/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;

public class Structure
implements Struct {
    private Object[] elements;
    private String typeName;
    private static char[] hexchar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Structure(Object[] objectArray, String string) {
        this.elements = objectArray;
        this.typeName = string;
    }

    public Object[] getAttributes() throws SQLException {
        return this.elements;
    }

    public String getSQLTypeName() throws SQLException {
        return this.typeName;
    }

    public Object[] getAttributes(Map map) throws SQLException {
        throw new SQLException("Feature not supported.");
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Object[] objectArray = null;
        if (object instanceof Struct) {
            try {
                objectArray = ((Struct)object).getAttributes();
            }
            catch (SQLException sQLException) {
                return false;
            }
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
        } else {
            return false;
        }
        if (this.elements.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("STRUCTURE (");
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i] instanceof byte[]) {
                printWriter.println("  FIELD[" + i + "]=" + this.toHex((byte[])this.elements[i]));
                continue;
            }
            printWriter.println("  FIELD[" + i + "]=" + this.elements[i]);
        }
        printWriter.println(")");
        return stringWriter.toString();
    }

    private String toHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer("x'");
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i];
            stringBuffer.append(hexchar[(n &= 0xFF) >> 4]);
            stringBuffer.append(hexchar[n % 4]);
        }
        stringBuffer.append("'");
        String string = new String(byArray);
        return stringBuffer.toString() + " (" + string + ")";
    }
}

