// Copyright (c) 2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
//
// MySQL Connector/NET is licensed under the terms of the GPLv2
// <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most 
// MySQL Connectors. There are special exceptions to the terms and 
// conditions of the GPLv2 as it is applied to this software, see the 
// FLOSS License Exception
// <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
//
// This program is free software; you can redistribute it and/or modify 
// it under the terms of the GNU General Public License as published 
// by the Free Software Foundation; version 2 of the License.
//
// This program is distributed in the hope that it will be useful, but 
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
// for more details.
//
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA

using System;
using System.Data;
using System.Threading;
using MySql.Data.MySqlClient;
using MySql.Data.MySqlClient.Tests;
using System.Data.EntityClient;
using System.Data.Common;
using NUnit.Framework;
using System.Data.Objects;
using MySql.Data.Entity.Tests.Properties;
using System.Linq;

namespace MySql.Data.Entity.Tests
{
    [TestFixture]
    public class RelationalOperators : BaseEdmTest
    {
        [Test]
        public void Except()
        {
/*            using (TestDB.TestDB db = new TestDB.TestDB())
            {
                var q = from c in db.Companies where 
                var query = from o in db.Orders
                            where o.StoreId = 3
                            select o;

                var result = query.First();
            }*/
        }

        [Test]
        public void Intersect()
        {
        }

        [Test]
        public void CrossJoin()
        {
        }

        [Test]
        public void Union()
        {
        }

        [Test]
        public void UnionAll()
        {
            using (testEntities context = new testEntities())
            {
                MySqlDataAdapter da = new MySqlDataAdapter(
                    "SELECT t.Id FROM Toys t UNION ALL SELECT c.Id FROM Companies c", conn);
                DataTable dt = new DataTable();
                da.Fill(dt);

                string entitySQL = @"(SELECT t.Id, t.Name FROM Toys AS t) 
                UNION ALL (SELECT c.Id, c.Name FROM Companies AS c)";
                ObjectQuery<DbDataRecord> query = context.CreateQuery<DbDataRecord>(entitySQL);

                string sql = query.ToTraceString();
                CheckSql(sql, SQLSyntax.UnionAll);

                int i = 0;
                foreach (DbDataRecord r in query)
                {
                    i++;
                }
                Assert.AreEqual(dt.Rows.Count, i);
            }
        }

        /// <summary>
        /// Bug #60652	Query returns BLOB type but no BLOBs are in the database.        
        /// </summary>
        [Test]
        public void UnionAllWithBitColumnsDoesNotThrow()
        {
            using (testEntities entities = new testEntities())
            {
                // Here, Computer is the base type of DesktopComputer, LaptopComputer and TabletComputer. 
                // LaptopComputer and TabletComputer include the bit fields that would provoke
                // an InvalidCastException (byte[] to bool) when participating in a UNION 
                // created internally by the Connector/Net entity framework provider.
                var computers = from c in entities.Computers
                                select c;

                foreach (Computer computer in computers)
                {
                    Assert.NotNull(computer);
                    Assert.IsTrue(computer.Id > 0);
                }
            }
        }
    }
}