/*
   Copyright 2007 - 2008 MySQL AB, 2008 - 2009 Sun Microsystems, Inc.  All rights reserved.

   The MySQL Connector/C++ is licensed under the terms of the GPL
   <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most
   MySQL Connectors. There are special exceptions to the terms and
   conditions of the GPL as it is applied to this software, see the
   FLOSS License Exception
   <http://www.mysql.com/about/legal/licensing/foss-exception.html>.
*/

#ifndef _MYSQL_CONNECTION_H_
#define _MYSQL_CONNECTION_H_

#include <cppconn/connection.h>
#include <boost/shared_ptr.hpp>

namespace sql
{
namespace mysql
{

class MySQL_Savepoint : public sql::Savepoint
{
	sql::SQLString name;

public:
	MySQL_Savepoint(const sql::SQLString &savepoint);
	virtual ~MySQL_Savepoint() {}

	int getSavepointId();

	sql::SQLString getSavepointName();

private:
	/* Prevent use of these */
	MySQL_Savepoint(const MySQL_Savepoint &);
	void operator=(MySQL_Savepoint &);
};


class MySQL_DebugLogger;
class MySQL_ConnectionData; /* PIMPL */

namespace NativeAPI
{
class NativeConnectionWrapper;
}

class CPPCONN_PUBLIC_FUNC MySQL_Connection : public sql::Connection
{
public:
	MySQL_Connection(const sql::SQLString& hostName, const sql::SQLString& userName, const sql::SQLString& password);

	MySQL_Connection(std::map< sql::SQLString, sql::ConnectPropertyVal > & options);

	virtual ~MySQL_Connection();

	void clearWarnings();

	void close();

	void commit();

	sql::Statement * createStatement();

	bool getAutoCommit();

	sql::SQLString getCatalog();

	sql::SQLString getSchema();

	sql::SQLString getClientInfo();

	void getClientOption(const sql::SQLString & optionName, void * optionValue);

	sql::DatabaseMetaData * getMetaData();

	enum_transaction_isolation getTransactionIsolation();

	const SQLWarning * getWarnings();

	bool isClosed();

	bool isReadOnly();

	sql::SQLString nativeSQL(const sql::SQLString& sql);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql, int autoGeneratedKeys);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql, int columnIndexes[]);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql, int resultSetType, int resultSetConcurrency);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability);

	sql::PreparedStatement * prepareStatement(const sql::SQLString& sql, sql::SQLString columnNames[]);

	void releaseSavepoint(Savepoint * savepoint) ;

	void rollback();

	void rollback(Savepoint * savepoint);

	void setAutoCommit(bool autoCommit);

	void setCatalog(const sql::SQLString& catalog);

	void setSchema(const sql::SQLString& catalog);

	sql::Connection * setClientOption(const sql::SQLString & optionName, const void * optionValue);

	void setHoldability(int holdability);

	void setReadOnly(bool readOnly);

	sql::Savepoint * setSavepoint();

	sql::Savepoint * setSavepoint(const sql::SQLString& name);

	void setTransactionIsolation(enum_transaction_isolation level);

	sql::SQLString getSessionVariable(const sql::SQLString & varname);

	void setSessionVariable(const sql::SQLString & varname, const sql::SQLString & value);

protected:
	void checkClosed();
	void init(std::map< sql::SQLString, sql::ConnectPropertyVal > & properties);

	MySQL_ConnectionData * intern; /* pimpl */

	boost::shared_ptr< NativeAPI::NativeConnectionWrapper > proxy;

private:
	/* Prevent use of these */
	MySQL_Connection(const MySQL_Connection &);
	void operator=(MySQL_Connection &);
};

} /* namespace mysql */
} /* namespace sql */

#endif // _MYSQL_CONNECTION_H_

/*
 * Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */
