// test_translations.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_public_interface.h"

char * filename_in1= "in1.xml";
char * filename_in2= "in2.xml";

struct Translation_case
{
  const char * text_group_id;
  const char * text_id;
  const char * defalt_text;
};

Translation_case names_to_translate[]=
{
  { "group1", "mysql_alloc", "default_text1" },
  { "group1", "login",       "default_text2" },
  { "group3", "text3",       "default_text3" },
  { "group4", "text4",       "default_text4" },
};

void print_usage()
{
  printf("usage : test_translations.exe <language>\n");
}

int main(int argc, char *argv[])
{
  if (argc < 2)
  {
    print_usage();
  }
  else
  {
    MYX_LIB_ERROR err;
    MYX_TRANS *trans= myx_init_trans(filename_in1,filename_in2,argv[1],&err);

    Translation_case *tcase= names_to_translate;
    Translation_case *end_case=
      names_to_translate + sizeof(names_to_translate)/sizeof(Translation_case);
    for (;tcase!=end_case; tcase++)
    {
      printf("myx_t(trans,\"%s\",\"%s\",\"%s\")=\"%s\"\n",
             tcase->text_group_id,tcase->text_id,tcase->defalt_text,
             myx_t(trans,tcase->text_group_id,
                   tcase->text_id,tcase->defalt_text));
      printf("myx_tg(trans,\"%s\",\"%s\",\"%s\")=\"%s\"\n",
             tcase->text_group_id,tcase->text_id,tcase->defalt_text,
             myx_tg(trans,tcase->text_group_id,
                    tcase->text_id,tcase->defalt_text));
    }

    myx_free_trans(trans);
  }
  return 0;
}

