// read_international.cpp : Defines the entry point for the console application.
//

#include "stdio.h"
#include "stdlib.h"
#include "myx_public_interface.h"

void print_usage()
{
  printf("usage : read_international.exe <filename> <charset>\n");
}

int main(int argc, char *argv[])
{
  if (argc<3)
  {
    print_usage();
  }
  else
  {
    MYX_LIB_ERROR err;
    const char * filename= argv[1];
    const char * charset= argv[2];
    bigint res;
    int bytes_read;

    MYX_INTL_FILE * ifile= myx_new_intl_file(filename,charset,&err);

    printf("<!-- result : \n-->");
    while ((res= myx_read_char_from_intl_file(ifile,&bytes_read,&err))!=-1)
      printf("&#%ld;<!-- length=%d \n-->",(long int)res,bytes_read);

    myx_free_intl_file(ifile);
  }
  return 0;
}

