unit Main;

interface

uses
  gnugettext, Windows, Messages, SysUtils, Variants, Classes, Graphics,
  Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, ImgList, Contnrs, Menus,
  ApplicationDataModule, MySQLConnection, AdditionalClasses,
  AdminServerInfo, AdminServiceControl, AdminUsers,
  AdminStartupVariables, AdminServerHealth, AdminServerConnections,
  AdminCatalog, AdminBackup, AdminServerLogs, AdminReplication,
  AdminRestore, ClipBrd,
  AuxFuncs, PNGImage, myx_public_interface, myx_admin_public_interface,
  Sections, Options, OptionsEditor, AdminOptionPages,
  CommonFuncs, TntForms, TntComCtrls, TntExtCtrls, TntMenus,
  MySQLCommonFuncs, AppInstanceMgmt;

{$include Consts.ini}

type
  TMainForm = class(TTntForm)
    StatusBar: TTntStatusBar;
    TopPnl: TTntPanel;
    Panel1: TTntPanel;
    Panel2: TTntPanel;
    MainMenu: TTntMainMenu;
    FileMI: TTntMenuItem;
    ConnecttoServerMI: TTntMenuItem;
    SaveConnectionMI: TTntMenuItem;
    N3: TTntMenuItem;
    CopyActivePageAsTextMI: TTntMenuItem;
    N2: TTntMenuItem;
    CloseMI: TTntMenuItem;
    Edit1: TTntMenuItem;
    CopyMI: TTntMenuItem;
    CutMI: TTntMenuItem;
    PasteMI: TTntMenuItem;
    HelpMI: TTntMenuItem;
    OnlineHelpMI: TTntMenuItem;
    N6: TTntMenuItem;
    ReportBugMI: TTntMenuItem;
    VisitMySQLcomMI: TTntMenuItem;
    N7: TTntMenuItem;
    AboutMI: TTntMenuItem;
    ManageConnectionsMI: TTntMenuItem;
    OptionsMI: TTntMenuItem;
    ToolsMI: TTntMenuItem;
    ViewMI: TTntMenuItem;
    MySQLCommandlineclientMI: TTntMenuItem;
    WindowsCommandLineMI: TTntMenuItem;
    ReconnectMI: TTntMenuItem;
    SelectAllMI: TTntMenuItem;
    MySQLQueryBrowserMI: TTntMenuItem;
    N1: TTntMenuItem;
    MySQLSystemTrayMonitorMI: TTntMenuItem;
    ListopenMySQLAdministratorBugsMI: TTntMenuItem;
    N5: TTntMenuItem;
    N9: TTntMenuItem;
    WindowMI: TTntMenuItem;
    N01: TTntMenuItem;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);

    procedure BuildSectionTree;
    procedure DoCurrentSectionChanged(Sender: TObject);
    function CreateSectionForm(AOwner: TComponent; SidebarSectionType: integer): TSectionForm;

    procedure ConnecttoServerMIClick(Sender: TObject);
    procedure CloseMIClick(Sender: TObject);

    procedure StatusBarDrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure StatusBarMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SaveConnectionMIClick(Sender: TObject);
    procedure PasteMIClick(Sender: TObject);
    procedure OptionsMIClick(Sender: TObject);
    procedure ManageConnectionsMIClick(Sender: TObject);
    procedure Disconnected(var Message: TMessage); message WM_Disconnected;
    procedure Reconnected(var Message: TMessage); message WM_Reconnected;

    procedure MySQLCommandlineclientMIClick(Sender: TObject);
    procedure WindowsCommandLineMIClick(Sender: TObject);
    procedure ReportBugMIClick(Sender: TObject);
    procedure VisitMySQLcomMIClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OnlineHelpMIClick(Sender: TObject);
    procedure AboutMIClick(Sender: TObject);
    procedure ReconnectMIClick(Sender: TObject);

    procedure HandleIdle(Sender: TObject; var Done: Boolean);
    procedure CutMIClick(Sender: TObject);
    procedure CopyMIClick(Sender: TObject);
    procedure SelectAllMIClick(Sender: TObject);

    procedure CopyActivePageAsTextMIClick(Sender: TObject);
    procedure MySQLQueryBrowserMIClick(Sender: TObject);
    procedure MySQLSystemTrayMonitorMIClick(Sender: TObject);
    procedure ListopenMySQLAdministratorBugsMIClick(Sender: TObject);

    procedure DoException(Sender: TObject; E: Exception);

    procedure WMInitMenuPopup(var MSG: TWMInitMenuPopup); message WM_INITMENUPOPUP;
    procedure MenuMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);
    procedure MenuDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; State: TOwnerDrawState);
  private
    CatalogSection, BackupRestoreSection,
    UserAdministrationSection: TSidebarSection;

    PNGThreadStop: TPNGObject;
  public
    MySQLConn: TMySQLConn;

    SectionControls: TSectionControls;
    procedure PrepareGUI();
  end;

const
    SSTAdmin_ServerInfo = 1;
    SSTAdmin_ServerConfig = 2;
    SSTAdmin_ServiceControl = 3;
    SSTAdmin_StartupVariables = 4;
    SSTAdmin_ServerConnections = 5;
    SSTAdmin_UserAdministration = 6;
    SSTAdmin_ServerHealth = 7;
    SSTAdmin_ServerLogs = 8;
    SSTAdmin_Backup = 9;
    SSTAdmin_Restore = 10;
    SSTAdmin_Replication = 11;
    SSTAdmin_Catalog = 12;

var
  MainForm: TMainForm;

implementation

uses
  About, PNGTools;

{$R *.dfm}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  InitForm(self);

  RegisterMySQLApplication(Application.Title,
    product_version, ExtractFilePath(Application.ExeName));

  MainMenu.AutoHotkeys:=maAutomatic;

  MySQLConn:=TMySQLConn.Create(StatusBar);

  PNGThreadStop:=LoadPNGImageFromResource('thread_stop', nil);

  if(Not(ApplicationDM.Options.RestoreWindowPos(self)))then
  begin
    if(Screen.Width>=1024)then
    begin
      if(Screen.Height>=1024)then
      begin
        Width:=900;
        Height:=720;
      end
      else
      begin
        Width:=900;
        Height:=680;
      end;

      //Align center (till position is stored)
      Left:=(Screen.Width+Width) div 2 - Width;
      Top:=(Screen.Height+Height) div 2 - Height;
    end
    else
    begin
      Width:=800;
      Height:=572;

      Left:=(Screen.Width+Width) div 2 - Width;
      Top:=0;

      WindowState:=wsMaximized;
    end;
  end;

  SectionControls:=TSectionControls.Create(self,
    CreateSectionForm,
    ViewMI,
    ApplicationDM.Options.SectionSidebarHidden,
    ApplicationDM.Options.SectionSidebarWidth,
    ApplicationDM.SectionImageList,
    11);


  Application.OnIdle:=HandleIdle;
  Application.OnException:=DoException;

end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  SectionControls.Free;

  ApplicationDM.Options.AddWindowPos(self);

  PNGThreadStop.Free;

  MySQLConn.Free;

  ApplicationDM.Free;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
var i: integer;
begin
  if(HiWord(GetKeyState(VK_CONTROL))<>0)then
    ConnecttoServerMIClick(self);

  ApplicationDM.ApplicationIsTerminating:=True;

  //Close all Sub-windows
  for i:=0 to SectionControls.SectionList.Count-1 do
    if(TSidebarSection(SectionControls.SectionList[i]).SectionForm<>nil)then
      TSidebarSection(SectionControls.SectionList[i]).SectionForm.Close;

  Action:=caFree;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  //
end;

procedure TMainForm.PrepareGUI();
begin
  //Set the Caption
  if(MySQLConn.GetConnectionCaption<>'')then
    Caption:=_('MySQL Administrator')+' - '+MySQLConn.GetConnectionCaption;

  //Build the Admin Tree
  BuildSectionTree;

  //Select first page
  if(ApplicationDM.Options.StartSection>0)and
    (ApplicationDM.Options.StartSection<=
      SectionControls.AdminTreeView.Items.Count)then
    SectionControls.AdminTreeView.Selected:=
      SectionControls.AdminTreeView.Items[
      ApplicationDM.Options.StartSection-1];

  //Enable Tools Menu Items
  MySQLQueryBrowserMI.Enabled:=(GetMySQLQueryBrowserCmd<>'');
  MySQLCommandlineclientMI.Enabled:=(GetMySQLCommandLineClientPath<>'')and(MySQLConn.user_connection<>nil);
  WindowsCommandLineMI.Enabled:=FileExists(GetSystemDir+'cmd.exe');
  MySQLSystemTrayMonitorMI.Enabled:=FileExists(
    ExtractFilePath(Application.ExeName)+'MySQLSystemTrayMonitor.exe');
end;

procedure TMainForm.ConnecttoServerMIClick(Sender: TObject);
begin
  CreateSubProcess(Application.ExeName, '');
end;

procedure TMainForm.CloseMIClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.StatusBarDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
begin
  if(Panel.Index=0)then
  begin
    if(MySQLConn.FetchingData)then
      PNGThreadStop.Draw(StatusBar.Canvas,
        Classes.Rect(Rect.Left+1, Rect.Top+1, Rect.Left+1+13, Rect.Top+1+13));
  end;
end;

procedure TMainForm.StatusBarMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if(X<20)and(MySQLConn.FetchingData)then
  begin
    MySQLConn.ClearWorkList;

    statusbar.Panels[1].Text:='';
    StatusBar.Invalidate;
  end;
end;

procedure TMainForm.OptionsMIClick(Sender: TObject);
var OptionsForm: TOptionsForm;
begin
  OptionsForm:=TOptionsForm.Create(self, TAdminOptionPagesForm.Create(self));
  try
    OptionsForm.ShowModal;
  finally
    OptionsForm.Free;
  end;
end;

procedure TMainForm.SaveConnectionMIClick(
  Sender: TObject);
var OptionsForm: TOptionsForm;
begin
  OptionsForm:=TOptionsForm.Create(self, TAdminOptionPagesForm.Create(self));
  try
    //Select Connections Page
    OptionsForm.ShowOptionPage(ConnectionsPage);
    
    OptionsForm.AddConnection(MySQLConn.user_connection);
    OptionsForm.ActiveControl:=OptionsForm.ConnectionEd;

    OptionsForm.ShowModal;
  finally
    OptionsForm.Free;
  end;
end;

procedure TMainForm.ManageConnectionsMIClick(Sender: TObject);
var OptionsForm: TOptionsForm;
begin
  OptionsForm:=TOptionsForm.Create(self, TAdminOptionPagesForm.Create(self));
  try
    //Select Connections Page
    OptionsForm.ShowOptionPage(ConnectionsPage);

    OptionsForm.ShowModal;
  finally
    OptionsForm.Free;
  end;
end;

procedure TMainForm.Disconnected(var Message: TMessage);
begin
  SectionControls.RefreshSidebarIcons(MySQLConn.Connected,
    MySQLConn.ConnectedToLocalhost);
end;

procedure TMainForm.Reconnected(var Message: TMessage);
begin
  SectionControls.RefreshSidebarIcons(MySQLConn.Connected,
    MySQLConn.ConnectedToLocalhost);
end;

procedure TMainForm.MySQLCommandlineclientMIClick(Sender: TObject);
var cmd: WideString;
begin
  cmd:=GetMySQLCommandLineClientPath;
  if(cmd<>'')and(MySQLConn.user_connection<>nil)then
    CreateSubProcess(cmd+' -h'+MySQLConn.user_connection.hostname+
      ' -u'+MySQLConn.user_connection.username+
      ' -p'+MySQLConn.user_connection.password+
      ' -P'+IntToStr(MySQLConn.user_connection.port), '');
end;

procedure TMainForm.WindowsCommandLineMIClick(Sender: TObject);
var cmd: WideString;
begin
  cmd:=GetSystemDir+'cmd.exe';
  if(FileExists(cmd))then
    CreateSubProcess(cmd, GetHomeDir);
end;

procedure TMainForm.ReportBugMIClick(Sender: TObject);
begin
  BrowseWebPage('http://bugs.mysql.com');
end;

procedure TMainForm.VisitMySQLcomMIClick(Sender: TObject);
begin
  BrowseWebPage('http://www.mysql.com');
end;

procedure TMainForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if(Key=VK_F1)then
    ShowHelp;
end;

procedure TMainForm.OnlineHelpMIClick(Sender: TObject);
begin
  ShowHelp;
end;

procedure TMainForm.AboutMIClick(Sender: TObject);
begin
  ShowAboutDialog('MySQL Administrator',
    product_version+' '+product_build_level,
    _('Michael G. Zinner, main concept, graphical design, '+
    'Windows development, library coding | '+
    'Alfredo Kengi Kojima, Linux development, library coding | '+
    'Ulrich Bayer, library coding, WIX | Victor Vagin, library coding, '+
    ' QA | '+
    'Brian Aker, conceptual design, supervising | '+
    'Stefan Hinz, documentation | '+
    'Mike Hillyer, documentation'));
end;

procedure TMainForm.BuildSectionTree;
begin
  SectionControls.AdminTreeView.Items.Clear;

  //Create all AdminTree nodes and attach the corresponding action

  if(Not(ApplicationDM.Options.ShowOnlyServiceSections))then
  begin
    //Create Server Information Section
    SectionControls.AddSection(_('Server Information'),
      TSidebarSection.Create(SSTAdmin_ServerInfo,
        0, 1, True, False));
  end;

  //Create Service Control Section
  SectionControls.AddSection(_('Service Control'),
    TSidebarSection.Create(SSTAdmin_ServiceControl,
      2, 3, False,
      Not(ApplicationDM.Options.ShowOnlyServiceSections),
      nil,
      ApplicationDM.Options.ShowOnlyServiceSections
      ));

  //Create Server Variables Section
  SectionControls.AddSection(_('Startup Variables'),
    TSidebarSection.Create(SSTAdmin_StartupVariables,
      4, 5, False,
      Not(ApplicationDM.Options.ShowOnlyServiceSections),
      nil,
      ApplicationDM.Options.ShowOnlyServiceSections
      ));

  if(Not(ApplicationDM.Options.ShowOnlyServiceSections))then
  begin
    //Create User Administration Section
    UserAdministrationSection:=
      TSidebarSection.Create(SSTAdmin_UserAdministration,
        8, 9, True, False,
        nil,
        True);
    SectionControls.AddSection(_('User Administration'),
      UserAdministrationSection);

    //Create Server Connections Section
    SectionControls.AddSection(_('Server Connections'),
      TSidebarSection.Create(SSTAdmin_ServerConnections,
        6, 7, True, False));

    //Create Health Section
    SectionControls.AddSection(_('Health'),
      TSidebarSection.Create(SSTAdmin_ServerHealth,
        10, 11, True, False));
  end;

  //Create Server Logs Section
  SectionControls.AddSection(_('Server Logs'),
    TSidebarSection.Create(SSTAdmin_ServerLogs,
      12, 13, False,
      Not(ApplicationDM.Options.ShowOnlyServiceSections),
      nil));

  if(Not(ApplicationDM.Options.ShowOnlyServiceSections))then
  begin
    //Create Replication Status Section
    SectionControls.AddSection(_('Replication Status'),
      TSidebarSection.Create(SSTAdmin_Replication,
        18, 19, True, False));

    //Create Backup Section
    BackupRestoreSection:=TSidebarSection.Create(SSTAdmin_Backup,
      14, 15, True, False,
      nil, True);
    SectionControls.AddSection(_('Backup'),
      BackupRestoreSection);

    //Create Restore Section
    SectionControls.AddSection(_('Restore'),
      TSidebarSection.Create(SSTAdmin_Restore,
        16, 17, True, False,
        nil, True));

    //Create Catalogs Section
    CatalogSection:=TSidebarSection.Create(SSTAdmin_Catalog,
      20, 21, True, False,
      nil, True);
    SectionControls.AddSection(_('Catalogs'),
      CatalogSection);
  end;

  SectionControls.RefreshSidebarIcons(MySQLConn.Connected,
    MySQLConn.ConnectedToLocalhost);

  if(ApplicationDM.Options.ShowOnlyServiceSections)then
    SaveConnectionMI.Enabled:=False;

  SectionControls.OnCurrentSectionChanged:=DoCurrentSectionChanged;
end;

procedure TMainForm.DoCurrentSectionChanged(Sender: TObject);
begin
  if(SectionControls.CurrentSidebarSection.SidebarSectionType=SSTAdmin_ServerInfo)then
    CopyActivePageAsTextMI.Enabled:=True;
end;


function TMainForm.CreateSectionForm(AOwner: TComponent;
  SidebarSectionType: integer): TSectionForm;
begin
  Result:=nil;

  case SidebarSectionType of
    SSTAdmin_ServerInfo:
      Result:=TAdminServerInfoForm.Create(AOwner,
            MySQLConn, StatusBar);
    SSTAdmin_ServiceControl:
      Result:=TAdminServiceControlForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_StartupVariables:
      Result:=TAdminStartupVariablesForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_ServerHealth:
      Result:=TAdminServerHealthForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_ServerConnections:
      Result:=TAdminServerConnectionsForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_UserAdministration:
      Result:=TAdminUsersForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_Catalog:
      Result:=TAdminCatalogForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_Backup:
      Result:=TAdminBackupForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_Restore:
      Result:=TAdminRestoreForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_ServerLogs:
      Result:=TAdminServerLogsForm.Create(AOwner,
          MySQLConn, StatusBar);
    SSTAdmin_replication:
      Result:=TAdminReplicationForm.Create(AOwner,
          MySQLConn, StatusBar);
  end;
end;

procedure TMainForm.ReconnectMIClick(Sender: TObject);
begin
  ConnecttoServerMIClick(self);

  Close;
end;

procedure TMainForm.HandleIdle(Sender: TObject; var Done: Boolean);
var Enable: Boolean;
begin
  if(ActiveControl is TCustomEdit)then
  begin
    Enable:=TCustomEdit(Self.ActiveControl).SelLength>0;
    CutMI.Enabled:=Enable;
    CopyMI.Enabled:=Enable;
    Enable:=Clipboard.HasFormat(CF_TEXT);
    PasteMI.Enabled:=Enable;
    SelectAllMI.Enabled:=Enable;
  end
  else
  begin
    CutMI.Enabled:=False;
    CopyMI.Enabled:=False;
    PasteMI.Enabled:=False;
  end;
end;


procedure TMainForm.CutMIClick(Sender: TObject);
begin
  SendMessage(ActiveControl.Handle, WM_Cut, 0, 0);
end;

procedure TMainForm.CopyMIClick(Sender: TObject);
begin
  SendMessage(ActiveControl.Handle, WM_COPY, 0, 0);
end;

procedure TMainForm.PasteMIClick(Sender: TObject);
begin
  SendMessage(ActiveControl.Handle, WM_Paste, 0, 0);
end;

procedure TMainForm.SelectAllMIClick(Sender: TObject);
begin
  if(ActiveControl is TCustomEdit)then
    TCustomEdit(ActiveControl).SelectAll;
end;

procedure TMainForm.CopyActivePageAsTextMIClick(Sender: TObject);
var s: WideString;
begin
  s:=SectionControls.CurrentSidebarSection.SectionForm.GetFormContentAsText;
  if(s<>'')then
  begin
    Clipboard.AsText:=s;
  end;
end;

procedure TMainForm.MySQLQueryBrowserMIClick(Sender: TObject);

  //---------------------------------------------------------------------------

  function ConvertToHex(const S: WideString): string;

  var
    Utf8String: string;
    
  begin
    Utf8String := Utf8Encode(S);
    SetLength(Result, 2 * Length(Utf8String));
    BinToHex(PChar(Utf8String), PChar(Result), Length(Utf8String));
  end;

  //---------------------------------------------------------------------------

var
  cmd: WideString;

begin
  cmd:=GetMySQLQueryBrowserCmd;

  if(MySQLConn.user_connection<>nil)then
  begin
    cmd := cmd + ' "-u' + MySQLConn.user_connection.username + '"';
    if MySQLConn.user_connection.password <> '' then
      cmd:=cmd + ' -x' + ConvertToHex(MySQLConn.user_connection.password);
    cmd:=cmd+' "-h'+MySQLConn.user_connection.hostname+'"';
    cmd:=cmd+' "-P'+IntToStr(MySQLConn.user_connection.port)+'"';
  end;

  CreateSubProcess(cmd, '');
end;

procedure TMainForm.MySQLSystemTrayMonitorMIClick(Sender: TObject);
begin
  CreateSubProcess(ExtractFilePath(Application.ExeName) + 'MySQLSystemTrayMonitor.exe', '');
end;

procedure TMainForm.ListopenMySQLAdministratorBugsMIClick(Sender: TObject);
begin
  BrowseWebPage('http://bugs.mysql.com/search.php?search_for=&limit=All&order_by=&direction=ASC&cmd=display&status=Active&severity=&showstopper=&bug_type=MySQL+Administrator&php_os=&phpver=&assign=&bug_age=0');
end;

procedure TMainForm.DoException(Sender: TObject; E: Exception);
begin
  ShowModalDialog(Application.Title+' '+_('Exception'),
    E.Message, myx_mtError, _('OK'));
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.WMInitMenuPopup(var MSG: TWMInitMenuPopup);

begin
  if (Msg.MenuPopup = WindowMI.Handle) then
    BuildRegisterApplicationMenuItems(WindowMI);

  inherited;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MenuMeasureItem(Sender: TObject; ACanvas: TCanvas; var Width, Height: Integer);

var
  Size: TSize;
  Item: TTntMenuItem;

begin
  if Sender is TTntMenuItem then
  begin
    Item := Sender as TTntMenuItem;
    ACanvas.Font := Font;

    if Item.IsLine then
    begin
      Width := 10; // This will actually have no effect, because other entries are much wider.
      Height := 6;
    end
    else
    begin
      GetTextExtentPoint32W(ACanvas.Handle, PWideChar(Item.Caption), Length(Item.Caption), Size);

      // Border around each entry.
      if (Item.Parent.Parent = nil) and not (Item.GetParentMenu is TPopupMenu) then
        Width := Size.cx
      else
        Width := Size.cx + 4;
      Height := Size.cy + 6;
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

procedure TMainForm.MenuDrawItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; State: TOwnerDrawState);

var
  Item: TTntMenuItem;

begin
  if Sender is TTntMenuItem then
  begin
    Item := Sender as TTntMenuItem;
    ACanvas.Font := Font;

    if Item.IsLine then
    begin
      // A menu separator.
      ACanvas.Pen.Color := clBtnShadow;
      ACanvas.MoveTo(ARect.Left + 2, (ARect.Bottom + ARect.Top) div 2);
      ACanvas.LineTo(ARect.Right - 2, (ARect.Bottom + ARect.Top) div 2);
    end
    else
    begin
      // Top level items have an invisible parent, so have to check the parent of the parent.
      if (Item.Parent.Parent = nil) and not (Item.GetParentMenu is TPopupMenu) then
      begin
        if [odHotLight, odSelected] * State <> [] then
          ACanvas.Brush.Color := clHighlight
        else
          ACanvas.Brush.Color := clBtnFace;
      end;
      ACanvas.FillRect(ARect);
      Inc(ARect.Left, 8);
      SetBKMode(ACanvas.Handle, TRANSPARENT);
      Windows.DrawTextW(ACanvas.Handle, PWideChar(Item.Caption), Length(Item.Caption), ARect, DT_LEFT + DT_SINGLELINE +
        DT_HIDEPREFIX + DT_VCENTER);
    end;
  end;
end;

//----------------------------------------------------------------------------------------------------------------------

end.
