from typing import List, Any, TypeVar, Type, Iterable, Iterator

_T = TypeVar('_T', bound=Enum)
class EnumMeta(type, Iterable[Enum]):
    def __iter__(self: Type[_T]) -> Iterator[_T]: ...  # type: ignore

class Enum(metaclass=EnumMeta):
    def __new__(cls: Type[_T], value: Any) -> _T: ...
    def __repr__(self) -> str: ...
    def __str__(self) -> str: ...
    def __dir__(self) -> List[str]: ...
    def __format__(self, format_spec: str) -> str: ...
    def __hash__(self) -> Any: ...
    def __reduce_ex__(self, proto: Any) -> Any: ...

    name = ...  # type: str
    value = ...  # type: Any

class IntEnum(int, Enum): ...

def unique(enumeration: _T) -> _T: ...
