# Stubs for array

# Based on http://docs.python.org/3.2/library/array.html

from typing import (Any, BinaryIO, Generic, Iterable, Iterator, List, MutableSequence,
                    overload, Text, Tuple, TypeVar, Union)

_T = TypeVar('_T', int, float, Text)

typecodes = ...  # type: str

class array(MutableSequence[_T], Generic[_T]):
    typecode = ...  # type: str
    itemsize = ...  # type: int
    def __init__(self, typecode: str,
                 __initializer: Union[bytes, Iterable[_T]] = ...) -> None: ...
    def append(self, x: _T) -> None: ...
    def buffer_info(self) -> Tuple[int, int]: ...
    def byteswap(self) -> None: ...
    def count(self, x: Any) -> int: ...
    def extend(self, iterable: Iterable[_T]) -> None: ...
    def frombytes(self, s: bytes) -> None: ...
    def fromfile(self, f: BinaryIO, n: int) -> None: ...
    def fromlist(self, list: List[_T]) -> None: ...
    def fromstring(self, s: bytes) -> None: ...
    def fromunicode(self, s: str) -> None: ...
    def index(self, x: _T) -> int: ...  # type: ignore  # Overrides Sequence
    def insert(self, i: int, x: _T) -> None: ...
    def pop(self, i: int = ...) -> _T: ...
    def remove(self, x: Any) -> None: ...
    def reverse(self) -> None: ...
    def tobytes(self) -> bytes: ...
    def tofile(self, f: BinaryIO) -> None: ...
    def tolist(self) -> List[_T]: ...
    def tostring(self) -> bytes: ...
    def tounicode(self) -> str: ...

    def __len__(self) -> int: ...

    @overload
    def __getitem__(self, i: int) -> _T: ...
    @overload
    def __getitem__(self, s: slice) -> array[_T]: ...

    @overload  # type: ignore  # Overrides MutableSequence
    def __setitem__(self, i: int, o: _T) -> None: ...
    @overload
    def __setitem__(self, s: slice, o: array[_T]) -> None: ...

    def __delitem__(self, i: Union[int, slice]) -> None: ...
    def __add__(self, x: array[_T]) -> array[_T]: ...
    def __ge__(self, other: array[_T]) -> bool: ...
    def __gt__(self, other: array[_T]) -> bool: ...
    def __iadd__(self, x: array[_T]) -> array[_T]: ...  # type: ignore  # Overrides MutableSequence
    def __imul__(self, n: int) -> array[_T]: ...
    def __le__(self, other: array[_T]) -> bool: ...
    def __lt__(self, other: array[_T]) -> bool: ...
    def __mul__(self, n: int) -> array[_T]: ...
    def __rmul__(self, n: int) -> array[_T]: ...
