# Stubs for logging (Python 2.7)
#
# NOTE: This dynamically typed stub was automatically generated by stubgen.

from typing import Any, Dict, Optional, Sequence, Tuple, overload, Union

CRITICAL = 0
FATAL = 0
ERROR = 0
WARNING = 0
WARN = 0
INFO = 0
DEBUG = 0
NOTSET = 0

def getLevelName(level: int) -> str: ...
def addLevelName(level: int, levelName: str) -> None: ...

class LogRecord:
    name = ...  # type: str
    msg = ...  # type: str
    args = ...  # type: Sequence[Any]
    levelname = ...  # type: str
    levelno = ...  # type: int
    pathname = ...  # type: str
    filename = ...  # type: str
    module = ...  # type: str
    exc_info = ...  # type: Tuple[Any, Any, Any]
    exc_text = ...  # type: str
    lineno = ...  # type: int
    funcName = ...  # type: Optional[str]
    created = ...  # type: float
    msecs = ...  # type: float
    relativeCreated = ...  # type: float
    thread = ...  # type: Any
    threadName = ...  # type: Any
    processName = ...  # type: Any
    process = ...  # type: Any
    def __init__(self, name: str, level: int, pathname: str, lineno: int, msg: str,
                 args: Sequence[Any], exc_info: Tuple[Any, Any, Any], func: str = ...) -> None: ...
    def getMessage(self) -> str: ...

def makeLogRecord(dict: Dict[str, Any]) -> LogRecord: ...

class PercentStyle:
    default_format = ...  # type: Any
    asctime_format = ...  # type: Any
    asctime_search = ...  # type: Any
    def __init__(self, fmt) -> None: ...
    def usesTime(self): ...
    def format(self, record): ...

class StrFormatStyle(PercentStyle):
    default_format = ...  # type: Any
    asctime_format = ...  # type: Any
    asctime_search = ...  # type: Any
    def format(self, record): ...

class StringTemplateStyle(PercentStyle):
    default_format = ...  # type: Any
    asctime_format = ...  # type: Any
    asctime_search = ...  # type: Any
    def __init__(self, fmt) -> None: ...
    def usesTime(self): ...
    def format(self, record): ...

BASIC_FORMAT = ...  # type: Any

class Formatter:
    converter = ...  # type: Any
    datefmt = ...  # type: Any
    def __init__(self, fmt: str = ..., datefmt: str = ...) -> None: ...
    default_time_format = ...  # type: Any
    default_msec_format = ...  # type: Any
    def formatTime(self, record, datefmt=...): ...
    def formatException(self, ei): ...
    def usesTime(self): ...
    def formatMessage(self, record): ...
    def formatStack(self, stack_info): ...
    def format(self, record: LogRecord) -> str: ...

class BufferingFormatter:
    linefmt = ...  # type: Any
    def __init__(self, linefmt=...) -> None: ...
    def formatHeader(self, records): ...
    def formatFooter(self, records): ...
    def format(self, records): ...

class Filter:
    name = ...  # type: Any
    nlen = ...  # type: Any
    def __init__(self, name: str = ...) -> None: ...
    def filter(self, record: LogRecord) -> int: ...

class Filterer:
    filters = ...  # type: Any
    def __init__(self) -> None: ...
    def addFilter(self, filter: Filter) -> None: ...
    def removeFilter(self, filter: Filter) -> None: ...
    def filter(self, record: LogRecord) -> int: ...

class Handler(Filterer):
    level = ...  # type: Any
    formatter = ...  # type: Any
    def __init__(self, level: int = ...) -> None: ...
    def get_name(self): ...
    def set_name(self, name): ...
    name = ...  # type: Any
    lock = ...  # type: Any
    def createLock(self): ...
    def acquire(self): ...
    def release(self): ...
    def setLevel(self, level: int) -> None: ...
    def format(self, record: LogRecord) -> str: ...
    def emit(self, record: LogRecord) -> None: ...
    def handle(self, record: LogRecord) -> Any: ... # Return value undocumented
    def setFormatter(self, fmt: Formatter) -> None: ...
    def flush(self) -> None: ...
    def close(self) -> None: ...
    def handleError(self, record: LogRecord) -> None: ...

class StreamHandler(Handler):
    terminator = ...  # type: Any
    stream = ...  # type: Any
    def __init__(self, stream=...) -> None: ...
    def flush(self): ...
    def emit(self, record): ...

class FileHandler(StreamHandler):
    baseFilename = ...  # type: Any
    mode = ...  # type: Any
    encoding = ...  # type: Any
    delay = ...  # type: Any
    stream = ...  # type: Any
    def __init__(self, filename: str, mode: str = ..., encoding: str = ..., delay: int = ...) -> None: ...
    def close(self): ...
    def emit(self, record): ...

class _StderrHandler(StreamHandler):
    def __init__(self, level=...) -> None: ...

lastResort = ...  # type: Any

class PlaceHolder:
    loggerMap = ...  # type: Any
    def __init__(self, alogger) -> None: ...
    def append(self, alogger): ...

def setLoggerClass(klass): ...
def getLoggerClass(): ...

class Manager:
    root = ...  # type: Any
    disable = ...  # type: Any
    emittedNoHandlerWarning = ...  # type: Any
    loggerDict = ...  # type: Any
    loggerClass = ...  # type: Any
    logRecordFactory = ...  # type: Any
    def __init__(self, rootnode) -> None: ...
    def getLogger(self, name): ...
    def setLoggerClass(self, klass): ...
    def setLogRecordFactory(self, factory): ...

class Logger(Filterer):
    name = ...  # type: Any
    level = ...  # type: Any
    parent = ...  # type: Any
    propagate = False
    handlers = ...  # type: Any
    disabled = ...  # type: Any
    def __init__(self, name: str, level: int = ...) -> None: ...
    def setLevel(self, level: int) -> None: ...
    def debug(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def info(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def warning(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def warn(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def error(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def exception(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def critical(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    fatal = ...  # type: Any
    def log(self, level: int, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def findCaller(self) -> Tuple[str, int, str]: ...
    def makeRecord(self, name, level, fn, lno, msg, args, exc_info, func=..., extra=...,
                   sinfo=...): ...
    def handle(self, record): ...
    def addHandler(self, hdlr: Handler) -> None: ...
    def removeHandler(self, hdlr: Handler) -> None: ...
    def hasHandlers(self): ...
    def callHandlers(self, record): ...
    def getEffectiveLevel(self) -> int: ...
    def isEnabledFor(self, level: int) -> bool: ...
    def getChild(self, suffix: str) -> Logger: ...

class RootLogger(Logger):
    def __init__(self, level) -> None: ...

class LoggerAdapter:
    logger = ...  # type: Any
    extra = ...  # type: Any
    def __init__(self, logger, extra) -> None: ...
    def process(self, msg, kwargs): ...
    def debug(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def info(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def warning(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def warn(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def error(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def exception(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def critical(self, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def log(self, level: int, msg: Union[str, unicode], *args, **kwargs) -> None: ...
    def isEnabledFor(self, level: int) -> bool: ...
    def setLevel(self, level: int) -> None: ...
    def getEffectiveLevel(self) -> int: ...
    def hasHandlers(self): ...

def basicConfig(**kwargs) -> None: ...
def getLogger(name: str = ...) -> Logger: ...
def critical(msg: str, *args, **kwargs) -> None: ...

fatal = ...  # type: Any

def error(msg: Union[str, unicode], *args, **kwargs) -> None: ...
@overload
def exception(msg: Union[str, unicode], *args, **kwargs) -> None: ...
@overload
def exception(exception: Exception, *args, **kwargs) -> None: ...
def warning(msg: Union[str, unicode], *args, **kwargs) -> None: ...
def warn(msg: Union[str, unicode], *args, **kwargs) -> None: ...
def info(msg: Union[str, unicode], *args, **kwargs) -> None: ...
def debug(msg: Union[str, unicode], *args, **kwargs) -> None: ...
def log(level: int, msg: Union[str, unicode], *args, **kwargs) -> None: ...
def disable(level: int) -> None: ...

class NullHandler(Handler):
    def handle(self, record): ...
    def emit(self, record): ...
    lock = ...  # type: Any
    def createLock(self): ...

def captureWarnings(capture: bool) -> None: ...
