# Stubs for warnings

# Based on http://docs.python.org/3.2/library/warnings.html

from typing import Any, List, TextIO, Union

def warn(message: Union[str, Warning], category: type = ...,
         stacklevel: int = ...) -> None: ...

def warn_explicit(message: Union[str, Warning], category: type, filename: str,
                  lineno: int, module: str = ..., registry: Any = ...,
                  module_globals: Any = ...) -> None: ...

# logging modifies showwarning => make it a variable.
def _showwarning(message: str, category: type, filename: str, lineno: int,
                 file: TextIO = ..., line: str = ...) -> None: ...
showwarning = _showwarning

def formatwarning(message: str, category: type, filename: str, lineno: int,
                  line: str = ...) -> None: ...
def filterwarnings(action: str, message: str = ..., category: type = ...,
                   module: str = ..., lineno: int = ...,
                   append: bool = ...) -> None: ...
def simplefilter(action: str, category: type = ..., lineno: int = ...,
                 append: bool = ...) -> None: ...
def resetwarnings() -> None: ...

class catch_warnings:
    # TODO record and module must be keyword arguments!
    # TODO type of module?
    def __init__(self, record: bool = ..., module: Any = ...) -> None: ...
    def __enter__(self) -> List[Any]: ...
    def __exit__(self, type, value, traceback) -> bool: ...
