
from urllib import addinfourl

class URLError(IOError): ...

class HTTPError(URLError, addinfourl): ...

class Request(object):
    host = ... # type: str
    port = ... # type: str
    data = ... # type: str
    headers = ... # type: Dict[str, str]
    unverifiable = ... # type: bool
    type = ...
    origin_req_host= ...
    unredirected_hdrs = ...

    def __init__(self, url: str, data: str, headers: Dict[str, str],
                 origin_req_host: str, unverifiable: bool) -> None: ...
    def __getattr__(self, attr): ...
    def get_method(self) -> str: ...
    def add_data(self, data) -> None: ...
    def has_data(self) -> bool: ...
    def get_data(self) -> str: ...
    def get_full_url(self) -> str: ...
    def get_type(self): ...
    def get_host(self) -> str: ...
    def get_selector(self): ...
    def set_proxy(self, host, type)-> None: ...
    def has_proxy(self) -> bool: ...
    def get_origin_req_host(self) -> str: ...
    def is_unverifiable(self) -> bool: ...
    def add_header(self, key: str, val: str) -> None: ...
    def add_unredirected_header(self, key: str, val: str) -> None: ...
    def has_header(self, header_name: str) -> bool: ...
    def get_header(self, header_name: str, default: str) -> str: ...
    def header_items(self): ...

class OpenerDirector(object): ...

def urlopen(url, data, timeout): ...
def install_opener(opener): ...
def build_opener(*handlers): ...

class BaseHandler:
    handler_order = ... # int

    def add_parent(self, parent) -> None: ...
    def close(self) -> None: ...
    def __lt__(self, other) -> bool: ...

class HTTPErrorProcessor(BaseHandler):
    def http_response(self, request, response): ...

class HTTPDefaultErrorHandler(BaseHandler):
    def http_error_default(self, req, fp, code, msg, hdrs): ...

class HTTPRedirectHandler(BaseHandler):
    max_repeats = ... # int
    max_redirections = ... # int
    def redirect_request(self, req, fp, code, msg, headers, newurl): ...
    def http_error_302(self, req, fp, code, msg, headers): ...
    http_error_301 = http_error_303 = http_error_307 = http_error_302
    inf_msg = ... # type: str


class ProxyHandler(BaseHandler):
    def __init__(self, proxies): ...
    def proxy_open(self, req, proxy, type): ...

class HTTPPasswordMgr:
    def __init__(self) -> None: ...
    def add_password(self, realm, uri, user, passwd): ...
    def find_user_password(self, realm, authuri): ...
    def reduce_uri(self, uri, default_port: bool): ...
    def is_suburi(self, base, test): ...

class HTTPPasswordMgrWithDefaultRealm(HTTPPasswordMgr): ...

class AbstractBasicAuthHandler:
    def __init__(self, password_mgr): ...
    def reset_retry_count(self): ...
    def http_error_auth_reqed(self, authreq, host, req, headers): ...
    def retry_http_basic_auth(self, host, req, realm): ...

class HTTPBasicAuthHandler(AbstractBasicAuthHandler, BaseHandler):
    auth_header = ... # type: str
    def http_error_401(self, req, fp, code, msg, headers): ...

class ProxyBasicAuthHandler(AbstractBasicAuthHandler, BaseHandler):
    auth_header = ... # type: str
    def http_error_407(self, req, fp, code, msg, headers): ...

class AbstractDigestAuthHandler:
    def __init__(self, passwd): ...
    def reset_retry_count(self): ...
    def http_error_auth_reqed(self, auth_header, host, req, headers): ...
    def retry_http_digest_auth(self, req, auth): ...
    def get_cnonce(self, nonce): ...
    def get_authorization(self, req, chal): ...
    def get_algorithm_impls(self, algorithm): ...
    def get_entity_digest(self, data, chal): ...

class HTTPDigestAuthHandler(BaseHandler, AbstractDigestAuthHandler):
    auth_header = ... # str
    handler_order = ... # int
    def http_error_401(self, req, fp, code, msg, headers): ...

class ProxyDigestAuthHandler(BaseHandler, AbstractDigestAuthHandler):
    auth_header = ... # str
    handler_order = ... # int
    def http_error_407(self, req, fp, code, msg, headers): ...

class AbstractHTTPHandler(BaseHandler):
    def __init__(self, debuglevel: int) -> None: ...
    def do_request_(self, request): ...
    def do_open(self, http_class, req): ...

class HTTPHandler(AbstractHTTPHandler):
    def http_open(self, req): ...
    http_request = AbstractHTTPHandler.do_request_

class HTTPSHandler(AbstractHTTPHandler):
    def https_open(self, req): ...
    https_request = AbstractHTTPHandler.do_request_

class HTTPCookieProcessor(BaseHandler):
    def __init__(self, cookiejar): ...
    def http_request(self, request): ...
    def http_response(self, request, response): ...

class UnknownHandler(BaseHandler):
    def unknown_open(self, req): ...

class FileHandler(BaseHandler):
    def file_open(self, req): ...
    def get_names(self): ...
    def open_local_file(self, req): ...

class FTPHandler(BaseHandler):
    def ftp_open(self, req): ...
    def connect_ftp(self, user, passwd, host, port, dirs, timeout): ...

class CacheFTPHandler(FTPHandler):
    def __init__(self): ...
    def setTimeout(self, t): ...
    def setMaxConns(self, m): ...
    def check_cache(self): ...
    def clear_cache(self): ...
