<?php
/**
 * $Id: camembert.php,v 1.9 2003/03/26 08:31:43 courou Exp $
 *
 * Author     : courou&#64;users.sourceforge.net
 * Website    : http://allreponse.ath.cx
 *
 * Support    : http://sourceforge.net/projects/myphpmoney/
 * CVS        : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/myphpmoney/
 *
 * Usage example :
 *
 *      $ChartDiameter = 150;
 *      $ChartFont     = 2;
 *      $ChartData     = array('2.66', '97.34');
 *      $ChartLabel    = array('Intrts', 'Capital');
 *
 */

if (!defined('__DOC__')) { define('__DOC__', 'YES');

/**
 * INCLUDE FILE
 */
     require_once '../config/settings.inc.php';

/**
 * ENTER IN THE SESSION OR BUILD THE LOGIN FORM
 */
     if (SQL_VerifSession()) {

## Define variable
if (isset($_GET['ChartDiameter']) && $_GET['ChartDiameter'] != '') $ChartDiameter = $_GET['ChartDiameter'];
if (isset($_GET['ChartFont']) && $_GET['ChartFont'] != '')         $ChartFont     = $_GET['ChartFont'];
if (isset($_GET['height']) && $_GET['height'] != '')               $height        = $_GET['height'];
if (isset($_GET['width']) && $_GET['width'] != '')                 $width         = $_GET['width'];
if (isset($_GET['ChartLabel']) && $_GET['ChartLabel'] != '')       $ChartLabel    = $_GET['ChartLabel'];
if (isset($_GET['ChartData']) && $_GET['ChartData'] != '')         $ChartData     = $_GET['ChartData'];

// Convertir les degrs en radians
// @param $degrees    = les degres
function radians($degrees) {
 return($degrees * (pi()/180.0));
}

// prendre x,y dans le cercle, centre = 0,0
// @param $degrees    = les degres
// @param diameter    = le diametre
function circles($degrees, $diameter) {
   $x = cos(radians($degrees)) * ($diameter/2);
   $y = sin(radians($degrees)) * ($diameter/2);
 return (array($x, $y));
}

## le font utiliser
$ChartFontHeight = imagefontheight($ChartFont);

## dterminer la taille du graphique
$ChartWidth = $width;
$ChartHeight = $height;

## dtermine le total de toutes les valeurs
$ChartTotal = '';
for($index = 0; $index < count($ChartData); $index++){
   ## Modification courou le 26/11/2002 -- Fix bug if value is -
   $ChartTotal += str_replace('-','',$ChartData[$index]);
}

$ChartCenterX = $ChartDiameter/2 + 20;
$ChartCenterY = $ChartDiameter/2 + 10;

## image
$image = imagecreate($ChartWidth, $ChartHeight);

## couleurs
$colorBody      = imagecolorallocate($image, 0xFF, 0xFF, 0xFF);
$colorBorder    = imagecolorallocate($image, 0xFF, 0xFF, 0xFF);
$colorText      = imagecolorallocate($image, 0x63, 0x51, 0x52);

## 12 couleur maxi
$colorSlice[]   = imagecolorallocate($image, 0xFF, 0x00, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0x00, 0xFF);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0xFF, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0xFF, 0xFF, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0xFF, 0x00, 0xFF);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0xFF, 0xFF);
$colorSlice[]   = imagecolorallocate($image, 0x99, 0x00, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0x99, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0x00, 0x99);
$colorSlice[]   = imagecolorallocate($image, 0x99, 0x99, 0x00);
$colorSlice[]   = imagecolorallocate($image, 0x99, 0x00, 0x99);
$colorSlice[]   = imagecolorallocate($image, 0x00, 0x99, 0x99);

## arrire-plan
imagefill($image, 0, 0, $colorBody);

## Dessiner chaque portion
$Degrees = '';

for($index = 0; $index < count($ChartData); $index++) {
   $StartDegrees = round($Degrees);

   ## Modification courou le 18/03/2002 -- Autorise les valeurs nuls
   $EndDegrees = round(
                        ($ChartTotal == 0)
                           ? $Degrees += 360
                           : $Degrees += ((str_replace('-','',$ChartData[$index])/$ChartTotal)*360)
                      );

   ## Modification courou le 02/11/2002 -- Fix bug if value is 99.9% and 0.1 %
   if ($ChartData[$index] == '0.1') $EndDegrees = $EndDegrees - 2;

   $CurrentColor = $colorSlice[$index%(count($colorSlice))];

        ## Dessiner un arc
        imagearc
        (
               $image,
               $ChartCenterX,
               $ChartCenterY,
               $ChartDiameter,
               $ChartDiameter,
               $StartDegrees,
               $EndDegrees,
               $CurrentColor
        );

        ## Tracer le dbut de la ligne  partir du centre
        list($ArcX, $ArcY) = circles($StartDegrees, $ChartDiameter);
        imageline
        (
               $image,
               $ChartCenterX,
               $ChartCenterY,
               floor($ChartCenterX + $ArcX),
               floor($ChartCenterY + $ArcY),
               $CurrentColor
        );

       ## Dessiner la fin de la ligne
        list($ArcX, $ArcY) = circles($EndDegrees, $ChartDiameter);
        imageline
        (
               $image,
               $ChartCenterX,
               $ChartCenterY,
               ceil($ChartCenterX + $ArcX),
               ceil($ChartCenterY + $ArcY),
               $CurrentColor
        );

        ## remplir les portions
        $MidPoint = round((($EndDegrees - $StartDegrees)/2) +  $StartDegrees);
        list($ArcX, $ArcY) = circles($MidPoint, $ChartDiameter/2);
        imagefilltoborder
        (
               $image,
               floor($ChartCenterX + $ArcX),
               floor($ChartCenterY + $ArcY),
               $CurrentColor,
               $CurrentColor
        );
        imagestring
        (
               $image,
               $ChartFont,
               floor($ChartCenterX + $ArcX) - 10,
               floor($ChartCenterY + $ArcY) - 5,
               str_replace('-','',$ChartData[$index]).' %',
               $colorText
        );
}

   ## la lgende
   for ($index = 0; $index < count($ChartData); $index++) {
     $CurrentColor = $colorSlice[$index%(count($colorSlice))];
     $LineY = $ChartDiameter + 25 +  ($index*($ChartFontHeight+2));

     ## la couleur des botes
     imagerectangle($image,29,$LineY,29 + $ChartFontHeight,$LineY+$ChartFontHeight,$colorBorder);
     imagefilltoborder($image,30,$LineY + 2,$colorBorder,$CurrentColor);

     ## Les titres
     imagestring
     (
               $image,
               $ChartFont,
               39 + $ChartFontHeight,
               $LineY,
               "$ChartLabel[$index]: $ChartData[$index] %",
               $colorText
     );
   } ## end of for ($index = 0 ...

     ## afficher l'image
     header('Content-type: image/png');
     imagepng($image);
     imagedestroy($image);

     } ## end if (SQL_VerifSession())

/**
 * CLOSE THE SESSION
 */
       page_close();

  } ## end of __DOC__
