<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["documentid"]) || !is_numeric($_GET["documentid"]) || intval($_GET["documentid"])<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$documentid = $_GET["documentid"];
$document = getDocument($documentid);
if (!is_object($document)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_doc_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_doc_id"));
	UI::htmlEndPage();
	exit;
}
$oldFolder = $document->getFolder();

if (!isset($_GET["targetid"]) || !is_numeric($_GET["targetid"]) || $_GET["targetid"]<1) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_target_folder"))));
	UI::globalNavigation($oldFolder);
	UI::pageNavigation(getMLText("invalid_target_folder"), "view_document");
	UI::htmlEndPage();
	exit;
}
$targetid = $_GET["targetid"];
$targetFolder = getFolder($targetid);
if (!is_object($targetFolder)) {
	UI::htmlStartPage(getMLText("document_title", array("documentname" => getMLText("invalid_target_folder"))));
	UI::globalNavigation($oldFolder);
	UI::pageNavigation(getMLText("invalid_target_folder"), "view_document");
	UI::htmlEndPage();
	exit;
}

if (($document->getAccessMode($user) < M_READWRITE) || ($targetFolder->getAccessMode($user) < M_READWRITE)) {
	$docPathHTML = getFolderPathHTML($oldFolder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
	UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
	UI::globalNavigation($oldFolder);
	UI::pageNavigation($docPathHTML, "view_document");
	UI::contentHeading(getMLText("move_document") . ": " . $document->getName());
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

$docPathHTML = getFolderPathHTML($targetFolder, true). " / <a href=\"../out/out.ViewDocument.php?documentid=".$documentid."\">".$document->getName()."</a>";
UI::htmlStartPage(getMLText("document_title", array("documentname" => $document->getName())));
UI::globalNavigation($targetFolder);
UI::pageNavigation($docPathHTML, "view_document");


UI::contentHeading(getMLText("move_document"));
UI::contentContainerStart();
printMLText("moving_document");
if ($targetid == $oldFolder->getID()) {
	printMLText("no_action");
	UI::contentContainerEnd();
	UI::htmlEndPage();
	exit;
}

if ($document->setFolder($targetFolder)) {
	printMLText("op_finished");
}
else {
	printMLText("error_occured");
}

print "<p>".getMLText("goto")." ".getMLText("old_folder").": <a href=\"../out/out.ViewFolder.php?folderid=".$oldFolder->getID()."\">".$oldFolder->getName(). "</a></p>";

UI::contentContainerEnd();
UI::htmlEndPage();
?>
