<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["action"]) || (strcasecmp($_GET["action"], "delnotify") && strcasecmp($_GET["action"], "addnotify"))) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_action"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_action"));
	UI::htmlEndPage();
	exit;
}
$action = $_GET["action"];

if (isset($_GET["userid"]) && (!is_numeric($_GET["userid"]) || $_GET["userid"]<-1)) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("unknown_user"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("unknown_user"));
	UI::htmlEndPage();
	exit;
}
$userid = $_GET["userid"];

if (isset($_GET["groupid"]) && (!is_numeric($_GET["groupid"]) || $_GET["groupid"]<-1)) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("unknown_group"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("unknown_group"));
	UI::htmlEndPage();
	exit;
}
$groupid = $_GET["groupid"];

if (!isset($_GET["folderid"]) || !is_numeric($_GET["folderid"]) || intval($_GET["folderid"])<1) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}
$folderid = $_GET["folderid"];
$folder = getFolder($folderid);
if (!is_object($folder)) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}

$folderPathHTML = getFolderPathHTML($folder, true);
UI::htmlStartPage(getMLText("folder_title", array("foldername" => $folder->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($folderPathHTML, "view_folder", $folder);

if ($folder->getAccessMode($user) < M_READ) {
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

UI::contentHeading(getMLText("edit_folder_notify"));
UI::contentContainerStart();

//Benachrichtigung lschen ------------------------------------------------------------------------
if ($action == "delnotify") {
	printMLText("deleting_folder_notify");
	if (isset($userid)) {
		$res = $folder->removeNotify($userid, true);
	}
	else if (isset($groupid)) {
		$res = $folder->removeNotify($groupid, false);
	}
	switch ($res) {
		case -1:
			print (isset($userid) ? getMLText("unknown_user") : getMLText("unknown_group"));
			break;
		case -2:
			printMLText("access_denied");
			break;
		case -3:
			printMLText("already_subscribed");
			break;
		case -4:
			printMLText("internal_error");
			break;
		case 0:
			printMLText("op_finished");
			break;
	}
}

//Benachrichtigung hinzufgen ---------------------------------------------------------------------
else if ($action == "addnotify") {
	printMLText("adding_folder_notify");
	if ($userid != -1) {
		$res = $folder->addNotify($userid, true);
		switch ($res) {
			case -1:
				printMLText("unknown_user");
				break;
			case -2:
				printMLText("access_denied");
				break;
			case -3:
				printMLText("already_subscribed");
				break;
			case -4:
				printMLText("internal_error");
				break;
			case 0:
				printMLText("op_finished");
				break;
		}
	}
	if ($groupid != -1) {
		$res = $folder->addNotify($groupid, false);
		switch ($res) {
			case -1:
				printMLText("unknown_group");
				break;
			case -2:
				printMLText("access_denied");
				break;
			case -3:
				printMLText("already_subscribed");
				break;
			case -4:
				printMLText("internal_error");
				break;
			case 0:
				printMLText("op_finished");
				break;
		}
	}
}
	
UI::contentContainerEnd();
UI::htmlEndPage();
?>
