<?php
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//    Copyright (C) 2006-2008 Malcolm Cowe
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

include("../inc/inc.Settings.php");
include("../inc/inc.AccessUtils.php");
include("../inc/inc.ClassAccess.php");
include("../inc/inc.ClassDocument.php");
include("../inc/inc.ClassFolder.php");
include("../inc/inc.ClassGroup.php");
include("../inc/inc.ClassUser.php");
include("../inc/inc.DBAccess.php");
include("../inc/inc.FileUtils.php");
include("../inc/inc.Language.php");
include("../inc/inc.ClassUI.php");
include("../inc/inc.ClassEmail.php");
include("../inc/inc.Authentication.php");

if (!isset($_GET["folderid"]) || !is_numeric($_GET["folderid"]) || intval($_GET["folderid"])<1) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}
$folderid = $_GET["folderid"];
$folder = getFolder($folderid);
if (!is_object($folder)) {
	UI::htmlStartPage(getMLText("folder_title", array("foldername" => getMLText("invalid_folder_id"))));
	UI::globalNavigation();
	UI::pageNavigation(getMLText("invalid_folder_id"));
	UI::htmlEndPage();
	exit;
}

$folderPathHTML = getFolderPathHTML($folder, true);
UI::htmlStartPage(getMLText("folder_title", array("foldername" => $folder->getName())));
UI::globalNavigation($folder);
UI::pageNavigation($folderPathHTML, "view_folder", $folder);
UI::contentHeading(getMLText("edit_folder_access"));

if ($folder->getAccessMode($user) < M_ALL) {
	UI::contentContainer(getMLText("operation_not_allowed"));
	UI::htmlEndPage();
	exit;
}

switch ($_GET["action"]) {
	case "setowner":
	case "delaccess":
	case "inherit":
		$action = $_GET["action"];
		break;
	case "setdefault":
	case "editaccess":
	case "addaccess":
		$action = $_GET["action"];
		if (!isset($_GET["mode"]) || !is_numeric($_GET["mode"]) || $_GET["mode"]<M_ANY || $_GET["mode"]>M_ALL) {
			UI::contentContainer(getMLText("invalid_access_mode"));
			UI::htmlEndPage();
			exit;
		}
		$mode = $_GET["mode"];
		break;
	case "notinherit":
		$action = $_GET["action"];
		if (strcasecmp($_GET["mode"], "copy") && strcasecmp($_GET["mode"], "empty")) {
			UI::contentContainer(getMLText("invalid_access_mode"));
			UI::htmlEndPage();
			exit;
		}
		$mode = $_GET["mode"];
		break;
	default:
		UI::contentContainer(getMLText("invalid_action"));
		UI::htmlEndPage();
		exit;
		break;
}

if (isset($_GET["userid"])) {
	if (!is_numeric($_GET["userid"])) {
		UI::contentContainer(getMLText("unknown_user"));
		UI::htmlEndPage();
		exit;
	}
	if (!strcasecmp($action, "addaccess") && $_GET["userid"]==-1) {
		$userid = -1;
	}
	else {
		if (!is_object(getUser($_GET["userid"]))) {
			UI::contentContainer(getMLText("unknown_user"));
			UI::htmlEndPage();
			exit;
		}
		$userid = $_GET["userid"];
	}
}

if (isset($_GET["groupid"])) {
	if (!is_numeric($_GET["groupid"])) {
		UI::contentContainer(getMLText("unknown_group"));
		UI::htmlEndPage();
		exit;
	}
	if (!strcasecmp($action, "addaccess") && $_GET["groupid"]==-1) {
		$groupid = -1;
	}
	else {
		if (!is_object(getGroup($_GET["groupid"]))) {
			UI::contentContainer(getMLText("unknown_group"));
			UI::htmlEndPage();
			exit;
		}
		$groupid = $_GET["groupid"];
	}
}

UI::contentContainerStart();

//ndern des Besitzers ----------------------------------------------------------------------------
if ($action == "setowner") {
	printMLText("setting_owner");
	if (!$user->isAdmin()) {
		printMLText("admin_set_owner");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	if (!isset($_GET["ownerid"]) || !is_numeric($_GET["ownerid"]) || $_GET["ownerid"]<1) {
		printMLText("unknown_user");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$newOwner = getUser($_GET["ownerid"]);
	if (!is_object($newOwner)) {
		printMLText("unknown_user");
		UI::contentContainerEnd();
		UI::htmlEndPage();
		exit;
	}
	$folder->setOwner($newOwner);
}

//nderung auf nicht erben ------------------------------------------------------------------------
else if ($action == "notinherit") {
	if ($mode == "copy")
		printMLText("folder_set_not_inherit_copy");
	else
		printMLText("folder_set_not_inherit_empty");

	$defAccess = $folder->getDefaultAccess();
	$folder->setInheritAccess(false);
	$folder->setDefaultAccess($defAccess);

	if ($mode == "copy") {
		$parent = $folder->getParent();
		$accessList = $parent->getAccessList();
		foreach ($accessList["users"] as $userAccess)
			$folder->addAccess($userAccess->getMode(), $userAccess->getUserID(), true);
		foreach ($accessList["groups"] as $groupAccess)
			$folder->addAccess($groupAccess->getMode(), $groupAccess->getGroupID(), false);
	}
}

//nderung auf erben ------------------------------------------------------------------------------
else if ($action == "inherit") {
	printMLText("folder_set_inherit");

	$folder->clearAccessList();
	$folder->setInheritAccess(true);
}

//Standardberechtigung setzen----------------------------------------------------------------------
else if ($action == "setdefault") {
	printMLText("folder_set_default_access");
	$folder->setDefaultAccess($mode);
}

//Bestehende Berechtigung nndern -----------------------------------------------------------------
else if ($action == "editaccess") {
	printMLText("folder_edit_access");
	if (isset($userid)) {
		$folder->changeAccess($mode, $userid, true);
	}
	else if (isset($groupid)) {
		$folder->changeAccess($mode, $groupid, false);
	}
}

//Berechtigung lschen ----------------------------------------------------------------------------
else if ($action == "delaccess") {
	printMLText("folder_del_access");
	if (isset($userid)) {
		$folder->removeAccess($userid, true);
	}
	else if (isset($groupid)) {
		$folder->removeAccess($groupid, false);
	}
}

//Neue Berechtigung hinzufgen --------------------------------------------------------------------
else if ($action == "addaccess") {
	printMLText("folder_add_access");
	if (isset($userid) && $userid != -1) {
		$folder->addAccess($mode, $userid, true);
	}
	if (isset($groupid) && $groupid != -1) {
		$folder->addAccess($mode, $groupid, false);
	}
}
printMLText("op_finished");
UI::contentContainerEnd();
UI::htmlEndPage();
?>
