<?
//    MyDMS. Document Management System
//    Copyright (C) 2002-2005  Markus Westphal
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

class Settings
{
	//IDs of admin-user, guest-user and root-folder (no need to change)
	var $_adminID = 1;
	var $_guestID = 2;
	var $_rootFolderID = 1;
	
	//If you don't want anybody to login as guest, set the following line to false
	var $_enableGuestLogin = true;
	
	//path to where mydms is located
	var $_rootDir = "e:/web/mydms/";
	
	//the same as URL
	var $_httpRoot = "/mydms/";
	
	//where the uploaded files are stored (you better choose a directory that is not accessible through your web-server)
	var $_contentDir = "e:/web/mydms/content/";
	
	//default language (name of a subfolder in folder "languages")
	var $_language = "English";
	
	//users are notified about document-changes that took place within the last $_updateNotifyTime seconds
	var $_updateNotifyTime = 86400; //means 24 hours
	
	//files with one of the following endings can be viewed online
	var $_viewOnlineFileTypes = array(".txt", ".html", ".htm", ".pdf", ".gif", ".png", ".jpg");
	
	//enable/disable converting of files
	var $_enableConverting = true;
	
	//default theme (name of a subfolder in folder "themes")
	var $_theme = "default";
	
	// -------------------------------- Database-Setup --------------------------------------------
	
	//Path to adodb
	var $_ADOdbPath = "e:/web/mydms/adodb/";
	
	//DB-Driver used by adodb (see adodb-readme)
	var $_dbDriver = "mysql";
	
	//DB-Server
	var $_dbHostname = "localhost";
	
	//database where the tables for mydms are stored (optional - see adodb-readme)
	var $_dbDatabase = "mydms";
	
	//username for database-access
	var $_dbUser = "root";
	
	//password for database-access
	var $_dbPass = "";
	
	function Settings()
	{
		//files with one of the following endings will be converted with the given commands
		//for windows users
		$this->_convertFileTypes = array(".doc" => "cscript \"" . $this->_rootDir."op/convert_word.js\" {SOURCE} {TARGET}",
										 ".xls" => "cscript \"".$this->_rootDir."op/convert_excel.js\" {SOURCE} {TARGET}",
										 ".ppt" => "cscript \"".$this->_rootDir."op/convert_pp.js\" {SOURCE} {TARGET}");
		//for linux users
	//	$this->_convertFileTypes = array(".doc" => "mswordview -o {TARGET} {SOURCE}");
	}
}

$settings = new Settings();

?>
