/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 xsleep.h  -  portable sleep functions

    begin                : Tue Mar 26 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef __xsleep_h_included__
#define __xsleep_h_included__

// Check to make sure we've got our struct defined for timespec.
#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

/*  For now, we can't do this.  We need Autoconf 2.5.
#ifndef HAVE_STRUCT_TIMESPEC
struct timespec
{
	time_t tv_sec;
	long   tv_nsec;
};
#endif
*/

// Make sure we've got timespec conversions.
#ifndef TIMEVAL_TO_TIMESPEC
#define TIMEVAL_TO_TIMESPEC(tv, ts) {                                   \
        (ts)->tv_sec = (tv)->tv_sec;                                    \
        (ts)->tv_nsec = (tv)->tv_usec * 1000;                           \
}
#endif

#ifndef TIMESPEC_TO_TIMEVAL
#define TIMESPEC_TO_TIMEVAL(tv, ts) {                                   \
        (tv)->tv_sec = (ts)->tv_sec;                                    \
        (tv)->tv_usec = (ts)->tv_nsec / 1000;                           \
}
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Support dumb missing headers on OSX.
#ifdef HAVE_NANOSLEEP
#if defined HAVE_DECL_NANOSLEEP && !HAVE_DECL_NANOSLEEP
//#ifdef __APPLE__
int nanosleep(const struct timespec *, struct timespec *);
#endif
#endif

int safe_nanosleep(const struct timespec *rqtp, struct timespec *rmtp);

#ifdef __cplusplus
};
#endif

#endif //__xsleep_h_included__

