/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 lineinput.cpp  -  Input line and command completion capabilities for term UI
 
    begin                : Sat Jan 26 2002
    copyright            : (C) 2002 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "mutella.h"
#include "lineinput.h"

#ifndef _USE_TECLA
#include "readline4fix.h"
#else //_USE_TECLA
#include <libtecla.h>
#endif //_USE_TECLA

#ifndef _USE_TECLA

#ifdef HAVE_READLINE_42
// we only support completion if readline 4.2 or greater is installed

static MLineInput* s_pInputLine = NULL;
static list<CString> s_listCompletions;
static list<CString>::iterator s_itCompl;

char *
dupstr (const char *s)
{
  char *r;
  r = (char*) malloc (strlen (s) + 1);
  ASSERT(r);
  strcpy (r, s);
  return (r);
}

/* Generator function for command completion.  STATE lets us
   know whether to start from scratch; without any state
   (i.e. STATE == 0), then we start at the top of the list. */
char *
ReadlineGenerator (const char * text, int state)
{
	static int len;
	char *name;

	/* If this is a new word to complete, initialize now.  This
	   includes saving the length of TEXT for efficiency, and
	   initializing the index variable to 0. */
	if (!state)
	{
		s_itCompl = s_listCompletions.begin();
		len = strlen (text);
	}

	/* Return the next name which partially matches from the
	   command list. */
	if (s_itCompl == s_listCompletions.end())
		return NULL;
	name = dupstr(s_itCompl->c_str());
	++s_itCompl;
	return name;
}

/* Attempt to complete on the contents of TEXT.  START and END
   bound the region of rl_line_buffer that contains the word to
   complete.  TEXT is the word to complete.  We can use the entire
   contents of rl_line_buffer in case we want to do some simple
   parsing. Returns the array of matches, or NULL if there aren't any. */
static char **
ReadlineCompletionCallback(const char * text, int start, int end)
{
	//
	if (!s_pInputLine)
		return NULL;
	// I hate static variables
	s_listCompletions.clear();
	if (!s_pInputLine->CompleteWord(CString(rl_line_buffer_fix(), end), s_listCompletions))
	{
		rl_attempted_completion_over_fix();
		return NULL;
	}
	//
	// we dont have to call rl_attempted_completion_over_fix() because matching function will return non-null value
	// call genetaror function as readline manual tells us
	return rl_completion_matches_fix(text, ReadlineGenerator);
}
#endif //HAVE_READLINE_42

#else //_USE_TECLA
static int TeclaCompletionCallback(WordCompletion *cpl, void *data, const char *line, int word_end)
{
	MLineInput* pLI = (MLineInput*) data;
	list<CString> listCompletions;
	if (pLI->CompleteWord(CString(line, word_end), listCompletions))
	{
		//cpl_add_completion(cpl, line, 0,word_end,"et",NULL," "); // completion example for s<TAB> to set<SPACE>
		for (list<CString>::iterator it = listCompletions.begin(); it!=listCompletions.end(); ++it)
		{
			cpl_add_completion(cpl, line, 0,word_end,it->substr(word_end).c_str(),NULL," ");
		}
	}
	return 0;
}
#endif //_USE_TECLA

MLineInput::MLineInput()
{
	m_pPrivate = NULL;
}

MLineInput::~MLineInput()
{
	if (m_pPrivate)
		Close();
}

bool MLineInput::Init(FILE* fpInput, FILE* fpOutput)
{
#ifndef _USE_TECLA
	/* Tell the GNU Readline library how to complete.  We want to try to
	   complete on command names if this is the first word in the line, or
	   on filenames if not. */
	/* Allow conditional parsing of the ~/.inputrc file. */
	rl_readline_name_fix("MLineInput");
#ifdef HAVE_READLINE_42
	// set the static callback for the completer
	s_pInputLine = this;
	/* Set "show-all" option ON */
	rl_complete_show_all_fix(1);
	/* Tell the completer that we want a crack first. */
	rl_attempted_completion_function_fix(ReadlineCompletionCallback);
#endif //HAVE_READLINE_42
	return true;
#else //_USE_TECLA
	m_pPrivate = new_GetLine(1024,2048);
	if (!m_pPrivate)
		return false;
	gl_customize_completion((GetLine*)m_pPrivate, this, TeclaCompletionCallback);
	return true;
#endif //_USE_TECLA
}

void MLineInput::Close()
{
#ifndef _USE_TECLA
#else //_USE_TECLA
	if (m_pPrivate)
	{
		del_GetLine((GetLine*)m_pPrivate);
		m_pPrivate = NULL;
	}
#endif //_USE_TECLA
}

CString MLineInput::InputLine(LPCSTR szPrompt)
{
#ifndef _USE_TECLA
	char * psz = readline_fix(szPrompt);
	CString s = psz;
	if (psz) ::free(psz);
	if (s.length() && s != m_sLast)
	{
		add_history_fix(s.c_str());
		m_sLast = s;
	}
	return s;
#else //_USE_TECLA
	if (!m_pPrivate)
		return "";
	return gl_get_line((GetLine*)m_pPrivate, szPrompt, NULL, -1);
#endif //_USE_TECLA
}

bool MLineInput::CompleteWord(const CString& part, list<CString>& listCompletions)
{
	return false;
}


