/***************************************************************************
 Mutella - A commandline/HTTP client for the Gnutella filesharing network.

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 byteorder.h  -  Bit/Byte order management class definition
                             -------------------
    begin                : Thu Jun 8 2000
    copyright            : (C) 2000 by Max Zaitsev
    email                : maksik@gmx.co.uk
 ***************************************************************************/

#ifndef _BYTEORDER_H_INCLUDED_
#define _BYTEORDER_H_INCLUDED_

#include "config.h"

// byte order independent template classes-wrappers
#define XOR(a,b) ( ((!(a)) && (b)) || ((a) && (!(b))) )

class MByteOrderTest {
private:
#ifdef WORDS_BIGENDIAN
	static const bool bigEndian = true;
#else
	static const bool bigEndian = false;
#endif 

public:
	MByteOrderTest(){};
	bool inline IsLittleEndian() const {return !bigEndian;}
	bool inline IsBigEndian() const { return bigEndian; }
};

#pragma pack(1)

template<class T_type, bool B_bigendian>
class TByteOrderWrapper{
public:
	TByteOrderWrapper():data(){}
	TByteOrderWrapper(const TByteOrderWrapper<T_type, B_bigendian>& orig):data(orig.data){}
	TByteOrderWrapper(T_type value){
		ByteReorder(value, data);
	}
	operator T_type() const{
		T_type tmp;
		ByteReorder(data, tmp);
		return tmp;
	}
	const TByteOrderWrapper<T_type, B_bigendian>& operator=(const T_type& rhs){
		ByteReorder(rhs, data);
		return (*this);
	}
	const TByteOrderWrapper<T_type, B_bigendian>& operator=(const TByteOrderWrapper<T_type, B_bigendian>& rhs){
		data = rhs.data;
		return (*this);
	}
	// i've decided to make it public
	T_type data;
protected:
	void ByteReorder(const T_type& src, T_type& dest) const{
		if(XOR(B_bigendian, bigEndian))
		{
			for(int i=0; i<sizeof(T_type); i++)
				((char*)(&dest))[sizeof(T_type)-i-1] = ((char*)(&src))[i];
		}
		else
		{
			dest = src;
		}
	}
	void ByteReorder(T_type& value) const{
		if(XOR(B_bigendian, bigEndian))
		{
			char chTmp;
			for(int i=0; i<sizeof(T_type)/2; i++)
			{
				chTmp = ((char*)(&value))[sizeof(T_type)-i-1];
				((char*)(&value))[sizeof(T_type)-i-1] = ((char*)(&value))[i];
				((char*)(&value))[i] = chTmp;
			}
		}
	}
private:
#ifdef WORDS_BIGENDIAN
	static const bool bigEndian = true;
#else 
	static const bool bigEndian = false;
#endif
};

#pragma pack()

#define BE(_TYPE) TByteOrderWrapper<_TYPE, true>
#define LE(_TYPE) TByteOrderWrapper<_TYPE, false>

template<class T_type>
T_type VariableByteOrderWrapper(T_type orig, bool bSwap)
{
	if(bSwap)
	{
		T_type dest;
		for(int i=0; i<sizeof(T_type); i++)
			((char*)(&dest))[sizeof(T_type)-i-1] = ((char*)(&orig))[i];
		return dest;
	}
	return orig;
}

#define VBO(_what, _swap) VariableByteOrderWrapper(_what, _swap)

extern void BitReorder(unsigned char* pBuffer, int nSize, int nElementSize, bool bBits, bool bBytes);

#endif //_BYTEORDER_H_INCLUDED_

