/*
 * muscleTool scanner.
 *
 * MUSCLE SmartCard Development ( http://www.linuxnet.com )
 *
 * Copyright (C) 2005
 *  Karsten Ohme <k_o_@users.sourceforge.net>
 *  Toni Andjelkovic <toni@soth.at>
 *  Ludovic Rousseau <ludovic.rousseau@free.fr>
 *
 * $Id: scanner.l,v 1.1.1.2 2009-11-13 13:13:11 rousseau Exp $
 */

%option noyywrap

%{
#include <string.h>
#include <stdlib.h>

#include "parser.h"

static YY_BUFFER_STATE buf_state;
void my_lex_init(char *src);
void my_lex_close(void);

/* silence warnings */
#if defined(_WIN32)
__declspec(dllimport) extern int fileno(FILE *);
#endif
extern void yyerror(char *);
#define YY_NO_UNPUT

%}

qstring		\"[^\n"]+\"
ws		[[:blank:]]+
alpha		[[:alnum:]]+
number		-?[0-9]+
comment		#.*
crlf		\r?\n|\r
separator	;

%%

create		return CREATE;
delete		return _DELETE;
deletekey	return DELETEKEY;
write		return WRITE;
read		return READ;
list		return LIST;
changeacl	return CHANGEACL;

crypt		return CRYPT;
filecrypt	return FILECRYPT;
rsa			return RSA;
rsacrt		return RSACRT;
dsa			return DSA;
des			return DES;
aes			return AES;
ec			return EC;
ecfp		return ECFP;
ecf2m		return ECF2M;
3des		return TDES;
3des3		return TDES3;
keys		return KEYS;
pins		return PINS;
objects		return OBJECTS;

verify		return VERIFY;
makepin		return MAKEPIN;
changepin	return CHANGEPIN;
unblock		return UNBLOCK;
listpins	return LISTPINS;
deleteid	return DELETEID;
movekey		return MOVEKEY;
move		return MOVE;
changekeyacl	return CHANGEKEYACL;

listkeys	return LISTKEYS;
exportkey	return EXPORTKEY;
importkey	return IMPORTKEY;
genkeys		return GENKEYS;

format		return FORMAT;
tokens		return TOKENS;
connect		return CONNECT;
resume		return RESUME;
release		return RELEASE;
status		return STATUS;
setstatus	return SETSTATUS;
challenge	return CHALLENGE;
logout		return LOGOUT;
version		return _VERSION;
exit|quit	return EXIT;
help|\?		return HELP;

test		return TEST;
{ws}		/* ignore */
{comment}	/* ignore */
{crlf}		return 0;
{separator}	return SEPARATOR;

{number}	{
			yylval.num = atoi(yytext);
			return NUMBER;
		}

{qstring}	{
			yylval.str = strdup(yytext + 1);
			yylval.str[yyleng - 2] = 0;
			return STRING;
		}

{alpha}		{
			yylval.str = strdup(yytext);
			return STRING;
		}

.		return yytext[0];

%%

void my_lex_init(char *src)
{
	buf_state = yy_scan_string(src);
}

void my_lex_close(void)
{
	yy_delete_buffer(buf_state);
}

