---
Name: Picard
URL: http://broadinstitute.github.io/picard/
Description: >
    Picard is a set of Java command line tools for manipulating high-throughput
    sequencing data.
---

The Picard module parses results generated by
[Picard](http://broadinstitute.github.io/picard/),
a set of Java command line tools for manipulating high-throughput
sequencing data.

Supported commands:

* `MarkDuplicates`
* `InsertSizeMetrics`
* `GcBiasMetrics`
* `HsMetrics`
* `OxoGMetrics`
* `BaseDistributionByCycl`
* `RnaSeqMetrics`
* `AlignmentSummaryMetrics`
* `RrbsSummaryMetrics`
* `ValidateSamFile`
* `VariantCallingMetrics`

#### InsertSizeMetrics
By default, the insert size plot is smoothed to contain a maximum of 500 data points per sample.
This is to prevent the MultiQC report from being very large with big datasets.
If you would like to customise this value to get a better resolution you can set the following
MultiQC config values, with the new maximum number of points:
```yaml
picard_config:
    insertsize_smooth_points: 10000
```

#### Coverage Levels
It's possible to customise the HsMetrics _"Target Bases 30X"_ coverage and
WgsMetrics _"Fraction of Bases over 30X"_ that are
shown in the general statistics table. This must correspond to field names in the
picard report, such as `PCT_TARGET_BASES_2X` / `PCT_10X`. Any numbers not found in the
reports will be ignored.

The coverage levels available for HsMetrics are
[typically](http://broadinstitute.github.io/picard/picard-metric-definitions.html#HsMetrics)
1, 2, 10, 20, 30, 40, 50 and 100X.

The coverage levels available for WgsMetrics are
[typically](http://broadinstitute.github.io/picard/picard-metric-definitions.html#CollectWgsMetrics.WgsMetrics)
1, 5, 10, 15, 20, 25, 30, 40, 50, 60, 70, 80, 90 and 100X.

To customise this, add the following to your MultiQC config:
```yaml
picard_config:
    general_stats_target_coverage:
        - 10
        - 50
```

#### ValidateSamFile Search Pattern
Generally, Picard adds identifiable content to the output of function calls. This is not the case for ValidateSamFile. In order to identify logs the MultiQC Picard submodule `ValidateSamFile` will search for filenames that contain 'validatesamfile' or 'ValidateSamFile'. One can customise the used search pattern by overwriting the `picard/sam_file_validation` pattern in your MultiQC config. For example:
```yaml
sp:
    picard/sam_file_validation:
        fn: '*[Vv]alidate[Ss]am[Ff]ile*'
```
