import zope.interface
from multibuild.builder.hooks import interfaces, register, support

class Hook(support.Hook):
    zope.interface.implements(interfaces.IHookBuildCompile)

    name = "compile-dpkg"

    def compile(self, build, flags):
        import errno, os, signal, time

        env = {}
        build_arch_all = build_source = False
        maintainer = None
        timeout = 150 * 60

        for key, value in flags.iteritems():
            if key == 'maintainer':
                maintainer = value
            elif key == 'build-arch-all':
                build_arch_all = True
            elif key == 'build-source':
                build_source = True
            elif key == 'timeout':
                try:
                    timeout = int(value) * 60
                except ValueError: pass
            elif key.startswith('env-'):
                env[key[4:]] = value

        cmd = ["env"]
        cmd.extend(["%s='%s'" % i for i in env.iteritems()])

        cmd.extend(["dpkg-buildpackage", "-uc", "-us", "-rfakeroot"])

        if build_source:
            pass
        elif build_arch_all:
            cmd.append("-b")
        else:
            cmd.append("-B")

        if build.environment.arch != 'all':
            cmd.append("'-a%s'" % build.environment.arch)

        if maintainer is not None:
            cmd.append("'-m%s'" % maintainer)

        f = build.environment.run_dir(cmd, "%s/%s-%s" % (build.environment.build_dir, build.package, build.version.upstream))

        timed_out = []
        last_time = time.time()

        def signal_alarm(sig, frame):
            sig = signal.SIGTERM
            if len(timed_out):
                sig = signal.SIGKILL
            #os.kill(pid, sig)
            timed_out.append((signal, time.time() - last_time))
            # only wait 5 minutes until next signal
            timeout = 5 * 60;
            signal.alarm(timeout)

        signal.signal(signal.SIGALRM, signal_alarm)
        signal.alarm(timeout)

        while True:
            try:
                i = f.readline()
            except IOError, e:
                if e.errno == errno.EINTR:
                    continue
                raise
            if not i:
                break
            signal.alarm(timeout);
            build.log.write(i)
            build.log.flush()

        signal.alarm(0);
        signal.signal(signal.SIGALRM, signal.SIG_DFL)

        if f.close():
            raise RuntimeError, "Failed"

register(Hook)
