from zope.interface import Attribute, Interface

class IHookBuildInfo(Interface):
    package = Attribute("Package to build")
    version = Attribute("Version of package to build")

    environment = Attribute("Current environemtn")
    extra = Attribute("Dict of additional informations for this build")
    log = Attribute("Where to write the log to")

class IHookBuild(Interface):
    pass

class IHookBuildCleanup(IHookBuild):
    def cleanup(build):
        pass

class IHookBuildCompile(IHookBuild):
    def compile(build, flags):
        pass

class IHookBuildCompileFlags(IHookBuild):
    def compileCmdFlags(build, flags):
        pass

class IHookBuildInstall(IHookBuild):
    def install(build, packages):
        pass

class IHookBuildPrepare(IHookBuild):
    def prepare(build):
        pass

class IHookBuildResult(IHookBuild):
    def result(build):
        pass

class IHookBuildSourceGet(IHookBuild):
    def sourceGet(build):
        pass

class IHookBuildSourceModify(IHookBuild):
    def sourceModify(build):
        pass

class IHookEnvironment(Interface):
    arch = Attribute("Architecture of the environment")
    arch_root = Attribute("Real architecture of the environment, for changes files")
    build_path = Attribute("Reachable path where the builds have to be located")
    build_dir = Attribute("Directory where the builds have to be located inside the root")
    dist = Attribute("Distribution of the environment")
    path = Attribute("Root")
    log = Attribute("Where to write the daemon log to")

    def cleanup(build):
        pass

    def install(build, packages):
        pass

    def prepare(build):
        pass

    def run(cmd):
        """
        @return: file like object, exit value available via close()
        """

    def run_dir(cmd, dir):
        """
        @return: file like object, exit value available via close()
        """

    def suexec(cmd):
        """
        @return: file like object, exit value available via close()
        """

class IHookEnvironmentFactory(Interface):
    def __call__(id, dist, arch, user, log):
        pass

