/*
 *  MudName Server v. 1.6 - A character name generator
 *  Copyright (C) 1997-2001 Ragnar Hojland Espinosa <ragnar@ragnar-hojland.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/wait.h>
#include <time.h>

#include "names.h"
#include "globals.h"
#include "server.h"

int serverfd;
int connection_count;

void name_generator (int fd, void *args)
{
   int i;
   
   srand (time(NULL) ^ getpid());   
   write (fd, text_version, strlen (text_version));
   write (fd, text_ad, strlen (text_ad));
   for (i = 0; i < 10; ++i) {
      char buf[8192];
      generate_name (rrand(0,dictionary_count - 1), buf, 8190);
      strcat (buf, "\n\r");
      buf[0] -= 32;
      write (fd, buf, strlen (buf));
   }
   write (fd, text_footer, strlen (text_footer));
}


/* obviously at least gettimeofday shouldn't be called inside a signal
 * handler. it'll do, tho */
void handler_sigterm (int signo)
{
   struct timeval tv;
   char *now;
   close (serverfd);
   
   gettimeofday (&tv, NULL);
   now = ctime (&tv.tv_sec);
   now[strlen(now) -1] = '\0';
   fprintf (logfile, "%s: killed, processed %d connections\n", now, connection_count);
   exit(0);
}


int init_server (int port)
{
   struct sockaddr_in server_addr;
   
   serverfd = socket (AF_INET, SOCK_STREAM, 0);
   if (serverfd < 0) {
      perror ("socket");
      return 1;
   }
   
   memset (&server_addr, 0, sizeof(server_addr));
   server_addr.sin_family = AF_INET;
   server_addr.sin_addr.s_addr = htonl (INADDR_ANY);
   server_addr.sin_port = htons(port);
   
   if (bind (serverfd, (struct sockaddr*) &server_addr, sizeof(server_addr)) < 0) {
      perror ("bind");
      return 1;
   }
   
   if (listen (serverfd, 5) < 0) {
      perror ("listen");
      return 1;
   }
   
   return 0;
}

int run_server (void (*function)(int fd, void *args), void *args)
{
   struct sockaddr_in client_addr;
   struct timeval tv;
   char  *now;
   
   gettimeofday (&tv, NULL);
   now = ctime (&tv.tv_sec);
   now[strlen(now) -1] = '\0';
   fprintf (logfile, "%s: %s started\n", now, text_fullid);
		     
   while (1) {
      pid_t child;
      unsigned int n = sizeof (client_addr);
      int clientfd = accept (serverfd, (struct sockaddr*) &client_addr, &n);
      if (clientfd < 0) {
	 perror ("accept");
      }
      ++connection_count;
      
      if ( (child = fork()) < 0) {
	 perror ("fork");
      } else if (child == 0) {
	 if ( (child = fork()) < 0) {
	    perror ("fork");
	 } else if (child > 0) {
	    exit(0);
	 }
	 close (serverfd);
	 function (clientfd, args);
	 close (clientfd);
	 exit(0);
      }
      close (clientfd);
      waitpid (child, NULL, 0);
   }
}
