/*
 * Decompiled with CFR 0.152.
 */
package org.petzall.daapapplet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import org.petzall.daapapplet.DAAPPanel;
import org.petzall.daapapplet.gui.GUI;
import org.petzall.daapapplet.gui.HtmlGUI;
import org.petzall.daapapplet.gui.SkinnedGUI;

public class DAAPApplet
extends JApplet {
    public static final String VERSION = "0.1";
    private GUI _gui;
    private DAAPPanel _panel;
    private boolean _useTableControl;
    private int _selTrack;

    public void init() {
        this._gui = "HTML".equals(this.getParameter("GUI")) ? new HtmlGUI(this) : new SkinnedGUI(this);
        try {
            int n = 3689;
            try {
                n = Integer.parseInt(this.getParameter("DAAPPort"));
            }
            catch (Exception exception) {
                n = 3689;
            }
            this._useTableControl = !this.getParameter("HTMLList").equals("true");
            this._panel = new DAAPPanel(this._gui, this.getParameter("DAAPHost"), n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getContentPane().add(this._panel);
    }

    public void start() {
        this._panel.openConnection();
    }

    public Color getColor(String string) {
        String string2 = this.getParameter(string + "Color");
        if (string2 == null || string2.length() == 0 || string2.charAt(0) != '#') {
            if (string.indexOf("Background") < 0) {
                return Color.BLACK;
            }
            return Color.WHITE;
        }
        int n = Integer.parseInt(string2.substring(1), 16);
        return new Color(n);
    }

    public Font getFont(String string) {
        String string2 = this.getParameter(string + "Font");
        if (string2 == null || string2.length() == 0) {
            return new Font("Tahoma", 0, 11);
        }
        return new Font(string2, 0, 11);
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"DAAPHost", "String", "The hostname to connect to (default is same as web server)"}, {"DAAPPort", "1-65536", "The port to connect to (default is 3689)"}, {"GUI", "[HTML]", "GUI mode (recommended to leave at default)"}};
        return stringArray;
    }

    public String getAppletInfo() {
        return "DAAPApplet v0.1\nCopyright \u00a9 2005 Rickard Petz\u00e4ll\nBased on AppleRecords \u00a9 2004 Chris Davies\nThis software is published under theGNU General Public License v2";
    }

    private String getCurrentServerHostname() {
        return "localhost";
    }

    public void playPause() {
        if (this._panel.getControl().isPlaying()) {
            this._panel.getControl().stopTrack();
        } else {
            this.play();
        }
    }

    public void play() {
        this._panel.getControl().playSelectedTrack();
    }

    public void playItem(int n) {
        this._gui.setStatusString("Playing item " + n);
        this._selTrack = n;
        this._panel.getControl().playSelectedTrack();
    }

    public void pause() {
    }

    public void next() {
        this._panel.getControl().playNextTrack();
    }

    public void previous() {
        this._panel.getControl().playPreviousTrack();
    }

    public void search(String string) {
        this._panel.search(string);
    }

    public void browseBy(String string, String string2) {
        this._panel.browseBy(string, string2);
    }

    public int getNumTracks() {
        return this._panel.getTotalTrackCount();
    }

    public int getNumFilteredTracks() {
        return this._panel.getTrackList().getRowCount();
    }

    public int getCurrentTrackPosition() {
        return this._panel.getControl().getCurrentTrackPosition();
    }

    public int getCurrentTrackLength() {
        return this._panel.getControl().getCurrentTrackLength();
    }

    public void about() {
        new JDialog((Frame)null, "About DAAPApplet", true){
            private static final String _aboutStr = "<b>DAAPApplet v0.1 - A DAAP Client applet</b><br><br>\u00a9 Rickard Petz\u00e4ll 2005<br>Based on AppleRecords \u00a9 2004 Chris Davies<br>For details, visit: <b>www.petzall.se/daap</b><br><br>This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.";

            public void show() {
                this.setLayout(new BorderLayout());
                JEditorPane jEditorPane = new JEditorPane("text/html", _aboutStr);
                jEditorPane.setEditable(false);
                this.getContentPane().add((Component)jEditorPane, "Center");
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.dispose();
                    }
                });
                this.getContentPane().add((Component)jButton, "South");
                this.setBounds(0, 0, 500, 300);
                this.setLocationRelativeTo(null);
                super.show();
            }
        }.show();
    }
}

