/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes.request;

import itunes.FieldPair;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import org.cdavies.itunes.request.NoServerPermissionException;
import org.cdavies.itunes.request.Request;
import org.cdavies.itunes.request.ServerInfoRequest;

public class LegacyServerInfoRequest
extends Request
implements ServerInfoRequest {
    public LegacyServerInfoRequest(String string, int n) {
        super(string, n, "server-info");
    }

    public void runQuery() throws NoServerPermissionException {
        try {
            DataInputStream dataInputStream = new DataInputStream(this._conn.getInputStream());
            int n = this._conn.getContentLength();
            if (n == -1) {
                return;
            }
            this.data = new byte[n];
            dataInputStream.readFully(this.data);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            throw new NoServerPermissionException(iOException.getMessage());
        }
    }

    public double getServerDAAPVersion() {
        int n = this.fieldPairs.indexOf(new FieldPair("apro", new byte[0], 0, 0));
        if (n == -1) {
            return n;
        }
        FieldPair fieldPair = (FieldPair)this.fieldPairs.get(n);
        return (double)LegacyServerInfoRequest.readInt(fieldPair.value, 0, 2) + 0.01 * (double)LegacyServerInfoRequest.readInt(fieldPair.value, 2, 2);
    }
}

