/*
 * Decompiled with CFR 0.152.
 */
package org.cdavies.itunes;

import java.util.Enumeration;
import java.util.Vector;
import org.cdavies.itunes.Itunes45Connection;
import org.cdavies.itunes.Itunes4Connection;
import org.cdavies.itunes.ItunesConnection;
import org.cdavies.itunes.hash.Itunes45Hash;
import org.cdavies.itunes.request.LegacyServerInfoRequest;
import org.cdavies.itunes.request.NoServerPermissionException;

public class ItunesConnectionFactory {
    private Vector _connections = new Vector(5);

    private ItunesConnection locateExistingConnection(String string, int n) {
        String string2 = string + ":" + n;
        Enumeration enumeration = this._connections.elements();
        while (enumeration.hasMoreElements()) {
            ItunesConnection itunesConnection = (ItunesConnection)enumeration.nextElement();
            if (!string2.equals(itunesConnection.getServerName() + ":" + itunesConnection.getPort())) continue;
            return itunesConnection;
        }
        return null;
    }

    public void removeCachedItunesConnection(String string) {
        for (int i = 0; i < this._connections.size(); ++i) {
            ItunesConnection itunesConnection = (ItunesConnection)this._connections.elementAt(i);
            if (!itunesConnection.toString().equals(string)) continue;
            this._connections.removeElementAt(i);
            break;
        }
    }

    public ItunesConnection produceConnectionInstance(String string, int n, String string2) throws NoServerPermissionException {
        ItunesConnection itunesConnection = this.locateExistingConnection(string, n);
        if (itunesConnection != null) {
            return itunesConnection;
        }
        LegacyServerInfoRequest legacyServerInfoRequest = new LegacyServerInfoRequest(string, n);
        legacyServerInfoRequest.setHash(new Itunes45Hash());
        legacyServerInfoRequest.constructQuery();
        legacyServerInfoRequest.runQuery();
        legacyServerInfoRequest.process();
        double d = legacyServerInfoRequest.getServerDAAPVersion();
        itunesConnection = d < 3.0 ? new Itunes4Connection(string, n, string2) : new Itunes45Connection(string, n, string2);
        this._connections.add(itunesConnection);
        return itunesConnection;
    }
}

