#!/bin/sh

usage()
{
	echo "	Usage:"
	echo ""
	echo "	This program updates the TuxFamily site with the new source tarball"
	echo "  that should have been generated using make-orig-tarball.sh"
	echo ""
	echo "  This program works when run from the top source directory"
	echo "  (where the debian directory resides. This directory must be called"
	echo "  \"development\" and must have as directory siblings the directories"
	echo "  \"tarballs\" and \"build-area\"."
	echo ""
	echo "	Simply answer the questions."
}

if [ "$1" = "-h" ] || [ "$1" = "--help" ] || [ "$1" = "?" ]
then
	usage
	exit
fi

if [ ! -d "debian" ]
then
	echo "Not in top source directory: no debian directory."
	exit 1
fi

projectName="msxpertsuite"

mainDir="$(pwd)/.."

tarballDir="${mainDir}/tarballs"
buildDir="${mainDir}/build-area"

devDir="${mainDir}/development"
debianDir="${devDir}/debian"

cd ${devDir}
# echo "Now in ${devDir}"

# Check that we are in the master branch or alert the user.

gitBranch=""

gitBranch=$(git status | head -n1 | awk '{print $3}')
if [ "${gitBranch}" != "master" ]
then
	echo "Checkout the master branch first, or is this branch fine (y/n)."
	read answer
	if [ "x${answer}" != "xy" ]
	then
		exit 1
	fi
fi

# Check that we have nothing to commit.

gitOutput=$(git status | \
	grep "nothing to commit" | awk '{printf $1 $2 $3}')

if [ "${gitOutput}" != "nothingtocommit," ]
then
	echo "Branch ${gitBranch} is not clean." 
	exit 1
fi

DEBVER=$(head -n1 ${debianDir}/changelog | \
	awk '{printf $2}' | sed 's|(\([0-9\.-]*\))|\1|')
UPVER=$(echo ${DEBVER} | sed 's/-[0-9]\+//')

srcTarball=${projectName}-${UPVER}.tar.gz

echo "Uploading ${srcTarball}"
echo ""
echo "Is this correct? Ctrl-C to stop process. Return to accept"
read answer
echo "Going on, then."

command="rsync -av --no-o --no-g ${tarballDir}/${srcTarball} \
 	rusconi@ssh.tuxfamily.org:~/msxpertsuite/msxpertsuite-repository/source"

echo ${command}

eval ${command}

exitStatus=$?
printf "exit status: ${exitStatus}\n"
return ${exitStatus}

