
#include <iostream>
#include <ctime>
#include <random>

#include "catch.hpp"

#include "MassPeak.hpp"
#include "globals/globals.hpp"

#include <QDebug>
#include <QFile>

using std::cout;

#define TEST_DATA_DIR "/home/rusconi/devel/msxpertsuite/development/tests/data"

//qDebug() << __FILE__ << __LINE__ << __FUNCTION__ 
//<< "Should compile libmass tests.";

namespace msXpSlibmass
{

	TEST_CASE("construct an initialized mass peak.", "[MassPeak]")
	{

		MassPeak invalidPeak;
		REQUIRE(invalidPeak.validate() == false);

		MassPeak peak1(12345.123456789, 987.987654321);

		REQUIRE(peak1.mz() == 12345.123456789);
		REQUIRE(peak1.i() == 987.987654321);

		REQUIRE(peak1.validate() == true);

		MassPeak peak2(peak1);

		REQUIRE(peak2.mz() == 12345.123456789);
		REQUIRE(peak2.i() == 987.987654321);

		QString xyLine = "12345.123456789 987.987654321\n";

		MassPeak peak3(xyLine);
		REQUIRE(peak3.mz() == 12345.123456789);
		REQUIRE(peak3.i() == 987.987654321);

		MassPeak peak4;

		bool res = peak4.initialize(xyLine);
		REQUIRE(res == true);		
		REQUIRE(peak4.mz() == 12345.123456789);
		REQUIRE(peak4.i() == 987.987654321);

	}









	//TEST_CASE("", "[MassPeak]")
	//{

	//}

} // namespace msXpSlibmass
