/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
*/



#ifndef FRAGMENTATION_DLG_HPP
#define FRAGMENTATION_DLG_HPP


/////////////////////// Qt includes
#include <QSortFilterProxyModel>


/////////////////////// Local includes
#include "ui_FragmentationDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "Fragmenter.hpp"
#include "SequenceEditorWnd.hpp"
#include "FragmentOligomerTableViewModel.hpp"
#include "FragmentOligomerTableViewSortProxyModel.hpp"
#include "FragOptions.hpp"


namespace msXpSmassXpert
{

  class FragmentOligomerTableViewModel;
  class FragmentOligomerTableViewSortProxyModel;

  class FragmentationDlg : public AbstractSeqEdWndDependentDlg
  {
    Q_OBJECT

    private:
    Ui::FragmentationDlg m_ui;

    // The results-exporting strings. ////////////////////////////////
    QString *mpa_resultsString;
    QString  m_resultsFilePath;
    //////////////////////////////////// The results-exporting strings.

    OligomerList m_oligomerList;

    CalcOptions       m_calcOptions;
    const msXpSlibmass::IonizeRule *mp_ionizeRule;

    Fragmenter *mpa_fragmenter;

    void writeSettings();
    void readSettings();

    FragmentOligomerTableViewModel *         mpa_oligomerTableViewModel;
    FragmentOligomerTableViewSortProxyModel *mpa_proxyModel;

    // For the filtering of the data in the treeview.
    QAction *filterAct;
    double   m_tolerance;
    QWidget *mp_focusWidget;

    void setupTableView();

    public:
    FragmentationDlg(SequenceEditorWnd *editorWnd, Polymer *polymer,
                     const PolChemDef * polChemDef,
                     const QString &    configSettingsFilePath,
                     const CalcOptions &calcOptions,
                     const msXpSlibmass::IonizeRule * ionizeRule);

    ~FragmentationDlg();

    bool initialize();

    bool populateSelectedOligomerData();
    void populateFragSpecList();

    void updateFragmentationDetails(const CalcOptions &);
    void updateOligomerSequence(QString *);

    bool calculateTolerance(double);

    // The results-exporting functions. ////////////////////////////////
    void prepareResultsTxtString();
    bool exportResultsClipboard();
    bool exportResultsFile();
    bool selectResultsFile();
    //////////////////////////////////// The results-exporting functions.

    public slots:
    void fragment();
    void exportResults(int);
    void filterOptions(bool);
    void filterOptionsToggled();
    void filterPattern();
    void filterMonoMass();
    void filterAvgMass();
    void filterCharge();
  };

} // namespace msXpSmassXpert


#endif // FRAGMENTATION_DLG_HPP
