/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */


#pragma once


/////////////////////// Qt includes
#include <QObject>
#include <QList>


/////////////////////// Local includes
#include "MassSpectrum.hpp"

namespace msXpSlibmass
{


	//! The MassSpectrumList class provides a list of MassSpectrum instances.
	/*!

		The list implementation is based on QList and the items that are in the list
		are heap-allocated MassSpectrum instance pointers.

*/
	class MassSpectrumList 
		: 
			public QObject,
			public QList<MassSpectrum *>
	{
		Q_OBJECT

		private:
			//! Title of the MassSpectrumList.
			QString m_title;

		public: 

			MassSpectrumList();
			MassSpectrumList(const QString &title);
			MassSpectrumList(const QList<MassSpectrum *> &massSpectra);
			virtual ~MassSpectrumList();

			void deleteSpectra();
			void deleteMassPeaks();

			QString title() const;

			void mzMinMax(double *minMz, double *maxMz) const;
			bool areSpectraSameLength() const;

			double tic();
			double tic(double mzStart, double mzEnd);
			static double tic(const MassSpectrumList &massSpectra);
	};


} // namespace msXpSlibmass



