/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
*/


#pragma once


#include <QString>
#include <QProgressBar>
#include <QLabel>

#include "globals.hpp"
#include "ConsoleWnd.hpp"


namespace msXpSmineXpert
{


	class FeedbackLogger : public QObject
	{
		Q_OBJECT;

		public:

		QString m_baseMsg= "NOT_SET";
		QString m_currentMsg = "NOT_SET";

		QVariant m_currentValue = 0;
		QVariant m_rangeStart = 0;
		QVariant m_rangeEnd = 0;

		int m_decimals = 6;
		char m_realFormat = 'f';

		int m_logType = LogType::LOG_TO_CONSOLE;

		QProgressBar *mp_progressBar = Q_NULLPTR;
		QLabel *mp_statusBarLabel = Q_NULLPTR;
		ConsoleWnd *mp_consoleWnd = Q_NULLPTR;

		FeedbackLogger();
		virtual ~FeedbackLogger();

		QString formattedString(const QString &formatString);

		QString setBaseMsg(const QString &formatstring);

		void feedback(const QString &formatString);
		void feedback(const QString &formatString, QVariant rangeStart, QVariant rangeEnd, QVariant currentValue);
		void feedback(const QString &formatString, QVariant currentValue);


	};


} // namespace msXpSmineXpert
