/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */


#include "FeedbackLogger.hpp"



namespace msXpSmineXpert
{


	FeedbackLogger::FeedbackLogger()
	{

	}


	FeedbackLogger::~FeedbackLogger()
	{
	}


	QString
		FeedbackLogger::formattedString(const QString &formatString)
		{
			// We get a format and we need to convert that into a string.
			// %b : base message
			// %c : current message
			// %v : current value
			// %s : range start
			// %e : range end.

			QString formattedString;

			QChar prevChar = ' ';

			for(int iter = 0; iter < formatString.size(); ++iter)
			{
				QChar curChar = formatString.at(iter);

				// qDebug() << __FILE__ << __LINE__
				// << "Current char:" << curChar;

				if(curChar == '\\')
				{
					if(prevChar == '\\')
					{
						formattedString += '\\';
						prevChar = ' ';
						continue;
					}
					else
					{
						prevChar = '\\';
						continue;
					}
				}

				if(curChar == '%')
				{
					if(prevChar == '\\')
					{
						formattedString += '%';
						prevChar = ' ';
						continue;
					}
					else
					{
						prevChar = '%';
						continue;
					}
				}

				if(curChar == 'n')
				{
					if(prevChar == '\\')
					{
						formattedString += QString("\n");

						// Because a newline only works if it is followed by something, and
						// if the user wants a termination newline, then we need to
						// duplicate that new line char if we are at the end of the string.

						if(iter == formatString.size() - 1)
						{
							// This is the last character of the line, then, duplicate
							// the
							// newline so that it actually creates a new line in the
							// text.

							formattedString += QString("\n");
						}

						prevChar = ' ';
						continue;
					}
				}

				if(prevChar == '%')
				{
					// The current character might have a specific signification.
					if(curChar == 'b')
					{
						formattedString += m_baseMsg;
						prevChar = ' ';
						continue;
					}
					if(curChar == 'c')
					{
						formattedString += m_currentMsg;
						prevChar = ' ';
						continue;
					}
					if(curChar == 'v')
					{
						if(m_currentValue.type() == QVariant::String)
							formattedString += m_currentValue.toString();

						if(m_currentValue.type() == QVariant::Int)
							formattedString += m_currentValue.toInt();

						if(m_currentValue.type() == QVariant::Double)
						{
							formattedString += QString("%1").arg(m_currentValue.toDouble(), 0, m_realFormat, m_decimals);
						}

						prevChar = ' ';
						continue;
					}
					if(curChar == 's')
					{
						if(m_rangeStart.type() == QVariant::String)
							formattedString += m_rangeStart.toString();

						if(m_rangeStart.type() == QVariant::Int)
							formattedString += m_rangeStart.toString();

						if(m_rangeStart.type() == QVariant::Double)
							formattedString += QString("%1").arg(m_rangeStart.toDouble(), 0, m_realFormat, m_decimals);

						prevChar = ' ';
						continue;
					}
					if(curChar == 'e')
					{
						if(m_rangeEnd.type() == QVariant::String)
							formattedString += m_rangeEnd.toString();

						if(m_rangeEnd.type() == QVariant::Int)
							formattedString += m_rangeEnd.toString();

						if(m_rangeEnd.type() == QVariant::Double)
							formattedString += QString("%1").arg(m_rangeEnd.toDouble(), 0, m_realFormat, m_decimals);

						prevChar = ' ';
						continue;
					}

					// At this point the '%' is not followed by any special character
					// above, so we skip them both from the text. If the '%' is to be
					// printed, then it needs to be escaped.

					continue;
				}
				// End of
				// if(prevChar == '%')

				// The character prior this current one was not '%' so we just append
				// the current character.
				formattedString += curChar;
			}
			// End of
			// for (int iter = 0; iter < pattern.size(); ++iter)

			return formattedString;
		}


	QString
		FeedbackLogger::setBaseMsg(const QString &formatString)
		{
			m_baseMsg = formattedString(formatString);

			return m_baseMsg;
		}


	void 
		FeedbackLogger::feedback(const QString &formatString)
		{
		}


	void 
		FeedbackLogger::feedback(const QString &formatString, QVariant rangeStart, QVariant rangeEnd, QVariant currentValue)
		{
		}


	void 
		FeedbackLogger::feedback(const QString &formatString, QVariant currentValue)
		{

		}


} // namespace msXpSmineXpert
