#!/bin/sh

usage()
{
	echo "	Usage:"
	echo ""
	echo "	This program updates the TuxFamily site with the new windows"
	echo "  Innosetup-generated setup executable file"
	echo ""
	echo "  This program works when run from the top source directory"
	echo "  and in the windows environment." 
	echo ""
	echo "	Simply answer the questions."
}

if [ "$1" = "-h" ] || [ "$1" = "--help" ] || [ "$1" = "?" ]
then
	usage
	exit
fi

if [ ! -d "minexpert" ] || [ ! -d "massxpert" ]
then
	echo "Not in top source directory: no minexpert or massxpert directory."
	exit 1
fi

projectName="msxpertsuite"

winInstallerDir="winInstaller"

UPVER=$(cat CMakeLists.txt | grep 'set(VERSION' | \
	sed 's/^.*set.VERSION.*\([0-9]\.[0-9]\.[0-9]\).*$/\1/')

winSetupFile=msXpertSuite-mingw64-win7+-v${UPVER}-setup.exe

echo "Uploading ${winSetupFile}"
echo ""
echo "Is this correct? Ctrl-C to stop process. Return to accept"
read answer
echo "Going on, then."

command="rsync -av --no-o --no-g ${winInstallerDir}/${winSetupFile} \
 	rusconi@ssh.tuxfamily.org:~/msxpertsuite/msxpertsuite-repository/mswindows"

echo ${command}

eval ${command}

exitStatus=$?
printf "exit status: ${exitStatus}\n"
exit ${exitStatus}

