/*
 * Copyright (C) Jan 2013 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/***
 *** This file was generated at "2015-06-17 12:05:31"
 *** by:
 ***    > /mswg/release/eat_me/last_release/adabe_plugins/adb2c/adb2pack.py --input adb/connectib/connectib.adb --file-prefix connectib --prefix connectib_
 ***/
#ifndef CONNECTIB_LAYOUTS_H
#define CONNECTIB_LAYOUTS_H


#ifdef __cplusplus
extern "C" {
#endif

#include "adb_to_c_utils.h"/* Description -   */
/* Size in bytes - 4 */
struct connectib_dw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t dw;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_nvlog {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t sub_class;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_eswitch {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0.16 - 0.17 */
	 u_int8_t port;
	/* Description -  */
	/* 0.18 - 0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_per_host {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.9 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0.10 - 0.17 */
	 u_int8_t function;
	/* Description -  */
	/* 0.18 - 0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_bmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.12 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0.13 - 0.17 */
	 u_int8_t channel;
	/* Description -  */
	/* 0.18 - 0.23 */
	 u_int8_t host;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_physical_port {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t parameter_index;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t port;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_type_global {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t parameter_index;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t class_;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_uint64 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t hi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t lo;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_dcr_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t gb_first_psn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t gb_last_psn;
	/* Description -  */
	/* 4.24 - 4.24 */
	 u_int8_t is_gb;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t reconnect_ack_psn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - tells when DCR cleanup turned off the heartbeat of this DCR */
	/* 12.0 - 16.31 */
	 u_int32_t dcr_heartbeat_clr_timestamp;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_regular_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Counter for retries (FW attempts recovery) on DS_EXCEEDS_PI error. this is a WA for and ordering issue seen with recovery DBs getting wrong PI */
	/* 0.0 - 0.3 */
	 u_int8_t ds_exceeds_pi_retries;
	/* Description - 0 - idle, 1 - pending, 2- armed */
	/* 0.4 - 0.5 */
	 u_int8_t dc_access_key_violation_count_state;
	/* Description - automatic path migration state
    APM_STATE_ARMED = 0x0,
    APM_STATE_REARM = 0x1,
    APM_STATE_MIGRATED = 0x3
 */
	/* 0.6 - 0.7 */
	 u_int8_t pm_state;
	/* Description - is current requester retransmission first wqe rdma read */
	/* 0.10 - 0.10 */
	 u_int8_t req_retrans_is_rdma_read;
	/* Description - issi=1 and old user lib, getting user_index=ffffff from sw */
	/* 0.11 - 0.11 */
	 u_int8_t invalid_user_index;
	/* Description -  */
	/* 0.16 - 0.19 */
	 u_int8_t xport_retry_counter;
	/* Description -  */
	/* 0.20 - 0.23 */
	 u_int8_t xport_retry_limit;
	/* Description -  */
	/* 0.24 - 0.27 */
	 u_int8_t rnr_retry_counter;
	/* Description -  */
	/* 0.28 - 4.31 */
	 u_int8_t rnr_retry_limit;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - points to head qp that holds the rq state */
	/* 4.0 - 4.23 */
	 u_int32_t rq_head_qpn;
	/* Description - indicate command is waiting. indicate the slot num. */
	/* 4.24 - 8.31 */
	 u_int8_t cmdif_entry_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t dc_access_key_violation_count;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t sw_uar;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_schedint_cause {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t clear_all_causes;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t schedint_destroy_qp;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t schedint_qp_flush;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t schedint_apm;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t schedint_duplicate;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t schedint_ud_sl_diff;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_msix_context_data0 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_generic_headers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.28 - 4.31 */
	 u_int8_t dword_select_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t dword_select;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_port {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t port;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t grh;
	/* Description -  */
	/* 0.13 - 0.13 */
	 u_int8_t bth;
	/* Description -  */
	/* 0.14 - 0.15 */
	 u_int8_t qp_type;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t force_lb;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t func_lb;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t multicast;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_source_gvmi_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t source_gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t source_qp;
	/* Description -  */
	/* 4.24 - 4.24 */
	 u_int8_t source_is_requestor;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l4 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t dest_qp;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t pkey;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l3 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   */
	/* 0.0 - 4.31 */
	 u_int32_t dgid_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -   */
	/* 4.0 - 8.31 */
	 u_int32_t dgid_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -   */
	/* 8.0 - 12.31 */
	 u_int32_t dgid_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -   */
	/* 12.0 - 16.31 */
	 u_int32_t dgid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l3_extended {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.19 */
	 u_int32_t flow_label;
	/* Description -  */
	/* 0.20 - 0.23 */
	 u_int8_t sl;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t traffic_class;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t pkey;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t dceth_complete;
	/* Description -  */
	/* 4.29 - 4.29 */
	 u_int8_t deth_complete;
	/* Description -  */
	/* 4.30 - 4.30 */
	 u_int8_t bth_complete;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t ip_version;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 8.0 - 12.31 */
	 u_int32_t qkey_dc_access_key_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 12.0 - 16.31 */
	 u_int32_t qkey_dc_access_key_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_ib_l2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t dlid;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t grh;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t bth;
	/* Description -  */
	/* 0.18 - 0.19 */
	 u_int8_t qp_type;
	/* Description -  */
	/* 0.20 - 0.23 */
	 u_int8_t sl;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t multicast;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.19 */
	 u_int32_t flow_label;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t rwh_ethertype;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_ste_tag_bulk {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   */
	/* 0.0 - 4.31 */
	 u_int32_t tag_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -   */
	/* 4.0 - 8.31 */
	 u_int32_t tag_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -   */
	/* 8.0 - 12.31 */
	 u_int32_t tag_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -   */
	/* 12.0 - 16.31 */
	 u_int32_t tag_31_0;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_transaction_pdf {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.17 - 0.17 */
	 u_int8_t invert_data_bits;
	/* Description - NO_DESCR */
	/* 0.18 - 0.18 */
	 u_int8_t swap_data_bits;
	/* Description - NO_DESCR */
	/* 0.19 - 0.19 */
	 u_int8_t seed;
	/* Description - NO_DESCR */
	/* 0.20 - 0.20 */
	 u_int8_t swap_crc_bytes;
	/* Description - NO_DESCR */
	/* 0.21 - 0.21 */
	 u_int8_t swap_crc_bits;
	/* Description - NO_DESCR */
	/* 0.22 - 0.22 */
	 u_int8_t invert_crc;
	/* Description - NO_DESCR */
	/* 0.23 - 0.23 */
	 u_int8_t sig_zones_covered;
	/* Description - NO_DESCR */
	/* 0.24 - 4.31 */
	 u_int8_t sig_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_pdf_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.17 - 0.17 */
	 u_int8_t invert_data_bits;
	/* Description - NO_DESCR */
	/* 0.18 - 0.18 */
	 u_int8_t swap_data_bits;
	/* Description - NO_DESCR */
	/* 0.19 - 0.19 */
	 u_int8_t seed;
	/* Description - NO_DESCR */
	/* 0.20 - 0.20 */
	 u_int8_t swap_crc_bytes;
	/* Description - NO_DESCR */
	/* 0.21 - 0.21 */
	 u_int8_t swap_crc_bits;
	/* Description - NO_DESCR */
	/* 0.22 - 0.22 */
	 u_int8_t invert_crc;
	/* Description - NO_DESCR */
	/* 0.23 - 0.23 */
	 u_int8_t regular;
	/* Description - NO_DESCR */
	/* 0.24 - 4.31 */
	 u_int8_t sig_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 4.15 */
	 u_int16_t dif_app_tag_bit_check_en;
	/* Description - NO_DESCR */
	/* 4.16 - 4.17 */
	 u_int8_t dif_guard_check_type;
	/* Description - NO_DESCR */
	/* 4.18 - 4.19 */
	 u_int8_t dif_learn_mode;
	/* Description - NO_DESCR */
	/* 4.20 - 4.20 */
	 u_int8_t dif_learn_app_tag;
	/* Description - NO_DESCR */
	/* 4.21 - 4.21 */
	 u_int8_t dif_learn_ref_tag;
	/* Description - NO_DESCR */
	/* 4.22 - 4.22 */
	 u_int8_t dif_inc_ref_tag;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_serdes_conf_tx_set_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.6 */
	 u_int8_t ob_preemp_pre;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t pre_polarity;
	/* Description -  */
	/* 0.8 - 0.14 */
	 u_int8_t ob_preemp_post;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t post_polarity;
	/* Description -  */
	/* 0.16 - 0.22 */
	 u_int8_t ob_preemp_main;
	/* Description -  */
	/* 0.23 - 0.23 */
	 u_int8_t main_polarity;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t preemp_mode;
	/* Description -  */
	/* 0.26 - 0.29 */
	 u_int8_t ob_bias;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_serdes_conf_rx_set_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t slicer_ind_en;
	/* Description -  */
	/* 0.8 - 0.11 */
	 u_int8_t slicer1_enable;
	/* Description -  */
	/* 0.12 - 0.15 */
	 u_int8_t slicer2_enable;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t ffe_tap0;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t ffe_tap1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t ffe_tap2;
	/* Description -  */
	/* 4.8 - 4.15 */
	 u_int8_t ffe_tap3;
	/* Description -  */
	/* 4.16 - 4.23 */
	 u_int8_t ffe_tap4;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_aba_index {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.5 */
	 u_int8_t aba_index0_start;
	/* Description -  */
	/* 0.6 - 0.11 */
	 u_int8_t aba_index0_end;
	/* Description -  */
	/* 0.12 - 0.17 */
	 u_int8_t aba_index0;
	/* Description -  */
	/* 0.18 - 0.23 */
	 u_int8_t aba_index1_start;
	/* Description -  */
	/* 0.24 - 0.29 */
	 u_int8_t aba_index1_end;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.5 */
	 u_int8_t aba_index1;
	/* Description -  */
	/* 4.6 - 4.11 */
	 u_int8_t aba_index2_start;
	/* Description -  */
	/* 4.12 - 4.17 */
	 u_int8_t aba_index2_end;
	/* Description -  */
	/* 4.18 - 4.23 */
	 u_int8_t aba_index2;
	/* Description -  */
	/* 4.24 - 4.29 */
	 u_int8_t aba_index3_start;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.5 */
	 u_int8_t aba_index3_end;
	/* Description -  */
	/* 8.6 - 8.11 */
	 u_int8_t aba_index3;
	/* Description -  */
	/* 8.12 - 8.17 */
	 u_int8_t aba_index4_start;
	/* Description -  */
	/* 8.18 - 8.23 */
	 u_int8_t aba_index4_end;
	/* Description -  */
	/* 8.24 - 8.29 */
	 u_int8_t aba_index4;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.5 */
	 u_int8_t aba_index5_start;
	/* Description -  */
	/* 12.6 - 12.11 */
	 u_int8_t aba_index5_end;
	/* Description -  */
	/* 12.12 - 12.17 */
	 u_int8_t aba_index5;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_nv_tlv_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_global global;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_physical_port physical_port;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_bmc bmc;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_per_host per_host;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_eswitch eswitch;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_type_nvlog nvlog;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_dw as_dw;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_register_access_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Real size can be larger than 0x20. Size is extracted from TLV */
	/* 0.0 - 32.31 */
	 u_int32_t dword[8];
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_tlv_hdr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size of configuration item data in bytes (not including header). Must be between 0 and 256 */
	/* 0.0 - 0.8 */
	 u_int16_t length;
	/* Description - 0-FW writes the configuration item directly to persistent storage.
1-FW writes the configuration item to a temporary non-persistent area, until an NVCT (non-volatile commit) operation is called */
	/* 0.11 - 0.11 */
	 u_int8_t shadow;
	/* Description - Configuration item version - defines the data structure following the header (together with the type field). See configuration items definitions */
	/* 0.12 - 0.15 */
	 u_int8_t version;
	/* Description - Controls the read operation of non-FW entities.
0 - TLV can be read.
1 - TLV cannot be read */
	/* 0.23 - 0.23 */
	 u_int8_t rd_en;
	/* Description - Enables overwriting a TLV by lower priorities.
00 - Only written during equal or higher priority.
01 - Allowed to be over-written by the next level priority.
10 - Allowed to be overwritten at any stage */
	/* 0.24 - 0.25 */
	 u_int8_t ovr_en;
	/* Description - Encodes the storage element Header Format
00 - Only Header is protected by CRC
01 - Header and Data are protected by CRC
10 - reserved
11 - reserved */
	/* 0.26 - 0.27 */
	 u_int8_t header_type;
	/* Description - Defines the allowed access to the data element
00 - Written only during Mellanox production stage
01 - Written during Mellanox production and OEM production stage
10 - written at any stage
11 - Reserved */
	/* 0.28 - 0.29 */
	 u_int8_t priority;
	/* Description - Encodes the data element validity
11 - Free (no data esists)
10 - Valid data
00 - Invalidated data element, should be skipped
01 - Illegal, treated as Invalidated data element */
	/* 0.30 - 4.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Configuration item type */
	/* 4.0 - 8.31 */
	 u_int32_t type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Encodes the data integrity check of the data element.
Note: in some elements only encodes the header into the CRC16, as defined in the header type field */
	/* 8.0 - 8.15 */
	 u_int16_t crc16;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_mfba_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0.4 - 0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0.8 - 0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Transaction size */
	/* 4.0 - 4.8 */
	 u_int16_t size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 8.0 - 8.23 */
	 u_int32_t address;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_ref_count {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.27 */
	 u_int32_t ref_counter;
	/* Description - 0x0 - not valid, 0x1 - valid, 0x2 - valid qp, 0x3 - valid sq, 0x4 - valid rq, 0x5 - valid srq, 0x6 - valid rmp, 0x7 - valid tip, 0x8 valid dct */
	/* 0.28 - 4.31 */
	 u_int8_t ref_valid_cre_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_tir_dmfs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - resource index of the head STE of TIR context */
	/* 0.0 - 8.31 */
	 u_int64_t ste_ix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_rx_hash_field_select {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bitmask which sets which packets headers fields should be 
selected for RX Hash.
Each bit represents a field as described below
0: SRC_IP
1: DST_IP
2: L4_SPORT
3: L4_DPORT
4: IPSEC_SPI
5-29: reserved
Only packets which contain the enabled fields can be delivered 
to that TIR, this must be done with proper Flow Table rules.
For example if L4_SPORT is enabled and l4_protocol_type == 
TCP only TCP packets are allowed to reach this TIR.
Notice that if this field refers to tunneling packets only tunneling 
packets with proper inner headers are allowed to reach this TIR. */
	/* 0.0 - 0.29 */
	 u_int32_t selected_fields;
	/* Description - This field sets the L4 protocol type (TCP or UDP) L4_SPORT 
and L4_DPORT fields refer to:
0: TCP
1: UDP
If both L4_SPORT and L4_DPORT are disabled this field is 
ignored and it doesn't impact the RX hash behavior. */
	/* 0.30 - 0.30 */
	 u_int8_t l4_prot_type;
	/* Description - This field sets the L3 protocol type (IPv4 or IPv6) SRC_IP and 
DST_IP fields refer to:
0: IPv4
1: IPv6
If both SRC_IP and DST_IP are disabled this field is ignored and 
it doesn't impact the RX hash behavior. */
	/* 0.31 - 4.31 */
	 u_int8_t l3_prot_type;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_fw_qpc_special {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_regular_qp regular_qp;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_dcr_qp dcr_qp;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_qpc_q {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -   FW_QP_STATE_RESET     = 0,
  FW_QP_STATE_INIT      = 1,
  FW_QP_STATE_RTR_UNUSED       = 2,
  FW_QP_STATE_RTS_UNUSED       = 3,
  FW_QP_STATE_SQER_UNUSED      = 4,
  FW_QP_STATE_SQD_UNUSED       = 5,
  FW_QP_STATE_ERR       = 6,
  FW_QP_STATE_DRAINING_UNUSED  = 7,
  FW_QP_STATE_BUSY_UNUSED      = 8,
  FW_QP_STATE_SUSPENDED_UNUSED = 9,
  FW_QP_STATE_READY     = 10,
  FW_QP_STATE_FLUSHING  = 11,
  FW_QP_STATE_CHILLING  = 12,
  FW_QP_STATE_NACK      = 13
 */
	/* 0.0 - 0.7 */
	 u_int8_t qp_state;
	/* Description -  */
	/* 0.8 - 0.15 */
	 struct connectib_schedint_cause schedint_cause;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t sxdc_valid;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t qpc_valid;
	/* Description - relevant for DCT only. DCT_CLEANUP_IDLE = 0
 DCT_CLEANUP_DCRS_NOT_FOUND = 1
 DCT_CLEANUP_DCRS_FOUND = 2 */
	/* 0.18 - 0.19 */
	 u_int8_t dct_cleanup_state;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t qp_in_linked_list;
	/* Description -  */
	/* 0.21 - 0.21 */
	 u_int8_t cmdif_awaiting;
	/* Description - kill qp arbiter was disabled as part of duplicate_sx_flush flow */
	/* 0.22 - 0.22 */
	 u_int8_t dup_sx_flush_kill_qp_arb_disabled;
	/* Description -  */
	/* 0.23 - 0.23 */
	 u_int8_t broken_wq_buffer;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t broken_cq;
	/* Description -  */
	/* 0.25 - 0.25 */
	 u_int8_t catas_event_generated;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t last_wqe_event_generated;
	/* Description -  */
	/* 0.27 - 0.27 */
	 u_int8_t async_event_generated;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t flushed_in_error;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t disable_flushed_in_error;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t vendor_syndrome;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t hw_syndrome;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.4 */
	 u_int8_t trap_reason;
	/* Description - for DCR cleanup */
	/* 12.5 - 12.5 */
	 u_int8_t connect_sent_to_ctrl_dct;
	/* Description - QP generated all needed events, or does need to */
	/* 12.6 - 12.6 */
	 u_int8_t needed_events_generated;
	/* Description - requester only */
	/* 12.7 - 12.7 */
	 u_int8_t rx_progress_after_retry;
	/* Description - used in responder only */
	/* 12.8 - 12.11 */
	 u_int8_t retransmission_state;
	/* Description -  */
	/* 12.12 - 12.12 */
	 u_int8_t rx_fault_event_fired;
	/* Description -  */
	/* 12.13 - 12.13 */
	 u_int8_t rx_progress_after_fault;
	/* Description -  */
	/* 12.14 - 12.14 */
	 u_int8_t sx_fault_event_fired;
	/* Description -  */
	/* 12.15 - 12.15 */
	 u_int8_t sx_progress_after_fault;
	/* Description - (fw_trap_reason = SET_LIMIT) -> limit value */
	/* 12.16 - 16.31 */
	 u_int16_t trap_data;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_hw_msix_context_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_hw_msix_context_data0 regular;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_steering_qp_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t qp_number;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t force_responder;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_hw_ste_tag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_bulk bulk;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_ib_l2 ibl2;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_ib_l3_extended ibl3_extended;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_ib_l3 ibl3;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_ib_l4 ibl4;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_source_gvmi_qp source_gvmi_qp;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_port port;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_ste_tag_generic_headers generic_headers;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_hw_pdf_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_pdf_decoder pdf_decoder;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_transaction_pdf transaction_pdf;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pf_vf_vpd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.16 - 0.30 */
	 u_int16_t vpd_address;
	/* Description - NO_DESCR */
	/* 0.31 - 4.31 */
	 u_int8_t F;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t vpd_data;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_pf_vf_sriov {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.0 */
	 u_int8_t vf_enable;
	/* Description - RO */
	/* 0.1 - 0.1 */
	 u_int8_t vf_migration_en;
	/* Description - RO */
	/* 0.2 - 0.2 */
	 u_int8_t vf_migration_int_en;
	/* Description - NO_DESCR */
	/* 0.3 - 0.3 */
	 u_int8_t vf_mse;
	/* Description - NO_DESCR */
	/* 0.4 - 0.4 */
	 u_int8_t ari_capable_hierarchy;
	/* Description - log value of system page size mask. no need to store more than 1 bit */
	/* 0.8 - 0.12 */
	 u_int8_t log_system_page_size;
	/* Description - number of vfs in this sr */
	/* 0.16 - 0.25 */
	 u_int16_t num_vfs;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - just a place holder */
	/* 4.0 - 8.31 */
	 u_int32_t not_in_use;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_serdes_conf_preset_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_serdes_conf_tx_set_ini set[16];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_serdes_active_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_serdes_conf_tx_set_ini set[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_serdes_active_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_serdes_conf_rx_set_ini set[4];
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_serdes_force_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 40.31 */
	 struct connectib_serdes_conf_tx_set_ini set[10];
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_serdes_force_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 80.31 */
	 struct connectib_serdes_conf_rx_set_ini set[10];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_serdes_conf_aba_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_serdes_conf_tx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_serdes_conf_aba_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_serdes_conf_rx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_serdes_conf_autoneg_tx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_serdes_conf_tx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_serdes_conf_autoneg_rx_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_serdes_conf_rx_set_ini set[32];
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_aba_indexes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_aba_index encode_64_66;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - node is not in use, exist only for future demand */
	/* 16.0 - 32.31 */
	 struct connectib_aba_index encode_8_10;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 48.31 */
	 struct connectib_aba_index encode_8_10_legacy;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_serdes_param_mask_per_proto_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rx;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_dmfs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - FW hash meta index to be delivered for DMFS garbage collection */
	/* 0.0 - 4.31 */
	 u_int32_t gc_hash_meta_ix;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - last flow destination that its ref_count was increased (for rollback) */
	/* 4.0 - 4.15 */
	 u_int16_t copied_dest_ctr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - HW STE index to be removed */
	/* 8.0 - 16.31 */
	 u_int64_t dealloc_ste_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 u_int64_t ft_hw_ix;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t ft_fw_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_create_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t mtt_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t num_mtts;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t num_psv;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t num_alloced_psv;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t pd;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 u_int32_t psv_ix[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_mcg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t mcg_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t gid_msb;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 u_int64_t gid_lsb;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t port_0_1;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_rmp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t bitmask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t lwm;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_arm_rq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t lwm;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_mkey {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t hw_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t fw_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t octoword_actual_size_mtt;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_cq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t mtt_ix;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t producer_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.0 */
	 u_int8_t cqe_128b_size;
	/* Description -  */
	/* 12.1 - 12.5 */
	 u_int8_t log2_size;
	/* Description -  */
	/* 12.6 - 12.10 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 12.11 - 12.16 */
	 u_int8_t cq_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t fence_slice;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_cq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t fw_addr;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_eq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t fw_eqc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t hw_eqc_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 u_int64_t event_bitmask;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t hw_eqn;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_rqt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rqt_fw_data_ix;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t rqt_hw_data_ix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - for rollback */
	/* 12.0 - 16.31 */
	 u_int32_t num_rqs_to_dec;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.16 - 20.31 */
	 u_int16_t rqt_max_size;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.15 */
	 u_int16_t rqt_actual_size;
	/* Description - only for modify_rqt */
	/* 20.16 - 24.31 */
	 u_int16_t rqt_actual_size_old;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - only for modify_rqt */
	/* 24.0 - 28.31 */
	 u_int32_t rqt_fw_data_ix_old;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_srq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t fw_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t srqi;
	/* Description -  */
	/* 8.31 - 12.31 */
	 u_int8_t cont_srq;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t pas_offset;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_rq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t fw_qpc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t no_lro_qpn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - copy of hca_params->log_max_qp */
	/* 12.0 - 12.4 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 12.8 - 12.11 */
	 u_int8_t wq_type;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create_qp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t fw_qpc_addr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t qpi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - copy of hca_params->log_max_qp */
	/* 12.0 - 12.4 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 12.5 - 12.5 */
	 u_int8_t is_dci;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_modify_tir {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t bitmask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t ste_ix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.23 */
	 u_int32_t rqt_number;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.23 */
	 u_int32_t old_rqt_number;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.23 */
	 u_int32_t inline_rqn;
	/* Description -  */
	/* 24.24 - 24.27 */
	 u_int8_t disp_type;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_cmdif_ctx_special_create {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t num_mapped_mtts;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_flush_type_bitmask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t dword;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_flush_type_bits {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t mkey_flush;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t qp_s_flush;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t qp_r_flush;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t rx_flush;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_project_nvqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Configuration item type */
	/* 0.0 - 4.31 */
	 union connectib_nv_tlv_type type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t support_rd;
	/* Description -  */
	/* 4.1 - 4.1 */
	 u_int8_t support_wr;
	/* Description -  */
	/* 4.4 - 4.7 */
	 u_int8_t version;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_project_nvda {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 12.31 */
	 struct connectib_nv_tlv_hdr tlv_header;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 44.31 */
	 struct connectib_register_access_data nvda_data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pmtu_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number. */
	/* 0.16 - 0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Maximum MTU supported on the port (Read Only).
MTU depends on the port type. When port type (Eth/IB/FC) is configured, 
the relevant MTU is reported. When the port type is not configured, the 
minimum between the 
max_mtu
 for the different types (Eth/IB/FC) is 
reported. */
	/* 4.16 - 8.31 */
	 u_int16_t max_mtu;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Administratively configured MTU on the port. Must be smaller or equal to 
max_mtu
. */
	/* 8.16 - 12.31 */
	 u_int16_t admin_mtu;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Operational MTU. This is the actual MTU configured on the ports. Packets 
exceeding this size will be dropped.
Note: In Ethernet or FC, 
oper_mtu
 is equal to 
admin_mtu
. In InfiniBand, 
the actual operational MTU is reported which may be smaller than 
admin_mtu
. */
	/* 12.16 - 16.31 */
	 u_int16_t oper_mtu;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_pamp_reg {
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_slrg_reg {
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_ptas_reg {
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_sltp_reg {
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_slrp_reg {
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_paos_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Port operational state:
0001 - up
0010 - down
0100 - down by port failure (transitioned by the hardware) */
	/* 0.0 - 0.3 */
	 u_int8_t oper_status;
	/* Description - Port administrative state (the desired state of the interface):
0001 - up
0010 - down by configuration
0011 - up once - if the port goes up and then down, the operational 
status should go to "down by port failure" and can only go back 
up upon explicit command
0100 - disabled by system - this mode can not be set by the soft
ware, only by the hardware. */
	/* 0.8 - 0.11 */
	 u_int8_t admin_status;
	/* Description - Local port number. */
	/* 0.16 - 0.23 */
	 u_int8_t local_port;
	/* Description - For HCA : must be always 0.
Switch partition ID with which to associate the port.
Switch partitions are numbered from 0 to 7 inclusively.
The 
swid
 field is only valid when the 
local_port
 is the router port. 
In this case, the 
swid
 indicates which of the router ports to config
ure/query. */
	/* 0.24 - 4.31 */
	 u_int8_t swid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Event generation on operational state change:
00 - Do not generate event
01 - Generate Event 
10 - Generate Single Event */
	/* 4.0 - 4.1 */
	 u_int8_t e;
	/* Description - Event update enable. If this bit is set, event generation will be 
updated based on the 
e
 field. Only relevant on Set operations. */
	/* 4.30 - 4.30 */
	 u_int8_t ee;
	/* Description - Admin state update enable. If this bit is set, admin state will be 
updated based on 
admin_state
 field. Only relevant on Set() opera
tions. */
	/* 4.31 - 8.31 */
	 u_int8_t ase;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_mjtag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - JTAG transaction length */
	/* 0.0 - 0.7 */
	 u_int8_t size;
	/* Description - Command Sequence Number */
	/* 0.24 - 0.27 */
	 u_int8_t sequence_number;
	/* Description - Master JTAG Interface: 00:Disable; 01:Enable; 10: Access */
	/* 0.30 - 4.31 */
	 u_int8_t cmd;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Transactions */
	/* 4.0 - 44.31 */
	 u_int32_t dword[10];
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_mfbe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0.4 - 0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0.8 - 0.8 */
	 u_int8_t p;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address in bytes */
	/* 8.0 - 8.23 */
	 u_int32_t address;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_project_mfba {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 12.31 */
	 struct connectib_mfba_header mfba_header;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 44.31 */
	 struct connectib_register_access_data mfba_data;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_register_misc_counters {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - When performing a WRITE operation - , the counter select bitmask deter
mines which registers are set:
Bit 0 - ECC
Bit 1 - LDB silent drop */
	/* 4.0 - 8.31 */
	 u_int32_t counter_select;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Counts number of arrays which encountered a bit error */
	/* 12.0 - 16.31 */
	 u_int32_t ecc;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Counts number of packets silently dropped due to LDB error */
	/* 16.0 - 20.31 */
	 u_int32_t ldb_silent_drop;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_mtmp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Sensors index to access */
	/* 0.0 - 0.6 */
	 u_int8_t sensor_index;
	/* Description - query the internal diodes */
	/* 0.31 - 4.31 */
	 u_int8_t internal_diodes_query;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Temperature reading from the sensor. Reading in 0.125 Celsius degrees. */
	/* 4.0 - 4.15 */
	 u_int16_t temperature;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The highest measured temperature from the sensor. */
	/* 8.0 - 8.15 */
	 u_int16_t max_temperture;
	/* Description - Max Temperature Reset - clears the value of the max temperature register */
	/* 8.30 - 8.30 */
	 u_int8_t mtr;
	/* Description - Max Temperature Enable - enables measuring the max temperature on a sensor */
	/* 8.31 - 12.31 */
	 u_int8_t mte;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - If the sensor temperature measurement is above the threshold (and events are enabled), an event
will be generated */
	/* 12.0 - 12.15 */
	 u_int16_t temperature_threshold_hi;
	/* Description - Temperature Event Enable
00 - Do not generate event
01 - Generate Event
10 - Generate single event */
	/* 12.30 - 16.31 */
	 u_int8_t tee;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.15 */
	 u_int16_t temperature_threshold_lo;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t name_lo;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t name_hi;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_mfrl {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - on Read, required reset level. On write, minimum requested reset level
 0-Full ISFU
 1-Driver down but link is up
 2-driver and link down
 3-driver down, link down pci disable/enable
 7-server warm reboot
 8-server cold reboot */
	/* 4.0 - 4.7 */
	 u_int8_t reset_level;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_register_mfai {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t address;
	/* Description - if set make image permamnent */
	/* 0.29 - 0.29 */
	 u_int8_t permanent;
	/* Description - if set use address */
	/* 0.30 - 0.30 */
	 u_int8_t use_address;
	/* Description - if set use image id and not address */
	/* 0.31 - 4.31 */
	 u_int8_t use_image_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t image_id;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_mfpa {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Flash Select */
	/* 0.4 - 0.5 */
	 u_int8_t fs;
	/* Description - Parallel */
	/* 0.8 - 0.8 */
	 u_int8_t p;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - address in bytes */
	/* 4.0 - 4.23 */
	 u_int32_t boot_address;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - number of flash devices connected */
	/* 16.0 - 16.3 */
	 u_int8_t flash_num;
	/* Description - reflection of wip bit from flash */
	/* 16.31 - 20.31 */
	 u_int8_t wip;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Flash JEDEC ID */
	/* 20.0 - 20.23 */
	 u_int32_t jedec_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Flash sectore size */
	/* 24.0 - 24.9 */
	 u_int16_t sector_size;
	/* Description -  */
	/* 24.16 - 24.23 */
	 u_int8_t block_allignment;
	/* Description -  */
	/* 24.24 - 28.31 */
	 u_int8_t block_size;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - capability mask ;bit 0:Parallel flash Support;else:Reserved  */
	/* 28.0 - 32.31 */
	 u_int32_t capability_mask;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_ib_gid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 u_int32_t dword[4];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_dmfs_hash_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.5 */
	 u_int8_t log_hash_entries;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t entry_count;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t descendant_count;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t default_ste_ix;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_dmfs_fte_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - HW iterator for multiple flow destinations */
	/* 0.0 - 8.31 */
	 u_int64_t dest_iter_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_dmfs_ft_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  0: INVALID
 1: FT_NIC_TRANSMIT
 2: FT_ESW_EGRESS
 3: FT_ESW_INGRESS
 4: FT_ESW_FDB */
	/* 0.0 - 0.7 */
	 u_int8_t table_type;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t log2_table_size;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - location in table chaining hierarchy
level 0x0 is the root table */
	/* 4.0 - 4.7 */
	 u_int8_t level;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 4.15 - 4.15 */
	 u_int8_t other_vport;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 4.16 - 8.31 */
	 u_int16_t vport_number;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - first group_id in flow table */
	/* 12.0 - 16.31 */
	 u_int32_t groups_list_head;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - total num of flows points to this flow table */
	/* 16.0 - 16.15 */
	 u_int16_t total_ref_count;
	/* Description - num of flows points to this flow table from table_list */
	/* 16.16 - 20.31 */
	 u_int16_t iter_rule_count;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - num of groups member in this flow table */
	/* 20.0 - 24.31 */
	 u_int32_t groups_member_count;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 32.31 */
	 u_int64_t ft_head_ix;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dmfs_group_meta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - counting rules member in group */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  0: INVALID
 1: FT_NIC_TRANSMIT
 2: FT_ESW_EGRESS
 3: FT_ESW_INGRESS
 4: FT_ESW_FDB */
	/* 4.0 - 4.7 */
	 u_int8_t table_type;
	/* Description -  */
	/* 4.8 - 8.31 */
	 u_int32_t table_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Bitmask representing which of the headers and parameters in match_criteria are used in defining the Flow */
	/* 8.0 - 8.7 */
	 u_int8_t match_criteria_enable;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 8.15 - 8.15 */
	 u_int8_t other_vport;
	/* Description - valid only for ESW ingress/egress flow table */
	/* 8.16 - 12.31 */
	 u_int16_t vport_number;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t start_flow_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t end_flow_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t prev_group_id;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t next_group_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t root_hash_meta_ix;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 40.31 */
	 u_int64_t end_ste_ix;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_mkey_dump {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t ready_4_dump;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_tis {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.12 - 4.15 */
	 u_int8_t prio;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t sqn_head;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_tir {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t inline_rqn;
	/* Description -  */
	/* 4.24 - 4.27 */
	 u_int8_t disp_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.7 */
	 u_int8_t lro_max_ip_payload_size;
	/* Description -  */
	/* 8.8 - 8.11 */
	 u_int8_t lro_enable_mask;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t lro_timeout_period_usecs;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t rqt_number;
	/* Description -  */
	/* 12.24 - 12.27 */
	 u_int8_t rx_hash_fn;
	/* Description -  */
	/* 12.28 - 12.28 */
	 u_int8_t tunneled_offload_en;
	/* Description -  */
	/* 12.30 - 12.30 */
	 u_int8_t rx_hash_symmetric;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - This field sets which outer or the only packets headers fields should be */
	/* 16.0 - 20.31 */
	 struct connectib_rx_hash_field_select rx_hash_field_selector_outer;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - This field sets which outer or the only packets headers fields should be */
	/* 20.0 - 24.31 */
	 struct connectib_rx_hash_field_select rx_hash_field_selector_inner;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 56.31 */
	 struct connectib_tir_dmfs dmfs;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - shared between fw_qpc_special unions, must move together! 
Transport Service Type:
0x0 - RC
0x1 - UC
0x2 - UD
0x3 - XRC
0x4 - MLX
0x5 - DCI/DCI
0x6 - DCT
0x7 - QP0
0x8 - QP1
0x9 - Raw Ethernet
0xA - Raw IPv6
0xB - Sniffer
0xC - SYNC_UMR
0xD - PTP1588
other: reserved
Note: QPs of types QP0 and QP1 have the same properties as UD QP. There can be at most one for each type per port
QPs of types Raw Ethernet, Raw IPv6, Sniffer and PTP1588 have the same properties as MLX QP. There can be at most one for each type per port
QP of types SYNC_UMR have the same properties as UD QP. There can be at most one such QP per device */
	/* 4.0 - 4.7 */
	 u_int8_t sw_st;
	/* Description -  */
	/* 4.8 - 4.10 */
	 u_int8_t sw_rwq_type;
	/* Description -  */
	/* 4.11 - 4.11 */
	 u_int8_t no_sq;
	/* Description -  */
	/* 4.12 - 4.13 */
	 u_int8_t sw_rq_type;
	/* Description -  */
	/* 4.14 - 4.14 */
	 u_int8_t qp_dual_write;
	/* Description -  */
	/* 4.15 - 4.15 */
	 u_int8_t ack_fence_req;
	/* Description - in nak flow, qp flush will wait till nak2ack slice is done */
	/* 4.16 - 4.23 */
	 u_int8_t ack_slice_to_fence;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - original timer value requested by SW */
	/* 8.0 - 8.4 */
	 u_int8_t sw_timer_granularity;
	/* Description -  */
	/* 8.5 - 8.9 */
	 u_int8_t chilling_timer_granularity;
	/* Description -  */
	/* 8.10 - 8.10 */
	 u_int8_t one_side_flush;
	/* Description - APM - automatic path migration - path validation failed
send EVENT_TYPE_PATH_MIG_FAIL only once per migration cycle */
	/* 8.11 - 8.11 */
	 u_int8_t apm_path_validation_failed;
	/* Description -  */
	/* 8.12 - 8.12 */
	 u_int8_t cd_slave_send;
	/* Description -  */
	/* 8.13 - 8.13 */
	 u_int8_t cd_slave_receive;
	/* Description -  */
	/* 8.14 - 8.14 */
	 u_int8_t cd_master;
	/* Description -  */
	/* 8.15 - 8.15 */
	 u_int8_t sqd_on_sigerr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t tis_num;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_fw_qpc_q responder;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 48.31 */
	 struct connectib_fw_qpc_q requestor;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 64.31 */
	 union connectib_fw_qpc_special fw_qpc_special;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_srqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t catas_event_generated;
	/* Description -  */
	/* 4.1 - 4.1 */
	 u_int8_t basic_cyclic_rcv_wqe;
	/* Description -  */
	/* 4.2 - 4.2 */
	 u_int8_t invalid_user_index;
	/* Description - bit per reason.
0x0 - reserved
0x1 - SET LIMIT */
	/* 4.12 - 4.15 */
	 u_int8_t trap_reason;
	/* Description - (fw_trap_reason = SET_LIMIT) -> limit value */
	/* 4.16 - 8.31 */
	 u_int16_t trap_data;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - valid for memory_rq (non connector_rq) */
	/* 16.0 - 16.23 */
	 u_int32_t no_lro_qpn;
	/* Description - valid for eth memory_rq only */
	/* 16.24 - 20.31 */
	 u_int8_t memory_rq_state;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_sw_ads {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Index to pkey table
Reserved for ROCE.
For RoCE index 0, which contains the default PKEY: 
0xFFFF, is chosen automatically */
	/* 0.0 - 0.15 */
	 u_int16_t pkey_index;
	/* Description - When set, packets sent using this QP are marked for free 
adaptive routing. On IB wire it is marked in LRH and BTH.
For RoCE it is marked in BTH
.
 
Supported only for UD and 
UC transports */
	/* 0.30 - 0.30 */
	 u_int8_t free_ar;
	/* Description - Force loopback */
	/* 0.31 - 4.31 */
	 u_int8_t fl;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Remote LID
.
Reserved when fl==1.
Reserved for RoCE. */
	/* 4.0 - 4.15 */
	 u_int16_t rlid;
	/* Description - LMC bits of LID
Reserved for RoCE. */
	/* 4.16 - 4.22 */
	 u_int8_t mlid;
	/* Description - Use GRH
For InfiniBand, if set, GRH will be placed in the packet 
header, if clear, no GRH.
Reserved for RoCE. */
	/* 4.23 - 4.23 */
	 u_int8_t grh;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - For IB and RoCE version 1.0: GRH Hop Limit.
For RRoCE: IPv6 hop limit or IPv4 TTL */
	/* 8.0 - 8.7 */
	 u_int8_t hop_limit;
	/* Description - Maximum static rate control.
0: no_limit - no limit on static rate (100% port speed)
1-6: reserved
7: 2.5Gbps
8: 10Gbps
9: 30Gbps
10: 5Gbps
11: 20Gbps
12: 40Gbps
13: 60Gbps
14: 80Gbps
15: 120Gbps */
	/* 8.8 - 8.11 */
	 u_int8_t stat_rate;
	/* Description - For Infiniband : Index to Address Table in the port to get 
source GID address.
For RoCE: index to Address table to get the source GID/IP 
and MAC address, VLAN ID, IP Type ( IPV4, IPv6) and 
RoCE type. */
	/* 8.16 - 8.23 */
	 u_int8_t src_addr_index;
	/* Description - Ack timeout timer for activation of retransmission mecha
nism. If zero - timeout is disabled. timeout is 4.096 uS 
*2^(ack_timeout)/ */
	/* 8.27 - 12.31 */
	 u_int8_t ack_timeout;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - IPv6 Flow Label */
	/* 12.0 - 12.19 */
	 u_int32_t flow_label;
	/* Description - For InfiniB
 and RoCE v1.0
: GRH TClass */
	/* 12.20 - 12.27 */
	 u_int8_t tclass;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Remote GID
/IP
 address.
For IB port - Valid if the GRH bit is set.
For an Ethernet port for RoCE mode this field must be 
always valid and contain the remote GID address.
For an Ethernet port for R-RoCE mode, this field contains 
IPv4 or IPv6 depending on the IP type which appears in 
RoCE Address table entry pointed by src_addr_index field: 
for IP type == IPV4 then rgid/rip bits [31:0] specify the 
remote IPv4 address and rgid/rip bits [127:32] are reserved, 
when L3 header type == IPV6 rgid/rip bits [127:0] contains 
an IPv6 address. */
	/* 16.24 - 32.23 */
	 u_int8_t rgid_rip[16];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - For R-RoCE v2.0 RC/UC QPs: UDP source port.
must belong to the range: [QUERY_HCA_CAP. 
r_roce_udp_src_port_range_min-QUERY_HCA_CAP. 
r_roce_udp_src_port_range_max]. 
 See Section 328, "HCA 
Capabilities Layout," on page 462 */
	/* 32.0 - 32.15 */
	 u_int16_t udp_sport;
	/* Description - For R-RoCE: IP DSCP
This field is reserved when QP supports only RoCE v1.0. */
	/* 32.16 - 32.21 */
	 u_int8_t dscp;
	/* Description - For R-RoCE: IP ECN 
This field is reserved when QP supports only RoCE v1.0. */
	/* 32.22 - 32.23 */
	 u_int8_t ecn;
	/* Description - Force Ethernet user priority for UD/DC RoCE QPs.
When set take Ethernet priority from QP"s Address Path and 
not from send WQE.
Note: When f_eth_prio is enabled but send WQE points to 
RoCE Address Table entry with vlan_valid disabled, priority 
tagged frame is created and Ethernet priority and DEI/CFI 
fields are taken from QP"s Address Path. */
	/* 32.24 - 32.24 */
	 u_int8_t f_eth_prio;
	/* Description - Force IP ECN only for UD/DC RoCE QPs.
Take IP ECN field from QPC and not from send WQE.
When QP can generate only RoCE v.1 packets this field is 
reserved. */
	/* 32.26 - 32.26 */
	 u_int8_t f_ecn;
	/* Description - Force IP DSCP for UD/DC QPs.
Take IPv4/IPv6 DSCP field from QPC and not from send 
WQE.
When QP can generate only RoCE v.1 packets this field is 
reserved. */
	/* 32.27 - 32.27 */
	 u_int8_t f_dscp;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Upper bits of remote MAC address.
Valid only for RoCE QPs. */
	/* 36.0 - 36.15 */
	 u_int16_t rmac_47_32;
	/* Description - p
ort number */
	/* 36.16 - 36.23 */
	 u_int8_t port;
	/* Description - InfiniBand: Service Level (SL) */
	/* 36.24 - 36.27 */
	 u_int8_t sl;
	/* Description - Ethernet Priority (PCP).
Reserved for Infiniband. */
	/* 36.28 - 36.30 */
	 u_int8_t eth_prio;
	/* Description - DEI/CFI field.
For UD/DCI QP, DEI/CFI field is taken from UD Address 
Vector of the send WQE with the following exception:
when f_eth_prio is enabled and send WQE points to RoCE 
Address Table entry with vlan_valid disabled. priority 
tagged frame is created and DEI/CFI is taken from QP"s 
Address Path
.
Reserved for Infiniband and for RoCE UD/DCI QP with 
AP.f_eth_prio disabled. */
	/* 36.31 - 40.31 */
	 u_int8_t dei_cfi;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Lower bits of remote MAC address.
Valid only for RoCE QPs. */
	/* 40.0 - 44.31 */
	 u_int32_t rmac_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_msix_ext_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t mask_3_0;
	/* Description -  */
	/* 0.4 - 0.7 */
	 u_int8_t disable_3_0;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t need;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.19 */
	 u_int32_t timestamp_51_32;
	/* Description -  */
	/* 8.20 - 12.31 */
	 u_int16_t min_wait;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t timestamp_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_msix_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.2 - 4.31 */
	 u_int32_t addr_31_2_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t addr_63_32_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 union connectib_hw_msix_context_data data;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.0 */
	 u_int8_t spec_mask;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_rdb_atomic_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 u_int32_t atomic_data[8];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_mtt2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t hi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t lo;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t pas_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t rd_en;
	/* Description -  */
	/* 4.1 - 4.1 */
	 u_int8_t wr_en;
	/* Description -  */
	/* 4.3 - 8.31 */
	 u_int32_t pas_31_3;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_steering_qp_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_steering_qp_entry steering_qp_entry0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_steering_qp_entry steering_qp_entry1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_steering_qp_entry steering_qp_entry2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_steering_qp_entry steering_qp_entry3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 struct connectib_steering_qp_entry steering_qp_entry4;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 struct connectib_steering_qp_entry steering_qp_entry5;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 struct connectib_steering_qp_entry steering_qp_entry6;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 struct connectib_steering_qp_entry steering_qp_entry7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 struct connectib_steering_qp_entry steering_qp_entry8;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 struct connectib_steering_qp_entry steering_qp_entry9;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 struct connectib_steering_qp_entry steering_qp_entry10;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 struct connectib_steering_qp_entry steering_qp_entry11;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 struct connectib_steering_qp_entry steering_qp_entry12;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 struct connectib_steering_qp_entry steering_qp_entry13;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 60.31 */
	 struct connectib_steering_qp_entry steering_qp_entry14;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 64.31 */
	 struct connectib_steering_qp_entry steering_qp_entry15;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_ste {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t member_count;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t rx_packet_qp;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t rx_fw_int;
	/* Description - Compare = 0x0, MissOnTagMatch = 0x1, AlwaysHit = 0x2, AlwaysMiss = 0x3 */
	/* 0.30 - 4.31 */
	 u_int8_t rx_cmd;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t pport_byte_counters_trigger;
	/* Description -  */
	/* 4.8 - 4.15 */
	 u_int8_t pport_packet_counters_trigger;
	/* Description -  */
	/* 4.16 - 4.19 */
	 u_int8_t vport_byte_counters_trigger;
	/* Description -  */
	/* 4.20 - 4.23 */
	 u_int8_t vport_packet_counters_trigger;
	/* Description -  */
	/* 4.26 - 4.26 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 4.27 - 4.27 */
	 u_int8_t sx_func_lb;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t sx_wire;
	/* Description -  */
	/* 4.29 - 4.29 */
	 u_int8_t sx_fw_int;
	/* Description - HitOnTagMatch = 0x0, HitAndTerminateOnTagMatch = 0x1, HitOnTagMismatch  = 0x2, HitAndTerminateOnTagMismatch = 0x3 */
	/* 4.30 - 8.31 */
	 u_int8_t sx_cmd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Nop=0x0, Port = 0x1, IbL2 = 0x2, IbL3 = 0x3, IbL3Extended = 0x4, IbL4Qp = 0x5, 
SrcGvmiAndQp = 0x8, 
GenericDwordSelect0 = 0xc, GenericDwordSelect1 = 0xd,
GenericDwordSelect2 = 0xe, GenericDwordSelect3 = 0xf */
	/* 8.24 - 12.31 */
	 u_int8_t my_lookup_type;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 u_int8_t hit_lookup_type_hash_field_mask;
	/* Description -  */
	/* 12.8 - 12.13 */
	 u_int8_t log2_hit_entry_size;
	/* Description -  */
	/* 12.16 - 16.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -   */
	/* 16.0 - 20.31 */
	 u_int32_t hit_base_address_63_32;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Nop=0x0, Port = 0x1, IbL2 = 0x2, IbL3 = 0x3, IbL3Extended = 0x4, IbL4Qp = 0x5, 
SrcGvmiAndQp = 0x8, 
GenericDwordSelect0 = 0xc, GenericDwordSelect1 = 0xd,
GenericDwordSelect2 = 0xe, GenericDwordSelect3 = 0xf */
	/* 20.0 - 20.7 */
	 u_int8_t hit_lookup_type;
	/* Description -   */
	/* 20.8 - 24.31 */
	 u_int32_t hit_base_address_31_8;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t miss_address_63_32;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.5 */
	 u_int8_t log2_hit_table_size;
	/* Description -  */
	/* 28.6 - 32.31 */
	 u_int32_t miss_address_31_6;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -   */
	/* 32.0 - 48.31 */
	 union connectib_hw_ste_tag tag_data;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -   */
	/* 48.0 - 64.31 */
	 union connectib_hw_ste_tag tag_mask;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_hw_timer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - time to wait before timeout (see qpc MAS) */
	/* 0.0 - 0.4 */
	 u_int8_t timer_granularity;
	/* Description - state of timer (see qpc mas) */
	/* 0.5 - 0.6 */
	 u_int8_t timer_state;
	/* Description - timer is valid */
	/* 0.7 - 0.7 */
	 u_int8_t timer_valid;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0.1 - 0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0.2 - 0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0.8 - 0.8 */
	 u_int8_t w_check_gen;
	/* Description - NO_DESCR */
	/* 0.9 - 0.9 */
	 u_int8_t w_init;
	/* Description - NO_DESCR */
	/* 0.10 - 0.11 */
	 u_int8_t w_pad;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_non_repeating_m_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0.8 - 0.8 */
	 u_int8_t w_check_gen;
	/* Description - NO_DESCR */
	/* 0.9 - 0.9 */
	 u_int8_t w_init;
	/* Description - NO_DESCR */
	/* 0.10 - 0.11 */
	 u_int8_t w_pad;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_repeating_m_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0.1 - 0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0.2 - 0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0.8 - 0.15 */
	 u_int8_t w_block_size_selector;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_w_repeating_m_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0.8 - 0.15 */
	 u_int8_t w_block_size_selector;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_same_block_non_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.0 */
	 u_int8_t m_check_gen;
	/* Description - NO_DESCR */
	/* 0.1 - 0.1 */
	 u_int8_t m_init;
	/* Description - NO_DESCR */
	/* 0.2 - 0.3 */
	 u_int8_t m_pad;
	/* Description - NO_DESCR */
	/* 0.8 - 0.15 */
	 u_int8_t copy_byte_mask;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_bsf_entry_same_block_repeating {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.7 */
	 u_int8_t m_block_size_selector;
	/* Description - NO_DESCR */
	/* 0.8 - 0.15 */
	 u_int8_t copy_byte_mask;
	/* Description - NO_DESCR */
	/* 0.16 - 0.23 */
	 u_int8_t byte_check_en;
	/* Description - NO_DESCR */
	/* 0.28 - 0.28 */
	 u_int8_t aligned;
	/* Description - NO_DESCR */
	/* 0.30 - 4.31 */
	 u_int8_t size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t raw_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 8.23 */
	 u_int32_t w_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 8.24 - 12.31 */
	 u_int8_t w_b_pdf_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - NO_DESCR */
	/* 12.0 - 12.23 */
	 u_int32_t m_b_psv_pointer;
	/* Description - NO_DESCR */
	/* 12.24 - 16.31 */
	 u_int8_t m_b_pdf_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - NO_DESCR */
	/* 16.0 - 16.23 */
	 u_int32_t prologue_size;
	/* Description - NO_DESCR */
	/* 16.24 - 16.24 */
	 u_int8_t m_t_end;
	/* Description - NO_DESCR */
	/* 16.25 - 16.25 */
	 u_int8_t m_t_start;
	/* Description - NO_DESCR */
	/* 16.28 - 16.28 */
	 u_int8_t w_t_end;
	/* Description - NO_DESCR */
	/* 16.29 - 16.29 */
	 u_int8_t w_t_start;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.23 */
	 u_int32_t epilogue_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - NO_DESCR */
	/* 24.0 - 24.23 */
	 u_int32_t w_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 24.24 - 28.31 */
	 u_int8_t w_t_pdf_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - NO_DESCR */
	/* 28.0 - 28.23 */
	 u_int32_t m_t_psv_pointer;
	/* Description - NO_DESCR */
	/* 28.24 - 32.31 */
	 u_int8_t m_t_pdf_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 32.15 */
	 u_int16_t w_dif_app_tag;
	/* Description - NO_DESCR */
	/* 32.30 - 32.30 */
	 u_int8_t w_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 32.31 - 36.31 */
	 u_int8_t w_in_line_vld;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 40.31 */
	 u_int32_t w_dif_ref_tag;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.0 - 48.31 */
	 union connectib_hw_pdf_entry w_in_line_pdf;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - NO_DESCR */
	/* 48.0 - 48.15 */
	 u_int16_t m_dif_app_tag;
	/* Description - NO_DESCR */
	/* 48.30 - 48.30 */
	 u_int8_t m_refresh_dif_params;
	/* Description - NO_DESCR */
	/* 48.31 - 52.31 */
	 u_int8_t m_in_line_vld;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - NO_DESCR */
	/* 52.0 - 56.31 */
	 u_int32_t m_dif_ref_tag;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - NO_DESCR */
	/* 56.0 - 64.31 */
	 union connectib_hw_pdf_entry m_in_line_pdf;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_dct {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - this field add for making this struct size 64B (as QPC) */
	/* 0.0 - 4.31 */
	 u_int32_t complete_to_64B_eyald;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.4 */
	 u_int8_t rnr_timer;
	/* Description - 
EAS NAME: rwe */
	/* 32.5 - 32.5 */
	 u_int8_t write_enable;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload <=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload <=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 32.6 - 32.7 */
	 u_int8_t inline_scatter;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 32.8 - 32.12 */
	 u_int8_t max_message_size;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 32.13 - 32.13 */
	 u_int8_t ignore_pkey_check;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 32.14 - 32.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - 
EAS NAME: rre */
	/* 32.15 - 32.15 */
	 u_int8_t read_enable;
	/* Description - 0: 256 bytes 
1: 512 bytes 
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 32.16 - 32.18 */
	 u_int8_t mtu;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 32.19 - 32.19 */
	 u_int8_t fast_path;
	/* Description - number of valid bytes in the dca_access_key
0-3: 2^value bytes
7-disable */
	/* 32.20 - 32.22 */
	 u_int8_t dc_access_key_log_num_byte;
	/* Description - 
EAS NAME: N/A */
	/* 32.23 - 32.23 */
	 u_int8_t tcu_drop;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 32.24 - 32.24 */
	 u_int8_t tcu_trap;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.25 - 32.25 */
	 u_int8_t adaptive_routing;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.26 - 32.26 */
	 u_int8_t port_number;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.27 - 32.27 */
	 u_int8_t grh_bit;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: flow_label */
	/* 36.0 - 36.19 */
	 u_int32_t flow_label;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 36.20 - 36.22 */
	 u_int8_t max_read_atomic;
	/* Description - in other decode options this bit should be reserved and always_zero.
this is because we don't have a HW check of ts when fetching DCT.
if we get normal QP by accident this will show invalid context. */
	/* 36.23 - 36.23 */
	 u_int8_t qp_valid;
	/* Description - 
EAS NAME: mlid */
	/* 36.24 - 36.30 */
	 u_int8_t my_lid;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 36.31 - 40.31 */
	 u_int8_t atomic_like_write;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
EAS NAME: srqn
condition:rwq_type==SRQ & ts!=DCR */
	/* 40.0 - 40.23 */
	 u_int32_t srq_number;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid
EAS NAME: if_counter_index */
	/* 40.24 - 44.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 
EAS NAME: pkey_index */
	/* 44.0 - 44.11 */
	 u_int16_t pkey_table_index;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 44.12 - 44.15 */
	 u_int8_t extended_atomic;
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 44.16 - 44.23 */
	 u_int8_t my_gid_mac_index;
	/* Description - 
EAS NAME: stat_rate */
	/* 44.24 - 44.27 */
	 u_int8_t ipd;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent
9-RMC child (RX only)
10-FCP
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - 
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 48.0 - 48.23 */
	 u_int32_t cq_number;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 48.24 - 52.31 */
	 u_int8_t hop_limit;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 52.0 - 52.23 */
	 u_int32_t context_number;
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 52.24 - 56.31 */
	 u_int8_t tclass;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
condition:ts==DCI */
	/* 56.0 - 64.31 */
	 u_int64_t dc_access_key;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ud_l2_cd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0.1 - 0.1 */
	 u_int8_t check_source_uc_wire;
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked.
This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0.8 - 0.8 */
	 u_int8_t check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0.9 - 0.9 */
	 u_int8_t check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0.10 - 0.10 */
	 u_int8_t check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0.28 - 0.28 */
	 u_int8_t drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE
0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0.30 - 0.30 */
	 u_int8_t grh_to_cqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's
saturation on 0xff
TODO: 8 MSB are not used */
	/* 44.0 - 44.15 */
	 u_int16_t no_wqe_drop_count;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 60.1 - 60.1 */
	 u_int8_t check_source_mc_wire;
	/* Description - 
condition:ts!=DCR & ts!=XRC & post_receive_slave_enable */
	/* 60.8 - 64.31 */
	 u_int32_t mpi_uar;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ud_l2_2srq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0.1 - 0.1 */
	 u_int8_t check_source_uc_wire;
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked.
This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0.8 - 0.8 */
	 u_int8_t check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0.9 - 0.9 */
	 u_int8_t check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0.10 - 0.10 */
	 u_int8_t check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0.28 - 0.28 */
	 u_int8_t drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE
0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0.30 - 0.30 */
	 u_int8_t grh_to_cqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's
saturation on 0xff
TODO: 8 MSB are not used */
	/* 44.0 - 44.15 */
	 u_int16_t no_wqe_drop_count;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: srqn
condition:rwq_type==SRQ & ts!=DCR */
	/* 56.0 - 56.23 */
	 u_int32_t srq_number;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 60.1 - 60.1 */
	 u_int8_t check_source_mc_wire;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ud_l2_2cyclicbuff {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0.1 - 0.1 */
	 u_int8_t check_source_uc_wire;
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked.
This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0.8 - 0.8 */
	 u_int8_t check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0.9 - 0.9 */
	 u_int8_t check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0.10 - 0.10 */
	 u_int8_t check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0.28 - 0.28 */
	 u_int8_t drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE
0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0.30 - 0.30 */
	 u_int8_t grh_to_cqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
condition:ts!=DCR & rwq_type==RCYCLIC */
	/* 12.0 - 16.31 */
	 u_int32_t rcyclic_producer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's
saturation on 0xff
TODO: 8 MSB are not used */
	/* 44.0 - 44.15 */
	 u_int16_t no_wqe_drop_count;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 56.0 - 60.31 */
	 u_int32_t e2e_pa_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 60.1 - 60.1 */
	 u_int8_t check_source_mc_wire;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 60.2 - 64.31 */
	 u_int32_t e2e_pa_31_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_ud_l2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0.1 - 0.1 */
	 u_int8_t check_source_uc_wire;
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked.
This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0.8 - 0.8 */
	 u_int8_t check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0.9 - 0.9 */
	 u_int8_t check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0.10 - 0.10 */
	 u_int8_t check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0.28 - 0.28 */
	 u_int8_t drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE
0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0.30 - 0.30 */
	 u_int8_t grh_to_cqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's
saturation on 0xff
TODO: 8 MSB are not used */
	/* 44.0 - 44.15 */
	 u_int16_t no_wqe_drop_count;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 56.0 - 60.31 */
	 u_int32_t e2e_pa_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 60.1 - 60.1 */
	 u_int8_t check_source_mc_wire;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 60.2 - 64.31 */
	 u_int32_t e2e_pa_31_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_unconnected_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check_source_uc_wire - check source (choose source based on QP bit) for multicast wire */
	/* 0.1 - 0.1 */
	 u_int8_t check_source_uc_wire;
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - Loopback only, If set, function_id is checked with the receiving QP function_id. Otherwise, SMAC is checked.
This and the following 4 not needed in FC (And RC) since we check DMAC in the QP and make sure that the packet arrived to its intended destination */
	/* 0.8 - 0.8 */
	 u_int8_t check_source_gvmi;
	/* Description - check source (choose source based on QP bit) for multicast loopback */
	/* 0.9 - 0.9 */
	 u_int8_t check_source_mc_lb;
	/* Description - check source (choose source based on QP bit) for unicast loopback */
	/* 0.10 - 0.10 */
	 u_int8_t check_source_uc_lb;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - when set: multicast loopback packets coming from the same QP will be dropped */
	/* 0.28 - 0.28 */
	 u_int8_t drop_my_self_multicast;
	/* Description - 1: GRH is sent to CQE
0: GRH is sent to first 40B of the WQE (or 40B reserved if GRH not present). this is the backward compatiblity mode */
	/* 0.30 - 0.30 */
	 u_int8_t grh_to_cqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - cleared when CQE is sent, increament when packet is dropped due to lack of receive WQE's
saturation on 0xff
TODO: 8 MSB are not used */
	/* 44.0 - 44.15 */
	 u_int16_t no_wqe_drop_count;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - check source (choose source based on QP bit) for multicast wire */
	/* 60.1 - 60.1 */
	 u_int8_t check_source_mc_wire;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_xrc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates which MSN was done
EAS NAME: rmsn
idle value: Common.PeerQp.Send.ssn
condition:rwq_type!=RCYCLIC */
	/* 24.0 - 24.23 */
	 u_int32_t msn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: srqn
condition:rwq_type==SRQ & ts!=DCR */
	/* 56.0 - 56.23 */
	 u_int32_t srq_number;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
	/* Description - Hermon: srcd
EAS NAME: xrcd
condition:ts==XRC */
	/* 60.8 - 64.31 */
	 u_int32_t xrc_domain;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_dcr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates which MSN was done
EAS NAME: rmsn
idle value: Common.PeerQp.Send.ssn
condition:rwq_type!=RCYCLIC */
	/* 24.0 - 24.23 */
	 u_int32_t msn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t dct_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - when equal 0xffffff: next DCR does not exist, end of list
EAS NAME: N/A
condition:ts==DCR */
	/* 56.0 - 56.23 */
	 u_int32_t next_dcr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
	/* Description - 1: dcr is connected
0: dcr is free
idle value: 0
condition:ts==DCR */
	/* 60.2 - 60.2 */
	 u_int8_t dcr_connected;
	/* Description - 
EAS NAME: N/A
condition:ts==DCR */
	/* 60.8 - 64.31 */
	 u_int32_t responder_session_id;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rc_uc_2srq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates which MSN was done
EAS NAME: rmsn
idle value: Common.PeerQp.Send.ssn
condition:rwq_type!=RCYCLIC */
	/* 24.0 - 24.23 */
	 u_int32_t msn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: srqn
condition:rwq_type==SRQ & ts!=DCR */
	/* 56.0 - 56.23 */
	 u_int32_t srq_number;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rc_uc_2cycbuff {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
condition:ts!=DCR & rwq_type==RCYCLIC */
	/* 12.0 - 16.31 */
	 u_int32_t rcyclic_producer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - how many bytes received ^ modulo 4G
condition:rwq_type==RCYCLIC */
	/* 24.0 - 28.31 */
	 u_int32_t rcyclic_consumer;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 56.0 - 60.31 */
	 u_int32_t e2e_pa_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 60.2 - 64.31 */
	 u_int32_t e2e_pa_31_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rc_uc_cd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates which MSN was done
EAS NAME: rmsn
idle value: Common.PeerQp.Send.ssn
condition:rwq_type!=RCYCLIC */
	/* 24.0 - 24.23 */
	 u_int32_t msn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
	/* Description - 
condition:ts!=DCR & ts!=XRC & post_receive_slave_enable */
	/* 60.8 - 64.31 */
	 u_int32_t mpi_uar;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_rc_uc_dci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
EAS NAME: rq_wqe_max
condition:ts!=DCR & rwq_type==REGULAR */
	/* 12.0 - 12.15 */
	 u_int16_t rwqe_producer_index;
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 12.16 - 16.31 */
	 u_int16_t rwqe_consumer_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Indicates which MSN was done
EAS NAME: rmsn
idle value: Common.PeerQp.Send.ssn
condition:rwq_type!=RCYCLIC */
	/* 24.0 - 24.23 */
	 u_int32_t msn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index  */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 56.0 - 60.31 */
	 u_int32_t e2e_pa_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 60.2 - 64.31 */
	 u_int32_t e2e_pa_31_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_connected_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - last opcode was:
0-write
1-send
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t last_opcode;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: rre */
	/* 0.13 - 0.13 */
	 u_int8_t read_enable;
	/* Description - When set send and invalidate is allowed on this Qp (like AWR bits) */
	/* 0.14 - 0.14 */
	 u_int8_t send_with_invalidate_enable;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description - 
EAS NAME: rwe */
	/* 0.23 - 0.23 */
	 u_int8_t write_enable;
	/* Description - RDMA write coming to this QP will enter the atomic lock mechanism to ensure PCI atomicity */
	/* 0.24 - 0.24 */
	 u_int8_t atomic_like_write;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: N/A */
	/* 0.28 - 0.30 */
	 u_int8_t ack_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - On WriteFirst set to the packet.R_key
EAS NAME: N/A */
	/* 4.0 - 8.31 */
	 u_int32_t write_rkey;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description -  */
	/* 8.16 - 8.20 */
	 u_int8_t rnr_timer;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - in hermon: last_acked_psn (+1 from hermon)
EAS NAME: last_acked_psn
idle value: Receive.expected_psn */
	/* 20.0 - 20.23 */
	 u_int32_t first_non_acked_psn;
	/* Description - 
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Receive.rdb_write_pointer */
	/* 36.0 - 36.7 */
	 u_int8_t rdb_read_pointer;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - How many received in current message, 0-not inside a message
RC: in chuncks of 256B
LRO: in bytes
hermon name: part was in last_opcode
EAS NAME: N/A
idle value: 0 */
	/* 40.8 - 44.31 */
	 u_int32_t rx_length_committed;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - 23:0 DCT number
39:24 GVMI
EAS NAME: N/A
condition:ts==DCR */
	/* 44.0 - 44.15 */
	 u_int16_t dct_gvmi;
	/* Description - SQ number
TODO: reduce 1 bit */
	/* 44.16 - 44.26 */
	 u_int16_t sqn;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - virtual address of write being processed
EAS NAME: N/A */
	/* 48.0 - 56.31 */
	 u_int64_t write_va;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Controls handling of packets with correct and incorrect PSN and opcode sequences
0: Unconnected - QPC ePSN and opcode sequence are invalid
1:Connected (good flow) - QPC.ePSN and correct opcode sequence are forwarded; everything else triggers FW
2: Resync (^xxstate^) -  QPC.ePSN and correct opcode sequence will cause HW to move QPC to Connected state; everything else is dropped
3: Closed - everything is dropped in RXT
HW writes to this field in RNR-nack flow
EAS NAME: N/A */
	/* 60.0 - 60.1 */
	 u_int8_t connection_state;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_r_qpc_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 
EAS NAME: link_type */
	/* 0.2 - 0.2 */
	 u_int8_t fw_link_type;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - when this bit is set a post_receive WQE may be executed on this target qp
must be set to 0 on DCR and XRC
EAS NAME: cd_slv_rcv */
	/* 0.25 - 0.25 */
	 u_int8_t post_receive_slave_enable;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.0 - 8.15 */
	 u_int16_t rwqe_limit_event;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 8.27 - 8.27 */
	 u_int8_t e2e_fetch_enable;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 8.28 - 8.30 */
	 u_int8_t e2e_credits_prefetch_threshold;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - UD: used for LRO checks
EAS NAME: next_rcv_psn */
	/* 32.8 - 36.31 */
	 u_int32_t expected_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_ud_l2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t umr_permission_select;
	/* Description - SX WQE opcode that cause packet creation are allowed */
	/* 0.29 - 0.29 */
	 u_int8_t packet_allowed;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - Hermon name: bind_enable */
	/* 8.28 - 8.28 */
	 u_int8_t umr_enable;
	/* Description - enable fast register WQE
Hermon name: frwr_en
EAS NAME: fre */
	/* 8.29 - 8.29 */
	 u_int8_t frwr_enable;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
	/* Description - 
EAS NAME: sq_wqe_counter */
	/* 16.16 - 20.31 */
	 u_int16_t swqe_consumer_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - SX should put this field in DETH.SQPN field
EAS NAME: remote_qpn/wire_qpn */
	/* 20.0 - 20.23 */
	 u_int32_t deth_sqpn;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - 
EAS NAME: next_send_psn */
	/* 32.8 - 36.31 */
	 u_int32_t next_to_send_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 40.15 - 40.15 */
	 u_int8_t force_grh_tclass;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - How many bytes were sent from current WQE
LSO byte granularty, otherwise 256B granularty
EAS NAME: N/A
idle value: 0 */
	/* 44.0 - 44.22 */
	 u_int32_t sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid)
condition:ts==DCI | ts==UD */
	/* 44.23 - 44.23 */
	 u_int8_t force_my_gid_index;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.30 - 56.30 */
	 u_int8_t vl15;
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 56.31 - 60.31 */
	 u_int8_t force_grh;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_dci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - TODO this bit does not work and is not needed, delete on next project
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t ldb_int;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - 
EAS NAME: rnr_retry */
	/* 0.8 - 0.10 */
	 u_int8_t rnr_nak_retry_limit;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: cur_rnr_retry */
	/* 0.12 - 0.14 */
	 u_int8_t rnr_nak_retry_counter;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t umr_permission_select;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: dc_hs */
	/* 0.28 - 0.28 */
	 u_int8_t dc_full_handshake;
	/* Description - set by SX when executing a non wire WQE
cleared by RX when LDB is empty
used by LDB for performance optimisation
idle value: 0 */
	/* 0.30 - 0.30 */
	 u_int8_t uncompleted_non_wire_wqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0: not connected
1: connect packet sent
2: connect was acked
EAS NAME: N/A
idle value: 0 */
	/* 8.0 - 8.1 */
	 u_int8_t dc_state;
	/* Description - 0-no limit, 1-outstanding reads, 2-fence, 3-strong ordering, 4-fc_seq_initiative, 5-outstanding psn, 6-dc wait for connect, 7-e2e credit (limited state)
EAS NAME: N/A
idle value: 0 */
	/* 8.17 - 8.19 */
	 u_int8_t limited_qp;
	/* Description -  2^value is the frequency at which we send ackreq.valid.
values are 0-8 giving ackreq bit per 1-256 packets
EAS NAME: ack_req_freq */
	/* 8.20 - 8.23 */
	 u_int8_t ack_req_frequency;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - Hermon name: bind_enable */
	/* 8.28 - 8.28 */
	 u_int8_t umr_enable;
	/* Description - enable fast register WQE
Hermon name: frwr_en
EAS NAME: fre */
	/* 8.29 - 8.29 */
	 u_int8_t frwr_enable;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - index updated when poping from ldb (ldb_index)
EAS NAME: N/A
idle value: Send.swqe_consumer_index */
	/* 12.16 - 16.31 */
	 u_int16_t currently_completing_wqe_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
	/* Description - 
EAS NAME: sq_wqe_counter */
	/* 16.16 - 20.31 */
	 u_int16_t swqe_consumer_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn - Send.psn_since_ackreq */
	/* 20.0 - 20.23 */
	 u_int32_t oldest_non_acked_psn;
	/* Description - ACKREQ_PSN (PSN of last packet sent with ACKREQ=1, virtual field for timer decision) = QP.next_to_send_psn - 1 - QP.PSN_since_ACKREQ
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t psn_since_ackreq;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - copied from packet on first ack
EAS NAME: N/A
condition:ts==DCI */
	/* 24.0 - 24.23 */
	 u_int32_t responder_session_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - 
EAS NAME: next_send_psn */
	/* 32.8 - 36.31 */
	 u_int32_t next_to_send_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: ssn */
	/* 36.0 - 36.23 */
	 u_int32_t ssn;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 40.15 - 40.15 */
	 u_int8_t force_grh_tclass;
	/* Description - 
EAS NAME: N/A
condition:ts==DCI */
	/* 40.16 - 40.19 */
	 u_int8_t reverse_sl;
	/* Description - 
EAS NAME: cur_retry_cnt */
	/* 40.20 - 40.22 */
	 u_int8_t to_sequence_error_retry_counter;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - How many bytes were sent from current WQE
LSO byte granularty, otherwise 256B granularty
EAS NAME: N/A
idle value: 0 */
	/* 44.0 - 44.22 */
	 u_int32_t sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid)
condition:ts==DCI | ts==UD */
	/* 44.23 - 44.23 */
	 u_int8_t force_my_gid_index;
	/* Description - 
EAS NAME: retry_count */
	/* 44.24 - 44.26 */
	 u_int8_t to_sequence_error_retry_limit;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - 
condition:ts==DCI */
	/* 48.0 - 56.31 */
	 u_int64_t dc_access_key;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn */
	/* 56.0 - 56.23 */
	 u_int32_t first_psn_of_message_currently_completing;
	/* Description - value 0 means that we are not in the middle of a read response
read middle: if DS is too big rx slice should skip the REQSL machine
EAS NAME: N/A
idle value: 0 */
	/* 56.24 - 56.29 */
	 u_int8_t currently_completing_ds;
	/* Description -  */
	/* 56.30 - 56.30 */
	 u_int8_t timer_enable;
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 56.31 - 60.31 */
	 u_int8_t force_grh;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Hermon: highest_psn
EAS NAME: N/A */
	/* 60.0 - 60.23 */
	 u_int32_t first_unsent_psn;
	/* Description - Counts number of outstanding reads and atomic
EAS NAME: N/A
idle value: 0 */
	/* 60.24 - 64.31 */
	 u_int8_t number_outstanding_reads;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_rc_uc_dcr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - TODO this bit does not work and is not needed, delete on next project
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t ldb_int;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - 
EAS NAME: rnr_retry */
	/* 0.8 - 0.10 */
	 u_int8_t rnr_nak_retry_limit;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: cur_rnr_retry */
	/* 0.12 - 0.14 */
	 u_int8_t rnr_nak_retry_counter;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t umr_permission_select;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: dc_hs */
	/* 0.28 - 0.28 */
	 u_int8_t dc_full_handshake;
	/* Description - set by SX when executing a non wire WQE
cleared by RX when LDB is empty
used by LDB for performance optimisation
idle value: 0 */
	/* 0.30 - 0.30 */
	 u_int8_t uncompleted_non_wire_wqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0: not connected
1: connect packet sent
2: connect was acked
EAS NAME: N/A
idle value: 0 */
	/* 8.0 - 8.1 */
	 u_int8_t dc_state;
	/* Description - 0-no limit, 1-outstanding reads, 2-fence, 3-strong ordering, 4-fc_seq_initiative, 5-outstanding psn, 6-dc wait for connect, 7-e2e credit (limited state)
EAS NAME: N/A
idle value: 0 */
	/* 8.17 - 8.19 */
	 u_int8_t limited_qp;
	/* Description -  2^value is the frequency at which we send ackreq.valid.
values are 0-8 giving ackreq bit per 1-256 packets
EAS NAME: ack_req_freq */
	/* 8.20 - 8.23 */
	 u_int8_t ack_req_frequency;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - Hermon name: bind_enable */
	/* 8.28 - 8.28 */
	 u_int8_t umr_enable;
	/* Description - enable fast register WQE
Hermon name: frwr_en
EAS NAME: fre */
	/* 8.29 - 8.29 */
	 u_int8_t frwr_enable;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - index updated when poping from ldb (ldb_index)
EAS NAME: N/A
idle value: Send.swqe_consumer_index */
	/* 12.16 - 16.31 */
	 u_int16_t currently_completing_wqe_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
	/* Description - 
EAS NAME: sq_wqe_counter */
	/* 16.16 - 20.31 */
	 u_int16_t swqe_consumer_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn - Send.psn_since_ackreq */
	/* 20.0 - 20.23 */
	 u_int32_t oldest_non_acked_psn;
	/* Description - ACKREQ_PSN (PSN of last packet sent with ACKREQ=1, virtual field for timer decision) = QP.next_to_send_psn - 1 - QP.PSN_since_ACKREQ
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t psn_since_ackreq;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - copied from packet on first ack
EAS NAME: N/A
condition:ts==DCI */
	/* 24.0 - 24.23 */
	 u_int32_t responder_session_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - 
EAS NAME: next_send_psn */
	/* 32.8 - 36.31 */
	 u_int32_t next_to_send_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: ssn */
	/* 36.0 - 36.23 */
	 u_int32_t ssn;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 40.15 - 40.15 */
	 u_int8_t force_grh_tclass;
	/* Description - 
EAS NAME: N/A
condition:ts==DCI */
	/* 40.16 - 40.19 */
	 u_int8_t reverse_sl;
	/* Description - 
EAS NAME: cur_retry_cnt */
	/* 40.20 - 40.22 */
	 u_int8_t to_sequence_error_retry_counter;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - How many bytes were sent from current WQE
LSO byte granularty, otherwise 256B granularty
EAS NAME: N/A
idle value: 0 */
	/* 44.0 - 44.22 */
	 u_int32_t sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid)
condition:ts==DCI | ts==UD */
	/* 44.23 - 44.23 */
	 u_int8_t force_my_gid_index;
	/* Description - 
EAS NAME: retry_count */
	/* 44.24 - 44.26 */
	 u_int8_t to_sequence_error_retry_limit;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - 
condition:ts!=DCI */
	/* 48.0 - 48.23 */
	 u_int32_t lsn;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn */
	/* 56.0 - 56.23 */
	 u_int32_t first_psn_of_message_currently_completing;
	/* Description - value 0 means that we are not in the middle of a read response
read middle: if DS is too big rx slice should skip the REQSL machine
EAS NAME: N/A
idle value: 0 */
	/* 56.24 - 56.29 */
	 u_int8_t currently_completing_ds;
	/* Description -  */
	/* 56.30 - 56.30 */
	 u_int8_t timer_enable;
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 56.31 - 60.31 */
	 u_int8_t force_grh;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Hermon: highest_psn
EAS NAME: N/A */
	/* 60.0 - 60.23 */
	 u_int32_t first_unsent_psn;
	/* Description - Counts number of outstanding reads and atomic
EAS NAME: N/A
idle value: 0 */
	/* 60.24 - 64.31 */
	 u_int8_t number_outstanding_reads;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_connected_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - TODO this bit does not work and is not needed, delete on next project
EAS NAME: N/A */
	/* 0.3 - 0.3 */
	 u_int8_t ldb_int;
	/* Description - 0: disable - data will always be scattered accoding to the scatter entry
1: up to 32B - if payload&lt;=32B, data should be scattered into the CQE (inline)
2: up to 64B - if payload&lt;=64B, data should be scattered into the CQE (inline)
Hermon: disable_inline_scatter
EAS NAME: cs
condition:ts!=DCR */
	/* 0.6 - 0.7 */
	 u_int8_t inline_scatter;
	/* Description - 
EAS NAME: rnr_retry */
	/* 0.8 - 0.10 */
	 u_int8_t rnr_nak_retry_limit;
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - 
EAS NAME: cur_rnr_retry */
	/* 0.12 - 0.14 */
	 u_int8_t rnr_nak_retry_counter;
	/* Description - TODO next project: rename to pkey_check_enable
EAS NAME: N/A */
	/* 0.15 - 0.15 */
	 u_int8_t ignore_pkey_check;
	/* Description - in the below description the size relates to the operands size (meaning: size of each operand)
0: disable atomic
1: IB spec (responder extended RDB is N/A)
all enum from here support extended atomic in addition
2: only 8B (hermon mode, responder extended RDB is N/A)
3: up to 8B (also 4B, responder extended RDB is N/A)
4: up to 16B (responder extended RDB is N/A)
5: up to 32B (responder extended RDB is N/A)
6: up to 64B (responder extended RDB is 64B)
7: up to 128B (responder extended RDB is 128B)
8: up to 256B (responder extended RDB is 256B)
EAS NAME: rae, rdma_atomic_mode */
	/* 0.16 - 0.19 */
	 u_int8_t extended_atomic;
	/* Description - 2^this value=max number of atomic/rdma reads
Hermon: max_rdma_atomic
EAS NAME: sra_max, rra_max */
	/* 0.20 - 0.22 */
	 u_int8_t max_read_atomic;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t umr_permission_select;
	/* Description - When set no-direct-access is allowed to this QP (i.e. by BTH.QPN).
When clear, both direct (i.e. by BTH.QPN) and indirect access (i.e. by RSS remapping, MC remapping etc) is allowed.
See issue 34551 
EAS NAME: N/A */
	/* 0.26 - 0.26 */
	 u_int8_t no_direct_access;
	/* Description - TCU requestor should trap when e2e_credits_enabled==&AETH.syndrom.CCCCC
EAS NAME: ric */
	/* 0.27 - 0.27 */
	 u_int8_t e2e_credits_enabled;
	/* Description - 
EAS NAME: dc_hs */
	/* 0.28 - 0.28 */
	 u_int8_t dc_full_handshake;
	/* Description - set by SX when executing a non wire WQE
cleared by RX when LDB is empty
used by LDB for performance optimisation
idle value: 0 */
	/* 0.30 - 0.30 */
	 u_int8_t uncompleted_non_wire_wqe;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0: not connected
1: connect packet sent
2: connect was acked
EAS NAME: N/A
idle value: 0 */
	/* 8.0 - 8.1 */
	 u_int8_t dc_state;
	/* Description - 0-no limit, 1-outstanding reads, 2-fence, 3-strong ordering, 4-fc_seq_initiative, 5-outstanding psn, 6-dc wait for connect, 7-e2e credit (limited state)
EAS NAME: N/A
idle value: 0 */
	/* 8.17 - 8.19 */
	 u_int8_t limited_qp;
	/* Description -  2^value is the frequency at which we send ackreq.valid.
values are 0-8 giving ackreq bit per 1-256 packets
EAS NAME: ack_req_freq */
	/* 8.20 - 8.23 */
	 u_int8_t ack_req_frequency;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 8.24 - 8.24 */
	 u_int8_t tcu_trap;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - 
EAS NAME: N/A */
	/* 8.26 - 8.26 */
	 u_int8_t tcu_drop;
	/* Description - Hermon name: bind_enable */
	/* 8.28 - 8.28 */
	 u_int8_t umr_enable;
	/* Description - enable fast register WQE
Hermon name: frwr_en
EAS NAME: fre */
	/* 8.29 - 8.29 */
	 u_int8_t frwr_enable;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - index updated when poping from ldb (ldb_index)
EAS NAME: N/A
idle value: Send.swqe_consumer_index */
	/* 12.16 - 16.31 */
	 u_int16_t currently_completing_wqe_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
	/* Description - 
EAS NAME: sq_wqe_counter */
	/* 16.16 - 20.31 */
	 u_int16_t swqe_consumer_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn - Send.psn_since_ackreq */
	/* 20.0 - 20.23 */
	 u_int32_t oldest_non_acked_psn;
	/* Description - ACKREQ_PSN (PSN of last packet sent with ACKREQ=1, virtual field for timer decision) = QP.next_to_send_psn - 1 - QP.PSN_since_ACKREQ
EAS NAME: N/A */
	/* 20.24 - 24.31 */
	 u_int8_t psn_since_ackreq;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - copied from packet on first ack
EAS NAME: N/A
condition:ts==DCI */
	/* 24.0 - 24.23 */
	 u_int32_t responder_session_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - 
EAS NAME: next_send_psn */
	/* 32.8 - 36.31 */
	 u_int32_t next_to_send_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - 
EAS NAME: ssn */
	/* 36.0 - 36.23 */
	 u_int32_t ssn;
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 40.15 - 40.15 */
	 u_int8_t force_grh_tclass;
	/* Description - 
EAS NAME: N/A
condition:ts==DCI */
	/* 40.16 - 40.19 */
	 u_int8_t reverse_sl;
	/* Description - 
EAS NAME: cur_retry_cnt */
	/* 40.20 - 40.22 */
	 u_int8_t to_sequence_error_retry_counter;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - How many bytes were sent from current WQE
LSO byte granularty, otherwise 256B granularty
EAS NAME: N/A
idle value: 0 */
	/* 44.0 - 44.22 */
	 u_int32_t sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid)
condition:ts==DCI | ts==UD */
	/* 44.23 - 44.23 */
	 u_int8_t force_my_gid_index;
	/* Description - 
EAS NAME: retry_count */
	/* 44.24 - 44.26 */
	 u_int8_t to_sequence_error_retry_limit;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
EAS NAME: N/A
idle value: Send.next_to_send_psn */
	/* 56.0 - 56.23 */
	 u_int32_t first_psn_of_message_currently_completing;
	/* Description - value 0 means that we are not in the middle of a read response
read middle: if DS is too big rx slice should skip the REQSL machine
EAS NAME: N/A
idle value: 0 */
	/* 56.24 - 56.29 */
	 u_int8_t currently_completing_ds;
	/* Description -  */
	/* 56.30 - 56.30 */
	 u_int8_t timer_enable;
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 56.31 - 60.31 */
	 u_int8_t force_grh;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Hermon: highest_psn
EAS NAME: N/A */
	/* 60.0 - 60.23 */
	 u_int32_t first_unsent_psn;
	/* Description - Counts number of outstanding reads and atomic
EAS NAME: N/A
idle value: 0 */
	/* 60.24 - 64.31 */
	 u_int8_t number_outstanding_reads;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_s_qpc_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - This QP should use the fast_path inside the device
condition:ts!=DCR */
	/* 0.11 - 0.11 */
	 u_int8_t fast_path;
	/* Description - TPT: umr permission table
there are four masks each with a different permissions level
qp has umr_permission_level field which points to one of these four masks.
golan.tpt.tpt_memop.tpt_memop_execution_machine.allow_mkey_context_update_bitmask[0-3]*
 */
	/* 0.24 - 0.25 */
	 u_int8_t umr_permission_select;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t qp_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 8.25 - 8.25 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - Hermon name: bind_enable */
	/* 8.28 - 8.28 */
	 u_int8_t umr_enable;
	/* Description - enable fast register WQE
Hermon name: frwr_en
EAS NAME: fre */
	/* 8.29 - 8.29 */
	 u_int8_t frwr_enable;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 8.31 - 12.31 */
	 u_int8_t rx_heartbeat;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: state */
	/* 16.0 - 16.15 */
	 u_int16_t qp_state;
	/* Description - 
EAS NAME: sq_wqe_counter */
	/* 16.16 - 20.31 */
	 u_int16_t swqe_consumer_index;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
if ts!=DCR cq_number
if ts == DCR dct_number
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 28.0 - 28.23 */
	 u_int32_t cq_number;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 u_int8_t flush_syndrom;
	/* Description - 
EAS NAME: next_send_psn */
	/* 32.8 - 36.31 */
	 u_int32_t next_to_send_psn;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - index to a table of counters that counts frame and bytes, oxff invalid - change to 0x00 as invalid
EAS NAME: if_counter_index */
	/* 36.24 - 40.31 */
	 u_int8_t counter_index;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 40.15 - 40.15 */
	 u_int8_t force_grh_tclass;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - How many bytes were sent from current WQE
LSO byte granularty, otherwise 256B granularty
EAS NAME: N/A
idle value: 0 */
	/* 44.0 - 44.22 */
	 u_int32_t sx_gather_commit;
	/* Description - if set gid index is taken from sqpc.mgid (my gid)
condition:ts==DCI | ts==UD */
	/* 44.23 - 44.23 */
	 u_int8_t force_my_gid_index;
	/* Description - set by SX on every packet sent or WQE executed */
	/* 44.27 - 44.27 */
	 u_int8_t sx_heartbeat;
	/* Description - Transport service (0-7: same as packet.BTH.opcode[7:5])
0-RC
1-UC
2-RD (reserved)
3-UD
5-XRC (SRC in hermon)
8-RMC parent - no in golan1
9-RMC child (RX only) no in golan1
10-FCP - no in golan 1
11-DCI/DCR
12-DCT
15-L2 (Hermon name: L2 & MLX)
EAS NAME: st */
	/* 44.28 - 48.31 */
	 u_int8_t ts;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
condition:ts==DCI | ts==UD */
	/* 56.31 - 60.31 */
	 u_int8_t force_grh;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_unconnected_2cycbuff {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - WQE size: (2^this field)*16B
condition:rwq_type==RCYCLIC */
	/* 4.8 - 4.12 */
	 u_int8_t rcyclic_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - sx: used when WQE.Qkey[31]=1
TODO FCP: what about FCoIB
EAS NAME: q_key */
	/* 20.0 - 24.31 */
	 u_int32_t qkey;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_unconnected {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
	/* 4.8 - 4.11 */
	 u_int8_t rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
	/* 4.12 - 4.14 */
	 u_int8_t rwqe_stride;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - sx: used when WQE.Qkey[31]=1
TODO FCP: what about FCoIB
EAS NAME: q_key */
	/* 20.0 - 24.31 */
	 u_int32_t qkey;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_unconnected_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - sx: used when WQE.Qkey[31]=1
TODO FCP: what about FCoIB
EAS NAME: q_key */
	/* 20.0 - 24.31 */
	 u_int32_t qkey;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_connected_dual {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB port: all packets go to loopback port
Ethernet port: see IAS
see issue 32965
EAS NAME: fl */
	/* 0.3 - 0.3 */
	 u_int8_t force_loopback;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t dual_write;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
	/* 4.8 - 4.11 */
	 u_int8_t rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
	/* 4.12 - 4.14 */
	 u_int8_t rwqe_stride;
	/* Description - 
EAS NAME: stat_rate */
	/* 4.16 - 4.19 */
	 u_int8_t ipd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Dest Qp in connection
EAS NAME: remote_qpn/wire_qpn */
	/* 8.0 - 8.23 */
	 u_int32_t peer_qp;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 8.24 - 12.31 */
	 u_int8_t hop_limit;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
	/* Description - sx will put this field in the migreq field
Hermon: path_migration_fsm[1] */
	/* 12.30 - 12.30 */
	 u_int8_t sx_migreq;
	/* Description - tcu check will jump if pkt.migreq differ from this bit
Hermon: mig_req */
	/* 12.31 - 16.31 */
	 u_int8_t rx_migreq;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: flow_label */
	/* 16.0 - 16.19 */
	 u_int32_t flow_label;
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 24.24 - 24.28 */
	 u_int8_t max_message_size;
	/* Description - 0: 256 bytes  
1: 512 bytes  
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 24.29 - 28.31 */
	 u_int8_t mtu;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
EAS NAME: rlid */
	/* 28.0 - 28.15 */
	 u_int16_t peer_lid;
	/* Description - 
EAS NAME: mlid */
	/* 28.16 - 28.22 */
	 u_int8_t my_lid;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - this hold the 2'nd peer_qp for dual write
condition:dual_write */
	/* 56.0 - 56.23 */
	 u_int32_t peer_qp2;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - this hold the 2'nd peer_lid for dual write
condition:dual_write */
	/* 60.0 - 60.15 */
	 u_int16_t peer_lid2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_connected_2cycbuff {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB port: all packets go to loopback port
Ethernet port: see IAS
see issue 32965
EAS NAME: fl */
	/* 0.3 - 0.3 */
	 u_int8_t force_loopback;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t dual_write;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - WQE size: (2^this field)*16B
condition:rwq_type==RCYCLIC */
	/* 4.8 - 4.12 */
	 u_int8_t rcyclic_size;
	/* Description - 
EAS NAME: stat_rate */
	/* 4.16 - 4.19 */
	 u_int8_t ipd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Dest Qp in connection
EAS NAME: remote_qpn/wire_qpn */
	/* 8.0 - 8.23 */
	 u_int32_t peer_qp;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 8.24 - 12.31 */
	 u_int8_t hop_limit;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
	/* Description - sx will put this field in the migreq field
Hermon: path_migration_fsm[1] */
	/* 12.30 - 12.30 */
	 u_int8_t sx_migreq;
	/* Description - tcu check will jump if pkt.migreq differ from this bit
Hermon: mig_req */
	/* 12.31 - 16.31 */
	 u_int8_t rx_migreq;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: flow_label */
	/* 16.0 - 16.19 */
	 u_int32_t flow_label;
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 24.24 - 24.28 */
	 u_int8_t max_message_size;
	/* Description - 0: 256 bytes  
1: 512 bytes  
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 24.29 - 28.31 */
	 u_int8_t mtu;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
EAS NAME: rlid */
	/* 28.0 - 28.15 */
	 u_int16_t peer_lid;
	/* Description - 
EAS NAME: mlid */
	/* 28.16 - 28.22 */
	 u_int8_t my_lid;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 48.0 - 56.31 */
	 u_int64_t peer_gid_127_64;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 56.0 - 64.31 */
	 u_int64_t peer_gid_63_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_connected {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB port: all packets go to loopback port
Ethernet port: see IAS
see issue 32965
EAS NAME: fl */
	/* 0.3 - 0.3 */
	 u_int8_t force_loopback;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t dual_write;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
	/* 4.8 - 4.11 */
	 u_int8_t rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
	/* 4.12 - 4.14 */
	 u_int8_t rwqe_stride;
	/* Description - 
EAS NAME: stat_rate */
	/* 4.16 - 4.19 */
	 u_int8_t ipd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Dest Qp in connection
EAS NAME: remote_qpn/wire_qpn */
	/* 8.0 - 8.23 */
	 u_int32_t peer_qp;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 8.24 - 12.31 */
	 u_int8_t hop_limit;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
	/* Description - sx will put this field in the migreq field
Hermon: path_migration_fsm[1] */
	/* 12.30 - 12.30 */
	 u_int8_t sx_migreq;
	/* Description - tcu check will jump if pkt.migreq differ from this bit
Hermon: mig_req */
	/* 12.31 - 16.31 */
	 u_int8_t rx_migreq;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: flow_label */
	/* 16.0 - 16.19 */
	 u_int32_t flow_label;
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 24.24 - 24.28 */
	 u_int8_t max_message_size;
	/* Description - 0: 256 bytes  
1: 512 bytes  
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 24.29 - 28.31 */
	 u_int8_t mtu;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
EAS NAME: rlid */
	/* 28.0 - 28.15 */
	 u_int16_t peer_lid;
	/* Description - 
EAS NAME: mlid */
	/* 28.16 - 28.22 */
	 u_int8_t my_lid;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 48.0 - 52.31 */
	 u_int32_t peer_gid_127_96;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 52.0 - 56.31 */
	 u_int32_t peer_gid_95_64;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 56.0 - 60.31 */
	 u_int32_t peer_gid_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - 
condition:~dual_write */
	/* 60.0 - 64.31 */
	 u_int32_t peer_gid_31_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_connected_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB port: all packets go to loopback port
Ethernet port: see IAS
see issue 32965
EAS NAME: fl */
	/* 0.3 - 0.3 */
	 u_int8_t force_loopback;
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t dual_write;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
	/* Description - 
EAS NAME: stat_rate */
	/* 4.16 - 4.19 */
	 u_int8_t ipd;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Dest Qp in connection
EAS NAME: remote_qpn/wire_qpn */
	/* 8.0 - 8.23 */
	 u_int32_t peer_qp;
	/* Description - Number of hops between subnets a packet can make before being discarded
Used by TCU for CNP with GRH in connected mode
EAS NAME: hop_limit */
	/* 8.24 - 12.31 */
	 u_int8_t hop_limit;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
	/* Description - sx will put this field in the migreq field
Hermon: path_migration_fsm[1] */
	/* 12.30 - 12.30 */
	 u_int8_t sx_migreq;
	/* Description - tcu check will jump if pkt.migreq differ from this bit
Hermon: mig_req */
	/* 12.31 - 16.31 */
	 u_int8_t rx_migreq;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: flow_label */
	/* 16.0 - 16.19 */
	 u_int32_t flow_label;
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
	/* Description - 2^thisValue is the max number of bytes per mesaage
EAS NAME: msg_max */
	/* 24.24 - 24.28 */
	 u_int8_t max_message_size;
	/* Description - 0: 256 bytes  
1: 512 bytes  
2: 1K bytes 
3: 2K bytes 
4: 4k bytes
5: 8k bytes
EAS NAME: mtu */
	/* 24.29 - 28.31 */
	 u_int8_t mtu;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - 
EAS NAME: rlid */
	/* 28.0 - 28.15 */
	 u_int16_t peer_lid;
	/* Description - 
EAS NAME: mlid */
	/* 28.16 - 28.22 */
	 u_int8_t my_lid;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_c_qpc_common {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Work Queue Type
1: normal WQ
2: attached to SRQ
3: Receive Cyclic Buffer
EAS NAME: 1 enumeration is: srq */
	/* 0.4 - 0.5 */
	 u_int8_t rwq_type;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 0.30 - 0.30 */
	 u_int8_t wq_signature;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t common_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - UD-see force_grh_tclass
golan2: we should have 2 tclass fields for ETHoIB enforcement
EAS NAME: tclass */
	/* 4.0 - 4.7 */
	 u_int8_t tclass;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 12.0 - 12.23 */
	 u_int32_t context_number;
	/* Description - If rwq_type==0 then 
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
    rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
    swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16  + masked_wqe_index*64
EAS NAME: page_offset */
	/* 12.24 - 12.29 */
	 u_int8_t wqe_page_offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 
EAS NAME: pkey_index */
	/* 16.20 - 20.31 */
	 u_int16_t pkey_table_index;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - access ICM with {GVMI, my_gid_index} to get GRH.MyGID, IPv6 and IPv4 use the same field
EAS NAME: mgid_index */
	/* 24.16 - 24.23 */
	 u_int8_t my_gid_mac_index;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - In DCE this field is {VLAN.prio, CFI\DA}
EAS NAME: Derived from sched_queue */
	/* 32.16 - 32.19 */
	 u_int8_t sl;
	/* Description - IB native only: packet should have GRH header
not used in UD/L2 responder
EAS NAME: grh */
	/* 32.20 - 32.20 */
	 u_int8_t grh_bit;
	/* Description - 
EAS NAME: Derived from sched_queue */
	/* 32.21 - 32.21 */
	 u_int8_t port_number;
	/* Description - mark packets as eligible for adaptive routing; supported on UC & UD transports
EAS NAME: free_ar */
	/* 32.22 - 32.22 */
	 u_int8_t adaptive_routing;
	/* Description - WQ size = 64B*2^value
EAS NAME: log_sq_size */
	/* 32.24 - 32.27 */
	 u_int8_t swqe_buffer_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 44.0 - 44.23 */
	 u_int32_t pd;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_pf_vf_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pcie sriov capability for pf */
	/* 0.0 - 8.31 */
	 struct connectib_pf_vf_sriov sriov;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - VPD capability for pf */
	/* 8.0 - 16.31 */
	 struct connectib_pf_vf_vpd vpd;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.9 */
	 u_int16_t hw_msix_vec0;
	/* Description - General MSIX function mask to all the function's vectors */
	/* 16.10 - 16.10 */
	 u_int8_t msix_func_mask;
	/* Description - NO_DESCR */
	/* 16.11 - 16.11 */
	 u_int8_t msix_enable;
	/* Description - pcie bus mastering for the function */
	/* 16.12 - 16.12 */
	 u_int8_t bus_master_en;
	/* Description - memory space enable
used for Golan only.
for Shomron, use command_register_memory_space */
	/* 16.13 - 16.13 */
	 u_int8_t memory_space;
	/* Description - valid for pf, rsvd for vf
used for Golan only.
for Shomron, use status_register_serr */
	/* 16.15 - 16.15 */
	 u_int8_t serr_status;
	/* Description - valid for pf, rsvd for vf
used for Golan only.
for Shomron, use command_register_serr_report_en */
	/* 16.16 - 16.16 */
	 u_int8_t serr_enable;
	/* Description - NO_DESCR
used for Golan only.
for Shomron, use command_register_perr_report_en */
	/* 16.17 - 16.17 */
	 u_int8_t perr_enable;
	/* Description - NO_DESCR */
	/* 16.18 - 16.18 */
	 u_int8_t int_disable;
	/* Description - Function got FLR, need to send event to driver */
	/* 16.19 - 16.19 */
	 u_int8_t need_to_fire_flr_event;
	/* Description - NO_DESCR */
	/* 16.20 - 16.20 */
	 u_int8_t in_middle_of_flr;
	/* Description - If set, this function power state is transparent to power management (L1) mechanism */
	/* 16.21 - 16.21 */
	 u_int8_t hide;
	/* Description - pcie logical Dstate */
	/* 16.22 - 16.23 */
	 u_int8_t power_state;
	/* Description - NO_DESCR */
	/* 16.24 - 20.31 */
	 u_int8_t cache_line;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - NO_DESCR */
	/* 20.0 - 20.7 */
	 u_int8_t interrupt_line;
	/* Description - NO_DESCR */
	/* 20.10 - 20.10 */
	 u_int8_t exp_rom_en;
	/* Description - NO_DESCR */
	/* 20.11 - 24.31 */
	 u_int32_t exp_rom_addr_31_11;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - PF - base. VF - RsvdP */
	/* 24.0 - 24.0 */
	 u_int8_t device_control_correctable_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.1 - 24.1 */
	 u_int8_t device_control_nonfatal_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.2 - 24.2 */
	 u_int8_t device_control_fatal_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.3 - 24.3 */
	 u_int8_t device_control_ur_error_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.4 - 24.4 */
	 u_int8_t device_control_enable_relaxed_ordering;
	/* Description - PF - base. VF - RsvdP */
	/* 24.5 - 24.7 */
	 u_int8_t device_control_max_payload_size;
	/* Description - PF - base. VF - RsvdP */
	/* 24.8 - 24.8 */
	 u_int8_t device_control_extended_tag_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.9 - 24.9 */
	 u_int8_t device_control_enable_no_snoop;
	/* Description - PF - base. VF - RsvdP */
	/* 24.10 - 24.12 */
	 u_int8_t device_control_max_read_request_size;
	/* Description -  */
	/* 24.13 - 24.13 */
	 u_int8_t device_status_correctable_error_detected;
	/* Description -  */
	/* 24.14 - 24.14 */
	 u_int8_t device_status_nonfatal_error_detected;
	/* Description -  */
	/* 24.15 - 24.15 */
	 u_int8_t device_status_fatal_error_detected;
	/* Description -  */
	/* 24.16 - 24.16 */
	 u_int8_t device_status_ur_error_detected;
	/* Description - PF - base. VF - RsvdP */
	/* 24.17 - 24.17 */
	 u_int8_t command_register_memory_space;
	/* Description - PF - base. VF - base */
	/* 24.18 - 24.18 */
	 u_int8_t command_register_bus_master_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.19 - 24.19 */
	 u_int8_t command_register_perr_report_en;
	/* Description - PF - base. VF - RsvdP */
	/* 24.20 - 24.20 */
	 u_int8_t command_register_serr_report_en;
	/* Description - PF - base. VF - 0 */
	/* 24.21 - 24.21 */
	 u_int8_t command_register_interrupt_disable;
	/* Description - PF - base. VF - 0 */
	/* 24.22 - 24.22 */
	 u_int8_t status_register_interrupt_status;
	/* Description -  */
	/* 24.23 - 24.23 */
	 u_int8_t status_register_perr;
	/* Description -  */
	/* 24.24 - 24.24 */
	 u_int8_t status_register_serr;
	/* Description -  */
	/* 24.25 - 24.25 */
	 u_int8_t status_register_received_master_abort;
	/* Description -  */
	/* 24.26 - 24.26 */
	 u_int8_t status_register_received_target_abort;
	/* Description -  */
	/* 24.27 - 24.27 */
	 u_int8_t status_register_detected_parity_error;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_init_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-init not started, 1-init in progress, 3 - init done */
	/* 0.0 - 0.1 */
	 u_int8_t init_state;
	/* Description - lock to prevent parallel init */
	/* 0.2 - 0.2 */
	 u_int8_t init_lock;
	/* Description - This VF owner PF */
	/* 0.16 - 0.19 */
	 u_int8_t owner_pf;
};

/* Description -  to be used in core2phy interface */
/* Size in bytes - 4 */
struct connectib_mlnx_enhanced_equal_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t mlpn_100kr4_extended_time_sup;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t mlpn_100cr4_extended_time_sup;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t mlpn_40cr4_extended_time_sup;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t mlpn_40kr4_extended_time_sup;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t mlpn_kr_extended_time_sup;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t edr_rx_atten_sup;
	/* Description -  */
	/* 0.6 - 0.10 */
	 u_int8_t edr_rx_atten;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t fdr_rx_atten_sup;
	/* Description -  */
	/* 0.12 - 0.16 */
	 u_int8_t fdr_rx_atten;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t qdr_ddr_ts3_rev;
};

/* Description -  mlpn cability (ability)/ admin (request) bits for ScratchPad (not in pages foramt) */
/* Size in bytes - 4 */
struct connectib_mlpn_database_all_protocol_bits_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t fdr_8_10;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t mlx_kr2;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t eth_56gb;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t fdr10;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t speed_reduction;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t width_reduction;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t eth_cbf;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t ib_64b_credits;
	/* Description - llr_en. ability/request according to node */
	/* 0.8 - 0.8 */
	 u_int8_t llr_ib_edr;
	/* Description - llr_en. ability/request according to node */
	/* 0.9 - 0.9 */
	 u_int8_t llr_ib_fdr;
	/* Description - llr_en. ability/request according to node */
	/* 0.10 - 0.10 */
	 u_int8_t llr_ib_fdr10;
	/* Description - llr_en. ability/request according to node */
	/* 0.11 - 0.11 */
	 u_int8_t llr_ib_qdr;
	/* Description - llr_en. ability/request according to node */
	/* 0.12 - 0.12 */
	 u_int8_t llr_ib_ddr;
	/* Description - llr_en. ability/request according to node */
	/* 0.13 - 0.13 */
	 u_int8_t llr_ib_sdr;
	/* Description - llr_en 56GBASE-KR4. ability/request according to node */
	/* 0.14 - 0.14 */
	 u_int8_t llr_56_kr4;
	/* Description - llr_en 56GBASE-KX4. ability/request according to node */
	/* 0.15 - 0.15 */
	 u_int8_t llr_56_kx4;
	/* Description - llr_en 40GBASE-KR4. ability/request according to node */
	/* 0.16 - 0.16 */
	 u_int8_t llr_kr4;
	/* Description - llr_en 40GBASE-CR4 (copper). ability/request according to node */
	/* 0.17 - 0.17 */
	 u_int8_t llr_cr4;
	/* Description - llr_en 40GBASE-S/LR4(optics). ability/request according to node */
	/* 0.18 - 0.18 */
	 u_int8_t llr_slr4;
	/* Description - llr_en 10GBASE-KR (XFI). ability/request according to node */
	/* 0.19 - 0.19 */
	 u_int8_t llr_kr;
	/* Description - llr_en 10GBASE-CR (copper). ability/request according to node */
	/* 0.20 - 0.20 */
	 u_int8_t llr_cr;
	/* Description - llr_en 10GBASE-S/LR(optics). ability/request according to node */
	/* 0.21 - 0.21 */
	 u_int8_t llr_slr;
	/* Description - llr_en 10GBASE-X (XAUI). ability/request according to node */
	/* 0.22 - 0.22 */
	 u_int8_t llr_xaui;
	/* Description - llr_en. ability/request according to node */
	/* 0.23 - 0.23 */
	 u_int8_t llr_sgmii;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0.25 - 0.25 */
	 u_int8_t fc_protocol;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0.26 - 0.26 */
	 u_int8_t eth_protocol;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0.27 - 0.27 */
	 u_int8_t ib_protocol;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t ib_64_66_spec_recovery;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0.29 - 0.29 */
	 u_int8_t ib_128b_llr;
	/* Description - in page0: protocol ability
in page2: protocol default (may set no more than one protocol bit, none - no default) */
	/* 0.30 - 0.30 */
	 u_int8_t ll_llr;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_serdes_preset_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_serdes_conf_preset_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_serdes_active_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - set0: half active fibre IB 8/10
set1: active fibre IB 8/10\
;set2: half active fibre IB FDR (64/66)
set3: active fibre IB FDR (64/66) */
	/* 0.0 - 32.31 */
	 struct connectib_serdes_active_rx_ini rx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - set0: half active fibre 8/10
set1: active fibre 8/10
set2: half active fibre FDR (64/66)
set3: active fibre FDR (64/66) */
	/* 32.0 - 48.31 */
	 struct connectib_serdes_active_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 120 */
struct connectib_serdes_force_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: forc
e fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set8: ffe initial
set9: for slicer4err calib */
	/* 0.0 - 80.31 */
	 struct connectib_serdes_force_rx_ini rx;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: forc
e fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set9: for slicer4err calib */
	/* 80.0 - 120.31 */
	 struct connectib_serdes_force_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_serdes_aba_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 0.0 - 256.31 */
	 struct connectib_serdes_conf_aba_rx_ini rx;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 256.0 - 384.31 */
	 struct connectib_serdes_conf_aba_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_serdes_autoneg_sets_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_serdes_conf_autoneg_rx_ini rx;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 384.31 */
	 struct connectib_serdes_conf_autoneg_tx_ini tx;
};

/* Description -   */
/* Size in bytes - 76 */
struct connectib_spec1_3_preset_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mask for the TX preset in FDR.
only the preset indexes that their bit is set in the mask will be checked. */
	/* 0.0 - 0.15 */
	 u_int16_t preset_tx_mask_internal;
	/* Description - mask for the TX preset in FDR.
only the preset indexes that their
bit is set in the mask will be checked. */
	/* 0.16 - 4.31 */
	 u_int16_t preset_tx_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.4 */
	 u_int8_t aba_mask0_start;
	/* Description -  */
	/* 4.8 - 4.12 */
	 u_int8_t aba_mask0_end;
	/* Description -  */
	/* 4.14 - 4.15 */
	 u_int8_t tx_ABA_en_mask;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t aba_mask0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.4 */
	 u_int8_t aba_mask1_start;
	/* Description -  */
	/* 8.8 - 8.12 */
	 u_int8_t aba_mask1_end;
	/* Description - mask per port 
ABA                = 0x0
ABA_legacy       = 0x1 */
	/* 8.14 - 8.15 */
	 u_int8_t tx_ABA_mode_mask;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t aba_mask1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.4 */
	 u_int8_t aba_mask2_start;
	/* Description -  */
	/* 12.8 - 12.12 */
	 u_int8_t aba_mask2_end;
	/* Description -  */
	/* 12.16 - 16.31 */
	 u_int16_t aba_mask2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.4 */
	 u_int8_t aba_mask3_start;
	/* Description -  */
	/* 16.8 - 16.12 */
	 u_int8_t aba_mask3_end;
	/* Description -  */
	/* 16.16 - 20.31 */
	 u_int16_t aba_mask3;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.4 */
	 u_int8_t aba_mask4_start;
	/* Description -  */
	/* 20.8 - 20.12 */
	 u_int8_t aba_mask4_end;
	/* Description -  */
	/* 20.16 - 24.31 */
	 u_int16_t aba_mask4;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.4 */
	 u_int8_t aba_mask5_start;
	/* Description -  */
	/* 24.8 - 24.12 */
	 u_int8_t aba_mask5_end;
	/* Description -  */
	/* 24.16 - 28.31 */
	 u_int16_t aba_mask5;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 76.31 */
	 struct connectib_aba_indexes aba_indexes;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_ib_ini_per_lcl_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t spec1_2_ib_support;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t spec1_3_ib_support;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t fec_request_fdr;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t fec_request_fdr10;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t heartbeat_enable;
	/* Description -  */
	/* 0.5 - 0.8 */
	 u_int8_t force_speed_val;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t force_speed_en;
	/* Description -  */
	/* 0.10 - 0.13 */
	 u_int8_t force_width_val;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t force_width_en;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t force_qdr_is_fdr10_val;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t force_qdr_is_fdr10_en;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t force_llr_fdr_en;
	/* Description -  */
	/* 0.18 - 0.18 */
	 u_int8_t force_llr_fdr_val;
	/* Description -  */
	/* 0.19 - 0.19 */
	 u_int8_t force_llr_fdr10_en;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t force_llr_fdr10_val;
	/* Description -  */
	/* 0.21 - 0.21 */
	 u_int8_t mlpn_en;
	/* Description -  */
	/* 0.22 - 0.22 */
	 u_int8_t llr_cell_size;
	/* Description -  */
	/* 0.23 - 0.23 */
	 u_int8_t speed_reduction_force;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t width_reduction_force;
	/* Description -  */
	/* 0.25 - 0.25 */
	 u_int8_t llr_fdr10_force;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t llr_fdr_force;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t spec1_2_legacy_mode;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t llr_disable_failsafe;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_serdes_param_mask_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_8_10;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_64_66;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_serdes_param_mask_per_proto_ini encode_kr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_serdes_param_mask_per_proto_ini fdr;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_tpt_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 when log_max_payload_size is configurable */
	/* 0.31 - 4.31 */
	 u_int8_t log_max_payload_size_supported;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_tpt_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - Automatically choose the burst length according to the PCIe packet length.
12 - A maximum of 4kb.
Else - reserved */
	/* 0.0 - 0.3 */
	 u_int8_t log_max_payload_size;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_nv_tlv_data_pci_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 when the max_pf_uar_bar_size field is configurable and the max_log_pf_uar_bar_size field is valid */
	/* 0.24 - 0.24 */
	 u_int8_t pf_bar_size_supported;
	/* Description - 1 when the max_vf_uar_bar_size field is configurable and the max_log_vf_uar_bar_size field is valid */
	/* 0.25 - 0.25 */
	 u_int8_t vf_bar_size_supported;
	/* Description - 1 when the num_pf_msix field is configurable and the max_num_pf_msix field is valid */
	/* 0.26 - 0.26 */
	 u_int8_t num_pf_msix_supported;
	/* Description - 1 when the num_vf_msix field is configurable and the max_num_vf_msix field is valid */
	/* 0.27 - 0.27 */
	 u_int8_t num_vf_msix_supported;
	/* Description - 1 when the num_pfs field is configurable and max_num_pfs is valid */
	/* 0.28 - 0.28 */
	 u_int8_t num_pfs_supported;
	/* Description - 1 when the max_total_bar field is valid */
	/* 0.29 - 0.29 */
	 u_int8_t max_log_total_bar_valid;
	/* Description - The max_total_msix field is valid */
	/* 0.30 - 0.30 */
	 u_int8_t max_total_msix_valid;
	/* Description - 1 when the max_vfs_per_pf field below is valid */
	/* 0.31 - 4.31 */
	 u_int8_t max_vfs_per_pf_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The maximum number of VFs that can be set in the total_vfs setting (per PF) */
	/* 4.0 - 4.15 */
	 u_int16_t max_vfs_per_pf;
	/* Description - Maximum total number of PFs */
	/* 4.16 - 4.19 */
	 u_int8_t max_num_pfs;
	/* Description - 1 - function per-port setting is configurable */
	/* 4.29 - 4.29 */
	 u_int8_t fpp_support;
	/* Description - 1 - The device supports controlling the VF QoS setting */
	/* 4.30 - 4.30 */
	 u_int8_t vf_qos_control_support;
	/* Description - 1 when SRIOV support is configurable */
	/* 4.31 - 8.31 */
	 u_int8_t sriov_support;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log 2 of the maximum size of a PFs UAR BAR */
	/* 8.0 - 8.5 */
	 u_int8_t max_log_pf_uar_bar_size;
	/* Description - Log 2 of the maximum size of a VFs UAR BAR */
	/* 8.6 - 8.11 */
	 u_int8_t max_log_vf_uar_bar_size;
	/* Description - Maximum number of MSI-X vectors and EQs per PF */
	/* 8.12 - 8.21 */
	 u_int16_t max_num_pf_msix;
	/* Description - Maximum number of MSI-X vectors and EQs per VF */
	/* 8.22 - 12.31 */
	 u_int16_t max_num_vf_msix;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Maximum number of MSI-X for the aggregate of all PFs and VFs */
	/* 12.0 - 16.31 */
	 u_int32_t max_total_msix;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Mmaximum total of the MMIO space for all PFs and VFs combined in MBytes */
	/* 16.0 - 20.31 */
	 u_int32_t max_total_bar_MB;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_nv_tlv_data_pci_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 when the log_pf_uar_bar_size field is valid */
	/* 0.24 - 0.24 */
	 u_int8_t pf_bar_size_valid;
	/* Description - 1 when the log_vf_uar_bar_size field is valid */
	/* 0.25 - 0.25 */
	 u_int8_t vf_bar_size_valid;
	/* Description - 1 when the num_pf_msix field is valid */
	/* 0.26 - 0.26 */
	 u_int8_t num_pf_msix_valid;
	/* Description - 1 when the num_vf_msix field is valid */
	/* 0.27 - 0.27 */
	 u_int8_t num_vf_msix_valid;
	/* Description - 1 when the num_pfs field is valid */
	/* 0.28 - 0.28 */
	 u_int8_t num_pfs_valid;
	/* Description - 1 when the fpp_en field is valid */
	/* 0.29 - 0.29 */
	 u_int8_t fpp_valid;
	/* Description - 1 when the full_vf_qos field below is valid */
	/* 0.30 - 0.30 */
	 u_int8_t full_vf_qos_valid;
	/* Description - 1 when the sriov_en and total_vfs fields below are valid */
	/* 0.31 - 4.31 */
	 u_int8_t sriov_valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of VFs that can be supported */
	/* 4.0 - 4.15 */
	 u_int16_t total_vfs;
	/* Description - Total number of PFs */
	/* 4.16 - 4.19 */
	 u_int8_t num_pfs;
	/* Description - 0 - a single PF for both ports
1 - function per-port */
	/* 4.29 - 4.29 */
	 u_int8_t fpp_en;
	/* Description - 0 - Use reduced QoS support level on VFs
1 - Support full QoS on VFs */
	/* 4.30 - 4.30 */
	 u_int8_t full_vf_qos;
	/* Description - 1 when SRIOV is enabled: SRIOV capability will appear on the PCI configuration header */
	/* 4.31 - 8.31 */
	 u_int8_t sriov_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log 2 of the size of a PFs UAR BAR in MB */
	/* 8.0 - 8.5 */
	 u_int8_t log_pf_uar_bar_size;
	/* Description - Log 2 of the size of a VFs UAR BAR in MB */
	/* 8.6 - 8.11 */
	 u_int8_t log_vf_uar_bar_size;
	/* Description - Number of MSI-X vectors and EQs per PF */
	/* 8.12 - 8.21 */
	 u_int16_t num_pf_msix;
	/* Description - Number of MSI-X vectors and EQs per VF */
	/* 8.22 - 12.31 */
	 u_int16_t num_vf_msix;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_header_log {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t hdr_127_96;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t hdr_95_64;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t hdr_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t hdr_31_0;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_advanced_error_cap_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The first error reported in the Uncorrectable Error
5'd15 : //CA(nsi) : can not happened, not supported by HW
5'd0  : //Undefined (Previously was Link Training Error of PHy)
5'd4  : //DLU  : log 32 MSB of the received DLLPs (not compliant)  
5'd13 : //FCPE : have no hdr to log
5'd19 : //ECRC
5'd18 : //ML
5'd17 : //OVF
5'd16 : //UX
5'd20 : //UR
5'd15 : //CA(drx)  : have no hdr to log (not supported by HW in CX3)
5'd12 : //Poison
5'd14 : // CTO : have no hdr to log */
	/* 0.0 - 0.4 */
	 u_int8_t first_error_pointer;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t ecrc_generation_cap;
	/* Description - This bit when set enables ECRC generation (see Section 2.7).
 Default value of this field is 0.
RWS */
	/* 0.6 - 0.6 */
	 u_int8_t ecrc_generation_enable;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t ecrc_check_cap;
	/* Description - This bit when set enables ECRC checking (see Section 2.7).
Default value of this field is 0.
RWS */
	/* 0.8 - 0.8 */
	 u_int8_t ecrc_check_enable;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_correctable_error_mask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0.0 - 0.0 */
	 u_int8_t receiver_error_mask;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t reserved3;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t reserved4;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t reserved5;
	/* Description - RWS */
	/* 0.6 - 0.6 */
	 u_int8_t bad_tlp_mask;
	/* Description - RWS */
	/* 0.7 - 0.7 */
	 u_int8_t bad_dllp_mask;
	/* Description - RWS */
	/* 0.8 - 0.8 */
	 u_int8_t replay_num_rollover_mask;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0.12 - 0.12 */
	 u_int8_t replay_timer_timeout_mask;
	/* Description - Advisory Non-Fatal Error Mask.
This bit is Set by default to enable compatibility with software that
does not comprehend Role-Based Error Reporting */
	/* 0.13 - 0.13 */
	 u_int8_t advisory_non_fatal_err_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_correctable_error_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RW1CS */
	/* 0.0 - 0.0 */
	 u_int8_t receiver_error_status;
	/* Description - RW1CS */
	/* 0.6 - 0.6 */
	 u_int8_t bad_tlp_status;
	/* Description - RW1CS */
	/* 0.7 - 0.7 */
	 u_int8_t bad_dllp_status;
	/* Description - RW1CS */
	/* 0.8 - 0.8 */
	 u_int8_t replay_num_rollover_status;
	/* Description - RW1CS */
	/* 0.12 - 0.12 */
	 u_int8_t replay_timer_timeout_status;
	/* Description - Advisory Non-Fatal Error Status
RW1CS */
	/* 0.13 - 0.13 */
	 u_int8_t advisory_nonftl_err_status;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_severity {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0.0 - 0.0 */
	 u_int8_t training_error_severity;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t reserved3;
	/* Description - RWS */
	/* 0.4 - 0.4 */
	 u_int8_t data_link_protocol_error;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t reserved5;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t reserved6;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t reserved7;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t reserved8;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0.12 - 0.12 */
	 u_int8_t poisoned_tlp;
	/* Description - RWS */
	/* 0.13 - 0.13 */
	 u_int8_t flow_control_protocol_error;
	/* Description - RWS */
	/* 0.14 - 0.14 */
	 u_int8_t completion_timeout;
	/* Description - RWS */
	/* 0.15 - 0.15 */
	 u_int8_t completer_abort;
	/* Description - RWS */
	/* 0.16 - 0.16 */
	 u_int8_t unexpected_completion;
	/* Description - RWS */
	/* 0.17 - 0.17 */
	 u_int8_t receiver_overflow;
	/* Description - RWS */
	/* 0.18 - 0.18 */
	 u_int8_t malformed_tlp;
	/* Description - RWS */
	/* 0.19 - 0.19 */
	 u_int8_t ecrc_error;
	/* Description - RWS */
	/* 0.20 - 0.20 */
	 u_int8_t unsupported_request_error;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_mask {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - RWS */
	/* 0.0 - 0.0 */
	 u_int8_t training_error_mask;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t reserved1;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t reserved2;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t reserved3;
	/* Description - RWS */
	/* 0.4 - 0.4 */
	 u_int8_t data_link_protocol_error;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t reserved5;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t reserved6;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t reserved7;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t reserved8;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t reserved9;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t reserved10;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t reserved11;
	/* Description - RWS */
	/* 0.12 - 0.12 */
	 u_int8_t poisoned_tlp;
	/* Description - RWS */
	/* 0.13 - 0.13 */
	 u_int8_t flow_control_protocol_error;
	/* Description - RWS */
	/* 0.14 - 0.14 */
	 u_int8_t completion_timeout;
	/* Description - RWS */
	/* 0.15 - 0.15 */
	 u_int8_t completer_abort;
	/* Description - RWS */
	/* 0.16 - 0.16 */
	 u_int8_t unexpected_completion;
	/* Description - RWS */
	/* 0.17 - 0.17 */
	 u_int8_t receiver_overflow;
	/* Description - RWS */
	/* 0.18 - 0.18 */
	 u_int8_t malformed_tlp;
	/* Description - RWS */
	/* 0.19 - 0.19 */
	 u_int8_t ecrc_error;
	/* Description - RWS */
	/* 0.20 - 0.20 */
	 u_int8_t unsupported_request_error;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_uncorrectable_error_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Undefined
previously was training_error_status */
	/* 0.0 - 0.0 */
	 u_int8_t training_error_status;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t data_link_protocol_error_status;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t poisoned_tlp_status;
	/* Description -  */
	/* 0.13 - 0.13 */
	 u_int8_t flow_control_protocol_error_status;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t completion_timeout_status;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t completer_abort_status;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t unexpected_completion_status;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t receiver_overflow_status;
	/* Description -  */
	/* 0.18 - 0.18 */
	 u_int8_t malformed_tlp_status;
	/* Description -  */
	/* 0.19 - 0.19 */
	 u_int8_t ecrc_error_status;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t unsupported_request_error_status;
};

/* Description -  Basic address register high bits - for 64bit bar address length */
/* Size in bytes - 4 */
struct connectib_bar_high {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - BAR[63:32] */
	/* 0.0 - 4.31 */
	 u_int32_t addr_63_32;
};

/* Description -  Basic address register low bits */
/* Size in bytes - 4 */
struct connectib_bar_low {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0-map to memory space, 1-map to io space */
	/* 0.0 - 0.0 */
	 u_int8_t memory_or_io;
	/* Description - address length: 0-mapping to the 32bit address space, 2-mapping to the 64bit address space */
	/* 0.1 - 0.2 */
	 u_int8_t type;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t prefetchable;
	/* Description - BAR[31:4] */
	/* 0.4 - 4.31 */
	 u_int32_t addr_31_4;
};

/* Description -  SR-IOV status register */
/* Size in bytes - 2 */
struct connectib_sriov_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF Migration Status */
	/* 0.0 - 0.0 */
	 u_int8_t vf_mig_status;
};

/* Description -  SR-IOV control register */
/* Size in bytes - 2 */
struct connectib_sriov_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF Enable */
	/* 0.0 - 0.0 */
	 u_int8_t vf_enable;
	/* Description - VF Migration Enable */
	/* 0.1 - 0.1 */
	 u_int8_t vf_migration_en;
	/* Description - VF Migration Interrupt Enable */
	/* 0.2 - 0.2 */
	 u_int8_t vf_migration_int_en;
	/* Description - VF MSE */
	/* 0.3 - 0.3 */
	 u_int8_t vf_mse;
	/* Description - ARI Capable Hierarchy */
	/* 0.4 - 0.4 */
	 u_int8_t ari_capable_hierarchy;
};

/* Description -  SR-IOV capability struct */
/* Size in bytes - 4 */
struct connectib_sriov_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - VF migration capable */
	/* 0.0 - 0.0 */
	 u_int8_t vf_mig_capable;
	/* Description - ARI Capable Hierarchy Preserved */
	/* 0.1 - 0.1 */
	 u_int8_t ari_cap_hier_preserved;
	/* Description - VF Migration Interrupt Message Number */
	/* 0.21 - 4.31 */
	 u_int16_t vf_mig_int_msg_num;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_ari_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t mfvc_en;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t acs_en;
	/* Description -  */
	/* 0.4 - 0.6 */
	 u_int8_t func_group;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_ari_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t mfvc;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t acs;
	/* Description - next pf number */
	/* 0.8 - 0.15 */
	 u_int8_t next_func_num;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_lane_eql_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t downstream_port_transmitter_preset0;
	/* Description -  */
	/* 0.4 - 0.6 */
	 u_int8_t downstream_port_receiver_preset_hint0;
	/* Description -  */
	/* 0.8 - 0.11 */
	 u_int8_t upstream_port_transmitter_preset0;
	/* Description -  */
	/* 0.12 - 0.14 */
	 u_int8_t upstream_port_receiver_preset_hint0;
	/* Description -  */
	/* 0.16 - 0.19 */
	 u_int8_t downstream_port_transmitter_preset1;
	/* Description -  */
	/* 0.20 - 0.22 */
	 u_int8_t downstream_port_receiver_preset_hint1;
	/* Description -  */
	/* 0.24 - 0.27 */
	 u_int8_t upstream_port_transmitter_preset1;
	/* Description -  */
	/* 0.28 - 0.30 */
	 u_int8_t upstream_port_receiver_preset_hint1;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pciex_link_ctl3 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t perform_equalization;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t link_equalization_req_int_en;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_message_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - num of msix vectors */
	/* 0.0 - 0.10 */
	 u_int16_t table_size;
	/* Description - If 1, all vectors of this function are masked regardless of their per vector mask bit   */
	/* 0.14 - 0.14 */
	 u_int8_t function_mask;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t msix_en;
};

/* Description -  PCI express link status register2 */
/* Size in bytes - 2 */
struct connectib_link_stat2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t current_de_emphasis_level;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t equalization_complete;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t equalization_phase1_successful;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t equalization_phase2_successful;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t equalization_phase3_successful;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t link_equalization_request;
};

/* Description -  PCI express link control register2 */
/* Size in bytes - 2 */
struct connectib_link_ctl2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t target_link_speed;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t enter_compliance;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t hardware_autonomus_speed_disable;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t selectable_de_emphasis;
	/* Description -  */
	/* 0.7 - 0.9 */
	 u_int8_t transmit_margin;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t modified_compliance;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t compliance_sos;
	/* Description -  */
	/* 0.12 - 0.15 */
	 u_int8_t compliance_preset_de_emphasis;
};

/* Description -  PCI express link capabilities register2 */
/* Size in bytes - 4 */
struct connectib_link_caps2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.1 - 0.7 */
	 u_int8_t supported_link_speed_vector;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t cross_link_supported;
};

/* Description -  PCI express device status register2 */
/* Size in bytes - 2 */
struct connectib_device_stat2 {
};

/* Description -  PCI express device control register2 */
/* Size in bytes - 2 */
struct connectib_device_ctl2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t completion_timeout_value;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t completion_timeout_disable;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t ari_forwarding_enable;
	/* Description -  */
	/* 0.13 - 0.14 */
	 u_int8_t obff_enable;
};

/* Description -  PCI express device capabilities register2 */
/* Size in bytes - 4 */
struct connectib_device_caps2 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t completion_timeout_ranges_supported;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t completion_timeout_disable_supported;
	/* Description -  */
	/* 0.5 - 0.7 */
	 u_int8_t ari_forwarding_supported;
	/* Description -  */
	/* 0.18 - 0.19 */
	 u_int8_t obff_supported;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t extended_fmt_field_supported;
};

/* Description -  PCI express link status register */
/* Size in bytes - 2 */
struct connectib_link_stat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t link_speed;
	/* Description -  */
	/* 0.4 - 0.9 */
	 u_int8_t negotiated_link_width;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t training_error;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t link_training;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t slot_clock_cfg;
};

/* Description -  PCI express link control register */
/* Size in bytes - 2 */
struct connectib_link_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.1 */
	 u_int8_t aspm_control;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t rcb;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t common_clock_configuration;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t extended_synch;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t enable_clock_power_management;
};

/* Description -  PCI express link capabilities register */
/* Size in bytes - 4 */
struct connectib_link_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t max_link_speed;
	/* Description -  */
	/* 0.4 - 0.9 */
	 u_int8_t max_link_width;
	/* Description -  */
	/* 0.10 - 0.11 */
	 u_int8_t aspm_support;
	/* Description -  */
	/* 0.12 - 0.14 */
	 u_int8_t l0s_exit_latency;
	/* Description -  */
	/* 0.15 - 0.17 */
	 u_int8_t l1_exit_latency;
	/* Description -  */
	/* 0.18 - 0.18 */
	 u_int8_t clock_power_management;
	/* Description -  */
	/* 0.19 - 0.19 */
	 u_int8_t surprise_down_error_reporting_cap;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t link_active_reporting_cap;
	/* Description -  */
	/* 0.21 - 0.21 */
	 u_int8_t link_bw_notification_cap;
	/* Description -  */
	/* 0.22 - 0.22 */
	 u_int8_t aspm_optionality_compliance;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t port_number;
};

/* Description -  PCI express device status register */
/* Size in bytes - 2 */
struct connectib_device_stat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t correctable_error;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t non_fatal_error;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t fatal_error;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t unsupported_request;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t aux_power;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t transactions_pending;
};

/* Description -  PCI express device control register */
/* Size in bytes - 2 */
struct connectib_device_ctl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t correctable_error_report;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t non_fatal_error_report;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t fatal_error_report;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t unsupported_request_report;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t relaxed_ordering;
	/* Description -  */
	/* 0.5 - 0.7 */
	 u_int8_t max_payload_size;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t extended_tag_field_en;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t phantom_funcs;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t aux_power;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t no_snoop;
	/* Description -  */
	/* 0.12 - 0.14 */
	 u_int8_t max_read_request_size;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t initiate_function_level_reset;
};

/* Description -  PCI express device capabilities register */
/* Size in bytes - 4 */
struct connectib_device_caps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.2 */
	 u_int8_t max_payload_size_supported;
	/* Description -  */
	/* 0.3 - 0.4 */
	 u_int8_t phantom_funcs;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t extended_tag_field_sup;
	/* Description -  */
	/* 0.6 - 0.8 */
	 u_int8_t l0s_acceptable_latency;
	/* Description -  */
	/* 0.9 - 0.11 */
	 u_int8_t l1_acceptable_latency;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t role_based_error_reporting;
	/* Description -  */
	/* 0.18 - 0.25 */
	 u_int8_t captured_slot_power_limit_value;
	/* Description -  */
	/* 0.26 - 0.27 */
	 u_int8_t captured_slot_power_limit_scale;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t function_level_reset_capability;
};

/* Description -  PCI express device capabilities reg1 */
/* Size in bytes - 2 */
struct connectib_pciex_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t version;
	/* Description -  */
	/* 0.4 - 0.7 */
	 u_int8_t device_port_type;
	/* Description - slot implemented */
	/* 0.9 - 0.9 */
	 u_int8_t slot;
	/* Description -  */
	/* 0.10 - 0.14 */
	 u_int8_t int_message_num;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_exp_rom {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - expansion ROM exist */
	/* 0.0 - 0.0 */
	 u_int8_t exp_rom_en;
	/* Description - ADDR[31:11] */
	/* 0.11 - 4.31 */
	 u_int32_t addr_31_11;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_stat_reg1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t int_status;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t capabilities_list;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t master_data_perr;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t signaled_ta;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t received_ta;
	/* Description -  */
	/* 0.13 - 0.13 */
	 u_int8_t received_ma;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t signaled_serr;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t detected_perr;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_cmd_reg1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t io_space;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t memory_space;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t bus_master_en;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t perr_enable;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t serr_enable;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t int_disable;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_tlv_data_vpi_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t network_link_type_ib;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t network_link_type_eth;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t default_link_type_ib;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t default_link_type_eth;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dword_val {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t val;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_port_cap_mask1_fields {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t is_sm;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t is_notice_sup;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t is_trap_sup;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t is_optional_ipd_sup;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t is_automatic_migration_sup;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t is_sl_mapping_sup;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t is_mkey_nvram;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t is_pkey_nvram;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t is_led_info_sup;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t is_sm_disabled;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t is_system_image_guid_sup;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t is_pkey_switch_external_port_trap_sup;
	/* Description -  */
	/* 0.13 - 0.13 */
	 u_int8_t is_cable_info_supported;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t is_extended_speed_sup;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t is_capability_mask2_supported;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t is_communication_management_sup;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t is_snmp_tunneling_sup;
	/* Description -  */
	/* 0.18 - 0.18 */
	 u_int8_t is_reinit_sup;
	/* Description -  */
	/* 0.19 - 0.19 */
	 u_int8_t is_device_management_sup;
	/* Description -  */
	/* 0.20 - 0.20 */
	 u_int8_t is_vendor_class_sup;
	/* Description -  */
	/* 0.21 - 0.21 */
	 u_int8_t is_dr_notice_sup;
	/* Description -  */
	/* 0.22 - 0.22 */
	 u_int8_t is_capability_mask_notice_sup;
	/* Description -  */
	/* 0.23 - 0.23 */
	 u_int8_t is_boot_management_sup;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t is_link_round_trip_latency_sup;
	/* Description -  */
	/* 0.25 - 0.25 */
	 u_int8_t is_client_reregistration_sup;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t is_other_local_changes_notice_supported;
	/* Description -  */
	/* 0.27 - 0.27 */
	 u_int8_t is_link_speed_width_pairs_table_supported;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t is_vendor_specific_mads_table_supported;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t is_multicast_pkey_trap_suppression_supported;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t is_multicast_fdb_top_supported;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t is_hierarchy_info_supported;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_ib_port_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Total number of times the Port Training state machine has failed the link error recovery process and downed the link. Refer to the InfiniBand Architecture Specification, Volume 2, Link/Phy Interface. */
	/* 0.0 - 0.7 */
	 u_int8_t link_downed_counter;
	/* Description - Total number of times the Port Training state machine has successfully completed the link error recovery. */
	/* 0.8 - 0.15 */
	 u_int8_t link_error_recovery_counter;
	/* Description - Total number of minor link errors detected on one or more physical lanes. */
	/* 0.16 - 4.31 */
	 u_int16_t symbol_error_counter;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Total number of packets marked with the EBP delimiter received on the port. */
	/* 4.0 - 4.15 */
	 u_int16_t port_rcv_remote_physical_errors;
	/* Description - Total number of packets containing an error that were received on the port. */
	/* 4.16 - 8.31 */
	 u_int16_t port_rcv_errors;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t port_xmit_discards;
	/* Description - Total number of packets received on the port that were discarded because they could not be forwarded by the switch relay. */
	/* 8.16 - 12.31 */
	 u_int16_t port_rcv_switch_relay_errors;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of times that OverrunErrors consecutive flow control update periods occurred., each having at least one overrun error. */
	/* 12.0 - 12.3 */
	 u_int8_t excessive_buffer_overrun_errors;
	/* Description - The number of times that the count of local physical errors exceeded the threshold */
	/* 12.4 - 12.7 */
	 u_int8_t local_link_integrity_errors;
	/* Description - Total number of packets received on the port that are discarded. */
	/* 12.16 - 12.23 */
	 u_int8_t port_rcv_constraint_errors;
	/* Description - Total number of packets not transmitted from the port for the following reasons: " FilterRawOutbound is true and packet is raw " PartitionEnforcementOutbound is true and packet fails partition key check or IP version check */
	/* 12.24 - 16.31 */
	 u_int8_t port_xmit_constraint_errors;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of incoming VL15 packets dropped due to resource limitations (e.g., lack of buffers) in the port */
	/* 16.0 - 16.15 */
	 u_int16_t vl15_dropped;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of data octets, divided by 4, transmitted on all VLs from the port. This includes all octets between (and not including) the start of packet delimiter and the VCRC, and may include packets containing errors. */
	/* 20.0 - 24.31 */
	 u_int32_t port_xmit_data;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of data octets, divided by 4, received on all VLs at the port. This includes all octets between (and not including) the start of packet delimiter and the VCRC, and may include packets containing errors. */
	/* 24.0 - 28.31 */
	 u_int32_t port_rcv_data;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of packets transmitted on all VLs from the port. */
	/* 28.0 - 32.31 */
	 u_int32_t port_xmit_pkts;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Optional; shall be zero if not implemented. Total number of packets, including packets containing errors */
	/* 32.0 - 36.31 */
	 u_int32_t port_rcv_pkts;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - If ClassPortInfo:CapabilityMask.PortCountersXmitWaitSupported
is set to 1, the number of ticks during which the port
selected by PortSelect had data to transmit but no data was sent
during the entire tick either because of insufficient credits or
because of lack of arbitration.
Otherwise, undefined. */
	/* 36.0 - 40.31 */
	 u_int32_t port_xmit_wait;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_llr_counters {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of cells recieved (including bad cells) */
	/* 0.0 - 4.31 */
	 u_int32_t llr_rx_cells_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t llr_rx_cells_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The total number of bad cells recieved (including CRC error) */
	/* 8.0 - 12.31 */
	 u_int32_t llr_rx_error_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t llr_rx_error_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The total number of cells recieved with CRC error */
	/* 16.0 - 20.31 */
	 u_int32_t llr_rx_crc_error_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t llr_rx_crc_error_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The total number of cells transmitted (including retransmitted cells) */
	/* 24.0 - 28.31 */
	 u_int32_t llr_tx_cells_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t llr_tx_cells_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of cells retransmitted */
	/* 32.0 - 36.31 */
	 u_int32_t llr_tx_ret_cells_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t llr_tx_ret_cells_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of retransmission events */
	/* 40.0 - 44.31 */
	 u_int32_t llr_tx_ret_events_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t llr_tx_ret_events_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_discard_cntrs_grp_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t ingress_general_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t ingress_general_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t ingress_policy_engine_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t ingress_policy_engine_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t ingress_vlan_membership_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t ingress_vlan_membership_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t ingress_tag_frame_type_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t ingress_tag_frame_type_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 u_int32_t egress_vlan_membership_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t egress_vlan_membership_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t loopback_filter_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t loopback_filter_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t egress_general_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 u_int32_t egress_general_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 60.31 */
	 u_int32_t egress_link_down_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 64.31 */
	 u_int32_t egress_link_down_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 68.31 */
	 u_int32_t egress_hoq_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 68.0 - 72.31 */
	 u_int32_t egress_hoq_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 76.31 */
	 u_int32_t port_isolation_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description -  */
	/* 76.0 - 80.31 */
	 u_int32_t port_isolation_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description -  */
	/* 80.0 - 84.31 */
	 u_int32_t egress_policy_engine_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description -  */
	/* 84.0 - 88.31 */
	 u_int32_t egress_policy_engine_low;
};

/* Description -   */
/* Size in bytes - 200 */
struct connectib_phys_layer_cntrs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 0.0 - 4.31 */
	 u_int32_t time_since_last_clear_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The time passed since the last counters clear event in 
msec. */
	/* 4.0 - 8.31 */
	 u_int32_t time_since_last_clear_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Perf.PortCounters(SymbolErrorCounter)
 = Perf.Port
Counters(UnknownSymbol) */
	/* 8.0 - 12.31 */
	 u_int32_t symbol_errors_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Perf.PortCounters(SymbolErrorCounter)
 = Perf.Port
Counters(UnknownSymbol) */
	/* 12.0 - 16.31 */
	 u_int32_t symbol_errors_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(SynchHeaderError
Counter) */
	/* 16.0 - 20.31 */
	 u_int32_t sync_headers_errors_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(SynchHeaderError
Counter) */
	/* 20.0 - 24.31 */
	 u_int32_t sync_headers_errors_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane0Counter) / BIP error 
counter, lane 0
In PRBS test mode, indicates the number of PRBS errors 
on lane 0 */
	/* 24.0 - 28.31 */
	 u_int32_t edpl_bip_errors_lane0_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane0Counter) / BIP error 
counter, lane 0
In PRBS test mode, indicates the number of PRBS errors 
on lane 0 */
	/* 28.0 - 32.31 */
	 u_int32_t edpl_bip_errors_lane0_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane1Counter) / BIP error 
counter, lane 1
In PRBS test mode, indicates the number of PRBS errors 
on lane 1 */
	/* 32.0 - 36.31 */
	 u_int32_t edpl_bip_errors_lane1_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane1Counter) / BIP error 
counter, lane 1
In PRBS test mode, indicates the number of PRBS errors 
on lane 1 */
	/* 36.0 - 40.31 */
	 u_int32_t edpl_bip_errors_lane1_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane2Counter) / BIP error 
counter, lane 2
In PRBS test mode, indicates the number of PRBS errors 
on lane 2 */
	/* 40.0 - 44.31 */
	 u_int32_t edpl_bip_errors_lane2_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane2Counter) / BIP error 
counter, lane 2
In PRBS test mode, indicates the number of PRBS errors 
on lane 2 */
	/* 44.0 - 48.31 */
	 u_int32_t edpl_bip_errors_lane2_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane3Counter) / BIP error 
counter, lane 3
In PRBS test mode, indicates the number of PRBS errors 
on lane 3 */
	/* 48.0 - 52.31 */
	 u_int32_t edpl_bip_errors_lane3_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(ErrorDetectionPerLane3Counter) / BIP error 
counter, lane 3
In PRBS test mode, indicates the number of PRBS errors 
on lane 3 */
	/* 52.0 - 56.31 */
	 u_int32_t edpl_bip_errors_lane3_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 56.0 - 60.31 */
	 u_int32_t fc_fec_corrected_blocks_lane0_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 60.0 - 64.31 */
	 u_int32_t fc_fec_corrected_blocks_lane0_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 64.0 - 68.31 */
	 u_int32_t fc_fec_corrected_blocks_lane1_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 68.0 - 72.31 */
	 u_int32_t fc_fec_corrected_blocks_lane1_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 72.0 - 76.31 */
	 u_int32_t fc_fec_corrected_blocks_lane2_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 76.0 - 80.31 */
	 u_int32_t fc_fec_corrected_blocks_lane2_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 80.0 - 84.31 */
	 u_int32_t fc_fec_corrected_blocks_lane3_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 84.0 - 88.31 */
	 u_int32_t fc_fec_corrected_blocks_lane3_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 88.0 - 92.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane0_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane0) */
	/* 92.0 - 96.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane0_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 96.0 - 100.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane1_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane1) */
	/* 100.0 - 104.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane1_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 104.0 - 108.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane2_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane2) */
	/* 108.0 - 112.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane2_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 112.0 - 116.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane3_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Perf.PortExtendedSpeed
sCounters(FECCorrectableBlockCounterLane3) */
	/* 116.0 - 120.31 */
	 u_int32_t fc_fec_uncorrectable_blocks_lane3_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FECCorrecable
BlockCounter) */
	/* 120.0 - 124.31 */
	 u_int32_t rs_fec_corrected_blocks_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FECCorrecable
BlockCounter) */
	/* 124.0 - 128.31 */
	 u_int32_t rs_fec_corrected_blocks_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FEUncorrecable
BlockCounter) */
	/* 128.0 - 132.31 */
	 u_int32_t rs_fec_uncorrectable_blocks_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - Perf.PortExtendedSpeedsCounters(FEUncorrecable
BlockCounter) */
	/* 132.0 - 136.31 */
	 u_int32_t rs_fec_uncorrectable_blocks_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - The number of RS-FEC blocks received that had no 
errors.
Note: Total rs_fec blocks received = 
rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks 
+ rs_fec_no_errors_blocks */
	/* 136.0 - 140.31 */
	 u_int32_t rs_fec_no_errors_blocks_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - The number of RS-FEC blocks received that had no 
errors.
Note: Total rs_fec blocks received = 
rs_fec_corrected_blocks + rs_fec_uncorrectable_blocks 
+ rs_fec_no_errors_blocks */
	/* 140.0 - 144.31 */
	 u_int32_t rs_fec_no_errors_blocks_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - The number of corrected RS-FEC blocks received that 
had exactly 1 error symbol. 
Note: A FEC block that is counted by 
rs_fec_single_error_blocks is counted also by 
rs_fec_corrected_blocks */
	/* 144.0 - 148.31 */
	 u_int32_t rs_fec_single_error_blocks_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - The number of corrected RS-FEC blocks received that 
had exactly 1 error symbol. 
Note: A FEC block that is counted by 
rs_fec_single_error_blocks is counted also by 
rs_fec_corrected_blocks */
	/* 148.0 - 152.31 */
	 u_int32_t rs_fec_single_error_blocks_low;
/*---------------- DWORD[38] (Offset 0x98) ----------------*/
	/* Description - Perf.PortExtendedSpeedCounters(PortFECCorrect
edSymbolCounter) */
	/* 152.0 - 156.31 */
	 u_int32_t rs_fec_corrected_symbols_total_high;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - Perf.PortExtendedSpeedCounters(PortFECCorrect
edSymbolCounter) */
	/* 156.0 - 160.31 */
	 u_int32_t rs_fec_corrected_symbols_total_low;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane0) */
	/* 160.0 - 164.31 */
	 u_int32_t rs_fec_corrected_symbols_lane0_high;
/*---------------- DWORD[41] (Offset 0xa4) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane0) */
	/* 164.0 - 168.31 */
	 u_int32_t rs_fec_corrected_symbols_lane0_low;
/*---------------- DWORD[42] (Offset 0xa8) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane1) */
	/* 168.0 - 172.31 */
	 u_int32_t rs_fec_corrected_symbols_lane1_high;
/*---------------- DWORD[43] (Offset 0xac) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane1) */
	/* 172.0 - 176.31 */
	 u_int32_t rs_fec_corrected_symbols_lane1_low;
/*---------------- DWORD[44] (Offset 0xb0) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane2) */
	/* 176.0 - 180.31 */
	 u_int32_t rs_fec_corrected_symbols_lane2_high;
/*---------------- DWORD[45] (Offset 0xb4) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane2) */
	/* 180.0 - 184.31 */
	 u_int32_t rs_fec_corrected_symbols_lane2_low;
/*---------------- DWORD[46] (Offset 0xb8) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane3) */
	/* 184.0 - 188.31 */
	 u_int32_t rs_fec_corrected_symbols_lane3_high;
/*---------------- DWORD[47] (Offset 0xbc) ----------------*/
	/* Description - Perf.PortExtendedSpeed
Counters(FECCorrectedSymbolCounterLane3) */
	/* 188.0 - 192.31 */
	 u_int32_t rs_fec_corrected_symbols_lane3_low;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description - Perf.PortCounters(LinkDownedCounter) */
	/* 192.0 - 196.31 */
	 u_int32_t link_down_events;
/*---------------- DWORD[49] (Offset 0xc4) ----------------*/
	/* Description - Perf.PortCounters(LinkErrorRecoveryCounter) */
	/* 196.0 - 200.31 */
	 u_int32_t successful_recovery_events;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_per_traffic_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Contains the transmit queue depth in bytes on traffic class selected 
by 
traffic_class
 of the port selected by 
local_port
. */
	/* 0.0 - 4.31 */
	 u_int32_t transmit_queue_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Contains the transmit queue depth in bytes on traffic class selected 
by 
traffic_class
 of the port selected by 
local_port
. */
	/* 4.0 - 8.31 */
	 u_int32_t transmit_queue_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_per_prio_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of octets received, including framing characters. */
	/* 0.0 - 4.31 */
	 u_int32_t rx_octets_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of octets received, including framing characters. */
	/* 4.0 - 8.31 */
	 u_int32_t rx_octets_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of packets received for this priority (including control 
frames). */
	/* 32.0 - 36.31 */
	 u_int32_t rx_frames_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The total number of packets received for this priority (including control 
frames). */
	/* 36.0 - 40.31 */
	 u_int32_t rx_frames_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of octets transmitted, including framing characters. */
	/* 40.0 - 44.31 */
	 u_int32_t tx_octets_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of octets transmitted, including framing characters. */
	/* 44.0 - 48.31 */
	 u_int32_t tx_octets_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The total number of packets transmitted. */
	/* 72.0 - 76.31 */
	 u_int32_t tx_frames_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The total number of packets transmitted. */
	/* 76.0 - 80.31 */
	 u_int32_t tx_frames_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The total number of PAUSE frames received from the far-end port. */
	/* 80.0 - 84.31 */
	 u_int32_t rx_pause_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The total number of PAUSE frames received from the far-end port. */
	/* 84.0 - 88.31 */
	 u_int32_t rx_pause_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total time in microseconds that transmission of packets to the far-end 
port have been paused. */
	/* 88.0 - 92.31 */
	 u_int32_t rx_pause_duration_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total time in microseconds that transmission of packets to the far-end 
port have been paused. */
	/* 92.0 - 96.31 */
	 u_int32_t rx_pause_duration_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of PAUSE frames sent to the far-end port. */
	/* 96.0 - 100.31 */
	 u_int32_t tx_pause_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of PAUSE frames sent to the far-end port. */
	/* 100.0 - 104.31 */
	 u_int32_t tx_pause_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - The total time in microseconds that the far-end port have been requested 
to paused. */
	/* 104.0 - 108.31 */
	 u_int32_t tx_pause_duration_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - The total time in microseconds that the far-end port have been requested 
to paused. */
	/* 108.0 - 112.31 */
	 u_int32_t tx_pause_duration_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - Counts the number of transitions from Xoff to Xon. */
	/* 112.0 - 116.31 */
	 u_int32_t rx_pause_transition_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Counts the number of transitions from Xoff to Xon. */
	/* 116.0 - 120.31 */
	 u_int32_t rx_pause_transition_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_extended_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of ticks during which the port selected had data to 
transmit but no data was sent during the entire tick either because 
of insufficient credits or because of lack of arbitration.
A tick is a multiple of the time needed to transfer one byte on a 
single lane, that is, the symbol time. 
For example, for links operating at IBA SDR (single data rate), 
the symbol time is 4nsec. independent of the width of the link. 
For links operating at Ethernet 10GE on a single lane or 40GE on 
4 lanes, the symbol time is 0.8nSec. */
	/* 0.0 - 4.31 */
	 u_int32_t port_transmit_wait_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The number of ticks during which the port selected had data to 
transmit but no data was sent during the entire tick either because 
of insufficient credits or because of lack of arbitration.
A tick is a multiple of the time needed to transfer one byte on a 
single lane, that is, the symbol time. 
For example, for links operating at IBA SDR (single data rate), 
the symbol time is 4nsec. independent of the width of the link. 
For links operating at Ethernet 10GE on a single lane or 40GE on 
4 lanes, the symbol time is 0.8nSec. */
	/* 4.0 - 8.31 */
	 u_int32_t port_transmit_wait_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_3635_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - A count of frames received that are not an integral number 
of octets in length and do not pass the FCS check. */
	/* 0.0 - 4.31 */
	 u_int32_t dot3stats_alignment_errors_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - A count of frames received that are not an integral number 
of octets in length and do not pass the FCS check. */
	/* 4.0 - 8.31 */
	 u_int32_t dot3stats_alignment_errors_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - A count of frames received that are an integral number of 
octets in length but do not pass the FCS check. This count 
does not include frames received with frame-too-long or 
frame-too-short errors. */
	/* 8.0 - 12.31 */
	 u_int32_t dot3stats_fcs_errors_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - A count of frames received that are an integral number of 
octets in length but do not pass the FCS check. This count 
does not include frames received with frame-too-long or 
frame-too-short errors. */
	/* 12.0 - 16.31 */
	 u_int32_t dot3stats_fcs_errors_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - A count of frames that are involved in a single collision, 
and are subsequently transmitted successfully.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 16.0 - 20.31 */
	 u_int32_t dot3stats_single_collision_frames_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - A count of frames that are involved in a single collision, 
and are subsequently transmitted successfully.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 20.0 - 24.31 */
	 u_int32_t dot3stats_single_collision_frames_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - A count of frames that are involved in more than one colli
sion and are subsequently transmitted successfully. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 24.0 - 28.31 */
	 u_int32_t dot3stats_multiple_collision_frames_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - A count of frames that are involved in more than one colli
sion and are subsequently transmitted successfully. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 28.0 - 32.31 */
	 u_int32_t dot3stats_multiple_collision_frames_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - A count of times that the SQE TEST ERROR is received 
on a particular interface.
This counter does not increment on interfaces operating at 
speeds greater than 10 Mb/s, or on interfaces operating in 
full-duplex mode. */
	/* 32.0 - 36.31 */
	 u_int32_t dot3stats_sqe_test_errors_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - A count of times that the SQE TEST ERROR is received 
on a particular interface.
This counter does not increment on interfaces operating at 
speeds greater than 10 Mb/s, or on interfaces operating in 
full-duplex mode. */
	/* 36.0 - 40.31 */
	 u_int32_t dot3stats_sqe_test_errors_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - A count of frames for which the first transmission attempt 
on a particular interface is delayed because the medium is 
busy. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 40.0 - 44.31 */
	 u_int32_t dot3stats_deferred_transmissions_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - A count of frames for which the first transmission attempt 
on a particular interface is delayed because the medium is 
busy. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 44.0 - 48.31 */
	 u_int32_t dot3stats_deferred_transmissions_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The number of times that a collision is detected on a par
ticular interface later than one slotTime into the transmis
sion of a packet.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 48.0 - 52.31 */
	 u_int32_t dot3stats_late_collisions_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The number of times that a collision is detected on a par
ticular interface later than one slotTime into the transmis
sion of a packet.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 52.0 - 56.31 */
	 u_int32_t dot3stats_late_collisions_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - A count of frames for which transmission on a particular 
interface fails due to excessive collisions.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 56.0 - 60.31 */
	 u_int32_t dot3stats_excessive_collisions_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - A count of frames for which transmission on a particular 
interface fails due to excessive collisions.
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 60.0 - 64.31 */
	 u_int32_t dot3stats_excessive_collisions_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - A count of frames for which transmission failed and were 
discarded even though no errors had been detected to pre
vent their being deliverable to a higher-layer protocol. */
	/* 64.0 - 68.31 */
	 u_int32_t dot3stats_internal_mac_transmit_errors_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - A count of frames for which transmission failed and were 
discarded even though no errors had been detected to pre
vent their being deliverable to a higher-layer protocol. */
	/* 68.0 - 72.31 */
	 u_int32_t dot3stats_internal_mac_transmit_errors_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The number of times that the carrier sense condition was 
lost or never asserted when attempting to transmit a frame 
on a particular interface. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 72.0 - 76.31 */
	 u_int32_t dot3stats_carrier_sense_errors_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The number of times that the carrier sense condition was 
lost or never asserted when attempting to transmit a frame 
on a particular interface. 
This counter does not increment when the interface is 
operating in full-duplex mode. */
	/* 76.0 - 80.31 */
	 u_int32_t dot3stats_carrier_sense_errors_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - A count of frames received that exceed the maximum per
mitted frame size. */
	/* 80.0 - 84.31 */
	 u_int32_t dot3stats_frame_too_longs_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - A count of frames received that exceed the maximum per
mitted frame size. */
	/* 84.0 - 88.31 */
	 u_int32_t dot3stats_frame_too_longs_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - A count of frames for which reception failed and were dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 88.0 - 92.31 */
	 u_int32_t dot3stats_internal_mac_receive_errors_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - A count of frames for which reception failed and were dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 92.0 - 96.31 */
	 u_int32_t dot3stats_internal_mac_receive_errors_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Receive Error". */
	/* 96.0 - 100.31 */
	 u_int32_t dot3stats_symbol_errors_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Receive Error". */
	/* 100.0 - 104.31 */
	 u_int32_t dot3stats_symbol_errors_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported. */
	/* 104.0 - 108.31 */
	 u_int32_t dot3control_in_unknown_opcodes_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported. */
	/* 108.0 - 112.31 */
	 u_int32_t dot3control_in_unknown_opcodes_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - A count of MAC Control frames received with an opcode 
indicating the PAUSE operation. */
	/* 112.0 - 116.31 */
	 u_int32_t dot3in_pause_frames_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - A count of MAC Control frames received with an opcode 
indicating the PAUSE operation. */
	/* 116.0 - 120.31 */
	 u_int32_t dot3in_pause_frames_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - A count of MAC Control frames transmitted with an 
opcode indicating the PAUSE operation. */
	/* 120.0 - 124.31 */
	 u_int32_t dot3out_pause_frames_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - A count of MAC Control frames transmitted with an 
opcode indicating the PAUSE operation. */
	/* 124.0 - 128.31 */
	 u_int32_t dot3out_pause_frames_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_2819_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of events in which packets were 
dropped by the probe due to lack of resources. */
	/* 0.0 - 4.31 */
	 u_int32_t ether_stats_drop_events_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of events in which packets were 
dropped by the probe due to lack of resources. */
	/* 4.0 - 8.31 */
	 u_int32_t ether_stats_drop_events_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The total number of octets of data (including those in 
bad packets) received (excluding framing bits but 
including FCS octets). */
	/* 8.0 - 12.31 */
	 u_int32_t ether_stats_octets_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The total number of octets of data (including those in 
bad packets) received (excluding framing bits but 
including FCS octets). */
	/* 12.0 - 16.31 */
	 u_int32_t ether_stats_octets_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The total number of packets (including bad packets, 
broadcast packets, and multicast packets) received. */
	/* 16.0 - 20.31 */
	 u_int32_t ether_stats_pkts_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The total number of packets (including bad packets, 
broadcast packets, and multicast packets) received. */
	/* 20.0 - 24.31 */
	 u_int32_t ether_stats_pkts_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The total number of good packets received that were 
directed to the broadcast address. 
Note: This does not include multicast packets. */
	/* 24.0 - 28.31 */
	 u_int32_t ether_stats_broadcast_pkts_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - The total number of good packets received that were 
directed to the broadcast address. 
Note: This does not include multicast packets. */
	/* 28.0 - 32.31 */
	 u_int32_t ether_stats_broadcast_pkts_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The total number of good packets received that were 
directed to a multicast MAC address. 
Note: This number does not include packets directed 
to the broadcast address. */
	/* 32.0 - 36.31 */
	 u_int32_t ether_stats_multicast_pkts_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The total number of good packets received that were 
directed to a multicast MAC address. 
Note: This number does not include packets directed 
to the broadcast address. */
	/* 36.0 - 40.31 */
	 u_int32_t ether_stats_multicast_pkts_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of packets received that had a length 
(excluding framing bits, but including FCS octets) of 
between 64 and MTU
 octets, inclusive, but had either 
a bad frame check sequence (FCS) with an integral 
number of octets (FCS error) or a bad FCS with a 
non-integral number of octets (alignment error). */
	/* 40.0 - 44.31 */
	 u_int32_t ether_stats_crc_align_errors_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of packets received that had a length 
(excluding framing bits, but including FCS octets) of 
between 64 and MTU
 octets, inclusive, but had either 
a bad frame check sequence (FCS) with an integral 
number of octets (FCS error) or a bad FCS with a 
non-integral number of octets (alignment error). */
	/* 44.0 - 48.31 */
	 u_int32_t ether_stats_crc_align_errors_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets long (excluding framing bits, but 
including FCS octets) and were otherwise well 
formed. */
	/* 48.0 - 52.31 */
	 u_int32_t ether_stats_undersize_pkts_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets long (excluding framing bits, but 
including FCS octets) and were otherwise well 
formed. */
	/* 52.0 - 56.31 */
	 u_int32_t ether_stats_undersize_pkts_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets) but were otherwise well formed. */
	/* 56.0 - 60.31 */
	 u_int32_t ether_stats_oversize_pkts_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets) but were otherwise well formed. */
	/* 60.0 - 64.31 */
	 u_int32_t ether_stats_oversize_pkts_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets in length (excluding framing bits but 
including FCS octets) and had either a bad FCS with 
an integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 64.0 - 68.31 */
	 u_int32_t ether_stats_fragments_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - The total number of packets received that were less 
than 64 octets in length (excluding framing bits but 
including FCS octets) and had either a bad FCS with 
an integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 68.0 - 72.31 */
	 u_int32_t ether_stats_fragments_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets), and had either a bad FCS with an 
integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 72.0 - 76.31 */
	 u_int32_t ether_stats_jabbers_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The total number of packets received that were longer 
than MTU octets (excluding framing bits, but includ
ing FCS octets), and had either a bad FCS with an 
integral number of octets (FCS error) or a bad FCS 
with a non-integral number of octets (alignment 
error). */
	/* 76.0 - 80.31 */
	 u_int32_t ether_stats_jabbers_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The best estimate of the total number of collisions on 
this Ethernet segment. */
	/* 80.0 - 84.31 */
	 u_int32_t ether_stats_collisions_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The best estimate of the total number of collisions on 
this Ethernet segment. */
	/* 84.0 - 88.31 */
	 u_int32_t ether_stats_collisions_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were 64 octets in length (excluding 
framing bits but including FCS octets). */
	/* 88.0 - 92.31 */
	 u_int32_t ether_stats_pkts64octets_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were 64 octets in length (excluding 
framing bits but including FCS octets). */
	/* 92.0 - 96.31 */
	 u_int32_t ether_stats_pkts64octets_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 65 and 127 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 96.0 - 100.31 */
	 u_int32_t ether_stats_pkts65to127octets_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 65 and 127 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 100.0 - 104.31 */
	 u_int32_t ether_stats_pkts65to127octets_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 128 and 255 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 104.0 - 108.31 */
	 u_int32_t ether_stats_pkts128to255octets_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 128 and 255 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 108.0 - 112.31 */
	 u_int32_t ether_stats_pkts128to255octets_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 256 and 511 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 112.0 - 116.31 */
	 u_int32_t ether_stats_pkts256to511octets_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 256 and 511 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 116.0 - 120.31 */
	 u_int32_t ether_stats_pkts256to511octets_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 512 and 1023 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 120.0 - 124.31 */
	 u_int32_t ether_stats_pkts512to1023octets_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 512 and 1023 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 124.0 - 128.31 */
	 u_int32_t ether_stats_pkts512to1023octets_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1024 and 1518 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 128.0 - 132.31 */
	 u_int32_t ether_stats_pkts1024to1518octets_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1024 and 1518 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 132.0 - 136.31 */
	 u_int32_t ether_stats_pkts1024to1518octets_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 136.0 - 140.31 */
	 u_int32_t ether_stats_pkts1519to2047octets_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 140.0 - 144.31 */
	 u_int32_t ether_stats_pkts1519to2047octets_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 144.0 - 148.31 */
	 u_int32_t ether_stats_pkts2048to4095octets_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 148.0 - 152.31 */
	 u_int32_t ether_stats_pkts2048to4095octets_low;
/*---------------- DWORD[38] (Offset 0x98) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 152.0 - 156.31 */
	 u_int32_t ether_stats_pkts4096to8191octets_high;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 156.0 - 160.31 */
	 u_int32_t ether_stats_pkts4096to8191octets_low;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 160.0 - 164.31 */
	 u_int32_t ether_stats_pkts8192to10239octets_high;
/*---------------- DWORD[41] (Offset 0xa4) ----------------*/
	/* Description - The total number of packets (including bad packets) 
received that were between 1519 and 2047 octets in 
length (excluding framing bits but including FCS 
octets). */
	/* 164.0 - 168.31 */
	 u_int32_t ether_stats_pkts8192to10239octets_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_2863_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The total number of octets received, including framing charac
ters. Including MAC control frames. */
	/* 0.0 - 4.31 */
	 u_int32_t if_in_octets_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The total number of octets received, including framing charac
ters. Including MAC control frames. */
	/* 4.0 - 8.31 */
	 u_int32_t if_in_octets_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The number of packets successfully received, which were not 
addressed to a multicast or broadcast MAC address. */
	/* 8.0 - 12.31 */
	 u_int32_t if_in_ucast_pkts_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The number of packets successfully received, which were not 
addressed to a multicast or broadcast MAC address. */
	/* 12.0 - 16.31 */
	 u_int32_t if_in_ucast_pkts_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 16.0 - 20.31 */
	 u_int32_t if_in_discards_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The number of inbound packets which were chosen to be dis
carded even though no errors had been detected to prevent 
their being deliverable to a higher-layer protocol. */
	/* 20.0 - 24.31 */
	 u_int32_t if_in_discards_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The number of inbound packets that contained errors prevent
ing them from being deliverable to a higher-layer protocol. */
	/* 24.0 - 28.31 */
	 u_int32_t if_in_errors_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - The number of inbound packets that contained errors prevent
ing them from being deliverable to a higher-layer protocol. */
	/* 28.0 - 32.31 */
	 u_int32_t if_in_errors_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The number of packets received via the interface which were 
discarded because of an unknown or unsupported protocol. */
	/* 32.0 - 36.31 */
	 u_int32_t if_in_unknown_protos_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - The number of packets received via the interface which were 
discarded because of an unknown or unsupported protocol. */
	/* 36.0 - 40.31 */
	 u_int32_t if_in_unknown_protos_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - The total number of octets transmitted out of the interface, 
including framing characters. */
	/* 40.0 - 44.31 */
	 u_int32_t if_out_octets_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - The total number of octets transmitted out of the interface, 
including framing characters. */
	/* 44.0 - 48.31 */
	 u_int32_t if_out_octets_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted and were not addressed to a multicast 
or broadcast MAC address, including those that were discarded 
or not sent. */
	/* 48.0 - 52.31 */
	 u_int32_t if_out_ucast_pkts_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted and were not addressed to a multicast 
or broadcast MAC address, including those that were discarded 
or not sent. */
	/* 52.0 - 56.31 */
	 u_int32_t if_out_ucast_pkts_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - The number of outbound packets which were chosen to be dis
carded, even though no errors had been detected to prevent 
their being transmitted. */
	/* 56.0 - 60.31 */
	 u_int32_t if_out_discards_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - The number of outbound packets which were chosen to be dis
carded, even though no errors had been detected to prevent 
their being transmitted. */
	/* 60.0 - 64.31 */
	 u_int32_t if_out_discards_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - The number of outbound packets that could not be transmitted 
because of errors. */
	/* 64.0 - 68.31 */
	 u_int32_t if_out_errors_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - The number of outbound packets that could not be transmitted 
because of errors. */
	/* 68.0 - 72.31 */
	 u_int32_t if_out_errors_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a multicast MAC address. */
	/* 72.0 - 76.31 */
	 u_int32_t if_in_multicast_pkts_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a multicast MAC address. */
	/* 76.0 - 80.31 */
	 u_int32_t if_in_multicast_pkts_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a broadcast MAC address. */
	/* 80.0 - 84.31 */
	 u_int32_t if_in_broadcast_pkts_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - The number of packets successfully received, which were 
addressed to a broadcast MAC address. */
	/* 84.0 - 88.31 */
	 u_int32_t if_in_broadcast_pkts_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a multi
cast MAC address, including those that were discarded or not 
sent. */
	/* 88.0 - 92.31 */
	 u_int32_t if_out_multicast_pkts_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a multi
cast MAC address, including those that were discarded or not 
sent. */
	/* 92.0 - 96.31 */
	 u_int32_t if_out_multicast_pkts_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a broad
cast MAC address, including those that were discarded or not 
sent. */
	/* 96.0 - 100.31 */
	 u_int32_t if_out_broadcast_pkts_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - The total number of packets that higher-level protocols 
requested be transmitted, and which were addressed to a broad
cast MAC address, including those that were discarded or not 
sent. */
	/* 100.0 - 104.31 */
	 u_int32_t if_out_broadcast_pkts_low;
};

/* Description -   */
/* Size in bytes - 248 */
struct connectib_eth_802_3_cntrs_grp_data_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - A count of frames that are successfully transmitted. */
	/* 0.0 - 4.31 */
	 u_int32_t a_frames_transmitted_ok_high;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - A count of frames that are successfully transmitted. */
	/* 4.0 - 8.31 */
	 u_int32_t a_frames_transmitted_ok_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - A count of frames that are successfully received. This 
does not include frames received with frame-too-long, 
frame check sequence (FCS), length or alignment errors, 
or frames lost due to other MAC errors. */
	/* 8.0 - 12.31 */
	 u_int32_t a_frames_received_ok_high;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - A count of frames that are successfully received. This 
does not include frames received with frame-too-long, 
frame check sequence (FCS), length or alignment errors, 
or frames lost due to other MAC errors. */
	/* 12.0 - 16.31 */
	 u_int32_t a_frames_received_ok_low;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - A count of receive frames that are an integral number of 
octets in length and do not pass the FCS check. This 
does not include frames received with frame-too-long, or 
frame-too-short (frame fragment) errors. */
	/* 16.0 - 20.31 */
	 u_int32_t a_frame_check_sequence_errors_high;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - A count of receive frames that are an integral number of 
octets in length and do not pass the FCS check. This 
does not include frames received with frame-too-long, or 
frame-too-short (frame fragment) errors. */
	/* 20.0 - 24.31 */
	 u_int32_t a_frame_check_sequence_errors_low;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - A count of frames that are not an integral number of 
octets in length and do not pass the FCS check. */
	/* 24.0 - 28.31 */
	 u_int32_t a_alignment_errors_high;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - A count of frames that are not an integral number of 
octets in length and do not pass the FCS check. */
	/* 28.0 - 32.31 */
	 u_int32_t a_alignment_errors_low;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - A count of data and padding octets of frames that are 
successfully transmitted. */
	/* 32.0 - 36.31 */
	 u_int32_t a_octets_transmitted_ok_high;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - A count of data and padding octets of frames that are 
successfully transmitted. */
	/* 36.0 - 40.31 */
	 u_int32_t a_octets_transmitted_ok_low;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - A count of data and padding octets in frames that are 
successfully received. This does not include octets in 
frames received with frame-too-long, FCS, length or 
alignment errors, or frames lost due to other MAC 
errors. */
	/* 40.0 - 44.31 */
	 u_int32_t a_octets_received_ok_high;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - A count of data and padding octets in frames that are 
successfully received. This does not include octets in 
frames received with frame-too-long, FCS, length or 
alignment errors, or frames lost due to other MAC 
errors. */
	/* 44.0 - 48.31 */
	 u_int32_t a_octets_received_ok_low;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - A count of frames that are successfully transmitted to a 
group destination address other than broadcast. */
	/* 48.0 - 52.31 */
	 u_int32_t a_multicast_frames_xmitted_ok_high;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - A count of frames that are successfully transmitted to a 
group destination address other than broadcast. */
	/* 52.0 - 56.31 */
	 u_int32_t a_multicast_frames_xmitted_ok_low;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 56.0 - 60.31 */
	 u_int32_t a_broadcast_frames_xmitted_ok_high;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 60.0 - 64.31 */
	 u_int32_t a_broadcast_frames_xmitted_ok_low;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - A count of frames that are successfully received and 
directed to an active nonbroadcast group address. This 
does not include frames received with frame-too-long, 
FCS, length or alignment errors, or frames lost due to 
internal MAC sublayer error. */
	/* 64.0 - 68.31 */
	 u_int32_t a_multicast_frames_received_ok_high;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - A count of frames that are successfully received and 
directed to an active nonbroadcast group address. This 
does not include frames received with frame-too-long, 
FCS, length or alignment errors, or frames lost due to 
internal MAC sublayer error. */
	/* 68.0 - 72.31 */
	 u_int32_t a_multicast_frames_received_ok_low;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 72.0 - 76.31 */
	 u_int32_t a_broadcast_frames_recieved_ok_high;
/*---------------- DWORD[19] (Offset 0x4c) ----------------*/
	/* Description - A count of the frames that were successfully transmitted 
to the broadcast address. Frames transmitted to multicast 
addresses are not broadcast frames and are excluded. */
	/* 76.0 - 80.31 */
	 u_int32_t a_broadcast_frames_recieved_ok_low;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - A count of frames with a length/type field value between 
the minimum unpadded MAC client data size and the 
maximum allowed MAC client data size, inclusive, that 
does not match the number of MAC client data octets 
received. The counter also increments for frames whose 
length/type field value is less than the minimum allowed 
unpadded MAC client data size and the number of MAC 
client data octets received is greater than the minimum 
unpadded MAC client data size. */
	/* 80.0 - 84.31 */
	 u_int32_t a_in_range_length_errors_high;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description - A count of frames with a length/type field value between 
the minimum unpadded MAC client data size and the 
maximum allowed MAC client data size, inclusive, that 
does not match the number of MAC client data octets 
received. The counter also increments for frames whose 
length/type field value is less than the minimum allowed 
unpadded MAC client data size and the number of MAC 
client data octets received is greater than the minimum 
unpadded MAC client data size. */
	/* 84.0 - 88.31 */
	 u_int32_t a_in_range_length_errors_low;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - A count of frames with a length field value greater than 
the maximum allowed LLC data size. */
	/* 88.0 - 92.31 */
	 u_int32_t a_out_of_range_length_field_high;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - A count of frames with a length field value greater than 
the maximum allowed LLC data size. */
	/* 92.0 - 96.31 */
	 u_int32_t a_out_of_range_length_field_low;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - A count of frames received that exceed the maximum 
permitted frame size by IEEE 802.3 (
MTU size). */
	/* 96.0 - 100.31 */
	 u_int32_t a_frame_too_long_errors_high;
/*---------------- DWORD[25] (Offset 0x64) ----------------*/
	/* Description - A count of frames received that exceed the maximum 
permitted frame size by IEEE 802.3 (
MTU size). */
	/* 100.0 - 104.31 */
	 u_int32_t a_frame_too_long_errors_low;
/*---------------- DWORD[26] (Offset 0x68) ----------------*/
	/* Description - For full duplex operation at 1000 Mb/s, it is a count of 
the number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Data reception error". */
	/* 104.0 - 108.31 */
	 u_int32_t a_symbol_error_during_carrier_high;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - For full duplex operation at 1000 Mb/s, it is a count of 
the number of times the receiving media is non-idle (a 
carrier event) for a period of time equal to or greater than 
minFrameSize, and during which there was at least one 
occurrence of an event that causes the PHY to indicate 
"Data reception error". */
	/* 108.0 - 112.31 */
	 u_int32_t a_symbol_error_during_carrier_low;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description - A count of MAC Control frames passed to the MAC 
sublayer for transmission. */
	/* 112.0 - 116.31 */
	 u_int32_t a_mac_control_frames_transmitted_high;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - A count of MAC Control frames passed to the MAC 
sublayer for transmission. */
	/* 116.0 - 120.31 */
	 u_int32_t a_mac_control_frames_transmitted_low;
/*---------------- DWORD[30] (Offset 0x78) ----------------*/
	/* Description - A count of MAC Control frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 120.0 - 124.31 */
	 u_int32_t a_mac_control_frames_received_high;
/*---------------- DWORD[31] (Offset 0x7c) ----------------*/
	/* Description - A count of MAC Control frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 124.0 - 128.31 */
	 u_int32_t a_mac_control_frames_received_low;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported by the device. */
	/* 128.0 - 132.31 */
	 u_int32_t a_unsupported_opcodes_received_high;
/*---------------- DWORD[33] (Offset 0x84) ----------------*/
	/* Description - A count of MAC Control frames received that contain an 
opcode that is not supported by the device. */
	/* 132.0 - 136.31 */
	 u_int32_t a_unsupported_opcodes_received_low;
/*---------------- DWORD[34] (Offset 0x88) ----------------*/
	/* Description - A count of MAC PAUSE frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 136.0 - 140.31 */
	 u_int32_t a_pause_mac_ctrl_frames_received_high;
/*---------------- DWORD[35] (Offset 0x8c) ----------------*/
	/* Description - A count of MAC PAUSE frames passed by the MAC 
sublayer to the MAC Control sublayer. */
	/* 140.0 - 144.31 */
	 u_int32_t a_pause_mac_ctrl_frames_received_low;
/*---------------- DWORD[36] (Offset 0x90) ----------------*/
	/* Description - A count of PAUSE frames passed to the MAC sublayer 
for transmission. */
	/* 144.0 - 148.31 */
	 u_int32_t a_pause_mac_ctrl_frames_transmitted_high;
/*---------------- DWORD[37] (Offset 0x94) ----------------*/
	/* Description - A count of PAUSE frames passed to the MAC sublayer 
for transmission. */
	/* 148.0 - 152.31 */
	 u_int32_t a_pause_mac_ctrl_frames_transmitted_low;
};

/* Description -   */
/* Size in bytes - 32 */
union connectib_cmdif_ctx_special {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create c;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_modify_tir tir;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create_qp qp;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create_rq rq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create_srq srq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_rqt rqt;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create_eq eq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_create_cq c_cq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_modify_cq m_cq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_mkey mkey;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_arm_rq arm_rq;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_special_modify_rmp modify_rmp;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_sniffer sniffer;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_mcg mcg;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_psv psv;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_create_mtt mtt;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_cmdif_ctx_dmfs dmfs;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_flush_type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_flush_type_bits bits;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_flush_type_bitmask bitmask;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_sw_eqe_flat_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 28.31 */
	 u_int32_t data[7];
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_db_bf_congestion_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - N/A
1 - Mild congestion
...
7 - Severe congestion */
	/* 0.8 - 0.15 */
	 u_int8_t congestion_level;
	/* Description - 0 - Doorbell congestion
1 - BlueFlame congestion */
	/* 0.24 - 4.31 */
	 u_int8_t event_subtype;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_rdma_page_fault_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of bytes already sent/received in this WQE before the fault. */
	/* 0.0 - 4.31 */
	 u_int32_t bytes_committed;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The R-key used for the RDMA transaction which caused the fault. */
	/* 4.0 - 8.31 */
	 u_int32_t r_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The length of the packet received/constructed for transmission when the 
fault occurred. Measured in bytes.
This can be used on RDMA write operations, where we do not always 
know the rdma_op_len. The software may attempt to prefetch memory 
based on the event attributes, but must make sure it can map the pages 
needed for packet_len bytes. */
	/* 8.0 - 8.15 */
	 u_int16_t packet_len;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The length of the RDMA operation, in bytes. If the HW cannot reliably 
report the length, it will put 0 in this field, and the driver should perform 
prefetching based on access pattern */
	/* 12.0 - 16.31 */
	 u_int32_t rdma_op_len;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The VA used for the beginning of the RDMA operation, upper 32-bits. */
	/* 16.0 - 20.31 */
	 u_int32_t rdma_va_hi;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - The VA used for the beginning of the RDMA operation, lower 32-bits. */
	/* 20.0 - 24.31 */
	 u_int32_t rdma_va_lo;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The QP on which the fault occurred */
	/* 24.0 - 24.23 */
	 u_int32_t qpn;
	/* Description - If set, the fault happened on the requestor (initiator) side of the QP.
Not set - responder side of the QP */
	/* 24.24 - 24.24 */
	 u_int8_t requestor;
	/* Description - If set, the operation attempted was writing memory. 
Not set - reading from memory */
	/* 24.25 - 24.25 */
	 u_int8_t write_read_;
	/* Description - 1 - RDMA associated page fault.
0 - WQE associated page fault */
	/* 24.26 - 24.26 */
	 u_int8_t rdma;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_wqe_page_fault_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The number of bytes already sent/received in this WQE before the fault. */
	/* 0.0 - 4.31 */
	 u_int32_t bytes_committed;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - The WQE index (from the beginning of the relevant queue, in WQEBB units) where the fault occurred. */
	/* 4.0 - 4.15 */
	 u_int16_t wqe_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - The length of the packet received/constructed for transmission when the fault occurred. Measured in bytes. */
	/* 8.0 - 8.15 */
	 u_int16_t packet_len;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - The QP on which the fault occurred. */
	/* 24.0 - 24.23 */
	 u_int32_t qpn;
	/* Description - If set, the fault happened on the requestor (initiator) side of the QP. */
	/* 24.24 - 24.24 */
	 u_int8_t req_res_;
	/* Description - If set, the operation attempted was writing memory. */
	/* 24.25 - 24.25 */
	 u_int8_t write_read_;
	/* Description - If set, the operation attempted was an RDMA operation. */
	/* 24.26 - 24.26 */
	 u_int8_t rdma;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_page_request_event {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - function_ix + function_en */
	/* 0.0 - 0.15 */
	 u_int16_t function_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Number of missing / unneeded pages (signed number, msb indicate sign) */
	/* 4.0 - 8.31 */
	 u_int32_t num_pages;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_port_state_change_event {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Port number */
	/* 8.28 - 12.31 */
	 u_int8_t port_num;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_sw_eqe_qp_data {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.23 */
	 u_int32_t qpn;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_sw_eqe_error_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t cqn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.7 */
	 u_int8_t syndrome;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_sw_eqe_cq_data {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.23 */
	 u_int32_t cqn;
};

/* Description -   */
/* Size in bytes - 44 */
union connectib_reg_access_reg_tlv_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_mfpa mfpa;
	/* Description - misc flash activate image */
	/* 0.0 - 16.31 */
	 struct connectib_register_mfai mfai;
	/* Description - misc flash reset level */
	/* 0.0 - 16.31 */
	 struct connectib_register_mfrl mfrl;
	/* Description - misc temperature */
	/* 0.0 - 28.31 */
	 struct connectib_mtmp mtmp;
	/* Description - misc_counters */
	/* 0.0 - 32.31 */
	 struct connectib_register_misc_counters misc_counters;
	/* Description - misc flash block access */
	/* 0.0 - 44.31 */
	 struct connectib_project_mfba mfba;
	/* Description - misc flash block erase */
	/* 0.0 - 12.31 */
	 struct connectib_mfbe mfbe;
	/* Description - mjtag - master jtag register */
	/* 0.0 - 44.31 */
	 struct connectib_mjtag mjtag;
	/* Description - Table 236 - PAOS - Ports Administrative and Operational Status Register Layout */
	/* 0.0 - 16.31 */
	 struct connectib_paos_reg paos;
	/* Description - Serdes Lane Receive Parameters */
	/* 0.0 - 40.31 */
	 struct connectib_slrp_reg slrp;
	/* Description - Table 305 - [Internal] SLTP - Serdes Lane Transmit Parameters Register Layout */
	/* 0.0 - 20.31 */
	 struct connectib_sltp_reg sltp;
	/* Description - Table 309 - PTAS - Phy Tuning Algorithm Settings Register Layout */
	/* 0.0 - 44.31 */
	 struct connectib_ptas_reg ptas;
	/* Description - Table 307 - SLRG - Serdes Lane Receive Grade Register Layou */
	/* 0.0 - 40.31 */
	 struct connectib_slrg_reg slrg;
	/* Description - Table 301 - [Internal] PPAMP - Port Phy opAMP data Register Layout */
	/* 0.0 - 44.31 */
	 struct connectib_pamp_reg ppamp;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_pmtu_reg pmtu;
	/* Description -  */
	/* 0.0 - 44.31 */
	 struct connectib_project_nvda nvda;
	/* Description -  */
	/* 0.0 - 12.31 */
	 struct connectib_nv_tlv_hdr nvdi;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_project_nvqc nvqc;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reg_access_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.16 - 0.26 */
	 u_int16_t len;
	/* Description - enum {
    EMAD_TLV_TYPE_END   = 0x0,
    EMAD_TLV_TYPE_OPER  = 0x1,
    EMAD_TLV_TYPE_RD    = 0x2,
    EMAD_TLV_TYPE_REG   = 0x3,
    EMAD_TLV_TYPE_UDATA = 0x4,
};
 */
	/* 0.27 - 4.31 */
	 u_int8_t type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_IB_TID {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t High;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t Low;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dc_control_packet_desc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t dlid;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t slid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t source_qp;
	/* Description -  */
	/* 4.24 - 4.24 */
	 u_int8_t valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t dest_qp;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t psn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.15 */
	 u_int16_t pkey;
	/* Description -  */
	/* 16.16 - 16.19 */
	 u_int8_t sl;
	/* Description -  */
	/* 16.20 - 16.20 */
	 u_int8_t port_id;
	/* Description -  */
	/* 16.21 - 16.21 */
	 u_int8_t has_grh;
	/* Description -  */
	/* 16.22 - 16.22 */
	 u_int8_t force_loopback;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.15 */
	 u_int16_t dct_gvmi;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.7 */
	 u_int8_t tclass;
	/* Description -  */
	/* 24.8 - 24.15 */
	 u_int8_t hop_limit;
	/* Description -  */
	/* 24.16 - 28.31 */
	 u_int16_t flow_label;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 48.31 */
	 struct connectib_ib_gid dgid;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 64.31 */
	 struct connectib_ib_gid sgid;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_dmfs_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_dmfs_group_meta group_meta;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_dmfs_ft_meta ft_meta;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_dmfs_fte_meta fte_meta;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_dmfs_hash_meta hash_meta;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_list_element {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.24 */
	 u_int32_t next;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t in_list;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.24 */
	 u_int32_t prev;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_fw_rqt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t rqt_max_size;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t rqt_actual_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t rqt_hw_data_ix;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t rqt_fw_data_ix;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_cqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 = Ok
0x1 = Error: CQ Overrun
0x2 = Error: Access Violation */
	/* 4.0 - 4.7 */
	 u_int8_t cq_status;
	/* Description -  */
	/* 4.8 - 4.11 */
	 u_int8_t trap_reason;
	/* Description -  */
	/* 4.30 - 4.30 */
	 u_int8_t in_cq_overrun_list;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t in_eq_overrun_list;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t fw_marked_sigerr;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_mkc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.30 */
	 u_int32_t state;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t sync_umr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_mkey_dump mkey_dump;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.0 */
	 u_int8_t next_num_of_sigerr;
	/* Description -  */
	/* 12.1 - 12.1 */
	 u_int8_t pg_access;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_fw_cre {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_fw_srqc fw_srqc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_fw_qpc fw_qpc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_fw_tir fw_tir;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_fw_tis fw_tis;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_fw_basic_res_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_fw_alt_path {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - ads layout */
	/* 0.0 - 44.31 */
	 struct connectib_sw_ads alt;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_fw_eqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Note: ref_counter must be in offset 0x0 ! */
	/* 0.0 - 4.31 */
	 struct connectib_fw_ref_count fw_ref_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 = Ok
0x2 = Error: Access Violation */
	/* 4.0 - 4.7 */
	 u_int8_t eq_status;
	/* Description -  */
	/* 4.8 - 4.11 */
	 u_int8_t trap_reason;
	/* Description -  */
	/* 4.30 - 4.30 */
	 u_int8_t needs_eq_probe;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t in_eq_overrun_list;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_qp_counter {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Only RX (Out-of-buffer induced dropped Rx packet count) */
	/* 0.0 - 4.31 */
	 u_int32_t pkt_nobuffer_drop;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t pkt_good_unicast;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t pkt_good_multicast;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - RX - Error induced dropped Rx packet count. SX - Dropped Tx packet count */
	/* 12.0 - 16.31 */
	 u_int32_t pkt_dropped;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Only RX */
	/* 16.0 - 20.31 */
	 u_int32_t msg_write_req;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t msg_rnr_nack;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - RX: Read Requests. SX : Read Responses */
	/* 24.0 - 28.31 */
	 u_int32_t msg_read;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t msg_dct_connect;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - RX: Atomic Requests. SX : Atomic Ack */
	/* 32.0 - 36.31 */
	 u_int32_t msg_atomic;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t fw_reserved;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - PAYLOAD bytes of RDMA frames that carry data */
	/* 40.0 - 48.31 */
	 u_int64_t bytes_rdma_frame;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 56.31 */
	 u_int64_t bytes_good_unicast;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 64.31 */
	 u_int64_t bytes_good_multicast;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_msix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pci spec msix vector */
	/* 0.0 - 16.31 */
	 struct connectib_hw_msix_context msix_context;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - msix extended context */
	/* 16.0 - 32.31 */
	 struct connectib_hw_msix_ext_context msix_ext_context;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_rdb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t opcode;
	/* Description - TODO: need to align this field to 32.  */
	/* 0.8 - 4.31 */
	 u_int32_t psn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t r_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 8.0 - 12.31 */
	 u_int32_t address_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 12.0 - 16.31 */
	 u_int32_t address_31_0;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t byte_count;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.7 - 20.7 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - TODO: need to align this field to 32.  */
	/* 20.8 - 24.31 */
	 u_int32_t pd;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.10 */
	 u_int16_t protection_ffser;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.0 */
	 u_int8_t fw_marked_as_read;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_hw_rdb_atomic_data atomic_data;
};

/* Description -   */
/* Size in bytes - 8 */
union connectib_icm_mtt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_mtt hw;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_mtt2 as_dw;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_steering_entry_icmc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_ste hw_ste;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_steering_qp_list steering_qp_list;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_pkey {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.15 */
	 u_int16_t pkey;
};

/* Description -  the timer is 8 bit, this is an adapter to node to unions */
/* Size in bytes - 4 */
struct connectib_hw_timer_32 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 struct connectib_hw_timer hw_timer;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_hw_sq_qp_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  QPN QP number */
	/* 0.0 - 0.23 */
	 u_int32_t qpi;
	/* Description -  DCR if this bit is set, the QP came from DCR DB */
	/* 0.31 - 4.31 */
	 u_int8_t global_gvmi;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_pipa {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  Producer Index Physical Address */
	/* 0.0 - 4.31 */
	 u_int32_t pa_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  if 0, there will not br recovery on this QPn */
	/* 4.0 - 4.0 */
	 u_int8_t recovery_en;
	/* Description -  */
	/* 4.1 - 4.1 */
	 u_int8_t always_zero;
	/* Description -  Producer Index Physical Address */
	/* 4.2 - 8.31 */
	 u_int32_t pa_31_2;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_hw_sxdc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t sq;
	/* Description - wqe_producer_index used in mpi to update producer index */
	/* 0.16 - 4.31 */
	 u_int16_t swqe_producer_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t uar;
	/* Description -  */
	/* 4.24 - 4.24 */
	 u_int8_t requestor_in_sq;
	/* Description -  */
	/* 4.25 - 4.25 */
	 u_int8_t responder_in_sq;
	/* Description - for QP flush FW flow. Indicates that the QP should not be scheduled when popping from the SQ but go the FW state */
	/* 4.26 - 4.26 */
	 u_int8_t scheduling_interrupt;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t doorbell_int;
	/* Description -  */
	/* 4.29 - 4.29 */
	 u_int8_t fast_path;
	/* Description - only when set external DB are accepted by the device, when cleared they are silently dropped */
	/* 4.30 - 4.30 */
	 u_int8_t external_db_en;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t valid;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_klm_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 4.31 */
	 u_int32_t length;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 16.31 */
	 u_int64_t va;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_sq_tokens {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  number of tokens to transfer in case the SQ has WareHouse QPs */
	/* 0.0 - 0.15 */
	 u_int16_t ware_house_burst_size_23_8;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Number of bytes for transmission by SXW for a QP popped from this SQ responder queue */
	/* 4.0 - 4.23 */
	 u_int32_t responder_burst_size;
	/* Description -  number of tokens to transfer in case the SQ has WareHouse QPs */
	/* 4.24 - 8.31 */
	 u_int8_t ware_house_burst_size_7_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  Number of bytes for transmission by SXW for a QP popped from this SQ requestor queue */
	/* 8.0 - 8.23 */
	 u_int32_t requestor_burst_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Number of bytes to add to GvmiTokenCount from GVMI tokens pool */
	/* 12.0 - 12.23 */
	 u_int32_t gvmi_vl_weight;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Number of bytes allocated to the SQ from the GVMI tokens pool */
	/* 16.0 - 16.23 */
	 u_int32_t gvmi_vl_token_count;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  Maximum value of GvmiVlTokenCount */
	/* 20.0 - 20.23 */
	 u_int32_t gvmi_vl_saturation;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Number of bytes to add to SwitchTokenCount during reset event of SQ-to-SL virtual switch arbiter */
	/* 24.0 - 24.23 */
	 u_int32_t dwrr_weight;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  Number of Tokens that the SQ has to Transfer to the SXW from the DWRR token Count */
	/* 28.0 - 28.23 */
	 u_int32_t dwrr_token_count;
	/* Description -  */
	/* 28.24 - 28.27 */
	 u_int8_t vl;
	/* Description -  */
	/* 28.28 - 28.30 */
	 u_int8_t vlg;
	/* Description -  */
	/* 28.31 - 32.31 */
	 u_int8_t port;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_gvmi_tokens {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 8.0 - 8.4 */
	 u_int8_t port1_avg_saturation;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 8.5 - 8.7 */
	 u_int8_t port1_high_vlg_req_token;
	/* Description -  port1_avg_time Log2 of the number of token distribution cycles to wait before adding tokens to average bandwidth bucket */
	/* 8.8 - 8.12 */
	 u_int8_t port1_log2avg_time;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 8.13 - 8.15 */
	 u_int8_t port1_max_weight_exp;
	/* Description -  port1_max_time Log2 of the number of token distribution cycles to wait before adding tokens to maximum bandwidth bucket */
	/* 8.16 - 8.20 */
	 u_int8_t port1_log2max_time;
	/* Description -  port0_has_tokens During token distribution cycle (from GVMI to SQ), indicates if maximum bandwidth bucket had tokens at the beginning of the cycle */
	/* 8.21 - 8.21 */
	 u_int8_t port0_has_token;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 8.22 - 8.22 */
	 u_int8_t port0_vlg_req_vld;
	/* Description -  During token distribution cycle (from GVMI to SQ), indicates if maximum bandwidth bucket had tokens at the beginning of the cycle */
	/* 8.23 - 8.23 */
	 u_int8_t port1_has_token;
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 8.24 - 8.28 */
	 u_int8_t port1_max_saturation;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 8.29 - 8.29 */
	 u_int8_t port1_vlg_req_vld;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 12.0 - 12.4 */
	 u_int8_t port0_avg_saturation;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 12.5 - 12.7 */
	 u_int8_t port0_avg_weight_exp;
	/* Description -  port0_avg_time Log2 of the number of token distribution cycles to wait before adding tokens to average bandwidth bucket */
	/* 12.8 - 12.12 */
	 u_int8_t port0_log2avg_time;
	/* Description -  VL group that will get tokens in next distribution cycle; updated during token reset cycle */
	/* 12.13 - 12.15 */
	 u_int8_t port0_high_vlg_req_token;
	/* Description -  port0_max_time Log2 of the number of token distribution cycles to wait before adding tokens to maximum bandwidth bucket */
	/* 12.16 - 12.20 */
	 u_int8_t port0_log2max_time;
	/* Description -  Maximum bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 12.21 - 12.23 */
	 u_int8_t port0_max_weight_exp;
	/* Description -  Maximum value in *_token_count = (2 ^ *_weight_saturation - 1); must be  <= 23 to allow negative tokens */
	/* 12.24 - 12.28 */
	 u_int8_t port0_max_saturation;
	/* Description -  Average bucket bandwidth = weight_mantissa * 2^weight_exp, in bytes */
	/* 12.29 - 16.31 */
	 u_int8_t port1_avg_weight_exp;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Maximum bandwidth bucket token count */
	/* 16.0 - 16.23 */
	 u_int32_t port1_max_token_count;
	/* Description -  */
	/* 16.24 - 20.31 */
	 u_int8_t port1_max_weight_mantissa;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  Average bandwidth bucket token count */
	/* 20.0 - 20.23 */
	 u_int32_t port1_avg_token_count;
	/* Description -  */
	/* 20.24 - 24.31 */
	 u_int8_t port1_avg_weight_mantissa;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Maximum bandwidth bucket token count */
	/* 24.0 - 24.23 */
	 u_int32_t port0_max_token_count;
	/* Description -  */
	/* 24.24 - 28.31 */
	 u_int8_t port0_max_weight_mantissa;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  Average bandwidth bucket token count */
	/* 28.0 - 28.23 */
	 u_int32_t port0_avg_token_count;
	/* Description -  */
	/* 28.24 - 32.31 */
	 u_int8_t port0_avg_weight_mantissa;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_sq_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  weight of requestor for dwrr between requstor and responder */
	/* 0.0 - 0.9 */
	 u_int16_t weight_requestor;
	/* Description - NO_DESCR */
	/* 0.10 - 0.15 */
	 u_int8_t sq_offset_11_6;
	/* Description -  weight of responder for dwrr between requstor and responder */
	/* 0.16 - 0.25 */
	 u_int16_t weight_responder;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Guest Virtual Machine ID */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
	/* Description -  requestor_responder_dwrr_token number of corrent tokens for corrent LastGntRequestor */
	/* 4.16 - 4.25 */
	 u_int16_t token;
	/* Description - NO_DESCR */
	/* 4.26 - 8.31 */
	 u_int8_t sq_offset_5_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  ware_house_counter_responder Number of responder QPs unscheduled back into the SQ due to lack of VL credits */
	/* 8.0 - 8.24 */
	 u_int32_t ware_house_counter_responder;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  ware_house_counter_requestor Number of requestor QPs unscheduled back into the SQ due to lack of VL credits */
	/* 12.0 - 12.24 */
	 u_int32_t ware_house_counter_requestor;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  responder_push_pointer responder push pointer at the SQ */
	/* 16.0 - 16.24 */
	 u_int32_t push_pointer_responder;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  requestor_push_pointer requestor push pointer at the SQ */
	/* 20.0 - 20.24 */
	 u_int32_t push_pointer_requestor;
	/* Description -  */
	/* 20.25 - 20.25 */
	 u_int8_t port;
	/* Description -  scheduling_interrupt if set QPs at this SQ will not be sched to the SXW, but will move to FW state at the scheduling slices */
	/* 20.26 - 20.26 */
	 u_int8_t scheduling_interrupt;
	/* Description -  Virtual lane */
	/* 20.28 - 24.31 */
	 u_int8_t vl;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  responder_pop_pointer responder pop pointer at the SQ */
	/* 24.0 - 24.24 */
	 u_int32_t pop_pointer_responder;
	/* Description -  last grant ID (requestor/responder) for DWRR at the SQ */
	/* 24.25 - 24.25 */
	 u_int8_t last_gnt_requestor;
	/* Description -  Log2 size of responder schedule queue, opened in ICM for QP list */
	/* 24.26 - 28.31 */
	 u_int8_t log2_max_num_of_qp_responder;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  requestor_pop_pointer requestor pop pointer at the SQ */
	/* 28.0 - 28.24 */
	 u_int32_t pop_pointer_requestor;
	/* Description -  scheduling_interrupt if set QPs at this SQ will not be sched to the SXW, but will move to FW state at the scheduling slices */
	/* 28.25 - 28.25 */
	 u_int8_t db_interrupt;
	/* Description -  Log2 size of requestor schedule queue, opened in ICM for QP list */
	/* 28.26 - 32.31 */
	 u_int8_t log2_max_num_of_qp_requestor;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_trasta {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t va_offset_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t va_offset_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t klm_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t invalidation_counter;
	/* Description -  */
	/* 12.16 - 12.16 */
	 u_int8_t valid;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hw_trastb {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  generation 16 bits: MKC.generation at the moment of last update. TRAST is stale if the genartion does not match current MKC, and will not be used */
	/* 0.0 - 0.15 */
	 u_int16_t generation_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  bsf_offset 32 bits: offset in 16B granularity of the BSF described by the entry, from the first BSF pointed by MKC */
	/* 4.0 - 8.31 */
	 u_int32_t bsf_offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  memory_fbo 32 bits: offset in bytes inside memory signature block, carried from previous BSF */
	/* 8.0 - 12.31 */
	 u_int32_t m_fbo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  wire_fbo 32 bits: offset in bytes inside wire signature block, carried from previous BSF */
	/* 12.0 - 16.31 */
	 u_int32_t w_fbo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  memory_va 64 bits: accumulated memory address from all BSFs prior to the one described by the entry */
	/* 16.0 - 24.31 */
	 u_int64_t m_va;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  wire_va 64 bits: accumulated wire address from all BSFs prior to the one described by the entry */
	/* 24.0 - 32.31 */
	 u_int64_t w_va;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_hw_base_psv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 0.29 - 0.29 */
	 u_int8_t data_heart_beat;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t wqe_heart_beat;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t status;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t syndrome;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t transient_signature;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t reference_tag;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_bsf_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_same_block_repeating same_block_repeating;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_same_block_non_repeating same_block_non_repeating;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_w_repeating_m_repeating hw_bsf_entry_w_repeating_m_repeating;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_w_repeating_m_non_repeating hw_bsf_entry_w_repeating_m_non_repeating;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_w_non_repeating_m_repeating hw_bsf_entry_w_non_repeating_m_repeating;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating hw_bsf_entry_w_non_repeating_m_non_repeating;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_port_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - NO_DESCR */
	/* 0.0 - 0.2 */
	 u_int8_t lmc;
	/* Description - NO_DESCR */
	/* 0.28 - 0.29 */
	 u_int8_t mad_filter;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 4.15 */
	 u_int16_t lid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 16.31 */
	 u_int64_t gid_prefix;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.16 - 64.15 */
	 u_int16_t dc_rsl2sq_map[16];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_r_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_common shared;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_connected_common shared_connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_rc_uc_dci connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_rc_uc_cd connected_cd;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_rc_uc_2cycbuff connected_2cycbuff;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_rc_uc_2srq connected_2srq;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_dcr connected_dcr;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_xrc connected_xrc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_unconnected_common shared_unconnected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_ud_l2 unconnected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_ud_l2_2cyclicbuff unconnected_2cyclicbuff;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_ud_l2_2srq unconnected_2srq;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_r_qpc_ud_l2_cd unconnected_cd;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_dct dct;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_s_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_s_qpc_common shared;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_s_qpc_connected_common shared_connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_s_qpc_rc_uc_dcr connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_s_qpc_dci connected_dci;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_s_qpc_ud_l2 unconnected;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_c_qpc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_common shared;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_connected_common shared_connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_connected connected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_connected_2cycbuff connected_2cycbuff;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_connected_dual connected_dual;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_unconnected_common shared_unconnected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_unconnected unconnected;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_c_qpc_unconnected_2cycbuff unconnected_2cycbuff;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_srq {
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.15 */
	 u_int16_t e2e_consumer_index;
	/* Description - FW bits, these are the only reserved bits that are not overriden by HW in ICM */
	/* 24.16 - 24.25 */
	 u_int16_t srq_fw;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - index to next free wqe
rwq_type=SRQ: copy index from SRQ on packet first
EAS NAME: rq_wqe_counter
condition:rwq_type!=RCYCLIC */
	/* 28.0 - 28.15 */
	 u_int16_t rwqe_consumer_index;
	/* Description - written by e2e credit machine */
	/* 28.16 - 32.31 */
	 u_int16_t e2e_producer_index;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Hermon: srcd
EAS NAME: xrcd
condition:ts==XRC */
	/* 32.0 - 32.23 */
	 u_int32_t xrc_domain;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - protection domain
EAS NAME: pd */
	/* 36.0 - 36.23 */
	 u_int32_t pd;
	/* Description - 2^ this value is the threshold to check for new E2E credits
0 means e2e prefethch disabled for this qp
in rcylic this thrshould is in MTU, otherwise in WQEs
EAS NAME: N/A
condition:ts!=DCR */
	/* 36.24 - 36.26 */
	 u_int8_t e2e_credits_prefetch_threshold;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - 
EAS NAME: cqn_snd, cqn_rcv
condition:ts!=DCR */
	/* 40.0 - 40.23 */
	 u_int32_t cq_number;
	/* Description - number of WQEs in the WQ: 2 in power of
EAS NAME: log_rq_size
condition:rwq_type!=RCYCLIC */
	/* 40.24 - 40.27 */
	 u_int8_t rwqe_buffer_size;
	/* Description - WQE size: (2^this field)*16B
EAS NAME: log_rq_stride
condition:rwq_type!=RCYCLIC */
	/* 40.28 - 40.30 */
	 u_int8_t rwqe_stride;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - in DCR this is the DCT number, this is MyQPN in the packet
EAS NAME: local_qpn */
	/* 44.0 - 44.23 */
	 u_int32_t context_number;
	/* Description - page_size = 4096*2^log_page_size */
	/* 44.24 - 44.28 */
	 u_int8_t log_page_size;
	/* Description - 
EAS NAME: N/A */
	/* 44.29 - 44.29 */
	 u_int8_t tcu_drop;
	/* Description - Used for translation and key check (TPT)
TODO: next project move to common section?
EAS NAME: rlkey */
	/* 44.30 - 44.30 */
	 u_int8_t can_use_reserved_lkey;
	/* Description - interrupt FW when packet arrives to tcu on this Qp
Hermon: tcu_int
EAS NAME: N/A */
	/* 44.31 - 48.31 */
	 u_int8_t tcu_trap;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 48.0 - 48.7 */
	 u_int8_t mtt_pointer_39_32;
	/* Description - If rwq_type==0 then 
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
else 
 rwqe_address=(2^log_page_size)*wqe_page_offset*64 + masked_wqe_index*64
 swqe_address=(2^log_page_size)*wqe_page_offset*64 + 2^(rwqe_buffer_size+rwqe_stride)*16 + masked_wqe_index*64
EAS NAME: page_offset */
	/* 48.8 - 48.13 */
	 u_int8_t wqe_page_offset;
	/* Description - set by RX on every packet received and accepted
EAS NAME: N/A */
	/* 48.14 - 48.14 */
	 u_int8_t rx_heartbeat;
	/* Description - e2e fetch is allowed only according to this bit */
	/* 48.15 - 48.15 */
	 u_int8_t e2e_fetch_enable;
	/* Description - E2E Limit on 
TCU: exception if descriptor is required and Number_of_E2E_credits=RQ/SRQ.rwqe_limit_event
EAS NAME: N/A
condition:ts!=DCR */
	/* 48.16 - 52.31 */
	 u_int16_t rwqe_limit_event;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 52.0 - 56.31 */
	 u_int32_t mtt_pointer_31_0;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 56.0 - 56.29 */
	 u_int32_t e2e_pa_63_34;
	/* Description -  */
	/* 56.30 - 56.30 */
	 u_int8_t srq_valid;
	/* Description - each WQE in the r&s WQ are signature protected */
	/* 56.31 - 60.31 */
	 u_int8_t wq_signature;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - e2e credits pysical address, bits[63:2]
EAS NAME: rcv_dbr_adr
condition:rwq_type!=SRQ & ts!=XRC & ts!=DCR & ~post_receive_slave_enable */
	/* 60.0 - 64.31 */
	 u_int32_t e2e_pa_33_2;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_toc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  number that should be added to EQ number when giving an EQ DoorBell to RXC */
	/* 0.0 - 0.15 */
	 u_int16_t eqn_offset;
	/* Description -  number that should be added to MSIx Vector Number when giving an MSIx Read/Write operation to RXC */
	/* 0.16 - 4.31 */
	 u_int16_t msix_offset;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - NO_DESCR */
	/* 4.0 - 8.31 */
	 u_int32_t doorbell_record;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - NO_DESCR */
	/* 8.0 - 16.31 */
	 u_int64_t cmdq_phy_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 struct connectib_hw_init_info init_info;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - pci_configuration_per_pf_vf */
	/* 20.0 - 48.31 */
	 struct connectib_pf_vf_cfg_space pci_cfg_space;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 48.7 */
	 u_int8_t sw_cmd_eq;
	/* Description - cmdif_checksum */
	/* 48.8 - 48.9 */
	 u_int8_t csum;
	/* Description -  */
	/* 48.10 - 48.10 */
	 u_int8_t ext_mod;
	/* Description -  */
	/* 48.11 - 48.11 */
	 u_int8_t teardown_event;
	/* Description -  */
	/* 48.12 - 48.12 */
	 u_int8_t pre_icm_driver_refused;
	/* Description - Reported in function initialization segment: 1 - device still in initializing state.0 - device is ready to receive commands. There is also global bit - static_config_not_done */
	/* 48.13 - 48.13 */
	 u_int8_t initializing;
	/* Description - 0-idle, 1-in progress, 2-returning pages */
	/* 48.14 - 48.15 */
	 u_int8_t flr_state;
	/* Description -  */
	/* 48.24 - 52.31 */
	 u_int8_t issi;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - state for init gvmix function  - pre init hca */
	/* 52.0 - 52.7 */
	 u_int8_t hca_state;
	/* Description - 0 - disabled, 1 - full driver , 2 - simple nic - internal FW copy */
	/* 52.8 - 52.9 */
	 u_int8_t nic_interface_type;
	/* Description - 0 - disabled, 1 - full driver , 2 - simple nic - value of SW visible field */
	/* 52.10 - 52.11 */
	 u_int8_t nic_interface_type_sw;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - global nodnic (simple nic interface) index */
	/* 56.0 - 56.2 */
	 u_int8_t nodnic_idx;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_mkc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  check that the mkey version fit to cr_space version. */
	/* 0.0 - 0.3 */
	 u_int8_t version;
	/* Description -   0x0: PA - (VA=PA, no translation needed)
0x1: MTT - (PA is needed)
0x2: KLMs (Indirect access) 
 */
	/* 0.8 - 0.9 */
	 u_int8_t access_mode;
	/* Description -  If set, local read is enabled why is this check not part of the EAS? It's part of the IB Spec */
	/* 0.10 - 0.10 */
	 u_int8_t lr;
	/* Description -  If set, local write is enabled */
	/* 0.11 - 0.11 */
	 u_int8_t lw;
	/* Description -  If set, remote read is enabled */
	/* 0.12 - 0.12 */
	 u_int8_t rr;
	/* Description -  If set, remote write is enabled */
	/* 0.13 - 0.13 */
	 u_int8_t rw;
	/* Description -  If set, atomic operation is enabled */
	/* 0.14 - 0.14 */
	 u_int8_t a;
	/* Description -  If set, this Mkey context support UMR operations */
	/* 0.15 - 0.15 */
	 u_int8_t umr_en;
	/* Description -  If set, the corresponding bit in the transaltion response will be set
EAS: responder will have one read request toward the PCIe (per QP) */
	/* 0.16 - 0.16 */
	 u_int8_t small_fence_on_rdma_read_response;
	/* Description -  If cleared, no PCI access will be performed on the target address.
RDMA write will be druped drooped.
RDMA read will give zeroes.
need to open on QUERY_DUMP_FILL_MKEY
 */
	/* 0.17 - 0.17 */
	 u_int8_t goto_pci;
	/* Description -  If set issue PCIe cycle with  relaxed ordering  attribute (allows write after write bypassing)
EAS: If cleared, PCIe cycle should be issued with relaxed ordering attribute */
	/* 0.18 - 0.18 */
	 u_int8_t relaxed_ordering;
	/* Description -  If set, issue PCIe cycle with (no Snoop) attribute and this cycle will not be snooped in CPU cache */
	/* 0.19 - 0.19 */
	 u_int8_t no_snoop;
	/* Description - NO_DESCR */
	/* 0.20 - 0.21 */
	 u_int8_t tlp_processing_hints;
	/* Description - NO_DESCR */
	/* 0.22 - 0.22 */
	 u_int8_t tlp_processing_hints_en;
	/* Description -  Unbound Type1 windows are denoted by _len=0.
 Unbound Type II windows are denoted by Status = Free. */
	/* 0.30 - 0.30 */
	 u_int8_t free;
	/* Description - NO_DESCR */
	/* 0.31 - 4.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  Variant part of MKey specified by this MKey context */
	/* 4.0 - 4.7 */
	 u_int8_t mem_key;
	/* Description -  QP number this MW is attached to. (no QPN attached if QPN = 0xFFFFFF) */
	/* 4.8 - 8.31 */
	 u_int32_t qpn;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  Protection Domain. (no Protection Domain if PD = 0xFFFFFF) */
	/* 12.0 - 12.23 */
	 u_int32_t pd;
	/* Description -  Enable remote invalidation */
	/* 12.24 - 12.24 */
	 u_int8_t en_rinval;
	/* Description -  If set, MKEY is armed to produce sigerr cqe. */
	/* 12.26 - 12.26 */
	 u_int8_t num_of_sigerr;
	/* Description -  can improve permormance of klm */
	/* 12.28 - 12.28 */
	 u_int8_t trast_a_en;
	/* Description -  can improve permormance of bsf */
	/* 12.29 - 12.29 */
	 u_int8_t trast_b_en;
	/* Description -  If set, this MKey specifies BSF (signature context) remove? */
	/* 12.30 - 12.30 */
	 u_int8_t bsf_enabled;
	/* Description -  to determine that len is 2^64 */
	/* 12.31 - 16.31 */
	 u_int8_t length_64;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  Start Address - Virtual Address where this region/window starts */
	/* 16.0 - 24.31 */
	 u_int64_t start_address;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  Region/Window Length [bytes] */
	/* 24.0 - 32.31 */
	 u_int64_t length;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - NO_DESCR */
	/* 32.0 - 36.31 */
	 u_int32_t bsf_octoword_count;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - NO_DESCR */
	/* 36.0 - 36.14 */
	 u_int16_t bsf_first_index_46_32;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - NO_DESCR */
	/* 40.4 - 44.31 */
	 u_int32_t bsf_first_index_31_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  Handle specifying ICM area allocated for the MTT This area will be used by the HCA to store translation pages or list of pointers (indirect MKey) */
	/* 44.0 - 44.14 */
	 u_int16_t mtt_first_index_46_32;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  Handle specifying ICM area allocated for the MTT This area will be used by the HCA to store translation pages or list of pointers (indirect MKey) */
	/* 48.3 - 52.31 */
	 u_int32_t mtt_first_index_31_3;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  number of MTTs/KLMs octowords (16B) that are mapped to this region */
	/* 52.0 - 56.31 */
	 u_int32_t mtt_octoword_count;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  page size = 2^(entity_size) [byte] */
	/* 56.0 - 56.4 */
	 u_int8_t entity_size;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  init to 0 */
	/* 60.0 - 60.15 */
	 u_int16_t generation_counter;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_hw_cqc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 0.0 - 0.15 */
	 u_int16_t lookahead_size_23_8;
	/* Description - when this bit is cleared IRISC should be called */
	/* 0.16 - 0.16 */
	 u_int8_t cqc_valid;
	/* Description - CQE size: 0-64B, 1-128B
condition:cq */
	/* 0.17 - 0.17 */
	 u_int8_t cqe_128b_size;
	/* Description - qe_coalesce_checksum - Shomron only!!!
msix:
1: send interupt to MSIX
0:send interupt to int pin
condition:~cq */
	/* 0.18 - 0.18 */
	 u_int8_t cqe_coalesce_checksum_msix;
	/* Description -  */
	/* 0.22 - 0.23 */
	 u_int8_t pa_error;
	/* Description - page_size = 4096*2^log_page_size */
	/* 0.24 - 0.28 */
	 u_int8_t log_page_size;
	/* Description - 
condition:cq */
	/* 0.29 - 0.29 */
	 u_int8_t poll_cq_cqe_with_error_generated_on_this_queue;
	/* Description - 
condition:cq */
	/* 0.30 - 0.30 */
	 u_int8_t poll_cq_queue_in_error_state;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t last_notified_check_for_arm_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - index of the last CQE with SE bit set
condition:cq */
	/* 4.0 - 4.23 */
	 u_int32_t last_solicited_index;
	/* Description - When pi - ci = lookahead_size ci is read from memory
condition:cq */
	/* 4.24 - 8.31 */
	 u_int8_t lookahead_size_7_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 8.0 - 12.31 */
	 u_int32_t pa0_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - CQ start address is: cq_page_offset &lt;&lt; (crspace+6)
It was changed to log page size from the context */
	/* 12.0 - 12.5 */
	 u_int8_t cq_page_offset;
	/* Description - 
condition:cq */
	/* 12.6 - 12.6 */
	 u_int8_t db_recovery_enable;
	/* Description - set to 1 on every CQE creation */
	/* 12.7 - 12.7 */
	 u_int8_t cqe_heartbeat;
	/* Description - 0: no pa fetch
1: single pa (bring next pa when last CQE of page is written)
2: dual pa prefetch */
	/* 12.8 - 12.9 */
	 u_int8_t pa_mode;
	/* Description - All the CQEs are written to the same address. Required for CQE coalescing */
	/* 12.10 - 12.10 */
	 u_int8_t shrink;
	/* Description - when this bit is set, FW should be called */
	/* 12.11 - 12.11 */
	 u_int8_t cq_trap;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 12.12 - 16.31 */
	 u_int32_t pa0_31_12;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 16.0 - 16.7 */
	 u_int8_t moderation_cnt_limit_15_8;
	/* Description - last index for which an event was created */
	/* 16.8 - 20.31 */
	 u_int32_t last_notified_index;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.23 */
	 u_int32_t producer_index;
	/* Description - minimum # of cqes to generate eqe
condition:cq */
	/* 20.24 - 24.31 */
	 u_int8_t moderation_cnt_limit_7_0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - CQC: eqn+eq_offset
EQC with MSIX: ^ MSIX number+offset
EQC with interrupt: 0-INT_A, 1-INT_B, 2-INT_C, 3-INT_D, 4-INT_YU */
	/* 24.0 - 24.19 */
	 u_int32_t eqn_msix;
	/* Description - minimum wait time between eqe:
0 means moderation is disabled on this CQ
condition:cq */
	/* 24.20 - 28.31 */
	 u_int16_t moderation_min_wait_time;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - doorbell ci - in the case of cq_state different from Fired, this field indicates what should be pi for firing the event. Updated by the doorbell handler */
	/* 28.0 - 28.23 */
	 u_int32_t db_ci;
	/* Description - amount of CQE in CQ is 2^los2_size */
	/* 28.24 - 28.28 */
	 u_int8_t log2_size;
	/* Description - set to 1 on every received DB */
	/* 28.29 - 28.29 */
	 u_int8_t db_heartbeat;
	/* Description - used for db.db_sn check
condition:cq */
	/* 28.30 - 32.31 */
	 u_int8_t number_of_events_generated;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 32.0 - 36.31 */
	 u_int32_t cipa_63_32;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 36.0 - 36.2 */
	 u_int8_t mtt_pointer_39_37;
	/* Description - bits[63:3] of the physical address of the ci
condition:cq */
	/* 36.3 - 40.31 */
	 u_int32_t cipa_31_3;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Used in TPT for wqe translation */
	/* 40.0 - 44.31 */
	 u_int32_t mtt_pointer_36_5;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 44.23 */
	 u_int32_t consumer_index;
	/* Description - 0-Fired
1-Armed Solicited
2-Armed
3-Always Armed
Hermon name: state */
	/* 44.24 - 44.25 */
	 u_int8_t cq_state;
	/* Description - When set: ci is ignored, and never read (block,lookahead) */
	/* 44.26 - 44.26 */
	 u_int8_t overrun_ignore;
	/* Description - Used in TPT for wqe translation */
	/* 44.27 - 48.31 */
	 u_int8_t mtt_pointer_4_0;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 48.0 - 52.31 */
	 u_int32_t pa1_63_32;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - updated when eqe is generated from a global timer */
	/* 52.0 - 52.11 */
	 u_int16_t moderation_timestamp_51_40;
	/* Description - MSB of physical address translation, 12lsb are VA[11:0] */
	/* 52.12 - 56.31 */
	 u_int32_t pa1_31_12;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - updated when eqe is generated from a global timer */
	/* 56.0 - 60.31 */
	 u_int32_t moderation_timestamp_39_8;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - 
EAS NAME: usr_page */
	/* 60.0 - 60.23 */
	 u_int32_t uar;
	/* Description - updated when eqe is generated from a global timer */
	/* 60.24 - 64.31 */
	 u_int8_t moderation_timestamp_7_0;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_ffe_tap_set {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t ffe_tap0;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t ffe_tap1;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t ffe_tap2;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t ffe_tap3;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t ffe_tap4;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_GEN3_TRANSMITTER_SETTING {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.5 */
	 u_int8_t post;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t reject_coeff;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t parity;
	/* Description -  */
	/* 0.8 - 0.13 */
	 u_int8_t main;
	/* Description -  */
	/* 0.16 - 0.21 */
	 u_int8_t pre;
	/* Description -  */
	/* 0.24 - 0.25 */
	 u_int8_t ec;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t reset_eieos;
	/* Description -  */
	/* 0.27 - 0.30 */
	 u_int8_t preset;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t use_preset;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_gpio_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t mode0;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t mode1;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t def_val;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t pull_up;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t pull_en;
	/* Description - 1-masked (don't use function defaults), 0-not masked */
	/* 0.7 - 0.7 */
	 u_int8_t masked;
};

/* Description -   */
/* Size in bytes - 1 */
struct connectib_gpio_function {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Map function to GPIO num, 0x3f - function not present. */
	/* 0.0 - 0.5 */
	 u_int8_t mapping;
	/* Description - function polarity 0-normal, 1-reverse. Normal polarity means 0 = non active, 1 = active. */
	/* 0.6 - 0.6 */
	 u_int8_t reverse_polarity;
	/* Description - 1-masked (don't use function defaults), 0-not masked */
	/* 0.7 - 0.7 */
	 u_int8_t masked;
};

/* Description -  to be used in core2phy interface (not in page format) */
/* Size in bytes - 4 */
struct connectib_mlpn_enhanced_database_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn bits */
	/* 0.0 - 4.31 */
	 struct connectib_mlnx_enhanced_equal_info_ini as_bits;
};

/* Description -  mlpn cability (ability)/ admin (request) bits for ScratchPad (not in pages foramt) */
/* Size in bytes - 4 */
struct connectib_mlpn_database_all_protocol_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn bits */
	/* 0.0 - 4.31 */
	 struct connectib_mlpn_database_all_protocol_bits_ini as_bits;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_tx_rx_logic_serdes_mapping_node_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 u_int32_t logic_to_serdes[8];
};

/* Description -   */
/* Size in bytes - 1088 */
struct connectib_serdes_conf_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 384.31 */
	 struct connectib_serdes_autoneg_sets_ini nego;
/*---------------- DWORD[96] (Offset 0x180) ----------------*/
	/* Description - sets 0-7   : IB 8/10
sets 8-15 : IB 8/10 for legacy device
sets16-31: IB FDR */
	/* 384.0 - 768.31 */
	 struct connectib_serdes_aba_sets_ini aba;
/*---------------- DWORD[192] (Offset 0x300) ----------------*/
	/* Description - set0: force sdr
set1: force ddr
set2: force qdr
set3: force fdr
set4: aggressor
set5: force xaui
set6: force sgmii
set7: force xfi
set8: ffe initial
set9: for slicer4err calib */
	/* 768.0 - 888.31 */
	 struct connectib_serdes_force_sets_ini force;
/*---------------- DWORD[222] (Offset 0x378) ----------------*/
	/* Description - set0: half active fibre IB 8/10
set1: active fibre IB 8/10
set2: half active fibre IB FDR (64/66)
set3: active fibre IB FDR (64/66) */
	/* 888.0 - 936.31 */
	 struct connectib_serdes_active_sets_ini active;
/*---------------- DWORD[234] (Offset 0x3a8) ----------------*/
	/* Description - spec1_3 preset for fdr */
	/* 936.0 - 1000.31 */
	 struct connectib_serdes_preset_sets_ini preset_tx_fdr;
/*---------------- DWORD[250] (Offset 0x3e8) ----------------*/
	/* Description - spec1_3 preset for qdr */
	/* 1000.0 - 1064.31 */
	 struct connectib_serdes_preset_sets_ini preset_tx_qdr;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_rx_adapt_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - max number of FFE steps bedore stop. 0 - unlimited */
	/* 0.0 - 0.5 */
	 u_int8_t max_num_ffe_search;
	/* Description - number of FFE taps to use.
allow values: 1-5 */
	/* 0.6 - 0.8 */
	 u_int8_t num_of_ffe_taps;
	/* Description - number of HW machine FFE searches before FW interfere */
	/* 0.9 - 0.14 */
	 u_int8_t num_of_ffe_hw_steps;
	/* Description - how many HW machine runs before doing eye open to help with ffe stop condition.
0 - dont do eye open for ffe stop condition */
	/* 0.15 - 0.18 */
	 u_int8_t num_hw_ffe_before_open_eye;
	/* Description - when set, dont do FFE search in RX adaptation flow, just go over RX sets. */
	/* 0.19 - 0.19 */
	 u_int8_t skip_ffe_srch;
	/* Description - when set, dont do RX buffer sets seatch in RX adaptation. */
	/* 0.20 - 0.20 */
	 u_int8_t skip_rx_srch;
	/* Description -  */
	/* 0.21 - 0.27 */
	 u_int8_t offset_eye_opener_range;
	/* Description - Max gap between eye pointers of current set and best set */
	/* 0.28 - 4.31 */
	 u_int8_t mixer_offset_grade_margin;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - jump size for first level of FFE search */
	/* 4.0 - 4.3 */
	 u_int8_t jump_size_ffe_level1;
	/* Description - jump size for second level of FFE search */
	/* 4.4 - 4.7 */
	 u_int8_t jump_size_ffe_level2;
	/* Description - jump size for third level of FFE search */
	/* 4.8 - 4.11 */
	 u_int8_t jump_size_ffe_level3;
	/* Description - determines start point of linear search on phase  */
	/* 4.12 - 4.16 */
	 u_int8_t delta_from_edges_phase;
	/* Description - determines start point of linear search on offset */
	/* 4.17 - 4.22 */
	 u_int8_t delta_from_edges_offst;
	/* Description -  */
	/* 4.23 - 4.23 */
	 u_int8_t offset_penalty_en;
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t offset_penalty_weight;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - center the eye on the phase */
	/* 8.0 - 8.0 */
	 u_int8_t center_mix90phase;
	/* Description -  */
	/* 8.1 - 8.1 */
	 u_int8_t disable_calib_in_QDR_rev0;
	/* Description - center the eye on the offset */
	/* 8.2 - 8.2 */
	 u_int8_t center_mixer_offset;
	/* Description - enable mixer_offset_grade_margin feature */
	/* 8.3 - 8.3 */
	 u_int8_t grade_mixer_margin_en;
	/* Description - 2^value * 64ns */
	/* 8.4 - 8.8 */
	 u_int8_t eye_open_machine_measure_time;
	/* Description - 2^value * 64ns */
	/* 8.9 - 8.13 */
	 u_int8_t eye_open_machine_stab_time;
	/* Description - minimum grade for eye. if below this grade, dont finish RX adaptation */
	/* 8.14 - 8.21 */
	 u_int8_t best_grade_th;
	/* Description -  */
	/* 8.22 - 8.26 */
	 u_int8_t eye_open_machine_stab_time_extended;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 u_int8_t eye_phase_diff_min;
	/* Description -  */
	/* 12.8 - 12.15 */
	 u_int8_t eye_offset_diff_min;
	/* Description -  */
	/* 12.16 - 12.16 */
	 u_int8_t min_eye_en;
	/* Description -  */
	/* 12.17 - 12.17 */
	 u_int8_t grade_eye_from_center;
	/* Description - if max_tap_offset exceeds this value - offset_grade is 0 */
	/* 12.18 - 12.23 */
	 u_int8_t offset_zero_grade_threshold;
	/* Description -  */
	/* 12.24 - 12.28 */
	 u_int8_t eye_open_machine_measure_time_in_stab_extend;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Maximal value for offset_grade. If offset_grade exceeds - it truncated to this value */
	/* 16.2 - 16.7 */
	 u_int8_t offset_max_grade;
	/* Description - seperate the eyes that passes this limit from the ones that did not pass */
	/* 16.8 - 16.12 */
	 u_int8_t phase_limit;
	/* Description -  */
	/* 16.13 - 16.15 */
	 u_int8_t rx_adaptation_reattempts;
	/* Description - weight for phase in grade calc */
	/* 16.16 - 16.23 */
	 u_int8_t phase_weight;
	/* Description - weight for offsetin grade calc */
	/* 16.24 - 20.31 */
	 u_int8_t offset_weight;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - maximum for the sum of rx taps */
	/* 20.0 - 20.7 */
	 u_int8_t rx_taps_norm_val;
};

/* Description -   */
/* Size in bytes - 96 */
struct connectib_ib_ini_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - The time to wait (* 50 usec) before turn off llr if lp don't has llr enabled.
Actual only for FDR
SDR/DDR/QDR wait time is 150 usec. */
	/* 0.0 - 0.5 */
	 u_int8_t llr_wait_time;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t spec1_3_ignore_peer_tx_req;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t qdr_tx_aggressor_en;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t equal_req_en;
	/* Description -  */
	/* 0.9 - 0.10 */
	 u_int8_t ts3_fcu;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t ts3_hbr;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t ts3_sct;
	/* Description -  */
	/* 0.13 - 0.13 */
	 u_int8_t ts3_tp;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t ts3_mpr;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t ts3_ft;
	/* Description -  */
	/* 0.16 - 0.20 */
	 u_int8_t min_ib_grade;
	/* Description -  */
	/* 0.21 - 0.24 */
	 u_int8_t tx_polarity_port0;
	/* Description -  */
	/* 0.25 - 0.28 */
	 u_int8_t tx_polarity_port1;
	/* Description - bit mask per logical port */
	/* 0.29 - 0.30 */
	 u_int8_t Mloop_en_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 12.31 */
	 struct connectib_ib_ini_per_lcl_ini lcl[2];
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.6 */
	 u_int8_t retry_counter_threshold;
	/* Description -  */
	/* 12.7 - 12.14 */
	 u_int8_t time_2_clear_err_after_linkup;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - hold the spec1_3 preset mask from INI and all the ABA masks and borders */
	/* 16.0 - 92.31 */
	 struct connectib_spec1_3_preset_ini spec1_3_preset;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description -  */
	/* 92.0 - 92.0 */
	 u_int8_t disable_llr_on_long_optic;
	/* Description -  */
	/* 92.1 - 92.7 */
	 u_int8_t llr_max_cable_length;
	/* Description -  */
	/* 92.8 - 92.8 */
	 u_int8_t terminate_pkt_timeout;
	/* Description -  */
	/* 92.9 - 92.9 */
	 u_int8_t llr_rx_check_en;
	/* Description -  */
	/* 92.10 - 92.10 */
	 u_int8_t enable_fec_on_long_optic;
	/* Description -  */
	/* 92.11 - 92.17 */
	 u_int8_t fec_min_cable_length;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_PORT_PHY_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_serdes_param_mask_ini serdes_param_mask;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_nv_config_tpt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_data_tpt_settings settings;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_nv_tlv_data_tpt_capabilities capabilities;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_nv_config_pci {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 12.31 */
	 struct connectib_nv_tlv_data_pci_settings settings;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 32.31 */
	 struct connectib_nv_tlv_data_pci_capabilities capabilities;
};

/* Description -   */
/* Size in bytes - 56 */
struct connectib_advanced_error_reporting {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t cap_id;
	/* Description -  */
	/* 0.16 - 0.19 */
	 u_int8_t version;
	/* Description -  */
	/* 0.20 - 4.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_uncorrectable_error_status uncorrectable_error_status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_uncorrectable_error_mask uncorrectable_error_mask;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_uncorrectable_error_severity uncorrectable_error_severity;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 struct connectib_correctable_error_status correctable_error_status;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 struct connectib_correctable_error_mask correctable_error_mask;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 struct connectib_advanced_error_cap_ctl advanced_error_cap_ctl;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 44.31 */
	 struct connectib_header_log header_log;
};

/* Description -  Device serial number capability */
/* Size in bytes - 12 */
struct connectib_dev_serial_num_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.15 */
	 u_int16_t cap_id;
	/* Description - capability id */
	/* 0.16 - 0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0.20 - 4.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t serial_number_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t serial_number_63_32;
};

/* Description -  Single Root IO virtualization capability */
/* Size in bytes - 64 */
struct connectib_sriov_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - SR-IOV capability id */
	/* 0.0 - 0.15 */
	 u_int16_t cap_id;
	/* Description - SR-IOV capability version */
	/* 0.16 - 0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0.20 - 4.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_sriov_capabilities capabilities;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 struct connectib_sriov_control ctrl;
	/* Description -  */
	/* 8.16 - 12.31 */
	 struct connectib_sriov_status status;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - The numbe rof VFs that are initially associated with the PF */
	/* 12.0 - 12.15 */
	 u_int16_t initial_vfs;
	/* Description - The maximum number of VFs that could be associated with the PF */
	/* 12.16 - 16.31 */
	 u_int16_t total_vfs;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - The number of VFs that are visible */
	/* 16.0 - 16.15 */
	 u_int16_t num_vfs;
	/* Description - Function dependency Link */
	/* 16.16 - 16.23 */
	 u_int8_t func_dependency_link;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - First VF Offset */
	/* 20.0 - 20.15 */
	 u_int16_t first_vf_offset;
	/* Description - VF Stride */
	/* 20.16 - 24.31 */
	 u_int16_t vf_stride;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.16 - 28.31 */
	 u_int16_t vf_device_id;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Supported Page Sizes. By default support all page size up to 4MB */
	/* 28.0 - 32.31 */
	 u_int32_t supported_page_sizes;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - System Page Size */
	/* 32.0 - 36.31 */
	 u_int32_t system_page_size;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 struct connectib_bar_low vf_bar0;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 struct connectib_bar_high vf_bar1;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 struct connectib_bar_low vf_bar2;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 struct connectib_bar_high vf_bar3;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 struct connectib_bar_low vf_bar4;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 60.31 */
	 struct connectib_bar_high vf_bar5;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - VF Migration State Array Offset */
	/* 60.0 - 64.31 */
	 u_int32_t vf_migstate_arrayofst;
};

/* Description -  alternative routing id cap */
/* Size in bytes - 8 */
struct connectib_ari_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.15 */
	 u_int16_t cap_id;
	/* Description - capability id */
	/* 0.16 - 0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0.20 - 4.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 struct connectib_ari_capabilities ari_capabilities;
	/* Description -  */
	/* 4.16 - 8.31 */
	 struct connectib_ari_control ari_control;
};

/* Description -  Secondary pcie extended capability for gen3 device */
/* Size in bytes - 44 */
struct connectib_secondary_pciex_ext_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.15 */
	 u_int16_t cap_id;
	/* Description - capability version */
	/* 0.16 - 0.19 */
	 u_int8_t version;
	/* Description - next capability pointer */
	/* 0.20 - 4.31 */
	 u_int16_t nxt_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_pciex_link_ctl3 pciex_link_ctl3;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t lane_err_bits;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 44.31 */
	 struct connectib_lane_eql_ctl lane_eql_ctl[8];
};

/* Description -  PCIe MSIX capability block */
/* Size in bytes - 12 */
struct connectib_msix_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.7 */
	 u_int8_t msix_cap_id;
	/* Description - next capability pointer */
	/* 0.8 - 0.15 */
	 u_int8_t nxt_ptr;
	/* Description - VPD address */
	/* 0.16 - 4.31 */
	 struct connectib_message_control message_control;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Vector table BAR number */
	/* 4.0 - 4.2 */
	 u_int8_t Table_BIR;
	/* Description - Vector table offset in the BAR */
	/* 4.3 - 8.31 */
	 u_int32_t Table_Offset;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Pending bit array BAR number */
	/* 8.0 - 8.2 */
	 u_int8_t PBA_BIR;
	/* Description - PBA offset in the BAR */
	/* 8.3 - 12.31 */
	 u_int32_t PBA_Offset;
};

/* Description -  PCIe capability block */
/* Size in bytes - 60 */
struct connectib_pciex_cap_block {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.7 */
	 u_int8_t pciex_cap_id;
	/* Description - next capability pointer */
	/* 0.8 - 0.15 */
	 u_int8_t nxt_ptr;
	/* Description -  */
	/* 0.16 - 4.31 */
	 struct connectib_pciex_cap pciex_cap;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_device_caps device_caps;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 struct connectib_device_ctl device_ctl;
	/* Description -  */
	/* 8.16 - 12.31 */
	 struct connectib_device_stat device_stat;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_link_caps link_caps;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.15 */
	 struct connectib_link_ctl link_ctl;
	/* Description -  */
	/* 16.16 - 20.31 */
	 struct connectib_link_stat link_stat;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 struct connectib_device_caps2 device_caps2;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 40.15 */
	 struct connectib_device_ctl2 device_ctl2;
	/* Description -  */
	/* 40.16 - 44.31 */
	 struct connectib_device_stat2 device_stat2;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 struct connectib_link_caps2 link_caps2;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 48.15 */
	 struct connectib_link_ctl2 link_ctl2;
	/* Description -  */
	/* 48.16 - 52.31 */
	 struct connectib_link_stat2 link_stat2;
};

/* Description -  PCIe VPD capability block */
/* Size in bytes - 8 */
struct connectib_vpd_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability id */
	/* 0.0 - 0.7 */
	 u_int8_t vpd_cap_id;
	/* Description - next capability pointer */
	/* 0.8 - 0.15 */
	 u_int8_t nxt_ptr;
	/* Description - VPD address */
	/* 0.16 - 0.30 */
	 u_int16_t vpd_address;
	/* Description - Flag - indicates a read/write command */
	/* 0.31 - 4.31 */
	 u_int8_t F;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - VPD data */
	/* 4.0 - 8.31 */
	 u_int32_t vpd_data;
};

/* Description -  Power Management Capability */
/* Size in bytes - 8 */
struct connectib_pci_power_management_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t cap_id;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t nxt_ptr;
	/* Description -  */
	/* 0.16 - 0.18 */
	 u_int8_t version;
	/* Description -  */
	/* 0.19 - 0.19 */
	 u_int8_t pme_clock;
	/* Description -  */
	/* 0.21 - 0.21 */
	 u_int8_t device_specific;
	/* Description -  */
	/* 0.22 - 0.22 */
	 u_int8_t aux_current;
	/* Description -  */
	/* 0.25 - 0.25 */
	 u_int8_t d1_support;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t d2_support;
	/* Description -  */
	/* 0.27 - 4.31 */
	 u_int8_t pme_support;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0-D0, 1-D1, 2-D2, 3-D3 */
	/* 4.0 - 4.1 */
	 u_int8_t power_state;
	/* Description - No_Soft_Reset - When set , this bit indicates that devices transitioning from D3hot to D0 because ofPowerState commands do not perform an internal reset. */
	/* 4.3 - 4.3 */
	 u_int8_t no_soft_reset;
	/* Description -  */
	/* 4.8 - 4.8 */
	 u_int8_t pme_enable;
	/* Description -  */
	/* 4.9 - 4.12 */
	 u_int8_t data_select;
	/* Description -  */
	/* 4.13 - 4.14 */
	 u_int8_t data_scale;
	/* Description -  */
	/* 4.15 - 4.15 */
	 u_int8_t pme_status;
	/* Description - not applicable for PCIe- should be 0 all the time */
	/* 4.16 - 4.23 */
	 u_int8_t pmcsr_bse;
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t data;
};

/* Description -  type0 configuration space */
/* Size in bytes - 64 */
struct connectib_pci_cfg_hdr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pcie vendor id */
	/* 0.0 - 0.15 */
	 u_int16_t vendor_id;
	/* Description - pcie device id */
	/* 0.16 - 4.31 */
	 u_int16_t device_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 struct connectib_cmd_reg1 cmd;
	/* Description -  */
	/* 4.16 - 8.31 */
	 struct connectib_stat_reg1 status;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - revision id */
	/* 8.0 - 8.7 */
	 u_int8_t rev_id;
	/* Description - class code */
	/* 8.8 - 12.31 */
	 u_int32_t class_code;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 u_int8_t cache_line;
	/* Description -  */
	/* 12.8 - 12.15 */
	 u_int8_t latency;
	/* Description -  */
	/* 12.16 - 12.23 */
	 u_int8_t hdr_type;
	/* Description -  */
	/* 12.24 - 16.31 */
	 u_int8_t bist;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 struct connectib_bar_low reg4;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 struct connectib_bar_high reg5;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 struct connectib_bar_low reg6;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 struct connectib_bar_high reg7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 struct connectib_bar_low reg8;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 struct connectib_bar_high reg9;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 44.15 */
	 u_int16_t sub_vendor_id;
	/* Description -  */
	/* 44.16 - 48.31 */
	 u_int16_t subsystem_id;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - expansion ROM base address */
	/* 48.0 - 52.31 */
	 struct connectib_exp_rom reg12;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Capabilities pointer */
	/* 52.0 - 52.7 */
	 u_int8_t cap_ptr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 60.7 */
	 u_int8_t interrupt_line;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t interrupt_pin;
	/* Description -  */
	/* 60.16 - 64.31 */
	 u_int16_t min_gnt_max_lat;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_port_settings {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_nv_tlv_data_vpi_settings vpi;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_phy_lcl_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t PlaceHolder;
};

/* Description -   */
/* Size in bytes - 4 */
union connectib_port_cap_mask1 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_port_cap_mask1_fields fields;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_dword_val dword;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reset_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Reset considered only if valid is set */
	/* 0.0 - 0.0 */
	 u_int8_t valid;
	/* Description - If Major matches. Match means seamless reset. Greater means reset supported. Less then upgrade not supported */
	/* 0.4 - 0.15 */
	 u_int16_t minor;
	/* Description - Match means upgrade supported, mismatch implies reset not supported */
	/* 0.16 - 4.31 */
	 u_int16_t major;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_mac_address_layout {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Upper bits of mac address. */
	/* 0.0 - 0.15 */
	 u_int16_t mac_addr_47_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Lower bits of mac address. */
	/* 4.0 - 8.31 */
	 u_int32_t mac_addr_31_0;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_resource_type_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t type;
	/* Description - resource is locked in icmc */
	/* 0.31 - 4.31 */
	 u_int8_t locked;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_index_and_length {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - first open resource index */
	/* 0.0 - 8.31 */
	 u_int64_t index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - number of open resources following (including the first one) */
	/* 8.0 - 12.31 */
	 u_int32_t length;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_dest_format_struct {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - when destination_type == VPORT - destination
 
is vport number .
when destination_type == FLOW_TABLE - destination is Flow Table Id.
when destination_type == TIR - destination is TIR. */
	/* 0.0 - 0.23 */
	 u_int32_t destination_id;
	/* Description - Define the destination type. valid only when action==FWD_DEST
1: FLOW_TABLE.
2: TIR
others: reserved. */
	/* 0.24 - 4.31 */
	 u_int8_t destination_type;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_flow_table_entry_match_set_lyr_2_4 {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Source MAC address of incoming packet. */
	/* 0.0 - 4.31 */
	 u_int32_t smac_47_16;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Incoming packet Ethertype - this is the Ethertype following the last VLAN 
tag of the packet. */
	/* 4.0 - 4.15 */
	 u_int16_t ethertype;
	/* Description - Source MAC address of incoming packet. */
	/* 4.16 - 8.31 */
	 u_int16_t smac_15_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Destination MAC address of incoming packet. */
	/* 8.0 - 12.31 */
	 u_int32_t dmac_47_16;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - VLAN ID of incoming packet VLAN tag. This field represents the first tag 
for Q in Q, and the only tag in single tagged packet. */
	/* 12.0 - 12.11 */
	 u_int16_t first_vid;
	/* Description - CFI bit of incoming packet VLAN tag. This field represents the first tag 
for Q in Q, and the only tag in single tagged packet. */
	/* 12.12 - 12.12 */
	 u_int8_t first_cfi;
	/* Description - Priority of incoming packet VLAN tag. This field represents the first tag 
for Q in Q, and the only tag in single tagged packet. */
	/* 12.13 - 12.15 */
	 u_int8_t first_prio;
	/* Description - Destination MAC address of incoming packet. */
	/* 12.16 - 16.31 */
	 u_int16_t dmac_15_0;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - TCP flags. 
Bit 0: FIN
Bit 1: SYN
Bit 2: RST
Bit 3: PSH
Bit 4: ACK
Bit 5: URG
Bit 6: ECE
Bit 7: CWR
Bit 8: NS */
	/* 16.0 - 16.8 */
	 u_int16_t tcp_flags;
	/* Description - Packet is an IP fragment
. */
	/* 16.13 - 16.13 */
	 u_int8_t frag;
	/* Description - Packet has a first VLAN tag present. */
	/* 16.15 - 16.15 */
	 u_int8_t vlan_tag;
	/* Description - Explicit Congestion Notification derived from Traffic Class/TOS field of 
IPv6/v4 */
	/* 16.16 - 16.17 */
	 u_int8_t ip_ecn;
	/* Description - Differentiated Services Code Point derived from Traffic Class/TOS field 
of IPv6/v4 */
	/* 16.18 - 16.23 */
	 u_int8_t ip_dscp;
	/* Description - IP protocol. */
	/* 16.24 - 20.31 */
	 u_int8_t ip_protocol;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - TCP
d
estination port. 
tcp and udp sport/dport are mutual exclusive. i.e. can't have udp and tcp 
together. */
	/* 20.0 - 20.15 */
	 u_int16_t tcp_dport;
	/* Description - TCP
 s
ource port.
tcp and udp sport/dport are mutual exclusive. i.e. can't have udp and tcp 
together. */
	/* 20.16 - 24.31 */
	 u_int16_t tcp_sport;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - U
DP destination port.
tcp and udp sport/dport are mutual exclusive. i.e. can't have udp and tcp 
together. */
	/* 28.0 - 28.15 */
	 u_int16_t udp_dport;
	/* Description - U
DP source port.
tcp and udp sport/dport are mutual exclusive. i.e. can't have udp and tcp 
together. */
	/* 28.16 - 32.31 */
	 u_int16_t udp_sport;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 32.0 - 36.31 */
	 u_int32_t src_ip_127_96;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 36.0 - 40.31 */
	 u_int32_t src_ip_95_64;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 40.0 - 44.31 */
	 u_int32_t src_ip_63_32;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - IPv6 source address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 44.0 - 48.31 */
	 u_int32_t src_ip_31_0;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 48.0 - 52.31 */
	 u_int32_t dst_ip_127_96;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 52.0 - 56.31 */
	 u_int32_t dst_ip_95_64;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 56.0 - 60.31 */
	 u_int32_t dst_ip_63_32;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - IPv6 destination address of incoming packets ;For IPv4 address use bits 31:0 (rest of the bits are reserved);This field should be qualified by an appropriate ;ether;t;ype */
	/* 60.0 - 64.31 */
	 u_int32_t dst_ip_31_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_flow_table_entry_match_set_misc {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Source port.
0xffff determines wire port. */
	/* 4.0 - 4.15 */
	 u_int16_t source_port;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - VLAN ID of incoming packet VLAN tag. This field represent the second tag 
for Q in Q, and is not valid in single tagged packet (encapsulated). */
	/* 8.0 - 8.11 */
	 u_int16_t inner_second_vid;
	/* Description - CFI bit of incoming packet VLAN tag. This field represent the second tag for 
Q in Q, and is not valid in single tagged packet (encapsulated). */
	/* 8.12 - 8.12 */
	 u_int8_t inner_second_cfi;
	/* Description - Priority of incoming packet VLAN tag. This field represent the second tag for 
Q in Q, and is not valid in single tagged packet (encapsulated). */
	/* 8.13 - 8.15 */
	 u_int8_t inner_second_prio;
	/* Description - VLAN ID of incoming packet VLAN tag. This field represent the second tag 
for Q in Q, and is not valid in single tagged packet (outer). */
	/* 8.16 - 8.27 */
	 u_int16_t outer_second_vid;
	/* Description - CFI bit of incoming packet VLAN tag. This field represent the second tag for 
Q in Q, and is not valid in single tagged packet (outer). */
	/* 8.28 - 8.28 */
	 u_int8_t outer_second_cfi;
	/* Description - Priority of incoming packet VLAN tag. This field represent the second tag for 
Q in Q, and is not valid in single tagged packet (outer). */
	/* 8.29 - 12.31 */
	 u_int8_t outer_second_prio;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - GRE Protocol (outer). */
	/* 12.0 - 12.15 */
	 u_int16_t gre_protocol;
	/* Description - Packet has a second inner VLAN tag present. */
	/* 12.30 - 12.30 */
	 u_int8_t inner_second_vlan_tag;
	/* Description - Packet has a second outer VLAN tag present. */
	/* 12.31 - 16.31 */
	 u_int8_t outer_second_vlan_tag;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - GRE Key [7:0] (outer). */
	/* 16.0 - 16.7 */
	 u_int8_t gre_key_l;
	/* Description - GRE Key[31:8] (outer). */
	/* 16.8 - 20.31 */
	 u_int32_t gre_key_h;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - VXLAN VNI (outer). */
	/* 20.8 - 24.31 */
	 u_int32_t vxlan_vni;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - Flow label of incoming IPv6 packet (outer). */
	/* 28.0 - 28.19 */
	 u_int32_t outer_ipv6_flow_label;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Flow label of incoming IPv6 packet (inner). */
	/* 32.0 - 32.19 */
	 u_int32_t inner_ipv6_flow_label;
};

/* Description -   */
/* Size in bytes - 248 */
union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_802_3_cntrs_grp_data_layout eth_802_3_cntrs_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_2863_cntrs_grp_data_layout eth_2863_cntrs_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_2819_cntrs_grp_data_layout eth_2819_cntrs_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_3635_cntrs_grp_data_layout eth_3635_cntrs_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_extended_cntrs_grp_data_layout eth_extended_cntrs_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_per_prio_grp_data_layout eth_per_prio_grp_data_layout;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_eth_per_traffic_grp_data_layout eth_per_traffic_grp_data_layout;
	/* Description -  */
	/* 0.0 - 200.31 */
	 struct connectib_phys_layer_cntrs phys_layer_cntrs;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_discard_cntrs_grp_data discard;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_llr_counters llr_counters;
	/* Description -  */
	/* 0.0 - 248.31 */
	 struct connectib_ib_port_counters ib_port_counters;
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_fw_vport_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  0-port is down, 1-port is up, 2-follow */
	/* 0.0 - 0.1 */
	 u_int8_t esw_state;
	/* Description -  ETH: 0-port is down, 1-port is up, IB: 1-down, 2- initalize, 3- arm, 4- active */
	/* 0.2 - 0.4 */
	 u_int8_t nic_state;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t connected_2_steering;
	/* Description - bit mask: PORT_MAD_EVENT_NUM_PKEY =  0
PORT_MAD_EVENT_NUM_LID =  1
PORT_MAD_EVENT_NUM_CLIENT_REREG = 2
PORT_MAD_EVENT_NUM_GUID = 3
 PORT_MAD_EVENT_NUM_PORT_STATE = 4
 */
	/* 0.8 - 0.15 */
	 u_int8_t event_mask;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_vf_pages_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int64_t pages[8];
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icm_page_manager {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - pointer to first free page. Head of page linked list */
	/* 0.0 - 8.31 */
	 u_int64_t page_list;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Number of free pages (without the pre-allocated pages) available to GVMI */
	/* 8.0 - 12.31 */
	 u_int32_t free_count;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Number of used pages of GVMI */
	/* 12.0 - 16.31 */
	 u_int32_t used_count;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Number of free pages + pre-allocated unused pages */
	/* 16.0 - 20.31 */
	 u_int32_t page_list_length;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - If set, means page manager is used by another flow */
	/* 20.0 - 20.0 */
	 u_int8_t lock;
	/* Description - Event was triggered and response is still pending */
	/* 20.1 - 20.1 */
	 u_int8_t event_pending;
	/* Description - Received a command from driver refusing to give pages. Return fail instead of wait for alloc pages request */
	/* 20.2 - 20.2 */
	 u_int8_t driver_refused;
	/* Description -  0-init state, 1-default state, 2-teardown state */
	/* 20.3 - 20.4 */
	 u_int8_t state;
	/* Description -  */
	/* 20.5 - 20.5 */
	 u_int8_t valid;
	/* Description -  */
	/* 20.16 - 20.23 */
	 u_int8_t num_vf_pages;
	/* Description -  */
	/* 20.24 - 24.31 */
	 u_int8_t vf_page_ix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_hca_params {
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t partition_cap;
	/* Description -  */
	/* 8.24 - 8.28 */
	 u_int8_t log_max_qp;
	/* Description -  */
	/* 8.29 - 8.29 */
	 u_int8_t phy_port_owner;
	/* Description -  */
	/* 8.30 - 8.30 */
	 u_int8_t eswitch_owner;
	/* Description -  */
	/* 8.31 - 12.31 */
	 u_int8_t dct;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.8 - 12.13 */
	 u_int8_t log_max_ra_res_qp;
	/* Description -  */
	/* 12.24 - 12.29 */
	 u_int8_t log_max_ra_req_qp;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.8 - 16.15 */
	 u_int8_t num_ports;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - log2_uar_page_sz in 4kbyte chunks. 4-64 kbyte supported */
	/* 20.0 - 20.15 */
	 u_int16_t log_uar_page_sz;
	/* Description - sw format = log_gid_table_size-3: 0: 8 gid entries, 1: 16 gid entries, 2: 32 gid entries, 3: 64 gid entries, 4: 128 gid entries, other: reserved */
	/* 20.16 - 20.21 */
	 u_int8_t log_gid_table_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - log2 max size of unicast mac list size */
	/* 24.0 - 24.10 */
	 u_int16_t log_max_mac_uc_lst_sz;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_dummy_addresses_one_cache_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int64_t ix[8];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cmdif_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t done_missions;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.24 */
	 u_int32_t res_num;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t cmd_valid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t opcode;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t op_mod;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t allocated_pages;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t needed_pages;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 union connectib_flush_type flush_type;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - valid only when flush_type qp_flush is set */
	/* 24.0 - 24.23 */
	 u_int32_t flush_qpn;
	/* Description - valid only when flush_type qp_flush is set */
	/* 24.24 - 28.31 */
	 u_int8_t flush_synd;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 union connectib_cmdif_ctx_special s;
};

/* Description -   */
/* Size in bytes - 28 */
union connectib_sw_eqe_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - completion event data format */
	/* 0.0 - 28.31 */
	 struct connectib_sw_eqe_cq_data cq_data;
	/* Description - asynch error event data format */
	/* 0.0 - 28.31 */
	 struct connectib_sw_eqe_error_data error_data;
	/* Description - asynch qp event data format */
	/* 0.0 - 28.31 */
	 struct connectib_sw_eqe_qp_data qp_data;
	/* Description - port change event data format */
	/* 0.0 - 28.31 */
	 struct connectib_port_state_change_event port_change;
	/* Description - page request event data format */
	/* 0.0 - 28.31 */
	 struct connectib_page_request_event page_request;
	/* Description - WQE page fault event data format */
	/* 0.0 - 28.31 */
	 struct connectib_wqe_page_fault_event wqe_page_fault;
	/* Description - RDMA page fault event data format */
	/* 0.0 - 28.31 */
	 struct connectib_rdma_page_fault_event rdma_page_fault;
	/* Description - Table 145 - Event_data Field - Doorbell / Blueflame Congestion Event Layout */
	/* 0.0 - 24.31 */
	 struct connectib_db_bf_congestion_event db_bf_congestion_event;
	/* Description -  */
	/* 0.0 - 28.31 */
	 struct connectib_sw_eqe_flat_data flat_data;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_reg_access_reg_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_reg_access_tlv hdr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 48.31 */
	 union connectib_reg_access_reg_tlv_data reg_tlv_data;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_reg_access_oper_tlv {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Code indicating status of operation */
	/* 0.8 - 0.14 */
	 u_int8_t Status;
	/* Description - Direct route - must be set on direct route packets. DR TLV must follow. */
	/* 0.15 - 0.15 */
	 u_int8_t dr;
	/* Description -  */
	/* 0.16 - 0.26 */
	 u_int16_t len;
	/* Description -  */
	/* 0.27 - 4.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Class of operation */
	/* 4.0 - 4.7 */
	 u_int8_t class_;
	/* Description - Method to perform Based on Management Class */
	/* 4.8 - 4.14 */
	 u_int8_t Method;
	/* Description - Response
0 Request */
	/* 4.15 - 4.15 */
	 u_int8_t r;
	/* Description - Defines objects being operated by a management class (Page 658) */
	/* 4.16 - 8.31 */
	 u_int16_t register_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 struct connectib_IB_TID TID;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_output_inline_standart {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - check the io function before changing this field.
overrun while status and syndrom is writen */
	/* 0.0 - 0.23 */
	 u_int32_t auto_1;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t status;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t syndrome;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t ix;
	/* Description -  */
	/* 8.24 - 12.31 */
	 u_int8_t auto_2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t auto_3;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_input_inline_standart {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - manually added, for reserved equal zero test */
	/* 0.0 - 0.15 */
	 u_int16_t reserved_0;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t opcode;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t opcode_mod;
	/* Description - manually added, for reserved equal zero test */
	/* 4.16 - 8.31 */
	 u_int16_t reserved_1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t ix;
	/* Description - manually added, for reserved equal zero test */
	/* 8.24 - 12.31 */
	 u_int8_t reserved_2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - manually added, for reserved equal zero test */
	/* 12.0 - 16.31 */
	 u_int32_t reserved_3;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_g_rse_decoders_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 u_int32_t dword[64];
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxs_rxt_desc_decoder.v -o rxs_rxt_desc_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 64 */
struct connectib_rxs_rxt_desc_decoder {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.13 */
	 u_int16_t payload_end_offset;
	/* Description -  */
	/* 4.14 - 4.14 */
	 u_int8_t mask_px_icmc_tpt_vld;
	/* Description -  */
	/* 4.15 - 4.15 */
	 u_int8_t need_invalidation;
	/* Description -  */
	/* 4.16 - 4.19 */
	 u_int8_t extended_rdb_size;
	/* Description -  */
	/* 4.20 - 4.22 */
	 u_int8_t max_rdma_atomic;
	/* Description -  */
	/* 4.23 - 4.23 */
	 u_int8_t scatter_grh;
	/* Description -  */
	/* 4.24 - 4.26 */
	 u_int8_t packet_type;
	/* Description -  */
	/* 4.27 - 4.27 */
	 u_int8_t can_use_reserved_lkey;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t use_dcr_gvmi_for_rdb;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 8.16 - 8.29 */
	 u_int16_t packet_len;
	/* Description -  */
	/* 8.30 - 8.30 */
	 u_int8_t free_line;
	/* Description -  */
	/* 8.31 - 12.31 */
	 u_int8_t header_capture;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 12.24 - 16.31 */
	 u_int8_t rdb_write_pointer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.23 */
	 u_int32_t psn;
	/* Description -  */
	/* 16.24 - 20.31 */
	 u_int8_t payload_offset;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.23 */
	 u_int32_t pd;
	/* Description -  */
	/* 20.24 - 24.31 */
	 u_int8_t grh_offset;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t rkey;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t dma_length;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 32.0 - 36.31 */
	 u_int32_t va_63_32;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 36.0 - 40.31 */
	 u_int32_t va_31_0;
};

/* Description -  // Created At Mon Oct  7 12:23:47 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_checks_packet_descriptor_decoder.v -o rxt_checks_packet_descriptor_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 64 */
struct connectib_rxt_checks_packet_descriptor_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.1 */
	 u_int8_t timestamp_version;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t force_loopback;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t functional_loopback;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t inner_crc_ok;
	/* Description -  */
	/* 0.5 - 0.5 */
	 u_int8_t mad_baseversion_error;
	/* Description -  */
	/* 0.6 - 0.6 */
	 u_int8_t mad_classversion_error;
	/* Description -  */
	/* 0.7 - 0.7 */
	 u_int8_t mad_send2host;
	/* Description -  */
	/* 0.8 - 0.8 */
	 u_int8_t outer_crc_ok;
	/* Description -  */
	/* 0.9 - 0.9 */
	 u_int8_t port_error;
	/* Description -  */
	/* 0.10 - 0.10 */
	 u_int8_t sx_sniffer;
	/* Description -  */
	/* 0.11 - 0.11 */
	 u_int8_t timestamp_vld;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t payload_offset;
	/* Description -  */
	/* 4.16 - 4.19 */
	 u_int8_t custom_dw0_vld;
	/* Description -  */
	/* 4.20 - 4.23 */
	 u_int8_t custom_dw1_vld;
	/* Description -  */
	/* 4.24 - 4.27 */
	 u_int8_t custom_dw2_vld;
	/* Description -  */
	/* 4.28 - 8.31 */
	 u_int8_t custom_dw3_vld;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t custom_dw3;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t custom_dw2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t custom_dw1;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t custom_dw0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 24.0 - 24.8 */
	 u_int16_t source_xqpn_40_32;
	/* Description -  */
	/* 24.9 - 24.9 */
	 u_int8_t dummy_packet;
	/* Description - TODO: need to align this field to 8.  */
	/* 24.10 - 24.15 */
	 u_int8_t mad_qp1_class;
	/* Description -  */
	/* 24.16 - 28.31 */
	 u_int16_t packet_end_offset;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 28.0 - 32.31 */
	 u_int32_t source_xqpn_31_0;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 32.0 - 36.31 */
	 u_int32_t timestamp_63_32;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 36.0 - 40.31 */
	 u_int32_t timestamp_31_0;
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_context_fetch_qp_desc_decoder.v -o rxt_context_fetch_qp_desc_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 16 */
struct connectib_rxt_context_fetch_qp_desc_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 0.0 - 0.0 */
	 u_int8_t qpc_ts_3_3;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 4.0 - 4.12 */
	 u_int16_t srq_number_23_11;
	/* Description - TODO: need to align this field to 16.  */
	/* 4.13 - 4.28 */
	 u_int16_t gvmi;
	/* Description - TODO: need to align this field to 4. This Field was broken due to 32-bit miss-alignement  */
	/* 4.29 - 8.31 */
	 u_int8_t qpc_ts_2_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.11 */
	 u_int16_t pkey_index;
	/* Description - TODO: need to align this field to 8.  */
	/* 8.12 - 8.19 */
	 u_int8_t my_gid_index;
	/* Description -  */
	/* 8.20 - 8.20 */
	 u_int8_t srq_vld;
	/* Description - TODO: need to align this field to 32. This Field was broken due to 32-bit miss-alignement  */
	/* 8.21 - 12.31 */
	 u_int16_t srq_number_10_0;
};

/* Description -  // Created At Mon Oct  7 12:23:46 IST 2013, By the following script (revision 1.45): ./decoder2adb.tcl -f /net/mtlfs01/vol/veri2/rev/golan/../../../../../../fwgwork/danielg/shomron/verilog/golan/./rxt_checks_steering_results_decoder.v -o rxt_checks_steering_results_decoder -adbfile ../adabe/golan//hw_decoders_st.adb */
/* Size in bytes - 16 */
struct connectib_rxt_checks_steering_results_decoder {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t vport_packet_counters_trigger;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 4.0 - 4.8 */
	 u_int16_t xqpn_40_32;
	/* Description -  */
	/* 4.9 - 4.9 */
	 u_int8_t pport_counters_trigger_vld;
	/* Description -  */
	/* 4.10 - 4.10 */
	 u_int8_t qpn_direct_access;
	/* Description -  */
	/* 4.11 - 4.11 */
	 u_int8_t vport_counters_trigger_vld;
	/* Description -  */
	/* 4.12 - 4.15 */
	 u_int8_t vport_byte_counters_trigger;
	/* Description -  */
	/* 4.16 - 4.23 */
	 u_int8_t pport_byte_counters_trigger;
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t pport_packet_counters_trigger;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - This Field was broken due to 32-bit miss-alignement  */
	/* 8.0 - 12.31 */
	 u_int32_t xqpn_31_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_ctx_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t dwords[16];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_fw_resource_context {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_fw_eqc fw_eqc;
	/* Description - ads layout */
	/* 0.0 - 48.31 */
	 struct connectib_fw_alt_path fw_alt_path;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_basic_res_ctx fw_basic;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_fw_cre fw_cre;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_fw_mkc fw_mkc;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_fw_psv fw_psv;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_fw_cqc fw_cqc;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_fw_rqt fw_rqt;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_list_element list_element;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_dmfs_resources dmfs_resources;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_dc_control_packet_desc dc_control_packet_desc;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_hw_hca_contexts {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_cqc cqc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_mkc mkc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_toc toc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_srq srq;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_dct dct;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_c_qpc c_qpc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_s_qpc s_qpc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_r_qpc r_qpc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_port_info port_info;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_bsf_entry bsf_entry;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_base_psv base_psv;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hw_trastb trastb;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_trasta trasta;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hw_sq_pointers sq_pointers;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hw_gvmi_tokens gvmi_tokens;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hw_sq_tokens sq_tokens;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_hw_klm_entry klm_entry;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_sxdc sxdc;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_hw_pipa pipa;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_hw_sq_qp_list sq_qp_list;
	/* Description - the timer is 8 bit, here its just a wrapper */
	/* 0.0 - 4.31 */
	 struct connectib_hw_timer_32 timer;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_hw_pkey pkey;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_ste hw_ste;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_steering_entry_icmc steering_entry_icmc;
	/* Description -  */
	/* 0.0 - 8.31 */
	 union connectib_icm_mtt mtt;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_rdb rdb;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hw_msix msix;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_qp_counter qp_counter;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_field_boundary {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t field_boundary;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_add_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t add_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_compare_mask_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t compare_mask_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_swap_mask_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t swap_mask_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_compare_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t compare_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_swap_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t swap_data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_nv_data_pointer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Offset of entire list area from start of NV data area. Every unit is 64 bytes */
	/* 0.0 - 0.15 */
	 u_int16_t offset_in_64_bytes;
	/* Description - Size of entire list area. Every unit is 64 bytes. */
	/* 0.16 - 0.25 */
	 u_int16_t size_in_64_bytes;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_jump_addresses {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t plastic;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_pcie_rx_adaptation_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t actual_ffe_tap_config_num;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t ffe_tap_value_lifting_en;
	/* Description - In case the ffe_tap values are modified manually in scratchpad,
 pushing this button will cause performing calibration for each set. */
	/* 0.31 - 4.31 */
	 u_int8_t redo_calibration;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0: Default setup ffe tap values
1: PLX optimized ffe tap vlaues
 2-7: Default setup ffe tap values - Not used by default */
	/* 4.0 - 68.31 */
	 struct connectib_ffe_tap_set ffe_tap_config[8];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pcie_tx_adaptation_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - enable for tx adaptation at Ph 2. */
	/* 0.0 - 0.3 */
	 u_int8_t tx_adaptation_config_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 16.31 */
	 struct connectib_GEN3_TRANSMITTER_SETTING tx_adaptation_ts_param[3];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_debug_cap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.12 */
	 u_int16_t internal_cause_mask;
	/* Description - Opens PCIe width debug capability (can be used for width degrade debug)
When enabled pxp.port_state will be stoped at each Config.Width state and sample the received TS. */
	/* 0.29 - 0.29 */
	 u_int8_t width_debug_en;
	/* Description - Opens PCIe speed debug capability (can be used for speed degrade debug)

TODO (still not affect FW operation)! */
	/* 0.30 - 0.30 */
	 u_int8_t speed_debug_en;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t internal_cause_en;
};

/* Description -   */
/* Size in bytes - 52 */
struct connectib_pcie_equalization_and_eye {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Mellanox full swing parameter - default is max 63 */
	/* 0.0 - 0.5 */
	 u_int8_t local_fs;
	/* Description - Mellanox full swing parameter - default is max 63 */
	/* 0.8 - 0.12 */
	 u_int8_t local_lf;
	/* Description - preset to be requested at phase 2 */
	/* 0.16 - 0.19 */
	 u_int8_t preset;
	/* Description - set in case we wish to request some preset at phase 2 */
	/* 0.20 - 0.20 */
	 u_int8_t force_preset;
	/* Description - Equalization phase 0 timeout in     msec.
After this timeout (started upon entering to phase 0), and if relevant TS arrived on all lanes we move to phase 1. */
	/* 0.21 - 0.25 */
	 u_int8_t phase0_timeout;
	/* Description - Equalization phase 2 timeout i    n msec.
After this timeout (started upon entering to phase 2) we move to phase 3. */
	/* 0.26 - 0.30 */
	 u_int8_t phase2_timeout;
	/* Description - enables fast (within 1 usec) phase3 FW response during the equalization process */
	/* 0.31 - 4.31 */
	 u_int8_t fast_x1_eql_for_compliance;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 48.31 */
	 u_int32_t gen3_preset[11];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - ffe_tap_offset1 offset used for vertical eye opening */
	/* 48.0 - 48.4 */
	 u_int8_t eye_center_mixer_offset;
	/* Description - enable eye centering on the phase (horizontal). */
	/* 48.5 - 48.5 */
	 u_int8_t eye_center_mix90_en;
	/* Description - enable eye centering on the offset (vertical). */
	/* 48.6 - 48.6 */
	 u_int8_t eye_center_offset_en;
	/* Description - when set perform vertiacal eye centerting before horizntal. When clear perform horizontal eye centering first. */
	/* 48.7 - 48.7 */
	 u_int8_t first_offset_phase_second;
	/* Description - The time (in usec) we wait for error in TS */
	/* 48.8 - 48.15 */
	 u_int8_t phase_err_wait_time;
	/* Description - The time (in usec) we wait since mix90phase set, and till we reset the the TS error counter */
	/* 48.16 - 48.19 */
	 u_int8_t phase_stabilize_time;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_pcie_serdes_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.2 */
	 u_int8_t sdr_preemp;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t sdr_preemp_pre;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t sdr_preemp_post;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t sdr_preemp_main;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.2 */
	 u_int8_t ddr_6_db_preemp;
	/* Description -  */
	/* 4.8 - 4.15 */
	 u_int8_t ddr_6_db_preemp_pre;
	/* Description -  */
	/* 4.16 - 4.23 */
	 u_int8_t ddr_6_db_preemp_post;
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t ddr_6_db_preemp_main;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.2 */
	 u_int8_t ddr_3_dot_5_db_preemp;
	/* Description -  */
	/* 8.8 - 8.15 */
	 u_int8_t ddr_3_dot_5_db_preemp_pre;
	/* Description -  */
	/* 8.16 - 8.23 */
	 u_int8_t ddr_3_dot_5_db_preemp_post;
	/* Description -  */
	/* 8.24 - 12.31 */
	 u_int8_t ddr_3_dot_5_db_preemp_main;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_GEN3_TRANSMITTER_SETTING gen3_def_tx_preset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.7 */
	 u_int8_t slicer_ind_en;
	/* Description -  */
	/* 16.8 - 16.11 */
	 u_int8_t slicer1_enable;
	/* Description -  */
	/* 16.12 - 16.15 */
	 u_int8_t slicer2_enable;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.6 */
	 u_int8_t signal_detect_threshold;
	/* Description - If set, signal detect will be enabled by setting rx_power_mode = 0, and its threshold will be according INI.
Else, rx_power_mode = 1 */
	/* 20.7 - 20.7 */
	 u_int8_t signal_detect_en;
	/* Description -  */
	/* 20.8 - 20.11 */
	 u_int8_t ob_bias;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 32.31 */
	 struct connectib_ffe_tap_set default_ffe_tap_set;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_gpio_configurations {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.24 - 48.23 */
	 struct connectib_gpio_config gpio[48];
};

/* Description -   */
/* Size in bytes - 84 */
struct connectib_gpio_functions {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 struct connectib_gpio_function physical_led_p1;
	/* Description -  */
	/* 0.8 - 0.15 */
	 struct connectib_gpio_function physical_led_p2;
	/* Description -  */
	/* 0.16 - 0.23 */
	 struct connectib_gpio_function logical_led_p1;
	/* Description -  */
	/* 0.24 - 4.31 */
	 struct connectib_gpio_function logical_led_p2;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 struct connectib_gpio_function gp_lv;
	/* Description -  */
	/* 4.8 - 4.15 */
	 struct connectib_gpio_function int_p1_l;
	/* Description -  */
	/* 4.16 - 4.23 */
	 struct connectib_gpio_function int_p2_l;
	/* Description -  */
	/* 4.24 - 8.31 */
	 struct connectib_gpio_function modprs_p1_l;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.7 */
	 struct connectib_gpio_function modprs_p2_l;
	/* Description -  */
	/* 8.8 - 8.15 */
	 struct connectib_gpio_function modsel_p1_l;
	/* Description -  */
	/* 8.16 - 8.23 */
	 struct connectib_gpio_function modsel_p2_l;
	/* Description -  */
	/* 8.24 - 12.31 */
	 struct connectib_gpio_function ncsi_arb_in;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 struct connectib_gpio_function ncsi_arb_out;
	/* Description -  */
	/* 12.8 - 12.15 */
	 struct connectib_gpio_function ncsi_crs_dv;
	/* Description -  */
	/* 12.16 - 12.23 */
	 struct connectib_gpio_function ncsi_rxd0;
	/* Description -  */
	/* 12.24 - 16.31 */
	 struct connectib_gpio_function ncsi_rxd1;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.7 */
	 struct connectib_gpio_function ncsi_txd0;
	/* Description -  */
	/* 16.8 - 16.15 */
	 struct connectib_gpio_function ncsi_txd1;
	/* Description -  */
	/* 16.16 - 16.23 */
	 struct connectib_gpio_function ncsi_ref_clk;
	/* Description -  */
	/* 16.24 - 20.31 */
	 struct connectib_gpio_function ncsi_tx_en;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.7 */
	 struct connectib_gpio_function oc_int_l;
	/* Description -  */
	/* 20.8 - 20.15 */
	 struct connectib_gpio_function ovt_wrng;
	/* Description -  */
	/* 20.16 - 20.23 */
	 struct connectib_gpio_function ovt_shtdn;
	/* Description -  */
	/* 20.24 - 24.31 */
	 struct connectib_gpio_function pe_rst_l;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.7 */
	 struct connectib_gpio_function gpio_func_reserved;
	/* Description -  */
	/* 24.8 - 24.15 */
	 struct connectib_gpio_function reset_p1_l;
	/* Description -  */
	/* 24.16 - 24.23 */
	 struct connectib_gpio_function reset_p2_l;
	/* Description -  */
	/* 24.24 - 28.31 */
	 struct connectib_gpio_function spi_clk;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.7 */
	 struct connectib_gpio_function spi_cs0_l;
	/* Description -  */
	/* 28.8 - 28.15 */
	 struct connectib_gpio_function spi_cs1_l;
	/* Description -  */
	/* 28.16 - 28.23 */
	 struct connectib_gpio_function spi_io0;
	/* Description -  */
	/* 28.24 - 32.31 */
	 struct connectib_gpio_function spi_io1;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.7 */
	 struct connectib_gpio_function spi_io2;
	/* Description -  */
	/* 32.8 - 32.15 */
	 struct connectib_gpio_function spi_io3;
	/* Description -  */
	/* 32.16 - 32.23 */
	 struct connectib_gpio_function i2c_scl1;
	/* Description -  */
	/* 32.24 - 36.31 */
	 struct connectib_gpio_function i2c_scl2;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 36.7 */
	 struct connectib_gpio_function i2c_scl3;
	/* Description -  */
	/* 36.8 - 36.15 */
	 struct connectib_gpio_function i2c_sda1;
	/* Description -  */
	/* 36.16 - 36.23 */
	 struct connectib_gpio_function i2c_sda2;
	/* Description -  */
	/* 36.24 - 40.31 */
	 struct connectib_gpio_function i2c_sda3;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 40.7 */
	 struct connectib_gpio_function i2c_int_l;
	/* Description -  */
	/* 40.8 - 40.15 */
	 struct connectib_gpio_function i2c_rst_l;
	/* Description -  */
	/* 40.16 - 40.23 */
	 struct connectib_gpio_function vdd_mod;
	/* Description -  */
	/* 40.24 - 44.31 */
	 struct connectib_gpio_function wake_l;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 44.7 */
	 struct connectib_gpio_function ibm_mezz_fault_l;
	/* Description -  */
	/* 44.8 - 44.15 */
	 struct connectib_gpio_function ibm_ite_all_pgood;
	/* Description -  */
	/* 44.16 - 44.23 */
	 struct connectib_gpio_function ibm_t_control_l;
	/* Description -  */
	/* 44.24 - 48.31 */
	 struct connectib_gpio_function ibm_t_warning_l;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 48.7 */
	 struct connectib_gpio_function ibm_t_critical_l;
	/* Description -  */
	/* 48.8 - 48.15 */
	 struct connectib_gpio_function ibm_cib_slot_id_0;
	/* Description -  */
	/* 48.16 - 48.23 */
	 struct connectib_gpio_function ibm_cib_slot_id_1;
	/* Description -  */
	/* 48.24 - 52.31 */
	 struct connectib_gpio_function ibm_vpd_update_l;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 52.7 */
	 struct connectib_gpio_function ibm_vpd_cache_comp;
	/* Description -  */
	/* 52.8 - 52.15 */
	 struct connectib_gpio_function ibm_vpd_ctrl;
	/* Description -  */
	/* 52.16 - 52.23 */
	 struct connectib_gpio_function gpio_port_swap;
	/* Description -  */
	/* 52.24 - 56.31 */
	 struct connectib_gpio_function gpio_func_reserved_1;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_i2c_device_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - I2C slave address of device */
	/* 0.0 - 0.6 */
	 u_int8_t slave_addr;
	/* Description - I2C bus number of device */
	/* 0.8 - 0.9 */
	 u_int8_t bus_id;
	/* Description - I2C addr size of device */
	/* 0.16 - 0.18 */
	 u_int8_t addr_size;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_module_config_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - 1.5W
1 - 2W
2 - 2.5W
3 - 3.5W */
	/* 0.0 - 0.1 */
	 u_int8_t module_power_level_supported;
	/* Description - 0.1W granularity */
	/* 0.2 - 0.7 */
	 u_int8_t module_mlnx_sub_power_supported;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_iopx_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t ref_clk_right_left_;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_iopl_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t ref_clk_right_left_;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t dynamic_pll_manage_en;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t dynamic_serdes_manage_en;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_port_mlpn_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - mlpn ability bits */
	/* 0.0 - 4.31 */
	 struct connectib_mlpn_database_all_protocol_ini mlpn_supported;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - mlpn request bits */
	/* 4.0 - 8.31 */
	 struct connectib_mlpn_database_all_protocol_ini mlpn_request;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - mlpn mlnx_enhanced_equalization_info bits */
	/* 8.0 - 12.31 */
	 struct connectib_mlpn_enhanced_database_ini mlpn_enhanced_database;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_pll_params {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t pll_fctrl_th;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t enable_phy_varactor_calibration;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 20.31 */
	 u_int32_t pll_fctrl_var[4];
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 36.31 */
	 u_int32_t pll_fctrl_val[4];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_logic_serdes_mapping_node_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_tx_rx_logic_serdes_mapping_node_ini tx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_tx_rx_logic_serdes_mapping_node_ini rx;
};

/* Description -   */
/* Size in bytes - 1472 */
struct connectib_phy_hw_main_config_ip {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_PORT_PHY_ini port[2];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 128.31 */
	 struct connectib_ib_ini_ini ib;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 152.31 */
	 struct connectib_rx_adapt_ini rx_adapt_ini;
/*---------------- DWORD[40] (Offset 0xa0) ----------------*/
	/* Description -  */
	/* 160.0 - 1248.31 */
	 struct connectib_serdes_conf_ini serdes_conf;
};

/* Description -   */
/* Size in bytes - 40 */
struct connectib_nv_config_boot_global {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_nv_config_pci pci;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 40.31 */
	 struct connectib_nv_config_tpt tpt;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_pciex_ext_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 44.31 */
	 struct connectib_secondary_pciex_ext_cap secondary_pciex_ext_cap;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - Alternative Routing ID cap */
	/* 44.0 - 52.31 */
	 struct connectib_ari_cap ari;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - Single Root IO virtualization capability */
	/* 52.0 - 116.31 */
	 struct connectib_sriov_cap sriov;
/*---------------- DWORD[29] (Offset 0x74) ----------------*/
	/* Description - Device serial number capability */
	/* 116.0 - 128.31 */
	 struct connectib_dev_serial_num_cap device_serial_number;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 184.31 */
	 struct connectib_advanced_error_reporting advanced_error_reporting;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_pci_cfg_space {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_pci_cfg_hdr cfg_hdr;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - Power Management Capability */
	/* 64.0 - 72.31 */
	 struct connectib_pci_power_management_cap power_management;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - VPD Capability */
	/* 72.0 - 80.31 */
	 struct connectib_vpd_cap vpd;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - image status - if not 0 then indicates the cause for going to livefish */
	/* 80.0 - 84.31 */
	 u_int32_t image_status;
/*---------------- DWORD[22] (Offset 0x58) ----------------*/
	/* Description - The address for crspace access */
	/* 88.0 - 92.31 */
	 u_int32_t cr_addr;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - The data for crspace access */
	/* 92.0 - 96.31 */
	 u_int32_t cr_data;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - PCIe capability block */
	/* 96.0 - 156.31 */
	 struct connectib_pciex_cap_block pciex_cap_block;
/*---------------- DWORD[39] (Offset 0x9c) ----------------*/
	/* Description - PCIe MSIX capability block */
	/* 156.0 - 168.31 */
	 struct connectib_msix_cap msix;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_nv_config_main_fw_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_port_settings port[2];
};

/* Description -   */
/* Size in bytes - 384 */
struct connectib_phy_fw_main_config_ip {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t PlaceHolder;
};

/* Description -   */
/* Size in bytes - 232 */
struct connectib_phy_fw_main_config_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_phy_lcl_ini lcl[2];
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_ibm_thermal_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t thermal_threshold_tcontrol;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t thermal_threshold_tcontrol_low;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t thermal_threshold_twarning;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t thermal_threshold_twarning_low;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t thermal_threshold_tcritical;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t thermal_threshold_tcritical_low;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_ocsd_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t internal_caution_threshold;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t extrenal_caution_threshold;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t internal_max_cont_threshold;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t external_max_cont_threshold;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_extended_port_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t link_speed_supported;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t link_speed_enabled;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t llr_64_byte_cell_size;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t llr_128_byte_cell_size;
	/* Description -  */
	/* 0.18 - 0.18 */
	 u_int8_t link_up_after_boot;
};

/* Description -   */
/* Size in bytes - 28 */
struct connectib_ib_port_info_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Additional supported capabilities of this port. Valid only if IsCapabilityMask2Supported bit is set in CapabilityMask. A bit set to 1 indicates affirmation of supported capability. 0: IsSetNodeDescriptionSupportede 1: IsPortInfoExtendedSupported 2-15: Reserved */
	/* 0.0 - 0.15 */
	 u_int16_t cap_mask2;
	/* Description - Diagnostic code, as described in 14.2.5.6.1 Interpretation of DiagCode on page 889. */
	/* 0.16 - 4.31 */
	 u_int16_t diag_code;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Optional; shall be 0 if not implemented (PortInfo:CapabilityMask.IsLinkRoundTripLatency-Supported = 0). This value represents a measurement of the round-trip latency of the link attached to this port. It is an unsigned 24-bit integer counting 4 nsec. intervals. This value might not be accurate to better than +/- 4 nsec. A value of 0 is valid when implemented, and indicates a latency of up to 4 nsec. LinkRoundTripLatency is reset to 0xFFFFFF whenever this port transitions to PortState = Down. Each time a link heartbeat reply (ACK) is received on this port when PortState is not Down, this value is set to the minimum of (a) the prior value of this attribute; and (b) the time elapsed since the corresponding heartbeat (SND) was sent. Note that while the value of this component will never increase, it may change over time due to varying queueing delays associated with traffic load. Note that this component is always 0 for Enhanced SP 0. See InfiniBand Architecture Volume 2, Link/Phy Interface chapter. */
	/* 4.0 - 4.23 */
	 u_int32_t link_roundtrip_lat;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Optional; shall be 0 if not implemented (PortInfo:CapabilityMask.IsLinkRoundTripLatency-Supported = 0). This value provides a vendordependent indication of the maximum number of credits available per VL on the Port. */
	/* 8.0 - 8.15 */
	 u_int16_t max_credit_hint;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 union connectib_port_cap_mask1 cap_mask;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.7 */
	 u_int8_t link_width_sup;
	/* Description - Enabled link width, indicated as follows: 0: No State Change valid only on Set(); 1: 1x 2: 4x; 3: 1x or 4x; 4: 8x; 5: 1x or 8x; 6: 4x or 8x; 7: 1x or 4x or 8x; 8: 12x; 9: 1x or 12x; 10: 4x or 12x; 11: 1x or 4x or 12x; 12: 8x or 12x; 13: 1x or 8x or 12x; 14: 4x or 8x or 12x; 15: 1x or 4x or 8x or 12x; 16 - 254: Reserved; 255: Set to LinkWidthSupported value; response; contains actual LinkWidthSupported.;Changes to this component do not take effect immediately. See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 16.8 - 16.15 */
	 u_int8_t link_width_ena;
	/* Description - Enabled link speed, indicated as follows: 0: No State Change; valid only on Set(); 1: 2.5 Gbps (also when SMSupportsExtended-Speeds is set to 0 on set, disable any extended speeds); 3: 2.5 or 5.0 Gbps (also when SMSupportsExtendedSpeeds is set to 0 on set, disable any extended speeds); 5: 2.5 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 7: 2.5 or 5.0 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 2, 4, 6, 8-14 Reserved; 15: Set to LinkSpeedSupported value; response contains actual LinkSpeedSupported. In addition to the LinkSpeedSupported value, when SMSupportsExtendedSpeeds is set to 0 in request/response AM, response contains QDR indication if an extended speed is enabled.; Note: See 14.3.14 SMSupportsExtendedLink-Speeds on page 932 for more information on SMSupportsExtendedSpeeds.; Changes to this component do not take effect immediately. See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 16.16 - 16.19 */
	 u_int8_t link_speed_ena;
	/* Description - 0: No state change; valid only on Set(); 1: Sleep; 2: Polling; 3 - 15: Reserved; See InfiniBand Architecture Specification Volume 2, Link/Phy Interface chapter. */
	/* 16.20 - 16.23 */
	 u_int8_t down_def_state;
	/* Description - Supported link speed, indicated as follows: 1: 2.5 Gbps; 3: 2.5 or 5.0 Gbps; 5: 2.5 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 7: 2.5 or 5.0 or 10.0 Gbps (or higher when SMSupportsExtendedSpeeds is set to 0 in request/response AM); 0, 2, 4, 6, 8-15: Reserved; Note: See 14.3.14 SMSupportsExtendedLink-Speeds on page 932 for more information on SMSupportsExtendedSpeeds. */
	/* 16.24 - 16.27 */
	 u_int8_t link_speed_sup;
	/* Description - Optional; shall be 0 if not implemented. Type of initialization requested by this port before SM moves it to Active or Armed state. See 14.4.4 Node Reinitialization on page 947.;/  bit 0: NoLoad. 0 = Port is requesting that its attributes be initialized (see 14.4.3 Initialization Actions on page 943). 1 = Port is requesting that no data be loaded into its attributes at all, asserting that the last-loaded data still exists and is valid.;/  bit 1: PreserveContent. 0 = Port makes no request regarding content of the data that is loaded into its attributes. 1 = Port is requesting that all such data, if loaded, be set to the most recent content loaded by the SM.;/ bit 2: PreservePresence. 0 = Port is requesting that all settable SA attributes referencing this port (see Table 209 Subnet Administration Attribute / Method Map on page 968) be removed prior to activating this port and Report()s of in/out of service (trap numbers 64/65) be sent. 1 = Port is requesting that all such data be preserved, and Report()s of in/out of service (trap numbers 64/65) not be sent for this port.;/ bit 3: DoNotResuscitate. 0 = bits 0, 1, and 2 of this field are valid; initialization of this port should begin based on their values. 1 = bits 0, 1, and 2 are not valid; port is requesting that reinitialization of this port, and any Report()s of in/out of service (trap numbers 64/65) be delayed until this bit is set to 0. */
	/* 16.28 - 20.31 */
	 u_int8_t init_type;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - VL/Weight pairs supported on this port in the VLArbitration table for high priority. Shall be 1 to 64 if more than one data VL is supported on this port, 0 otherwise. See 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 20.0 - 20.7 */
	 u_int8_t vl_arb_high_cap;
	/* Description - Limit of High Priority component of VL Arbitration Table, as defined in 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 20.8 - 20.15 */
	 u_int8_t vl_high_limit;
	/* Description - Virtual Lanes supported on this port, indicated as follows: 1: VL0; 2: VL0, VL1; 3: VL0 - VL3; 4: VL0 - VL7; 5: VL0 - VL14; 0, 6 - 15: reserved */
	/* 20.16 - 20.19 */
	 u_int8_t vl_cap;
	/* Description - VL/Weight pairs supported on this port in the VLArbitration table for high priority. Shall be 1 to 64 if more than one data VL is supported on this port, 0 otherwise. See 7.6.9 VL Arbitration and Prioritization on page 200. */
	/* 20.20 - 20.27 */
	 u_int8_t vl_arb_low_cap;
	/* Description - Virtual Lanes operational on this port, indicated as follows: 0: No change; valid only on Set();/ 1: VL0;/ 2: VL0, VL1;/ 3: VL0 - VL3;/ 4: VL0 - VL7;/ 5: VL0 - VL14;/ 6 - 15: reserved;/ Changing OperationalVLs in certain PortStates may cause flow control update errors which may initiate Link/Phy retraining. */
	/* 20.28 - 24.31 */
	 u_int8_t operational_vl;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Virtual Lanes operational on this port, indicated as follows: 0: No change; valid only on Set();/ 1: VL0;/ 2: VL0, VL1;/ 3: VL0 - VL3;/ 4: VL0 - VL7;/ 5: VL0 - VL14;/ 6 - 15: reserved;/ Changing OperationalVLs in certain PortStates may cause flow control update errors which may initiate Link/Phy retraining. */
	/* 24.0 - 24.3 */
	 u_int8_t neighbor_mtu;
	/* Description - Maximum MTU supported by this port.;/ 1: 256 ;/ 2: 512;/ 3: 1024;/ 4: 2048;/ 5: 4096;/ 0, 6 - 15: reserved */
	/* 24.4 - 24.7 */
	 u_int8_t mtu_cap;
	/* Description - Multicast PKey Trap Suppression Enable */
	/* 24.8 - 24.9 */
	 u_int8_t mc_pkey_trap_suppress_en;
	/* Description - Number of GUID entries supported in the GUIDInfo attribute for this port. */
	/* 24.10 - 24.17 */
	 u_int8_t guid_cap;
	/* Description - Specifies the expected maximum time between the port reception of a SMP and the transmission of the associated response. The duration of time is calculated based on (4.096 usec * 2^RespTimeValue). */
	/* 24.18 - 24.22 */
	 u_int8_t resp_time_value;
	/* Description - 0: No State Change; valid only on Set(); 1: 14.0625 Gbps (FDR); 2: 25.78125 Gbps (EDR); 3: 14.0625 Gbps (FDR) or 25.78125 Gbps (EDR); 4-29: Reserved; 30: Disable extended link speeds/Extended link speeds disabled; 31: Set to LinkSpeedExtSupported value; response contains actual LinkSpeedExtSupported; */
	/* 24.23 - 24.27 */
	 u_int8_t link_speed_ext_ena;
	/* Description - 0: Reserved; 1: 14.0625 Gbps (FDR); 2: 25.78125 Gbps (EDR); 3: 14.0625 Gbps (FDR) or 25.78125 Gbps (EDR); 4-15: Reserved */
	/* 24.28 - 28.31 */
	 u_int8_t link_speed_ext_sup;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_node_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t num_of_ports;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t node_type;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t class_version;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t base_version;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t system_image_guid_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t system_image_guid_lo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t node_guid_hi;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t node_guid_lo;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t port_guid_hi;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t port_guid_lo;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.15 */
	 u_int16_t device_id;
	/* Description -  */
	/* 28.16 - 32.31 */
	 u_int16_t partition_cap;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 u_int32_t revision;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 36.23 */
	 u_int32_t vendor_id;
	/* Description -  */
	/* 36.24 - 40.31 */
	 u_int8_t local_port_num;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_led_port_blink_pattern {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t phy_pattern;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t log_pattern;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t length;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_uid_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Number of allocated UIDs in this entry */
	/* 0.0 - 0.7 */
	 u_int8_t num_allocated;
	/* Description - Step size by which to derive the UIDs for this entry
See struct description */
	/* 0.8 - 0.15 */
	 u_int8_t step;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - For MACs, the upper 16 bits in the 'hi' dword are reserved */
	/* 8.0 - 16.31 */
	 u_int64_t uid;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_module_version {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t branch;
	/* Description -  */
	/* 0.8 - 0.19 */
	 u_int16_t minor;
	/* Description -  */
	/* 0.20 - 4.31 */
	 u_int16_t major;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_reset_level_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_reset_version ver;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t ini_sig;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 2^0-full ISFU, 2^1-management+link up ISFU 2^2-only PCIe ISFU 2^3-PCI disable/enable, 2^7-power_up */
	/* 8.0 - 8.7 */
	 u_int8_t reset_type;
	/* Description -  */
	/* 8.8 - 8.8 */
	 u_int8_t ini_sig_v;
	/* Description -  */
	/* 8.9 - 8.9 */
	 u_int8_t ini_sig_ignore;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_vport_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB + ROCE */
	/* 0.0 - 8.31 */
	 u_int64_t port_guid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - IB + ROCE */
	/* 8.0 - 16.31 */
	 u_int64_t node_guid;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 struct connectib_mac_address_layout permanent_address;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.15 */
	 u_int16_t cap_mask;
	/* Description -  */
	/* 24.16 - 24.27 */
	 u_int16_t allowed_list_size;
	/* Description -  */
	/* 24.31 - 28.31 */
	 u_int8_t roce_en;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.15 */
	 u_int16_t p_key_violations;
	/* Description - IB + ROCE */
	/* 28.16 - 32.31 */
	 u_int16_t q_key_violations;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_vport_shadow {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IB + ROCE */
	/* 0.0 - 8.31 */
	 u_int64_t port_guid;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - IB + ROCE */
	/* 8.0 - 16.31 */
	 u_int64_t node_guid;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 struct connectib_mac_address_layout permanent_address;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_general_fault_injector_pair {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - in config: must be bigger then 1 */
	/* 0.0 - 0.15 */
	 u_int16_t freq;
	/* Description - the error will be hooks_duration of times in sequence */
	/* 0.16 - 4.31 */
	 u_int16_t duration;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_pvlc_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Local port number */
	/* 0.16 - 0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Virtual Lanes supported on this port.
0 - Reserved
1: VL0
2: VL0, VL1
3: VL0 - VL2
4: VL0 - VL3
5: VL0 - VL4
6: VL0 - VL5
7: VL0 - VL6
8: VL0 - VL7
15: VL0 - VL14 */
	/* 4.0 - 4.3 */
	 u_int8_t vl_hw_cap;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Virtual Lanes enabled by the local admin on this port.
0: No change; valid only on Set()
1: VL0
2: VL0, VL1
3: VL0 - VL2
4: VL0 - VL3
5: VL0 - VL4
6: VL0 - VL5
7: VL0 - VL6
8: VL0 - VL7
15: VL0 - VL14 */
	/* 8.0 - 8.3 */
	 u_int8_t vl_admin;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Operational VLs as configured by the SM on this port:
0: No change; valid only on Set()
1: VL0
2: VL0, VL1
3: VL0 - VL2 
4: VL0 - VL3
5: VL0 - VL4
6: VL0 - VL5
7: VL0 - VL6
8: VL0 - VL7
15: VL0 - VL14
Changing 
vl_operational
 in certain PortStates may cause in flow control 
update errors which may initiate Link/PHY retraining. */
	/* 12.0 - 12.3 */
	 u_int8_t vl_operational;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_get_ste_resources_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t resources_count;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 256.31 */
	 struct connectib_resource_type_entry resource_type[63];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ste_resources_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_ste_open_resources_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - there are more open resources, please query again with the next start index */
	/* 0.0 - 0.0 */
	 u_int8_t more;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - number of valid entries in open resources table */
	/* 4.0 - 8.31 */
	 u_int32_t output_size;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 520.31 */
	 struct connectib_index_and_length opened_resource[32];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ste_open_resources_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t icm_resource_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t start_index;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_fte_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t action;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t valid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t group_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t flow_tag;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t destination_list_size;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 128.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 outer_headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 192.31 */
	 struct connectib_flow_table_entry_match_set_misc misc_parameters;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 192.0 - 256.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 inner_headers;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 768.31 */
	 struct connectib_dest_format_struct destination[64];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t flow_index;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t requested_fte_partition;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t first;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t flow_index;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fte_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FTE and ignore flow_index
1: Request the next FTE following the one pointed by flow_index */
	/* 0.29 - 4.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t flow_index;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_get_fg_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t start_flow_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t end_flow_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.7 */
	 u_int8_t match_criteria_enable;
	/* Description -  */
	/* 8.31 - 12.31 */
	 u_int8_t valid;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 128.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 outer_headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 192.31 */
	 struct connectib_flow_table_entry_match_set_misc misc_parameters;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 192.0 - 256.31 */
	 struct connectib_flow_table_entry_match_set_lyr_2_4 inner_headers;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t first;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_fg_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FG and ignore group_ID
1: Request the next FG following the one pointed by Group_ID */
	/* 0.29 - 4.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t group_id;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_info_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t log_size;
	/* Description -  */
	/* 0.8 - 0.15 */
	 u_int8_t level;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t table_type;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t valid;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_info_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_list_out {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
	/* Description -  */
	/* 0.28 - 0.28 */
	 u_int8_t valid;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t last;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t first;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_ft_list_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t table_id;
	/* Description - 0: Request the first FT and ignore Table_ID
1: Request  the next FT following the one pointed by Table_ID */
	/* 0.29 - 4.31 */
	 u_int8_t info;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_ppcnt_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Performance counter group.
Group 63 indicates all groups. Only valid on Set() operation with 
clr
 bit set.
0x0: IEEE 802.3 Counters
0x1: RFC 2863 Counters
0x2: RFC 2819 Counters
0x3: RFC 3635 Counters
0x5: Ethernet Extended Counters
0x10: Per Priority Counters
0x11: Per Traffic Class Counters */
	/* 0.0 - 0.5 */
	 u_int8_t grp;
	/* Description - Port number access type:
0 - Local port number
1 - IB port number */
	/* 0.14 - 0.15 */
	 u_int8_t pnat;
	/* Description - Local port number. 
255 indicates all ports on the device, and is only allowed for Set() operation. */
	/* 0.16 - 0.23 */
	 u_int8_t local_port;
	/* Description - For HCA
:
 must be always 0.
Switch partition ID to associate port with.
Switch partitions are numbered from 0 to 7 inclusively.
Switch partition 254 indicates stacking ports.
Switch partition 255 indicates all switch partitions.
Only valid on Set() operation with local_port=255. */
	/* 0.24 - 4.31 */
	 u_int8_t swid;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Priority for counter set that support per priority. Traffic class for counter set 
the support per traffic class. Otherwise must be 0. */
	/* 4.0 - 4.4 */
	 u_int8_t prio_tc;
	/* Description - Clear counters. Setting the 
clr
 bit will reset the counter value for all counters 
in the counter group. This bit can be set for both Set() and Get() operation. */
	/* 4.31 - 8.31 */
	 u_int8_t clr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Counter set as described in:
 See Table 244, "
Ethernet IEEE 802.3 Counters Group Data Layout
," on 
page 397
 See Table 246, "
Ethernet RFC 2863 Counter Group Data Layout
," on 
page 400
 See Table 248, "
Ethernet RFC 2819 Coun
t
er Group Data Layout
," on 
page 402
 See Table 250, "
Ethernet RFC 3635 Counter Group Data Layout
," on 
page 405
 See Table 252, "
Ethernet Extended Counter Group Data Layout
," on 
page 408
 See Table 254, "
Ethernet Per Priority Group Data Layout
," on page 409
 See Table 256, "
Ethernet Per Traffic Cla
s
s Group data layout
," on page 411 */
	/* 8.0 - 256.31 */
	 union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto counter_set;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_ptys_reg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Protocol Mask. Indicates which of the protocol data is valid
Bit 0: InfiniBand
Bit 2: Ethernet */
	/* 0.0 - 0.2 */
	 u_int8_t proto_mask;
	/* Description - Local port number */
	/* 0.16 - 0.23 */
	 u_int8_t local_port;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Ethernet port speed/protocols supported (bitmask)
Bit 22 -100GBase KR4
Bit 21 -100GBase SR4
Bit 20 -100GBase CR4
Bit 16 - 40GBase LR4/ER4
Bit 15 - 40GBase SR4
Bit 14 - 10GBase ER/LR
Bit 13 - 10GBase SR
Bit 12 - 10GBase CR
Bit 7 - 40GBase KR4
Bit 6 - 40GBase CR4
Bit 4 - 10GBase KR
Bit 3 - 10GBase KX4
Bit 2 - 10GBase-CX4
Bit 1 - 1000Base KX
Bit 0 - SGMII */
	/* 12.0 - 16.31 */
	 u_int32_t eth_proto_capability;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - InfiniBand port speed supported (bitmask)
ib_link_speed <= ib_proto_capability[7:0]
Bit 0 - SDR
Bit 1 - DDR
Bit 2 - QDR
Bit 3 - FDR10
Bit 4 - FDR
Bit 5 - EDR */
	/* 16.0 - 16.15 */
	 u_int16_t ib_proto_capability;
	/* Description - ib_link_width <= ib_proto_capability
Bit 0 - 1x
Bit 1 - 2x
Bit 2 - 4x */
	/* 16.16 - 20.31 */
	 u_int16_t ib_link_width_capability;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - Ethernet port speed/protocols bitmask */
	/* 24.0 - 28.31 */
	 u_int32_t eth_proto_admin;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - InfiniBand port speed bitmask */
	/* 28.0 - 28.15 */
	 u_int16_t ib_proto_admin;
	/* Description - InfiniBand port link width bitmask */
	/* 28.16 - 32.31 */
	 u_int16_t ib_link_width_admin;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Ethernet port speed/protocols bitmask */
	/* 36.0 - 40.31 */
	 u_int32_t eth_proto_oper;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - InfiniBand port speed bitmask */
	/* 40.0 - 40.15 */
	 u_int16_t ib_proto_oper;
	/* Description - InfiniBand port link width bitmask */
	/* 40.16 - 44.31 */
	 u_int16_t ib_link_width_oper;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - Ethernet port speed/protocols bitmask */
	/* 48.0 - 52.31 */
	 u_int32_t eth_proto_lp_advertise;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_steering_table_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - base index of table */
	/* 0.0 - 8.31 */
	 u_int64_t base_index;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - table lookup type */
	/* 8.0 - 8.7 */
	 u_int8_t ste_lu_type;
	/* Description -  */
	/* 8.8 - 8.15 */
	 u_int8_t log2_table_size;
	/* Description -  */
	/* 8.16 - 8.23 */
	 u_int8_t log2_entry_size;
	/* Description - while searching ste in table:
0 - do match only on data + mask
1 - do match only on data
2 - do full match on whole ste */
	/* 8.24 - 8.27 */
	 u_int8_t match_mode;
	/* Description -  */
	/* 8.31 - 12.31 */
	 u_int8_t sx_rx_;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 u_int8_t hash_fieldwise_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_dcr_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t next_dcri;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t valid;
	/* Description -  */
	/* 0.25 - 0.25 */
	 u_int8_t connected;
	/* Description -  */
	/* 0.26 - 0.26 */
	 u_int8_t trapped;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_frequency {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .yu.bootrecord.core_f */
	/* 0.0 - 0.6 */
	 u_int8_t core_f;
	/* Description - .scratchpad.kernel.shared_kernel.core_clocks_per_usec */
	/* 0.7 - 0.7 */
	 u_int8_t core_clocks_per_usec;
	/* Description - .yu.bootrecord.core_r */
	/* 0.8 - 0.12 */
	 u_int8_t core_r;
	/* Description - .px.pxdp.pxp.cx3_count_in_core_clocks */
	/* 0.13 - 0.13 */
	 u_int8_t cx3_count_in_core_clocks;
	/* Description - .scratchpad.kernel.shared_kernel.usecs_in_high_tick */
	/* 0.14 - 0.14 */
	 u_int8_t usecs_in_high_tick;
	/* Description - .scratchpad.ini.hw_main_config.gpios.functions.vdd_mod.mapping */
	/* 0.15 - 0.15 */
	 u_int8_t vdd_mod_mapping;
	/* Description - .yu.bootrecord.flash_div */
	/* 0.16 - 0.19 */
	 u_int8_t flash_div;
	/* Description - .yu.bootrecord.core_od */
	/* 0.20 - 0.21 */
	 u_int8_t core_od;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_cables {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.identifier */
	/* 0.0 - 0.7 */
	 u_int8_t identifier;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.extended_identifier */
	/* 0.8 - 0.15 */
	 u_int8_t extended_identifier;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.device_tech */
	/* 0.16 - 0.23 */
	 u_int8_t device_tech;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.qsfp.attenuation_5g */
	/* 0.24 - 4.31 */
	 u_int8_t attenuation_5g;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].vendor_oui */
	/* 4.0 - 4.23 */
	 u_int32_t vendor_oui;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].m_fsm_state */
	/* 4.24 - 4.29 */
	 u_int8_t m_fsm_state;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].mlnx_cable */
	/* 4.30 - 4.30 */
	 u_int8_t mlnx_cable;
	/* Description - .scratchpad.peripherals.module_mng.module_database[NUM].eeprom_present */
	/* 4.31 - 8.31 */
	 u_int8_t eeprom_present;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.link_length_supported */
	/* 8.0 - 8.7 */
	 u_int8_t link_length_supported;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.eth_com_codes */
	/* 8.8 - 8.15 */
	 u_int8_t eth_com_codes;
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.tech */
	/* 8.16 - 8.24 */
	 u_int16_t tech;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - .scratchpad.phy_manager.port[NUM].port_cfg.module_params.sfp.ib_10ge_com_codes */
	/* 12.0 - 12.6 */
	 u_int8_t ib_10ge_com_codes;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_pcie_ver_device {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - .yu.boot.devid.devid */
	/* 0.0 - 0.15 */
	 u_int16_t devid;
	/* Description - .yu.boot.devid.revid */
	/* 0.16 - 0.19 */
	 u_int8_t revid;
	/* Description - .yu.boot.reset.strap_eprom_present */
	/* 0.20 - 0.20 */
	 u_int8_t strap_eprom_present;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_code_coverage_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Window start address [Byte] is code address */
	/* 0.0 - 0.23 */
	 u_int32_t window;
	/* Description - Read only: size in bytes of collection window. */
	/* 0.24 - 0.28 */
	 u_int8_t log_window_size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bitmask of irisc to collect 1-Iron, 0-7 plastic */
	/* 4.0 - 4.15 */
	 u_int16_t irisc_bitmask;
	/* Description - Shomron only. back pressure on congestion */
	/* 4.24 - 4.24 */
	 u_int8_t bp;
	/* Description - Shomron only. If set collect all IPs, if cleared only branches */
	/* 4.25 - 4.25 */
	 u_int8_t all_ips;
	/* Description - Shomron only. Use 0 for legacy mode, non 0 for future modes */
	/* 4.26 - 4.27 */
	 u_int8_t trace_mode;
	/* Description - If set tracer will be enabled. For ini, use boot field for boot collection */
	/* 4.31 - 8.31 */
	 u_int8_t enable;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_vport_real_state {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 512.31 */
	 u_int32_t real_state[128];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_fw_esw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.16 - 64.15 */
	 struct connectib_fw_vport_ctx vport_ctx[32];
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_gvmix_sub_structs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_cmdif_ctx cmdif_ctx;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_dummy_addresses_one_cache_line dummy_addresses;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_hca_params hca_params;
	/* Description -  */
	/* 0.0 - 24.31 */
	 struct connectib_icm_page_manager icm_page_manager;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_vf_pages_list vf_pages_list;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_eqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Event Sub Type.
Defined for events which have sub types, zero elsewhere. */
	/* 0.0 - 0.7 */
	 u_int8_t event_sub_type;
	/* Description - Event Type */
	/* 0.16 - 0.23 */
	 u_int8_t event_type;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Delivers auxilary data to handle the event. */
	/* 32.0 - 60.31 */
	 union connectib_sw_eqe_data event_data;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - Owner of the entry */
	/* 60.0 - 60.0 */
	 u_int8_t owner;
	/* Description - Byte-wise XOR of EQE - signature protection (see 
 See Section 16.2.4, 
"Completion and Event Queue Elements (CQEs and EQEs)," on 
page 330
). EQE is valid if byte-wise XOR of entire EQE (including 
sig
nature
 field) and the EQE index is 0xff. */
	/* 60.8 - 60.15 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_itrace_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - threashhold of logging to print from */
	/* 0.0 - 0.7 */
	 u_int8_t log_level;
	/* Description - added delay (usec) to prevent log event lost */
	/* 0.16 - 4.31 */
	 u_int16_t log_delay;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_lock_tag {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t resource_id;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t resource_type;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_reg_access_cmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_reg_access_oper_tlv oper_tlv;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 64.31 */
	 struct connectib_reg_access_reg_tlv reg_tlv;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cable_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t address;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t page_number;
	/* Description - slave adddr */
	/* 0.24 - 4.31 */
	 u_int8_t device_address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 64.31 */
	 u_int32_t dword[12];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_grepper_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t dwords[16];
};

/* Description -   */
/* Size in bytes - 2 */
struct connectib_cc_table_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - this is the shift value used when calculating the injection rate delay */
	/* 0.0 - 0.13 */
	 u_int16_t cct_multiplier;
	/* Description - this is the multiplier used when calculating the injection rate delay */
	/* 0.14 - 0.15 */
	 u_int8_t cct_shift;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_ca_congestion_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - when the CCTI is equal to this value, an event is logged in the CA's cycyclic event log */
	/* 0.0 - 0.7 */
	 u_int8_t trigger_threshold;
	/* Description - the number to be added to the table index (CCTI) on the receipt of a BECN */
	/* 0.8 - 0.15 */
	 u_int8_t ccti_increase;
	/* Description - when the timer expires it will be reset to its specified value, and 1 will be decremented from the CCTI */
	/* 0.16 - 4.31 */
	 u_int16_t ccti_timer;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - the minimum value permitted for the CCTI. This is used to impose a minimum injection rate delay on the SL */
	/* 4.24 - 8.31 */
	 u_int8_t ccti_min;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_congestion_log_event_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - local QP that reached CN threshold. Set to zero if port threshold reached */
	/* 0.0 - 0.3 */
	 u_int8_t service_type;
	/* Description - SL associated with local QP */
	/* 0.4 - 0.7 */
	 u_int8_t sl;
	/* Description - remote QP that is connect to local QP. set to zero for datagram QPs */
	/* 0.8 - 4.31 */
	 u_int32_t local_qpn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - local QP that reached CN threshold. Set to zero if port threshold reached */
	/* 4.8 - 8.31 */
	 u_int32_t remote_qpn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - LID of remote port that is connet to local QP. Set to zero for datagram service */
	/* 8.0 - 8.15 */
	 u_int16_t remote_lid;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - timestamp when threshold reached */
	/* 12.0 - 16.31 */
	 u_int32_t timestamp;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_special_qps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t qp0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t qp1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t raw;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t ipv6;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t reserved;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t ptp1588;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t sync_umr;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_cmdif_hdr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t reserved0;
	/* Description - cmd type = 0x7 */
	/* 0.24 - 4.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - input command length in bytes */
	/* 4.0 - 8.31 */
	 u_int32_t input_length;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t ibox_pointer;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - just the standart, The first 128 bits of the command input */
	/* 16.0 - 32.31 */
	 struct connectib_input_inline_standart input_inline;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - The first 128 bits of the command output */
	/* 32.0 - 48.31 */
	 struct connectib_output_inline_standart output_inline;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 56.31 */
	 u_int64_t obox_pointer;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - output command length in bytes */
	/* 56.0 - 60.31 */
	 u_int32_t output_length;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 60.0 - 60.0 */
	 u_int8_t ownership;
	/* Description -     NO_ERRORS          = 0x0,
    SIGNATURE_ERROR    = 0x1,
    TOKEN_ERROR        = 0x2,
    BAD_BLOCK_NUMBER   = 0x3,
    BAD_OUTPUT_POINTER = 0x4,   // pointer not align to mailbox size
    BAD_INPUT_POINTER  = 0x5,   // pointer not align to mailbox size
    INTERNAL_ERROR     = 0x6,
    INPUT_LEN_ERROR    = 0x7,   // input  length less than 0x8.
    OUTPUT_LEN_ERROR   = 0x8,   // output length less than 0x8.
    RESERVE_NOT_ZERO   = 0x9,
    BAD_CMD_TYPE       = 0x10,
 */
	/* 60.1 - 60.7 */
	 u_int8_t status;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t reserved1;
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 60.16 - 60.23 */
	 u_int8_t signature;
	/* Description - SW should set to 1 when posting the command. HW will change to zero to move ownership bit to SW. */
	/* 60.24 - 64.31 */
	 u_int8_t token;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_header_capture_checks {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t word[16];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_header_capture_headers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 u_int32_t word[32];
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_g_rse_hw_decoders {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_rxt_checks_steering_results_decoder rxt_checks_steering_results_decoder;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_rxt_context_fetch_qp_desc_decoder rxt_context_fetch_qp_desc_decoder;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_rxt_checks_packet_descriptor_decoder rxt_checks_packet_descriptor_decoder;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_rxs_rxt_desc_decoder rxs_rxt_desc_decoder;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_g_rse_decoders_as_dwords raw_dwords;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_FW_VERSION {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t MAJOR;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t SUBMINOR;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t MINOR;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.8 - 8.15 */
	 u_int8_t Hour;
	/* Description -  */
	/* 8.16 - 8.23 */
	 u_int8_t Minutes;
	/* Description -  */
	/* 8.24 - 12.31 */
	 u_int8_t Seconds;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.7 */
	 u_int8_t Day;
	/* Description -  */
	/* 12.8 - 12.15 */
	 u_int8_t Month;
	/* Description -  */
	/* 12.16 - 16.31 */
	 u_int16_t Year;
};

/* Description -   */
/* Size in bytes - 64 */
union connectib_golan_hw_fw_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_hca_contexts hw_ctx;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_fw_resource_context fw_ctx;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_ctx_as_dwords as_dwords;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_wqe_extended_atomic_fetch_add_128byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_add_data add_data[32];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 256.31 */
	 struct connectib_field_boundary field_boundary[32];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_wqe_extended_atomic_fetch_add_64byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_add_data add_data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 128.31 */
	 struct connectib_field_boundary field_boundary[16];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_wqe_extended_atomic_fetch_add_32byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_add_data add_data[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_field_boundary field_boundary[8];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_extended_atomic_fetch_add_16byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_add_data add_data[4];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_field_boundary field_boundary[4];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_fetch_add_8byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_add_data add_data[2];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 struct connectib_field_boundary field_boundary[2];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_fetch_add_4byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t add_data;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t field_boundary;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_wqe_extended_atomic_cmp_swap_128byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_swap_data swap_data[32];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 256.31 */
	 struct connectib_compare_data compare_data[32];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 384.31 */
	 struct connectib_swap_mask_data swap_mask_data[32];
/*---------------- DWORD[96] (Offset 0x180) ----------------*/
	/* Description -  */
	/* 384.0 - 512.31 */
	 struct connectib_compare_mask_data compare_mask_data[32];
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_wqe_extended_atomic_cmp_swap_64byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_swap_data swap_data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 128.31 */
	 struct connectib_compare_data compare_data[16];
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 192.31 */
	 struct connectib_swap_mask_data swap_mask_data[16];
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 192.0 - 256.31 */
	 struct connectib_compare_mask_data compare_mask_data[16];
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_wqe_extended_atomic_cmp_swap_32byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_swap_data swap_data[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_compare_data compare_data[8];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 96.31 */
	 struct connectib_swap_mask_data swap_mask_data[8];
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 96.0 - 128.31 */
	 struct connectib_compare_mask_data compare_mask_data[8];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_wqe_extended_atomic_cmp_swap_16byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_swap_data swap_data[4];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_compare_data compare_data[4];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 48.31 */
	 struct connectib_swap_mask_data swap_mask_data[4];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 64.31 */
	 struct connectib_compare_mask_data compare_mask_data[4];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_extended_atomic_cmp_swap_8byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_swap_data swap_data[2];
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 struct connectib_compare_data compare_data[2];
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 struct connectib_swap_mask_data swap_mask_data[2];
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 32.31 */
	 struct connectib_compare_mask_data compare_mask_data[2];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_extended_atomic_cmp_swap_4byte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t swap_data;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t compare_data;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t swap_mask_data;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t compare_mask_data;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_nv_config_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - if 0x4d544346, this nv_data partition is valid */
	/* 0.0 - 4.31 */
	 u_int32_t signature;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t version_minor;
	/* Description -  */
	/* 4.8 - 4.15 */
	 u_int8_t version_major;
	/* Description - non volatile counter incremented when fw didn't find valid configuration header and need to erase the nv partition */
	/* 4.16 - 8.31 */
	 u_int16_t num_of_init_cfg_hdr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - non volatile counter incremented on each sector erase */
	/* 8.0 - 12.31 */
	 u_int32_t num_of_swaps;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 0=hw_calibration, 1=fast_list, 2=slow_list */
	/* 12.0 - 36.31 */
	 struct connectib_nv_data_pointer list_pointers[6];
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - crc16 of header area */
	/* 60.0 - 60.15 */
	 u_int16_t crc16;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_fw_image {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t itoc_ptr;
	/* Description -  */
	/* 0.24 - 0.24 */
	 u_int8_t is_palladium;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 32.31 */
	 struct connectib_jump_addresses jump_addresses;
};

/* Description -   */
/* Size in bytes - 192 */
struct connectib_pcie_cfg_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.3 */
	 u_int8_t pcie_max_speed_supported;
	/* Description - [0]-x1\n[1]-x2\n[2]-x4\n[3]-x8\n[4]-x16 */
	/* 0.4 - 0.8 */
	 u_int8_t pcie_max_width_supported;
	/* Description - Drop LPS after 5 msec */
	/* 0.9 - 0.9 */
	 u_int8_t drop_loopback_slave_en;
	/* Description - disable automatic reversal, set lane_reversal_enable = 0x1, this flag is for Loopback PTC Test. It solve the problem of rx_active_lanes when moving to Loopback from Configuration */
	/* 0.10 - 0.10 */
	 u_int8_t disable_automatic_reversal;
	/* Description - Enable up or down configuring the link width */
	/* 0.12 - 0.12 */
	 u_int8_t upconfigure_capable;
	/* Description - PCIe is reversed in comparison to the rx */
	/* 0.13 - 0.13 */
	 u_int8_t px_tx_reversal;
	/* Description -  */
	/* 0.14 - 0.14 */
	 u_int8_t polling_compliance_en;
	/* Description -  */
	/* 0.15 - 0.15 */
	 u_int8_t pcie_center_phase_optimization_en;
	/* Description -  */
	/* 0.17 - 0.17 */
	 u_int8_t handle_bar_miss_error_by_cr_handler_en;
	/* Description - This bit enables DC ballance on the transmitter */
	/* 0.18 - 0.18 */
	 u_int8_t dc_ballance_en;
	/* Description - Enable receiver detect as a condition to exit from Detect 
   Notice: Need to configure the receiver detect time */
	/* 0.19 - 0.19 */
	 u_int8_t receiver_detect_en;
	/* Description - When using receiver detect WA this field define the delay to detect a receiver
   Notice: Using a value too high for a system will cause the PCIe not to link up */
	/* 0.20 - 0.28 */
	 u_int16_t receiver_detect_time;
	/* Description - Reference clock indication 1-from connector 0-local oscilator */
	/* 0.29 - 0.29 */
	 u_int8_t slot_clock_cfg;
	/* Description -  */
	/* 0.30 - 0.30 */
	 u_int8_t dynamic_pll_manage_en;
	/* Description - If set, the unused PX SerDes x4 ports will be disabled in order to save power.
 */
	/* 0.31 - 4.31 */
	 u_int8_t static_width_reduction_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Do mixer0 calibration with optimization. */
	/* 4.0 - 4.0 */
	 u_int8_t do_mixer0_calibration_optimized;
	/* Description - Delta from edges while serching for valid mixer_offset0 */
	/* 4.1 - 4.6 */
	 u_int8_t do_mixer0_calibration_delta;
	/* Description - calibration is done per lane according to this mask in stage I and then on mask_not in stage II */
	/* 4.16 - 8.31 */
	 u_int16_t first_iteration_calibration_mask;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 40.31 */
	 struct connectib_pcie_serdes_cfg serdes_cfg;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 92.31 */
	 struct connectib_pcie_equalization_and_eye pcie_equalization_and_eye;
/*---------------- DWORD[23] (Offset 0x5c) ----------------*/
	/* Description - Opens specific PCIe debug capabilities */
	/* 92.0 - 96.31 */
	 struct connectib_pcie_debug_cap pcie_debug_cap;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description - preset values se  nt in Eq.Phase2 / Enable */
	/* 96.0 - 112.31 */
	 struct connectib_pcie_tx_adaptation_cfg tx_adaptation_cfg;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 112.0 - 180.31 */
	 struct connectib_pcie_rx_adaptation_cfg rx_adaptation_cfg;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_vpd_eeprom_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size of VPD eeprom / flash */
	/* 0.0 - 0.15 */
	 u_int16_t vpd_size;
	/* Description - Size of each one of the EEEPROM slaves of the VPD */
	/* 0.16 - 0.20 */
	 u_int8_t log2_vpd_eeprom_size;
	/* Description - Number of EEEPROM slaves of the VPD */
	/* 0.24 - 0.26 */
	 u_int8_t vpd_num_eeproms;
	/* Description - Set if VPD on eeprom, if on flash */
	/* 0.27 - 0.27 */
	 u_int8_t vpd_eeprom;
};

/* Description -   */
/* Size in bytes - 132 */
struct connectib_ini_gpios_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 84.31 */
	 struct connectib_gpio_functions functions;
/*---------------- DWORD[21] (Offset 0x54) ----------------*/
	/* Description -  */
	/* 84.0 - 132.31 */
	 struct connectib_gpio_configurations configurations;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_i2c_devices_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_i2c_device_entry device[16];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_module_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_module_config_st module[2];
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_thermal_config_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Threshold (in celsius degree) for the temp _fsm to move from WARM to COLD state,
and clear the OVT warning over gpio (if enabled).
set by default to 95c. */
	/* 0.0 - 0.7 */
	 u_int8_t warm2cold_threshold;
	/* Description - Threshold (in celsius degree) for the temp _fsm to move from COLD to WARM state,
and set the OVT warning over gpio (if enabled).
set by default to 110c. */
	/* 0.8 - 0.15 */
	 u_int8_t cold2warm_threshold;
	/* Description - Reaching this temperature will cause the fw algorith to move the temp_fsm to HOT state
and cause thermal_shut_down.
set by default to 120c. */
	/* 0.16 - 0.23 */
	 u_int8_t fw_shut_down_threshold;
	/* Description - if set and thermal fsm reaches HOT state, FW will perform thermal_shut_down (i1fsm moved to FATAL state). */
	/* 0.30 - 0.30 */
	 u_int8_t fw_shut_down_en;
	/* Description - 1- indicate that board over temp warning gpio is enabled.
can be set/clear by ini and mad. */
	/* 0.31 - 4.31 */
	 u_int8_t gpio_enable;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - left from baz for MAD query.
 */
	/* 4.0 - 4.0 */
	 u_int8_t trap_supported;
	/* Description - left from baz for MAD query. */
	/* 4.1 - 4.1 */
	 u_int8_t trap_enable;
	/* Description - if set, report to fatal buffer. */
	/* 4.2 - 4.2 */
	 u_int8_t fatal_enable;
	/* Description - external sensors active, bit per sensor. bit0 = internal EMC1444 sensor
 bit1 = EMC1444 Q1 sensor
 bit2 = EMC1444 Q2 sensor
 bit3 = EMC1444 Q3 sensor
 */
	/* 4.8 - 4.11 */
	 u_int8_t active_ext_sensors;
	/* Description - compare mask, bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the a2d will be configured to HW protection (compare).
HW will shut down if 130deg threshold will be reached.
default is YU a2d selected.
legal value are 1,2,4 so only one a2d is selected only, or 0 for none (hw protection disabled).
 */
	/* 4.16 - 4.18 */
	 u_int8_t a2d_compare_mask;
	/* Description - measure mask, measure circuit is analog. bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the fw will measure the temperature from relevant a2d and calc it for fw thermal protection.
default is none as compare and measure is considered more reliable. */
	/* 4.19 - 4.21 */
	 u_int8_t a2d_measure_mask;
	/* Description - compare and measure mask, measure circuit is digital. bit per a2d (0 - iopx, 1 - iopl, 2 - yu)
if set, the fw will measure the temperature from relevant a2d and calc it for fw thermal protection.
default is IOPX and IOPL only (the YU will be used for hw thermal protection). */
	/* 4.22 - 4.24 */
	 u_int8_t a2d_compare_and_measure_mask;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_system_mng {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - If set network ports will be reveresed */
	/* 0.0 - 0.0 */
	 u_int8_t port_swap;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_power {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - In case fuse_dvfs_force is set, contain the forced DVFS value for voltage scaling procedure */
	/* 0.28 - 0.30 */
	 u_int8_t fuse_dvfs;
	/* Description - if set, the DVFS is read from INI instead of reading from fuse */
	/* 0.31 - 4.31 */
	 u_int8_t fuse_dvfs_force;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_iopl_power iopl_power;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_iopx_power iopx_power;
};

/* Description -   */
/* Size in bytes - 1792 */
struct connectib_port_serdes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - contains parameters that are board related.
for example: polarity, SD parameters */
	/* 0.0 - 1472.31 */
	 struct connectib_phy_hw_main_config_ip phy_hw_main_config_ip;
/*---------------- DWORD[372] (Offset 0x5d0) ----------------*/
	/* Description -  */
	/* 1488.0 - 1552.31 */
	 struct connectib_logic_serdes_mapping_node_ini logic_serdes_mapping_node_ini;
/*---------------- DWORD[389] (Offset 0x614) ----------------*/
	/* Description -  */
	/* 1556.0 - 1592.31 */
	 struct connectib_pll_params pll_params;
/*---------------- DWORD[398] (Offset 0x638) ----------------*/
	/* Description -  */
	/* 1592.0 - 1624.31 */
	 struct connectib_port_mlpn_db mlpn_port[2];
};

/* Description -  format of non volatile configuration loaded from flash for pre plastic flows */
/* Size in bytes - 64 */
struct connectib_nv_config_boot {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 40.31 */
	 struct connectib_nv_config_boot_global global;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_power_management {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - both for gen12 adn for gen3 */
	/* 0.0 - 0.15 */
	 u_int16_t delay_in_recovery_lock;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t pcie_l1_en;
};

/* Description -  PCI configuration space (by spec) */
/* Size in bytes - 512 */
struct connectib_pci_cfg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_pci_cfg_space pci_cfg_space;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 512.31 */
	 struct connectib_pciex_ext_cfg_space pciex_ext_cfg_space;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_pcie_transaction {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Max number of pending outbound read requests */
	/* 0.0 - 0.8 */
	 u_int16_t global_read_task_limit;
	/* Description - Function Level Reset Capability enable */
	/* 0.9 - 0.9 */
	 u_int8_t function_level_reset_capability;
	/* Description - If and only if set, upon sending Completion with UR status, due to incoming Cfg Type 1 Request, 
will be reported (by FW) as AER advisory-non-fatal (anf) error  */
	/* 0.10 - 0.10 */
	 u_int8_t aer_anf_by_cfg_type_1_en;
	/* Description - If and only if set, upon sending Completion with UR status, due to bad function number in incoming Cfg Request, 
will be reported (by FW) as AER advisory-non-fatal (anf) error  */
	/* 0.11 - 0.11 */
	 u_int8_t aer_anf_by_bad_func_en;
	/* Description -  */
	/* 0.12 - 0.12 */
	 u_int8_t advisory_non_fatal_en;
	/* Description - advanced error reporting enable */
	/* 0.13 - 0.13 */
	 u_int8_t aer_cap_en;
	/* Description - Alternatove Rounting-ID capability enable  */
	/* 0.14 - 0.14 */
	 u_int8_t ari_cap_en;
	/* Description - SR-IOV capability enable  */
	/* 0.15 - 0.15 */
	 u_int8_t sriov_cap_en;
	/* Description - VPD  capability enable  */
	/* 0.16 - 0.16 */
	 u_int8_t vpd_cap_en;
	/* Description - enable crspace access via conf space register 22 and 23 */
	/* 0.17 - 0.17 */
	 u_int8_t pci_crspace_access_en;
	/* Description - MLNX PCI VSEC   capability enable  */
	/* 0.18 - 0.18 */
	 u_int8_t pci_vsec_cap_en;
	/* Description - MLNX PCIE VSEC  - for future use */
	/* 0.19 - 0.19 */
	 u_int8_t pcie_vsec_cap_en;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_multi_function {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - num of hosts */
	/* 0.5 - 0.7 */
	 u_int8_t num_hosts;
	/* Description - num of msix vectors per pf */
	/* 0.16 - 0.23 */
	 u_int8_t pf_msix_table_size;
	/* Description - num of msix vectors per vf */
	/* 0.24 - 4.31 */
	 u_int8_t vf_msix_table_size;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.16 - 4.19 */
	 u_int8_t log_max_num_of_eqs;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Log base 2 of PF UAR size in MB */
	/* 8.0 - 8.5 */
	 u_int8_t log2_pf_bar_megabytes;
	/* Description - UAR Bar width - 0x0=32bit , 0x1=64bit */
	/* 8.6 - 8.6 */
	 u_int8_t pf_bar_type;
	/* Description - UAR Bar prefetchable property */
	/* 8.7 - 8.7 */
	 u_int8_t pf_bar_prefetchable;
	/* Description - Log base 2 of VF mini BAR size in MB. Total SR BAR size is 2^log2_vf_minibar_megabytes * total_vfs */
	/* 8.8 - 8.13 */
	 u_int8_t log2_vf_minibar_megabytes;
	/* Description - VF Bar width - 0x0=32bit , 0x1=64bit */
	/* 8.14 - 8.14 */
	 u_int8_t vf_minibar_type;
	/* Description - VF Bar prefetchable property */
	/* 8.15 - 8.15 */
	 u_int8_t vf_minibar_prefetchable;
	/* Description - function number that requests and enables crspace bar */
	/* 8.16 - 8.19 */
	 u_int8_t cr_bar_func;
	/* Description - CR Bar width - 0x0=32bit , 0x1=64bit */
	/* 8.20 - 8.20 */
	 u_int8_t cr_bar_type;
	/* Description - request and enable crspace bar */
	/* 8.21 - 8.21 */
	 u_int8_t cr_bar_en;
};

/* Description -  format of non volatile configuration loaded from flash */
/* Size in bytes - 256 */
struct connectib_nv_config_main {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_nv_config_main_fw_data fw_config;
};

/* Description -   */
/* Size in bytes - 688 */
struct connectib_phy_fw_main_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 232.31 */
	 struct connectib_phy_fw_main_config_golan phy_golan;
/*---------------- DWORD[58] (Offset 0xe8) ----------------*/
	/* Description - contains parameters that are FW flows related. 
for example: MLPN bits. speed, width capabilities .. */
	/* 232.0 - 616.31 */
	 struct connectib_phy_fw_main_config_ip phy_ip;
};

/* Description -   */
/* Size in bytes - 76 */
struct connectib_host_management {
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 36.31 */
	 struct connectib_ocsd_config ocsd_config;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 64.31 */
	 struct connectib_ibm_thermal_config ibm_thermal_config;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_management {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_node_info node_info;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 92.31 */
	 struct connectib_ib_port_info_ini port_info;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 192.0 - 192.0 */
	 u_int8_t eeprom_read_disable_p1;
	/* Description -  */
	/* 192.1 - 192.1 */
	 u_int8_t eeprom_read_disable_p2;
	/* Description - override fw cable stamping */
	/* 192.2 - 192.2 */
	 u_int8_t fw_stamping_override;
	/* Description - override read supported cable speed */
	/* 192.3 - 192.3 */
	 u_int8_t cable_speed_override;
/*---------------- DWORD[49] (Offset 0xc4) ----------------*/
	/* Description -  */
	/* 196.0 - 200.31 */
	 struct connectib_extended_port_info_ini extended_port_info;
/*---------------- DWORD[50] (Offset 0xc8) ----------------*/
	/* Description - valid i2c address for cable info mad */
	/* 200.24 - 204.23 */
	 u_int8_t valid_i2c_address[4];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_customization {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - the module rx amp range in port1 will be configured according to active_amp_range value */
	/* 0.0 - 0.3 */
	 u_int8_t active_amp_range_p1;
	/* Description - the module rx amp range in port2 will be configured according to active_amp_range value */
	/* 0.4 - 0.7 */
	 u_int8_t active_amp_range_p2;
};

/* Description -   */
/* Size in bytes - 160 */
struct connectib_leds_blink_patterns {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_led_port_blink_pattern no_phy_no_log_link;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 struct connectib_led_port_blink_pattern phy_no_log_link;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 24.31 */
	 struct connectib_led_port_blink_pattern phy_log_link;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 32.31 */
	 struct connectib_led_port_blink_pattern phy_log_link_traffic;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 40.31 */
	 struct connectib_led_port_blink_pattern error;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 160.31 */
	 struct connectib_led_port_blink_pattern reserved_pattern[15];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_static_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t dwrr_en;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t ifarm_en;
	/* Description - flip flop data protection enable
if error is detected -
ib + pci serdes will give dc stable (i.e all 0's) */
	/* 0.8 - 0.8 */
	 u_int8_t ffser_en;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - mask of iriscs that participate in prio group X in dispatcher */
	/* 4.0 - 4.7 */
	 u_int8_t prio_g_0_ix_mask_no_ifarm;
	/* Description - mask of iriscs that participate in prio group X in dispatcher */
	/* 4.8 - 4.15 */
	 u_int8_t prio_g_1_ix_mask_no_ifarm;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_guids {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - UIDs (MACs and GUIDs) Allocation Entry.
guids[0], is used for system GUID, node GUID and port GUID of port 0. guids[1], is used for port GUID of port 1.;/Multiple UIDs can be assigned to a single port, to be used for multiple virtual guests.

Allocation Example:
For a port GUID, if the
    UID = 0x2c9030001000
    num_allocated  = 4, 
    step = 8

Then the GUIDs for this port would be:
    0x2c9030001000
    0x2c9030001008
    0x2c9030001010
    0x2c9030001018 */
	/* 0.0 - 32.31 */
	 struct connectib_uid_entry guids[2];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_uid_entry macs[2];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_module_versions {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_module_version core;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_module_version phy;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 struct connectib_module_version kernel;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 struct connectib_module_version iron_image;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 struct connectib_module_version host_management;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 struct connectib_module_version mad;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_image_size {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - log of next address in bytes to search for an image. Address in bytes is 2^log_step */
	/* 0.0 - 0.7 */
	 u_int8_t log_step;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Max possible size in bytes of image. Image read / write should not occure beyond this address */
	/* 4.0 - 8.31 */
	 u_int32_t max_size;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_TRIPPLE_VERSION {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t MAJOR;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t SUBMINOR;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t MINOR;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_operation_key {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t key_modifier;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t key;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_toc_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t size;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_rst_api_ver {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_reset_level_info reset[8];
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_reset_capabilities {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Initial capability for reset level */
	/* 0.0 - 0.0 */
	 u_int8_t reset_ver_en;
};

/* Description -   */
/* Size in bytes - 96 */
struct connectib_icmd_get_pf_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t portid;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t vport_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t pf_gvmi;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 64.31 */
	 struct connectib_vport_shadow vport_shadow;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 96.31 */
	 struct connectib_vport_info vport_info;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_gen_assert {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - assert value */
	/* 0.0 - 4.31 */
	 u_int32_t value;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_general_fault_injector {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - no pages */
	/* 0.0 - 4.31 */
	 u_int32_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_general_fault_injector_pair config;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_pvlc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 20.31 */
	 struct connectib_pvlc_reg pvlc;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_read_ste {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_ste data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 68.31 */
	 u_int32_t index;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 68.0 - 68.15 */
	 u_int16_t gvmi;
	/* Description - is ste locked in icmc, if so gvmi is reserved */
	/* 68.31 - 72.31 */
	 u_int8_t locked_in_icmc;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_icmd_get_ste_resources_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ste_resources_list_in in;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_icmd_get_ste_resources_list_out out;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_get_ste_open_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ste_open_resources_in in;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_get_ste_open_resources_out out;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_get_fte {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fte_in in;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_get_fte_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_fte_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fte_list_in in;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fte_list_out out;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_icmd_get_fg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fg_in in;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_icmd_get_fg_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_fg_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fg_list_in in;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_fg_list_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_ft_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ft_info_in in;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ft_info_out out;
};

/* Description -   */
/* Size in bytes - 16 */
union connectib_icmd_get_ft_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ft_list_in in;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_ft_list_out out;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_set_get_port_cntr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 u_int64_t data;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.0 */
	 u_int8_t port_0_1;
	/* Description -  */
	/* 8.1 - 8.1 */
	 u_int8_t set_get_;
	/* Description - ConnectX4 max_ix=276 ; ConnectIB max_ix=182 */
	/* 8.16 - 12.31 */
	 u_int16_t cntr_ix;
};

/* Description -   */
/* Size in bytes - 268 */
struct connectib_icmd_access_register_ppcnt {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 260.31 */
	 struct connectib_ppcnt_reg ppcnt;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_icmd_access_reg_ptys {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 68.31 */
	 struct connectib_ptys_reg ptys;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_pmtu {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 20.31 */
	 struct connectib_pmtu_reg pmtu;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_ppamp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 48.31 */
	 struct connectib_pamp_reg ppamp;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_ptas {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 48.31 */
	 struct connectib_ptas_reg ptas;
};

/* Description -   */
/* Size in bytes - 44 */
struct connectib_icmd_access_register_slrg {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 44.31 */
	 struct connectib_slrg_reg slrg;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_access_register_sltp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 24.31 */
	 struct connectib_sltp_reg sltp;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_access_register_slrp {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 44.31 */
	 struct connectib_slrp_reg slrp;
};

/* Description -   */
/* Size in bytes - 20 */
struct connectib_icmd_access_register_paos {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 20.31 */
	 struct connectib_paos_reg paos;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_gvmi_via_vsec {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_steering_table_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_steering_table_info table_info;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - defined in steering_inner.h */
	/* 32.0 - 32.23 */
	 u_int32_t steering_table;
	/* Description -  */
	/* 32.31 - 36.31 */
	 u_int8_t portid;
};

/* Description -   */
/* Size in bytes - 68 */
struct connectib_icmd_access_steering_root {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_hw_ste data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 64.0 */
	 u_int8_t sx_rx_;
	/* Description -  */
	/* 64.1 - 64.1 */
	 u_int8_t portid;
	/* Description -  */
	/* 64.2 - 64.2 */
	 u_int8_t mc_uc_;
	/* Description - valid only for SX, in HW indication come from QP */
	/* 64.3 - 64.3 */
	 u_int8_t special_root;
	/* Description -  */
	/* 64.31 - 68.31 */
	 u_int8_t rw_;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_dcr_ll_next_dcr_list {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t start_dcri;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t list_length;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 768.31 */
	 struct connectib_dcr_info dcr_info[128];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_dcr_ll_trvrs {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t start_dcri;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t list_length;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t last_dcri;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_flr_debug {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - read - update in_standby_mode and times. write - simulate exit/enter icmc power save flow (caller should set exit_enter_) */
	/* 0.0 - 0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t flow_id;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t flow_data_0;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t flow_data_1;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_push_db {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 4.24 - 4.24 */
	 u_int8_t req_res_;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_pcie_ver_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_pcie_ver_device device;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 48.31 */
	 struct connectib_icmd_pcie_ver_cables cables[2];
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 64.31 */
	 struct connectib_icmd_pcie_ver_frequency frequency;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_stress_testing {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0x01 - ICMD_STRESS_OPCODE_RXB_SLICE_CREDIT
0x02 - ICMD_STRESS_OPCODE_ICMC_NORMAL_CREDITS
0x03 - ICMD_STRESS_OPCODE_ICMC_TLB_CREDITS
0x04 - ICMD_STRESS_OPCODE_TRANSLATION_SLICE_CREDITS
0x05 - ICMD_STRESS_OPCODE_QPC_TIMER_CREDITS
0x06 - ICMD_STRESS_OPCODE_TPT_MEMOP_SLICE_CREDITS
0x07 - ICMD_STRESS_OPCODE_QPC_ALL_SLICE_REDUCTION
0x08 - ICMD_STRESS_OPCODE_FW_STOP */
	/* 0.0 - 0.7 */
	 u_int8_t opcode;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - for opcodes 0x01-0x06 param is number of credits to consume,for opcode 0x07 set param != -1 for stress, for opcode 0x08 param is number of iterations for delay. set -1 to return to initial value */
	/* 4.0 - 8.31 */
	 u_int32_t param;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_icmd_stop_toggler {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - DC_CNAK    = 0
RXT_CHECKS = 1
TIMERS     = 2
SX_ERROR   = 3
RX_ERROR   = 4
MX_ERROR   = 5
MAD_TRAP   = 6
RXT_SLICE       = 0x20
QOS_ARBITER     = 0x21 */
	/* 0.0 - 0.7 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - HW/FW will be working/stopped (according to mostly_working config) for a fraction of 1/(2^log_stress) each duty cycle. Duty cycle is: approx. 50uSec * 2^log_duty_cycle */
	/* 4.0 - 4.0 */
	 u_int8_t mostly_working;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0 = remove stress */
	/* 8.0 - 8.4 */
	 u_int8_t log_duty_cycle;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - must be less than log_duty_cycle */
	/* 12.0 - 12.4 */
	 u_int8_t log_stress;
};

/* Description -   */
/* Size in bytes - 264 */
struct connectib_icmd_code_coverage_read {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 u_int32_t data[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - dword to start reading the data from */
	/* 256.0 - 256.15 */
	 u_int16_t start_dw;
	/* Description - number of dword to read. Max number is buffer size in dwords or number of dwords left in HW queue from start */
	/* 256.16 - 260.31 */
	 u_int16_t num_dw;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_code_coverage_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - reg access is shared with smp mads that are limited to 0x40B */
	/* 4.0 - 12.31 */
	 struct connectib_code_coverage_control code_coverage_control;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_esw {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_fw_esw fw_esw;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.29 - 64.29 */
	 u_int8_t port_is_ib;
	/* Description -  */
	/* 64.30 - 64.30 */
	 u_int8_t rw_;
	/* Description -  */
	/* 64.31 - 68.31 */
	 u_int8_t portid;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 68.0 - 72.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 76.31 */
	 u_int32_t num_of_vport;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 768.31 */
	 struct connectib_vport_real_state vport_real_state;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_rw_gvmix {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_gvmix_sub_structs sub_structs;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 68.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - ICMD_RW_GVMIX_CMD_CTX = 0x1,
ICMD_RW_GVMIX_DUMMY_ADDR = 0x2,
ICMD_RW_GVMIX_HCA_PARAMS = 0x3,
ICMD_RW_GVMIX_PAGE_MANAGER = 0x4, */
	/* 68.0 - 72.31 */
	 u_int32_t node_type;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 76.31 */
	 u_int32_t ix;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_gen_eqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t eqn;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 80.31 */
	 struct connectib_sw_eqe eqe;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_pcie_tools_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t pcie_endpoint_data_ptr;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t pcie_timestamps_ptr;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t pcie_transaction_ptr;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t pcie_debug_equalization_debug_ptr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t pcie_debug_ts_debug_ptr;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t pcie_debug_internal_error_debug_ptr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t pcie_phy_gen3_equalization_ptr;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t pcie_phy_pcie_eye_centering_ptr;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 u_int32_t pcie_phy_first_calibration_results_ptr;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t pcie_phy_pcie_rx_adaptation_ptr;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t pcie_phy_pcie_tx_adaptation_ptr;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t pcie_phy_tracer_ptr;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t pcie_pfs_ptr;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_phy_ver_overwrite {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - port1, 1 - port2 */
	/* 0.0 - 0.0 */
	 u_int8_t port_id;
	/* Description - 0x00 - CABLE_STAMP
0x01 - MLPN_EN
0x02 - MLPN_SUP
0x03 - MLPN_REQ
0x04 - SPEC_1_2
0x05 - SPEC_1_3
0x06 - FEC_REQ_FDR
0x07 - FEC_REQ_FDR10 */
	/* 0.16 - 0.23 */
	 u_int8_t field_id;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - New value to overwrite.
 For MLPN_SUP and MLPN_REQ full DW
 */
	/* 4.0 - 8.31 */
	 u_int32_t field_value;
};

/* Description -   */
/* Size in bytes - 12 */
struct connectib_icmd_init_ocsd {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t addr_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t addr_low;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_itrace {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - bit numbers:
0=DEBUG_INIT
1=INIT
2=ICM
3=ICM_FREE_LIST
4=ICM_BLOCK_ALLOC
5=CMD_IF
6=PHY_IB
7=PHY_RX_ADAP
8=PHY_EYE_OPN
9=PHY_COMMON
10=PHY_MANAGER
11=PHY_PLL
12=BLOCK_ALLOC
13=ICM_ACCESS
14=MAD
15=RXT_CHECKS
16=I2C
17=TRANSPORT
18=FW_LL
19=RX_ERRORS
20=DEBUG_TRACER
21=PROFILING
22=MANAGEMENT
23=FLASH
24=STEERING
 */
	/* 0.0 - 4.31 */
	 u_int32_t unit_mask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 struct connectib_itrace_ctrl ctrl;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_dc_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 0 - DC_CONFIG_BIT_HANDSHAKE
1 -DC_CONFIG_INITIAL_LOG_LIFO
2 - DC_CONFIG_LOG_MAX_DCRS
3 - DC_CONFIG_INHALE_EN
4 - DC_CONFIG_INHALE_THRESHOLD
5 - DC_CONFIG_INHALE_INC
6 - DC_CONFIG_LIFO_SIZE_INC
7 - DC_CONFIG_LOG_HASH
8 - DC_CONFIG_FORCE_NO_DCRS
9 - DC_CONFIG_FORCE_GARBAGE_COLLECT
10 - DC_CONFIG_GARBAGE_COLLECT_PACKET_DROP
11 - DC_CONFIG_GHOST_BUSTER_ENABLE */
	/* 0.0 - 4.31 */
	 u_int32_t bitmask;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - read=1, write=0, for read - bitmask must be 0, for write: at least 1 bit should be set in bitmask */
	/* 4.0 - 4.0 */
	 u_int8_t rw_;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - must be configured before init hca - lifo size to be initialized during init_hca */
	/* 12.0 - 12.4 */
	 u_int8_t initial_log_dcr_lifo_size;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - should be configured when no DC traffic: must be less than DC_INITIAL_LOG_DCR_HASH_SIZE.
 Mustn't be changed when dcrs are in use (garbage collection must be done) */
	/* 16.0 - 16.4 */
	 u_int8_t log_hash_size;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - set all qps opened from this point with full_handshake = 0/1 */
	/* 20.0 - 20.0 */
	 u_int8_t full_handshake_enable;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - absolute max number of dcrs (after inhale) */
	/* 24.0 - 24.4 */
	 u_int8_t log_max_dcrs;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - enable inhaling lifo (enlarging lifo when reaching lower threshold) */
	/* 28.0 - 28.4 */
	 u_int8_t inhale_en;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - threshold of available dcrs when inhale is triggered */
	/* 32.0 - 32.23 */
	 u_int32_t inhale_threshold;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - number of dcrs to add to lifo when inhale is triggered */
	/* 36.0 - 36.23 */
	 u_int32_t inhale_inc;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - when FORCE_NO_DCR bit is set in bitmask: forces no_dcr (cnacks) for force_no_dcrs_delay times ~15ns ticks. max delay of: 10,000,000 (1.5 secs) */
	/* 40.0 - 44.31 */
	 u_int32_t force_no_dcrs_delay;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - RO - expected maximum dcrs when HW is idle */
	/* 44.0 - 48.31 */
	 u_int32_t current_max_lifo_size;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description - RO - current number of free dcrs in lifo */
	/* 48.0 - 52.31 */
	 u_int32_t available_lifo_size;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description - should be configured when no DC traffic. decrease mustn't go below 0. firmware will level out maximum so as not to go above absolute max */
	/* 52.0 - 56.31 */
	 u_int32_t available_lifo_size_inc;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description - when GARBAGE_COLLECTION bit is set in bitmask, icmd will return OK if done, or OPERATIONAL_ERROR if garbage collection doesn't finish with this number of ticks (~50usec) */
	/* 56.0 - 60.31 */
	 u_int32_t force_garbage_collection_fail_threshold;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description - number of ghost busters currently active. should be 0 once garbage collection is done */
	/* 60.0 - 64.31 */
	 u_int32_t number_of_active_ghost_busters;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - N next dcr cleanup connects will be dropped */
	/* 64.0 - 68.31 */
	 u_int32_t cleanup_drop_n_connects;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - N next dcr cleanup disconnects will be dropped */
	/* 68.0 - 72.31 */
	 u_int32_t cleanup_drop_n_disconnects;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description - enables/disable ghost buster mechanism */
	/* 72.0 - 72.0 */
	 u_int8_t ghost_buster_enable;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_dc_params {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t full_handshake_enable;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - must be less than DC_INITIAL_LOG_DCR_HASH_SIZE.
 Mustn't be changed when dcrs are in use */
	/* 8.0 - 8.4 */
	 u_int8_t log_hash_size;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - RO */
	/* 12.0 - 16.31 */
	 u_int32_t current_lifo_size;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_access_icm_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.31 - 68.31 */
	 u_int8_t rw_;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 80.31 */
	 u_int64_t addr;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_check_sqpc_status {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t qpn;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
	/* Description - 0:all good
1:db_record!=sxdc_pi
2:pi!=ci;\3:ci!=ccwi */
	/* 4.16 - 8.31 */
	 u_int16_t result_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - the diff */
	/* 8.0 - 12.31 */
	 u_int32_t result_diff;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_lock_unlock_resource {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_lock_tag lock_tag;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.0 */
	 u_int8_t lock_unlock_;
	/* Description -  */
	/* 12.8 - 12.10 */
	 u_int8_t irisc_ix;
	/* Description - when this bit is set, locking will impersonate irisc specified in irisc_ix field */
	/* 12.11 - 12.11 */
	 u_int8_t spy_en;
};

/* Description -   */
/* Size in bytes - 160 */
struct connectib_reg_access_ext_cmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_reg_access_cmd reg_access;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - reg access is shared with smp mads that are limited to 0x40B */
	/* 64.0 - 160.31 */
	 u_int32_t more_data[24];
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_get_icm_ctx_addr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 4.0 - 8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t ctx_num_hi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t ctx_num_lo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t icm_addr_hi;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t icm_addr_lo;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_phy_nego_ctrl_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t force_link_up_port0;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t halt_fw_phy_fsm_port0;
	/* Description -  */
	/* 0.2 - 0.2 */
	 u_int8_t force_link_up_port1;
	/* Description -  */
	/* 0.3 - 0.3 */
	 u_int8_t halt_fw_phy_fsm_port1;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_eye_opening_read_st {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t port_num;
	/* Description -  */
	/* 0.16 - 0.23 */
	 u_int8_t lane_num;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t amplitude_high;
	/* Description -  */
	/* 4.16 - 8.31 */
	 u_int16_t amplitude_low;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t phase_high;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t phase_low;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t tx_set_chosen;
	/* Description -  */
	/* 12.16 - 16.31 */
	 u_int16_t rx_set_chosen;
};

/* Description -   */
/* Size in bytes - 24 */
struct connectib_icmd_alloc_dealloc_resource {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 0.16 - 0.16 */
	 u_int8_t alloc_dealloc;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 4.0 - 8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t res_num_hi;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t res_num_lo;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t return_status;
};

/* Description -   */
/* Size in bytes - 36 */
struct connectib_icmd_get_icm_res_prop {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - valid types defined at icm_resources.h */
	/* 0.0 - 4.31 */
	 u_int32_t input_icm_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t table_base_hi;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t table_base_lo;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t offset;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t log2_stride;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t log2_size;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t log2_table_size;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t dummy_idx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 u_int32_t sw_type;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_icmd_cable_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1 = GET, 2 = SET */
	/* 0.0 - 0.7 */
	 u_int8_t method;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - return status */
	/* 4.16 - 4.30 */
	 u_int16_t status;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 20.7 */
	 u_int8_t module;
	/* Description - when set, no page select will be made */
	/* 20.31 - 24.31 */
	 u_int8_t lock_bit;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 128.31 */
	 struct connectib_cable_info data;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_cable_plug_out_in {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Bit per port. 0x1 - port1, 0x2 - port2, 0x3 - both ports, others reserved. */
	/* 0.0 - 0.3 */
	 u_int8_t port;
	/* Description - Simulate plug out (0x1) or plug in (0x0), this mode will work if delay=0 */
	/* 0.8 - 0.8 */
	 u_int8_t plug_out_in;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_standby {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - read - update in_standby_mode and times. write - simulate exit/enter icmc power save flow (caller should set exit_enter_) */
	/* 0.0 - 0.0 */
	 u_int8_t rw_;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x0 - enter power save mode, 0x1 - exit power save mode */
	/* 4.0 - 4.0 */
	 u_int8_t exit_enter_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 0x0 - ports, 0x1 - icmc, 0x2 - arrays, 0x3- clock */
	/* 8.0 - 8.7 */
	 u_int8_t in_standby_mode;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - last iron down time usec. update on icmd read */
	/* 12.0 - 16.31 */
	 u_int32_t last_iron_down_time_usec;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - 0 - icmc standby flow , 1 - arrays standby flow, 2 - clock standby flow, 3 - full standby flow */
	/* 16.0 - 16.15 */
	 u_int16_t flow_id;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_icmd_grepper {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - icmd will run grepper operation - 0x0 - icmc_write, 0x1 - icmc_copy, 0x2 - icmc_copy_and_lock, 0x3 - icmc unlock and invalidate */
	/* 0.0 - 4.31 */
	 u_int32_t icmd_grepper_flow;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - address to read */
	/* 8.0 - 16.31 */
	 u_int64_t read_addr;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - address to write */
	/* 16.0 - 24.31 */
	 u_int64_t write_addr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - read stride size (log) */
	/* 24.0 - 24.4 */
	 u_int8_t log_read_stride;
	/* Description - write stride size (log) */
	/* 24.5 - 24.9 */
	 u_int8_t log_write_stride;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - offset from the first line */
	/* 28.0 - 28.25 */
	 u_int32_t line_start_offset;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - number of iterations */
	/* 32.0 - 32.25 */
	 u_int32_t iterations;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Address of first hit (read only) */
	/* 36.0 - 36.25 */
	 u_int32_t first_line_hit;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - number of hits (read only) */
	/* 40.0 - 44.31 */
	 u_int32_t number_of_hits;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description - write_data */
	/* 44.0 - 108.31 */
	 struct connectib_grepper_dwords write_data;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description - write_mask */
	/* 108.0 - 172.31 */
	 struct connectib_grepper_dwords write_mask;
/*---------------- DWORD[43] (Offset 0xac) ----------------*/
	/* Description - compare_data */
	/* 172.0 - 236.31 */
	 struct connectib_grepper_dwords compare_data;
/*---------------- DWORD[75] (Offset 0x12c) ----------------*/
	/* Description - compare_mask */
	/* 300.0 - 364.31 */
	 struct connectib_grepper_dwords compare_mask;
};

/* Description -   */
/* Size in bytes - 48 */
struct connectib_icmd_debug_fw_tracer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 u_int32_t arg[8];
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - Number of arguments passed to the icmd */
	/* 32.0 - 32.3 */
	 u_int8_t num_of_args;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description - Number of print iterations to execute */
	/* 36.0 - 40.31 */
	 u_int32_t num_of_iterations;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description - Delay between iterations in msec */
	/* 40.0 - 44.31 */
	 u_int32_t iter_delay;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_get_open_resources {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - defined in icm_resources.h */
	/* 4.0 - 8.31 */
	 u_int32_t icm_res_type;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 16.31 */
	 u_int64_t start_index;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - there are more open resources, please query again with the next start index */
	/* 16.0 - 16.0 */
	 u_int8_t more;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - number of valid entries in open resources table */
	/* 20.0 - 24.31 */
	 u_int32_t output_size;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 544.31 */
	 struct connectib_index_and_length open_resources[32];
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_read_icm_dummy_addr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - resource type - see icm_ctx icmd node */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - dummy index: based to icmd_get_icm_res_prop.dummy_idx */
	/* 4.0 - 4.7 */
	 u_int8_t dummy_idx;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - hop number 3-6 */
	/* 8.0 - 8.2 */
	 u_int8_t hop_num;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - PA of dummy page */
	/* 16.0 - 24.31 */
	 u_int64_t dummy_addr;
};

/* Description -   */
/* Size in bytes - 80 */
struct connectib_icmd_read_icm_tlb_line {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int64_t data[8];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 72.31 */
	 u_int64_t tlb_addr;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 72.3 */
	 u_int8_t hop_number;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_config_cc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - ICMD_CONFIG_CC_OPCODE_SET_CC_SETTINGS = 0x0
ICMD_CONFIG_CC_OPCODE_GET_CC_SETTINGS = 0x1
ICMD_CONFIG_CC_OPCODE_SET_CCT = 0x2
ICMD_CONFIG_CC_OPCODE_GET_CCT = 0x3 */
	/* 0.0 - 0.1 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0.4 - 0.4 */
	 u_int8_t portid;
	/* Description -  */
	/* 0.8 - 0.9 */
	 u_int8_t cc_mode;
	/* Description -  */
	/* 0.16 - 4.31 */
	 u_int16_t sl_map;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.7 */
	 u_int8_t base;
	/* Description -  */
	/* 4.16 - 4.23 */
	 u_int8_t num_entries;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description - specifies a list of 16 CA congestion entries, one per SL */
	/* 256.0 - 384.31 */
	 struct connectib_ca_congestion_entry ca_congestion_entry_list[16];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description - specifies a list of 64 CCT entries */
	/* 512.16 - 640.15 */
	 struct connectib_cc_table_entry ccti_entry_list[64];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_write_dc_cnak_lid {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.1 */
	 u_int8_t port;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t lid;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_icmd_congestion_log {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.1 */
	 u_int8_t port;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_congestion_log_event_entry log_entry;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_get_port_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t sx_port1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.23 */
	 u_int32_t sx_port2;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t rx_port1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t rx_port2;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_set_port_sniffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t sx_rx_;
	/* Description -  */
	/* 4.16 - 4.16 */
	 u_int8_t attach_detach_;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.24 - 12.31 */
	 u_int8_t port;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.23 */
	 u_int32_t sniffer_qpn;
};

/* Description -   */
/* Size in bytes - 260 */
struct connectib_icmd_special_qps {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_special_qps qps;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 256.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 256.16 - 256.16 */
	 u_int8_t port;
};

/* Description -   */
/* Size in bytes - 260 */
struct connectib_eqn4type {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 u_int32_t eqn[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 256.15 */
	 u_int16_t gvmi;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_access_cmdq {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_cmdif_hdr cmdq;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 64.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 64.16 - 64.20 */
	 u_int8_t cmd_ix;
};

/* Description -   */
/* Size in bytes - 72 */
struct connectib_icmd_read_sx_wq_buffer {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t data[16];
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 64.4 */
	 u_int8_t ec;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description -  */
	/* 68.0 - 68.4 */
	 u_int8_t wqe_idx;
};

/* Description -   */
/* Size in bytes - 192 */
struct connectib_icmd_header_capture {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_icmd_header_capture_headers headers;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 192.31 */
	 struct connectib_icmd_header_capture_checks checks;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_print_icm {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t enable_specific_gvmi;
	/* Description -  */
	/* 0.1 - 0.1 */
	 u_int8_t enable_specific_icm_type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
	/* Description - take from icm_resources.h */
	/* 4.16 - 8.31 */
	 u_int16_t icm_res_type;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_fw_reset {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - write 0xBADC0FFE in order to enable FW reset */
	/* 0.0 - 4.31 */
	 u_int32_t protection;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 0x1 - upgrade flow
0x2 - dirty MBIST flow */
	/* 4.0 - 4.1 */
	 u_int8_t reset_mode;
};

/* Description -   */
/* Size in bytes - 264 */
struct connectib_icmd_read_g_rse_slice_desc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 union connectib_g_rse_hw_decoders desc;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 256.4 */
	 u_int8_t slice;
	/* Description -  */
	/* 256.8 - 256.11 */
	 u_int8_t array_index;
/*---------------- DWORD[65] (Offset 0x104) ----------------*/
	/* Description - 0x0 STEERING_RES
0x1 PKT_DESC
0x2 RXT_RXS_DESC
0x3 CONTEXT_FETCH_QP_DESC
0x4 STEERING PIPE0
0x5 STEERING PIPE1
0x6 STEERING QPCOMMIT */
	/* 260.0 - 260.7 */
	 u_int8_t desc_type;
};

/* Description -   */
/* Size in bytes - 524 */
struct connectib_icmd_read_rx_slice_packet {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 512.31 */
	 u_int32_t data[128];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description - Total Packet size (returned by ICMD) */
	/* 512.0 - 512.11 */
	 u_int16_t packet_size;
/*---------------- DWORD[129] (Offset 0x204) ----------------*/
	/* Description -  */
	/* 516.0 - 516.4 */
	 u_int8_t slice;
/*---------------- DWORD[130] (Offset 0x208) ----------------*/
	/* Description - How many bytes to read in this iteration. (Must be a multiple of 64. Max allowed value is 512) */
	/* 520.0 - 520.11 */
	 u_int16_t size;
	/* Description - Offset in dw to start from */
	/* 520.16 - 520.27 */
	 u_int16_t offset_dw;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_icmd_get_fw_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_FW_VERSION fw_version;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Hash gen file signature */
	/* 16.0 - 16.15 */
	 u_int16_t hash_signature;
};

/* Description -   */
/* Size in bytes - 8 */
struct connectib_icmd_get_link_leds {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1-port1 2-port2 */
	/* 0.0 - 0.7 */
	 u_int8_t port_number;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t physical_link;
	/* Description -  */
	/* 4.8 - 4.8 */
	 u_int8_t logical_link;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_get_boot_stage {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t boot_stage;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_icmd_get_irisc_heart_beat {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - bit per irisc */
	/* 0.0 - 0.7 */
	 u_int8_t irisc_heart_beat;
};

/* Description -   */
/* Size in bytes - 524 */
struct connectib_icmd_read_q_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 512.31 */
	 u_int32_t data[128];
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description -  */
	/* 512.0 - 512.15 */
	 u_int16_t gvmi;
/*---------------- DWORD[129] (Offset 0x204) ----------------*/
	/* Description -  */
	/* 516.0 - 516.23 */
	 u_int32_t q_num;
	/* Description - 0=sq 1=rq 2=cq 4=eq 5=rdb 6=srq */
	/* 516.24 - 520.31 */
	 u_int8_t q_type;
/*---------------- DWORD[130] (Offset 0x208) ----------------*/
	/* Description -  */
	/* 520.0 - 524.31 */
	 u_int32_t index;
};

/* Description -   */
/* Size in bytes - 288 */
struct connectib_icmd_access_host_mem {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 256.31 */
	 u_int32_t data[64];
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 256.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 256.31 - 260.31 */
	 u_int8_t rw_;
/*---------------- DWORD[65] (Offset 0x104) ----------------*/
	/* Description - up to 256 bytes */
	/* 260.0 - 264.31 */
	 u_int32_t num_dwords;
/*---------------- DWORD[66] (Offset 0x108) ----------------*/
	/* Description -  */
	/* 264.0 - 272.31 */
	 u_int64_t addr;
/*---------------- DWORD[68] (Offset 0x110) ----------------*/
	/* Description - VA - mkey, MTT - ptr */
	/* 272.0 - 280.31 */
	 u_int64_t key_or_ptr;
/*---------------- DWORD[70] (Offset 0x118) ----------------*/
	/* Description - 0-PA
1-MTT
2-VA
3-OFFSET(signature) */
	/* 280.0 - 280.1 */
	 u_int8_t addr_type;
	/* Description - MTT only */
	/* 280.16 - 284.31 */
	 u_int16_t l2_block_s;
};

/* Description -   */
/* Size in bytes - 96 */
struct connectib_icmd_access_icm_ctx {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_golan_hw_fw_ctx ctx;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 64.15 */
	 u_int16_t gvmi;
	/* Description -  */
	/* 64.31 - 68.31 */
	 u_int8_t rw_;
/*---------------- DWORD[17] (Offset 0x44) ----------------*/
	/* Description - 0x5f MTT
 0x01 SQ_QP_LIST_REQ
 0x02 SQ_QP_LIST_RES
 0x03 BSF
 0x04 RDB
 0x05 EXT_RDB
 0x06 ICM_CRC
 0x07 QP_COMMON
  0x08 REQUESTOR_QPC
 0x09 RESPONDER_QPC
 0x0a MKEY
 0x0b SRQ
 0x0c CQ
 0x0d TRANS_STATUS_BSF
 0x0e TRANS_STATUS_KLM
 0x0f PSV
  0x10 EXT_PSV
 0x11 SXDC
 0x12 PIPA
 0x13 TIMER
 0x15 EQ
 0x16 MSIX
 0x17 SXD_GVMI_RATE_LIMITER
 0x18 PORT0_PKEY
 0x19 PORT0_GUID
  0x1a PORT0_INFO
 0x1b PORT0_COUNTERS_GVMI_RX
 0x1c PORT1_PKEY
 0x1d PORT1_GUID
 0x1e PORT1_INFO
 0x1f PORT1_COUNTERS_GVMI_RX
  0x20 STEERING
 0x21 LDB_CACHE
 0x22 REQ_SL_CACHE
 0x23 IRISC
 0x24 SCRATCHPAD
 0x25 SQ_POINTERS
 0x26 SQ_TOKENS
 0x27 TOC
  0x28 FW_GVMI_CTX
 0x29 FW_QPC
 0x2a FW_MALLOC
 0x2b FW_PD
 0x2c FW_UAR
 0x2d FW_EQ
 0x2e FW_CQ
 0x2f FW_MKEY
 0x30 FW_SRQ
  0x31 FW_GLOBAL
 0x32 FW_SQ
 0x33 GLOBAL_FW_GVMI_CTX
 0x34 FW_ALT_PATH
 0x36 COUNTERS_QP_RX
 0x36 PORT0_COUNTERS_GVMI_SX
  0x37 PORT1_COUNTERS_GVMI_SX
 0x38 FW_LL_QP_REQ
 0x39 FW_LL_QP_RES
 0x3a  FW_LL_CQ_OVERRUN
 0x3b FW_LL_EQ_OVERRUN_CQ
  0x3c FW_LL_EQ_OVERRUN_EQ
 0x3d EQ_OVERRUN_LIST_META
 0x3e ICM_RES_FW_XRCD
 0x3f ICM_RES_FW_FREE_LIST
 0x4e COUNTERS_QP_SX */
	/* 68.0 - 68.15 */
	 u_int16_t ctx_type;
/*---------------- DWORD[18] (Offset 0x48) ----------------*/
	/* Description -  */
	/* 72.0 - 80.31 */
	 u_int64_t ctx_num;
/*---------------- DWORD[20] (Offset 0x50) ----------------*/
	/* Description - second index - for reading RDB */
	/* 80.0 - 84.31 */
	 u_int32_t ctx_num2;
};

/* Description -   */
/* Size in bytes - 768 */
struct connectib_icmd_cmd_as_dwords {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 768.31 */
	 u_int32_t dword[192];
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_64b {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t checksum;
	/* Description -  */
	/* 8.16 - 12.31 */
	 u_int16_t rsvd_3;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t ip_status;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 16.15 */
	 u_int16_t slid_smac_47_32;
	/* Description -  */
	/* 16.16 - 20.31 */
	 u_int16_t vlan_ml_path;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t slid_smac_31_0;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.23 */
	 u_int32_t rqpn;
	/* Description -  */
	/* 24.24 - 24.27 */
	 u_int8_t sl_vlan_type;
	/* Description -  */
	/* 24.28 - 24.29 */
	 u_int8_t g;
	/* Description -  */
	/* 24.30 - 24.30 */
	 u_int8_t fl;
	/* Description -  */
	/* 24.31 - 28.31 */
	 u_int8_t rsvd_bit;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t rss_val;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.23 */
	 u_int32_t srq_num;
	/* Description -  */
	/* 32.24 - 36.31 */
	 u_int8_t rsvd_1;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t imm_inv_key;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t rsvd_0;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t byte_count;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t timestamp_h;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 u_int32_t timestamp_l;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 56.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 56.24 - 60.31 */
	 u_int8_t swqe_opcode_drop_cntr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 60.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 60.1 - 60.1 */
	 u_int8_t se;
	/* Description -  */
	/* 60.2 - 60.3 */
	 u_int8_t inline_scatter;
	/* Description -  */
	/* 60.4 - 60.7 */
	 u_int8_t rwqe_opcode;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 60.16 - 64.31 */
	 u_int16_t wqe_counter;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_grh_inline_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 u_int32_t grh_inline_data[16];
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_eth_segment {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.13 */
	 u_int16_t mss;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t l3cs_inner;
	/* Description -  */
	/* 4.29 - 4.29 */
	 u_int8_t l4cs_inner;
	/* Description -  */
	/* 4.30 - 4.30 */
	 u_int8_t l3cs;
	/* Description -  */
	/* 4.31 - 8.31 */
	 u_int8_t l4cs;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t inline_headers;
	/* Description -  */
	/* 12.16 - 12.25 */
	 u_int16_t inline_header_size;
};

/* Description -   */
/* Size in bytes - 4 */
struct connectib_wqe_inline_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.9 */
	 u_int16_t byte_count;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t wqe_inline;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_gather_scatter_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.30 */
	 u_int32_t byte_count;
	/* Description -  */
	/* 0.31 - 4.31 */
	 u_int8_t wqe_inline;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t local_key;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t local_address_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t local_address_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_srq_next {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.15 */
	 u_int16_t next_wqe_index;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_signature {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.24 - 8.31 */
	 u_int8_t signature;
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_wqe_extended_atomic_fetch_add {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_4byte byte4;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_8byte byte8;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_16byte byte16;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_32byte byte32;
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_64byte byte64;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_wqe_extended_atomic_fetch_add_128byte byte128;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_atomic_fetch_add {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t add_data_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t add_data_31_0;
};

/* Description -   */
/* Size in bytes - 512 */
union connectib_wqe_extended_atomic_cmp_swap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_4byte byte4;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_8byte byte8;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_16byte byte16;
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_32byte byte32;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_64byte byte64;
	/* Description -  */
	/* 0.0 - 512.31 */
	 struct connectib_wqe_extended_atomic_cmp_swap_128byte byte126;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_atomic_cmp_swap {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t swap_data_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t swap_data_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t compare_data_63_32;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t compare_data_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_rdma_read {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t remote_virtual_address_63_32;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t remote_virtual_address_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t remote_key;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_wqe_address_vector_ext {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.0 */
	 u_int8_t auto_1;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.0 */
	 u_int8_t auto_2;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.7 */
	 u_int8_t hop_limit;
	/* Description -  */
	/* 8.8 - 8.15 */
	 u_int8_t tclass;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.19 */
	 u_int32_t flow_label;
	/* Description -  */
	/* 12.20 - 12.27 */
	 u_int8_t my_gid_index1;
	/* Description -  */
	/* 12.30 - 12.30 */
	 u_int8_t grh;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t rgid_127_96;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t rgid_95_64;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t rgid_63_32;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t rgid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_address_vector_basic {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t dca_key_63_32_qkey;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t dca_key_31_0;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.23 */
	 u_int32_t destination_qp_dct;
	/* Description - Used only in DC. Sent in "Connect" packet. */
	/* 8.24 - 8.27 */
	 u_int8_t reverse_sl;
	/* Description - Ext=1:AV global extension exist. Ext=0:AV global extension doesn't exist. */
	/* 8.31 - 12.31 */
	 u_int8_t ext;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 12.15 */
	 u_int16_t rlid_15_0;
	/* Description -  */
	/* 12.16 - 12.23 */
	 u_int8_t slid;
	/* Description -  */
	/* 12.24 - 12.27 */
	 u_int8_t sl;
	/* Description -  */
	/* 12.28 - 16.31 */
	 u_int8_t static_rate;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_xrc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.23 */
	 u_int32_t xrc;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_mlx {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.16 - 4.19 */
	 u_int8_t sl;
	/* Description -  */
	/* 4.20 - 4.23 */
	 u_int8_t static_rate;
	/* Description - Force loopback
0-packet is sent to loopback\serdes according to Loopback Resolution
1-packet is sent to loopback only (used for opening QP's between application on the same guest before SM gives the link layer the LID) */
	/* 4.26 - 4.26 */
	 u_int8_t fl;
	/* Description - 1 - Don't add ICRC (raw packet, or ICRC calculated by driver)
0 - Replace last DW with ICRC */
	/* 4.27 - 4.27 */
	 u_int8_t ic;
	/* Description -  */
	/* 4.28 - 4.28 */
	 u_int8_t fc;
	/* Description - SLID MSB taken from:
0-(PortInfo - Per GVMI,Port)
1-packetSLID MSB taken from:
0-(PortInfo - Per GVMI,Port)
1-packet */
	/* 4.29 - 4.29 */
	 u_int8_t slr;
	/* Description -  */
	/* 4.30 - 4.30 */
	 u_int8_t vl15;
	/* Description - When set VLAN should 
be transmitted with VLAN.
(Inserted if no vlan in the packet/ replaced by WQE.VLAN if vlan exists)


Ethertype is a configuration.
VLAN_ID is located in VLAN */
	/* 4.31 - 8.31 */
	 u_int8_t v;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 8.15 */
	 u_int16_t dmac_dlid_47_32;
	/* Description - VLAN to add to the packet. */
	/* 8.16 - 12.31 */
	 u_int16_t vlan;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t dmac_dlid_31_0;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_wqe_control {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 0.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 0.8 - 0.23 */
	 u_int16_t wqe_index;
	/* Description -  */
	/* 0.24 - 4.31 */
	 u_int8_t opc_mod;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - WQE size in octwords (16 byte)
needed only for gather list size
valid values: 1-63 */
	/* 4.0 - 4.5 */
	 u_int8_t ds;
	/* Description -  */
	/* 4.8 - 8.31 */
	 u_int32_t qpn;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - interrupt bit */
	/* 8.0 - 8.0 */
	 u_int8_t interrupt;
	/* Description - solicited event  */
	/* 8.1 - 8.1 */
	 u_int8_t se;
	/* Description - CQE and EQE control
00 - generate CQE only on error WQE completion. (note - per IB spec, if completion with error, generate event)
01 - No CQE, No EQE (even on error)
10 - Gen CQE on WQE completion (good or bad)
11 - Gen CQE and EQE (loccal Solicited event).
 */
	/* 8.2 - 8.3 */
	 u_int8_t ce;
	/* Description - nop bit
no supported in golan
 */
	/* 8.4 - 8.4 */
	 u_int8_t nop;
	/* Description - fence mode
000 - No Fence
001 - Initiator Small Fence.
Wait as long as there are WQEs that are currently locally in execution (doing gather / memop etc.)
010 - Fence - the WQE will start execution only after all previous Read/Atomic WQEs complete.
011 - Strong Ordering - when set, the WQE will be executed only after all previous WQEs have been executed. Can be set for RC WQEs only. .
100 - Fence and Initiator Small Fence.
101-111 - reserved */
	/* 8.5 - 8.7 */
	 u_int8_t fm;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t immediate_invalidation_key;
};

/* Description -   */
/* Size in bytes - 65536 */
struct connectib_nv_data {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_nv_config_header header;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_hw_boot_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Address on flash of manufacturing info */
	/* 0.0 - 0.23 */
	 u_int32_t manufacture_info_address;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Address on flash of read only manufacturing info */
	/* 4.0 - 4.23 */
	 u_int32_t ro_manufacture_info_address;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - Address on flash of VPD info, copy 1 */
	/* 8.0 - 8.23 */
	 u_int32_t vpd_info_address_1;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - Address on flash  of VPD info, copy 2 */
	/* 12.0 - 12.23 */
	 u_int32_t vpd_info_address_2;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Describes info about the vpd */
	/* 16.0 - 24.31 */
	 struct connectib_vpd_eeprom_info vpd_eeprom;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - used to enable hw tracer for code coverage */
	/* 24.0 - 32.31 */
	 struct connectib_code_coverage_control code_coverage;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 224.31 */
	 struct connectib_pcie_cfg_golan pcie_cfg;
/*---------------- DWORD[56] (Offset 0xe0) ----------------*/
	/* Description -  */
	/* 224.0 - 256.31 */
	 struct connectib_fw_image fw_image;
};

/* Description -   */
/* Size in bytes - 2816 */
struct connectib_hw_main_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 1792.31 */
	 struct connectib_port_serdes ports_serdes;
/*---------------- DWORD[448] (Offset 0x700) ----------------*/
	/* Description -  */
	/* 1792.0 - 1808.31 */
	 struct connectib_power power;
/*---------------- DWORD[452] (Offset 0x710) ----------------*/
	/* Description -  */
	/* 1808.0 - 1812.31 */
	 struct connectib_system_mng system_mng;
/*---------------- DWORD[453] (Offset 0x714) ----------------*/
	/* Description -  */
	/* 1812.0 - 1820.31 */
	 struct connectib_thermal_config_golan thermal;
/*---------------- DWORD[480] (Offset 0x780) ----------------*/
	/* Description -  */
	/* 1920.0 - 1928.31 */
	 struct connectib_module_config module;
/*---------------- DWORD[482] (Offset 0x788) ----------------*/
	/* Description - Board I2C information */
	/* 1928.0 - 2008.31 */
	 struct connectib_i2c_devices_db i2c;
/*---------------- DWORD[502] (Offset 0x7d8) ----------------*/
	/* Description - Board GPIO information */
	/* 2008.0 - 2140.31 */
	 struct connectib_ini_gpios_golan gpios;
};

/* Description -   */
/* Size in bytes - 1152 */
struct connectib_fw_boot_config {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_FW_VERSION fw_version;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - All multi_function pconfigurable parameters */
	/* 16.0 - 28.31 */
	 struct connectib_multi_function multi_function;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - All Transaction Layer flags */
	/* 28.0 - 32.31 */
	 struct connectib_pcie_transaction pcie_transaction;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description - PCIe cfg space data */
	/* 32.0 - 544.31 */
	 struct connectib_pci_cfg pcie_cfg_data;
/*---------------- DWORD[136] (Offset 0x220) ----------------*/
	/* Description - PCIe cfg space for masking */
	/* 544.0 - 1056.31 */
	 struct connectib_pci_cfg pcie_cfg_mask;
/*---------------- DWORD[264] (Offset 0x420) ----------------*/
	/* Description - PF/SR pciex data */
	/* 1056.0 - 1084.31 */
	 struct connectib_pf_vf_cfg_space pf_vf_cfg_data;
/*---------------- DWORD[271] (Offset 0x43c) ----------------*/
	/* Description - power management (L1) configuration */
	/* 1084.0 - 1088.31 */
	 struct connectib_pcie_power_management pcie_power_management;
/*---------------- DWORD[272] (Offset 0x440) ----------------*/
	/* Description - data later to be overridden by NV config */
	/* 1088.0 - 1152.31 */
	 struct connectib_nv_config_boot nv_config;
};

/* Description -   */
/* Size in bytes - 1776 */
struct connectib_fw_main_config {
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 4.2 */
	 u_int8_t log_max_num_rdbs;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_static_config static_config;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 192.31 */
	 struct connectib_leds_blink_patterns leds_blink_pattern;
/*---------------- DWORD[48] (Offset 0xc0) ----------------*/
	/* Description -  */
	/* 192.0 - 256.31 */
	 struct connectib_customization customization;
/*---------------- DWORD[64] (Offset 0x100) ----------------*/
	/* Description -  */
	/* 256.0 - 512.31 */
	 struct connectib_management management;
/*---------------- DWORD[128] (Offset 0x200) ----------------*/
	/* Description -  */
	/* 512.0 - 588.31 */
	 struct connectib_host_management host_management;
/*---------------- DWORD[208] (Offset 0x340) ----------------*/
	/* Description -  */
	/* 832.0 - 1520.31 */
	 struct connectib_phy_fw_main_config phy_fw_main_config;
/*---------------- DWORD[380] (Offset 0x5f0) ----------------*/
	/* Description - data later to be overridden ny NV config */
	/* 1520.0 - 1776.31 */
	 struct connectib_nv_config_main nv_config;
};

/* Description -   */
/* Size in bytes - 320 */
struct connectib_mfg_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.24 - 16.23 */
	 char psid[17];
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - When this bit is set, the GUIDs should be taken from the device_info node.
When this bit is cleared, the GUIDs should be taken from the mfg_info node. */
	/* 28.0 - 28.0 */
	 u_int8_t guids_override_en;
	/* Description - MFG_INFO section minor version */
	/* 28.16 - 28.23 */
	 u_int8_t minor_version;
	/* Description - MFG_INFO section major version */
	/* 28.24 - 32.31 */
	 u_int8_t major_version;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 96.31 */
	 struct connectib_guids guids;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_image_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - IMAGE_INFO section minor version */
	/* 0.16 - 0.23 */
	 u_int8_t minor_version;
	/* Description - IMAGE_INFO section major version */
	/* 0.24 - 4.31 */
	 u_int8_t major_version;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 20.31 */
	 struct connectib_FW_VERSION FW_VERSION;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 28.31 */
	 struct connectib_TRIPPLE_VERSION mic_version;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.24 - 52.23 */
	 char psid[17];
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 52.15 */
	 u_int16_t vsd_vendor_id;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.24 - 264.23 */
	 char vsd[209];
/*---------------- DWORD[66] (Offset 0x108) ----------------*/
	/* Description - image size parameters */
	/* 264.0 - 272.31 */
	 struct connectib_image_size image_size;
/*---------------- DWORD[70] (Offset 0x118) ----------------*/
	/* Description - HW device(s) supported by this FW image.
0 means invalid entry.
For Golan A0, first entry should be 0x1ff
 */
	/* 280.0 - 296.31 */
	 u_int32_t supported_hw_id[4];
/*---------------- DWORD[74] (Offset 0x128) ----------------*/
	/* Description -  */
	/* 296.0 - 300.31 */
	 u_int32_t ini_file_num;
/*---------------- DWORD[112] (Offset 0x1c0) ----------------*/
	/* Description - Product Version is the unified version of the FW and expansion ROM.
Format is defined by the packager.
When set to a non-empty string the FW update tool burns the image as a monolythic entity and refuses to update rom only or FW only. */
	/* 448.24 - 464.23 */
	 char prod_ver[17];
/*---------------- DWORD[192] (Offset 0x300) ----------------*/
	/* Description -  */
	/* 768.0 - 832.31 */
	 struct connectib_module_versions module_versions;
};

/* Description -   */
/* Size in bytes - 512 */
struct connectib_device_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t signature0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t signature1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t signature2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t signature3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Format version for this struct */
	/* 16.0 - 16.7 */
	 u_int8_t minor_version;
	/* Description - Format version for this struct */
	/* 16.8 - 16.16 */
	 u_int16_t major_version;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 96.31 */
	 struct connectib_guids guids;
/*---------------- DWORD[27] (Offset 0x6c) ----------------*/
	/* Description -  */
	/* 108.0 - 108.15 */
	 u_int16_t vsd_vendor_id;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 112.24 - 320.23 */
	 char vsd[209];
/*---------------- DWORD[88] (Offset 0x160) ----------------*/
	/* Description -  */
	/* 352.0 - 416.31 */
	 struct connectib_operation_key keys[4];
};

/* Description -   */
/* Size in bytes - 256 */
union connectib_dtoc_pointers {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_toc_data device_info_0;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_toc_data nv_data_0;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_toc_data nv_data_1;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_toc_data fw_nv_log;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_toc_data mfg_info;
};

/* Description -   */
/* Size in bytes - 256 */
struct connectib_reset_info {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - capability mask for reset database */
	/* 0.0 - 4.31 */
	 struct connectib_reset_capabilities rst_cap_mask;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - versions for data structures that need to be maintained acrros different reset levels */
	/* 16.0 - 144.31 */
	 struct connectib_rst_api_ver rst_api_ver;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_boot_record_golan {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - SPI clock frequenct equal = E1ClockFreq / (2*(n+1))
where n is is value of this register */
	/* 0.0 - 0.3 */
	 u_int8_t flash_div;
	/* Description - Set default to 0 (hot_reset request from px will be ignored) as WA for HW BUG #170316 (serdes power toggles during reset from px). */
	/* 0.4 - 0.4 */
	 u_int8_t hot_reset_enable;
	/* Description - after pll stabilization (timer), the boot machine will wait till core pll lock indication before continuing */
	/* 0.5 - 0.5 */
	 u_int8_t wait_lock;
	/* Description - 0 - disable.
1 - iopx will be powered down while perst is asserted.
2 - all_reset will be triggered upon perst change. */
	/* 0.6 - 0.7 */
	 u_int8_t perst_action;
	/* Description - CoreFreq = PadFreq * 2(F+1) / ((R+1)*(2^OD)) */
	/* 0.8 - 0.14 */
	 u_int8_t core_f;
	/* Description - core PLL PowerDown */
	/* 0.16 - 0.16 */
	 u_int8_t core_pd;
	/* Description -  */
	/* 0.17 - 0.18 */
	 u_int8_t core_od;
	/* Description -  */
	/* 0.19 - 0.23 */
	 u_int8_t core_r;
	/* Description - Core PLL bypass.
When set, pad and core clock are the same.

default is 0 */
	/* 0.24 - 0.24 */
	 u_int8_t core_bypass;
	/* Description - When set, core PLL input comes from PCIe ref clock.
When cleared, core PLL input comes from CCLK pad.

For live-fish, PCIe clock is used, and we are confident 
that the clock used will be 100MHz thus we can set default 
value to the PLL.

On functional mode, this bit is taken from flash with the 
correctPLL parameters thus any oscillator can be used 
for CCLK */
	/* 0.25 - 0.25 */
	 u_int8_t core_from_pex;
	/* Description - Reserved for parity bit from the flash */
	/* 0.31 - 4.31 */
	 u_int8_t parity_reserved0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - Bit per thermal diode, when one of the termal diodes is too hot and masked, the GPIO will be set.
bit[0]: A2D in Iopx (px)
bit[1]: A2D in Iop
bit[2]: A2D in Yu
 */
	/* 4.14 - 4.16 */
	 u_int8_t temp_gpio_mask;
	/* Description - Bit per thermal diode, when one of the termal diodes is too hot and masked, chip will enter FATAL.
bit[0]: A2D in Iopx (px)
bit[1]: A2D in Iop
bit[2]: A2D in Yu */
	/* 4.18 - 4.20 */
	 u_int8_t temp_fatal_mask;
	/* Description - bit[0] gpio weak pull (up/down) enable together with gpio_pull_enable
bit[1] jtag weak pull up/down enable */
	/* 4.22 - 4.23 */
	 u_int8_t gpio_pull_en;
	/* Description - //Choose which PLL to debug: lock on GPIO21 and clock on GPIO22
//[3:0] debug_pll_id
// 0-0000 - the PAD are controled by the regular GPIO logic
// 1-0001 - iop0 clock 0
// 2-0010 - iop0 clock 1
// 3-0011 - iop0 clock 3
// 4-0100 - iop0 clock 2
// 5-0101 - iop1 clock 0 (NA)
// 6-0110 - iop1 clock 1 (NA)
// 7-0111 - iop1 clock 3 (NA)
// 8-1000 - iop1 clock 2 (NA)
// 9-1001 - iotg clock 0
//10-1010 - iotg clock 1
//11-1011  -pll input pin : FIN 
//12-1100 - pll output pin : FOUT 
//13-1101 - i1clk //same clock which go to the core
//14-1110 - pll2 output pin : FOUT (i2clk) (NA)
//15-1111 - muxed_clock before the bypass muxes (NA)


//[6:4] debug_pll_id
//000 - div by 1
//001 - div by 2
//010 - div by 4
//011 - div by 8 
//100- div by 16
//101- div by 64
//110 - div by 128
//111 - div by 256
 */
	/* 4.24 - 4.30 */
	 u_int8_t pll_debug;
	/* Description - Reserved for parity bit from the flash */
	/* 4.31 - 8.31 */
	 u_int8_t parity_reserved1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 2^mbist_group_size wrappers will run simultaniously
values 15-9 are reserved - does not work */
	/* 8.0 - 8.3 */
	 u_int8_t mbist_group_size;
	/* Description - 2^mbist_unit_size units will run simultaniously */
	/* 8.4 - 8.6 */
	 u_int8_t mbist_unit_size;
	/* Description - Enable MBIST run */
	/* 8.8 - 8.8 */
	 u_int8_t mbist_en;
	/* Description - adds (2^x - 1) relax cycles between captures of different units */
	/* 8.13 - 8.15 */
	 u_int8_t lbist_capture_delay;
	/* Description -  */
	/* 8.16 - 8.22 */
	 u_int8_t i2c_slave_addr;
	/* Description - i2c slave enable */
	/* 8.23 - 8.23 */
	 u_int8_t i2c_slave_en;
	/* Description - value 0 will disabe yu_fuse read/write requests to reach the fuse (in case Fuse is malfunctioning).
upon reads, data recieved will be hard wired zeros.
upon write, efuse_done will rise after 1 cycle. */
	/* 8.24 - 8.24 */
	 u_int8_t fuse_enable;
	/* Description - the boot machine will wait 2^(this value) e1clk
need to wait for 200us between power_down fall and pxp.port_state move to detect
With clock of 156.25Mhz this gives = 31,250 clocks ~ 2^15
With clock of 78.125Mhz this will give = 400us (which is much less than PCIe constrain of 20ms)

As a margin we config to 0x11 (1.6ms with 78.125Mhz oscilator)
 */
	/* 8.26 - 8.30 */
	 u_int8_t pll_stabilize;
	/* Description - Reserved for parity bit from the flash */
	/* 8.31 - 12.31 */
	 u_int8_t parity_reserved2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - logic bist pattern count (LSB)
MSB is in the extended boot record
When {MSB,LSB}=0 lbist will run 2^32 patterns */
	/* 12.0 - 12.15 */
	 u_int16_t lbist_pat_cnt_lsb;
	/* Description - value is the number of captures per pattern
value=0 means no capture state at all.
last pattern is controled by lbist_capture_last */
	/* 12.19 - 12.21 */
	 u_int8_t lbist_capture;
	/* Description - at each capture 2 selected units work together for gaining full chip coverage */
	/* 12.22 - 12.22 */
	 u_int8_t lbist_capt_2;
	/* Description - shift cycle every corepll clocks:
f = 2^x (f = 1,2,4,8,..,128)
0-1, 1-2, 2-4, 3-8... */
	/* 12.23 - 12.25 */
	 u_int8_t lbist_shift_clk_divider;
	/* Description - same as lbist_capture but only for the last pattern, part of the stop function.
value must be > 0 */
	/* 12.27 - 12.29 */
	 u_int8_t lbist_capture_last;
	/* Description - Logic BIST enable */
	/* 12.30 - 12.30 */
	 u_int8_t lbist_en;
	/* Description - Reserved for parity bit from the flash */
	/* 12.31 - 16.31 */
	 u_int8_t parity_reserved3;
};

/* Description -   */
/* Size in bytes - 16 */
struct connectib_icmd_ctrl {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Protection against accidently writing to contexts
To enable write 0xBADC0FFE */
	/* 0.0 - 4.31 */
	 u_int32_t destructive_op_unlock;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - from the function */
	/* 4.0 - 4.15 */
	 u_int16_t gvmi;
	/* Description - when set limited icmd are supported */
	/* 4.16 - 4.16 */
	 u_int8_t public_icmd;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - set by user, cleared by firmware */
	/* 12.0 - 12.0 */
	 u_int8_t busy;
	/* Description -  0x00 OK
 0x01 INVALID_OPCODE
 0x02 INVALID_CMD
 0x03 OPERATIONAL_ERROR
 0x04 BAD_PARAM
 0x05 BUSY */
	/* 12.8 - 12.15 */
	 u_int8_t status;
	/* Description -     0x1000 = ICMD_OPCODE_MNG_MMINIT
  0x6001 = ICMD_OPCODE_PHY_UC_DO_CONTINUE
  0x6002 = ICMD_OPCODE_PHY_UC_DO_STEP
  0x6003 =  ICMD_OPCODE_PHY_UC_SET_DEL_BP
  0x6004 = ICMD_OPCODE_PHY_UC_SET_GET_DATA
  0x6005 = ICMD_OPCODE_PHY_UC_GET_ARRAY_PROP
  0x6006 = ICMD_OPCODE_PHY_UC_GET_STATUS
  0x6007 = ICMD_OPCODE_PHY_ACTIVATE_RX_ADAP
  0x6008 = ICMD_OPCODE_PHY_UC_SET_GET_DATA_FIELD
  0x6009 = ICMD_OPCODE_PHY_UC_ACTIVATE_UC
  0x600b = ICMD_OPCODE_PHY_GET_LINK_STATUS
  0x600c = ICMD_OPCODE_PHY_OPEN_CLOSE_PORT
  0x600d = ICMD_OPCODE_PHY_PLL_VARACTOR_CALIB
  0x600e = ICMD_OPCODE_PHY_HALT_FSM
  0x600f = ICMD_OPCODE_PHY_SET_GET_TX_SD
  0x6010 = ICMD_OPCODE_PHY_SET_GET_RX_SD
  0x6011 = ICMD_OPCODE_PHY_TRANS_OR_SYNC
  0x6013 = ICMD_OPCODE_PHY_GET_CLEAR_COUNTERS
  0x6014 = ICMD_OPCODE_PHY_UPDATE_CALIB_VALS
  0x6015 = ICMD_OPCODE_PHY_GET_GRADE_INFO
  0x6016 = ICMD_OPCODE_PHY_SET_GET_PTAS
  0x6017 = ICMD_OPCODE_PHY_GET_PPAMP
  0x6018 = ICMD_OPCODE_PHY_GET_PPLL
  0x6019 = ICMD_OPCODE_PHY_GET_PPDDB
  0x8000 = ACCESS_ICM_LINE
  0x8001 = ACCESS_ICM_CTX
  0x8002 = ACCESS_HOST_MEM
  0x8003 = READ_Q_ENTRY
  0x8004 = GET_IRISC_HEAR_BEAT
  0x8005 = GET_BOOT_STAGE
  0x8006 = GET_LINK_LEDS
  0x8007 = GET_FW_VERSION
  0x8008 = READ_RX_SLICE_PACKET
  0x8009 = READ_G_RSE_SLICE_DESC
  0x8010 = READ_SX_WQ_BUFFER
  0x8011 = READ_ICM_TLB_LINE
  0x8012 = READ_ICM_DUMMY_ADDRESS
  0x8013 = DEBUG_FW_TRACER
  0x8014 = CABLE_PLUG_OUT_IN
  0x8015 = GET_ICM_RES_PROP
  0x8017 = GET_ICM_CTX_ADDR
  0x8018 = CHECK_SQPC_STATUS
  0x8019 = ALLOC_DEALLOC_RESOURCE
  0x801a = LOCK_UNLOCK
  0x801b = ICMD_DB_RECOVERY
  0x801c = ICMD_READ_ICMC_TAG
  0x801d = ICMD_DC_PARAMS (LEGACY - deprecated!)
  0x8020 = ICMD_RW_GVMIX
  0x8021 = ICMD_ICMC_LOCKED_HISTOGRAM
  0x8022 = ICMD_DC_CONFIG
  0x8023 = ICMD_OPCODE_PUSH_DB
  0x8024 = GET_OPEN_RESOURCES
  0x8025 = RW_ESW
  0x8026 = ACCESS_REG_PMTU
  0x8027 = ICMD_OPCODE_ACCESS_REGISTER_PAOS
  0x8028 = ACCESS_REG_PPCNT
  0x8029 = ACCESS_REG_PTYS
  0x8030 = ICMD_OPCODE_ACCESS_REGISTER_SLRP
  0x8031 = ICMD_OPCODE_ACCESS_REGISTER_SLTP
  0x8032 = ICMD_OPCODE_ACCESS_REGISTER_SLRG
  0x8033 = ICMD_OPCODE_ACCESS_REGISTER_PTAS
  0x8034 = ICMD_OPCODE_ACCESS_REGISTER_PPAMP
  0x802a = ACCESS_REG_PVLC
  0x8100 = DEBUG_PRINT_ICM
  0x8101 = GET_HEADER_CAPTURE
  0x8200 = ICMD_OPCODE_SET_GET_PORT_CNTR
  0x8201 = ICMD_OPCODE_GET_PF_CTX
  0x8300 = GET_FT_LIST
  0x8301 = GET_FT_INFO
  0x8302 = GET_FG_LIST
  0x8303 = GET_FG
  0x8304 = GET_FTE_LIST
  0x8305 = GET_FTE
  0x8306 = GET_STE_OPEN_RESOURCES
  0x8307 = GET_STE_RESOURCES_LIST
  0x8308 = READ_STE
  0x9001 = FLASH_REG_ACCESS
  0xa000 = FW_SW_RESET
  0xb000 = READ_COMMAND
  0xa004 = ICMD_OPCODE_PMAOS_WRITE
  0xa005 = ICMD_OPCODE_PMAOS_QUERY
  0xc000 = READ_EQ4TYPE
  0xc001 = READ_SPECIAL_QPS
  0xc002 = SET_PORT_SNIFFER
  0xc003 = GET_PORT_SNIFFER
  0xc004 = ICMD_OPCODE_WRITE_CC_LOG
  0xc005 = ICMD_OPCODE_CONFIG_CC
  0xc006 = ICMD_OPCODE_WRITE_DC_CNAK_LID
  0xf000 = ICMD_OPCODE_PHY_NEGO_CTRL
  0xf001 = ICMD_OPCODE_EYE_OPENER_READ
  0xf002 = CLEAR_RXT_CHK_CAUSES
  0xf003 = SET_ITRACE
  0xf004 = ICMD_OPCODE_INIT_OCSD
  0xf005 = ICMD_OPCODE_PHY_VER_OVERWRITE
  0xf006 = ICMD_OPCODE_PCIE_TOOLS_POINTERS
  0xf007 = ICMD_OPCODE_CODE_COVERAGE
  0xf008 = ICMD_OPCODE_CODE_COVERAGE_READ
  0xf00b = ICMD_STOP_TOGGLER
  0xf010 = ICMD_OPCODE_GREPPER
  0xf011 = ICMD_OPCODE_STANDBY
  0xf012 = ICMD_OPCODE_FLR_DEBUG
  0xf013 = ICMD_OPCODE_DCR_LL_TRVRS
  0xf014 = ICMD_OPCODE_NEXT_DCR
  0xf015 = ICMD_OPCODE_GENERAL_FAULT_INJECTOR
  0xf016 = ICMD_OPCODE_ACCESS_STEERING_ROOT
  0xf017 = ICMD_OPCODE_GET_STEERING_TABLE_INFO
  0xf018 = ICMD_OPCODE_GET_GVMI_VIA_VSEC
  0xa100 = ICMD_OPCODE_SMBUS_MASTER_ACCESS
  0xa102 = ICMD_OPCODE_MNG_SMBUS_GW_FREQ
  0xff60 = ICMD_OPCODE_CABLE_INFO
  0xff61 = ICMD_OPCODE_GEN_ASSERT  */
	/* 12.16 - 16.31 */
	 u_int16_t opcode;
};

/* Description -   */
/* Size in bytes - 768 */
union connectib_icmd_cmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_cmd_as_dwords as_dwords;
	/* Description -  */
	/* 0.0 - 96.31 */
	 struct connectib_icmd_access_icm_ctx access_icm_ctx;
	/* Description -  */
	/* 0.0 - 80.31 */
	 struct connectib_icmd_access_icm_line access_icm_line;
	/* Description -  */
	/* 0.0 - 288.31 */
	 struct connectib_icmd_access_host_mem access_host_mem;
	/* Description -  */
	/* 0.0 - 524.31 */
	 struct connectib_icmd_read_q_entry read_q_entry;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_icmd_get_irisc_heart_beat get_irisc_heart_beat;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_icmd_get_boot_stage get_boot_stage;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_icmd_get_link_leds get_link_leds;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_icmd_get_fw_info get_fw_info;
	/* Description -  */
	/* 0.0 - 524.31 */
	 struct connectib_icmd_read_rx_slice_packet read_rx_slice_packet;
	/* Description -  */
	/* 0.0 - 264.31 */
	 struct connectib_icmd_read_g_rse_slice_desc read_g_rse_slice_desc;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_icmd_fw_reset fw_reset;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_print_icm debug_print_icm;
	/* Description -  */
	/* 0.0 - 192.31 */
	 struct connectib_icmd_header_capture header_capture;
	/* Description -  */
	/* 0.0 - 72.31 */
	 struct connectib_icmd_read_sx_wq_buffer read_sx_wq_buffer;
	/* Description -  */
	/* 0.0 - 72.31 */
	 struct connectib_icmd_access_cmdq icmd_access_cmdq;
	/* Description -  */
	/* 0.0 - 260.31 */
	 struct connectib_eqn4type eqn4type;
	/* Description -  */
	/* 0.0 - 260.31 */
	 struct connectib_icmd_special_qps special_qps;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_set_port_sniffer set_port_sniffer;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_port_sniffer get_port_sniffer;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_icmd_congestion_log congestion_log;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_icmd_write_dc_cnak_lid write_dc_cnak_lid;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_config_cc config_cc;
	/* Description -  */
	/* 0.0 - 80.31 */
	 struct connectib_icmd_read_icm_tlb_line read_icm_tlb_line;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_icmd_read_icm_dummy_addr read_icm_dummy_addr;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_get_open_resources get_open_resources;
	/* Description -  */
	/* 0.0 - 48.31 */
	 struct connectib_icmd_debug_fw_tracer debug_fw_tracer;
	/* Description -  */
	/* 0.0 - 512.31 */
	 struct connectib_icmd_grepper grepper;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_icmd_standby standby;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_icmd_cable_plug_out_in cable_plug_out_in;
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_icmd_cable_info cable_info;
	/* Description -  */
	/* 0.0 - 36.31 */
	 struct connectib_icmd_get_icm_res_prop get_icm_res_prop;
	/* Description -  */
	/* 0.0 - 24.31 */
	 struct connectib_icmd_alloc_dealloc_resource alloc_dealloc_resource;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_eye_opening_read_st eye_opening_read;
	/* Description -  */
	/* 0.0 - 4.31 */
	 struct connectib_phy_nego_ctrl_st phy_nego_ctrl;
	/* Description -  */
	/* 0.0 - 24.31 */
	 struct connectib_icmd_get_icm_ctx_addr get_icm_ctx_addr;
	/* Description -  */
	/* 0.0 - 160.31 */
	 struct connectib_reg_access_ext_cmd access_register;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_check_sqpc_status check_sqpc_status;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_lock_unlock_resource lock_unlock_resource;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_check_sqpc_status db_recovery;
	/* Description -  */
	/* 0.0 - 80.31 */
	 struct connectib_icmd_access_icm_line read_icmc_tag;
	/* Description - configures all params. if only one params change is required - perform read modify write */
	/* 0.0 - 32.31 */
	 struct connectib_icmd_dc_params dc_params;
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_icmd_dc_config dc_config;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_itrace set_itrace;
	/* Description -  */
	/* 0.0 - 12.31 */
	 struct connectib_icmd_init_ocsd init_ocsd;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_icmd_phy_ver_overwrite phy_ver_overwrite;
	/* Description - pointers to some tables in pciex scratchpad, for tools usage */
	/* 0.0 - 64.31 */
	 struct connectib_pcie_tools_pointers pcie_tools_pointers;
	/* Description -  */
	/* 0.0 - 80.31 */
	 struct connectib_icmd_gen_eqe gen_eqe;
	/* Description -  */
	/* 0.0 - 128.31 */
	 struct connectib_icmd_rw_gvmix rw_gvmix;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_esw rw_esw;
	/* Description - used to enable/query HW tracer for code coverage */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_code_coverage_control code_coverage;
	/* Description - Read code coverage bitmask from HW buffer */
	/* 0.0 - 264.31 */
	 struct connectib_icmd_code_coverage_read code_coverage_read;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_icmd_stop_toggler stop_toggler;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_icmd_stress_testing stress_testing;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_icmd_pcie_ver_data pcie_ver_data;
	/* Description -  */
	/* 0.0 - 8.31 */
	 struct connectib_icmd_push_db push_db;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_icmd_flr_debug flr_debug;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_dcr_ll_trvrs dcr_ll_trvrs;
	/* Description -  */
	/* 0.0 - 768.31 */
	 struct connectib_icmd_dcr_ll_next_dcr_list dcr_ll_next_dcr_list;
	/* Description -  */
	/* 0.0 - 68.31 */
	 struct connectib_icmd_access_steering_root access_steering_root;
	/* Description -  */
	/* 0.0 - 48.31 */
	 struct connectib_icmd_steering_table_info get_steering_table_info;
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_icmd_get_gvmi_via_vsec get_gvmi_via_vsec;
	/* Description -  */
	/* 0.0 - 20.31 */
	 struct connectib_icmd_access_register_paos access_register_paos;
	/* Description -  */
	/* 0.0 - 48.31 */
	 struct connectib_icmd_access_register_slrp access_register_slrp;
	/* Description -  */
	/* 0.0 - 24.31 */
	 struct connectib_icmd_access_register_sltp access_register_sltp;
	/* Description -  */
	/* 0.0 - 44.31 */
	 struct connectib_icmd_access_register_slrg access_register_slrg;
	/* Description -  */
	/* 0.0 - 48.31 */
	 struct connectib_icmd_access_register_ptas access_register_ptas;
	/* Description -  */
	/* 0.0 - 48.31 */
	 struct connectib_icmd_access_register_ppamp access_register_ppamp;
	/* Description -  */
	/* 0.0 - 20.31 */
	 struct connectib_icmd_access_register_pmtu access_register_pmtu;
	/* Description -  */
	/* 0.0 - 68.31 */
	 struct connectib_icmd_access_reg_ptys access_register_ptys;
	/* Description -  */
	/* 0.0 - 268.31 */
	 struct connectib_icmd_access_register_ppcnt access_register_ppcnt;
	/* Description -  */
	/* 0.0 - 24.31 */
	 struct connectib_icmd_set_get_port_cntr set_get_port_counter;
	/* Description - FTE dump tool: Flow Table list */
	/* 0.0 - 16.31 */
	 union connectib_icmd_get_ft_list get_ft_list;
	/* Description - FTE dump tool: Flow Table info */
	/* 0.0 - 16.31 */
	 union connectib_icmd_get_ft_info get_ft_info;
	/* Description - FTE dump tool: Flow Group list */
	/* 0.0 - 16.31 */
	 union connectib_icmd_get_fg_list get_fg_list;
	/* Description - FTE dump tool: Flow Group info */
	/* 0.0 - 256.31 */
	 union connectib_icmd_get_fg get_fg;
	/* Description - FTE dump tool: Flow Table Entry list */
	/* 0.0 - 16.31 */
	 union connectib_icmd_get_fte_list get_fte_list;
	/* Description - FTE dump tool: Flow Table Entry info */
	/* 0.0 - 768.31 */
	 union connectib_icmd_get_fte get_fte;
	/* Description - STE dump tool: STE opened resources */
	/* 0.0 - 768.31 */
	 union connectib_icmd_get_ste_open_resources get_ste_open_resources;
	/* Description - STE dump tool: STE resources list */
	/* 0.0 - 256.31 */
	 union connectib_icmd_get_ste_resources_list get_ste_resources_list;
	/* Description - STE dump tool: STE dump */
	/* 0.0 - 80.31 */
	 struct connectib_icmd_read_ste read_ste;
	/* Description -  */
	/* 0.0 - 20.31 */
	 struct connectib_icmd_access_register_pvlc access_register_pvlc;
	/* Description - injects faults for verification */
	/* 0.0 - 8.31 */
	 struct connectib_icmd_general_fault_injector general_fault_injector;
	/* Description - generate assert */
	/* 0.0 - 4.31 */
	 struct connectib_icmd_gen_assert gen_assert;
	/* Description - vport_info or vport_shadow */
	/* 0.0 - 96.31 */
	 struct connectib_icmd_get_pf_ctx get_pf_ctx;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_sigerr {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t rsvd_6;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t expected_trans_sig;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t actual_trans_sig;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t expected_ref_tag;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t actual_ref_tag;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.15 */
	 u_int16_t rsvd_5;
	/* Description -  */
	/* 32.16 - 36.31 */
	 u_int16_t syndrome;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t mkey;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t sig_err_byte_h;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t sig_err_byte_l;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 u_int32_t rsvd_3;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 56.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 56.24 - 60.31 */
	 u_int8_t rsvd_2;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 60.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 60.1 - 60.3 */
	 u_int8_t rsvd_0;
	/* Description -  */
	/* 60.4 - 60.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 60.16 - 64.31 */
	 u_int16_t rsvd_1;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_resize {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rsvd_14;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t rsvd_13;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t rsvd_12;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t rsvd_11;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t rsvd_10;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 36.31 */
	 u_int32_t rsvd_6;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t rsvd_3;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t timestamp_h;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 56.31 */
	 u_int32_t timestamp_l;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 60.31 */
	 u_int32_t rsvd_2;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 60.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 60.1 - 60.3 */
	 u_int8_t rsvd_1;
	/* Description -  */
	/* 60.4 - 60.7 */
	 u_int8_t opcode;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 60.16 - 64.31 */
	 u_int16_t rsvd_0;
};

/* Description -   */
/* Size in bytes - 64 */
struct connectib_sw_cqe_error {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 4.31 */
	 u_int32_t rsvd_14;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description -  */
	/* 4.0 - 8.31 */
	 u_int32_t rsvd_13;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description -  */
	/* 8.0 - 12.31 */
	 u_int32_t rsvd_12;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description -  */
	/* 12.0 - 16.31 */
	 u_int32_t rsvd_11;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 20.31 */
	 u_int32_t rsvd_10;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.0 - 24.31 */
	 u_int32_t rsvd_9;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 28.31 */
	 u_int32_t rsvd_8;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 32.31 */
	 u_int32_t rsvd_7;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 32.23 */
	 u_int32_t srq_num;
	/* Description -  */
	/* 32.24 - 36.31 */
	 u_int8_t rsvd_6;
/*---------------- DWORD[9] (Offset 0x24) ----------------*/
	/* Description -  */
	/* 36.0 - 40.31 */
	 u_int32_t rsvd_5;
/*---------------- DWORD[10] (Offset 0x28) ----------------*/
	/* Description -  */
	/* 40.0 - 44.31 */
	 u_int32_t rsvd_4;
/*---------------- DWORD[11] (Offset 0x2c) ----------------*/
	/* Description -  */
	/* 44.0 - 48.31 */
	 u_int32_t rsvd_3;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 52.31 */
	 u_int32_t rsvd_2;
/*---------------- DWORD[13] (Offset 0x34) ----------------*/
	/* Description -  */
	/* 52.0 - 52.7 */
	 u_int8_t syndrome;
	/* Description -  */
	/* 52.8 - 52.15 */
	 u_int8_t vendor_error_syndrome;
	/* Description -  */
	/* 52.16 - 52.19 */
	 u_int8_t rsvd_1;
	/* Description -  */
	/* 52.20 - 52.23 */
	 u_int8_t hw_syndrome_type;
	/* Description -  */
	/* 52.24 - 56.31 */
	 u_int8_t vendor_hw_syndrome;
/*---------------- DWORD[14] (Offset 0x38) ----------------*/
	/* Description -  */
	/* 56.0 - 56.23 */
	 u_int32_t qpn;
	/* Description -  */
	/* 56.24 - 60.31 */
	 u_int8_t swqe_opcode_drop_cntr;
/*---------------- DWORD[15] (Offset 0x3c) ----------------*/
	/* Description -  */
	/* 60.0 - 60.0 */
	 u_int8_t owner;
	/* Description -  */
	/* 60.1 - 60.3 */
	 u_int8_t rsvd_0;
	/* Description -  */
	/* 60.4 - 60.7 */
	 u_int8_t rwqe_opcode;
	/* Description -  */
	/* 60.8 - 60.15 */
	 u_int8_t signature;
	/* Description -  */
	/* 60.16 - 64.31 */
	 u_int16_t wqe_counter;
};

/* Description -   */
/* Size in bytes - 128 */
struct connectib_sw_cqe_128b {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_grh_inline_data grh_inline_data;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description - 64B CQE */
	/* 64.0 - 128.31 */
	 struct connectib_sw_cqe_64b cqe_64b;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_itoc_entry {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.2 - 0.23 */
	 u_int32_t size;
	/* Description - Section ID Section Type DESCRIPTION
0x1 BOOT_CODE FW loader code
0x2 PCI_CODE Code that is required to raise PCIe link.
0x3 MAIN_CODE All non-PCIe FW code
0x8 HW_BOOT_CFG Initial values for the PCI related registers
0x9 HW_MAIN_CFG Initial values for all other registers 
0x10 IMAGE_INFO Management data for the burning tool. See 'Image Info Section' chapter in the Mellanox Flash Programming Application Note
0x11 FW_BOOT_CFG Initial values for user set-able hi level non-hardware related settings, such as number of physical functions
(optional)
0x12 FW_MAIN_CFG Initial values for user set-able hi level non-hardware related settings.
(optional)
0x18 ROM_CODE PXE/Boot over IB code. 
0x30 DBG_LOG_MAP FW logger 'index to string' map. The map is in ASCI text. Format is TBD.
                                          PARAM0 in the iTOC specifies the compression method of this sector:
                                          0. Uncompressed
                                          1. Zlib compress2()
                                          2. LZMA
                                          Others - Reserved 
0x31 DBG_FW_INI The Ini file used in the image generation. The PARAM0 applies the same as in  DBG_LOG_MAP section type.
0x32 DBG_FW_PARAMS FW settable parameters. ASCII text. Format is TBD. The PARAM0 applies the same as in  DBG_LOG_MAP section type.
0xff END_MARKER A type of 0xff marks the end of the iTOC entries array. It is recommended to leave the unused part of the iTOC section blank (that is, 0xff in all unused bytes)
All other values Reserved 
 */
	/* 0.24 - 4.31 */
	 u_int8_t type;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - if partition type is code or ini then the load address is in here */
	/* 4.0 - 4.29 */
	 u_int32_t param0;
	/* Description - When this bit is set, Data within the section is protected by per-line crc. See yu.flash.replacement.crc_en */
	/* 4.30 - 4.30 */
	 u_int8_t cache_line_crc;
	/* Description - When this bit is set, image is zipped */
	/* 4.31 - 8.31 */
	 u_int8_t zipped_image;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - if partition type is code then the jump address is in here */
	/* 8.0 - 12.31 */
	 u_int32_t param1;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description -  */
	/* 20.2 - 20.30 */
	 u_int32_t flash_addr;
	/* Description -  */
	/* 20.31 - 24.31 */
	 u_int8_t relative_addr;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description -  */
	/* 24.0 - 24.15 */
	 u_int16_t section_crc;
	/* Description -  */
	/* 24.16 - 24.16 */
	 u_int8_t no_crc;
	/* Description - When this bit is set, the section pointed by this entry in belongs to teh device tather than to teh FW image.
A device_data section should not be updated in a regular FW update.
Example for device_data section: VPD_R, GUIDs. */
	/* 24.17 - 24.17 */
	 u_int8_t device_data;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.15 */
	 u_int16_t itoc_entry_crc;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_itoc_header {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 49 54 4f 43 */
	/* 0.0 - 4.31 */
	 u_int32_t signature0;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - 04 08 15 16 */
	/* 4.0 - 8.31 */
	 u_int32_t signature1;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 23 42 ca fa */
	/* 8.0 - 12.31 */
	 u_int32_t signature2;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - ba ca fe 00 */
	/* 12.0 - 16.31 */
	 u_int32_t signature3;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - Current version: 1 */
	/* 16.0 - 16.7 */
	 u_int8_t version;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description -  */
	/* 28.0 - 28.15 */
	 u_int16_t itoc_entry_crc;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_sw_wqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 16.31 */
	 struct connectib_wqe_control conrtol;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description -  */
	/* 16.0 - 32.31 */
	 struct connectib_wqe_mlx mlx;
/*---------------- DWORD[8] (Offset 0x20) ----------------*/
	/* Description -  */
	/* 32.0 - 48.31 */
	 struct connectib_wqe_xrc xrc;
/*---------------- DWORD[12] (Offset 0x30) ----------------*/
	/* Description -  */
	/* 48.0 - 64.31 */
	 struct connectib_wqe_address_vector_basic address_vector_basic;
/*---------------- DWORD[16] (Offset 0x40) ----------------*/
	/* Description -  */
	/* 64.0 - 96.31 */
	 struct connectib_wqe_address_vector_ext address_vector_ext;
/*---------------- DWORD[24] (Offset 0x60) ----------------*/
	/* Description -  */
	/* 96.0 - 112.31 */
	 struct connectib_wqe_rdma_read rdma_read;
/*---------------- DWORD[28] (Offset 0x70) ----------------*/
	/* Description -  */
	/* 112.0 - 128.31 */
	 struct connectib_wqe_atomic_cmp_swap atomic_cmp_swap;
/*---------------- DWORD[32] (Offset 0x80) ----------------*/
	/* Description -  */
	/* 128.0 - 640.31 */
	 union connectib_wqe_extended_atomic_cmp_swap ext_atom_cmp_swap;
/*---------------- DWORD[160] (Offset 0x280) ----------------*/
	/* Description -  */
	/* 640.0 - 656.31 */
	 struct connectib_wqe_atomic_fetch_add atomic_fetch_add;
/*---------------- DWORD[164] (Offset 0x290) ----------------*/
	/* Description -  */
	/* 656.0 - 912.31 */
	 union connectib_wqe_extended_atomic_fetch_add ext_atom_fetch_add;
/*---------------- DWORD[228] (Offset 0x390) ----------------*/
	/* Description -  */
	/* 912.0 - 928.31 */
	 struct connectib_wqe_signature signature;
/*---------------- DWORD[232] (Offset 0x3a0) ----------------*/
	/* Description -  */
	/* 928.0 - 944.31 */
	 struct connectib_wqe_srq_next srq_next;
/*---------------- DWORD[236] (Offset 0x3b0) ----------------*/
	/* Description -  */
	/* 944.0 - 960.31 */
	 struct connectib_wqe_gather_scatter_entry gather_scatter_entry;
/*---------------- DWORD[240] (Offset 0x3c0) ----------------*/
	/* Description -  */
	/* 960.0 - 964.31 */
	 struct connectib_wqe_inline_header inline_header;
/*---------------- DWORD[244] (Offset 0x3d0) ----------------*/
	/* Description -  */
	/* 976.0 - 992.31 */
	 struct connectib_wqe_eth_segment eth_segment;
};

/* Description -  All ini  fields */
/* Size in bytes - 65536 */
union connectib_ini {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - 1. Boot record endianes: reserved1 is the fist Byte that should be written on the NVRAM (address 0)
2. Each line is protected by parity bit (bit 31) the xor of the 32 read bits should be 1 */
	/* 0.0 - 16.31 */
	 struct connectib_boot_record_golan boot_record;
	/* Description -  */
	/* 0.0 - 256.31 */
	 struct connectib_reset_info reset_info;
	/* Description - This is a 'dummy' section.
It holds teh pointers for the dTOC entries.
Used by the mic tool */
	/* 0.0 - 256.31 */
	 union connectib_dtoc_pointers dtoc_pointers;
	/* Description - This struct contains device specific info, such as GUIDs, VSD, Keys, etc...
It is not a part of teh FW image.
 */
	/* 0.0 - 512.31 */
	 struct connectib_device_info device_info;
	/* Description - This section contains info which is shared by FW and burning tool */
	/* 0.0 - 1024.31 */
	 struct connectib_image_info image_info;
	/* Description -  */
	/* 0.0 - 320.31 */
	 struct connectib_mfg_info mfg_info;
	/* Description - plastic fw config data */
	/* 0.0 - 1776.31 */
	 struct connectib_fw_main_config fw_main_config;
	/* Description - boot + iron fw config data */
	/* 0.0 - 1152.31 */
	 struct connectib_fw_boot_config fw_boot_config;
	/* Description - plastic hw and board config data */
	/* 0.0 - 2816.31 */
	 struct connectib_hw_main_config hw_main_config;
	/* Description - boot and iron hw and board config data */
	/* 0.0 - 256.31 */
	 struct connectib_hw_boot_config hw_boot_config;
	/* Description -  */
	/* 0.0 - 65536.31 */
	 struct connectib_nv_data nv_data_0;
	/* Description -  */
	/* 0.0 - 65536.31 */
	 struct connectib_nv_data nv_data_1;
	/* Description -  */
	/* 0.0 - 65536.31 */
	 struct connectib_nv_data fw_nv_log;
};

/* Description -   */
/* Size in bytes - 32 */
struct connectib_a2d {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - PowerUp the a2d circuit */
	/* 0.0 - 0.0 */
	 u_int8_t power_up;
	/* Description - divider the clock by: 2^(16-N) */
	/* 0.1 - 0.3 */
	 u_int8_t clock_div;
	/* Description - 
0: temperature (tempnet represented by voltage coming from bandgap circuit)
1: ibres2a2d : voltage coming from opamp_dft representing current over cml_res for debug
2: vddcore1 vdd coming from core. Omer needs to specify exactly where it is connected to
3: vsscore1 vss coming from core. Omer needs to specify exactly where it is connected to
4: vddcore2 vdd coming from core. Omer needs to specify exactly where it is connected to
5: vsscore2 vss coming from core. Omer needs to specify exactly where it is connected to
6: vddsd - vdd coming from serdes. Please refer to measure_sedes_probe in serdes
7: vsssd - vss coming from serdes. Please refer to measure_sedes_probe in serdes
8: irstatation voltages
9: av2a2d debug voltages coming from plls. Please refer to selav2a2d in PllCenter
10: bg12 directly from bandgap
11: bgx1 - coming from pll_ref buffered
12: package vss_sense
13: package vdd_sense
14: avout analog d2a voltage
15: fbout d2d feedback

 */
	/* 0.4 - 0.7 */
	 u_int8_t probe_sel;
	/* Description - Define the A2D measure mode (not thermal protect)
0,1: compare (for thermal protection or when SW driving HW machine)
2: binary search
    If thermal protection is enabled than the protection and measurement will operate simultaniously
3: circuit binary search (thermal_protect_en must be set to 0) */
	/* 0.8 - 0.9 */
	 u_int8_t measure_mode;
	/* Description - Which clock drives the A2D block:
0-internal ring oscilator
1-clock from pll input buffer 0
2-clock directly from pad1
3-clock directly from pad0
5-clock from pll input buffer 1 */
	/* 0.10 - 0.12 */
	 u_int8_t clock_sel;
	/* Description - sets the polarity of the bin_search algorithm. i.e. wheather to go up or down on each d2a results. */
	/* 0.13 - 0.13 */
	 u_int8_t measure_polarity;
/*---------------- DWORD[1] (Offset 0x4) ----------------*/
	/* Description - selects which analog net is connected to the ref_cm pad:
0-serial mode out
1-vss
2-analog value from probes
3-d2a analog value out */
	/* 4.0 - 4.1 */
	 u_int8_t pad_out_sel;
	/* Description - defines the direction of the spike direction */
	/* 4.2 - 4.2 */
	 u_int8_t spike_direction;
	/* Description - CAUTION - this register causes chage sharing over pllx4

0: 0.9V  (best for temperature)
1: 1.2V  (best for vddcore)
2: 1.8V  (best for vddhs)
3: 2.4V  (best for biases and analog) */
	/* 4.4 - 4.6 */
	 u_int8_t dynamic_range;
	/* Description - probe_sel needs to have values 6 (Vdd) / 7 (Vss) to select these voltages

1: vdd rxl. Please refer to serdes.x4.top_probe
2: vdd rxr. Please refer to serdes.x4.top_probe
3: vdd txl. Please refer to serdes.x4.top_probe
4: vdd txr. Please refer to serdes.x4.top_probe
5: vddhs ibfl . Please refer to serdes.x4.mid_probe
6: vddhs ibf4. Please refer to serdes.x4.mid_probe
7: spare
8: spare
 */
	/* 4.10 - 4.12 */
	 u_int8_t measure_serdes_probe;
	/* Description - When this register is set then the too hot indication (a2d_compare)
will be send to yu (too hot) */
	/* 4.13 - 4.13 */
	 u_int8_t thermal_protect_en;
/*---------------- DWORD[2] (Offset 0x8) ----------------*/
	/* Description - 
Current value from A2D block or threshold value to compare with.
Temperature values are in reverse order to actual temperture[C] */
	/* 8.0 - 8.10 */
	 u_int16_t measure_value;
	/* Description - set by HW upon receiving valid from circuit binary machine, may be cleared by FW */
	/* 8.11 - 8.11 */
	 u_int8_t circuit_binary_done;
	/* Description - compare value from A2D block
1-too hot / analog below threshold
0-cold / analog above threshold */
	/* 8.12 - 8.12 */
	 u_int8_t a2d_compare;
	/* Description - threshold cross sticky bit
write 0 to clear */
	/* 8.13 - 8.13 */
	 u_int8_t spike_detect;
/*---------------- DWORD[3] (Offset 0xc) ----------------*/
	/* Description - 
stabilization time:  2^ in i1 clocks
This time purpose is to wait for the HW a2d to stabilize and give a good output.
The time starts counting once inputs are good and control will disregard a2d output
as long time not ended.
 */
	/* 12.0 - 12.4 */
	 u_int8_t stabilization_time;
/*---------------- DWORD[4] (Offset 0x10) ----------------*/
	/* Description - min a2d value
writable by crspace */
	/* 16.0 - 16.10 */
	 u_int16_t measure_min;
	/* Description - compare value from A2D block on the last measure cycle
1-too hot / analog below threshold
0-cold / analog above threshold */
	/* 16.11 - 16.11 */
	 u_int8_t measure_compare;
/*---------------- DWORD[5] (Offset 0x14) ----------------*/
	/* Description - max a2d value
writable by crspace */
	/* 20.0 - 20.10 */
	 u_int16_t measure_max;
/*---------------- DWORD[6] (Offset 0x18) ----------------*/
	/* Description - This value is driven to HW a2d to compare when protect mode is on
temp values are in reverse order to temperture
 */
	/* 24.0 - 24.10 */
	 u_int16_t protect_value;
	/* Description - sets polarity of the protection mode or the too_hot indication going towards YU */
	/* 24.11 - 24.11 */
	 u_int8_t protect_polarity;
/*---------------- DWORD[7] (Offset 0x1c) ----------------*/
	/* Description - temperature value as measured before VDDCORE was powered up
temp values are in reverse order to temperture */
	/* 28.0 - 28.10 */
	 u_int16_t calib_value;
};

/* Description -   */
/* Size in bytes - 1024 */
struct connectib_icmd {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 768.31 */
	 union connectib_icmd_cmd cmd;
/*---------------- DWORD[252] (Offset 0x3f0) ----------------*/
	/* Description -  */
	/* 1008.0 - 1024.31 */
	 struct connectib_icmd_ctrl ctrl;
};

/* Description -   */
/* Size in bytes - 128 */
union connectib_sw_cqe {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - cqe 64B layout */
	/* 0.0 - 64.31 */
	 struct connectib_sw_cqe_64b cqe_64b;
	/* Description - cqe 128B layout */
	/* 0.0 - 128.31 */
	 struct connectib_sw_cqe_128b cqe_128b;
	/* Description - error cqe layout */
	/* 0.0 - 64.31 */
	 struct connectib_sw_cqe_error cqe_error;
	/* Description - CQ resize cqe layout */
	/* 0.0 - 64.31 */
	 struct connectib_sw_cqe_resize cqe_resize;
	/* Description - signature error cqe layout */
	/* 0.0 - 64.31 */
	 struct connectib_sw_cqe_sigerr cqe_sigerr;
};

/* Description -  All nodes */
/* Size in bytes - 32 */
union connectib_itoc {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description - Size must be multiple of 16B */
	/* 0.0 - 32.31 */
	 struct connectib_itoc_header header;
	/* Description - Size must be multiple of 16B. When the no_crc bit is set, the section_crc should not be checked.
 */
	/* 0.0 - 32.31 */
	 struct connectib_itoc_entry entry;
};

/* Description -   */
/* Size in bytes - 65536 */
union connectib_connectib_Nodes {
/*---------------- DWORD[0] (Offset 0x0) ----------------*/
	/* Description -  */
	/* 0.0 - 32.31 */
	 union connectib_itoc itoc;
	/* Description -  */
	/* 0.0 - 64.31 */
	 union connectib_hw_hca_contexts hw_hca_contexts;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_guids guids;
	/* Description -  */
	/* 0.0 - 128.31 */
	 union connectib_sw_cqe sw_cqe;
	/* Description -  */
	/* 0.0 - 1024.31 */
	 struct connectib_icmd icmd;
	/* Description -  */
	/* 0.0 - 32.31 */
	 struct connectib_a2d a2d;
	/* Description -  */
	/* 0.0 - 65536.31 */
	 union connectib_ini ini;
	/* Description -  */
	/* 0.0 - 1024.31 */
	 struct connectib_sw_wqe sw_wqe;
	/* Description -  */
	/* 0.0 - 64.31 */
	 struct connectib_sw_eqe sw_eqe;
};


/*================= PACK/UNPACK/PRINT FUNCTIONS ======================*/
/* dw */
void connectib_dw_pack(const struct connectib_dw *ptr_struct, u_int8_t* ptr_buff);
void connectib_dw_unpack(struct connectib_dw *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dw_print(const struct connectib_dw *ptr_struct, FILE* file, int indent_level);
int connectib_dw_size(void);
#define CONNECTIB_DW_SIZE    (0x4)
void connectib_dw_dump(const struct connectib_dw *ptr_struct, FILE* file);
/* nv_tlv_type_nvlog */
void connectib_nv_tlv_type_nvlog_pack(const struct connectib_nv_tlv_type_nvlog *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_nvlog_unpack(struct connectib_nv_tlv_type_nvlog *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_nvlog_print(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_nvlog_size(void);
#define CONNECTIB_NV_TLV_TYPE_NVLOG_SIZE    (0x4)
void connectib_nv_tlv_type_nvlog_dump(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file);
/* nv_tlv_type_eswitch */
void connectib_nv_tlv_type_eswitch_pack(const struct connectib_nv_tlv_type_eswitch *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_eswitch_unpack(struct connectib_nv_tlv_type_eswitch *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_eswitch_print(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_eswitch_size(void);
#define CONNECTIB_NV_TLV_TYPE_ESWITCH_SIZE    (0x4)
void connectib_nv_tlv_type_eswitch_dump(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file);
/* nv_tlv_type_per_host */
void connectib_nv_tlv_type_per_host_pack(const struct connectib_nv_tlv_type_per_host *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_per_host_unpack(struct connectib_nv_tlv_type_per_host *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_per_host_print(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_per_host_size(void);
#define CONNECTIB_NV_TLV_TYPE_PER_HOST_SIZE    (0x4)
void connectib_nv_tlv_type_per_host_dump(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file);
/* nv_tlv_type_bmc */
void connectib_nv_tlv_type_bmc_pack(const struct connectib_nv_tlv_type_bmc *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_bmc_unpack(struct connectib_nv_tlv_type_bmc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_bmc_print(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_bmc_size(void);
#define CONNECTIB_NV_TLV_TYPE_BMC_SIZE    (0x4)
void connectib_nv_tlv_type_bmc_dump(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file);
/* nv_tlv_type_physical_port */
void connectib_nv_tlv_type_physical_port_pack(const struct connectib_nv_tlv_type_physical_port *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_physical_port_unpack(struct connectib_nv_tlv_type_physical_port *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_physical_port_print(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_physical_port_size(void);
#define CONNECTIB_NV_TLV_TYPE_PHYSICAL_PORT_SIZE    (0x4)
void connectib_nv_tlv_type_physical_port_dump(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file);
/* nv_tlv_type_global */
void connectib_nv_tlv_type_global_pack(const struct connectib_nv_tlv_type_global *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_global_unpack(struct connectib_nv_tlv_type_global *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_global_print(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_global_size(void);
#define CONNECTIB_NV_TLV_TYPE_GLOBAL_SIZE    (0x4)
void connectib_nv_tlv_type_global_dump(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file);
/* uint64 */
void connectib_uint64_pack(const struct connectib_uint64 *ptr_struct, u_int8_t* ptr_buff);
void connectib_uint64_unpack(struct connectib_uint64 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_uint64_print(const struct connectib_uint64 *ptr_struct, FILE* file, int indent_level);
int connectib_uint64_size(void);
#define CONNECTIB_UINT64_SIZE    (0x8)
void connectib_uint64_dump(const struct connectib_uint64 *ptr_struct, FILE* file);
/* dcr_qp */
void connectib_dcr_qp_pack(const struct connectib_dcr_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_dcr_qp_unpack(struct connectib_dcr_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dcr_qp_print(const struct connectib_dcr_qp *ptr_struct, FILE* file, int indent_level);
int connectib_dcr_qp_size(void);
#define CONNECTIB_DCR_QP_SIZE    (0x10)
void connectib_dcr_qp_dump(const struct connectib_dcr_qp *ptr_struct, FILE* file);
/* regular_qp */
void connectib_regular_qp_pack(const struct connectib_regular_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_regular_qp_unpack(struct connectib_regular_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_regular_qp_print(const struct connectib_regular_qp *ptr_struct, FILE* file, int indent_level);
int connectib_regular_qp_size(void);
#define CONNECTIB_REGULAR_QP_SIZE    (0x10)
void connectib_regular_qp_dump(const struct connectib_regular_qp *ptr_struct, FILE* file);
/* schedint_cause */
void connectib_schedint_cause_pack(const struct connectib_schedint_cause *ptr_struct, u_int8_t* ptr_buff);
void connectib_schedint_cause_unpack(struct connectib_schedint_cause *ptr_struct, const u_int8_t* ptr_buff);
void connectib_schedint_cause_print(const struct connectib_schedint_cause *ptr_struct, FILE* file, int indent_level);
int connectib_schedint_cause_size(void);
#define CONNECTIB_SCHEDINT_CAUSE_SIZE    (0x1)
void connectib_schedint_cause_dump(const struct connectib_schedint_cause *ptr_struct, FILE* file);
/* hw_msix_context_data0 */
void connectib_hw_msix_context_data0_pack(const struct connectib_hw_msix_context_data0 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_context_data0_unpack(struct connectib_hw_msix_context_data0 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_context_data0_print(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_context_data0_size(void);
#define CONNECTIB_HW_MSIX_CONTEXT_DATA0_SIZE    (0x4)
void connectib_hw_msix_context_data0_dump(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file);
/* hw_ste_tag_generic_headers */
void connectib_hw_ste_tag_generic_headers_pack(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_generic_headers_unpack(struct connectib_hw_ste_tag_generic_headers *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_generic_headers_print(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_generic_headers_size(void);
#define CONNECTIB_HW_STE_TAG_GENERIC_HEADERS_SIZE    (0x10)
void connectib_hw_ste_tag_generic_headers_dump(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file);
/* hw_ste_tag_port */
void connectib_hw_ste_tag_port_pack(const struct connectib_hw_ste_tag_port *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_port_unpack(struct connectib_hw_ste_tag_port *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_port_print(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_port_size(void);
#define CONNECTIB_HW_STE_TAG_PORT_SIZE    (0x10)
void connectib_hw_ste_tag_port_dump(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file);
/* hw_ste_tag_source_gvmi_qp */
void connectib_hw_ste_tag_source_gvmi_qp_pack(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_source_gvmi_qp_unpack(struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_source_gvmi_qp_print(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_source_gvmi_qp_size(void);
#define CONNECTIB_HW_STE_TAG_SOURCE_GVMI_QP_SIZE    (0x10)
void connectib_hw_ste_tag_source_gvmi_qp_dump(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l4 */
void connectib_hw_ste_tag_ib_l4_pack(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l4_unpack(struct connectib_hw_ste_tag_ib_l4 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l4_print(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l4_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L4_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l4_dump(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l3 */
void connectib_hw_ste_tag_ib_l3_pack(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_unpack(struct connectib_hw_ste_tag_ib_l3 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_print(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l3_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L3_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l3_dump(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l3_extended */
void connectib_hw_ste_tag_ib_l3_extended_pack(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_extended_unpack(struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l3_extended_print(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l3_extended_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L3_EXTENDED_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l3_extended_dump(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file);
/* hw_ste_tag_ib_l2 */
void connectib_hw_ste_tag_ib_l2_pack(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l2_unpack(struct connectib_hw_ste_tag_ib_l2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_ib_l2_print(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_ib_l2_size(void);
#define CONNECTIB_HW_STE_TAG_IB_L2_SIZE    (0x10)
void connectib_hw_ste_tag_ib_l2_dump(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file);
/* hw_ste_tag_bulk */
void connectib_hw_ste_tag_bulk_pack(const struct connectib_hw_ste_tag_bulk *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_bulk_unpack(struct connectib_hw_ste_tag_bulk *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_bulk_print(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_bulk_size(void);
#define CONNECTIB_HW_STE_TAG_BULK_SIZE    (0x10)
void connectib_hw_ste_tag_bulk_dump(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file);
/* hw_transaction_pdf */
void connectib_hw_transaction_pdf_pack(const struct connectib_hw_transaction_pdf *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_transaction_pdf_unpack(struct connectib_hw_transaction_pdf *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_transaction_pdf_print(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file, int indent_level);
int connectib_hw_transaction_pdf_size(void);
#define CONNECTIB_HW_TRANSACTION_PDF_SIZE    (0x8)
void connectib_hw_transaction_pdf_dump(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file);
/* hw_pdf_decoder */
void connectib_hw_pdf_decoder_pack(const struct connectib_hw_pdf_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_pdf_decoder_unpack(struct connectib_hw_pdf_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_pdf_decoder_print(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_hw_pdf_decoder_size(void);
#define CONNECTIB_HW_PDF_DECODER_SIZE    (0x8)
void connectib_hw_pdf_decoder_dump(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file);
/* serdes_conf_tx_set_ini */
void connectib_serdes_conf_tx_set_ini_pack(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_tx_set_ini_unpack(struct connectib_serdes_conf_tx_set_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_tx_set_ini_print(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_tx_set_ini_size(void);
#define CONNECTIB_SERDES_CONF_TX_SET_INI_SIZE    (0x4)
void connectib_serdes_conf_tx_set_ini_dump(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file);
/* serdes_conf_rx_set_ini */
void connectib_serdes_conf_rx_set_ini_pack(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_rx_set_ini_unpack(struct connectib_serdes_conf_rx_set_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_rx_set_ini_print(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_rx_set_ini_size(void);
#define CONNECTIB_SERDES_CONF_RX_SET_INI_SIZE    (0x8)
void connectib_serdes_conf_rx_set_ini_dump(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file);
/* aba_index */
void connectib_aba_index_pack(const struct connectib_aba_index *ptr_struct, u_int8_t* ptr_buff);
void connectib_aba_index_unpack(struct connectib_aba_index *ptr_struct, const u_int8_t* ptr_buff);
void connectib_aba_index_print(const struct connectib_aba_index *ptr_struct, FILE* file, int indent_level);
int connectib_aba_index_size(void);
#define CONNECTIB_ABA_INDEX_SIZE    (0x10)
void connectib_aba_index_dump(const struct connectib_aba_index *ptr_struct, FILE* file);
/* nv_tlv_type */
void connectib_nv_tlv_type_pack(const union connectib_nv_tlv_type *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_type_unpack(union connectib_nv_tlv_type *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_type_print(const union connectib_nv_tlv_type *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_type_size(void);
#define CONNECTIB_NV_TLV_TYPE_SIZE    (0x4)
void connectib_nv_tlv_type_dump(const union connectib_nv_tlv_type *ptr_struct, FILE* file);
/* register_access_data */
void connectib_register_access_data_pack(const struct connectib_register_access_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_access_data_unpack(struct connectib_register_access_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_access_data_print(const struct connectib_register_access_data *ptr_struct, FILE* file, int indent_level);
int connectib_register_access_data_size(void);
#define CONNECTIB_REGISTER_ACCESS_DATA_SIZE    (0x20)
void connectib_register_access_data_dump(const struct connectib_register_access_data *ptr_struct, FILE* file);
/* nv_tlv_hdr */
void connectib_nv_tlv_hdr_pack(const struct connectib_nv_tlv_hdr *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_hdr_unpack(struct connectib_nv_tlv_hdr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_hdr_print(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_hdr_size(void);
#define CONNECTIB_NV_TLV_HDR_SIZE    (0xc)
void connectib_nv_tlv_hdr_dump(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file);
/* mfba_header */
void connectib_mfba_header_pack(const struct connectib_mfba_header *ptr_struct, u_int8_t* ptr_buff);
void connectib_mfba_header_unpack(struct connectib_mfba_header *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mfba_header_print(const struct connectib_mfba_header *ptr_struct, FILE* file, int indent_level);
int connectib_mfba_header_size(void);
#define CONNECTIB_MFBA_HEADER_SIZE    (0xc)
void connectib_mfba_header_dump(const struct connectib_mfba_header *ptr_struct, FILE* file);
/* fw_ref_count */
void connectib_fw_ref_count_pack(const struct connectib_fw_ref_count *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_ref_count_unpack(struct connectib_fw_ref_count *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_ref_count_print(const struct connectib_fw_ref_count *ptr_struct, FILE* file, int indent_level);
int connectib_fw_ref_count_size(void);
#define CONNECTIB_FW_REF_COUNT_SIZE    (0x4)
void connectib_fw_ref_count_dump(const struct connectib_fw_ref_count *ptr_struct, FILE* file);
/* tir_dmfs */
void connectib_tir_dmfs_pack(const struct connectib_tir_dmfs *ptr_struct, u_int8_t* ptr_buff);
void connectib_tir_dmfs_unpack(struct connectib_tir_dmfs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_tir_dmfs_print(const struct connectib_tir_dmfs *ptr_struct, FILE* file, int indent_level);
int connectib_tir_dmfs_size(void);
#define CONNECTIB_TIR_DMFS_SIZE    (0x8)
void connectib_tir_dmfs_dump(const struct connectib_tir_dmfs *ptr_struct, FILE* file);
/* rx_hash_field_select */
void connectib_rx_hash_field_select_pack(const struct connectib_rx_hash_field_select *ptr_struct, u_int8_t* ptr_buff);
void connectib_rx_hash_field_select_unpack(struct connectib_rx_hash_field_select *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rx_hash_field_select_print(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file, int indent_level);
int connectib_rx_hash_field_select_size(void);
#define CONNECTIB_RX_HASH_FIELD_SELECT_SIZE    (0x4)
void connectib_rx_hash_field_select_dump(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file);
/* fw_qpc_special */
void connectib_fw_qpc_special_pack(const union connectib_fw_qpc_special *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_qpc_special_unpack(union connectib_fw_qpc_special *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_qpc_special_print(const union connectib_fw_qpc_special *ptr_struct, FILE* file, int indent_level);
int connectib_fw_qpc_special_size(void);
#define CONNECTIB_FW_QPC_SPECIAL_SIZE    (0x10)
void connectib_fw_qpc_special_dump(const union connectib_fw_qpc_special *ptr_struct, FILE* file);
/* fw_qpc_q */
void connectib_fw_qpc_q_pack(const struct connectib_fw_qpc_q *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_qpc_q_unpack(struct connectib_fw_qpc_q *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_qpc_q_print(const struct connectib_fw_qpc_q *ptr_struct, FILE* file, int indent_level);
int connectib_fw_qpc_q_size(void);
#define CONNECTIB_FW_QPC_Q_SIZE    (0x10)
void connectib_fw_qpc_q_dump(const struct connectib_fw_qpc_q *ptr_struct, FILE* file);
/* hw_msix_context_data */
void connectib_hw_msix_context_data_pack(const union connectib_hw_msix_context_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_context_data_unpack(union connectib_hw_msix_context_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_context_data_print(const union connectib_hw_msix_context_data *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_context_data_size(void);
#define CONNECTIB_HW_MSIX_CONTEXT_DATA_SIZE    (0x4)
void connectib_hw_msix_context_data_dump(const union connectib_hw_msix_context_data *ptr_struct, FILE* file);
/* steering_qp_entry */
void connectib_steering_qp_entry_pack(const struct connectib_steering_qp_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_steering_qp_entry_unpack(struct connectib_steering_qp_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_steering_qp_entry_print(const struct connectib_steering_qp_entry *ptr_struct, FILE* file, int indent_level);
int connectib_steering_qp_entry_size(void);
#define CONNECTIB_STEERING_QP_ENTRY_SIZE    (0x4)
void connectib_steering_qp_entry_dump(const struct connectib_steering_qp_entry *ptr_struct, FILE* file);
/* hw_ste_tag */
void connectib_hw_ste_tag_pack(const union connectib_hw_ste_tag *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_tag_unpack(union connectib_hw_ste_tag *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_tag_print(const union connectib_hw_ste_tag *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_tag_size(void);
#define CONNECTIB_HW_STE_TAG_SIZE    (0x10)
void connectib_hw_ste_tag_dump(const union connectib_hw_ste_tag *ptr_struct, FILE* file);
/* hw_pdf_entry */
void connectib_hw_pdf_entry_pack(const union connectib_hw_pdf_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_pdf_entry_unpack(union connectib_hw_pdf_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_pdf_entry_print(const union connectib_hw_pdf_entry *ptr_struct, FILE* file, int indent_level);
int connectib_hw_pdf_entry_size(void);
#define CONNECTIB_HW_PDF_ENTRY_SIZE    (0x8)
void connectib_hw_pdf_entry_dump(const union connectib_hw_pdf_entry *ptr_struct, FILE* file);
/* pf_vf_vpd */
void connectib_pf_vf_vpd_pack(const struct connectib_pf_vf_vpd *ptr_struct, u_int8_t* ptr_buff);
void connectib_pf_vf_vpd_unpack(struct connectib_pf_vf_vpd *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pf_vf_vpd_print(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file, int indent_level);
int connectib_pf_vf_vpd_size(void);
#define CONNECTIB_PF_VF_VPD_SIZE    (0x8)
void connectib_pf_vf_vpd_dump(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file);
/* pf_vf_sriov */
void connectib_pf_vf_sriov_pack(const struct connectib_pf_vf_sriov *ptr_struct, u_int8_t* ptr_buff);
void connectib_pf_vf_sriov_unpack(struct connectib_pf_vf_sriov *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pf_vf_sriov_print(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file, int indent_level);
int connectib_pf_vf_sriov_size(void);
#define CONNECTIB_PF_VF_SRIOV_SIZE    (0x8)
void connectib_pf_vf_sriov_dump(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file);
/* serdes_conf_preset_tx_ini */
void connectib_serdes_conf_preset_tx_ini_pack(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_preset_tx_ini_unpack(struct connectib_serdes_conf_preset_tx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_preset_tx_ini_print(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_preset_tx_ini_size(void);
#define CONNECTIB_SERDES_CONF_PRESET_TX_INI_SIZE    (0x40)
void connectib_serdes_conf_preset_tx_ini_dump(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file);
/* serdes_active_tx_ini */
void connectib_serdes_active_tx_ini_pack(const struct connectib_serdes_active_tx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_active_tx_ini_unpack(struct connectib_serdes_active_tx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_active_tx_ini_print(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_active_tx_ini_size(void);
#define CONNECTIB_SERDES_ACTIVE_TX_INI_SIZE    (0x10)
void connectib_serdes_active_tx_ini_dump(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file);
/* serdes_active_rx_ini */
void connectib_serdes_active_rx_ini_pack(const struct connectib_serdes_active_rx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_active_rx_ini_unpack(struct connectib_serdes_active_rx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_active_rx_ini_print(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_active_rx_ini_size(void);
#define CONNECTIB_SERDES_ACTIVE_RX_INI_SIZE    (0x20)
void connectib_serdes_active_rx_ini_dump(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file);
/* serdes_force_tx_ini */
void connectib_serdes_force_tx_ini_pack(const struct connectib_serdes_force_tx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_force_tx_ini_unpack(struct connectib_serdes_force_tx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_force_tx_ini_print(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_force_tx_ini_size(void);
#define CONNECTIB_SERDES_FORCE_TX_INI_SIZE    (0x28)
void connectib_serdes_force_tx_ini_dump(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file);
/* serdes_force_rx_ini */
void connectib_serdes_force_rx_ini_pack(const struct connectib_serdes_force_rx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_force_rx_ini_unpack(struct connectib_serdes_force_rx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_force_rx_ini_print(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_force_rx_ini_size(void);
#define CONNECTIB_SERDES_FORCE_RX_INI_SIZE    (0x50)
void connectib_serdes_force_rx_ini_dump(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file);
/* serdes_conf_aba_tx_ini */
void connectib_serdes_conf_aba_tx_ini_pack(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_aba_tx_ini_unpack(struct connectib_serdes_conf_aba_tx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_aba_tx_ini_print(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_aba_tx_ini_size(void);
#define CONNECTIB_SERDES_CONF_ABA_TX_INI_SIZE    (0x80)
void connectib_serdes_conf_aba_tx_ini_dump(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file);
/* serdes_conf_aba_rx_ini */
void connectib_serdes_conf_aba_rx_ini_pack(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_aba_rx_ini_unpack(struct connectib_serdes_conf_aba_rx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_aba_rx_ini_print(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_aba_rx_ini_size(void);
#define CONNECTIB_SERDES_CONF_ABA_RX_INI_SIZE    (0x100)
void connectib_serdes_conf_aba_rx_ini_dump(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file);
/* serdes_conf_autoneg_tx_ini */
void connectib_serdes_conf_autoneg_tx_ini_pack(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_autoneg_tx_ini_unpack(struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_autoneg_tx_ini_print(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_autoneg_tx_ini_size(void);
#define CONNECTIB_SERDES_CONF_AUTONEG_TX_INI_SIZE    (0x80)
void connectib_serdes_conf_autoneg_tx_ini_dump(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file);
/* serdes_conf_autoneg_rx_ini */
void connectib_serdes_conf_autoneg_rx_ini_pack(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_autoneg_rx_ini_unpack(struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_autoneg_rx_ini_print(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_autoneg_rx_ini_size(void);
#define CONNECTIB_SERDES_CONF_AUTONEG_RX_INI_SIZE    (0x100)
void connectib_serdes_conf_autoneg_rx_ini_dump(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file);
/* aba_indexes */
void connectib_aba_indexes_pack(const struct connectib_aba_indexes *ptr_struct, u_int8_t* ptr_buff);
void connectib_aba_indexes_unpack(struct connectib_aba_indexes *ptr_struct, const u_int8_t* ptr_buff);
void connectib_aba_indexes_print(const struct connectib_aba_indexes *ptr_struct, FILE* file, int indent_level);
int connectib_aba_indexes_size(void);
#define CONNECTIB_ABA_INDEXES_SIZE    (0x30)
void connectib_aba_indexes_dump(const struct connectib_aba_indexes *ptr_struct, FILE* file);
/* serdes_param_mask_per_proto_ini */
void connectib_serdes_param_mask_per_proto_ini_pack(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_param_mask_per_proto_ini_unpack(struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_param_mask_per_proto_ini_print(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_param_mask_per_proto_ini_size(void);
#define CONNECTIB_SERDES_PARAM_MASK_PER_PROTO_INI_SIZE    (0x4)
void connectib_serdes_param_mask_per_proto_ini_dump(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file);
/* cmdif_ctx_dmfs */
void connectib_cmdif_ctx_dmfs_pack(const struct connectib_cmdif_ctx_dmfs *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_dmfs_unpack(struct connectib_cmdif_ctx_dmfs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_dmfs_print(const struct connectib_cmdif_ctx_dmfs *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_dmfs_size(void);
#define CONNECTIB_CMDIF_CTX_DMFS_SIZE    (0x20)
void connectib_cmdif_ctx_dmfs_dump(const struct connectib_cmdif_ctx_dmfs *ptr_struct, FILE* file);
/* cmdif_ctx_create_mtt */
void connectib_cmdif_ctx_create_mtt_pack(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_create_mtt_unpack(struct connectib_cmdif_ctx_create_mtt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_create_mtt_print(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_create_mtt_size(void);
#define CONNECTIB_CMDIF_CTX_CREATE_MTT_SIZE    (0x20)
void connectib_cmdif_ctx_create_mtt_dump(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file);
/* cmdif_ctx_psv */
void connectib_cmdif_ctx_psv_pack(const struct connectib_cmdif_ctx_psv *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_psv_unpack(struct connectib_cmdif_ctx_psv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_psv_print(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_psv_size(void);
#define CONNECTIB_CMDIF_CTX_PSV_SIZE    (0x20)
void connectib_cmdif_ctx_psv_dump(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file);
/* cmdif_ctx_mcg */
void connectib_cmdif_ctx_mcg_pack(const struct connectib_cmdif_ctx_mcg *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_mcg_unpack(struct connectib_cmdif_ctx_mcg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_mcg_print(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_mcg_size(void);
#define CONNECTIB_CMDIF_CTX_MCG_SIZE    (0x20)
void connectib_cmdif_ctx_mcg_dump(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file);
/* cmdif_ctx_sniffer */
void connectib_cmdif_ctx_sniffer_pack(const struct connectib_cmdif_ctx_sniffer *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_sniffer_unpack(struct connectib_cmdif_ctx_sniffer *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_sniffer_print(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_sniffer_size(void);
#define CONNECTIB_CMDIF_CTX_SNIFFER_SIZE    (0x20)
void connectib_cmdif_ctx_sniffer_dump(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file);
/* cmdif_ctx_special_modify_rmp */
void connectib_cmdif_ctx_special_modify_rmp_pack(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_rmp_unpack(struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_rmp_print(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_modify_rmp_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_MODIFY_RMP_SIZE    (0x20)
void connectib_cmdif_ctx_special_modify_rmp_dump(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file);
/* cmdif_ctx_special_arm_rq */
void connectib_cmdif_ctx_special_arm_rq_pack(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_arm_rq_unpack(struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_arm_rq_print(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_arm_rq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_ARM_RQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_arm_rq_dump(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file);
/* cmdif_ctx_special_mkey */
void connectib_cmdif_ctx_special_mkey_pack(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_mkey_unpack(struct connectib_cmdif_ctx_special_mkey *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_mkey_print(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_mkey_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_MKEY_SIZE    (0x20)
void connectib_cmdif_ctx_special_mkey_dump(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file);
/* cmdif_ctx_special_modify_cq */
void connectib_cmdif_ctx_special_modify_cq_pack(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_cq_unpack(struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_cq_print(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_modify_cq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_MODIFY_CQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_modify_cq_dump(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file);
/* cmdif_ctx_special_create_cq */
void connectib_cmdif_ctx_special_create_cq_pack(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_cq_unpack(struct connectib_cmdif_ctx_special_create_cq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_cq_print(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_cq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_CQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_cq_dump(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file);
/* cmdif_ctx_special_create_eq */
void connectib_cmdif_ctx_special_create_eq_pack(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_eq_unpack(struct connectib_cmdif_ctx_special_create_eq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_eq_print(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_eq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_EQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_eq_dump(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file);
/* cmdif_ctx_rqt */
void connectib_cmdif_ctx_rqt_pack(const struct connectib_cmdif_ctx_rqt *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_rqt_unpack(struct connectib_cmdif_ctx_rqt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_rqt_print(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_rqt_size(void);
#define CONNECTIB_CMDIF_CTX_RQT_SIZE    (0x20)
void connectib_cmdif_ctx_rqt_dump(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file);
/* cmdif_ctx_special_create_srq */
void connectib_cmdif_ctx_special_create_srq_pack(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_srq_unpack(struct connectib_cmdif_ctx_special_create_srq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_srq_print(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_srq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_SRQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_srq_dump(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file);
/* cmdif_ctx_special_create_rq */
void connectib_cmdif_ctx_special_create_rq_pack(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_rq_unpack(struct connectib_cmdif_ctx_special_create_rq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_rq_print(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_rq_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_RQ_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_rq_dump(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file);
/* cmdif_ctx_special_create_qp */
void connectib_cmdif_ctx_special_create_qp_pack(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_qp_unpack(struct connectib_cmdif_ctx_special_create_qp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_qp_print(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_qp_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_QP_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_qp_dump(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, FILE* file);
/* cmdif_ctx_special_modify_tir */
void connectib_cmdif_ctx_special_modify_tir_pack(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_tir_unpack(struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_modify_tir_print(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_modify_tir_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_MODIFY_TIR_SIZE    (0x20)
void connectib_cmdif_ctx_special_modify_tir_dump(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file);
/* cmdif_ctx_special_create */
void connectib_cmdif_ctx_special_create_pack(const struct connectib_cmdif_ctx_special_create *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_unpack(struct connectib_cmdif_ctx_special_create *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_create_print(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_create_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_CREATE_SIZE    (0x20)
void connectib_cmdif_ctx_special_create_dump(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file);
/* flush_type_bitmask */
void connectib_flush_type_bitmask_pack(const struct connectib_flush_type_bitmask *ptr_struct, u_int8_t* ptr_buff);
void connectib_flush_type_bitmask_unpack(struct connectib_flush_type_bitmask *ptr_struct, const u_int8_t* ptr_buff);
void connectib_flush_type_bitmask_print(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file, int indent_level);
int connectib_flush_type_bitmask_size(void);
#define CONNECTIB_FLUSH_TYPE_BITMASK_SIZE    (0x4)
void connectib_flush_type_bitmask_dump(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file);
/* flush_type_bits */
void connectib_flush_type_bits_pack(const struct connectib_flush_type_bits *ptr_struct, u_int8_t* ptr_buff);
void connectib_flush_type_bits_unpack(struct connectib_flush_type_bits *ptr_struct, const u_int8_t* ptr_buff);
void connectib_flush_type_bits_print(const struct connectib_flush_type_bits *ptr_struct, FILE* file, int indent_level);
int connectib_flush_type_bits_size(void);
#define CONNECTIB_FLUSH_TYPE_BITS_SIZE    (0x4)
void connectib_flush_type_bits_dump(const struct connectib_flush_type_bits *ptr_struct, FILE* file);
/* project_nvqc */
void connectib_project_nvqc_pack(const struct connectib_project_nvqc *ptr_struct, u_int8_t* ptr_buff);
void connectib_project_nvqc_unpack(struct connectib_project_nvqc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_project_nvqc_print(const struct connectib_project_nvqc *ptr_struct, FILE* file, int indent_level);
int connectib_project_nvqc_size(void);
#define CONNECTIB_PROJECT_NVQC_SIZE    (0x8)
void connectib_project_nvqc_dump(const struct connectib_project_nvqc *ptr_struct, FILE* file);
/* project_nvda */
void connectib_project_nvda_pack(const struct connectib_project_nvda *ptr_struct, u_int8_t* ptr_buff);
void connectib_project_nvda_unpack(struct connectib_project_nvda *ptr_struct, const u_int8_t* ptr_buff);
void connectib_project_nvda_print(const struct connectib_project_nvda *ptr_struct, FILE* file, int indent_level);
int connectib_project_nvda_size(void);
#define CONNECTIB_PROJECT_NVDA_SIZE    (0x2c)
void connectib_project_nvda_dump(const struct connectib_project_nvda *ptr_struct, FILE* file);
/* pmtu_reg */
void connectib_pmtu_reg_pack(const struct connectib_pmtu_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pmtu_reg_unpack(struct connectib_pmtu_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pmtu_reg_print(const struct connectib_pmtu_reg *ptr_struct, FILE* file, int indent_level);
int connectib_pmtu_reg_size(void);
#define CONNECTIB_PMTU_REG_SIZE    (0x10)
void connectib_pmtu_reg_dump(const struct connectib_pmtu_reg *ptr_struct, FILE* file);
/* pamp_reg */
void connectib_pamp_reg_pack(const struct connectib_pamp_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pamp_reg_unpack(struct connectib_pamp_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pamp_reg_print(const struct connectib_pamp_reg *ptr_struct, FILE* file, int indent_level);
int connectib_pamp_reg_size(void);
#define CONNECTIB_PAMP_REG_SIZE    (0x2c)
void connectib_pamp_reg_dump(const struct connectib_pamp_reg *ptr_struct, FILE* file);
/* slrg_reg */
void connectib_slrg_reg_pack(const struct connectib_slrg_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_slrg_reg_unpack(struct connectib_slrg_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_slrg_reg_print(const struct connectib_slrg_reg *ptr_struct, FILE* file, int indent_level);
int connectib_slrg_reg_size(void);
#define CONNECTIB_SLRG_REG_SIZE    (0x28)
void connectib_slrg_reg_dump(const struct connectib_slrg_reg *ptr_struct, FILE* file);
/* ptas_reg */
void connectib_ptas_reg_pack(const struct connectib_ptas_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_ptas_reg_unpack(struct connectib_ptas_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ptas_reg_print(const struct connectib_ptas_reg *ptr_struct, FILE* file, int indent_level);
int connectib_ptas_reg_size(void);
#define CONNECTIB_PTAS_REG_SIZE    (0x2c)
void connectib_ptas_reg_dump(const struct connectib_ptas_reg *ptr_struct, FILE* file);
/* sltp_reg */
void connectib_sltp_reg_pack(const struct connectib_sltp_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_sltp_reg_unpack(struct connectib_sltp_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sltp_reg_print(const struct connectib_sltp_reg *ptr_struct, FILE* file, int indent_level);
int connectib_sltp_reg_size(void);
#define CONNECTIB_SLTP_REG_SIZE    (0x14)
void connectib_sltp_reg_dump(const struct connectib_sltp_reg *ptr_struct, FILE* file);
/* slrp_reg */
void connectib_slrp_reg_pack(const struct connectib_slrp_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_slrp_reg_unpack(struct connectib_slrp_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_slrp_reg_print(const struct connectib_slrp_reg *ptr_struct, FILE* file, int indent_level);
int connectib_slrp_reg_size(void);
#define CONNECTIB_SLRP_REG_SIZE    (0x28)
void connectib_slrp_reg_dump(const struct connectib_slrp_reg *ptr_struct, FILE* file);
/* paos_reg */
void connectib_paos_reg_pack(const struct connectib_paos_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_paos_reg_unpack(struct connectib_paos_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_paos_reg_print(const struct connectib_paos_reg *ptr_struct, FILE* file, int indent_level);
int connectib_paos_reg_size(void);
#define CONNECTIB_PAOS_REG_SIZE    (0x10)
void connectib_paos_reg_dump(const struct connectib_paos_reg *ptr_struct, FILE* file);
/* mjtag */
void connectib_mjtag_pack(const struct connectib_mjtag *ptr_struct, u_int8_t* ptr_buff);
void connectib_mjtag_unpack(struct connectib_mjtag *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mjtag_print(const struct connectib_mjtag *ptr_struct, FILE* file, int indent_level);
int connectib_mjtag_size(void);
#define CONNECTIB_MJTAG_SIZE    (0x2c)
void connectib_mjtag_dump(const struct connectib_mjtag *ptr_struct, FILE* file);
/* mfbe */
void connectib_mfbe_pack(const struct connectib_mfbe *ptr_struct, u_int8_t* ptr_buff);
void connectib_mfbe_unpack(struct connectib_mfbe *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mfbe_print(const struct connectib_mfbe *ptr_struct, FILE* file, int indent_level);
int connectib_mfbe_size(void);
#define CONNECTIB_MFBE_SIZE    (0xc)
void connectib_mfbe_dump(const struct connectib_mfbe *ptr_struct, FILE* file);
/* project_mfba */
void connectib_project_mfba_pack(const struct connectib_project_mfba *ptr_struct, u_int8_t* ptr_buff);
void connectib_project_mfba_unpack(struct connectib_project_mfba *ptr_struct, const u_int8_t* ptr_buff);
void connectib_project_mfba_print(const struct connectib_project_mfba *ptr_struct, FILE* file, int indent_level);
int connectib_project_mfba_size(void);
#define CONNECTIB_PROJECT_MFBA_SIZE    (0x2c)
void connectib_project_mfba_dump(const struct connectib_project_mfba *ptr_struct, FILE* file);
/* register_misc_counters */
void connectib_register_misc_counters_pack(const struct connectib_register_misc_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_misc_counters_unpack(struct connectib_register_misc_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_misc_counters_print(const struct connectib_register_misc_counters *ptr_struct, FILE* file, int indent_level);
int connectib_register_misc_counters_size(void);
#define CONNECTIB_REGISTER_MISC_COUNTERS_SIZE    (0x20)
void connectib_register_misc_counters_dump(const struct connectib_register_misc_counters *ptr_struct, FILE* file);
/* mtmp */
void connectib_mtmp_pack(const struct connectib_mtmp *ptr_struct, u_int8_t* ptr_buff);
void connectib_mtmp_unpack(struct connectib_mtmp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mtmp_print(const struct connectib_mtmp *ptr_struct, FILE* file, int indent_level);
int connectib_mtmp_size(void);
#define CONNECTIB_MTMP_SIZE    (0x1c)
void connectib_mtmp_dump(const struct connectib_mtmp *ptr_struct, FILE* file);
/* register_mfrl */
void connectib_register_mfrl_pack(const struct connectib_register_mfrl *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_mfrl_unpack(struct connectib_register_mfrl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_mfrl_print(const struct connectib_register_mfrl *ptr_struct, FILE* file, int indent_level);
int connectib_register_mfrl_size(void);
#define CONNECTIB_REGISTER_MFRL_SIZE    (0x10)
void connectib_register_mfrl_dump(const struct connectib_register_mfrl *ptr_struct, FILE* file);
/* register_mfai */
void connectib_register_mfai_pack(const struct connectib_register_mfai *ptr_struct, u_int8_t* ptr_buff);
void connectib_register_mfai_unpack(struct connectib_register_mfai *ptr_struct, const u_int8_t* ptr_buff);
void connectib_register_mfai_print(const struct connectib_register_mfai *ptr_struct, FILE* file, int indent_level);
int connectib_register_mfai_size(void);
#define CONNECTIB_REGISTER_MFAI_SIZE    (0x10)
void connectib_register_mfai_dump(const struct connectib_register_mfai *ptr_struct, FILE* file);
/* mfpa */
void connectib_mfpa_pack(const struct connectib_mfpa *ptr_struct, u_int8_t* ptr_buff);
void connectib_mfpa_unpack(struct connectib_mfpa *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mfpa_print(const struct connectib_mfpa *ptr_struct, FILE* file, int indent_level);
int connectib_mfpa_size(void);
#define CONNECTIB_MFPA_SIZE    (0x20)
void connectib_mfpa_dump(const struct connectib_mfpa *ptr_struct, FILE* file);
/* ib_gid */
void connectib_ib_gid_pack(const struct connectib_ib_gid *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_gid_unpack(struct connectib_ib_gid *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_gid_print(const struct connectib_ib_gid *ptr_struct, FILE* file, int indent_level);
int connectib_ib_gid_size(void);
#define CONNECTIB_IB_GID_SIZE    (0x10)
void connectib_ib_gid_dump(const struct connectib_ib_gid *ptr_struct, FILE* file);
/* dmfs_hash_meta */
void connectib_dmfs_hash_meta_pack(const struct connectib_dmfs_hash_meta *ptr_struct, u_int8_t* ptr_buff);
void connectib_dmfs_hash_meta_unpack(struct connectib_dmfs_hash_meta *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dmfs_hash_meta_print(const struct connectib_dmfs_hash_meta *ptr_struct, FILE* file, int indent_level);
int connectib_dmfs_hash_meta_size(void);
#define CONNECTIB_DMFS_HASH_META_SIZE    (0x10)
void connectib_dmfs_hash_meta_dump(const struct connectib_dmfs_hash_meta *ptr_struct, FILE* file);
/* dmfs_fte_meta */
void connectib_dmfs_fte_meta_pack(const struct connectib_dmfs_fte_meta *ptr_struct, u_int8_t* ptr_buff);
void connectib_dmfs_fte_meta_unpack(struct connectib_dmfs_fte_meta *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dmfs_fte_meta_print(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file, int indent_level);
int connectib_dmfs_fte_meta_size(void);
#define CONNECTIB_DMFS_FTE_META_SIZE    (0x8)
void connectib_dmfs_fte_meta_dump(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file);
/* dmfs_ft_meta */
void connectib_dmfs_ft_meta_pack(const struct connectib_dmfs_ft_meta *ptr_struct, u_int8_t* ptr_buff);
void connectib_dmfs_ft_meta_unpack(struct connectib_dmfs_ft_meta *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dmfs_ft_meta_print(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file, int indent_level);
int connectib_dmfs_ft_meta_size(void);
#define CONNECTIB_DMFS_FT_META_SIZE    (0x20)
void connectib_dmfs_ft_meta_dump(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file);
/* dmfs_group_meta */
void connectib_dmfs_group_meta_pack(const struct connectib_dmfs_group_meta *ptr_struct, u_int8_t* ptr_buff);
void connectib_dmfs_group_meta_unpack(struct connectib_dmfs_group_meta *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dmfs_group_meta_print(const struct connectib_dmfs_group_meta *ptr_struct, FILE* file, int indent_level);
int connectib_dmfs_group_meta_size(void);
#define CONNECTIB_DMFS_GROUP_META_SIZE    (0x40)
void connectib_dmfs_group_meta_dump(const struct connectib_dmfs_group_meta *ptr_struct, FILE* file);
/* mkey_dump */
void connectib_mkey_dump_pack(const struct connectib_mkey_dump *ptr_struct, u_int8_t* ptr_buff);
void connectib_mkey_dump_unpack(struct connectib_mkey_dump *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mkey_dump_print(const struct connectib_mkey_dump *ptr_struct, FILE* file, int indent_level);
int connectib_mkey_dump_size(void);
#define CONNECTIB_MKEY_DUMP_SIZE    (0x4)
void connectib_mkey_dump_dump(const struct connectib_mkey_dump *ptr_struct, FILE* file);
/* fw_tis */
void connectib_fw_tis_pack(const struct connectib_fw_tis *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_tis_unpack(struct connectib_fw_tis *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_tis_print(const struct connectib_fw_tis *ptr_struct, FILE* file, int indent_level);
int connectib_fw_tis_size(void);
#define CONNECTIB_FW_TIS_SIZE    (0x40)
void connectib_fw_tis_dump(const struct connectib_fw_tis *ptr_struct, FILE* file);
/* fw_tir */
void connectib_fw_tir_pack(const struct connectib_fw_tir *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_tir_unpack(struct connectib_fw_tir *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_tir_print(const struct connectib_fw_tir *ptr_struct, FILE* file, int indent_level);
int connectib_fw_tir_size(void);
#define CONNECTIB_FW_TIR_SIZE    (0x40)
void connectib_fw_tir_dump(const struct connectib_fw_tir *ptr_struct, FILE* file);
/* fw_qpc */
void connectib_fw_qpc_pack(const struct connectib_fw_qpc *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_qpc_unpack(struct connectib_fw_qpc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_qpc_print(const struct connectib_fw_qpc *ptr_struct, FILE* file, int indent_level);
int connectib_fw_qpc_size(void);
#define CONNECTIB_FW_QPC_SIZE    (0x40)
void connectib_fw_qpc_dump(const struct connectib_fw_qpc *ptr_struct, FILE* file);
/* fw_srqc */
void connectib_fw_srqc_pack(const struct connectib_fw_srqc *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_srqc_unpack(struct connectib_fw_srqc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_srqc_print(const struct connectib_fw_srqc *ptr_struct, FILE* file, int indent_level);
int connectib_fw_srqc_size(void);
#define CONNECTIB_FW_SRQC_SIZE    (0x40)
void connectib_fw_srqc_dump(const struct connectib_fw_srqc *ptr_struct, FILE* file);
/* sw_ads */
void connectib_sw_ads_pack(const struct connectib_sw_ads *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_ads_unpack(struct connectib_sw_ads *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_ads_print(const struct connectib_sw_ads *ptr_struct, FILE* file, int indent_level);
int connectib_sw_ads_size(void);
#define CONNECTIB_SW_ADS_SIZE    (0x2c)
void connectib_sw_ads_dump(const struct connectib_sw_ads *ptr_struct, FILE* file);
/* hw_msix_ext_context */
void connectib_hw_msix_ext_context_pack(const struct connectib_hw_msix_ext_context *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_ext_context_unpack(struct connectib_hw_msix_ext_context *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_ext_context_print(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_ext_context_size(void);
#define CONNECTIB_HW_MSIX_EXT_CONTEXT_SIZE    (0x10)
void connectib_hw_msix_ext_context_dump(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file);
/* hw_msix_context */
void connectib_hw_msix_context_pack(const struct connectib_hw_msix_context *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_context_unpack(struct connectib_hw_msix_context *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_context_print(const struct connectib_hw_msix_context *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_context_size(void);
#define CONNECTIB_HW_MSIX_CONTEXT_SIZE    (0x10)
void connectib_hw_msix_context_dump(const struct connectib_hw_msix_context *ptr_struct, FILE* file);
/* hw_rdb_atomic_data */
void connectib_hw_rdb_atomic_data_pack(const struct connectib_hw_rdb_atomic_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_rdb_atomic_data_unpack(struct connectib_hw_rdb_atomic_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_rdb_atomic_data_print(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file, int indent_level);
int connectib_hw_rdb_atomic_data_size(void);
#define CONNECTIB_HW_RDB_ATOMIC_DATA_SIZE    (0x20)
void connectib_hw_rdb_atomic_data_dump(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file);
/* hw_mtt2 */
void connectib_hw_mtt2_pack(const struct connectib_hw_mtt2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_mtt2_unpack(struct connectib_hw_mtt2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_mtt2_print(const struct connectib_hw_mtt2 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_mtt2_size(void);
#define CONNECTIB_HW_MTT2_SIZE    (0x8)
void connectib_hw_mtt2_dump(const struct connectib_hw_mtt2 *ptr_struct, FILE* file);
/* hw_mtt */
void connectib_hw_mtt_pack(const struct connectib_hw_mtt *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_mtt_unpack(struct connectib_hw_mtt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_mtt_print(const struct connectib_hw_mtt *ptr_struct, FILE* file, int indent_level);
int connectib_hw_mtt_size(void);
#define CONNECTIB_HW_MTT_SIZE    (0x8)
void connectib_hw_mtt_dump(const struct connectib_hw_mtt *ptr_struct, FILE* file);
/* steering_qp_list */
void connectib_steering_qp_list_pack(const struct connectib_steering_qp_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_steering_qp_list_unpack(struct connectib_steering_qp_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_steering_qp_list_print(const struct connectib_steering_qp_list *ptr_struct, FILE* file, int indent_level);
int connectib_steering_qp_list_size(void);
#define CONNECTIB_STEERING_QP_LIST_SIZE    (0x40)
void connectib_steering_qp_list_dump(const struct connectib_steering_qp_list *ptr_struct, FILE* file);
/* hw_ste */
void connectib_hw_ste_pack(const struct connectib_hw_ste *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_ste_unpack(struct connectib_hw_ste *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_ste_print(const struct connectib_hw_ste *ptr_struct, FILE* file, int indent_level);
int connectib_hw_ste_size(void);
#define CONNECTIB_HW_STE_SIZE    (0x40)
void connectib_hw_ste_dump(const struct connectib_hw_ste *ptr_struct, FILE* file);
/* hw_timer */
void connectib_hw_timer_pack(const struct connectib_hw_timer *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_timer_unpack(struct connectib_hw_timer *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_timer_print(const struct connectib_hw_timer *ptr_struct, FILE* file, int indent_level);
int connectib_hw_timer_size(void);
#define CONNECTIB_HW_TIMER_SIZE    (0x1)
void connectib_hw_timer_dump(const struct connectib_hw_timer *ptr_struct, FILE* file);
/* hw_bsf_entry_w_non_repeating_m_non_repeating */
void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_W_NON_REPEATING_M_NON_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file);
/* hw_bsf_entry_w_non_repeating_m_repeating */
void connectib_hw_bsf_entry_w_non_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_non_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_non_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_w_non_repeating_m_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_W_NON_REPEATING_M_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_w_non_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file);
/* hw_bsf_entry_w_repeating_m_non_repeating */
void connectib_hw_bsf_entry_w_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_w_repeating_m_non_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_W_REPEATING_M_NON_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_w_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file);
/* hw_bsf_entry_w_repeating_m_repeating */
void connectib_hw_bsf_entry_w_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_w_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_w_repeating_m_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_W_REPEATING_M_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_w_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file);
/* hw_bsf_entry_same_block_non_repeating */
void connectib_hw_bsf_entry_same_block_non_repeating_pack(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_same_block_non_repeating_unpack(struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_same_block_non_repeating_print(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_same_block_non_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_SAME_BLOCK_NON_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_same_block_non_repeating_dump(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file);
/* hw_bsf_entry_same_block_repeating */
void connectib_hw_bsf_entry_same_block_repeating_pack(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_same_block_repeating_unpack(struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_same_block_repeating_print(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_same_block_repeating_size(void);
#define CONNECTIB_HW_BSF_ENTRY_SAME_BLOCK_REPEATING_SIZE    (0x40)
void connectib_hw_bsf_entry_same_block_repeating_dump(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file);
/* hw_dct */
void connectib_hw_dct_pack(const struct connectib_hw_dct *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_dct_unpack(struct connectib_hw_dct *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_dct_print(const struct connectib_hw_dct *ptr_struct, FILE* file, int indent_level);
int connectib_hw_dct_size(void);
#define CONNECTIB_HW_DCT_SIZE    (0x40)
void connectib_hw_dct_dump(const struct connectib_hw_dct *ptr_struct, FILE* file);
/* hw_r_qpc_ud_l2_cd */
void connectib_hw_r_qpc_ud_l2_cd_pack(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_cd_unpack(struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_cd_print(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_ud_l2_cd_size(void);
#define CONNECTIB_HW_R_QPC_UD_L2_CD_SIZE    (0x40)
void connectib_hw_r_qpc_ud_l2_cd_dump(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, FILE* file);
/* hw_r_qpc_ud_l2_2srq */
void connectib_hw_r_qpc_ud_l2_2srq_pack(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_2srq_unpack(struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_2srq_print(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_ud_l2_2srq_size(void);
#define CONNECTIB_HW_R_QPC_UD_L2_2SRQ_SIZE    (0x40)
void connectib_hw_r_qpc_ud_l2_2srq_dump(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, FILE* file);
/* hw_r_qpc_ud_l2_2cyclicbuff */
void connectib_hw_r_qpc_ud_l2_2cyclicbuff_pack(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_2cyclicbuff_unpack(struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_2cyclicbuff_print(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_ud_l2_2cyclicbuff_size(void);
#define CONNECTIB_HW_R_QPC_UD_L2_2CYCLICBUFF_SIZE    (0x40)
void connectib_hw_r_qpc_ud_l2_2cyclicbuff_dump(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, FILE* file);
/* hw_r_qpc_ud_l2 */
void connectib_hw_r_qpc_ud_l2_pack(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_unpack(struct connectib_hw_r_qpc_ud_l2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_ud_l2_print(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_ud_l2_size(void);
#define CONNECTIB_HW_R_QPC_UD_L2_SIZE    (0x40)
void connectib_hw_r_qpc_ud_l2_dump(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, FILE* file);
/* hw_r_qpc_unconnected_common */
void connectib_hw_r_qpc_unconnected_common_pack(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_unconnected_common_unpack(struct connectib_hw_r_qpc_unconnected_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_unconnected_common_print(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_unconnected_common_size(void);
#define CONNECTIB_HW_R_QPC_UNCONNECTED_COMMON_SIZE    (0x40)
void connectib_hw_r_qpc_unconnected_common_dump(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, FILE* file);
/* hw_r_qpc_xrc */
void connectib_hw_r_qpc_xrc_pack(const struct connectib_hw_r_qpc_xrc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_xrc_unpack(struct connectib_hw_r_qpc_xrc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_xrc_print(const struct connectib_hw_r_qpc_xrc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_xrc_size(void);
#define CONNECTIB_HW_R_QPC_XRC_SIZE    (0x40)
void connectib_hw_r_qpc_xrc_dump(const struct connectib_hw_r_qpc_xrc *ptr_struct, FILE* file);
/* hw_r_qpc_dcr */
void connectib_hw_r_qpc_dcr_pack(const struct connectib_hw_r_qpc_dcr *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_dcr_unpack(struct connectib_hw_r_qpc_dcr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_dcr_print(const struct connectib_hw_r_qpc_dcr *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_dcr_size(void);
#define CONNECTIB_HW_R_QPC_DCR_SIZE    (0x40)
void connectib_hw_r_qpc_dcr_dump(const struct connectib_hw_r_qpc_dcr *ptr_struct, FILE* file);
/* hw_r_qpc_rc_uc_2srq */
void connectib_hw_r_qpc_rc_uc_2srq_pack(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_2srq_unpack(struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_2srq_print(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_rc_uc_2srq_size(void);
#define CONNECTIB_HW_R_QPC_RC_UC_2SRQ_SIZE    (0x40)
void connectib_hw_r_qpc_rc_uc_2srq_dump(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, FILE* file);
/* hw_r_qpc_rc_uc_2cycbuff */
void connectib_hw_r_qpc_rc_uc_2cycbuff_pack(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_2cycbuff_unpack(struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_2cycbuff_print(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_rc_uc_2cycbuff_size(void);
#define CONNECTIB_HW_R_QPC_RC_UC_2CYCBUFF_SIZE    (0x40)
void connectib_hw_r_qpc_rc_uc_2cycbuff_dump(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, FILE* file);
/* hw_r_qpc_rc_uc_cd */
void connectib_hw_r_qpc_rc_uc_cd_pack(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_cd_unpack(struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_cd_print(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_rc_uc_cd_size(void);
#define CONNECTIB_HW_R_QPC_RC_UC_CD_SIZE    (0x40)
void connectib_hw_r_qpc_rc_uc_cd_dump(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, FILE* file);
/* hw_r_qpc_rc_uc_dci */
void connectib_hw_r_qpc_rc_uc_dci_pack(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_dci_unpack(struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_rc_uc_dci_print(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_rc_uc_dci_size(void);
#define CONNECTIB_HW_R_QPC_RC_UC_DCI_SIZE    (0x40)
void connectib_hw_r_qpc_rc_uc_dci_dump(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, FILE* file);
/* hw_r_qpc_connected_common */
void connectib_hw_r_qpc_connected_common_pack(const struct connectib_hw_r_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_connected_common_unpack(struct connectib_hw_r_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_connected_common_print(const struct connectib_hw_r_qpc_connected_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_connected_common_size(void);
#define CONNECTIB_HW_R_QPC_CONNECTED_COMMON_SIZE    (0x40)
void connectib_hw_r_qpc_connected_common_dump(const struct connectib_hw_r_qpc_connected_common *ptr_struct, FILE* file);
/* hw_r_qpc_common */
void connectib_hw_r_qpc_common_pack(const struct connectib_hw_r_qpc_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_common_unpack(struct connectib_hw_r_qpc_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_common_print(const struct connectib_hw_r_qpc_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_common_size(void);
#define CONNECTIB_HW_R_QPC_COMMON_SIZE    (0x40)
void connectib_hw_r_qpc_common_dump(const struct connectib_hw_r_qpc_common *ptr_struct, FILE* file);
/* hw_s_qpc_ud_l2 */
void connectib_hw_s_qpc_ud_l2_pack(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_ud_l2_unpack(struct connectib_hw_s_qpc_ud_l2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_ud_l2_print(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_ud_l2_size(void);
#define CONNECTIB_HW_S_QPC_UD_L2_SIZE    (0x40)
void connectib_hw_s_qpc_ud_l2_dump(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, FILE* file);
/* hw_s_qpc_dci */
void connectib_hw_s_qpc_dci_pack(const struct connectib_hw_s_qpc_dci *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_dci_unpack(struct connectib_hw_s_qpc_dci *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_dci_print(const struct connectib_hw_s_qpc_dci *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_dci_size(void);
#define CONNECTIB_HW_S_QPC_DCI_SIZE    (0x40)
void connectib_hw_s_qpc_dci_dump(const struct connectib_hw_s_qpc_dci *ptr_struct, FILE* file);
/* hw_s_qpc_rc_uc_dcr */
void connectib_hw_s_qpc_rc_uc_dcr_pack(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_rc_uc_dcr_unpack(struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_rc_uc_dcr_print(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_rc_uc_dcr_size(void);
#define CONNECTIB_HW_S_QPC_RC_UC_DCR_SIZE    (0x40)
void connectib_hw_s_qpc_rc_uc_dcr_dump(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, FILE* file);
/* hw_s_qpc_connected_common */
void connectib_hw_s_qpc_connected_common_pack(const struct connectib_hw_s_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_connected_common_unpack(struct connectib_hw_s_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_connected_common_print(const struct connectib_hw_s_qpc_connected_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_connected_common_size(void);
#define CONNECTIB_HW_S_QPC_CONNECTED_COMMON_SIZE    (0x40)
void connectib_hw_s_qpc_connected_common_dump(const struct connectib_hw_s_qpc_connected_common *ptr_struct, FILE* file);
/* hw_s_qpc_common */
void connectib_hw_s_qpc_common_pack(const struct connectib_hw_s_qpc_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_common_unpack(struct connectib_hw_s_qpc_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_common_print(const struct connectib_hw_s_qpc_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_common_size(void);
#define CONNECTIB_HW_S_QPC_COMMON_SIZE    (0x40)
void connectib_hw_s_qpc_common_dump(const struct connectib_hw_s_qpc_common *ptr_struct, FILE* file);
/* hw_c_qpc_unconnected_2cycbuff */
void connectib_hw_c_qpc_unconnected_2cycbuff_pack(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_2cycbuff_unpack(struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_2cycbuff_print(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_unconnected_2cycbuff_size(void);
#define CONNECTIB_HW_C_QPC_UNCONNECTED_2CYCBUFF_SIZE    (0x40)
void connectib_hw_c_qpc_unconnected_2cycbuff_dump(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, FILE* file);
/* hw_c_qpc_unconnected */
void connectib_hw_c_qpc_unconnected_pack(const struct connectib_hw_c_qpc_unconnected *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_unpack(struct connectib_hw_c_qpc_unconnected *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_print(const struct connectib_hw_c_qpc_unconnected *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_unconnected_size(void);
#define CONNECTIB_HW_C_QPC_UNCONNECTED_SIZE    (0x40)
void connectib_hw_c_qpc_unconnected_dump(const struct connectib_hw_c_qpc_unconnected *ptr_struct, FILE* file);
/* hw_c_qpc_unconnected_common */
void connectib_hw_c_qpc_unconnected_common_pack(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_common_unpack(struct connectib_hw_c_qpc_unconnected_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unconnected_common_print(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_unconnected_common_size(void);
#define CONNECTIB_HW_C_QPC_UNCONNECTED_COMMON_SIZE    (0x40)
void connectib_hw_c_qpc_unconnected_common_dump(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, FILE* file);
/* hw_c_qpc_connected_dual */
void connectib_hw_c_qpc_connected_dual_pack(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_dual_unpack(struct connectib_hw_c_qpc_connected_dual *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_dual_print(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_connected_dual_size(void);
#define CONNECTIB_HW_C_QPC_CONNECTED_DUAL_SIZE    (0x40)
void connectib_hw_c_qpc_connected_dual_dump(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, FILE* file);
/* hw_c_qpc_connected_2cycbuff */
void connectib_hw_c_qpc_connected_2cycbuff_pack(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_2cycbuff_unpack(struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_2cycbuff_print(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_connected_2cycbuff_size(void);
#define CONNECTIB_HW_C_QPC_CONNECTED_2CYCBUFF_SIZE    (0x40)
void connectib_hw_c_qpc_connected_2cycbuff_dump(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, FILE* file);
/* hw_c_qpc_connected */
void connectib_hw_c_qpc_connected_pack(const struct connectib_hw_c_qpc_connected *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_unpack(struct connectib_hw_c_qpc_connected *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_print(const struct connectib_hw_c_qpc_connected *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_connected_size(void);
#define CONNECTIB_HW_C_QPC_CONNECTED_SIZE    (0x40)
void connectib_hw_c_qpc_connected_dump(const struct connectib_hw_c_qpc_connected *ptr_struct, FILE* file);
/* hw_c_qpc_connected_common */
void connectib_hw_c_qpc_connected_common_pack(const struct connectib_hw_c_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_common_unpack(struct connectib_hw_c_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_connected_common_print(const struct connectib_hw_c_qpc_connected_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_connected_common_size(void);
#define CONNECTIB_HW_C_QPC_CONNECTED_COMMON_SIZE    (0x40)
void connectib_hw_c_qpc_connected_common_dump(const struct connectib_hw_c_qpc_connected_common *ptr_struct, FILE* file);
/* hw_c_qpc_common */
void connectib_hw_c_qpc_common_pack(const struct connectib_hw_c_qpc_common *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_common_unpack(struct connectib_hw_c_qpc_common *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_common_print(const struct connectib_hw_c_qpc_common *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_common_size(void);
#define CONNECTIB_HW_C_QPC_COMMON_SIZE    (0x40)
void connectib_hw_c_qpc_common_dump(const struct connectib_hw_c_qpc_common *ptr_struct, FILE* file);
/* pf_vf_cfg_space */
void connectib_pf_vf_cfg_space_pack(const struct connectib_pf_vf_cfg_space *ptr_struct, u_int8_t* ptr_buff);
void connectib_pf_vf_cfg_space_unpack(struct connectib_pf_vf_cfg_space *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pf_vf_cfg_space_print(const struct connectib_pf_vf_cfg_space *ptr_struct, FILE* file, int indent_level);
int connectib_pf_vf_cfg_space_size(void);
#define CONNECTIB_PF_VF_CFG_SPACE_SIZE    (0x1c)
void connectib_pf_vf_cfg_space_dump(const struct connectib_pf_vf_cfg_space *ptr_struct, FILE* file);
/* hw_init_info */
void connectib_hw_init_info_pack(const struct connectib_hw_init_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_init_info_unpack(struct connectib_hw_init_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_init_info_print(const struct connectib_hw_init_info *ptr_struct, FILE* file, int indent_level);
int connectib_hw_init_info_size(void);
#define CONNECTIB_HW_INIT_INFO_SIZE    (0x4)
void connectib_hw_init_info_dump(const struct connectib_hw_init_info *ptr_struct, FILE* file);
/* mlnx_enhanced_equal_info_ini */
void connectib_mlnx_enhanced_equal_info_ini_pack(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_mlnx_enhanced_equal_info_ini_unpack(struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mlnx_enhanced_equal_info_ini_print(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, FILE* file, int indent_level);
int connectib_mlnx_enhanced_equal_info_ini_size(void);
#define CONNECTIB_MLNX_ENHANCED_EQUAL_INFO_INI_SIZE    (0x4)
void connectib_mlnx_enhanced_equal_info_ini_dump(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, FILE* file);
/* mlpn_database_all_protocol_bits_ini */
void connectib_mlpn_database_all_protocol_bits_ini_pack(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_mlpn_database_all_protocol_bits_ini_unpack(struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mlpn_database_all_protocol_bits_ini_print(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, FILE* file, int indent_level);
int connectib_mlpn_database_all_protocol_bits_ini_size(void);
#define CONNECTIB_MLPN_DATABASE_ALL_PROTOCOL_BITS_INI_SIZE    (0x4)
void connectib_mlpn_database_all_protocol_bits_ini_dump(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, FILE* file);
/* serdes_preset_sets_ini */
void connectib_serdes_preset_sets_ini_pack(const struct connectib_serdes_preset_sets_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_preset_sets_ini_unpack(struct connectib_serdes_preset_sets_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_preset_sets_ini_print(const struct connectib_serdes_preset_sets_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_preset_sets_ini_size(void);
#define CONNECTIB_SERDES_PRESET_SETS_INI_SIZE    (0x40)
void connectib_serdes_preset_sets_ini_dump(const struct connectib_serdes_preset_sets_ini *ptr_struct, FILE* file);
/* serdes_active_sets_ini */
void connectib_serdes_active_sets_ini_pack(const struct connectib_serdes_active_sets_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_active_sets_ini_unpack(struct connectib_serdes_active_sets_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_active_sets_ini_print(const struct connectib_serdes_active_sets_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_active_sets_ini_size(void);
#define CONNECTIB_SERDES_ACTIVE_SETS_INI_SIZE    (0x30)
void connectib_serdes_active_sets_ini_dump(const struct connectib_serdes_active_sets_ini *ptr_struct, FILE* file);
/* serdes_force_sets_ini */
void connectib_serdes_force_sets_ini_pack(const struct connectib_serdes_force_sets_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_force_sets_ini_unpack(struct connectib_serdes_force_sets_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_force_sets_ini_print(const struct connectib_serdes_force_sets_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_force_sets_ini_size(void);
#define CONNECTIB_SERDES_FORCE_SETS_INI_SIZE    (0x78)
void connectib_serdes_force_sets_ini_dump(const struct connectib_serdes_force_sets_ini *ptr_struct, FILE* file);
/* serdes_aba_sets_ini */
void connectib_serdes_aba_sets_ini_pack(const struct connectib_serdes_aba_sets_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_aba_sets_ini_unpack(struct connectib_serdes_aba_sets_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_aba_sets_ini_print(const struct connectib_serdes_aba_sets_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_aba_sets_ini_size(void);
#define CONNECTIB_SERDES_ABA_SETS_INI_SIZE    (0x180)
void connectib_serdes_aba_sets_ini_dump(const struct connectib_serdes_aba_sets_ini *ptr_struct, FILE* file);
/* serdes_autoneg_sets_ini */
void connectib_serdes_autoneg_sets_ini_pack(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_autoneg_sets_ini_unpack(struct connectib_serdes_autoneg_sets_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_autoneg_sets_ini_print(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_autoneg_sets_ini_size(void);
#define CONNECTIB_SERDES_AUTONEG_SETS_INI_SIZE    (0x180)
void connectib_serdes_autoneg_sets_ini_dump(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, FILE* file);
/* spec1_3_preset_ini */
void connectib_spec1_3_preset_ini_pack(const struct connectib_spec1_3_preset_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_spec1_3_preset_ini_unpack(struct connectib_spec1_3_preset_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_spec1_3_preset_ini_print(const struct connectib_spec1_3_preset_ini *ptr_struct, FILE* file, int indent_level);
int connectib_spec1_3_preset_ini_size(void);
#define CONNECTIB_SPEC1_3_PRESET_INI_SIZE    (0x4c)
void connectib_spec1_3_preset_ini_dump(const struct connectib_spec1_3_preset_ini *ptr_struct, FILE* file);
/* ib_ini_per_lcl_ini */
void connectib_ib_ini_per_lcl_ini_pack(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_ini_per_lcl_ini_unpack(struct connectib_ib_ini_per_lcl_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_ini_per_lcl_ini_print(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, FILE* file, int indent_level);
int connectib_ib_ini_per_lcl_ini_size(void);
#define CONNECTIB_IB_INI_PER_LCL_INI_SIZE    (0x4)
void connectib_ib_ini_per_lcl_ini_dump(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, FILE* file);
/* serdes_param_mask_ini */
void connectib_serdes_param_mask_ini_pack(const struct connectib_serdes_param_mask_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_param_mask_ini_unpack(struct connectib_serdes_param_mask_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_param_mask_ini_print(const struct connectib_serdes_param_mask_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_param_mask_ini_size(void);
#define CONNECTIB_SERDES_PARAM_MASK_INI_SIZE    (0x10)
void connectib_serdes_param_mask_ini_dump(const struct connectib_serdes_param_mask_ini *ptr_struct, FILE* file);
/* nv_tlv_data_tpt_capabilities */
void connectib_nv_tlv_data_tpt_capabilities_pack(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_data_tpt_capabilities_unpack(struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_data_tpt_capabilities_print(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_data_tpt_capabilities_size(void);
#define CONNECTIB_NV_TLV_DATA_TPT_CAPABILITIES_SIZE    (0x4)
void connectib_nv_tlv_data_tpt_capabilities_dump(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, FILE* file);
/* nv_tlv_data_tpt_settings */
void connectib_nv_tlv_data_tpt_settings_pack(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_data_tpt_settings_unpack(struct connectib_nv_tlv_data_tpt_settings *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_data_tpt_settings_print(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_data_tpt_settings_size(void);
#define CONNECTIB_NV_TLV_DATA_TPT_SETTINGS_SIZE    (0x4)
void connectib_nv_tlv_data_tpt_settings_dump(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, FILE* file);
/* nv_tlv_data_pci_capabilities */
void connectib_nv_tlv_data_pci_capabilities_pack(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_data_pci_capabilities_unpack(struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_data_pci_capabilities_print(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_data_pci_capabilities_size(void);
#define CONNECTIB_NV_TLV_DATA_PCI_CAPABILITIES_SIZE    (0x14)
void connectib_nv_tlv_data_pci_capabilities_dump(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, FILE* file);
/* nv_tlv_data_pci_settings */
void connectib_nv_tlv_data_pci_settings_pack(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_data_pci_settings_unpack(struct connectib_nv_tlv_data_pci_settings *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_data_pci_settings_print(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_data_pci_settings_size(void);
#define CONNECTIB_NV_TLV_DATA_PCI_SETTINGS_SIZE    (0xc)
void connectib_nv_tlv_data_pci_settings_dump(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, FILE* file);
/* header_log */
void connectib_header_log_pack(const struct connectib_header_log *ptr_struct, u_int8_t* ptr_buff);
void connectib_header_log_unpack(struct connectib_header_log *ptr_struct, const u_int8_t* ptr_buff);
void connectib_header_log_print(const struct connectib_header_log *ptr_struct, FILE* file, int indent_level);
int connectib_header_log_size(void);
#define CONNECTIB_HEADER_LOG_SIZE    (0x10)
void connectib_header_log_dump(const struct connectib_header_log *ptr_struct, FILE* file);
/* advanced_error_cap_ctl */
void connectib_advanced_error_cap_ctl_pack(const struct connectib_advanced_error_cap_ctl *ptr_struct, u_int8_t* ptr_buff);
void connectib_advanced_error_cap_ctl_unpack(struct connectib_advanced_error_cap_ctl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_advanced_error_cap_ctl_print(const struct connectib_advanced_error_cap_ctl *ptr_struct, FILE* file, int indent_level);
int connectib_advanced_error_cap_ctl_size(void);
#define CONNECTIB_ADVANCED_ERROR_CAP_CTL_SIZE    (0x4)
void connectib_advanced_error_cap_ctl_dump(const struct connectib_advanced_error_cap_ctl *ptr_struct, FILE* file);
/* correctable_error_mask */
void connectib_correctable_error_mask_pack(const struct connectib_correctable_error_mask *ptr_struct, u_int8_t* ptr_buff);
void connectib_correctable_error_mask_unpack(struct connectib_correctable_error_mask *ptr_struct, const u_int8_t* ptr_buff);
void connectib_correctable_error_mask_print(const struct connectib_correctable_error_mask *ptr_struct, FILE* file, int indent_level);
int connectib_correctable_error_mask_size(void);
#define CONNECTIB_CORRECTABLE_ERROR_MASK_SIZE    (0x4)
void connectib_correctable_error_mask_dump(const struct connectib_correctable_error_mask *ptr_struct, FILE* file);
/* correctable_error_status */
void connectib_correctable_error_status_pack(const struct connectib_correctable_error_status *ptr_struct, u_int8_t* ptr_buff);
void connectib_correctable_error_status_unpack(struct connectib_correctable_error_status *ptr_struct, const u_int8_t* ptr_buff);
void connectib_correctable_error_status_print(const struct connectib_correctable_error_status *ptr_struct, FILE* file, int indent_level);
int connectib_correctable_error_status_size(void);
#define CONNECTIB_CORRECTABLE_ERROR_STATUS_SIZE    (0x4)
void connectib_correctable_error_status_dump(const struct connectib_correctable_error_status *ptr_struct, FILE* file);
/* uncorrectable_error_severity */
void connectib_uncorrectable_error_severity_pack(const struct connectib_uncorrectable_error_severity *ptr_struct, u_int8_t* ptr_buff);
void connectib_uncorrectable_error_severity_unpack(struct connectib_uncorrectable_error_severity *ptr_struct, const u_int8_t* ptr_buff);
void connectib_uncorrectable_error_severity_print(const struct connectib_uncorrectable_error_severity *ptr_struct, FILE* file, int indent_level);
int connectib_uncorrectable_error_severity_size(void);
#define CONNECTIB_UNCORRECTABLE_ERROR_SEVERITY_SIZE    (0x4)
void connectib_uncorrectable_error_severity_dump(const struct connectib_uncorrectable_error_severity *ptr_struct, FILE* file);
/* uncorrectable_error_mask */
void connectib_uncorrectable_error_mask_pack(const struct connectib_uncorrectable_error_mask *ptr_struct, u_int8_t* ptr_buff);
void connectib_uncorrectable_error_mask_unpack(struct connectib_uncorrectable_error_mask *ptr_struct, const u_int8_t* ptr_buff);
void connectib_uncorrectable_error_mask_print(const struct connectib_uncorrectable_error_mask *ptr_struct, FILE* file, int indent_level);
int connectib_uncorrectable_error_mask_size(void);
#define CONNECTIB_UNCORRECTABLE_ERROR_MASK_SIZE    (0x4)
void connectib_uncorrectable_error_mask_dump(const struct connectib_uncorrectable_error_mask *ptr_struct, FILE* file);
/* uncorrectable_error_status */
void connectib_uncorrectable_error_status_pack(const struct connectib_uncorrectable_error_status *ptr_struct, u_int8_t* ptr_buff);
void connectib_uncorrectable_error_status_unpack(struct connectib_uncorrectable_error_status *ptr_struct, const u_int8_t* ptr_buff);
void connectib_uncorrectable_error_status_print(const struct connectib_uncorrectable_error_status *ptr_struct, FILE* file, int indent_level);
int connectib_uncorrectable_error_status_size(void);
#define CONNECTIB_UNCORRECTABLE_ERROR_STATUS_SIZE    (0x4)
void connectib_uncorrectable_error_status_dump(const struct connectib_uncorrectable_error_status *ptr_struct, FILE* file);
/* bar_high */
void connectib_bar_high_pack(const struct connectib_bar_high *ptr_struct, u_int8_t* ptr_buff);
void connectib_bar_high_unpack(struct connectib_bar_high *ptr_struct, const u_int8_t* ptr_buff);
void connectib_bar_high_print(const struct connectib_bar_high *ptr_struct, FILE* file, int indent_level);
int connectib_bar_high_size(void);
#define CONNECTIB_BAR_HIGH_SIZE    (0x4)
void connectib_bar_high_dump(const struct connectib_bar_high *ptr_struct, FILE* file);
/* bar_low */
void connectib_bar_low_pack(const struct connectib_bar_low *ptr_struct, u_int8_t* ptr_buff);
void connectib_bar_low_unpack(struct connectib_bar_low *ptr_struct, const u_int8_t* ptr_buff);
void connectib_bar_low_print(const struct connectib_bar_low *ptr_struct, FILE* file, int indent_level);
int connectib_bar_low_size(void);
#define CONNECTIB_BAR_LOW_SIZE    (0x4)
void connectib_bar_low_dump(const struct connectib_bar_low *ptr_struct, FILE* file);
/* sriov_status */
void connectib_sriov_status_pack(const struct connectib_sriov_status *ptr_struct, u_int8_t* ptr_buff);
void connectib_sriov_status_unpack(struct connectib_sriov_status *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sriov_status_print(const struct connectib_sriov_status *ptr_struct, FILE* file, int indent_level);
int connectib_sriov_status_size(void);
#define CONNECTIB_SRIOV_STATUS_SIZE    (0x2)
void connectib_sriov_status_dump(const struct connectib_sriov_status *ptr_struct, FILE* file);
/* sriov_control */
void connectib_sriov_control_pack(const struct connectib_sriov_control *ptr_struct, u_int8_t* ptr_buff);
void connectib_sriov_control_unpack(struct connectib_sriov_control *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sriov_control_print(const struct connectib_sriov_control *ptr_struct, FILE* file, int indent_level);
int connectib_sriov_control_size(void);
#define CONNECTIB_SRIOV_CONTROL_SIZE    (0x2)
void connectib_sriov_control_dump(const struct connectib_sriov_control *ptr_struct, FILE* file);
/* sriov_capabilities */
void connectib_sriov_capabilities_pack(const struct connectib_sriov_capabilities *ptr_struct, u_int8_t* ptr_buff);
void connectib_sriov_capabilities_unpack(struct connectib_sriov_capabilities *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sriov_capabilities_print(const struct connectib_sriov_capabilities *ptr_struct, FILE* file, int indent_level);
int connectib_sriov_capabilities_size(void);
#define CONNECTIB_SRIOV_CAPABILITIES_SIZE    (0x4)
void connectib_sriov_capabilities_dump(const struct connectib_sriov_capabilities *ptr_struct, FILE* file);
/* ari_control */
void connectib_ari_control_pack(const struct connectib_ari_control *ptr_struct, u_int8_t* ptr_buff);
void connectib_ari_control_unpack(struct connectib_ari_control *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ari_control_print(const struct connectib_ari_control *ptr_struct, FILE* file, int indent_level);
int connectib_ari_control_size(void);
#define CONNECTIB_ARI_CONTROL_SIZE    (0x2)
void connectib_ari_control_dump(const struct connectib_ari_control *ptr_struct, FILE* file);
/* ari_capabilities */
void connectib_ari_capabilities_pack(const struct connectib_ari_capabilities *ptr_struct, u_int8_t* ptr_buff);
void connectib_ari_capabilities_unpack(struct connectib_ari_capabilities *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ari_capabilities_print(const struct connectib_ari_capabilities *ptr_struct, FILE* file, int indent_level);
int connectib_ari_capabilities_size(void);
#define CONNECTIB_ARI_CAPABILITIES_SIZE    (0x2)
void connectib_ari_capabilities_dump(const struct connectib_ari_capabilities *ptr_struct, FILE* file);
/* lane_eql_ctl */
void connectib_lane_eql_ctl_pack(const struct connectib_lane_eql_ctl *ptr_struct, u_int8_t* ptr_buff);
void connectib_lane_eql_ctl_unpack(struct connectib_lane_eql_ctl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_lane_eql_ctl_print(const struct connectib_lane_eql_ctl *ptr_struct, FILE* file, int indent_level);
int connectib_lane_eql_ctl_size(void);
#define CONNECTIB_LANE_EQL_CTL_SIZE    (0x4)
void connectib_lane_eql_ctl_dump(const struct connectib_lane_eql_ctl *ptr_struct, FILE* file);
/* pciex_link_ctl3 */
void connectib_pciex_link_ctl3_pack(const struct connectib_pciex_link_ctl3 *ptr_struct, u_int8_t* ptr_buff);
void connectib_pciex_link_ctl3_unpack(struct connectib_pciex_link_ctl3 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pciex_link_ctl3_print(const struct connectib_pciex_link_ctl3 *ptr_struct, FILE* file, int indent_level);
int connectib_pciex_link_ctl3_size(void);
#define CONNECTIB_PCIEX_LINK_CTL3_SIZE    (0x4)
void connectib_pciex_link_ctl3_dump(const struct connectib_pciex_link_ctl3 *ptr_struct, FILE* file);
/* message_control */
void connectib_message_control_pack(const struct connectib_message_control *ptr_struct, u_int8_t* ptr_buff);
void connectib_message_control_unpack(struct connectib_message_control *ptr_struct, const u_int8_t* ptr_buff);
void connectib_message_control_print(const struct connectib_message_control *ptr_struct, FILE* file, int indent_level);
int connectib_message_control_size(void);
#define CONNECTIB_MESSAGE_CONTROL_SIZE    (0x2)
void connectib_message_control_dump(const struct connectib_message_control *ptr_struct, FILE* file);
/* link_stat2 */
void connectib_link_stat2_pack(const struct connectib_link_stat2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_stat2_unpack(struct connectib_link_stat2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_stat2_print(const struct connectib_link_stat2 *ptr_struct, FILE* file, int indent_level);
int connectib_link_stat2_size(void);
#define CONNECTIB_LINK_STAT2_SIZE    (0x2)
void connectib_link_stat2_dump(const struct connectib_link_stat2 *ptr_struct, FILE* file);
/* link_ctl2 */
void connectib_link_ctl2_pack(const struct connectib_link_ctl2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_ctl2_unpack(struct connectib_link_ctl2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_ctl2_print(const struct connectib_link_ctl2 *ptr_struct, FILE* file, int indent_level);
int connectib_link_ctl2_size(void);
#define CONNECTIB_LINK_CTL2_SIZE    (0x2)
void connectib_link_ctl2_dump(const struct connectib_link_ctl2 *ptr_struct, FILE* file);
/* link_caps2 */
void connectib_link_caps2_pack(const struct connectib_link_caps2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_caps2_unpack(struct connectib_link_caps2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_caps2_print(const struct connectib_link_caps2 *ptr_struct, FILE* file, int indent_level);
int connectib_link_caps2_size(void);
#define CONNECTIB_LINK_CAPS2_SIZE    (0x4)
void connectib_link_caps2_dump(const struct connectib_link_caps2 *ptr_struct, FILE* file);
/* device_stat2 */
void connectib_device_stat2_pack(const struct connectib_device_stat2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_stat2_unpack(struct connectib_device_stat2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_stat2_print(const struct connectib_device_stat2 *ptr_struct, FILE* file, int indent_level);
int connectib_device_stat2_size(void);
#define CONNECTIB_DEVICE_STAT2_SIZE    (0x2)
void connectib_device_stat2_dump(const struct connectib_device_stat2 *ptr_struct, FILE* file);
/* device_ctl2 */
void connectib_device_ctl2_pack(const struct connectib_device_ctl2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_ctl2_unpack(struct connectib_device_ctl2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_ctl2_print(const struct connectib_device_ctl2 *ptr_struct, FILE* file, int indent_level);
int connectib_device_ctl2_size(void);
#define CONNECTIB_DEVICE_CTL2_SIZE    (0x2)
void connectib_device_ctl2_dump(const struct connectib_device_ctl2 *ptr_struct, FILE* file);
/* device_caps2 */
void connectib_device_caps2_pack(const struct connectib_device_caps2 *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_caps2_unpack(struct connectib_device_caps2 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_caps2_print(const struct connectib_device_caps2 *ptr_struct, FILE* file, int indent_level);
int connectib_device_caps2_size(void);
#define CONNECTIB_DEVICE_CAPS2_SIZE    (0x4)
void connectib_device_caps2_dump(const struct connectib_device_caps2 *ptr_struct, FILE* file);
/* link_stat */
void connectib_link_stat_pack(const struct connectib_link_stat *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_stat_unpack(struct connectib_link_stat *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_stat_print(const struct connectib_link_stat *ptr_struct, FILE* file, int indent_level);
int connectib_link_stat_size(void);
#define CONNECTIB_LINK_STAT_SIZE    (0x2)
void connectib_link_stat_dump(const struct connectib_link_stat *ptr_struct, FILE* file);
/* link_ctl */
void connectib_link_ctl_pack(const struct connectib_link_ctl *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_ctl_unpack(struct connectib_link_ctl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_ctl_print(const struct connectib_link_ctl *ptr_struct, FILE* file, int indent_level);
int connectib_link_ctl_size(void);
#define CONNECTIB_LINK_CTL_SIZE    (0x2)
void connectib_link_ctl_dump(const struct connectib_link_ctl *ptr_struct, FILE* file);
/* link_caps */
void connectib_link_caps_pack(const struct connectib_link_caps *ptr_struct, u_int8_t* ptr_buff);
void connectib_link_caps_unpack(struct connectib_link_caps *ptr_struct, const u_int8_t* ptr_buff);
void connectib_link_caps_print(const struct connectib_link_caps *ptr_struct, FILE* file, int indent_level);
int connectib_link_caps_size(void);
#define CONNECTIB_LINK_CAPS_SIZE    (0x4)
void connectib_link_caps_dump(const struct connectib_link_caps *ptr_struct, FILE* file);
/* device_stat */
void connectib_device_stat_pack(const struct connectib_device_stat *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_stat_unpack(struct connectib_device_stat *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_stat_print(const struct connectib_device_stat *ptr_struct, FILE* file, int indent_level);
int connectib_device_stat_size(void);
#define CONNECTIB_DEVICE_STAT_SIZE    (0x2)
void connectib_device_stat_dump(const struct connectib_device_stat *ptr_struct, FILE* file);
/* device_ctl */
void connectib_device_ctl_pack(const struct connectib_device_ctl *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_ctl_unpack(struct connectib_device_ctl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_ctl_print(const struct connectib_device_ctl *ptr_struct, FILE* file, int indent_level);
int connectib_device_ctl_size(void);
#define CONNECTIB_DEVICE_CTL_SIZE    (0x2)
void connectib_device_ctl_dump(const struct connectib_device_ctl *ptr_struct, FILE* file);
/* device_caps */
void connectib_device_caps_pack(const struct connectib_device_caps *ptr_struct, u_int8_t* ptr_buff);
void connectib_device_caps_unpack(struct connectib_device_caps *ptr_struct, const u_int8_t* ptr_buff);
void connectib_device_caps_print(const struct connectib_device_caps *ptr_struct, FILE* file, int indent_level);
int connectib_device_caps_size(void);
#define CONNECTIB_DEVICE_CAPS_SIZE    (0x4)
void connectib_device_caps_dump(const struct connectib_device_caps *ptr_struct, FILE* file);
/* pciex_cap */
void connectib_pciex_cap_pack(const struct connectib_pciex_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_pciex_cap_unpack(struct connectib_pciex_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pciex_cap_print(const struct connectib_pciex_cap *ptr_struct, FILE* file, int indent_level);
int connectib_pciex_cap_size(void);
#define CONNECTIB_PCIEX_CAP_SIZE    (0x2)
void connectib_pciex_cap_dump(const struct connectib_pciex_cap *ptr_struct, FILE* file);
/* exp_rom */
void connectib_exp_rom_pack(const struct connectib_exp_rom *ptr_struct, u_int8_t* ptr_buff);
void connectib_exp_rom_unpack(struct connectib_exp_rom *ptr_struct, const u_int8_t* ptr_buff);
void connectib_exp_rom_print(const struct connectib_exp_rom *ptr_struct, FILE* file, int indent_level);
int connectib_exp_rom_size(void);
#define CONNECTIB_EXP_ROM_SIZE    (0x4)
void connectib_exp_rom_dump(const struct connectib_exp_rom *ptr_struct, FILE* file);
/* stat_reg1 */
void connectib_stat_reg1_pack(const struct connectib_stat_reg1 *ptr_struct, u_int8_t* ptr_buff);
void connectib_stat_reg1_unpack(struct connectib_stat_reg1 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_stat_reg1_print(const struct connectib_stat_reg1 *ptr_struct, FILE* file, int indent_level);
int connectib_stat_reg1_size(void);
#define CONNECTIB_STAT_REG1_SIZE    (0x2)
void connectib_stat_reg1_dump(const struct connectib_stat_reg1 *ptr_struct, FILE* file);
/* cmd_reg1 */
void connectib_cmd_reg1_pack(const struct connectib_cmd_reg1 *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmd_reg1_unpack(struct connectib_cmd_reg1 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmd_reg1_print(const struct connectib_cmd_reg1 *ptr_struct, FILE* file, int indent_level);
int connectib_cmd_reg1_size(void);
#define CONNECTIB_CMD_REG1_SIZE    (0x2)
void connectib_cmd_reg1_dump(const struct connectib_cmd_reg1 *ptr_struct, FILE* file);
/* nv_tlv_data_vpi_settings */
void connectib_nv_tlv_data_vpi_settings_pack(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_tlv_data_vpi_settings_unpack(struct connectib_nv_tlv_data_vpi_settings *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_tlv_data_vpi_settings_print(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, FILE* file, int indent_level);
int connectib_nv_tlv_data_vpi_settings_size(void);
#define CONNECTIB_NV_TLV_DATA_VPI_SETTINGS_SIZE    (0x4)
void connectib_nv_tlv_data_vpi_settings_dump(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, FILE* file);
/* dword_val */
void connectib_dword_val_pack(const struct connectib_dword_val *ptr_struct, u_int8_t* ptr_buff);
void connectib_dword_val_unpack(struct connectib_dword_val *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dword_val_print(const struct connectib_dword_val *ptr_struct, FILE* file, int indent_level);
int connectib_dword_val_size(void);
#define CONNECTIB_DWORD_VAL_SIZE    (0x4)
void connectib_dword_val_dump(const struct connectib_dword_val *ptr_struct, FILE* file);
/* port_cap_mask1_fields */
void connectib_port_cap_mask1_fields_pack(const struct connectib_port_cap_mask1_fields *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_cap_mask1_fields_unpack(struct connectib_port_cap_mask1_fields *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_cap_mask1_fields_print(const struct connectib_port_cap_mask1_fields *ptr_struct, FILE* file, int indent_level);
int connectib_port_cap_mask1_fields_size(void);
#define CONNECTIB_PORT_CAP_MASK1_FIELDS_SIZE    (0x4)
void connectib_port_cap_mask1_fields_dump(const struct connectib_port_cap_mask1_fields *ptr_struct, FILE* file);
/* ib_port_counters */
void connectib_ib_port_counters_pack(const struct connectib_ib_port_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_port_counters_unpack(struct connectib_ib_port_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_port_counters_print(const struct connectib_ib_port_counters *ptr_struct, FILE* file, int indent_level);
int connectib_ib_port_counters_size(void);
#define CONNECTIB_IB_PORT_COUNTERS_SIZE    (0xf8)
void connectib_ib_port_counters_dump(const struct connectib_ib_port_counters *ptr_struct, FILE* file);
/* llr_counters */
void connectib_llr_counters_pack(const struct connectib_llr_counters *ptr_struct, u_int8_t* ptr_buff);
void connectib_llr_counters_unpack(struct connectib_llr_counters *ptr_struct, const u_int8_t* ptr_buff);
void connectib_llr_counters_print(const struct connectib_llr_counters *ptr_struct, FILE* file, int indent_level);
int connectib_llr_counters_size(void);
#define CONNECTIB_LLR_COUNTERS_SIZE    (0xf8)
void connectib_llr_counters_dump(const struct connectib_llr_counters *ptr_struct, FILE* file);
/* discard_cntrs_grp_data */
void connectib_discard_cntrs_grp_data_pack(const struct connectib_discard_cntrs_grp_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_discard_cntrs_grp_data_unpack(struct connectib_discard_cntrs_grp_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_discard_cntrs_grp_data_print(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file, int indent_level);
int connectib_discard_cntrs_grp_data_size(void);
#define CONNECTIB_DISCARD_CNTRS_GRP_DATA_SIZE    (0xf8)
void connectib_discard_cntrs_grp_data_dump(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file);
/* phys_layer_cntrs */
void connectib_phys_layer_cntrs_pack(const struct connectib_phys_layer_cntrs *ptr_struct, u_int8_t* ptr_buff);
void connectib_phys_layer_cntrs_unpack(struct connectib_phys_layer_cntrs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phys_layer_cntrs_print(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file, int indent_level);
int connectib_phys_layer_cntrs_size(void);
#define CONNECTIB_PHYS_LAYER_CNTRS_SIZE    (0xc8)
void connectib_phys_layer_cntrs_dump(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file);
/* eth_per_traffic_grp_data_layout */
void connectib_eth_per_traffic_grp_data_layout_pack(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_per_traffic_grp_data_layout_unpack(struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_per_traffic_grp_data_layout_print(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_per_traffic_grp_data_layout_size(void);
#define CONNECTIB_ETH_PER_TRAFFIC_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_per_traffic_grp_data_layout_dump(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file);
/* eth_per_prio_grp_data_layout */
void connectib_eth_per_prio_grp_data_layout_pack(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_per_prio_grp_data_layout_unpack(struct connectib_eth_per_prio_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_per_prio_grp_data_layout_print(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_per_prio_grp_data_layout_size(void);
#define CONNECTIB_ETH_PER_PRIO_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_per_prio_grp_data_layout_dump(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file);
/* eth_extended_cntrs_grp_data_layout */
void connectib_eth_extended_cntrs_grp_data_layout_pack(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_extended_cntrs_grp_data_layout_unpack(struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_extended_cntrs_grp_data_layout_print(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_extended_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_EXTENDED_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_extended_cntrs_grp_data_layout_dump(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_3635_cntrs_grp_data_layout */
void connectib_eth_3635_cntrs_grp_data_layout_pack(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_3635_cntrs_grp_data_layout_unpack(struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_3635_cntrs_grp_data_layout_print(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_3635_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_3635_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_3635_cntrs_grp_data_layout_dump(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_2819_cntrs_grp_data_layout */
void connectib_eth_2819_cntrs_grp_data_layout_pack(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_2819_cntrs_grp_data_layout_unpack(struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_2819_cntrs_grp_data_layout_print(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_2819_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_2819_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_2819_cntrs_grp_data_layout_dump(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_2863_cntrs_grp_data_layout */
void connectib_eth_2863_cntrs_grp_data_layout_pack(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_2863_cntrs_grp_data_layout_unpack(struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_2863_cntrs_grp_data_layout_print(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_2863_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_2863_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_2863_cntrs_grp_data_layout_dump(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* eth_802_3_cntrs_grp_data_layout */
void connectib_eth_802_3_cntrs_grp_data_layout_pack(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_unpack(struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_print(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level);
int connectib_eth_802_3_cntrs_grp_data_layout_size(void);
#define CONNECTIB_ETH_802_3_CNTRS_GRP_DATA_LAYOUT_SIZE    (0xf8)
void connectib_eth_802_3_cntrs_grp_data_layout_dump(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file);
/* cmdif_ctx_special */
void connectib_cmdif_ctx_special_pack(const union connectib_cmdif_ctx_special *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_unpack(union connectib_cmdif_ctx_special *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_special_print(const union connectib_cmdif_ctx_special *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_special_size(void);
#define CONNECTIB_CMDIF_CTX_SPECIAL_SIZE    (0x20)
void connectib_cmdif_ctx_special_dump(const union connectib_cmdif_ctx_special *ptr_struct, FILE* file);
/* flush_type */
void connectib_flush_type_pack(const union connectib_flush_type *ptr_struct, u_int8_t* ptr_buff);
void connectib_flush_type_unpack(union connectib_flush_type *ptr_struct, const u_int8_t* ptr_buff);
void connectib_flush_type_print(const union connectib_flush_type *ptr_struct, FILE* file, int indent_level);
int connectib_flush_type_size(void);
#define CONNECTIB_FLUSH_TYPE_SIZE    (0x4)
void connectib_flush_type_dump(const union connectib_flush_type *ptr_struct, FILE* file);
/* sw_eqe_flat_data */
void connectib_sw_eqe_flat_data_pack(const struct connectib_sw_eqe_flat_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_flat_data_unpack(struct connectib_sw_eqe_flat_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_flat_data_print(const struct connectib_sw_eqe_flat_data *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_flat_data_size(void);
#define CONNECTIB_SW_EQE_FLAT_DATA_SIZE    (0x1c)
void connectib_sw_eqe_flat_data_dump(const struct connectib_sw_eqe_flat_data *ptr_struct, FILE* file);
/* db_bf_congestion_event */
void connectib_db_bf_congestion_event_pack(const struct connectib_db_bf_congestion_event *ptr_struct, u_int8_t* ptr_buff);
void connectib_db_bf_congestion_event_unpack(struct connectib_db_bf_congestion_event *ptr_struct, const u_int8_t* ptr_buff);
void connectib_db_bf_congestion_event_print(const struct connectib_db_bf_congestion_event *ptr_struct, FILE* file, int indent_level);
int connectib_db_bf_congestion_event_size(void);
#define CONNECTIB_DB_BF_CONGESTION_EVENT_SIZE    (0x18)
void connectib_db_bf_congestion_event_dump(const struct connectib_db_bf_congestion_event *ptr_struct, FILE* file);
/* rdma_page_fault_event */
void connectib_rdma_page_fault_event_pack(const struct connectib_rdma_page_fault_event *ptr_struct, u_int8_t* ptr_buff);
void connectib_rdma_page_fault_event_unpack(struct connectib_rdma_page_fault_event *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rdma_page_fault_event_print(const struct connectib_rdma_page_fault_event *ptr_struct, FILE* file, int indent_level);
int connectib_rdma_page_fault_event_size(void);
#define CONNECTIB_RDMA_PAGE_FAULT_EVENT_SIZE    (0x1c)
void connectib_rdma_page_fault_event_dump(const struct connectib_rdma_page_fault_event *ptr_struct, FILE* file);
/* wqe_page_fault_event */
void connectib_wqe_page_fault_event_pack(const struct connectib_wqe_page_fault_event *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_page_fault_event_unpack(struct connectib_wqe_page_fault_event *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_page_fault_event_print(const struct connectib_wqe_page_fault_event *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_page_fault_event_size(void);
#define CONNECTIB_WQE_PAGE_FAULT_EVENT_SIZE    (0x1c)
void connectib_wqe_page_fault_event_dump(const struct connectib_wqe_page_fault_event *ptr_struct, FILE* file);
/* page_request_event */
void connectib_page_request_event_pack(const struct connectib_page_request_event *ptr_struct, u_int8_t* ptr_buff);
void connectib_page_request_event_unpack(struct connectib_page_request_event *ptr_struct, const u_int8_t* ptr_buff);
void connectib_page_request_event_print(const struct connectib_page_request_event *ptr_struct, FILE* file, int indent_level);
int connectib_page_request_event_size(void);
#define CONNECTIB_PAGE_REQUEST_EVENT_SIZE    (0x1c)
void connectib_page_request_event_dump(const struct connectib_page_request_event *ptr_struct, FILE* file);
/* port_state_change_event */
void connectib_port_state_change_event_pack(const struct connectib_port_state_change_event *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_state_change_event_unpack(struct connectib_port_state_change_event *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_state_change_event_print(const struct connectib_port_state_change_event *ptr_struct, FILE* file, int indent_level);
int connectib_port_state_change_event_size(void);
#define CONNECTIB_PORT_STATE_CHANGE_EVENT_SIZE    (0x1c)
void connectib_port_state_change_event_dump(const struct connectib_port_state_change_event *ptr_struct, FILE* file);
/* sw_eqe_qp_data */
void connectib_sw_eqe_qp_data_pack(const struct connectib_sw_eqe_qp_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_qp_data_unpack(struct connectib_sw_eqe_qp_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_qp_data_print(const struct connectib_sw_eqe_qp_data *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_qp_data_size(void);
#define CONNECTIB_SW_EQE_QP_DATA_SIZE    (0x1c)
void connectib_sw_eqe_qp_data_dump(const struct connectib_sw_eqe_qp_data *ptr_struct, FILE* file);
/* sw_eqe_error_data */
void connectib_sw_eqe_error_data_pack(const struct connectib_sw_eqe_error_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_error_data_unpack(struct connectib_sw_eqe_error_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_error_data_print(const struct connectib_sw_eqe_error_data *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_error_data_size(void);
#define CONNECTIB_SW_EQE_ERROR_DATA_SIZE    (0x1c)
void connectib_sw_eqe_error_data_dump(const struct connectib_sw_eqe_error_data *ptr_struct, FILE* file);
/* sw_eqe_cq_data */
void connectib_sw_eqe_cq_data_pack(const struct connectib_sw_eqe_cq_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_cq_data_unpack(struct connectib_sw_eqe_cq_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_cq_data_print(const struct connectib_sw_eqe_cq_data *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_cq_data_size(void);
#define CONNECTIB_SW_EQE_CQ_DATA_SIZE    (0x1c)
void connectib_sw_eqe_cq_data_dump(const struct connectib_sw_eqe_cq_data *ptr_struct, FILE* file);
/* reg_access_reg_tlv_data */
void connectib_reg_access_reg_tlv_data_pack(const union connectib_reg_access_reg_tlv_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_reg_access_reg_tlv_data_unpack(union connectib_reg_access_reg_tlv_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reg_access_reg_tlv_data_print(const union connectib_reg_access_reg_tlv_data *ptr_struct, FILE* file, int indent_level);
int connectib_reg_access_reg_tlv_data_size(void);
#define CONNECTIB_REG_ACCESS_REG_TLV_DATA_SIZE    (0x2c)
void connectib_reg_access_reg_tlv_data_dump(const union connectib_reg_access_reg_tlv_data *ptr_struct, FILE* file);
/* reg_access_tlv */
void connectib_reg_access_tlv_pack(const struct connectib_reg_access_tlv *ptr_struct, u_int8_t* ptr_buff);
void connectib_reg_access_tlv_unpack(struct connectib_reg_access_tlv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reg_access_tlv_print(const struct connectib_reg_access_tlv *ptr_struct, FILE* file, int indent_level);
int connectib_reg_access_tlv_size(void);
#define CONNECTIB_REG_ACCESS_TLV_SIZE    (0x4)
void connectib_reg_access_tlv_dump(const struct connectib_reg_access_tlv *ptr_struct, FILE* file);
/* IB_TID */
void connectib_IB_TID_pack(const struct connectib_IB_TID *ptr_struct, u_int8_t* ptr_buff);
void connectib_IB_TID_unpack(struct connectib_IB_TID *ptr_struct, const u_int8_t* ptr_buff);
void connectib_IB_TID_print(const struct connectib_IB_TID *ptr_struct, FILE* file, int indent_level);
int connectib_IB_TID_size(void);
#define CONNECTIB_IB_TID_SIZE    (0x8)
void connectib_IB_TID_dump(const struct connectib_IB_TID *ptr_struct, FILE* file);
/* dc_control_packet_desc */
void connectib_dc_control_packet_desc_pack(const struct connectib_dc_control_packet_desc *ptr_struct, u_int8_t* ptr_buff);
void connectib_dc_control_packet_desc_unpack(struct connectib_dc_control_packet_desc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dc_control_packet_desc_print(const struct connectib_dc_control_packet_desc *ptr_struct, FILE* file, int indent_level);
int connectib_dc_control_packet_desc_size(void);
#define CONNECTIB_DC_CONTROL_PACKET_DESC_SIZE    (0x40)
void connectib_dc_control_packet_desc_dump(const struct connectib_dc_control_packet_desc *ptr_struct, FILE* file);
/* dmfs_resources */
void connectib_dmfs_resources_pack(const union connectib_dmfs_resources *ptr_struct, u_int8_t* ptr_buff);
void connectib_dmfs_resources_unpack(union connectib_dmfs_resources *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dmfs_resources_print(const union connectib_dmfs_resources *ptr_struct, FILE* file, int indent_level);
int connectib_dmfs_resources_size(void);
#define CONNECTIB_DMFS_RESOURCES_SIZE    (0x40)
void connectib_dmfs_resources_dump(const union connectib_dmfs_resources *ptr_struct, FILE* file);
/* list_element */
void connectib_list_element_pack(const struct connectib_list_element *ptr_struct, u_int8_t* ptr_buff);
void connectib_list_element_unpack(struct connectib_list_element *ptr_struct, const u_int8_t* ptr_buff);
void connectib_list_element_print(const struct connectib_list_element *ptr_struct, FILE* file, int indent_level);
int connectib_list_element_size(void);
#define CONNECTIB_LIST_ELEMENT_SIZE    (0x8)
void connectib_list_element_dump(const struct connectib_list_element *ptr_struct, FILE* file);
/* fw_rqt */
void connectib_fw_rqt_pack(const struct connectib_fw_rqt *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_rqt_unpack(struct connectib_fw_rqt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_rqt_print(const struct connectib_fw_rqt *ptr_struct, FILE* file, int indent_level);
int connectib_fw_rqt_size(void);
#define CONNECTIB_FW_RQT_SIZE    (0x20)
void connectib_fw_rqt_dump(const struct connectib_fw_rqt *ptr_struct, FILE* file);
/* fw_cqc */
void connectib_fw_cqc_pack(const struct connectib_fw_cqc *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_cqc_unpack(struct connectib_fw_cqc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_cqc_print(const struct connectib_fw_cqc *ptr_struct, FILE* file, int indent_level);
int connectib_fw_cqc_size(void);
#define CONNECTIB_FW_CQC_SIZE    (0x10)
void connectib_fw_cqc_dump(const struct connectib_fw_cqc *ptr_struct, FILE* file);
/* fw_psv */
void connectib_fw_psv_pack(const struct connectib_fw_psv *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_psv_unpack(struct connectib_fw_psv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_psv_print(const struct connectib_fw_psv *ptr_struct, FILE* file, int indent_level);
int connectib_fw_psv_size(void);
#define CONNECTIB_FW_PSV_SIZE    (0x4)
void connectib_fw_psv_dump(const struct connectib_fw_psv *ptr_struct, FILE* file);
/* fw_mkc */
void connectib_fw_mkc_pack(const struct connectib_fw_mkc *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_mkc_unpack(struct connectib_fw_mkc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_mkc_print(const struct connectib_fw_mkc *ptr_struct, FILE* file, int indent_level);
int connectib_fw_mkc_size(void);
#define CONNECTIB_FW_MKC_SIZE    (0x10)
void connectib_fw_mkc_dump(const struct connectib_fw_mkc *ptr_struct, FILE* file);
/* fw_cre */
void connectib_fw_cre_pack(const union connectib_fw_cre *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_cre_unpack(union connectib_fw_cre *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_cre_print(const union connectib_fw_cre *ptr_struct, FILE* file, int indent_level);
int connectib_fw_cre_size(void);
#define CONNECTIB_FW_CRE_SIZE    (0x40)
void connectib_fw_cre_dump(const union connectib_fw_cre *ptr_struct, FILE* file);
/* fw_basic_res_ctx */
void connectib_fw_basic_res_ctx_pack(const struct connectib_fw_basic_res_ctx *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_basic_res_ctx_unpack(struct connectib_fw_basic_res_ctx *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_basic_res_ctx_print(const struct connectib_fw_basic_res_ctx *ptr_struct, FILE* file, int indent_level);
int connectib_fw_basic_res_ctx_size(void);
#define CONNECTIB_FW_BASIC_RES_CTX_SIZE    (0x4)
void connectib_fw_basic_res_ctx_dump(const struct connectib_fw_basic_res_ctx *ptr_struct, FILE* file);
/* fw_alt_path */
void connectib_fw_alt_path_pack(const struct connectib_fw_alt_path *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_alt_path_unpack(struct connectib_fw_alt_path *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_alt_path_print(const struct connectib_fw_alt_path *ptr_struct, FILE* file, int indent_level);
int connectib_fw_alt_path_size(void);
#define CONNECTIB_FW_ALT_PATH_SIZE    (0x30)
void connectib_fw_alt_path_dump(const struct connectib_fw_alt_path *ptr_struct, FILE* file);
/* fw_eqc */
void connectib_fw_eqc_pack(const struct connectib_fw_eqc *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_eqc_unpack(struct connectib_fw_eqc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_eqc_print(const struct connectib_fw_eqc *ptr_struct, FILE* file, int indent_level);
int connectib_fw_eqc_size(void);
#define CONNECTIB_FW_EQC_SIZE    (0x10)
void connectib_fw_eqc_dump(const struct connectib_fw_eqc *ptr_struct, FILE* file);
/* hw_qp_counter */
void connectib_hw_qp_counter_pack(const struct connectib_hw_qp_counter *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_qp_counter_unpack(struct connectib_hw_qp_counter *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_qp_counter_print(const struct connectib_hw_qp_counter *ptr_struct, FILE* file, int indent_level);
int connectib_hw_qp_counter_size(void);
#define CONNECTIB_HW_QP_COUNTER_SIZE    (0x40)
void connectib_hw_qp_counter_dump(const struct connectib_hw_qp_counter *ptr_struct, FILE* file);
/* hw_msix */
void connectib_hw_msix_pack(const struct connectib_hw_msix *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_msix_unpack(struct connectib_hw_msix *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_msix_print(const struct connectib_hw_msix *ptr_struct, FILE* file, int indent_level);
int connectib_hw_msix_size(void);
#define CONNECTIB_HW_MSIX_SIZE    (0x20)
void connectib_hw_msix_dump(const struct connectib_hw_msix *ptr_struct, FILE* file);
/* hw_rdb */
void connectib_hw_rdb_pack(const struct connectib_hw_rdb *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_rdb_unpack(struct connectib_hw_rdb *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_rdb_print(const struct connectib_hw_rdb *ptr_struct, FILE* file, int indent_level);
int connectib_hw_rdb_size(void);
#define CONNECTIB_HW_RDB_SIZE    (0x40)
void connectib_hw_rdb_dump(const struct connectib_hw_rdb *ptr_struct, FILE* file);
/* icm_mtt */
void connectib_icm_mtt_pack(const union connectib_icm_mtt *ptr_struct, u_int8_t* ptr_buff);
void connectib_icm_mtt_unpack(union connectib_icm_mtt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icm_mtt_print(const union connectib_icm_mtt *ptr_struct, FILE* file, int indent_level);
int connectib_icm_mtt_size(void);
#define CONNECTIB_ICM_MTT_SIZE    (0x8)
void connectib_icm_mtt_dump(const union connectib_icm_mtt *ptr_struct, FILE* file);
/* steering_entry_icmc */
void connectib_steering_entry_icmc_pack(const union connectib_steering_entry_icmc *ptr_struct, u_int8_t* ptr_buff);
void connectib_steering_entry_icmc_unpack(union connectib_steering_entry_icmc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_steering_entry_icmc_print(const union connectib_steering_entry_icmc *ptr_struct, FILE* file, int indent_level);
int connectib_steering_entry_icmc_size(void);
#define CONNECTIB_STEERING_ENTRY_ICMC_SIZE    (0x40)
void connectib_steering_entry_icmc_dump(const union connectib_steering_entry_icmc *ptr_struct, FILE* file);
/* hw_pkey */
void connectib_hw_pkey_pack(const struct connectib_hw_pkey *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_pkey_unpack(struct connectib_hw_pkey *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_pkey_print(const struct connectib_hw_pkey *ptr_struct, FILE* file, int indent_level);
int connectib_hw_pkey_size(void);
#define CONNECTIB_HW_PKEY_SIZE    (0x4)
void connectib_hw_pkey_dump(const struct connectib_hw_pkey *ptr_struct, FILE* file);
/* hw_timer_32 */
void connectib_hw_timer_32_pack(const struct connectib_hw_timer_32 *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_timer_32_unpack(struct connectib_hw_timer_32 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_timer_32_print(const struct connectib_hw_timer_32 *ptr_struct, FILE* file, int indent_level);
int connectib_hw_timer_32_size(void);
#define CONNECTIB_HW_TIMER_32_SIZE    (0x4)
void connectib_hw_timer_32_dump(const struct connectib_hw_timer_32 *ptr_struct, FILE* file);
/* hw_sq_qp_list */
void connectib_hw_sq_qp_list_pack(const struct connectib_hw_sq_qp_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_sq_qp_list_unpack(struct connectib_hw_sq_qp_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_sq_qp_list_print(const struct connectib_hw_sq_qp_list *ptr_struct, FILE* file, int indent_level);
int connectib_hw_sq_qp_list_size(void);
#define CONNECTIB_HW_SQ_QP_LIST_SIZE    (0x4)
void connectib_hw_sq_qp_list_dump(const struct connectib_hw_sq_qp_list *ptr_struct, FILE* file);
/* hw_pipa */
void connectib_hw_pipa_pack(const struct connectib_hw_pipa *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_pipa_unpack(struct connectib_hw_pipa *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_pipa_print(const struct connectib_hw_pipa *ptr_struct, FILE* file, int indent_level);
int connectib_hw_pipa_size(void);
#define CONNECTIB_HW_PIPA_SIZE    (0x8)
void connectib_hw_pipa_dump(const struct connectib_hw_pipa *ptr_struct, FILE* file);
/* hw_sxdc */
void connectib_hw_sxdc_pack(const struct connectib_hw_sxdc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_sxdc_unpack(struct connectib_hw_sxdc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_sxdc_print(const struct connectib_hw_sxdc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_sxdc_size(void);
#define CONNECTIB_HW_SXDC_SIZE    (0x8)
void connectib_hw_sxdc_dump(const struct connectib_hw_sxdc *ptr_struct, FILE* file);
/* hw_klm_entry */
void connectib_hw_klm_entry_pack(const struct connectib_hw_klm_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_klm_entry_unpack(struct connectib_hw_klm_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_klm_entry_print(const struct connectib_hw_klm_entry *ptr_struct, FILE* file, int indent_level);
int connectib_hw_klm_entry_size(void);
#define CONNECTIB_HW_KLM_ENTRY_SIZE    (0x10)
void connectib_hw_klm_entry_dump(const struct connectib_hw_klm_entry *ptr_struct, FILE* file);
/* hw_sq_tokens */
void connectib_hw_sq_tokens_pack(const struct connectib_hw_sq_tokens *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_sq_tokens_unpack(struct connectib_hw_sq_tokens *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_sq_tokens_print(const struct connectib_hw_sq_tokens *ptr_struct, FILE* file, int indent_level);
int connectib_hw_sq_tokens_size(void);
#define CONNECTIB_HW_SQ_TOKENS_SIZE    (0x20)
void connectib_hw_sq_tokens_dump(const struct connectib_hw_sq_tokens *ptr_struct, FILE* file);
/* hw_gvmi_tokens */
void connectib_hw_gvmi_tokens_pack(const struct connectib_hw_gvmi_tokens *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_gvmi_tokens_unpack(struct connectib_hw_gvmi_tokens *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_gvmi_tokens_print(const struct connectib_hw_gvmi_tokens *ptr_struct, FILE* file, int indent_level);
int connectib_hw_gvmi_tokens_size(void);
#define CONNECTIB_HW_GVMI_TOKENS_SIZE    (0x20)
void connectib_hw_gvmi_tokens_dump(const struct connectib_hw_gvmi_tokens *ptr_struct, FILE* file);
/* hw_sq_pointers */
void connectib_hw_sq_pointers_pack(const struct connectib_hw_sq_pointers *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_sq_pointers_unpack(struct connectib_hw_sq_pointers *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_sq_pointers_print(const struct connectib_hw_sq_pointers *ptr_struct, FILE* file, int indent_level);
int connectib_hw_sq_pointers_size(void);
#define CONNECTIB_HW_SQ_POINTERS_SIZE    (0x20)
void connectib_hw_sq_pointers_dump(const struct connectib_hw_sq_pointers *ptr_struct, FILE* file);
/* hw_trasta */
void connectib_hw_trasta_pack(const struct connectib_hw_trasta *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_trasta_unpack(struct connectib_hw_trasta *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_trasta_print(const struct connectib_hw_trasta *ptr_struct, FILE* file, int indent_level);
int connectib_hw_trasta_size(void);
#define CONNECTIB_HW_TRASTA_SIZE    (0x10)
void connectib_hw_trasta_dump(const struct connectib_hw_trasta *ptr_struct, FILE* file);
/* hw_trastb */
void connectib_hw_trastb_pack(const struct connectib_hw_trastb *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_trastb_unpack(struct connectib_hw_trastb *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_trastb_print(const struct connectib_hw_trastb *ptr_struct, FILE* file, int indent_level);
int connectib_hw_trastb_size(void);
#define CONNECTIB_HW_TRASTB_SIZE    (0x20)
void connectib_hw_trastb_dump(const struct connectib_hw_trastb *ptr_struct, FILE* file);
/* hw_base_psv */
void connectib_hw_base_psv_pack(const struct connectib_hw_base_psv *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_base_psv_unpack(struct connectib_hw_base_psv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_base_psv_print(const struct connectib_hw_base_psv *ptr_struct, FILE* file, int indent_level);
int connectib_hw_base_psv_size(void);
#define CONNECTIB_HW_BASE_PSV_SIZE    (0x10)
void connectib_hw_base_psv_dump(const struct connectib_hw_base_psv *ptr_struct, FILE* file);
/* hw_bsf_entry */
void connectib_hw_bsf_entry_pack(const union connectib_hw_bsf_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_unpack(union connectib_hw_bsf_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_bsf_entry_print(const union connectib_hw_bsf_entry *ptr_struct, FILE* file, int indent_level);
int connectib_hw_bsf_entry_size(void);
#define CONNECTIB_HW_BSF_ENTRY_SIZE    (0x40)
void connectib_hw_bsf_entry_dump(const union connectib_hw_bsf_entry *ptr_struct, FILE* file);
/* hw_port_info */
void connectib_hw_port_info_pack(const struct connectib_hw_port_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_port_info_unpack(struct connectib_hw_port_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_port_info_print(const struct connectib_hw_port_info *ptr_struct, FILE* file, int indent_level);
int connectib_hw_port_info_size(void);
#define CONNECTIB_HW_PORT_INFO_SIZE    (0x40)
void connectib_hw_port_info_dump(const struct connectib_hw_port_info *ptr_struct, FILE* file);
/* hw_r_qpc */
void connectib_hw_r_qpc_pack(const union connectib_hw_r_qpc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_r_qpc_unpack(union connectib_hw_r_qpc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_r_qpc_print(const union connectib_hw_r_qpc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_r_qpc_size(void);
#define CONNECTIB_HW_R_QPC_SIZE    (0x40)
void connectib_hw_r_qpc_dump(const union connectib_hw_r_qpc *ptr_struct, FILE* file);
/* hw_s_qpc */
void connectib_hw_s_qpc_pack(const union connectib_hw_s_qpc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_s_qpc_unpack(union connectib_hw_s_qpc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_s_qpc_print(const union connectib_hw_s_qpc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_s_qpc_size(void);
#define CONNECTIB_HW_S_QPC_SIZE    (0x40)
void connectib_hw_s_qpc_dump(const union connectib_hw_s_qpc *ptr_struct, FILE* file);
/* hw_c_qpc */
void connectib_hw_c_qpc_pack(const union connectib_hw_c_qpc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_c_qpc_unpack(union connectib_hw_c_qpc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_c_qpc_print(const union connectib_hw_c_qpc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_c_qpc_size(void);
#define CONNECTIB_HW_C_QPC_SIZE    (0x40)
void connectib_hw_c_qpc_dump(const union connectib_hw_c_qpc *ptr_struct, FILE* file);
/* hw_srq */
void connectib_hw_srq_pack(const struct connectib_hw_srq *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_srq_unpack(struct connectib_hw_srq *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_srq_print(const struct connectib_hw_srq *ptr_struct, FILE* file, int indent_level);
int connectib_hw_srq_size(void);
#define CONNECTIB_HW_SRQ_SIZE    (0x40)
void connectib_hw_srq_dump(const struct connectib_hw_srq *ptr_struct, FILE* file);
/* hw_toc */
void connectib_hw_toc_pack(const struct connectib_hw_toc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_toc_unpack(struct connectib_hw_toc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_toc_print(const struct connectib_hw_toc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_toc_size(void);
#define CONNECTIB_HW_TOC_SIZE    (0x40)
void connectib_hw_toc_dump(const struct connectib_hw_toc *ptr_struct, FILE* file);
/* hw_mkc */
void connectib_hw_mkc_pack(const struct connectib_hw_mkc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_mkc_unpack(struct connectib_hw_mkc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_mkc_print(const struct connectib_hw_mkc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_mkc_size(void);
#define CONNECTIB_HW_MKC_SIZE    (0x40)
void connectib_hw_mkc_dump(const struct connectib_hw_mkc *ptr_struct, FILE* file);
/* hw_cqc */
void connectib_hw_cqc_pack(const struct connectib_hw_cqc *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_cqc_unpack(struct connectib_hw_cqc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_cqc_print(const struct connectib_hw_cqc *ptr_struct, FILE* file, int indent_level);
int connectib_hw_cqc_size(void);
#define CONNECTIB_HW_CQC_SIZE    (0x40)
void connectib_hw_cqc_dump(const struct connectib_hw_cqc *ptr_struct, FILE* file);
/* ffe_tap_set */
void connectib_ffe_tap_set_pack(const struct connectib_ffe_tap_set *ptr_struct, u_int8_t* ptr_buff);
void connectib_ffe_tap_set_unpack(struct connectib_ffe_tap_set *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ffe_tap_set_print(const struct connectib_ffe_tap_set *ptr_struct, FILE* file, int indent_level);
int connectib_ffe_tap_set_size(void);
#define CONNECTIB_FFE_TAP_SET_SIZE    (0x8)
void connectib_ffe_tap_set_dump(const struct connectib_ffe_tap_set *ptr_struct, FILE* file);
/* GEN3_TRANSMITTER_SETTING */
void connectib_GEN3_TRANSMITTER_SETTING_pack(const struct connectib_GEN3_TRANSMITTER_SETTING *ptr_struct, u_int8_t* ptr_buff);
void connectib_GEN3_TRANSMITTER_SETTING_unpack(struct connectib_GEN3_TRANSMITTER_SETTING *ptr_struct, const u_int8_t* ptr_buff);
void connectib_GEN3_TRANSMITTER_SETTING_print(const struct connectib_GEN3_TRANSMITTER_SETTING *ptr_struct, FILE* file, int indent_level);
int connectib_GEN3_TRANSMITTER_SETTING_size(void);
#define CONNECTIB_GEN3_TRANSMITTER_SETTING_SIZE    (0x4)
void connectib_GEN3_TRANSMITTER_SETTING_dump(const struct connectib_GEN3_TRANSMITTER_SETTING *ptr_struct, FILE* file);
/* gpio_config */
void connectib_gpio_config_pack(const struct connectib_gpio_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_gpio_config_unpack(struct connectib_gpio_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_gpio_config_print(const struct connectib_gpio_config *ptr_struct, FILE* file, int indent_level);
int connectib_gpio_config_size(void);
#define CONNECTIB_GPIO_CONFIG_SIZE    (0x1)
void connectib_gpio_config_dump(const struct connectib_gpio_config *ptr_struct, FILE* file);
/* gpio_function */
void connectib_gpio_function_pack(const struct connectib_gpio_function *ptr_struct, u_int8_t* ptr_buff);
void connectib_gpio_function_unpack(struct connectib_gpio_function *ptr_struct, const u_int8_t* ptr_buff);
void connectib_gpio_function_print(const struct connectib_gpio_function *ptr_struct, FILE* file, int indent_level);
int connectib_gpio_function_size(void);
#define CONNECTIB_GPIO_FUNCTION_SIZE    (0x1)
void connectib_gpio_function_dump(const struct connectib_gpio_function *ptr_struct, FILE* file);
/* mlpn_enhanced_database_ini */
void connectib_mlpn_enhanced_database_ini_pack(const struct connectib_mlpn_enhanced_database_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_mlpn_enhanced_database_ini_unpack(struct connectib_mlpn_enhanced_database_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mlpn_enhanced_database_ini_print(const struct connectib_mlpn_enhanced_database_ini *ptr_struct, FILE* file, int indent_level);
int connectib_mlpn_enhanced_database_ini_size(void);
#define CONNECTIB_MLPN_ENHANCED_DATABASE_INI_SIZE    (0x4)
void connectib_mlpn_enhanced_database_ini_dump(const struct connectib_mlpn_enhanced_database_ini *ptr_struct, FILE* file);
/* mlpn_database_all_protocol_ini */
void connectib_mlpn_database_all_protocol_ini_pack(const struct connectib_mlpn_database_all_protocol_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_mlpn_database_all_protocol_ini_unpack(struct connectib_mlpn_database_all_protocol_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mlpn_database_all_protocol_ini_print(const struct connectib_mlpn_database_all_protocol_ini *ptr_struct, FILE* file, int indent_level);
int connectib_mlpn_database_all_protocol_ini_size(void);
#define CONNECTIB_MLPN_DATABASE_ALL_PROTOCOL_INI_SIZE    (0x4)
void connectib_mlpn_database_all_protocol_ini_dump(const struct connectib_mlpn_database_all_protocol_ini *ptr_struct, FILE* file);
/* tx_rx_logic_serdes_mapping_node_ini */
void connectib_tx_rx_logic_serdes_mapping_node_ini_pack(const struct connectib_tx_rx_logic_serdes_mapping_node_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_tx_rx_logic_serdes_mapping_node_ini_unpack(struct connectib_tx_rx_logic_serdes_mapping_node_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_tx_rx_logic_serdes_mapping_node_ini_print(const struct connectib_tx_rx_logic_serdes_mapping_node_ini *ptr_struct, FILE* file, int indent_level);
int connectib_tx_rx_logic_serdes_mapping_node_ini_size(void);
#define CONNECTIB_TX_RX_LOGIC_SERDES_MAPPING_NODE_INI_SIZE    (0x20)
void connectib_tx_rx_logic_serdes_mapping_node_ini_dump(const struct connectib_tx_rx_logic_serdes_mapping_node_ini *ptr_struct, FILE* file);
/* serdes_conf_ini */
void connectib_serdes_conf_ini_pack(const struct connectib_serdes_conf_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_serdes_conf_ini_unpack(struct connectib_serdes_conf_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_serdes_conf_ini_print(const struct connectib_serdes_conf_ini *ptr_struct, FILE* file, int indent_level);
int connectib_serdes_conf_ini_size(void);
#define CONNECTIB_SERDES_CONF_INI_SIZE    (0x440)
void connectib_serdes_conf_ini_dump(const struct connectib_serdes_conf_ini *ptr_struct, FILE* file);
/* rx_adapt_ini */
void connectib_rx_adapt_ini_pack(const struct connectib_rx_adapt_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_rx_adapt_ini_unpack(struct connectib_rx_adapt_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rx_adapt_ini_print(const struct connectib_rx_adapt_ini *ptr_struct, FILE* file, int indent_level);
int connectib_rx_adapt_ini_size(void);
#define CONNECTIB_RX_ADAPT_INI_SIZE    (0x18)
void connectib_rx_adapt_ini_dump(const struct connectib_rx_adapt_ini *ptr_struct, FILE* file);
/* ib_ini_ini */
void connectib_ib_ini_ini_pack(const struct connectib_ib_ini_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_ini_ini_unpack(struct connectib_ib_ini_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_ini_ini_print(const struct connectib_ib_ini_ini *ptr_struct, FILE* file, int indent_level);
int connectib_ib_ini_ini_size(void);
#define CONNECTIB_IB_INI_INI_SIZE    (0x60)
void connectib_ib_ini_ini_dump(const struct connectib_ib_ini_ini *ptr_struct, FILE* file);
/* PORT_PHY_ini */
void connectib_PORT_PHY_ini_pack(const struct connectib_PORT_PHY_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_PORT_PHY_ini_unpack(struct connectib_PORT_PHY_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_PORT_PHY_ini_print(const struct connectib_PORT_PHY_ini *ptr_struct, FILE* file, int indent_level);
int connectib_PORT_PHY_ini_size(void);
#define CONNECTIB_PORT_PHY_INI_SIZE    (0x10)
void connectib_PORT_PHY_ini_dump(const struct connectib_PORT_PHY_ini *ptr_struct, FILE* file);
/* nv_config_tpt */
void connectib_nv_config_tpt_pack(const struct connectib_nv_config_tpt *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_tpt_unpack(struct connectib_nv_config_tpt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_tpt_print(const struct connectib_nv_config_tpt *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_tpt_size(void);
#define CONNECTIB_NV_CONFIG_TPT_SIZE    (0x8)
void connectib_nv_config_tpt_dump(const struct connectib_nv_config_tpt *ptr_struct, FILE* file);
/* nv_config_pci */
void connectib_nv_config_pci_pack(const struct connectib_nv_config_pci *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_pci_unpack(struct connectib_nv_config_pci *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_pci_print(const struct connectib_nv_config_pci *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_pci_size(void);
#define CONNECTIB_NV_CONFIG_PCI_SIZE    (0x20)
void connectib_nv_config_pci_dump(const struct connectib_nv_config_pci *ptr_struct, FILE* file);
/* advanced_error_reporting */
void connectib_advanced_error_reporting_pack(const struct connectib_advanced_error_reporting *ptr_struct, u_int8_t* ptr_buff);
void connectib_advanced_error_reporting_unpack(struct connectib_advanced_error_reporting *ptr_struct, const u_int8_t* ptr_buff);
void connectib_advanced_error_reporting_print(const struct connectib_advanced_error_reporting *ptr_struct, FILE* file, int indent_level);
int connectib_advanced_error_reporting_size(void);
#define CONNECTIB_ADVANCED_ERROR_REPORTING_SIZE    (0x38)
void connectib_advanced_error_reporting_dump(const struct connectib_advanced_error_reporting *ptr_struct, FILE* file);
/* dev_serial_num_cap */
void connectib_dev_serial_num_cap_pack(const struct connectib_dev_serial_num_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_dev_serial_num_cap_unpack(struct connectib_dev_serial_num_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dev_serial_num_cap_print(const struct connectib_dev_serial_num_cap *ptr_struct, FILE* file, int indent_level);
int connectib_dev_serial_num_cap_size(void);
#define CONNECTIB_DEV_SERIAL_NUM_CAP_SIZE    (0xc)
void connectib_dev_serial_num_cap_dump(const struct connectib_dev_serial_num_cap *ptr_struct, FILE* file);
/* sriov_cap */
void connectib_sriov_cap_pack(const struct connectib_sriov_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_sriov_cap_unpack(struct connectib_sriov_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sriov_cap_print(const struct connectib_sriov_cap *ptr_struct, FILE* file, int indent_level);
int connectib_sriov_cap_size(void);
#define CONNECTIB_SRIOV_CAP_SIZE    (0x40)
void connectib_sriov_cap_dump(const struct connectib_sriov_cap *ptr_struct, FILE* file);
/* ari_cap */
void connectib_ari_cap_pack(const struct connectib_ari_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_ari_cap_unpack(struct connectib_ari_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ari_cap_print(const struct connectib_ari_cap *ptr_struct, FILE* file, int indent_level);
int connectib_ari_cap_size(void);
#define CONNECTIB_ARI_CAP_SIZE    (0x8)
void connectib_ari_cap_dump(const struct connectib_ari_cap *ptr_struct, FILE* file);
/* secondary_pciex_ext_cap */
void connectib_secondary_pciex_ext_cap_pack(const struct connectib_secondary_pciex_ext_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_secondary_pciex_ext_cap_unpack(struct connectib_secondary_pciex_ext_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_secondary_pciex_ext_cap_print(const struct connectib_secondary_pciex_ext_cap *ptr_struct, FILE* file, int indent_level);
int connectib_secondary_pciex_ext_cap_size(void);
#define CONNECTIB_SECONDARY_PCIEX_EXT_CAP_SIZE    (0x2c)
void connectib_secondary_pciex_ext_cap_dump(const struct connectib_secondary_pciex_ext_cap *ptr_struct, FILE* file);
/* msix_cap */
void connectib_msix_cap_pack(const struct connectib_msix_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_msix_cap_unpack(struct connectib_msix_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_msix_cap_print(const struct connectib_msix_cap *ptr_struct, FILE* file, int indent_level);
int connectib_msix_cap_size(void);
#define CONNECTIB_MSIX_CAP_SIZE    (0xc)
void connectib_msix_cap_dump(const struct connectib_msix_cap *ptr_struct, FILE* file);
/* pciex_cap_block */
void connectib_pciex_cap_block_pack(const struct connectib_pciex_cap_block *ptr_struct, u_int8_t* ptr_buff);
void connectib_pciex_cap_block_unpack(struct connectib_pciex_cap_block *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pciex_cap_block_print(const struct connectib_pciex_cap_block *ptr_struct, FILE* file, int indent_level);
int connectib_pciex_cap_block_size(void);
#define CONNECTIB_PCIEX_CAP_BLOCK_SIZE    (0x3c)
void connectib_pciex_cap_block_dump(const struct connectib_pciex_cap_block *ptr_struct, FILE* file);
/* vpd_cap */
void connectib_vpd_cap_pack(const struct connectib_vpd_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_vpd_cap_unpack(struct connectib_vpd_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vpd_cap_print(const struct connectib_vpd_cap *ptr_struct, FILE* file, int indent_level);
int connectib_vpd_cap_size(void);
#define CONNECTIB_VPD_CAP_SIZE    (0x8)
void connectib_vpd_cap_dump(const struct connectib_vpd_cap *ptr_struct, FILE* file);
/* pci_power_management_cap */
void connectib_pci_power_management_cap_pack(const struct connectib_pci_power_management_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_pci_power_management_cap_unpack(struct connectib_pci_power_management_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pci_power_management_cap_print(const struct connectib_pci_power_management_cap *ptr_struct, FILE* file, int indent_level);
int connectib_pci_power_management_cap_size(void);
#define CONNECTIB_PCI_POWER_MANAGEMENT_CAP_SIZE    (0x8)
void connectib_pci_power_management_cap_dump(const struct connectib_pci_power_management_cap *ptr_struct, FILE* file);
/* pci_cfg_hdr */
void connectib_pci_cfg_hdr_pack(const struct connectib_pci_cfg_hdr *ptr_struct, u_int8_t* ptr_buff);
void connectib_pci_cfg_hdr_unpack(struct connectib_pci_cfg_hdr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pci_cfg_hdr_print(const struct connectib_pci_cfg_hdr *ptr_struct, FILE* file, int indent_level);
int connectib_pci_cfg_hdr_size(void);
#define CONNECTIB_PCI_CFG_HDR_SIZE    (0x40)
void connectib_pci_cfg_hdr_dump(const struct connectib_pci_cfg_hdr *ptr_struct, FILE* file);
/* port_settings */
void connectib_port_settings_pack(const struct connectib_port_settings *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_settings_unpack(struct connectib_port_settings *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_settings_print(const struct connectib_port_settings *ptr_struct, FILE* file, int indent_level);
int connectib_port_settings_size(void);
#define CONNECTIB_PORT_SETTINGS_SIZE    (0x4)
void connectib_port_settings_dump(const struct connectib_port_settings *ptr_struct, FILE* file);
/* phy_lcl_ini */
void connectib_phy_lcl_ini_pack(const struct connectib_phy_lcl_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_phy_lcl_ini_unpack(struct connectib_phy_lcl_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phy_lcl_ini_print(const struct connectib_phy_lcl_ini *ptr_struct, FILE* file, int indent_level);
int connectib_phy_lcl_ini_size(void);
#define CONNECTIB_PHY_LCL_INI_SIZE    (0x4)
void connectib_phy_lcl_ini_dump(const struct connectib_phy_lcl_ini *ptr_struct, FILE* file);
/* port_cap_mask1 */
void connectib_port_cap_mask1_pack(const union connectib_port_cap_mask1 *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_cap_mask1_unpack(union connectib_port_cap_mask1 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_cap_mask1_print(const union connectib_port_cap_mask1 *ptr_struct, FILE* file, int indent_level);
int connectib_port_cap_mask1_size(void);
#define CONNECTIB_PORT_CAP_MASK1_SIZE    (0x4)
void connectib_port_cap_mask1_dump(const union connectib_port_cap_mask1 *ptr_struct, FILE* file);
/* reset_version */
void connectib_reset_version_pack(const struct connectib_reset_version *ptr_struct, u_int8_t* ptr_buff);
void connectib_reset_version_unpack(struct connectib_reset_version *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reset_version_print(const struct connectib_reset_version *ptr_struct, FILE* file, int indent_level);
int connectib_reset_version_size(void);
#define CONNECTIB_RESET_VERSION_SIZE    (0x4)
void connectib_reset_version_dump(const struct connectib_reset_version *ptr_struct, FILE* file);
/* mac_address_layout */
void connectib_mac_address_layout_pack(const struct connectib_mac_address_layout *ptr_struct, u_int8_t* ptr_buff);
void connectib_mac_address_layout_unpack(struct connectib_mac_address_layout *ptr_struct, const u_int8_t* ptr_buff);
void connectib_mac_address_layout_print(const struct connectib_mac_address_layout *ptr_struct, FILE* file, int indent_level);
int connectib_mac_address_layout_size(void);
#define CONNECTIB_MAC_ADDRESS_LAYOUT_SIZE    (0x8)
void connectib_mac_address_layout_dump(const struct connectib_mac_address_layout *ptr_struct, FILE* file);
/* resource_type_entry */
void connectib_resource_type_entry_pack(const struct connectib_resource_type_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_resource_type_entry_unpack(struct connectib_resource_type_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_resource_type_entry_print(const struct connectib_resource_type_entry *ptr_struct, FILE* file, int indent_level);
int connectib_resource_type_entry_size(void);
#define CONNECTIB_RESOURCE_TYPE_ENTRY_SIZE    (0x4)
void connectib_resource_type_entry_dump(const struct connectib_resource_type_entry *ptr_struct, FILE* file);
/* index_and_length */
void connectib_index_and_length_pack(const struct connectib_index_and_length *ptr_struct, u_int8_t* ptr_buff);
void connectib_index_and_length_unpack(struct connectib_index_and_length *ptr_struct, const u_int8_t* ptr_buff);
void connectib_index_and_length_print(const struct connectib_index_and_length *ptr_struct, FILE* file, int indent_level);
int connectib_index_and_length_size(void);
#define CONNECTIB_INDEX_AND_LENGTH_SIZE    (0x10)
void connectib_index_and_length_dump(const struct connectib_index_and_length *ptr_struct, FILE* file);
/* dest_format_struct */
void connectib_dest_format_struct_pack(const struct connectib_dest_format_struct *ptr_struct, u_int8_t* ptr_buff);
void connectib_dest_format_struct_unpack(struct connectib_dest_format_struct *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dest_format_struct_print(const struct connectib_dest_format_struct *ptr_struct, FILE* file, int indent_level);
int connectib_dest_format_struct_size(void);
#define CONNECTIB_DEST_FORMAT_STRUCT_SIZE    (0x8)
void connectib_dest_format_struct_dump(const struct connectib_dest_format_struct *ptr_struct, FILE* file);
/* flow_table_entry_match_set_lyr_2_4 */
void connectib_flow_table_entry_match_set_lyr_2_4_pack(const struct connectib_flow_table_entry_match_set_lyr_2_4 *ptr_struct, u_int8_t* ptr_buff);
void connectib_flow_table_entry_match_set_lyr_2_4_unpack(struct connectib_flow_table_entry_match_set_lyr_2_4 *ptr_struct, const u_int8_t* ptr_buff);
void connectib_flow_table_entry_match_set_lyr_2_4_print(const struct connectib_flow_table_entry_match_set_lyr_2_4 *ptr_struct, FILE* file, int indent_level);
int connectib_flow_table_entry_match_set_lyr_2_4_size(void);
#define CONNECTIB_FLOW_TABLE_ENTRY_MATCH_SET_LYR_2_4_SIZE    (0x40)
void connectib_flow_table_entry_match_set_lyr_2_4_dump(const struct connectib_flow_table_entry_match_set_lyr_2_4 *ptr_struct, FILE* file);
/* flow_table_entry_match_set_misc */
void connectib_flow_table_entry_match_set_misc_pack(const struct connectib_flow_table_entry_match_set_misc *ptr_struct, u_int8_t* ptr_buff);
void connectib_flow_table_entry_match_set_misc_unpack(struct connectib_flow_table_entry_match_set_misc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_flow_table_entry_match_set_misc_print(const struct connectib_flow_table_entry_match_set_misc *ptr_struct, FILE* file, int indent_level);
int connectib_flow_table_entry_match_set_misc_size(void);
#define CONNECTIB_FLOW_TABLE_ENTRY_MATCH_SET_MISC_SIZE    (0x40)
void connectib_flow_table_entry_match_set_misc_dump(const struct connectib_flow_table_entry_match_set_misc *ptr_struct, FILE* file);
/* eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto */
void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_pack(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_unpack(union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, const u_int8_t* ptr_buff);
void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_print(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, FILE* file, int indent_level);
int connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_size(void);
#define CONNECTIB_ETH_802_3_CNTRS_GRP_DATA_LAYOUT_ETH_2863_CNTRS_GRP_DATA_LAYOUT_ETH_2819_CNTRS_GRP_DATA_LAYOUT_ETH_3635_CNTRS_GRP_DATA_LAYOUT_ETH_EXTENDED_CNTRS_GRP_DATA_LAYOUT_ETH_PER_PRIO_GRP_DATA_LAYOUT_ETH_PER_TRAFFIC_GRP_DATA_LAYOUT_PHYS_LAYER_CNTRS_AUTO_SIZE    (0xf8)
void connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto_dump(const union connectib_eth_802_3_cntrs_grp_data_layout_eth_2863_cntrs_grp_data_layout_eth_2819_cntrs_grp_data_layout_eth_3635_cntrs_grp_data_layout_eth_extended_cntrs_grp_data_layout_eth_per_prio_grp_data_layout_eth_per_traffic_grp_data_layout_phys_layer_cntrs_auto *ptr_struct, FILE* file);
/* fw_vport_ctx */
void connectib_fw_vport_ctx_pack(const struct connectib_fw_vport_ctx *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_vport_ctx_unpack(struct connectib_fw_vport_ctx *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_vport_ctx_print(const struct connectib_fw_vport_ctx *ptr_struct, FILE* file, int indent_level);
int connectib_fw_vport_ctx_size(void);
#define CONNECTIB_FW_VPORT_CTX_SIZE    (0x2)
void connectib_fw_vport_ctx_dump(const struct connectib_fw_vport_ctx *ptr_struct, FILE* file);
/* vf_pages_list */
void connectib_vf_pages_list_pack(const struct connectib_vf_pages_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_vf_pages_list_unpack(struct connectib_vf_pages_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vf_pages_list_print(const struct connectib_vf_pages_list *ptr_struct, FILE* file, int indent_level);
int connectib_vf_pages_list_size(void);
#define CONNECTIB_VF_PAGES_LIST_SIZE    (0x40)
void connectib_vf_pages_list_dump(const struct connectib_vf_pages_list *ptr_struct, FILE* file);
/* icm_page_manager */
void connectib_icm_page_manager_pack(const struct connectib_icm_page_manager *ptr_struct, u_int8_t* ptr_buff);
void connectib_icm_page_manager_unpack(struct connectib_icm_page_manager *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icm_page_manager_print(const struct connectib_icm_page_manager *ptr_struct, FILE* file, int indent_level);
int connectib_icm_page_manager_size(void);
#define CONNECTIB_ICM_PAGE_MANAGER_SIZE    (0x18)
void connectib_icm_page_manager_dump(const struct connectib_icm_page_manager *ptr_struct, FILE* file);
/* hca_params */
void connectib_hca_params_pack(const struct connectib_hca_params *ptr_struct, u_int8_t* ptr_buff);
void connectib_hca_params_unpack(struct connectib_hca_params *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hca_params_print(const struct connectib_hca_params *ptr_struct, FILE* file, int indent_level);
int connectib_hca_params_size(void);
#define CONNECTIB_HCA_PARAMS_SIZE    (0x20)
void connectib_hca_params_dump(const struct connectib_hca_params *ptr_struct, FILE* file);
/* dummy_addresses_one_cache_line */
void connectib_dummy_addresses_one_cache_line_pack(const struct connectib_dummy_addresses_one_cache_line *ptr_struct, u_int8_t* ptr_buff);
void connectib_dummy_addresses_one_cache_line_unpack(struct connectib_dummy_addresses_one_cache_line *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dummy_addresses_one_cache_line_print(const struct connectib_dummy_addresses_one_cache_line *ptr_struct, FILE* file, int indent_level);
int connectib_dummy_addresses_one_cache_line_size(void);
#define CONNECTIB_DUMMY_ADDRESSES_ONE_CACHE_LINE_SIZE    (0x40)
void connectib_dummy_addresses_one_cache_line_dump(const struct connectib_dummy_addresses_one_cache_line *ptr_struct, FILE* file);
/* cmdif_ctx */
void connectib_cmdif_ctx_pack(const struct connectib_cmdif_ctx *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_ctx_unpack(struct connectib_cmdif_ctx *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_ctx_print(const struct connectib_cmdif_ctx *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_ctx_size(void);
#define CONNECTIB_CMDIF_CTX_SIZE    (0x40)
void connectib_cmdif_ctx_dump(const struct connectib_cmdif_ctx *ptr_struct, FILE* file);
/* sw_eqe_data */
void connectib_sw_eqe_data_pack(const union connectib_sw_eqe_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_data_unpack(union connectib_sw_eqe_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_data_print(const union connectib_sw_eqe_data *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_data_size(void);
#define CONNECTIB_SW_EQE_DATA_SIZE    (0x1c)
void connectib_sw_eqe_data_dump(const union connectib_sw_eqe_data *ptr_struct, FILE* file);
/* reg_access_reg_tlv */
void connectib_reg_access_reg_tlv_pack(const struct connectib_reg_access_reg_tlv *ptr_struct, u_int8_t* ptr_buff);
void connectib_reg_access_reg_tlv_unpack(struct connectib_reg_access_reg_tlv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reg_access_reg_tlv_print(const struct connectib_reg_access_reg_tlv *ptr_struct, FILE* file, int indent_level);
int connectib_reg_access_reg_tlv_size(void);
#define CONNECTIB_REG_ACCESS_REG_TLV_SIZE    (0x30)
void connectib_reg_access_reg_tlv_dump(const struct connectib_reg_access_reg_tlv *ptr_struct, FILE* file);
/* reg_access_oper_tlv */
void connectib_reg_access_oper_tlv_pack(const struct connectib_reg_access_oper_tlv *ptr_struct, u_int8_t* ptr_buff);
void connectib_reg_access_oper_tlv_unpack(struct connectib_reg_access_oper_tlv *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reg_access_oper_tlv_print(const struct connectib_reg_access_oper_tlv *ptr_struct, FILE* file, int indent_level);
int connectib_reg_access_oper_tlv_size(void);
#define CONNECTIB_REG_ACCESS_OPER_TLV_SIZE    (0x10)
void connectib_reg_access_oper_tlv_dump(const struct connectib_reg_access_oper_tlv *ptr_struct, FILE* file);
/* output_inline_standart */
void connectib_output_inline_standart_pack(const struct connectib_output_inline_standart *ptr_struct, u_int8_t* ptr_buff);
void connectib_output_inline_standart_unpack(struct connectib_output_inline_standart *ptr_struct, const u_int8_t* ptr_buff);
void connectib_output_inline_standart_print(const struct connectib_output_inline_standart *ptr_struct, FILE* file, int indent_level);
int connectib_output_inline_standart_size(void);
#define CONNECTIB_OUTPUT_INLINE_STANDART_SIZE    (0x10)
void connectib_output_inline_standart_dump(const struct connectib_output_inline_standart *ptr_struct, FILE* file);
/* input_inline_standart */
void connectib_input_inline_standart_pack(const struct connectib_input_inline_standart *ptr_struct, u_int8_t* ptr_buff);
void connectib_input_inline_standart_unpack(struct connectib_input_inline_standart *ptr_struct, const u_int8_t* ptr_buff);
void connectib_input_inline_standart_print(const struct connectib_input_inline_standart *ptr_struct, FILE* file, int indent_level);
int connectib_input_inline_standart_size(void);
#define CONNECTIB_INPUT_INLINE_STANDART_SIZE    (0x10)
void connectib_input_inline_standart_dump(const struct connectib_input_inline_standart *ptr_struct, FILE* file);
/* g_rse_decoders_as_dwords */
void connectib_g_rse_decoders_as_dwords_pack(const struct connectib_g_rse_decoders_as_dwords *ptr_struct, u_int8_t* ptr_buff);
void connectib_g_rse_decoders_as_dwords_unpack(struct connectib_g_rse_decoders_as_dwords *ptr_struct, const u_int8_t* ptr_buff);
void connectib_g_rse_decoders_as_dwords_print(const struct connectib_g_rse_decoders_as_dwords *ptr_struct, FILE* file, int indent_level);
int connectib_g_rse_decoders_as_dwords_size(void);
#define CONNECTIB_G_RSE_DECODERS_AS_DWORDS_SIZE    (0x100)
void connectib_g_rse_decoders_as_dwords_dump(const struct connectib_g_rse_decoders_as_dwords *ptr_struct, FILE* file);
/* rxs_rxt_desc_decoder */
void connectib_rxs_rxt_desc_decoder_pack(const struct connectib_rxs_rxt_desc_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_rxs_rxt_desc_decoder_unpack(struct connectib_rxs_rxt_desc_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rxs_rxt_desc_decoder_print(const struct connectib_rxs_rxt_desc_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_rxs_rxt_desc_decoder_size(void);
#define CONNECTIB_RXS_RXT_DESC_DECODER_SIZE    (0x40)
void connectib_rxs_rxt_desc_decoder_dump(const struct connectib_rxs_rxt_desc_decoder *ptr_struct, FILE* file);
/* rxt_checks_packet_descriptor_decoder */
void connectib_rxt_checks_packet_descriptor_decoder_pack(const struct connectib_rxt_checks_packet_descriptor_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_rxt_checks_packet_descriptor_decoder_unpack(struct connectib_rxt_checks_packet_descriptor_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rxt_checks_packet_descriptor_decoder_print(const struct connectib_rxt_checks_packet_descriptor_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_rxt_checks_packet_descriptor_decoder_size(void);
#define CONNECTIB_RXT_CHECKS_PACKET_DESCRIPTOR_DECODER_SIZE    (0x40)
void connectib_rxt_checks_packet_descriptor_decoder_dump(const struct connectib_rxt_checks_packet_descriptor_decoder *ptr_struct, FILE* file);
/* rxt_context_fetch_qp_desc_decoder */
void connectib_rxt_context_fetch_qp_desc_decoder_pack(const struct connectib_rxt_context_fetch_qp_desc_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_rxt_context_fetch_qp_desc_decoder_unpack(struct connectib_rxt_context_fetch_qp_desc_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rxt_context_fetch_qp_desc_decoder_print(const struct connectib_rxt_context_fetch_qp_desc_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_rxt_context_fetch_qp_desc_decoder_size(void);
#define CONNECTIB_RXT_CONTEXT_FETCH_QP_DESC_DECODER_SIZE    (0x10)
void connectib_rxt_context_fetch_qp_desc_decoder_dump(const struct connectib_rxt_context_fetch_qp_desc_decoder *ptr_struct, FILE* file);
/* rxt_checks_steering_results_decoder */
void connectib_rxt_checks_steering_results_decoder_pack(const struct connectib_rxt_checks_steering_results_decoder *ptr_struct, u_int8_t* ptr_buff);
void connectib_rxt_checks_steering_results_decoder_unpack(struct connectib_rxt_checks_steering_results_decoder *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rxt_checks_steering_results_decoder_print(const struct connectib_rxt_checks_steering_results_decoder *ptr_struct, FILE* file, int indent_level);
int connectib_rxt_checks_steering_results_decoder_size(void);
#define CONNECTIB_RXT_CHECKS_STEERING_RESULTS_DECODER_SIZE    (0x10)
void connectib_rxt_checks_steering_results_decoder_dump(const struct connectib_rxt_checks_steering_results_decoder *ptr_struct, FILE* file);
/* ctx_as_dwords */
void connectib_ctx_as_dwords_pack(const struct connectib_ctx_as_dwords *ptr_struct, u_int8_t* ptr_buff);
void connectib_ctx_as_dwords_unpack(struct connectib_ctx_as_dwords *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ctx_as_dwords_print(const struct connectib_ctx_as_dwords *ptr_struct, FILE* file, int indent_level);
int connectib_ctx_as_dwords_size(void);
#define CONNECTIB_CTX_AS_DWORDS_SIZE    (0x40)
void connectib_ctx_as_dwords_dump(const struct connectib_ctx_as_dwords *ptr_struct, FILE* file);
/* fw_resource_context */
void connectib_fw_resource_context_pack(const union connectib_fw_resource_context *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_resource_context_unpack(union connectib_fw_resource_context *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_resource_context_print(const union connectib_fw_resource_context *ptr_struct, FILE* file, int indent_level);
int connectib_fw_resource_context_size(void);
#define CONNECTIB_FW_RESOURCE_CONTEXT_SIZE    (0x40)
void connectib_fw_resource_context_dump(const union connectib_fw_resource_context *ptr_struct, FILE* file);
/* hw_hca_contexts */
void connectib_hw_hca_contexts_pack(const union connectib_hw_hca_contexts *ptr_struct, u_int8_t* ptr_buff);
void connectib_hw_hca_contexts_unpack(union connectib_hw_hca_contexts *ptr_struct, const u_int8_t* ptr_buff);
void connectib_hw_hca_contexts_print(const union connectib_hw_hca_contexts *ptr_struct, FILE* file, int indent_level);
int connectib_hw_hca_contexts_size(void);
#define CONNECTIB_HW_HCA_CONTEXTS_SIZE    (0x40)
void connectib_hw_hca_contexts_dump(const union connectib_hw_hca_contexts *ptr_struct, FILE* file);
/* field_boundary */
void connectib_field_boundary_pack(const struct connectib_field_boundary *ptr_struct, u_int8_t* ptr_buff);
void connectib_field_boundary_unpack(struct connectib_field_boundary *ptr_struct, const u_int8_t* ptr_buff);
void connectib_field_boundary_print(const struct connectib_field_boundary *ptr_struct, FILE* file, int indent_level);
int connectib_field_boundary_size(void);
#define CONNECTIB_FIELD_BOUNDARY_SIZE    (0x4)
void connectib_field_boundary_dump(const struct connectib_field_boundary *ptr_struct, FILE* file);
/* add_data */
void connectib_add_data_pack(const struct connectib_add_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_add_data_unpack(struct connectib_add_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_add_data_print(const struct connectib_add_data *ptr_struct, FILE* file, int indent_level);
int connectib_add_data_size(void);
#define CONNECTIB_ADD_DATA_SIZE    (0x4)
void connectib_add_data_dump(const struct connectib_add_data *ptr_struct, FILE* file);
/* compare_mask_data */
void connectib_compare_mask_data_pack(const struct connectib_compare_mask_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_compare_mask_data_unpack(struct connectib_compare_mask_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_compare_mask_data_print(const struct connectib_compare_mask_data *ptr_struct, FILE* file, int indent_level);
int connectib_compare_mask_data_size(void);
#define CONNECTIB_COMPARE_MASK_DATA_SIZE    (0x4)
void connectib_compare_mask_data_dump(const struct connectib_compare_mask_data *ptr_struct, FILE* file);
/* swap_mask_data */
void connectib_swap_mask_data_pack(const struct connectib_swap_mask_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_swap_mask_data_unpack(struct connectib_swap_mask_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_swap_mask_data_print(const struct connectib_swap_mask_data *ptr_struct, FILE* file, int indent_level);
int connectib_swap_mask_data_size(void);
#define CONNECTIB_SWAP_MASK_DATA_SIZE    (0x4)
void connectib_swap_mask_data_dump(const struct connectib_swap_mask_data *ptr_struct, FILE* file);
/* compare_data */
void connectib_compare_data_pack(const struct connectib_compare_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_compare_data_unpack(struct connectib_compare_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_compare_data_print(const struct connectib_compare_data *ptr_struct, FILE* file, int indent_level);
int connectib_compare_data_size(void);
#define CONNECTIB_COMPARE_DATA_SIZE    (0x4)
void connectib_compare_data_dump(const struct connectib_compare_data *ptr_struct, FILE* file);
/* swap_data */
void connectib_swap_data_pack(const struct connectib_swap_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_swap_data_unpack(struct connectib_swap_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_swap_data_print(const struct connectib_swap_data *ptr_struct, FILE* file, int indent_level);
int connectib_swap_data_size(void);
#define CONNECTIB_SWAP_DATA_SIZE    (0x4)
void connectib_swap_data_dump(const struct connectib_swap_data *ptr_struct, FILE* file);
/* nv_data_pointer */
void connectib_nv_data_pointer_pack(const struct connectib_nv_data_pointer *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_data_pointer_unpack(struct connectib_nv_data_pointer *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_data_pointer_print(const struct connectib_nv_data_pointer *ptr_struct, FILE* file, int indent_level);
int connectib_nv_data_pointer_size(void);
#define CONNECTIB_NV_DATA_POINTER_SIZE    (0x4)
void connectib_nv_data_pointer_dump(const struct connectib_nv_data_pointer *ptr_struct, FILE* file);
/* jump_addresses */
void connectib_jump_addresses_pack(const struct connectib_jump_addresses *ptr_struct, u_int8_t* ptr_buff);
void connectib_jump_addresses_unpack(struct connectib_jump_addresses *ptr_struct, const u_int8_t* ptr_buff);
void connectib_jump_addresses_print(const struct connectib_jump_addresses *ptr_struct, FILE* file, int indent_level);
int connectib_jump_addresses_size(void);
#define CONNECTIB_JUMP_ADDRESSES_SIZE    (0x1c)
void connectib_jump_addresses_dump(const struct connectib_jump_addresses *ptr_struct, FILE* file);
/* pcie_rx_adaptation_cfg */
void connectib_pcie_rx_adaptation_cfg_pack(const struct connectib_pcie_rx_adaptation_cfg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_rx_adaptation_cfg_unpack(struct connectib_pcie_rx_adaptation_cfg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_rx_adaptation_cfg_print(const struct connectib_pcie_rx_adaptation_cfg *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_rx_adaptation_cfg_size(void);
#define CONNECTIB_PCIE_RX_ADAPTATION_CFG_SIZE    (0x44)
void connectib_pcie_rx_adaptation_cfg_dump(const struct connectib_pcie_rx_adaptation_cfg *ptr_struct, FILE* file);
/* pcie_tx_adaptation_cfg */
void connectib_pcie_tx_adaptation_cfg_pack(const struct connectib_pcie_tx_adaptation_cfg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_tx_adaptation_cfg_unpack(struct connectib_pcie_tx_adaptation_cfg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_tx_adaptation_cfg_print(const struct connectib_pcie_tx_adaptation_cfg *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_tx_adaptation_cfg_size(void);
#define CONNECTIB_PCIE_TX_ADAPTATION_CFG_SIZE    (0x10)
void connectib_pcie_tx_adaptation_cfg_dump(const struct connectib_pcie_tx_adaptation_cfg *ptr_struct, FILE* file);
/* pcie_debug_cap */
void connectib_pcie_debug_cap_pack(const struct connectib_pcie_debug_cap *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_debug_cap_unpack(struct connectib_pcie_debug_cap *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_debug_cap_print(const struct connectib_pcie_debug_cap *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_debug_cap_size(void);
#define CONNECTIB_PCIE_DEBUG_CAP_SIZE    (0x4)
void connectib_pcie_debug_cap_dump(const struct connectib_pcie_debug_cap *ptr_struct, FILE* file);
/* pcie_equalization_and_eye */
void connectib_pcie_equalization_and_eye_pack(const struct connectib_pcie_equalization_and_eye *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_equalization_and_eye_unpack(struct connectib_pcie_equalization_and_eye *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_equalization_and_eye_print(const struct connectib_pcie_equalization_and_eye *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_equalization_and_eye_size(void);
#define CONNECTIB_PCIE_EQUALIZATION_AND_EYE_SIZE    (0x34)
void connectib_pcie_equalization_and_eye_dump(const struct connectib_pcie_equalization_and_eye *ptr_struct, FILE* file);
/* pcie_serdes_cfg */
void connectib_pcie_serdes_cfg_pack(const struct connectib_pcie_serdes_cfg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_serdes_cfg_unpack(struct connectib_pcie_serdes_cfg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_serdes_cfg_print(const struct connectib_pcie_serdes_cfg *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_serdes_cfg_size(void);
#define CONNECTIB_PCIE_SERDES_CFG_SIZE    (0x20)
void connectib_pcie_serdes_cfg_dump(const struct connectib_pcie_serdes_cfg *ptr_struct, FILE* file);
/* gpio_configurations */
void connectib_gpio_configurations_pack(const struct connectib_gpio_configurations *ptr_struct, u_int8_t* ptr_buff);
void connectib_gpio_configurations_unpack(struct connectib_gpio_configurations *ptr_struct, const u_int8_t* ptr_buff);
void connectib_gpio_configurations_print(const struct connectib_gpio_configurations *ptr_struct, FILE* file, int indent_level);
int connectib_gpio_configurations_size(void);
#define CONNECTIB_GPIO_CONFIGURATIONS_SIZE    (0x30)
void connectib_gpio_configurations_dump(const struct connectib_gpio_configurations *ptr_struct, FILE* file);
/* gpio_functions */
void connectib_gpio_functions_pack(const struct connectib_gpio_functions *ptr_struct, u_int8_t* ptr_buff);
void connectib_gpio_functions_unpack(struct connectib_gpio_functions *ptr_struct, const u_int8_t* ptr_buff);
void connectib_gpio_functions_print(const struct connectib_gpio_functions *ptr_struct, FILE* file, int indent_level);
int connectib_gpio_functions_size(void);
#define CONNECTIB_GPIO_FUNCTIONS_SIZE    (0x54)
void connectib_gpio_functions_dump(const struct connectib_gpio_functions *ptr_struct, FILE* file);
/* i2c_device_entry */
void connectib_i2c_device_entry_pack(const struct connectib_i2c_device_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_i2c_device_entry_unpack(struct connectib_i2c_device_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_i2c_device_entry_print(const struct connectib_i2c_device_entry *ptr_struct, FILE* file, int indent_level);
int connectib_i2c_device_entry_size(void);
#define CONNECTIB_I2C_DEVICE_ENTRY_SIZE    (0x4)
void connectib_i2c_device_entry_dump(const struct connectib_i2c_device_entry *ptr_struct, FILE* file);
/* module_config_st */
void connectib_module_config_st_pack(const struct connectib_module_config_st *ptr_struct, u_int8_t* ptr_buff);
void connectib_module_config_st_unpack(struct connectib_module_config_st *ptr_struct, const u_int8_t* ptr_buff);
void connectib_module_config_st_print(const struct connectib_module_config_st *ptr_struct, FILE* file, int indent_level);
int connectib_module_config_st_size(void);
#define CONNECTIB_MODULE_CONFIG_ST_SIZE    (0x4)
void connectib_module_config_st_dump(const struct connectib_module_config_st *ptr_struct, FILE* file);
/* iopx_power */
void connectib_iopx_power_pack(const struct connectib_iopx_power *ptr_struct, u_int8_t* ptr_buff);
void connectib_iopx_power_unpack(struct connectib_iopx_power *ptr_struct, const u_int8_t* ptr_buff);
void connectib_iopx_power_print(const struct connectib_iopx_power *ptr_struct, FILE* file, int indent_level);
int connectib_iopx_power_size(void);
#define CONNECTIB_IOPX_POWER_SIZE    (0x4)
void connectib_iopx_power_dump(const struct connectib_iopx_power *ptr_struct, FILE* file);
/* iopl_power */
void connectib_iopl_power_pack(const struct connectib_iopl_power *ptr_struct, u_int8_t* ptr_buff);
void connectib_iopl_power_unpack(struct connectib_iopl_power *ptr_struct, const u_int8_t* ptr_buff);
void connectib_iopl_power_print(const struct connectib_iopl_power *ptr_struct, FILE* file, int indent_level);
int connectib_iopl_power_size(void);
#define CONNECTIB_IOPL_POWER_SIZE    (0x4)
void connectib_iopl_power_dump(const struct connectib_iopl_power *ptr_struct, FILE* file);
/* port_mlpn_db */
void connectib_port_mlpn_db_pack(const struct connectib_port_mlpn_db *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_mlpn_db_unpack(struct connectib_port_mlpn_db *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_mlpn_db_print(const struct connectib_port_mlpn_db *ptr_struct, FILE* file, int indent_level);
int connectib_port_mlpn_db_size(void);
#define CONNECTIB_PORT_MLPN_DB_SIZE    (0x10)
void connectib_port_mlpn_db_dump(const struct connectib_port_mlpn_db *ptr_struct, FILE* file);
/* pll_params */
void connectib_pll_params_pack(const struct connectib_pll_params *ptr_struct, u_int8_t* ptr_buff);
void connectib_pll_params_unpack(struct connectib_pll_params *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pll_params_print(const struct connectib_pll_params *ptr_struct, FILE* file, int indent_level);
int connectib_pll_params_size(void);
#define CONNECTIB_PLL_PARAMS_SIZE    (0x24)
void connectib_pll_params_dump(const struct connectib_pll_params *ptr_struct, FILE* file);
/* logic_serdes_mapping_node_ini */
void connectib_logic_serdes_mapping_node_ini_pack(const struct connectib_logic_serdes_mapping_node_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_logic_serdes_mapping_node_ini_unpack(struct connectib_logic_serdes_mapping_node_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_logic_serdes_mapping_node_ini_print(const struct connectib_logic_serdes_mapping_node_ini *ptr_struct, FILE* file, int indent_level);
int connectib_logic_serdes_mapping_node_ini_size(void);
#define CONNECTIB_LOGIC_SERDES_MAPPING_NODE_INI_SIZE    (0x40)
void connectib_logic_serdes_mapping_node_ini_dump(const struct connectib_logic_serdes_mapping_node_ini *ptr_struct, FILE* file);
/* phy_hw_main_config_ip */
void connectib_phy_hw_main_config_ip_pack(const struct connectib_phy_hw_main_config_ip *ptr_struct, u_int8_t* ptr_buff);
void connectib_phy_hw_main_config_ip_unpack(struct connectib_phy_hw_main_config_ip *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phy_hw_main_config_ip_print(const struct connectib_phy_hw_main_config_ip *ptr_struct, FILE* file, int indent_level);
int connectib_phy_hw_main_config_ip_size(void);
#define CONNECTIB_PHY_HW_MAIN_CONFIG_IP_SIZE    (0x5c0)
void connectib_phy_hw_main_config_ip_dump(const struct connectib_phy_hw_main_config_ip *ptr_struct, FILE* file);
/* nv_config_boot_global */
void connectib_nv_config_boot_global_pack(const struct connectib_nv_config_boot_global *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_boot_global_unpack(struct connectib_nv_config_boot_global *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_boot_global_print(const struct connectib_nv_config_boot_global *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_boot_global_size(void);
#define CONNECTIB_NV_CONFIG_BOOT_GLOBAL_SIZE    (0x28)
void connectib_nv_config_boot_global_dump(const struct connectib_nv_config_boot_global *ptr_struct, FILE* file);
/* pciex_ext_cfg_space */
void connectib_pciex_ext_cfg_space_pack(const struct connectib_pciex_ext_cfg_space *ptr_struct, u_int8_t* ptr_buff);
void connectib_pciex_ext_cfg_space_unpack(struct connectib_pciex_ext_cfg_space *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pciex_ext_cfg_space_print(const struct connectib_pciex_ext_cfg_space *ptr_struct, FILE* file, int indent_level);
int connectib_pciex_ext_cfg_space_size(void);
#define CONNECTIB_PCIEX_EXT_CFG_SPACE_SIZE    (0x100)
void connectib_pciex_ext_cfg_space_dump(const struct connectib_pciex_ext_cfg_space *ptr_struct, FILE* file);
/* pci_cfg_space */
void connectib_pci_cfg_space_pack(const struct connectib_pci_cfg_space *ptr_struct, u_int8_t* ptr_buff);
void connectib_pci_cfg_space_unpack(struct connectib_pci_cfg_space *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pci_cfg_space_print(const struct connectib_pci_cfg_space *ptr_struct, FILE* file, int indent_level);
int connectib_pci_cfg_space_size(void);
#define CONNECTIB_PCI_CFG_SPACE_SIZE    (0x100)
void connectib_pci_cfg_space_dump(const struct connectib_pci_cfg_space *ptr_struct, FILE* file);
/* nv_config_main_fw_data */
void connectib_nv_config_main_fw_data_pack(const struct connectib_nv_config_main_fw_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_main_fw_data_unpack(struct connectib_nv_config_main_fw_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_main_fw_data_print(const struct connectib_nv_config_main_fw_data *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_main_fw_data_size(void);
#define CONNECTIB_NV_CONFIG_MAIN_FW_DATA_SIZE    (0x20)
void connectib_nv_config_main_fw_data_dump(const struct connectib_nv_config_main_fw_data *ptr_struct, FILE* file);
/* phy_fw_main_config_ip */
void connectib_phy_fw_main_config_ip_pack(const struct connectib_phy_fw_main_config_ip *ptr_struct, u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_ip_unpack(struct connectib_phy_fw_main_config_ip *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_ip_print(const struct connectib_phy_fw_main_config_ip *ptr_struct, FILE* file, int indent_level);
int connectib_phy_fw_main_config_ip_size(void);
#define CONNECTIB_PHY_FW_MAIN_CONFIG_IP_SIZE    (0x180)
void connectib_phy_fw_main_config_ip_dump(const struct connectib_phy_fw_main_config_ip *ptr_struct, FILE* file);
/* phy_fw_main_config_golan */
void connectib_phy_fw_main_config_golan_pack(const struct connectib_phy_fw_main_config_golan *ptr_struct, u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_golan_unpack(struct connectib_phy_fw_main_config_golan *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_golan_print(const struct connectib_phy_fw_main_config_golan *ptr_struct, FILE* file, int indent_level);
int connectib_phy_fw_main_config_golan_size(void);
#define CONNECTIB_PHY_FW_MAIN_CONFIG_GOLAN_SIZE    (0xe8)
void connectib_phy_fw_main_config_golan_dump(const struct connectib_phy_fw_main_config_golan *ptr_struct, FILE* file);
/* ibm_thermal_config */
void connectib_ibm_thermal_config_pack(const struct connectib_ibm_thermal_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_ibm_thermal_config_unpack(struct connectib_ibm_thermal_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ibm_thermal_config_print(const struct connectib_ibm_thermal_config *ptr_struct, FILE* file, int indent_level);
int connectib_ibm_thermal_config_size(void);
#define CONNECTIB_IBM_THERMAL_CONFIG_SIZE    (0x1c)
void connectib_ibm_thermal_config_dump(const struct connectib_ibm_thermal_config *ptr_struct, FILE* file);
/* ocsd_config */
void connectib_ocsd_config_pack(const struct connectib_ocsd_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_ocsd_config_unpack(struct connectib_ocsd_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ocsd_config_print(const struct connectib_ocsd_config *ptr_struct, FILE* file, int indent_level);
int connectib_ocsd_config_size(void);
#define CONNECTIB_OCSD_CONFIG_SIZE    (0x14)
void connectib_ocsd_config_dump(const struct connectib_ocsd_config *ptr_struct, FILE* file);
/* extended_port_info_ini */
void connectib_extended_port_info_ini_pack(const struct connectib_extended_port_info_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_extended_port_info_ini_unpack(struct connectib_extended_port_info_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_extended_port_info_ini_print(const struct connectib_extended_port_info_ini *ptr_struct, FILE* file, int indent_level);
int connectib_extended_port_info_ini_size(void);
#define CONNECTIB_EXTENDED_PORT_INFO_INI_SIZE    (0x4)
void connectib_extended_port_info_ini_dump(const struct connectib_extended_port_info_ini *ptr_struct, FILE* file);
/* ib_port_info_ini */
void connectib_ib_port_info_ini_pack(const struct connectib_ib_port_info_ini *ptr_struct, u_int8_t* ptr_buff);
void connectib_ib_port_info_ini_unpack(struct connectib_ib_port_info_ini *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ib_port_info_ini_print(const struct connectib_ib_port_info_ini *ptr_struct, FILE* file, int indent_level);
int connectib_ib_port_info_ini_size(void);
#define CONNECTIB_IB_PORT_INFO_INI_SIZE    (0x1c)
void connectib_ib_port_info_ini_dump(const struct connectib_ib_port_info_ini *ptr_struct, FILE* file);
/* node_info */
void connectib_node_info_pack(const struct connectib_node_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_node_info_unpack(struct connectib_node_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_node_info_print(const struct connectib_node_info *ptr_struct, FILE* file, int indent_level);
int connectib_node_info_size(void);
#define CONNECTIB_NODE_INFO_SIZE    (0x40)
void connectib_node_info_dump(const struct connectib_node_info *ptr_struct, FILE* file);
/* led_port_blink_pattern */
void connectib_led_port_blink_pattern_pack(const struct connectib_led_port_blink_pattern *ptr_struct, u_int8_t* ptr_buff);
void connectib_led_port_blink_pattern_unpack(struct connectib_led_port_blink_pattern *ptr_struct, const u_int8_t* ptr_buff);
void connectib_led_port_blink_pattern_print(const struct connectib_led_port_blink_pattern *ptr_struct, FILE* file, int indent_level);
int connectib_led_port_blink_pattern_size(void);
#define CONNECTIB_LED_PORT_BLINK_PATTERN_SIZE    (0x8)
void connectib_led_port_blink_pattern_dump(const struct connectib_led_port_blink_pattern *ptr_struct, FILE* file);
/* uid_entry */
void connectib_uid_entry_pack(const struct connectib_uid_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_uid_entry_unpack(struct connectib_uid_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_uid_entry_print(const struct connectib_uid_entry *ptr_struct, FILE* file, int indent_level);
int connectib_uid_entry_size(void);
#define CONNECTIB_UID_ENTRY_SIZE    (0x10)
void connectib_uid_entry_dump(const struct connectib_uid_entry *ptr_struct, FILE* file);
/* module_version */
void connectib_module_version_pack(const struct connectib_module_version *ptr_struct, u_int8_t* ptr_buff);
void connectib_module_version_unpack(struct connectib_module_version *ptr_struct, const u_int8_t* ptr_buff);
void connectib_module_version_print(const struct connectib_module_version *ptr_struct, FILE* file, int indent_level);
int connectib_module_version_size(void);
#define CONNECTIB_MODULE_VERSION_SIZE    (0x4)
void connectib_module_version_dump(const struct connectib_module_version *ptr_struct, FILE* file);
/* reset_level_info */
void connectib_reset_level_info_pack(const struct connectib_reset_level_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_reset_level_info_unpack(struct connectib_reset_level_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reset_level_info_print(const struct connectib_reset_level_info *ptr_struct, FILE* file, int indent_level);
int connectib_reset_level_info_size(void);
#define CONNECTIB_RESET_LEVEL_INFO_SIZE    (0x10)
void connectib_reset_level_info_dump(const struct connectib_reset_level_info *ptr_struct, FILE* file);
/* vport_info */
void connectib_vport_info_pack(const struct connectib_vport_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_vport_info_unpack(struct connectib_vport_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vport_info_print(const struct connectib_vport_info *ptr_struct, FILE* file, int indent_level);
int connectib_vport_info_size(void);
#define CONNECTIB_VPORT_INFO_SIZE    (0x20)
void connectib_vport_info_dump(const struct connectib_vport_info *ptr_struct, FILE* file);
/* vport_shadow */
void connectib_vport_shadow_pack(const struct connectib_vport_shadow *ptr_struct, u_int8_t* ptr_buff);
void connectib_vport_shadow_unpack(struct connectib_vport_shadow *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vport_shadow_print(const struct connectib_vport_shadow *ptr_struct, FILE* file, int indent_level);
int connectib_vport_shadow_size(void);
#define CONNECTIB_VPORT_SHADOW_SIZE    (0x20)
void connectib_vport_shadow_dump(const struct connectib_vport_shadow *ptr_struct, FILE* file);
/* general_fault_injector_pair */
void connectib_general_fault_injector_pair_pack(const struct connectib_general_fault_injector_pair *ptr_struct, u_int8_t* ptr_buff);
void connectib_general_fault_injector_pair_unpack(struct connectib_general_fault_injector_pair *ptr_struct, const u_int8_t* ptr_buff);
void connectib_general_fault_injector_pair_print(const struct connectib_general_fault_injector_pair *ptr_struct, FILE* file, int indent_level);
int connectib_general_fault_injector_pair_size(void);
#define CONNECTIB_GENERAL_FAULT_INJECTOR_PAIR_SIZE    (0x4)
void connectib_general_fault_injector_pair_dump(const struct connectib_general_fault_injector_pair *ptr_struct, FILE* file);
/* pvlc_reg */
void connectib_pvlc_reg_pack(const struct connectib_pvlc_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pvlc_reg_unpack(struct connectib_pvlc_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pvlc_reg_print(const struct connectib_pvlc_reg *ptr_struct, FILE* file, int indent_level);
int connectib_pvlc_reg_size(void);
#define CONNECTIB_PVLC_REG_SIZE    (0x10)
void connectib_pvlc_reg_dump(const struct connectib_pvlc_reg *ptr_struct, FILE* file);
/* icmd_get_ste_resources_list_out */
void connectib_icmd_get_ste_resources_list_out_pack(const struct connectib_icmd_get_ste_resources_list_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_out_unpack(struct connectib_icmd_get_ste_resources_list_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_out_print(const struct connectib_icmd_get_ste_resources_list_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_resources_list_out_size(void);
#define CONNECTIB_ICMD_GET_STE_RESOURCES_LIST_OUT_SIZE    (0x100)
void connectib_icmd_get_ste_resources_list_out_dump(const struct connectib_icmd_get_ste_resources_list_out *ptr_struct, FILE* file);
/* icmd_get_ste_resources_list_in */
void connectib_icmd_get_ste_resources_list_in_pack(const struct connectib_icmd_get_ste_resources_list_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_in_unpack(struct connectib_icmd_get_ste_resources_list_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_in_print(const struct connectib_icmd_get_ste_resources_list_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_resources_list_in_size(void);
#define CONNECTIB_ICMD_GET_STE_RESOURCES_LIST_IN_SIZE    (0x10)
void connectib_icmd_get_ste_resources_list_in_dump(const struct connectib_icmd_get_ste_resources_list_in *ptr_struct, FILE* file);
/* icmd_get_ste_open_resources_out */
void connectib_icmd_get_ste_open_resources_out_pack(const struct connectib_icmd_get_ste_open_resources_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_out_unpack(struct connectib_icmd_get_ste_open_resources_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_out_print(const struct connectib_icmd_get_ste_open_resources_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_open_resources_out_size(void);
#define CONNECTIB_ICMD_GET_STE_OPEN_RESOURCES_OUT_SIZE    (0x300)
void connectib_icmd_get_ste_open_resources_out_dump(const struct connectib_icmd_get_ste_open_resources_out *ptr_struct, FILE* file);
/* icmd_get_ste_open_resources_in */
void connectib_icmd_get_ste_open_resources_in_pack(const struct connectib_icmd_get_ste_open_resources_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_in_unpack(struct connectib_icmd_get_ste_open_resources_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_in_print(const struct connectib_icmd_get_ste_open_resources_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_open_resources_in_size(void);
#define CONNECTIB_ICMD_GET_STE_OPEN_RESOURCES_IN_SIZE    (0x10)
void connectib_icmd_get_ste_open_resources_in_dump(const struct connectib_icmd_get_ste_open_resources_in *ptr_struct, FILE* file);
/* icmd_get_fte_out */
void connectib_icmd_get_fte_out_pack(const struct connectib_icmd_get_fte_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_out_unpack(struct connectib_icmd_get_fte_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_out_print(const struct connectib_icmd_get_fte_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_out_size(void);
#define CONNECTIB_ICMD_GET_FTE_OUT_SIZE    (0x300)
void connectib_icmd_get_fte_out_dump(const struct connectib_icmd_get_fte_out *ptr_struct, FILE* file);
/* icmd_get_fte_in */
void connectib_icmd_get_fte_in_pack(const struct connectib_icmd_get_fte_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_in_unpack(struct connectib_icmd_get_fte_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_in_print(const struct connectib_icmd_get_fte_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_in_size(void);
#define CONNECTIB_ICMD_GET_FTE_IN_SIZE    (0x10)
void connectib_icmd_get_fte_in_dump(const struct connectib_icmd_get_fte_in *ptr_struct, FILE* file);
/* icmd_get_fte_list_out */
void connectib_icmd_get_fte_list_out_pack(const struct connectib_icmd_get_fte_list_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_out_unpack(struct connectib_icmd_get_fte_list_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_out_print(const struct connectib_icmd_get_fte_list_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_list_out_size(void);
#define CONNECTIB_ICMD_GET_FTE_LIST_OUT_SIZE    (0x10)
void connectib_icmd_get_fte_list_out_dump(const struct connectib_icmd_get_fte_list_out *ptr_struct, FILE* file);
/* icmd_get_fte_list_in */
void connectib_icmd_get_fte_list_in_pack(const struct connectib_icmd_get_fte_list_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_in_unpack(struct connectib_icmd_get_fte_list_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_in_print(const struct connectib_icmd_get_fte_list_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_list_in_size(void);
#define CONNECTIB_ICMD_GET_FTE_LIST_IN_SIZE    (0x10)
void connectib_icmd_get_fte_list_in_dump(const struct connectib_icmd_get_fte_list_in *ptr_struct, FILE* file);
/* icmd_get_fg_out */
void connectib_icmd_get_fg_out_pack(const struct connectib_icmd_get_fg_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_out_unpack(struct connectib_icmd_get_fg_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_out_print(const struct connectib_icmd_get_fg_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_out_size(void);
#define CONNECTIB_ICMD_GET_FG_OUT_SIZE    (0x100)
void connectib_icmd_get_fg_out_dump(const struct connectib_icmd_get_fg_out *ptr_struct, FILE* file);
/* icmd_get_fg_in */
void connectib_icmd_get_fg_in_pack(const struct connectib_icmd_get_fg_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_in_unpack(struct connectib_icmd_get_fg_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_in_print(const struct connectib_icmd_get_fg_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_in_size(void);
#define CONNECTIB_ICMD_GET_FG_IN_SIZE    (0x10)
void connectib_icmd_get_fg_in_dump(const struct connectib_icmd_get_fg_in *ptr_struct, FILE* file);
/* icmd_get_fg_list_out */
void connectib_icmd_get_fg_list_out_pack(const struct connectib_icmd_get_fg_list_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_out_unpack(struct connectib_icmd_get_fg_list_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_out_print(const struct connectib_icmd_get_fg_list_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_list_out_size(void);
#define CONNECTIB_ICMD_GET_FG_LIST_OUT_SIZE    (0x10)
void connectib_icmd_get_fg_list_out_dump(const struct connectib_icmd_get_fg_list_out *ptr_struct, FILE* file);
/* icmd_get_fg_list_in */
void connectib_icmd_get_fg_list_in_pack(const struct connectib_icmd_get_fg_list_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_in_unpack(struct connectib_icmd_get_fg_list_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_in_print(const struct connectib_icmd_get_fg_list_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_list_in_size(void);
#define CONNECTIB_ICMD_GET_FG_LIST_IN_SIZE    (0x10)
void connectib_icmd_get_fg_list_in_dump(const struct connectib_icmd_get_fg_list_in *ptr_struct, FILE* file);
/* icmd_get_ft_info_out */
void connectib_icmd_get_ft_info_out_pack(const struct connectib_icmd_get_ft_info_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_out_unpack(struct connectib_icmd_get_ft_info_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_out_print(const struct connectib_icmd_get_ft_info_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_info_out_size(void);
#define CONNECTIB_ICMD_GET_FT_INFO_OUT_SIZE    (0x10)
void connectib_icmd_get_ft_info_out_dump(const struct connectib_icmd_get_ft_info_out *ptr_struct, FILE* file);
/* icmd_get_ft_info_in */
void connectib_icmd_get_ft_info_in_pack(const struct connectib_icmd_get_ft_info_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_in_unpack(struct connectib_icmd_get_ft_info_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_in_print(const struct connectib_icmd_get_ft_info_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_info_in_size(void);
#define CONNECTIB_ICMD_GET_FT_INFO_IN_SIZE    (0x10)
void connectib_icmd_get_ft_info_in_dump(const struct connectib_icmd_get_ft_info_in *ptr_struct, FILE* file);
/* icmd_get_ft_list_out */
void connectib_icmd_get_ft_list_out_pack(const struct connectib_icmd_get_ft_list_out *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_out_unpack(struct connectib_icmd_get_ft_list_out *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_out_print(const struct connectib_icmd_get_ft_list_out *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_list_out_size(void);
#define CONNECTIB_ICMD_GET_FT_LIST_OUT_SIZE    (0x10)
void connectib_icmd_get_ft_list_out_dump(const struct connectib_icmd_get_ft_list_out *ptr_struct, FILE* file);
/* icmd_get_ft_list_in */
void connectib_icmd_get_ft_list_in_pack(const struct connectib_icmd_get_ft_list_in *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_in_unpack(struct connectib_icmd_get_ft_list_in *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_in_print(const struct connectib_icmd_get_ft_list_in *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_list_in_size(void);
#define CONNECTIB_ICMD_GET_FT_LIST_IN_SIZE    (0x10)
void connectib_icmd_get_ft_list_in_dump(const struct connectib_icmd_get_ft_list_in *ptr_struct, FILE* file);
/* ppcnt_reg */
void connectib_ppcnt_reg_pack(const struct connectib_ppcnt_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_ppcnt_reg_unpack(struct connectib_ppcnt_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ppcnt_reg_print(const struct connectib_ppcnt_reg *ptr_struct, FILE* file, int indent_level);
int connectib_ppcnt_reg_size(void);
#define CONNECTIB_PPCNT_REG_SIZE    (0x100)
void connectib_ppcnt_reg_dump(const struct connectib_ppcnt_reg *ptr_struct, FILE* file);
/* ptys_reg */
void connectib_ptys_reg_pack(const struct connectib_ptys_reg *ptr_struct, u_int8_t* ptr_buff);
void connectib_ptys_reg_unpack(struct connectib_ptys_reg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ptys_reg_print(const struct connectib_ptys_reg *ptr_struct, FILE* file, int indent_level);
int connectib_ptys_reg_size(void);
#define CONNECTIB_PTYS_REG_SIZE    (0x40)
void connectib_ptys_reg_dump(const struct connectib_ptys_reg *ptr_struct, FILE* file);
/* steering_table_info */
void connectib_steering_table_info_pack(const struct connectib_steering_table_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_steering_table_info_unpack(struct connectib_steering_table_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_steering_table_info_print(const struct connectib_steering_table_info *ptr_struct, FILE* file, int indent_level);
int connectib_steering_table_info_size(void);
#define CONNECTIB_STEERING_TABLE_INFO_SIZE    (0x20)
void connectib_steering_table_info_dump(const struct connectib_steering_table_info *ptr_struct, FILE* file);
/* dcr_info */
void connectib_dcr_info_pack(const struct connectib_dcr_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_dcr_info_unpack(struct connectib_dcr_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_dcr_info_print(const struct connectib_dcr_info *ptr_struct, FILE* file, int indent_level);
int connectib_dcr_info_size(void);
#define CONNECTIB_DCR_INFO_SIZE    (0x4)
void connectib_dcr_info_dump(const struct connectib_dcr_info *ptr_struct, FILE* file);
/* icmd_pcie_ver_frequency */
void connectib_icmd_pcie_ver_frequency_pack(const struct connectib_icmd_pcie_ver_frequency *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_frequency_unpack(struct connectib_icmd_pcie_ver_frequency *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_frequency_print(const struct connectib_icmd_pcie_ver_frequency *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_pcie_ver_frequency_size(void);
#define CONNECTIB_ICMD_PCIE_VER_FREQUENCY_SIZE    (0x10)
void connectib_icmd_pcie_ver_frequency_dump(const struct connectib_icmd_pcie_ver_frequency *ptr_struct, FILE* file);
/* icmd_pcie_ver_cables */
void connectib_icmd_pcie_ver_cables_pack(const struct connectib_icmd_pcie_ver_cables *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_cables_unpack(struct connectib_icmd_pcie_ver_cables *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_cables_print(const struct connectib_icmd_pcie_ver_cables *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_pcie_ver_cables_size(void);
#define CONNECTIB_ICMD_PCIE_VER_CABLES_SIZE    (0x10)
void connectib_icmd_pcie_ver_cables_dump(const struct connectib_icmd_pcie_ver_cables *ptr_struct, FILE* file);
/* icmd_pcie_ver_device */
void connectib_icmd_pcie_ver_device_pack(const struct connectib_icmd_pcie_ver_device *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_device_unpack(struct connectib_icmd_pcie_ver_device *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_device_print(const struct connectib_icmd_pcie_ver_device *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_pcie_ver_device_size(void);
#define CONNECTIB_ICMD_PCIE_VER_DEVICE_SIZE    (0x10)
void connectib_icmd_pcie_ver_device_dump(const struct connectib_icmd_pcie_ver_device *ptr_struct, FILE* file);
/* code_coverage_control */
void connectib_code_coverage_control_pack(const struct connectib_code_coverage_control *ptr_struct, u_int8_t* ptr_buff);
void connectib_code_coverage_control_unpack(struct connectib_code_coverage_control *ptr_struct, const u_int8_t* ptr_buff);
void connectib_code_coverage_control_print(const struct connectib_code_coverage_control *ptr_struct, FILE* file, int indent_level);
int connectib_code_coverage_control_size(void);
#define CONNECTIB_CODE_COVERAGE_CONTROL_SIZE    (0x8)
void connectib_code_coverage_control_dump(const struct connectib_code_coverage_control *ptr_struct, FILE* file);
/* vport_real_state */
void connectib_vport_real_state_pack(const struct connectib_vport_real_state *ptr_struct, u_int8_t* ptr_buff);
void connectib_vport_real_state_unpack(struct connectib_vport_real_state *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vport_real_state_print(const struct connectib_vport_real_state *ptr_struct, FILE* file, int indent_level);
int connectib_vport_real_state_size(void);
#define CONNECTIB_VPORT_REAL_STATE_SIZE    (0x200)
void connectib_vport_real_state_dump(const struct connectib_vport_real_state *ptr_struct, FILE* file);
/* fw_esw */
void connectib_fw_esw_pack(const struct connectib_fw_esw *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_esw_unpack(struct connectib_fw_esw *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_esw_print(const struct connectib_fw_esw *ptr_struct, FILE* file, int indent_level);
int connectib_fw_esw_size(void);
#define CONNECTIB_FW_ESW_SIZE    (0x40)
void connectib_fw_esw_dump(const struct connectib_fw_esw *ptr_struct, FILE* file);
/* gvmix_sub_structs */
void connectib_gvmix_sub_structs_pack(const union connectib_gvmix_sub_structs *ptr_struct, u_int8_t* ptr_buff);
void connectib_gvmix_sub_structs_unpack(union connectib_gvmix_sub_structs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_gvmix_sub_structs_print(const union connectib_gvmix_sub_structs *ptr_struct, FILE* file, int indent_level);
int connectib_gvmix_sub_structs_size(void);
#define CONNECTIB_GVMIX_SUB_STRUCTS_SIZE    (0x40)
void connectib_gvmix_sub_structs_dump(const union connectib_gvmix_sub_structs *ptr_struct, FILE* file);
/* sw_eqe */
void connectib_sw_eqe_pack(const struct connectib_sw_eqe *ptr_struct, u_int8_t* ptr_buff);
void connectib_sw_eqe_unpack(struct connectib_sw_eqe *ptr_struct, const u_int8_t* ptr_buff);
void connectib_sw_eqe_print(const struct connectib_sw_eqe *ptr_struct, FILE* file, int indent_level);
int connectib_sw_eqe_size(void);
#define CONNECTIB_SW_EQE_SIZE    (0x40)
void connectib_sw_eqe_dump(const struct connectib_sw_eqe *ptr_struct, FILE* file);
/* itrace_ctrl */
void connectib_itrace_ctrl_pack(const struct connectib_itrace_ctrl *ptr_struct, u_int8_t* ptr_buff);
void connectib_itrace_ctrl_unpack(struct connectib_itrace_ctrl *ptr_struct, const u_int8_t* ptr_buff);
void connectib_itrace_ctrl_print(const struct connectib_itrace_ctrl *ptr_struct, FILE* file, int indent_level);
int connectib_itrace_ctrl_size(void);
#define CONNECTIB_ITRACE_CTRL_SIZE    (0x4)
void connectib_itrace_ctrl_dump(const struct connectib_itrace_ctrl *ptr_struct, FILE* file);
/* lock_tag */
void connectib_lock_tag_pack(const struct connectib_lock_tag *ptr_struct, u_int8_t* ptr_buff);
void connectib_lock_tag_unpack(struct connectib_lock_tag *ptr_struct, const u_int8_t* ptr_buff);
void connectib_lock_tag_print(const struct connectib_lock_tag *ptr_struct, FILE* file, int indent_level);
int connectib_lock_tag_size(void);
#define CONNECTIB_LOCK_TAG_SIZE    (0x4)
void connectib_lock_tag_dump(const struct connectib_lock_tag *ptr_struct, FILE* file);
/* reg_access_cmd */
void connectib_reg_access_cmd_pack(const struct connectib_reg_access_cmd *ptr_struct, u_int8_t* ptr_buff);
void connectib_reg_access_cmd_unpack(struct connectib_reg_access_cmd *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reg_access_cmd_print(const struct connectib_reg_access_cmd *ptr_struct, FILE* file, int indent_level);
int connectib_reg_access_cmd_size(void);
#define CONNECTIB_REG_ACCESS_CMD_SIZE    (0x40)
void connectib_reg_access_cmd_dump(const struct connectib_reg_access_cmd *ptr_struct, FILE* file);
/* cable_info */
void connectib_cable_info_pack(const struct connectib_cable_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_cable_info_unpack(struct connectib_cable_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cable_info_print(const struct connectib_cable_info *ptr_struct, FILE* file, int indent_level);
int connectib_cable_info_size(void);
#define CONNECTIB_CABLE_INFO_SIZE    (0x40)
void connectib_cable_info_dump(const struct connectib_cable_info *ptr_struct, FILE* file);
/* grepper_dwords */
void connectib_grepper_dwords_pack(const struct connectib_grepper_dwords *ptr_struct, u_int8_t* ptr_buff);
void connectib_grepper_dwords_unpack(struct connectib_grepper_dwords *ptr_struct, const u_int8_t* ptr_buff);
void connectib_grepper_dwords_print(const struct connectib_grepper_dwords *ptr_struct, FILE* file, int indent_level);
int connectib_grepper_dwords_size(void);
#define CONNECTIB_GREPPER_DWORDS_SIZE    (0x40)
void connectib_grepper_dwords_dump(const struct connectib_grepper_dwords *ptr_struct, FILE* file);
/* cc_table_entry */
void connectib_cc_table_entry_pack(const struct connectib_cc_table_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_cc_table_entry_unpack(struct connectib_cc_table_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cc_table_entry_print(const struct connectib_cc_table_entry *ptr_struct, FILE* file, int indent_level);
int connectib_cc_table_entry_size(void);
#define CONNECTIB_CC_TABLE_ENTRY_SIZE    (0x2)
void connectib_cc_table_entry_dump(const struct connectib_cc_table_entry *ptr_struct, FILE* file);
/* ca_congestion_entry */
void connectib_ca_congestion_entry_pack(const struct connectib_ca_congestion_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_ca_congestion_entry_unpack(struct connectib_ca_congestion_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ca_congestion_entry_print(const struct connectib_ca_congestion_entry *ptr_struct, FILE* file, int indent_level);
int connectib_ca_congestion_entry_size(void);
#define CONNECTIB_CA_CONGESTION_ENTRY_SIZE    (0x8)
void connectib_ca_congestion_entry_dump(const struct connectib_ca_congestion_entry *ptr_struct, FILE* file);
/* congestion_log_event_entry */
void connectib_congestion_log_event_entry_pack(const struct connectib_congestion_log_event_entry *ptr_struct, u_int8_t* ptr_buff);
void connectib_congestion_log_event_entry_unpack(struct connectib_congestion_log_event_entry *ptr_struct, const u_int8_t* ptr_buff);
void connectib_congestion_log_event_entry_print(const struct connectib_congestion_log_event_entry *ptr_struct, FILE* file, int indent_level);
int connectib_congestion_log_event_entry_size(void);
#define CONNECTIB_CONGESTION_LOG_EVENT_ENTRY_SIZE    (0x10)
void connectib_congestion_log_event_entry_dump(const struct connectib_congestion_log_event_entry *ptr_struct, FILE* file);
/* special_qps */
void connectib_special_qps_pack(const struct connectib_special_qps *ptr_struct, u_int8_t* ptr_buff);
void connectib_special_qps_unpack(struct connectib_special_qps *ptr_struct, const u_int8_t* ptr_buff);
void connectib_special_qps_print(const struct connectib_special_qps *ptr_struct, FILE* file, int indent_level);
int connectib_special_qps_size(void);
#define CONNECTIB_SPECIAL_QPS_SIZE    (0x20)
void connectib_special_qps_dump(const struct connectib_special_qps *ptr_struct, FILE* file);
/* cmdif_hdr */
void connectib_cmdif_hdr_pack(const struct connectib_cmdif_hdr *ptr_struct, u_int8_t* ptr_buff);
void connectib_cmdif_hdr_unpack(struct connectib_cmdif_hdr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_cmdif_hdr_print(const struct connectib_cmdif_hdr *ptr_struct, FILE* file, int indent_level);
int connectib_cmdif_hdr_size(void);
#define CONNECTIB_CMDIF_HDR_SIZE    (0x40)
void connectib_cmdif_hdr_dump(const struct connectib_cmdif_hdr *ptr_struct, FILE* file);
/* icmd_header_capture_checks */
void connectib_icmd_header_capture_checks_pack(const struct connectib_icmd_header_capture_checks *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_header_capture_checks_unpack(struct connectib_icmd_header_capture_checks *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_header_capture_checks_print(const struct connectib_icmd_header_capture_checks *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_header_capture_checks_size(void);
#define CONNECTIB_ICMD_HEADER_CAPTURE_CHECKS_SIZE    (0x40)
void connectib_icmd_header_capture_checks_dump(const struct connectib_icmd_header_capture_checks *ptr_struct, FILE* file);
/* icmd_header_capture_headers */
void connectib_icmd_header_capture_headers_pack(const struct connectib_icmd_header_capture_headers *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_header_capture_headers_unpack(struct connectib_icmd_header_capture_headers *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_header_capture_headers_print(const struct connectib_icmd_header_capture_headers *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_header_capture_headers_size(void);
#define CONNECTIB_ICMD_HEADER_CAPTURE_HEADERS_SIZE    (0x80)
void connectib_icmd_header_capture_headers_dump(const struct connectib_icmd_header_capture_headers *ptr_struct, FILE* file);
/* g_rse_hw_decoders */
void connectib_g_rse_hw_decoders_pack(const union connectib_g_rse_hw_decoders *ptr_struct, u_int8_t* ptr_buff);
void connectib_g_rse_hw_decoders_unpack(union connectib_g_rse_hw_decoders *ptr_struct, const u_int8_t* ptr_buff);
void connectib_g_rse_hw_decoders_print(const union connectib_g_rse_hw_decoders *ptr_struct, FILE* file, int indent_level);
int connectib_g_rse_hw_decoders_size(void);
#define CONNECTIB_G_RSE_HW_DECODERS_SIZE    (0x100)
void connectib_g_rse_hw_decoders_dump(const union connectib_g_rse_hw_decoders *ptr_struct, FILE* file);
/* FW_VERSION */
void connectib_FW_VERSION_pack(const struct connectib_FW_VERSION *ptr_struct, u_int8_t* ptr_buff);
void connectib_FW_VERSION_unpack(struct connectib_FW_VERSION *ptr_struct, const u_int8_t* ptr_buff);
void connectib_FW_VERSION_print(const struct connectib_FW_VERSION *ptr_struct, FILE* file, int indent_level);
int connectib_FW_VERSION_size(void);
#define CONNECTIB_FW_VERSION_SIZE    (0x10)
void connectib_FW_VERSION_dump(const struct connectib_FW_VERSION *ptr_struct, FILE* file);
/* golan_hw_fw_ctx */
void connectib_golan_hw_fw_ctx_pack(const union connectib_golan_hw_fw_ctx *ptr_struct, u_int8_t* ptr_buff);
void connectib_golan_hw_fw_ctx_unpack(union connectib_golan_hw_fw_ctx *ptr_struct, const u_int8_t* ptr_buff);
void connectib_golan_hw_fw_ctx_print(const union connectib_golan_hw_fw_ctx *ptr_struct, FILE* file, int indent_level);
int connectib_golan_hw_fw_ctx_size(void);
#define CONNECTIB_GOLAN_HW_FW_CTX_SIZE    (0x40)
void connectib_golan_hw_fw_ctx_dump(const union connectib_golan_hw_fw_ctx *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_128byte */
void connectib_wqe_extended_atomic_fetch_add_128byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_128byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_128byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_128byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_128byte_print(const struct connectib_wqe_extended_atomic_fetch_add_128byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_128byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_128BYTE_SIZE    (0x100)
void connectib_wqe_extended_atomic_fetch_add_128byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_128byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_64byte */
void connectib_wqe_extended_atomic_fetch_add_64byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_64byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_64byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_64byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_64byte_print(const struct connectib_wqe_extended_atomic_fetch_add_64byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_64byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_64BYTE_SIZE    (0x80)
void connectib_wqe_extended_atomic_fetch_add_64byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_64byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_32byte */
void connectib_wqe_extended_atomic_fetch_add_32byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_32byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_32byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_32byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_32byte_print(const struct connectib_wqe_extended_atomic_fetch_add_32byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_32byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_32BYTE_SIZE    (0x40)
void connectib_wqe_extended_atomic_fetch_add_32byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_32byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_16byte */
void connectib_wqe_extended_atomic_fetch_add_16byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_16byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_16byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_16byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_16byte_print(const struct connectib_wqe_extended_atomic_fetch_add_16byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_16byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_16BYTE_SIZE    (0x20)
void connectib_wqe_extended_atomic_fetch_add_16byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_16byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_8byte */
void connectib_wqe_extended_atomic_fetch_add_8byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_8byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_8byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_8byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_8byte_print(const struct connectib_wqe_extended_atomic_fetch_add_8byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_8byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_8BYTE_SIZE    (0x10)
void connectib_wqe_extended_atomic_fetch_add_8byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_8byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_fetch_add_4byte */
void connectib_wqe_extended_atomic_fetch_add_4byte_pack(const struct connectib_wqe_extended_atomic_fetch_add_4byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_4byte_unpack(struct connectib_wqe_extended_atomic_fetch_add_4byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_fetch_add_4byte_print(const struct connectib_wqe_extended_atomic_fetch_add_4byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_fetch_add_4byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_FETCH_ADD_4BYTE_SIZE    (0x10)
void connectib_wqe_extended_atomic_fetch_add_4byte_dump(const struct connectib_wqe_extended_atomic_fetch_add_4byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_128byte */
void connectib_wqe_extended_atomic_cmp_swap_128byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_128byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_128byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_128byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_128byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_128byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_128byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_128BYTE_SIZE    (0x200)
void connectib_wqe_extended_atomic_cmp_swap_128byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_128byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_64byte */
void connectib_wqe_extended_atomic_cmp_swap_64byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_64byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_64byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_64byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_64byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_64byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_64byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_64BYTE_SIZE    (0x100)
void connectib_wqe_extended_atomic_cmp_swap_64byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_64byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_32byte */
void connectib_wqe_extended_atomic_cmp_swap_32byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_32byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_32byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_32byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_32byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_32byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_32byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_32BYTE_SIZE    (0x80)
void connectib_wqe_extended_atomic_cmp_swap_32byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_32byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_16byte */
void connectib_wqe_extended_atomic_cmp_swap_16byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_16byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_16byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_16byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_16byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_16byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_16byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_16BYTE_SIZE    (0x40)
void connectib_wqe_extended_atomic_cmp_swap_16byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_16byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_8byte */
void connectib_wqe_extended_atomic_cmp_swap_8byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_8byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_8byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_8byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_8byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_8byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_8byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_8BYTE_SIZE    (0x20)
void connectib_wqe_extended_atomic_cmp_swap_8byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_8byte *ptr_struct, FILE* file);
/* wqe_extended_atomic_cmp_swap_4byte */
void connectib_wqe_extended_atomic_cmp_swap_4byte_pack(const struct connectib_wqe_extended_atomic_cmp_swap_4byte *ptr_struct, u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_4byte_unpack(struct connectib_wqe_extended_atomic_cmp_swap_4byte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_wqe_extended_atomic_cmp_swap_4byte_print(const struct connectib_wqe_extended_atomic_cmp_swap_4byte *ptr_struct, FILE* file, int indent_level);
int connectib_wqe_extended_atomic_cmp_swap_4byte_size(void);
#define CONNECTIB_WQE_EXTENDED_ATOMIC_CMP_SWAP_4BYTE_SIZE    (0x10)
void connectib_wqe_extended_atomic_cmp_swap_4byte_dump(const struct connectib_wqe_extended_atomic_cmp_swap_4byte *ptr_struct, FILE* file);
/* nv_config_header */
void connectib_nv_config_header_pack(const struct connectib_nv_config_header *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_header_unpack(struct connectib_nv_config_header *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_header_print(const struct connectib_nv_config_header *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_header_size(void);
#define CONNECTIB_NV_CONFIG_HEADER_SIZE    (0x40)
void connectib_nv_config_header_dump(const struct connectib_nv_config_header *ptr_struct, FILE* file);
/* fw_image */
void connectib_fw_image_pack(const struct connectib_fw_image *ptr_struct, u_int8_t* ptr_buff);
void connectib_fw_image_unpack(struct connectib_fw_image *ptr_struct, const u_int8_t* ptr_buff);
void connectib_fw_image_print(const struct connectib_fw_image *ptr_struct, FILE* file, int indent_level);
int connectib_fw_image_size(void);
#define CONNECTIB_FW_IMAGE_SIZE    (0x20)
void connectib_fw_image_dump(const struct connectib_fw_image *ptr_struct, FILE* file);
/* pcie_cfg_golan */
void connectib_pcie_cfg_golan_pack(const struct connectib_pcie_cfg_golan *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_cfg_golan_unpack(struct connectib_pcie_cfg_golan *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_cfg_golan_print(const struct connectib_pcie_cfg_golan *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_cfg_golan_size(void);
#define CONNECTIB_PCIE_CFG_GOLAN_SIZE    (0xc0)
void connectib_pcie_cfg_golan_dump(const struct connectib_pcie_cfg_golan *ptr_struct, FILE* file);
/* vpd_eeprom_info */
void connectib_vpd_eeprom_info_pack(const struct connectib_vpd_eeprom_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_vpd_eeprom_info_unpack(struct connectib_vpd_eeprom_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_vpd_eeprom_info_print(const struct connectib_vpd_eeprom_info *ptr_struct, FILE* file, int indent_level);
int connectib_vpd_eeprom_info_size(void);
#define CONNECTIB_VPD_EEPROM_INFO_SIZE    (0x8)
void connectib_vpd_eeprom_info_dump(const struct connectib_vpd_eeprom_info *ptr_struct, FILE* file);
/* ini_gpios_golan */
void connectib_ini_gpios_golan_pack(const struct connectib_ini_gpios_golan *ptr_struct, u_int8_t* ptr_buff);
void connectib_ini_gpios_golan_unpack(struct connectib_ini_gpios_golan *ptr_struct, const u_int8_t* ptr_buff);
void connectib_ini_gpios_golan_print(const struct connectib_ini_gpios_golan *ptr_struct, FILE* file, int indent_level);
int connectib_ini_gpios_golan_size(void);
#define CONNECTIB_INI_GPIOS_GOLAN_SIZE    (0x84)
void connectib_ini_gpios_golan_dump(const struct connectib_ini_gpios_golan *ptr_struct, FILE* file);
/* i2c_devices_db */
void connectib_i2c_devices_db_pack(const struct connectib_i2c_devices_db *ptr_struct, u_int8_t* ptr_buff);
void connectib_i2c_devices_db_unpack(struct connectib_i2c_devices_db *ptr_struct, const u_int8_t* ptr_buff);
void connectib_i2c_devices_db_print(const struct connectib_i2c_devices_db *ptr_struct, FILE* file, int indent_level);
int connectib_i2c_devices_db_size(void);
#define CONNECTIB_I2C_DEVICES_DB_SIZE    (0x50)
void connectib_i2c_devices_db_dump(const struct connectib_i2c_devices_db *ptr_struct, FILE* file);
/* module_config */
void connectib_module_config_pack(const struct connectib_module_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_module_config_unpack(struct connectib_module_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_module_config_print(const struct connectib_module_config *ptr_struct, FILE* file, int indent_level);
int connectib_module_config_size(void);
#define CONNECTIB_MODULE_CONFIG_SIZE    (0x8)
void connectib_module_config_dump(const struct connectib_module_config *ptr_struct, FILE* file);
/* thermal_config_golan */
void connectib_thermal_config_golan_pack(const struct connectib_thermal_config_golan *ptr_struct, u_int8_t* ptr_buff);
void connectib_thermal_config_golan_unpack(struct connectib_thermal_config_golan *ptr_struct, const u_int8_t* ptr_buff);
void connectib_thermal_config_golan_print(const struct connectib_thermal_config_golan *ptr_struct, FILE* file, int indent_level);
int connectib_thermal_config_golan_size(void);
#define CONNECTIB_THERMAL_CONFIG_GOLAN_SIZE    (0x8)
void connectib_thermal_config_golan_dump(const struct connectib_thermal_config_golan *ptr_struct, FILE* file);
/* system_mng */
void connectib_system_mng_pack(const struct connectib_system_mng *ptr_struct, u_int8_t* ptr_buff);
void connectib_system_mng_unpack(struct connectib_system_mng *ptr_struct, const u_int8_t* ptr_buff);
void connectib_system_mng_print(const struct connectib_system_mng *ptr_struct, FILE* file, int indent_level);
int connectib_system_mng_size(void);
#define CONNECTIB_SYSTEM_MNG_SIZE    (0x4)
void connectib_system_mng_dump(const struct connectib_system_mng *ptr_struct, FILE* file);
/* power */
void connectib_power_pack(const struct connectib_power *ptr_struct, u_int8_t* ptr_buff);
void connectib_power_unpack(struct connectib_power *ptr_struct, const u_int8_t* ptr_buff);
void connectib_power_print(const struct connectib_power *ptr_struct, FILE* file, int indent_level);
int connectib_power_size(void);
#define CONNECTIB_POWER_SIZE    (0x10)
void connectib_power_dump(const struct connectib_power *ptr_struct, FILE* file);
/* port_serdes */
void connectib_port_serdes_pack(const struct connectib_port_serdes *ptr_struct, u_int8_t* ptr_buff);
void connectib_port_serdes_unpack(struct connectib_port_serdes *ptr_struct, const u_int8_t* ptr_buff);
void connectib_port_serdes_print(const struct connectib_port_serdes *ptr_struct, FILE* file, int indent_level);
int connectib_port_serdes_size(void);
#define CONNECTIB_PORT_SERDES_SIZE    (0x700)
void connectib_port_serdes_dump(const struct connectib_port_serdes *ptr_struct, FILE* file);
/* nv_config_boot */
void connectib_nv_config_boot_pack(const struct connectib_nv_config_boot *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_boot_unpack(struct connectib_nv_config_boot *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_boot_print(const struct connectib_nv_config_boot *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_boot_size(void);
#define CONNECTIB_NV_CONFIG_BOOT_SIZE    (0x40)
void connectib_nv_config_boot_dump(const struct connectib_nv_config_boot *ptr_struct, FILE* file);
/* pcie_power_management */
void connectib_pcie_power_management_pack(const struct connectib_pcie_power_management *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_power_management_unpack(struct connectib_pcie_power_management *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_power_management_print(const struct connectib_pcie_power_management *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_power_management_size(void);
#define CONNECTIB_PCIE_POWER_MANAGEMENT_SIZE    (0x4)
void connectib_pcie_power_management_dump(const struct connectib_pcie_power_management *ptr_struct, FILE* file);
/* pci_cfg */
void connectib_pci_cfg_pack(const struct connectib_pci_cfg *ptr_struct, u_int8_t* ptr_buff);
void connectib_pci_cfg_unpack(struct connectib_pci_cfg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pci_cfg_print(const struct connectib_pci_cfg *ptr_struct, FILE* file, int indent_level);
int connectib_pci_cfg_size(void);
#define CONNECTIB_PCI_CFG_SIZE    (0x200)
void connectib_pci_cfg_dump(const struct connectib_pci_cfg *ptr_struct, FILE* file);
/* pcie_transaction */
void connectib_pcie_transaction_pack(const struct connectib_pcie_transaction *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_transaction_unpack(struct connectib_pcie_transaction *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_transaction_print(const struct connectib_pcie_transaction *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_transaction_size(void);
#define CONNECTIB_PCIE_TRANSACTION_SIZE    (0x4)
void connectib_pcie_transaction_dump(const struct connectib_pcie_transaction *ptr_struct, FILE* file);
/* multi_function */
void connectib_multi_function_pack(const struct connectib_multi_function *ptr_struct, u_int8_t* ptr_buff);
void connectib_multi_function_unpack(struct connectib_multi_function *ptr_struct, const u_int8_t* ptr_buff);
void connectib_multi_function_print(const struct connectib_multi_function *ptr_struct, FILE* file, int indent_level);
int connectib_multi_function_size(void);
#define CONNECTIB_MULTI_FUNCTION_SIZE    (0xc)
void connectib_multi_function_dump(const struct connectib_multi_function *ptr_struct, FILE* file);
/* nv_config_main */
void connectib_nv_config_main_pack(const struct connectib_nv_config_main *ptr_struct, u_int8_t* ptr_buff);
void connectib_nv_config_main_unpack(struct connectib_nv_config_main *ptr_struct, const u_int8_t* ptr_buff);
void connectib_nv_config_main_print(const struct connectib_nv_config_main *ptr_struct, FILE* file, int indent_level);
int connectib_nv_config_main_size(void);
#define CONNECTIB_NV_CONFIG_MAIN_SIZE    (0x100)
void connectib_nv_config_main_dump(const struct connectib_nv_config_main *ptr_struct, FILE* file);
/* phy_fw_main_config */
void connectib_phy_fw_main_config_pack(const struct connectib_phy_fw_main_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_unpack(struct connectib_phy_fw_main_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_phy_fw_main_config_print(const struct connectib_phy_fw_main_config *ptr_struct, FILE* file, int indent_level);
int connectib_phy_fw_main_config_size(void);
#define CONNECTIB_PHY_FW_MAIN_CONFIG_SIZE    (0x2b0)
void connectib_phy_fw_main_config_dump(const struct connectib_phy_fw_main_config *ptr_struct, FILE* file);
/* host_management */
void connectib_host_management_pack(const struct connectib_host_management *ptr_struct, u_int8_t* ptr_buff);
void connectib_host_management_unpack(struct connectib_host_management *ptr_struct, const u_int8_t* ptr_buff);
void connectib_host_management_print(const struct connectib_host_management *ptr_struct, FILE* file, int indent_level);
int connectib_host_management_size(void);
#define CONNECTIB_HOST_MANAGEMENT_SIZE    (0x4c)
void connectib_host_management_dump(const struct connectib_host_management *ptr_struct, FILE* file);
/* management */
void connectib_management_pack(const struct connectib_management *ptr_struct, u_int8_t* ptr_buff);
void connectib_management_unpack(struct connectib_management *ptr_struct, const u_int8_t* ptr_buff);
void connectib_management_print(const struct connectib_management *ptr_struct, FILE* file, int indent_level);
int connectib_management_size(void);
#define CONNECTIB_MANAGEMENT_SIZE    (0x100)
void connectib_management_dump(const struct connectib_management *ptr_struct, FILE* file);
/* customization */
void connectib_customization_pack(const struct connectib_customization *ptr_struct, u_int8_t* ptr_buff);
void connectib_customization_unpack(struct connectib_customization *ptr_struct, const u_int8_t* ptr_buff);
void connectib_customization_print(const struct connectib_customization *ptr_struct, FILE* file, int indent_level);
int connectib_customization_size(void);
#define CONNECTIB_CUSTOMIZATION_SIZE    (0x40)
void connectib_customization_dump(const struct connectib_customization *ptr_struct, FILE* file);
/* leds_blink_patterns */
void connectib_leds_blink_patterns_pack(const struct connectib_leds_blink_patterns *ptr_struct, u_int8_t* ptr_buff);
void connectib_leds_blink_patterns_unpack(struct connectib_leds_blink_patterns *ptr_struct, const u_int8_t* ptr_buff);
void connectib_leds_blink_patterns_print(const struct connectib_leds_blink_patterns *ptr_struct, FILE* file, int indent_level);
int connectib_leds_blink_patterns_size(void);
#define CONNECTIB_LEDS_BLINK_PATTERNS_SIZE    (0xa0)
void connectib_leds_blink_patterns_dump(const struct connectib_leds_blink_patterns *ptr_struct, FILE* file);
/* static_config */
void connectib_static_config_pack(const struct connectib_static_config *ptr_struct, u_int8_t* ptr_buff);
void connectib_static_config_unpack(struct connectib_static_config *ptr_struct, const u_int8_t* ptr_buff);
void connectib_static_config_print(const struct connectib_static_config *ptr_struct, FILE* file, int indent_level);
int connectib_static_config_size(void);
#define CONNECTIB_STATIC_CONFIG_SIZE    (0x10)
void connectib_static_config_dump(const struct connectib_static_config *ptr_struct, FILE* file);
/* guids */
void connectib_guids_pack(const struct connectib_guids *ptr_struct, u_int8_t* ptr_buff);
void connectib_guids_unpack(struct connectib_guids *ptr_struct, const u_int8_t* ptr_buff);
void connectib_guids_print(const struct connectib_guids *ptr_struct, FILE* file, int indent_level);
int connectib_guids_size(void);
#define CONNECTIB_GUIDS_SIZE    (0x40)
void connectib_guids_dump(const struct connectib_guids *ptr_struct, FILE* file);
/* module_versions */
void connectib_module_versions_pack(const struct connectib_module_versions *ptr_struct, u_int8_t* ptr_buff);
void connectib_module_versions_unpack(struct connectib_module_versions *ptr_struct, const u_int8_t* ptr_buff);
void connectib_module_versions_print(const struct connectib_module_versions *ptr_struct, FILE* file, int indent_level);
int connectib_module_versions_size(void);
#define CONNECTIB_MODULE_VERSIONS_SIZE    (0x40)
void connectib_module_versions_dump(const struct connectib_module_versions *ptr_struct, FILE* file);
/* image_size */
void connectib_image_size_pack(const struct connectib_image_size *ptr_struct, u_int8_t* ptr_buff);
void connectib_image_size_unpack(struct connectib_image_size *ptr_struct, const u_int8_t* ptr_buff);
void connectib_image_size_print(const struct connectib_image_size *ptr_struct, FILE* file, int indent_level);
int connectib_image_size_size(void);
#define CONNECTIB_IMAGE_SIZE_SIZE    (0x8)
void connectib_image_size_dump(const struct connectib_image_size *ptr_struct, FILE* file);
/* TRIPPLE_VERSION */
void connectib_TRIPPLE_VERSION_pack(const struct connectib_TRIPPLE_VERSION *ptr_struct, u_int8_t* ptr_buff);
void connectib_TRIPPLE_VERSION_unpack(struct connectib_TRIPPLE_VERSION *ptr_struct, const u_int8_t* ptr_buff);
void connectib_TRIPPLE_VERSION_print(const struct connectib_TRIPPLE_VERSION *ptr_struct, FILE* file, int indent_level);
int connectib_TRIPPLE_VERSION_size(void);
#define CONNECTIB_TRIPPLE_VERSION_SIZE    (0x8)
void connectib_TRIPPLE_VERSION_dump(const struct connectib_TRIPPLE_VERSION *ptr_struct, FILE* file);
/* operation_key */
void connectib_operation_key_pack(const struct connectib_operation_key *ptr_struct, u_int8_t* ptr_buff);
void connectib_operation_key_unpack(struct connectib_operation_key *ptr_struct, const u_int8_t* ptr_buff);
void connectib_operation_key_print(const struct connectib_operation_key *ptr_struct, FILE* file, int indent_level);
int connectib_operation_key_size(void);
#define CONNECTIB_OPERATION_KEY_SIZE    (0x10)
void connectib_operation_key_dump(const struct connectib_operation_key *ptr_struct, FILE* file);
/* toc_data */
void connectib_toc_data_pack(const struct connectib_toc_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_toc_data_unpack(struct connectib_toc_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_toc_data_print(const struct connectib_toc_data *ptr_struct, FILE* file, int indent_level);
int connectib_toc_data_size(void);
#define CONNECTIB_TOC_DATA_SIZE    (0x8)
void connectib_toc_data_dump(const struct connectib_toc_data *ptr_struct, FILE* file);
/* rst_api_ver */
void connectib_rst_api_ver_pack(const struct connectib_rst_api_ver *ptr_struct, u_int8_t* ptr_buff);
void connectib_rst_api_ver_unpack(struct connectib_rst_api_ver *ptr_struct, const u_int8_t* ptr_buff);
void connectib_rst_api_ver_print(const struct connectib_rst_api_ver *ptr_struct, FILE* file, int indent_level);
int connectib_rst_api_ver_size(void);
#define CONNECTIB_RST_API_VER_SIZE    (0x80)
void connectib_rst_api_ver_dump(const struct connectib_rst_api_ver *ptr_struct, FILE* file);
/* reset_capabilities */
void connectib_reset_capabilities_pack(const struct connectib_reset_capabilities *ptr_struct, u_int8_t* ptr_buff);
void connectib_reset_capabilities_unpack(struct connectib_reset_capabilities *ptr_struct, const u_int8_t* ptr_buff);
void connectib_reset_capabilities_print(const struct connectib_reset_capabilities *ptr_struct, FILE* file, int indent_level);
int connectib_reset_capabilities_size(void);
#define CONNECTIB_RESET_CAPABILITIES_SIZE    (0x4)
void connectib_reset_capabilities_dump(const struct connectib_reset_capabilities *ptr_struct, FILE* file);
/* icmd_get_pf_ctx */
void connectib_icmd_get_pf_ctx_pack(const struct connectib_icmd_get_pf_ctx *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_pf_ctx_unpack(struct connectib_icmd_get_pf_ctx *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_pf_ctx_print(const struct connectib_icmd_get_pf_ctx *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_pf_ctx_size(void);
#define CONNECTIB_ICMD_GET_PF_CTX_SIZE    (0x60)
void connectib_icmd_get_pf_ctx_dump(const struct connectib_icmd_get_pf_ctx *ptr_struct, FILE* file);
/* icmd_gen_assert */
void connectib_icmd_gen_assert_pack(const struct connectib_icmd_gen_assert *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_gen_assert_unpack(struct connectib_icmd_gen_assert *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_gen_assert_print(const struct connectib_icmd_gen_assert *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_gen_assert_size(void);
#define CONNECTIB_ICMD_GEN_ASSERT_SIZE    (0x4)
void connectib_icmd_gen_assert_dump(const struct connectib_icmd_gen_assert *ptr_struct, FILE* file);
/* icmd_general_fault_injector */
void connectib_icmd_general_fault_injector_pack(const struct connectib_icmd_general_fault_injector *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_general_fault_injector_unpack(struct connectib_icmd_general_fault_injector *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_general_fault_injector_print(const struct connectib_icmd_general_fault_injector *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_general_fault_injector_size(void);
#define CONNECTIB_ICMD_GENERAL_FAULT_INJECTOR_SIZE    (0x8)
void connectib_icmd_general_fault_injector_dump(const struct connectib_icmd_general_fault_injector *ptr_struct, FILE* file);
/* icmd_access_register_pvlc */
void connectib_icmd_access_register_pvlc_pack(const struct connectib_icmd_access_register_pvlc *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_pvlc_unpack(struct connectib_icmd_access_register_pvlc *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_pvlc_print(const struct connectib_icmd_access_register_pvlc *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_pvlc_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PVLC_SIZE    (0x14)
void connectib_icmd_access_register_pvlc_dump(const struct connectib_icmd_access_register_pvlc *ptr_struct, FILE* file);
/* icmd_read_ste */
void connectib_icmd_read_ste_pack(const struct connectib_icmd_read_ste *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_read_ste_unpack(struct connectib_icmd_read_ste *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_read_ste_print(const struct connectib_icmd_read_ste *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_read_ste_size(void);
#define CONNECTIB_ICMD_READ_STE_SIZE    (0x50)
void connectib_icmd_read_ste_dump(const struct connectib_icmd_read_ste *ptr_struct, FILE* file);
/* icmd_get_ste_resources_list */
void connectib_icmd_get_ste_resources_list_pack(const union connectib_icmd_get_ste_resources_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_unpack(union connectib_icmd_get_ste_resources_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_resources_list_print(const union connectib_icmd_get_ste_resources_list *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_resources_list_size(void);
#define CONNECTIB_ICMD_GET_STE_RESOURCES_LIST_SIZE    (0x100)
void connectib_icmd_get_ste_resources_list_dump(const union connectib_icmd_get_ste_resources_list *ptr_struct, FILE* file);
/* icmd_get_ste_open_resources */
void connectib_icmd_get_ste_open_resources_pack(const union connectib_icmd_get_ste_open_resources *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_unpack(union connectib_icmd_get_ste_open_resources *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ste_open_resources_print(const union connectib_icmd_get_ste_open_resources *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ste_open_resources_size(void);
#define CONNECTIB_ICMD_GET_STE_OPEN_RESOURCES_SIZE    (0x300)
void connectib_icmd_get_ste_open_resources_dump(const union connectib_icmd_get_ste_open_resources *ptr_struct, FILE* file);
/* icmd_get_fte */
void connectib_icmd_get_fte_pack(const union connectib_icmd_get_fte *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_unpack(union connectib_icmd_get_fte *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_print(const union connectib_icmd_get_fte *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_size(void);
#define CONNECTIB_ICMD_GET_FTE_SIZE    (0x300)
void connectib_icmd_get_fte_dump(const union connectib_icmd_get_fte *ptr_struct, FILE* file);
/* icmd_get_fte_list */
void connectib_icmd_get_fte_list_pack(const union connectib_icmd_get_fte_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_unpack(union connectib_icmd_get_fte_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fte_list_print(const union connectib_icmd_get_fte_list *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fte_list_size(void);
#define CONNECTIB_ICMD_GET_FTE_LIST_SIZE    (0x10)
void connectib_icmd_get_fte_list_dump(const union connectib_icmd_get_fte_list *ptr_struct, FILE* file);
/* icmd_get_fg */
void connectib_icmd_get_fg_pack(const union connectib_icmd_get_fg *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_unpack(union connectib_icmd_get_fg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_print(const union connectib_icmd_get_fg *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_size(void);
#define CONNECTIB_ICMD_GET_FG_SIZE    (0x100)
void connectib_icmd_get_fg_dump(const union connectib_icmd_get_fg *ptr_struct, FILE* file);
/* icmd_get_fg_list */
void connectib_icmd_get_fg_list_pack(const union connectib_icmd_get_fg_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_unpack(union connectib_icmd_get_fg_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_fg_list_print(const union connectib_icmd_get_fg_list *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_fg_list_size(void);
#define CONNECTIB_ICMD_GET_FG_LIST_SIZE    (0x10)
void connectib_icmd_get_fg_list_dump(const union connectib_icmd_get_fg_list *ptr_struct, FILE* file);
/* icmd_get_ft_info */
void connectib_icmd_get_ft_info_pack(const union connectib_icmd_get_ft_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_unpack(union connectib_icmd_get_ft_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_info_print(const union connectib_icmd_get_ft_info *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_info_size(void);
#define CONNECTIB_ICMD_GET_FT_INFO_SIZE    (0x10)
void connectib_icmd_get_ft_info_dump(const union connectib_icmd_get_ft_info *ptr_struct, FILE* file);
/* icmd_get_ft_list */
void connectib_icmd_get_ft_list_pack(const union connectib_icmd_get_ft_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_unpack(union connectib_icmd_get_ft_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_ft_list_print(const union connectib_icmd_get_ft_list *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_ft_list_size(void);
#define CONNECTIB_ICMD_GET_FT_LIST_SIZE    (0x10)
void connectib_icmd_get_ft_list_dump(const union connectib_icmd_get_ft_list *ptr_struct, FILE* file);
/* icmd_set_get_port_cntr */
void connectib_icmd_set_get_port_cntr_pack(const struct connectib_icmd_set_get_port_cntr *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_set_get_port_cntr_unpack(struct connectib_icmd_set_get_port_cntr *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_set_get_port_cntr_print(const struct connectib_icmd_set_get_port_cntr *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_set_get_port_cntr_size(void);
#define CONNECTIB_ICMD_SET_GET_PORT_CNTR_SIZE    (0x18)
void connectib_icmd_set_get_port_cntr_dump(const struct connectib_icmd_set_get_port_cntr *ptr_struct, FILE* file);
/* icmd_access_register_ppcnt */
void connectib_icmd_access_register_ppcnt_pack(const struct connectib_icmd_access_register_ppcnt *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_ppcnt_unpack(struct connectib_icmd_access_register_ppcnt *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_ppcnt_print(const struct connectib_icmd_access_register_ppcnt *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_ppcnt_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PPCNT_SIZE    (0x10c)
void connectib_icmd_access_register_ppcnt_dump(const struct connectib_icmd_access_register_ppcnt *ptr_struct, FILE* file);
/* icmd_access_reg_ptys */
void connectib_icmd_access_reg_ptys_pack(const struct connectib_icmd_access_reg_ptys *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_reg_ptys_unpack(struct connectib_icmd_access_reg_ptys *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_reg_ptys_print(const struct connectib_icmd_access_reg_ptys *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_reg_ptys_size(void);
#define CONNECTIB_ICMD_ACCESS_REG_PTYS_SIZE    (0x44)
void connectib_icmd_access_reg_ptys_dump(const struct connectib_icmd_access_reg_ptys *ptr_struct, FILE* file);
/* icmd_access_register_pmtu */
void connectib_icmd_access_register_pmtu_pack(const struct connectib_icmd_access_register_pmtu *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_pmtu_unpack(struct connectib_icmd_access_register_pmtu *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_pmtu_print(const struct connectib_icmd_access_register_pmtu *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_pmtu_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PMTU_SIZE    (0x14)
void connectib_icmd_access_register_pmtu_dump(const struct connectib_icmd_access_register_pmtu *ptr_struct, FILE* file);
/* icmd_access_register_ppamp */
void connectib_icmd_access_register_ppamp_pack(const struct connectib_icmd_access_register_ppamp *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_ppamp_unpack(struct connectib_icmd_access_register_ppamp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_ppamp_print(const struct connectib_icmd_access_register_ppamp *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_ppamp_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PPAMP_SIZE    (0x30)
void connectib_icmd_access_register_ppamp_dump(const struct connectib_icmd_access_register_ppamp *ptr_struct, FILE* file);
/* icmd_access_register_ptas */
void connectib_icmd_access_register_ptas_pack(const struct connectib_icmd_access_register_ptas *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_ptas_unpack(struct connectib_icmd_access_register_ptas *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_ptas_print(const struct connectib_icmd_access_register_ptas *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_ptas_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PTAS_SIZE    (0x30)
void connectib_icmd_access_register_ptas_dump(const struct connectib_icmd_access_register_ptas *ptr_struct, FILE* file);
/* icmd_access_register_slrg */
void connectib_icmd_access_register_slrg_pack(const struct connectib_icmd_access_register_slrg *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_slrg_unpack(struct connectib_icmd_access_register_slrg *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_slrg_print(const struct connectib_icmd_access_register_slrg *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_slrg_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_SLRG_SIZE    (0x2c)
void connectib_icmd_access_register_slrg_dump(const struct connectib_icmd_access_register_slrg *ptr_struct, FILE* file);
/* icmd_access_register_sltp */
void connectib_icmd_access_register_sltp_pack(const struct connectib_icmd_access_register_sltp *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_sltp_unpack(struct connectib_icmd_access_register_sltp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_sltp_print(const struct connectib_icmd_access_register_sltp *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_sltp_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_SLTP_SIZE    (0x18)
void connectib_icmd_access_register_sltp_dump(const struct connectib_icmd_access_register_sltp *ptr_struct, FILE* file);
/* icmd_access_register_slrp */
void connectib_icmd_access_register_slrp_pack(const struct connectib_icmd_access_register_slrp *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_slrp_unpack(struct connectib_icmd_access_register_slrp *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_slrp_print(const struct connectib_icmd_access_register_slrp *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_slrp_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_SLRP_SIZE    (0x30)
void connectib_icmd_access_register_slrp_dump(const struct connectib_icmd_access_register_slrp *ptr_struct, FILE* file);
/* icmd_access_register_paos */
void connectib_icmd_access_register_paos_pack(const struct connectib_icmd_access_register_paos *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_register_paos_unpack(struct connectib_icmd_access_register_paos *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_register_paos_print(const struct connectib_icmd_access_register_paos *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_register_paos_size(void);
#define CONNECTIB_ICMD_ACCESS_REGISTER_PAOS_SIZE    (0x14)
void connectib_icmd_access_register_paos_dump(const struct connectib_icmd_access_register_paos *ptr_struct, FILE* file);
/* icmd_get_gvmi_via_vsec */
void connectib_icmd_get_gvmi_via_vsec_pack(const struct connectib_icmd_get_gvmi_via_vsec *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_get_gvmi_via_vsec_unpack(struct connectib_icmd_get_gvmi_via_vsec *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_get_gvmi_via_vsec_print(const struct connectib_icmd_get_gvmi_via_vsec *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_get_gvmi_via_vsec_size(void);
#define CONNECTIB_ICMD_GET_GVMI_VIA_VSEC_SIZE    (0x10)
void connectib_icmd_get_gvmi_via_vsec_dump(const struct connectib_icmd_get_gvmi_via_vsec *ptr_struct, FILE* file);
/* icmd_steering_table_info */
void connectib_icmd_steering_table_info_pack(const struct connectib_icmd_steering_table_info *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_steering_table_info_unpack(struct connectib_icmd_steering_table_info *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_steering_table_info_print(const struct connectib_icmd_steering_table_info *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_steering_table_info_size(void);
#define CONNECTIB_ICMD_STEERING_TABLE_INFO_SIZE    (0x30)
void connectib_icmd_steering_table_info_dump(const struct connectib_icmd_steering_table_info *ptr_struct, FILE* file);
/* icmd_access_steering_root */
void connectib_icmd_access_steering_root_pack(const struct connectib_icmd_access_steering_root *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_access_steering_root_unpack(struct connectib_icmd_access_steering_root *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_access_steering_root_print(const struct connectib_icmd_access_steering_root *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_access_steering_root_size(void);
#define CONNECTIB_ICMD_ACCESS_STEERING_ROOT_SIZE    (0x44)
void connectib_icmd_access_steering_root_dump(const struct connectib_icmd_access_steering_root *ptr_struct, FILE* file);
/* icmd_dcr_ll_next_dcr_list */
void connectib_icmd_dcr_ll_next_dcr_list_pack(const struct connectib_icmd_dcr_ll_next_dcr_list *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_dcr_ll_next_dcr_list_unpack(struct connectib_icmd_dcr_ll_next_dcr_list *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_dcr_ll_next_dcr_list_print(const struct connectib_icmd_dcr_ll_next_dcr_list *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_dcr_ll_next_dcr_list_size(void);
#define CONNECTIB_ICMD_DCR_LL_NEXT_DCR_LIST_SIZE    (0x300)
void connectib_icmd_dcr_ll_next_dcr_list_dump(const struct connectib_icmd_dcr_ll_next_dcr_list *ptr_struct, FILE* file);
/* icmd_dcr_ll_trvrs */
void connectib_icmd_dcr_ll_trvrs_pack(const struct connectib_icmd_dcr_ll_trvrs *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_dcr_ll_trvrs_unpack(struct connectib_icmd_dcr_ll_trvrs *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_dcr_ll_trvrs_print(const struct connectib_icmd_dcr_ll_trvrs *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_dcr_ll_trvrs_size(void);
#define CONNECTIB_ICMD_DCR_LL_TRVRS_SIZE    (0x10)
void connectib_icmd_dcr_ll_trvrs_dump(const struct connectib_icmd_dcr_ll_trvrs *ptr_struct, FILE* file);
/* icmd_flr_debug */
void connectib_icmd_flr_debug_pack(const struct connectib_icmd_flr_debug *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_flr_debug_unpack(struct connectib_icmd_flr_debug *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_flr_debug_print(const struct connectib_icmd_flr_debug *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_flr_debug_size(void);
#define CONNECTIB_ICMD_FLR_DEBUG_SIZE    (0x20)
void connectib_icmd_flr_debug_dump(const struct connectib_icmd_flr_debug *ptr_struct, FILE* file);
/* icmd_push_db */
void connectib_icmd_push_db_pack(const struct connectib_icmd_push_db *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_push_db_unpack(struct connectib_icmd_push_db *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_push_db_print(const struct connectib_icmd_push_db *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_push_db_size(void);
#define CONNECTIB_ICMD_PUSH_DB_SIZE    (0x8)
void connectib_icmd_push_db_dump(const struct connectib_icmd_push_db *ptr_struct, FILE* file);
/* icmd_pcie_ver_data */
void connectib_icmd_pcie_ver_data_pack(const struct connectib_icmd_pcie_ver_data *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_data_unpack(struct connectib_icmd_pcie_ver_data *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_pcie_ver_data_print(const struct connectib_icmd_pcie_ver_data *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_pcie_ver_data_size(void);
#define CONNECTIB_ICMD_PCIE_VER_DATA_SIZE    (0x40)
void connectib_icmd_pcie_ver_data_dump(const struct connectib_icmd_pcie_ver_data *ptr_struct, FILE* file);
/* icmd_stress_testing */
void connectib_icmd_stress_testing_pack(const struct connectib_icmd_stress_testing *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_stress_testing_unpack(struct connectib_icmd_stress_testing *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_stress_testing_print(const struct connectib_icmd_stress_testing *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_stress_testing_size(void);
#define CONNECTIB_ICMD_STRESS_TESTING_SIZE    (0x100)
void connectib_icmd_stress_testing_dump(const struct connectib_icmd_stress_testing *ptr_struct, FILE* file);
/* icmd_stop_toggler */
void connectib_icmd_stop_toggler_pack(const struct connectib_icmd_stop_toggler *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_stop_toggler_unpack(struct connectib_icmd_stop_toggler *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_stop_toggler_print(const struct connectib_icmd_stop_toggler *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_stop_toggler_size(void);
#define CONNECTIB_ICMD_STOP_TOGGLER_SIZE    (0x100)
void connectib_icmd_stop_toggler_dump(const struct connectib_icmd_stop_toggler *ptr_struct, FILE* file);
/* icmd_code_coverage_read */
void connectib_icmd_code_coverage_read_pack(const struct connectib_icmd_code_coverage_read *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_code_coverage_read_unpack(struct connectib_icmd_code_coverage_read *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_code_coverage_read_print(const struct connectib_icmd_code_coverage_read *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_code_coverage_read_size(void);
#define CONNECTIB_ICMD_CODE_COVERAGE_READ_SIZE    (0x108)
void connectib_icmd_code_coverage_read_dump(const struct connectib_icmd_code_coverage_read *ptr_struct, FILE* file);
/* icmd_code_coverage_control */
void connectib_icmd_code_coverage_control_pack(const struct connectib_icmd_code_coverage_control *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_code_coverage_control_unpack(struct connectib_icmd_code_coverage_control *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_code_coverage_control_print(const struct connectib_icmd_code_coverage_control *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_code_coverage_control_size(void);
#define CONNECTIB_ICMD_CODE_COVERAGE_CONTROL_SIZE    (0x10)
void connectib_icmd_code_coverage_control_dump(const struct connectib_icmd_code_coverage_control *ptr_struct, FILE* file);
/* icmd_esw */
void connectib_icmd_esw_pack(const struct connectib_icmd_esw *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_esw_unpack(struct connectib_icmd_esw *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_esw_print(const struct connectib_icmd_esw *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_esw_size(void);
#define CONNECTIB_ICMD_ESW_SIZE    (0x300)
void connectib_icmd_esw_dump(const struct connectib_icmd_esw *ptr_struct, FILE* file);
/* icmd_rw_gvmix */
void connectib_icmd_rw_gvmix_pack(const struct connectib_icmd_rw_gvmix *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_rw_gvmix_unpack(struct connectib_icmd_rw_gvmix *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_rw_gvmix_print(const struct connectib_icmd_rw_gvmix *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_rw_gvmix_size(void);
#define CONNECTIB_ICMD_RW_GVMIX_SIZE    (0x80)
void connectib_icmd_rw_gvmix_dump(const struct connectib_icmd_rw_gvmix *ptr_struct, FILE* file);
/* icmd_gen_eqe */
void connectib_icmd_gen_eqe_pack(const struct connectib_icmd_gen_eqe *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_gen_eqe_unpack(struct connectib_icmd_gen_eqe *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_gen_eqe_print(const struct connectib_icmd_gen_eqe *ptr_struct, FILE* file, int indent_level);
int connectib_icmd_gen_eqe_size(void);
#define CONNECTIB_ICMD_GEN_EQE_SIZE    (0x50)
void connectib_icmd_gen_eqe_dump(const struct connectib_icmd_gen_eqe *ptr_struct, FILE* file);
/* pcie_tools_pointers */
void connectib_pcie_tools_pointers_pack(const struct connectib_pcie_tools_pointers *ptr_struct, u_int8_t* ptr_buff);
void connectib_pcie_tools_pointers_unpack(struct connectib_pcie_tools_pointers *ptr_struct, const u_int8_t* ptr_buff);
void connectib_pcie_tools_pointers_print(const struct connectib_pcie_tools_pointers *ptr_struct, FILE* file, int indent_level);
int connectib_pcie_tools_pointers_size(void);
#define CONNECTIB_PCIE_TOOLS_POINTERS_SIZE    (0x40)
void connectib_pcie_tools_pointers_dump(const struct connectib_pcie_tools_pointers *ptr_struct, FILE* file);
/* icmd_phy_ver_overwrite */
void connectib_icmd_phy_ver_overwrite_pack(const struct connectib_icmd_phy_ver_overwrite *ptr_struct, u_int8_t* ptr_buff);
void connectib_icmd_phy_ver_overwrite_unpack(struct connectib_icmd_phy_ver_overwrite *ptr_struct, const u_int8_t* ptr_buff);
void connectib_icmd_phy_ver_overwrite_print(const struct connectib_icmd_phy_ver_overwrite *ptr_struct, FILE* file, int indent_level);
int con