/*
 * Copyright (C) Jan 2013 Mellanox Technologies Ltd. All rights reserved.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/***
 *** This file was generated at "2015-06-17 12:05:31"
 *** by:
 ***    > /mswg/release/eat_me/last_release/adabe_plugins/adb2c/adb2pack.py --input adb/connectib/connectib.adb --file-prefix connectib --prefix connectib_
 ***/
#include "connectib_layouts.h"

void connectib_dw_pack(const struct connectib_dw *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dw);

}

void connectib_dw_unpack(struct connectib_dw *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dw = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dw_print(const struct connectib_dw *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dw ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dw                   : "U32H_FMT"\n", ptr_struct->dw);

}

int connectib_dw_size(void){
	 return 4;
}

void connectib_dw_dump(const struct connectib_dw *ptr_struct, FILE* file) {
	connectib_dw_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_nvlog_pack(const struct connectib_nv_tlv_type_nvlog *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sub_class);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_nvlog_unpack(struct connectib_nv_tlv_type_nvlog *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=8;
	ptr_struct->sub_class = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_nvlog_print(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_nvlog ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sub_class            : "UH_FMT"\n", ptr_struct->sub_class);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_nvlog_size(void){
	 return 4;
}

void connectib_nv_tlv_type_nvlog_dump(const struct connectib_nv_tlv_type_nvlog *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_nvlog_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_eswitch_pack(const struct connectib_nv_tlv_type_eswitch *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->port);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_eswitch_unpack(struct connectib_nv_tlv_type_eswitch *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=14;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_eswitch_print(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_eswitch ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : "UH_FMT"\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : "UH_FMT"\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_eswitch_size(void){
	 return 4;
}

void connectib_nv_tlv_type_eswitch_dump(const struct connectib_nv_tlv_type_eswitch *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_eswitch_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_per_host_pack(const struct connectib_nv_tlv_type_per_host *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->parameter_index);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->function);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_per_host_unpack(struct connectib_nv_tlv_type_per_host *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=22;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=14;
	ptr_struct->function = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_per_host_print(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_per_host ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "function             : "UH_FMT"\n", ptr_struct->function);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : "UH_FMT"\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_per_host_size(void){
	 return 4;
}

void connectib_nv_tlv_type_per_host_dump(const struct connectib_nv_tlv_type_per_host *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_per_host_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_bmc_pack(const struct connectib_nv_tlv_type_bmc *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 13, (u_int32_t)ptr_struct->parameter_index);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->channel);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->host);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_bmc_unpack(struct connectib_nv_tlv_type_bmc *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=19;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 13);

	offset=14;
	ptr_struct->channel = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=8;
	ptr_struct->host = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_bmc_print(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_bmc ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "channel              : "UH_FMT"\n", ptr_struct->channel);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "host                 : "UH_FMT"\n", ptr_struct->host);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_bmc_size(void){
	 return 4;
}

void connectib_nv_tlv_type_bmc_dump(const struct connectib_nv_tlv_type_bmc *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_bmc_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_physical_port_pack(const struct connectib_nv_tlv_type_physical_port *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->parameter_index);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_physical_port_unpack(struct connectib_nv_tlv_type_physical_port *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->parameter_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=8;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_physical_port_print(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_physical_port ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : "UH_FMT"\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_physical_port_size(void){
	 return 4;
}

void connectib_nv_tlv_type_physical_port_dump(const struct connectib_nv_tlv_type_physical_port *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_physical_port_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_global_pack(const struct connectib_nv_tlv_type_global *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->parameter_index);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->class_);

}

void connectib_nv_tlv_type_global_unpack(struct connectib_nv_tlv_type_global *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->parameter_index = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=0;
	ptr_struct->class_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_nv_tlv_type_global_print(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type_global ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "parameter_index      : "UH_FMT"\n", ptr_struct->parameter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "class_               : "UH_FMT"\n", ptr_struct->class_);

}

int connectib_nv_tlv_type_global_size(void){
	 return 4;
}

void connectib_nv_tlv_type_global_dump(const struct connectib_nv_tlv_type_global *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_global_print(ptr_struct, file, 0);
}

void connectib_uint64_pack(const struct connectib_uint64 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hi);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->lo);

}

void connectib_uint64_unpack(struct connectib_uint64 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_uint64_print(const struct connectib_uint64 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_uint64 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hi                   : "U32H_FMT"\n", ptr_struct->hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lo                   : "U32H_FMT"\n", ptr_struct->lo);

}

int connectib_uint64_size(void){
	 return 8;
}

void connectib_uint64_dump(const struct connectib_uint64 *ptr_struct, FILE* file) {
	connectib_uint64_print(ptr_struct, file, 0);
}

void connectib_dcr_qp_pack(const struct connectib_dcr_qp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->gb_first_psn);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->gb_last_psn);

	offset=39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_gb);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->reconnect_ack_psn);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dcr_heartbeat_clr_timestamp);

}

void connectib_dcr_qp_unpack(struct connectib_dcr_qp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->gb_first_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=40;
	ptr_struct->gb_last_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=39;
	ptr_struct->is_gb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=72;
	ptr_struct->reconnect_ack_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->dcr_heartbeat_clr_timestamp = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dcr_qp_print(const struct connectib_dcr_qp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dcr_qp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gb_first_psn         : "UH_FMT"\n", ptr_struct->gb_first_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gb_last_psn          : "UH_FMT"\n", ptr_struct->gb_last_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_gb                : "UH_FMT"\n", ptr_struct->is_gb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reconnect_ack_psn    : "UH_FMT"\n", ptr_struct->reconnect_ack_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_heartbeat_clr_timestamp : "U32H_FMT"\n", ptr_struct->dcr_heartbeat_clr_timestamp);

}

int connectib_dcr_qp_size(void){
	 return 16;
}

void connectib_dcr_qp_dump(const struct connectib_dcr_qp *ptr_struct, FILE* file) {
	connectib_dcr_qp_print(ptr_struct, file, 0);
}

void connectib_regular_qp_pack(const struct connectib_regular_qp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ds_exceeds_pi_retries);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dc_access_key_violation_count_state);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->pm_state);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->req_retrans_is_rdma_read);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invalid_user_index);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->xport_retry_counter);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->xport_retry_limit);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rnr_retry_counter);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rnr_retry_limit);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rq_head_qpn);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cmdif_entry_ix);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dc_access_key_violation_count);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->sw_uar);

}

void connectib_regular_qp_unpack(struct connectib_regular_qp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->ds_exceeds_pi_retries = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=26;
	ptr_struct->dc_access_key_violation_count_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->pm_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=21;
	ptr_struct->req_retrans_is_rdma_read = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->invalid_user_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->xport_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=8;
	ptr_struct->xport_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=4;
	ptr_struct->rnr_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=0;
	ptr_struct->rnr_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=40;
	ptr_struct->rq_head_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=32;
	ptr_struct->cmdif_entry_ix = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->dc_access_key_violation_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=104;
	ptr_struct->sw_uar = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_regular_qp_print(const struct connectib_regular_qp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_regular_qp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ds_exceeds_pi_retries : "UH_FMT"\n", ptr_struct->ds_exceeds_pi_retries);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_violation_count_state : "UH_FMT"\n", ptr_struct->dc_access_key_violation_count_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pm_state             : "UH_FMT"\n", ptr_struct->pm_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "req_retrans_is_rdma_read : "UH_FMT"\n", ptr_struct->req_retrans_is_rdma_read);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invalid_user_index   : "UH_FMT"\n", ptr_struct->invalid_user_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xport_retry_counter  : "UH_FMT"\n", ptr_struct->xport_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xport_retry_limit    : "UH_FMT"\n", ptr_struct->xport_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_retry_counter    : "UH_FMT"\n", ptr_struct->rnr_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_retry_limit      : "UH_FMT"\n", ptr_struct->rnr_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rq_head_qpn          : "UH_FMT"\n", ptr_struct->rq_head_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmdif_entry_ix       : "UH_FMT"\n", ptr_struct->cmdif_entry_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_violation_count : "U32H_FMT"\n", ptr_struct->dc_access_key_violation_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_uar               : "UH_FMT"\n", ptr_struct->sw_uar);

}

int connectib_regular_qp_size(void){
	 return 16;
}

void connectib_regular_qp_dump(const struct connectib_regular_qp *ptr_struct, FILE* file) {
	connectib_regular_qp_print(ptr_struct, file, 0);
}

void connectib_schedint_cause_pack(const struct connectib_schedint_cause *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clear_all_causes);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_destroy_qp);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_qp_flush);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_apm);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_duplicate);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->schedint_ud_sl_diff);

}

void connectib_schedint_cause_unpack(struct connectib_schedint_cause *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	ptr_struct->clear_all_causes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->schedint_destroy_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->schedint_qp_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->schedint_apm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->schedint_duplicate = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->schedint_ud_sl_diff = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_schedint_cause_print(const struct connectib_schedint_cause *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_schedint_cause ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clear_all_causes     : "UH_FMT"\n", ptr_struct->clear_all_causes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_destroy_qp  : "UH_FMT"\n", ptr_struct->schedint_destroy_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_qp_flush    : "UH_FMT"\n", ptr_struct->schedint_qp_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_apm         : "UH_FMT"\n", ptr_struct->schedint_apm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_duplicate   : "UH_FMT"\n", ptr_struct->schedint_duplicate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_ud_sl_diff  : "UH_FMT"\n", ptr_struct->schedint_ud_sl_diff);

}

int connectib_schedint_cause_size(void){
	 return 1;
}

void connectib_schedint_cause_dump(const struct connectib_schedint_cause *ptr_struct, FILE* file) {
	connectib_schedint_cause_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_data0_pack(const struct connectib_hw_msix_context_data0 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->data);

}

void connectib_hw_msix_context_data0_unpack(struct connectib_hw_msix_context_data0 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_msix_context_data0_print(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context_data0 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data                 : "U32H_FMT"\n", ptr_struct->data);

}

int connectib_hw_msix_context_data0_size(void){
	 return 4;
}

void connectib_hw_msix_context_data0_dump(const struct connectib_hw_msix_context_data0 *ptr_struct, FILE* file) {
	connectib_hw_msix_context_data0_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_generic_headers_pack(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->dword_select_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dword_select);

}

void connectib_hw_ste_tag_generic_headers_unpack(struct connectib_hw_ste_tag_generic_headers *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dword_select_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->dword_select = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_generic_headers_print(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_generic_headers ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_select_valid   : "UH_FMT"\n", ptr_struct->dword_select_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_select         : "U32H_FMT"\n", ptr_struct->dword_select);

}

int connectib_hw_ste_tag_generic_headers_size(void){
	 return 16;
}

void connectib_hw_ste_tag_generic_headers_dump(const struct connectib_hw_ste_tag_generic_headers *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_generic_headers_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_port_pack(const struct connectib_hw_ste_tag_port *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->qp_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_sniffer);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_lb);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->func_lb);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->multicast);

}

void connectib_hw_ste_tag_port_unpack(struct connectib_hw_ste_tag_port *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=19;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->bth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->qp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->sx_sniffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->force_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->func_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_ste_tag_port_print(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_port ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : "UH_FMT"\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : "UH_FMT"\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth                  : "UH_FMT"\n", ptr_struct->bth);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_type              : "UH_FMT"\n", ptr_struct->qp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_sniffer           : "UH_FMT"\n", ptr_struct->sx_sniffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_lb             : "UH_FMT"\n", ptr_struct->force_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "func_lb              : "UH_FMT"\n", ptr_struct->func_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "multicast            : "UH_FMT"\n", ptr_struct->multicast);

}

int connectib_hw_ste_tag_port_size(void){
	 return 16;
}

void connectib_hw_ste_tag_port_dump(const struct connectib_hw_ste_tag_port *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_port_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_source_gvmi_qp_pack(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->source_gvmi);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->source_qp);

	offset=39;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->source_is_requestor);

}

void connectib_hw_ste_tag_source_gvmi_qp_unpack(struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->source_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=40;
	ptr_struct->source_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=39;
	ptr_struct->source_is_requestor = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_ste_tag_source_gvmi_qp_print(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_source_gvmi_qp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_gvmi          : "UH_FMT"\n", ptr_struct->source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_qp            : "UH_FMT"\n", ptr_struct->source_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_is_requestor  : "UH_FMT"\n", ptr_struct->source_is_requestor);

}

int connectib_hw_ste_tag_source_gvmi_qp_size(void){
	 return 16;
}

void connectib_hw_ste_tag_source_gvmi_qp_dump(const struct connectib_hw_ste_tag_source_gvmi_qp *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_source_gvmi_qp_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l4_pack(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->dest_qp);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey);

}

void connectib_hw_ste_tag_ib_l4_unpack(struct connectib_hw_ste_tag_ib_l4 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->dest_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=48;
	ptr_struct->pkey = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_ste_tag_ib_l4_print(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l4 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dest_qp              : "UH_FMT"\n", ptr_struct->dest_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey                 : "UH_FMT"\n", ptr_struct->pkey);

}

int connectib_hw_ste_tag_ib_l4_size(void){
	 return 16;
}

void connectib_hw_ste_tag_ib_l4_dump(const struct connectib_hw_ste_tag_ib_l4 *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_ib_l4_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l3_pack(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dgid_127_96);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dgid_95_64);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dgid_63_32);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dgid_31_0);

}

void connectib_hw_ste_tag_ib_l3_unpack(struct connectib_hw_ste_tag_ib_l3 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dgid_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->dgid_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->dgid_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->dgid_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_ib_l3_print(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l3 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_127_96          : "U32H_FMT"\n", ptr_struct->dgid_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_95_64           : "U32H_FMT"\n", ptr_struct->dgid_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_63_32           : "U32H_FMT"\n", ptr_struct->dgid_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dgid_31_0            : "U32H_FMT"\n", ptr_struct->dgid_31_0);

}

int connectib_hw_ste_tag_ib_l3_size(void){
	 return 16;
}

void connectib_hw_ste_tag_ib_l3_dump(const struct connectib_hw_ste_tag_ib_l3 *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_ib_l3_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l3_extended_pack(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->traffic_class);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey);

	offset=35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dceth_complete);

	offset=34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->deth_complete);

	offset=33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth_complete);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ip_version);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qkey_dc_access_key_63_32);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qkey_dc_access_key_31_0);

}

void connectib_hw_ste_tag_ib_l3_extended_unpack(struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=8;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=0;
	ptr_struct->traffic_class = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=48;
	ptr_struct->pkey = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=35;
	ptr_struct->dceth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=34;
	ptr_struct->deth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=33;
	ptr_struct->bth_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->ip_version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->qkey_dc_access_key_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->qkey_dc_access_key_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_ib_l3_extended_print(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l3_extended ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "traffic_class        : "UH_FMT"\n", ptr_struct->traffic_class);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey                 : "UH_FMT"\n", ptr_struct->pkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dceth_complete       : "UH_FMT"\n", ptr_struct->dceth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "deth_complete        : "UH_FMT"\n", ptr_struct->deth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth_complete         : "UH_FMT"\n", ptr_struct->bth_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ip_version           : "UH_FMT"\n", ptr_struct->ip_version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey_dc_access_key_63_32 : "U32H_FMT"\n", ptr_struct->qkey_dc_access_key_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey_dc_access_key_31_0 : "U32H_FMT"\n", ptr_struct->qkey_dc_access_key_31_0);

}

int connectib_hw_ste_tag_ib_l3_extended_size(void){
	 return 16;
}

void connectib_hw_ste_tag_ib_l3_extended_dump(const struct connectib_hw_ste_tag_ib_l3_extended *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_ib_l3_extended_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_ib_l2_pack(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dlid);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bth);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->qp_type);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->multicast);

	offset=76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwh_ethertype);

}

void connectib_hw_ste_tag_ib_l2_unpack(struct connectib_hw_ste_tag_ib_l2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->dlid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=15;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->bth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->qp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=8;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=0;
	ptr_struct->multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=76;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=112;
	ptr_struct->rwh_ethertype = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_ste_tag_ib_l2_print(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_ib_l2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dlid                 : "UH_FMT"\n", ptr_struct->dlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : "UH_FMT"\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bth                  : "UH_FMT"\n", ptr_struct->bth);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_type              : "UH_FMT"\n", ptr_struct->qp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "multicast            : "UH_FMT"\n", ptr_struct->multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwh_ethertype        : "UH_FMT"\n", ptr_struct->rwh_ethertype);

}

int connectib_hw_ste_tag_ib_l2_size(void){
	 return 16;
}

void connectib_hw_ste_tag_ib_l2_dump(const struct connectib_hw_ste_tag_ib_l2 *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_ib_l2_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_bulk_pack(const struct connectib_hw_ste_tag_bulk *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tag_127_96);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tag_95_64);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tag_63_32);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tag_31_0);

}

void connectib_hw_ste_tag_bulk_unpack(struct connectib_hw_ste_tag_bulk *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->tag_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->tag_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->tag_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->tag_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_ste_tag_bulk_print(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag_bulk ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_127_96           : "U32H_FMT"\n", ptr_struct->tag_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_95_64            : "U32H_FMT"\n", ptr_struct->tag_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_63_32            : "U32H_FMT"\n", ptr_struct->tag_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_31_0             : "U32H_FMT"\n", ptr_struct->tag_31_0);

}

int connectib_hw_ste_tag_bulk_size(void){
	 return 16;
}

void connectib_hw_ste_tag_bulk_dump(const struct connectib_hw_ste_tag_bulk *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_bulk_print(ptr_struct, file, 0);
}

void connectib_hw_transaction_pdf_pack(const struct connectib_hw_transaction_pdf *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_data_bits);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_data_bits);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->seed);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bytes);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bits);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_crc);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sig_zones_covered);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sig_type);

}

void connectib_hw_transaction_pdf_unpack(struct connectib_hw_transaction_pdf *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	ptr_struct->invert_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->swap_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->seed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->swap_crc_bytes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->swap_crc_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->invert_crc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->sig_zones_covered = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->sig_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_transaction_pdf_print(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_transaction_pdf ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_data_bits     : "UH_FMT"\n", ptr_struct->invert_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_data_bits       : "UH_FMT"\n", ptr_struct->swap_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "seed                 : "UH_FMT"\n", ptr_struct->seed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bytes       : "UH_FMT"\n", ptr_struct->swap_crc_bytes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bits        : "UH_FMT"\n", ptr_struct->swap_crc_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_crc           : "UH_FMT"\n", ptr_struct->invert_crc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_zones_covered    : "UH_FMT"\n", ptr_struct->sig_zones_covered);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_type             : "UH_FMT"\n", ptr_struct->sig_type);

}

int connectib_hw_transaction_pdf_size(void){
	 return 8;
}

void connectib_hw_transaction_pdf_dump(const struct connectib_hw_transaction_pdf *ptr_struct, FILE* file) {
	connectib_hw_transaction_pdf_print(ptr_struct, file, 0);
}

void connectib_hw_pdf_decoder_pack(const struct connectib_hw_pdf_decoder *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_data_bits);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_data_bits);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->seed);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bytes);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->swap_crc_bits);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invert_crc);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->regular);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sig_type);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dif_app_tag_bit_check_en);

	offset=46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dif_guard_check_type);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dif_learn_mode);

	offset=43;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_learn_app_tag);

	offset=42;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_learn_ref_tag);

	offset=41;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dif_inc_ref_tag);

}

void connectib_hw_pdf_decoder_unpack(struct connectib_hw_pdf_decoder *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	ptr_struct->invert_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->swap_data_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->seed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->swap_crc_bytes = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->swap_crc_bits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->invert_crc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->regular = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->sig_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=48;
	ptr_struct->dif_app_tag_bit_check_en = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=46;
	ptr_struct->dif_guard_check_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=44;
	ptr_struct->dif_learn_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=43;
	ptr_struct->dif_learn_app_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=42;
	ptr_struct->dif_learn_ref_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=41;
	ptr_struct->dif_inc_ref_tag = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_pdf_decoder_print(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_pdf_decoder ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_data_bits     : "UH_FMT"\n", ptr_struct->invert_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_data_bits       : "UH_FMT"\n", ptr_struct->swap_data_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "seed                 : "UH_FMT"\n", ptr_struct->seed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bytes       : "UH_FMT"\n", ptr_struct->swap_crc_bytes);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swap_crc_bits        : "UH_FMT"\n", ptr_struct->swap_crc_bits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invert_crc           : "UH_FMT"\n", ptr_struct->invert_crc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular              : "UH_FMT"\n", ptr_struct->regular);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sig_type             : "UH_FMT"\n", ptr_struct->sig_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_app_tag_bit_check_en : "UH_FMT"\n", ptr_struct->dif_app_tag_bit_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_guard_check_type : "UH_FMT"\n", ptr_struct->dif_guard_check_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_mode       : "UH_FMT"\n", ptr_struct->dif_learn_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_app_tag    : "UH_FMT"\n", ptr_struct->dif_learn_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_learn_ref_tag    : "UH_FMT"\n", ptr_struct->dif_learn_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dif_inc_ref_tag      : "UH_FMT"\n", ptr_struct->dif_inc_ref_tag);

}

int connectib_hw_pdf_decoder_size(void){
	 return 8;
}

void connectib_hw_pdf_decoder_dump(const struct connectib_hw_pdf_decoder *ptr_struct, FILE* file) {
	connectib_hw_pdf_decoder_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_tx_set_ini_pack(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_pre);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pre_polarity);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_post);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_polarity);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->ob_preemp_main);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->main_polarity);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->preemp_mode);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ob_bias);

}

void connectib_serdes_conf_tx_set_ini_unpack(struct connectib_serdes_conf_tx_set_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=25;
	ptr_struct->ob_preemp_pre = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=24;
	ptr_struct->pre_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->ob_preemp_post = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=16;
	ptr_struct->post_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->ob_preemp_main = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=8;
	ptr_struct->main_polarity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->preemp_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=2;
	ptr_struct->ob_bias = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_serdes_conf_tx_set_ini_print(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_tx_set_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_pre        : "UH_FMT"\n", ptr_struct->ob_preemp_pre);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pre_polarity         : "UH_FMT"\n", ptr_struct->pre_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_post       : "UH_FMT"\n", ptr_struct->ob_preemp_post);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_polarity        : "UH_FMT"\n", ptr_struct->post_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_preemp_main       : "UH_FMT"\n", ptr_struct->ob_preemp_main);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "main_polarity        : "UH_FMT"\n", ptr_struct->main_polarity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "preemp_mode          : "UH_FMT"\n", ptr_struct->preemp_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ob_bias              : "UH_FMT"\n", ptr_struct->ob_bias);

}

int connectib_serdes_conf_tx_set_ini_size(void){
	 return 4;
}

void connectib_serdes_conf_tx_set_ini_dump(const struct connectib_serdes_conf_tx_set_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_tx_set_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_rx_set_ini_pack(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->slicer_ind_en);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->slicer1_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->slicer2_enable);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap0);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap1);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap2);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap3);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ffe_tap4);

}

void connectib_serdes_conf_rx_set_ini_unpack(struct connectib_serdes_conf_rx_set_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->slicer_ind_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=20;
	ptr_struct->slicer1_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=16;
	ptr_struct->slicer2_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=8;
	ptr_struct->ffe_tap0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->ffe_tap1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=56;
	ptr_struct->ffe_tap2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=48;
	ptr_struct->ffe_tap3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=40;
	ptr_struct->ffe_tap4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_serdes_conf_rx_set_ini_print(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_rx_set_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer_ind_en        : "UH_FMT"\n", ptr_struct->slicer_ind_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer1_enable       : "UH_FMT"\n", ptr_struct->slicer1_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slicer2_enable       : "UH_FMT"\n", ptr_struct->slicer2_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap0             : "UH_FMT"\n", ptr_struct->ffe_tap0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap1             : "UH_FMT"\n", ptr_struct->ffe_tap1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap2             : "UH_FMT"\n", ptr_struct->ffe_tap2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap3             : "UH_FMT"\n", ptr_struct->ffe_tap3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ffe_tap4             : "UH_FMT"\n", ptr_struct->ffe_tap4);

}

int connectib_serdes_conf_rx_set_ini_size(void){
	 return 8;
}

void connectib_serdes_conf_rx_set_ini_dump(const struct connectib_serdes_conf_rx_set_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_rx_set_ini_print(ptr_struct, file, 0);
}

void connectib_aba_index_pack(const struct connectib_aba_index *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0_start);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0_end);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index0);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1_start);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1_end);

	offset=58;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index1);

	offset=52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2_start);

	offset=46;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2_end);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index2);

	offset=34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3_start);

	offset=90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3_end);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index3);

	offset=78;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4_start);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4_end);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index4);

	offset=122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5_start);

	offset=116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5_end);

	offset=110;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->aba_index5);

}

void connectib_aba_index_unpack(struct connectib_aba_index *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->aba_index0_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=20;
	ptr_struct->aba_index0_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=14;
	ptr_struct->aba_index0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=8;
	ptr_struct->aba_index1_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=2;
	ptr_struct->aba_index1_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=58;
	ptr_struct->aba_index1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=52;
	ptr_struct->aba_index2_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=46;
	ptr_struct->aba_index2_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=40;
	ptr_struct->aba_index2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=34;
	ptr_struct->aba_index3_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=90;
	ptr_struct->aba_index3_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=84;
	ptr_struct->aba_index3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=78;
	ptr_struct->aba_index4_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=72;
	ptr_struct->aba_index4_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=66;
	ptr_struct->aba_index4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=122;
	ptr_struct->aba_index5_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=116;
	ptr_struct->aba_index5_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=110;
	ptr_struct->aba_index5 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

}

void connectib_aba_index_print(const struct connectib_aba_index *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_aba_index ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0_start     : "UH_FMT"\n", ptr_struct->aba_index0_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0_end       : "UH_FMT"\n", ptr_struct->aba_index0_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index0           : "UH_FMT"\n", ptr_struct->aba_index0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1_start     : "UH_FMT"\n", ptr_struct->aba_index1_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1_end       : "UH_FMT"\n", ptr_struct->aba_index1_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index1           : "UH_FMT"\n", ptr_struct->aba_index1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2_start     : "UH_FMT"\n", ptr_struct->aba_index2_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2_end       : "UH_FMT"\n", ptr_struct->aba_index2_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index2           : "UH_FMT"\n", ptr_struct->aba_index2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3_start     : "UH_FMT"\n", ptr_struct->aba_index3_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3_end       : "UH_FMT"\n", ptr_struct->aba_index3_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index3           : "UH_FMT"\n", ptr_struct->aba_index3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4_start     : "UH_FMT"\n", ptr_struct->aba_index4_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4_end       : "UH_FMT"\n", ptr_struct->aba_index4_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index4           : "UH_FMT"\n", ptr_struct->aba_index4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5_start     : "UH_FMT"\n", ptr_struct->aba_index5_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5_end       : "UH_FMT"\n", ptr_struct->aba_index5_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_index5           : "UH_FMT"\n", ptr_struct->aba_index5);

}

int connectib_aba_index_size(void){
	 return 16;
}

void connectib_aba_index_dump(const struct connectib_aba_index *ptr_struct, FILE* file) {
	connectib_aba_index_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_type_pack(const union connectib_nv_tlv_type *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_dw_pack(&(ptr_struct->as_dw), ptr_buff);
}

void connectib_nv_tlv_type_unpack(union connectib_nv_tlv_type *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_dw_unpack(&(ptr_struct->as_dw), ptr_buff);
}

void connectib_nv_tlv_type_print(const union connectib_nv_tlv_type *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_type ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "global:\n");
	connectib_nv_tlv_type_global_print(&(ptr_struct->global), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "physical_port:\n");
	connectib_nv_tlv_type_physical_port_print(&(ptr_struct->physical_port), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bmc:\n");
	connectib_nv_tlv_type_bmc_print(&(ptr_struct->bmc), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "per_host:\n");
	connectib_nv_tlv_type_per_host_print(&(ptr_struct->per_host), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eswitch:\n");
	connectib_nv_tlv_type_eswitch_print(&(ptr_struct->eswitch), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvlog:\n");
	connectib_nv_tlv_type_nvlog_print(&(ptr_struct->nvlog), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "as_dw:\n");
	connectib_dw_print(&(ptr_struct->as_dw), file, indent_level + 1);

}

int connectib_nv_tlv_type_size(void){
	 return 4;
}

void connectib_nv_tlv_type_dump(const union connectib_nv_tlv_type *ptr_struct, FILE* file) {
	connectib_nv_tlv_type_print(ptr_struct, file, 0);
}

void connectib_register_access_data_pack(const struct connectib_register_access_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 8; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dword[i]);
	}

}

void connectib_register_access_data_unpack(struct connectib_register_access_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 8; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 256, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_register_access_data_print(const struct connectib_register_access_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_access_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : "U32H_FMT"\n", i, ptr_struct->dword[i]);
	}

}

int connectib_register_access_data_size(void){
	 return 32;
}

void connectib_register_access_data_dump(const struct connectib_register_access_data *ptr_struct, FILE* file) {
	connectib_register_access_data_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_hdr_pack(const struct connectib_nv_tlv_hdr *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 9, (u_int32_t)ptr_struct->length);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->shadow);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->version);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rd_en);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->ovr_en);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->header_type);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->priority);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->type);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->crc16);

}

void connectib_nv_tlv_hdr_unpack(struct connectib_nv_tlv_hdr *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=23;
	ptr_struct->length = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 9);

	offset=20;
	ptr_struct->shadow = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=8;
	ptr_struct->rd_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->ovr_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=4;
	ptr_struct->header_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=2;
	ptr_struct->priority = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=0;
	ptr_struct->valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->type = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->crc16 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_nv_tlv_hdr_print(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_hdr ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "length               : "UH_FMT"\n", ptr_struct->length);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "shadow               : "UH_FMT"\n", ptr_struct->shadow);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version              : "UH_FMT"\n", ptr_struct->version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rd_en                : "UH_FMT"\n", ptr_struct->rd_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ovr_en               : "UH_FMT"\n", ptr_struct->ovr_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "header_type          : "UH_FMT"\n", ptr_struct->header_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "priority             : "UH_FMT"\n", ptr_struct->priority);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "valid                : "UH_FMT"\n", ptr_struct->valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type                 : "U32H_FMT"\n", ptr_struct->type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "crc16                : "UH_FMT"\n", ptr_struct->crc16);

}

int connectib_nv_tlv_hdr_size(void){
	 return 12;
}

void connectib_nv_tlv_hdr_dump(const struct connectib_nv_tlv_hdr *ptr_struct, FILE* file) {
	connectib_nv_tlv_hdr_print(ptr_struct, file, 0);
}

void connectib_mfba_header_pack(const struct connectib_mfba_header *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset=55;
	adb2c_push_bits_to_buff(ptr_buff, offset, 9, (u_int32_t)ptr_struct->size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

}

void connectib_mfba_header_unpack(struct connectib_mfba_header *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=55;
	ptr_struct->size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 9);

	offset=72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_mfba_header_print(const struct connectib_mfba_header *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfba_header ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : "UH_FMT"\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : "UH_FMT"\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : "UH_FMT"\n", ptr_struct->address);

}

int connectib_mfba_header_size(void){
	 return 12;
}

void connectib_mfba_header_dump(const struct connectib_mfba_header *ptr_struct, FILE* file) {
	connectib_mfba_header_print(ptr_struct, file, 0);
}

void connectib_fw_ref_count_pack(const struct connectib_fw_ref_count *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 28, (u_int32_t)ptr_struct->ref_counter);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ref_valid_cre_type);

}

void connectib_fw_ref_count_unpack(struct connectib_fw_ref_count *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=4;
	ptr_struct->ref_counter = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 28);

	offset=0;
	ptr_struct->ref_valid_cre_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_fw_ref_count_print(const struct connectib_fw_ref_count *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_ref_count ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ref_counter          : "UH_FMT"\n", ptr_struct->ref_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ref_valid_cre_type   : "UH_FMT"\n", ptr_struct->ref_valid_cre_type);

}

int connectib_fw_ref_count_size(void){
	 return 4;
}

void connectib_fw_ref_count_dump(const struct connectib_fw_ref_count *ptr_struct, FILE* file) {
	connectib_fw_ref_count_print(ptr_struct, file, 0);
}

void connectib_tir_dmfs_pack(const struct connectib_tir_dmfs *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->ste_ix);

}

void connectib_tir_dmfs_unpack(struct connectib_tir_dmfs *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->ste_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_tir_dmfs_print(const struct connectib_tir_dmfs *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_tir_dmfs ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ste_ix               : "U64H_FMT"\n", ptr_struct->ste_ix);

}

int connectib_tir_dmfs_size(void){
	 return 8;
}

void connectib_tir_dmfs_dump(const struct connectib_tir_dmfs *ptr_struct, FILE* file) {
	connectib_tir_dmfs_print(ptr_struct, file, 0);
}

void connectib_rx_hash_field_select_pack(const struct connectib_rx_hash_field_select *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->selected_fields);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->l4_prot_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->l3_prot_type);

}

void connectib_rx_hash_field_select_unpack(struct connectib_rx_hash_field_select *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=2;
	ptr_struct->selected_fields = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

	offset=1;
	ptr_struct->l4_prot_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->l3_prot_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_rx_hash_field_select_print(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_rx_hash_field_select ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "selected_fields      : %s ("UH_FMT")\n", (ptr_struct->selected_fields == 0 ? ("SRC_IP") : ((ptr_struct->selected_fields == 1 ? ("DST_IP") : ((ptr_struct->selected_fields == 2 ? ("L4_SPORT") : ((ptr_struct->selected_fields == 3 ? ("L4_DPORT") : ((ptr_struct->selected_fields == 4 ? ("IPSEC_SPI") : ("unknown")))))))))), ptr_struct->selected_fields);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l4_prot_type         : "UH_FMT"\n", ptr_struct->l4_prot_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l3_prot_type         : "UH_FMT"\n", ptr_struct->l3_prot_type);

}

int connectib_rx_hash_field_select_size(void){
	 return 4;
}

void connectib_rx_hash_field_select_dump(const struct connectib_rx_hash_field_select *ptr_struct, FILE* file) {
	connectib_rx_hash_field_select_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_special_pack(const union connectib_fw_qpc_special *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_dcr_qp_pack(&(ptr_struct->dcr_qp), ptr_buff);
}

void connectib_fw_qpc_special_unpack(union connectib_fw_qpc_special *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_dcr_qp_unpack(&(ptr_struct->dcr_qp), ptr_buff);
}

void connectib_fw_qpc_special_print(const union connectib_fw_qpc_special *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_special ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular_qp:\n");
	connectib_regular_qp_print(&(ptr_struct->regular_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_qp:\n");
	connectib_dcr_qp_print(&(ptr_struct->dcr_qp), file, indent_level + 1);

}

int connectib_fw_qpc_special_size(void){
	 return 16;
}

void connectib_fw_qpc_special_dump(const union connectib_fw_qpc_special *ptr_struct, FILE* file) {
	connectib_fw_qpc_special_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_q_pack(const struct connectib_fw_qpc_q *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->qp_state);

	offset=16;
	connectib_schedint_cause_pack(&(ptr_struct->schedint_cause), ptr_buff + offset/8);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sxdc_valid);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qpc_valid);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dct_cleanup_state);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_in_linked_list);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cmdif_awaiting);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dup_sx_flush_kill_qp_arb_disabled);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->broken_wq_buffer);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->broken_cq);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->catas_event_generated);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_wqe_event_generated);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->async_event_generated);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->flushed_in_error);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->disable_flushed_in_error);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vendor_syndrome);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->hw_syndrome);

	offset=123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->trap_reason);

	offset=122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->connect_sent_to_ctrl_dct);

	offset=121;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->needed_events_generated);

	offset=120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_progress_after_retry);

	offset=116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->retransmission_state);

	offset=115;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_fault_event_fired);

	offset=114;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_progress_after_fault);

	offset=113;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_fault_event_fired);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_progress_after_fault);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->trap_data);

}

void connectib_fw_qpc_q_unpack(struct connectib_fw_qpc_q *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->qp_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=16;
	connectib_schedint_cause_unpack(&(ptr_struct->schedint_cause), ptr_buff + offset/8);

	offset=15;
	ptr_struct->sxdc_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->qpc_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->dct_cleanup_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=11;
	ptr_struct->qp_in_linked_list = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->cmdif_awaiting = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->dup_sx_flush_kill_qp_arb_disabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->broken_wq_buffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->broken_cq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->catas_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->last_wqe_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->async_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->flushed_in_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->disable_flushed_in_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->vendor_syndrome = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=64;
	ptr_struct->hw_syndrome = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=123;
	ptr_struct->trap_reason = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=122;
	ptr_struct->connect_sent_to_ctrl_dct = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=121;
	ptr_struct->needed_events_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=120;
	ptr_struct->rx_progress_after_retry = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=116;
	ptr_struct->retransmission_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=115;
	ptr_struct->rx_fault_event_fired = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=114;
	ptr_struct->rx_progress_after_fault = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=113;
	ptr_struct->sx_fault_event_fired = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->sx_progress_after_fault = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->trap_data = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_fw_qpc_q_print(const struct connectib_fw_qpc_q *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc_q ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "schedint_cause:\n");
	connectib_schedint_cause_print(&(ptr_struct->schedint_cause), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sxdc_valid           : "UH_FMT"\n", ptr_struct->sxdc_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpc_valid            : "UH_FMT"\n", ptr_struct->qpc_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_cleanup_state    : "UH_FMT"\n", ptr_struct->dct_cleanup_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_in_linked_list    : "UH_FMT"\n", ptr_struct->qp_in_linked_list);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmdif_awaiting       : "UH_FMT"\n", ptr_struct->cmdif_awaiting);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dup_sx_flush_kill_qp_arb_disabled : "UH_FMT"\n", ptr_struct->dup_sx_flush_kill_qp_arb_disabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "broken_wq_buffer     : "UH_FMT"\n", ptr_struct->broken_wq_buffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "broken_cq            : "UH_FMT"\n", ptr_struct->broken_cq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "catas_event_generated : "UH_FMT"\n", ptr_struct->catas_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_wqe_event_generated : "UH_FMT"\n", ptr_struct->last_wqe_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "async_event_generated : "UH_FMT"\n", ptr_struct->async_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flushed_in_error     : "UH_FMT"\n", ptr_struct->flushed_in_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disable_flushed_in_error : "UH_FMT"\n", ptr_struct->disable_flushed_in_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vendor_syndrome      : "UH_FMT"\n", ptr_struct->vendor_syndrome);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_syndrome          : "UH_FMT"\n", ptr_struct->hw_syndrome);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_reason          : %s ("UH_FMT")\n", (ptr_struct->trap_reason == 0 ? ("NORMAL") : ((ptr_struct->trap_reason == 1 ? ("SET_LIMIT") : ((ptr_struct->trap_reason == 2 ? ("DCR_OVERFLOW") : ((ptr_struct->trap_reason == 3 ? ("DCR_DUP_WA") : ((ptr_struct->trap_reason == 4 ? ("DCI_RECONNECT") : ("unknown")))))))))), ptr_struct->trap_reason);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connect_sent_to_ctrl_dct : "UH_FMT"\n", ptr_struct->connect_sent_to_ctrl_dct);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "needed_events_generated : "UH_FMT"\n", ptr_struct->needed_events_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_progress_after_retry : "UH_FMT"\n", ptr_struct->rx_progress_after_retry);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "retransmission_state : "UH_FMT"\n", ptr_struct->retransmission_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_fault_event_fired : "UH_FMT"\n", ptr_struct->rx_fault_event_fired);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_progress_after_fault : "UH_FMT"\n", ptr_struct->rx_progress_after_fault);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_fault_event_fired : "UH_FMT"\n", ptr_struct->sx_fault_event_fired);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_progress_after_fault : "UH_FMT"\n", ptr_struct->sx_progress_after_fault);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_data            : "UH_FMT"\n", ptr_struct->trap_data);

}

int connectib_fw_qpc_q_size(void){
	 return 16;
}

void connectib_fw_qpc_q_dump(const struct connectib_fw_qpc_q *ptr_struct, FILE* file) {
	connectib_fw_qpc_q_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_data_pack(const union connectib_hw_msix_context_data *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_msix_context_data0_pack(&(ptr_struct->regular), ptr_buff);
}

void connectib_hw_msix_context_data_unpack(union connectib_hw_msix_context_data *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_msix_context_data0_unpack(&(ptr_struct->regular), ptr_buff);
}

void connectib_hw_msix_context_data_print(const union connectib_hw_msix_context_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "regular:\n");
	connectib_hw_msix_context_data0_print(&(ptr_struct->regular), file, indent_level + 1);

}

int connectib_hw_msix_context_data_size(void){
	 return 4;
}

void connectib_hw_msix_context_data_dump(const union connectib_hw_msix_context_data *ptr_struct, FILE* file) {
	connectib_hw_msix_context_data_print(ptr_struct, file, 0);
}

void connectib_steering_qp_entry_pack(const struct connectib_steering_qp_entry *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->qp_number);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_responder);

}

void connectib_steering_qp_entry_unpack(struct connectib_steering_qp_entry *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->qp_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=0;
	ptr_struct->force_responder = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_steering_qp_entry_print(const struct connectib_steering_qp_entry *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_steering_qp_entry ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_number            : "UH_FMT"\n", ptr_struct->qp_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_responder      : "UH_FMT"\n", ptr_struct->force_responder);

}

int connectib_steering_qp_entry_size(void){
	 return 4;
}

void connectib_steering_qp_entry_dump(const struct connectib_steering_qp_entry *ptr_struct, FILE* file) {
	connectib_steering_qp_entry_print(ptr_struct, file, 0);
}

void connectib_hw_ste_tag_pack(const union connectib_hw_ste_tag *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_ste_tag_generic_headers_pack(&(ptr_struct->generic_headers), ptr_buff);
}

void connectib_hw_ste_tag_unpack(union connectib_hw_ste_tag *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_ste_tag_generic_headers_unpack(&(ptr_struct->generic_headers), ptr_buff);
}

void connectib_hw_ste_tag_print(const union connectib_hw_ste_tag *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste_tag ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bulk:\n");
	connectib_hw_ste_tag_bulk_print(&(ptr_struct->bulk), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl2:\n");
	connectib_hw_ste_tag_ib_l2_print(&(ptr_struct->ibl2), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl3_extended:\n");
	connectib_hw_ste_tag_ib_l3_extended_print(&(ptr_struct->ibl3_extended), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl3:\n");
	connectib_hw_ste_tag_ib_l3_print(&(ptr_struct->ibl3), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ibl4:\n");
	connectib_hw_ste_tag_ib_l4_print(&(ptr_struct->ibl4), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "source_gvmi_qp:\n");
	connectib_hw_ste_tag_source_gvmi_qp_print(&(ptr_struct->source_gvmi_qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port:\n");
	connectib_hw_ste_tag_port_print(&(ptr_struct->port), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "generic_headers:\n");
	connectib_hw_ste_tag_generic_headers_print(&(ptr_struct->generic_headers), file, indent_level + 1);

}

int connectib_hw_ste_tag_size(void){
	 return 16;
}

void connectib_hw_ste_tag_dump(const union connectib_hw_ste_tag *ptr_struct, FILE* file) {
	connectib_hw_ste_tag_print(ptr_struct, file, 0);
}

void connectib_hw_pdf_entry_pack(const union connectib_hw_pdf_entry *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_hw_transaction_pdf_pack(&(ptr_struct->transaction_pdf), ptr_buff);
}

void connectib_hw_pdf_entry_unpack(union connectib_hw_pdf_entry *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_hw_transaction_pdf_unpack(&(ptr_struct->transaction_pdf), ptr_buff);
}

void connectib_hw_pdf_entry_print(const union connectib_hw_pdf_entry *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_pdf_entry ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pdf_decoder:\n");
	connectib_hw_pdf_decoder_print(&(ptr_struct->pdf_decoder), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transaction_pdf:\n");
	connectib_hw_transaction_pdf_print(&(ptr_struct->transaction_pdf), file, indent_level + 1);

}

int connectib_hw_pdf_entry_size(void){
	 return 8;
}

void connectib_hw_pdf_entry_dump(const union connectib_hw_pdf_entry *ptr_struct, FILE* file) {
	connectib_hw_pdf_entry_print(ptr_struct, file, 0);
}

void connectib_pf_vf_vpd_pack(const struct connectib_pf_vf_vpd *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 15, (u_int32_t)ptr_struct->vpd_address);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->F);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->vpd_data);

}

void connectib_pf_vf_vpd_unpack(struct connectib_pf_vf_vpd *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=1;
	ptr_struct->vpd_address = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 15);

	offset=0;
	ptr_struct->F = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->vpd_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pf_vf_vpd_print(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_vf_vpd ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vpd_address          : "UH_FMT"\n", ptr_struct->vpd_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "F                    : "UH_FMT"\n", ptr_struct->F);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vpd_data             : "U32H_FMT"\n", ptr_struct->vpd_data);

}

int connectib_pf_vf_vpd_size(void){
	 return 8;
}

void connectib_pf_vf_vpd_dump(const struct connectib_pf_vf_vpd *ptr_struct, FILE* file) {
	connectib_pf_vf_vpd_print(ptr_struct, file, 0);
}

void connectib_pf_vf_sriov_pack(const struct connectib_pf_vf_sriov *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_enable);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_en);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_int_en);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_mse);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ari_capable_hierarchy);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_system_page_size);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->num_vfs);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->not_in_use);

}

void connectib_pf_vf_sriov_unpack(struct connectib_pf_vf_sriov *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->vf_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->vf_migration_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->vf_migration_int_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->vf_mse = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->ari_capable_hierarchy = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->log_system_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=6;
	ptr_struct->num_vfs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=32;
	ptr_struct->not_in_use = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_pf_vf_sriov_print(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_vf_sriov ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_enable            : "UH_FMT"\n", ptr_struct->vf_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_en      : "UH_FMT"\n", ptr_struct->vf_migration_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_int_en  : "UH_FMT"\n", ptr_struct->vf_migration_int_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mse               : "UH_FMT"\n", ptr_struct->vf_mse);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_capable_hierarchy : "UH_FMT"\n", ptr_struct->ari_capable_hierarchy);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_system_page_size : "UH_FMT"\n", ptr_struct->log_system_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_vfs              : "UH_FMT"\n", ptr_struct->num_vfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "not_in_use           : "U32H_FMT"\n", ptr_struct->not_in_use);

}

int connectib_pf_vf_sriov_size(void){
	 return 8;
}

void connectib_pf_vf_sriov_dump(const struct connectib_pf_vf_sriov *ptr_struct, FILE* file) {
	connectib_pf_vf_sriov_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_preset_tx_ini_pack(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 16; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 512, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_preset_tx_ini_unpack(struct connectib_serdes_conf_preset_tx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 16; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 512, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_preset_tx_ini_print(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_preset_tx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 16; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_preset_tx_ini_size(void){
	 return 64;
}

void connectib_serdes_conf_preset_tx_ini_dump(const struct connectib_serdes_conf_preset_tx_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_preset_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_active_tx_ini_pack(const struct connectib_serdes_active_tx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 128, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_tx_ini_unpack(struct connectib_serdes_active_tx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 128, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_tx_ini_print(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_active_tx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_active_tx_ini_size(void){
	 return 16;
}

void connectib_serdes_active_tx_ini_dump(const struct connectib_serdes_active_tx_ini *ptr_struct, FILE* file) {
	connectib_serdes_active_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_active_rx_ini_pack(const struct connectib_serdes_active_rx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 256, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_rx_ini_unpack(struct connectib_serdes_active_rx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 256, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_active_rx_ini_print(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_active_rx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_active_rx_ini_size(void){
	 return 32;
}

void connectib_serdes_active_rx_ini_dump(const struct connectib_serdes_active_rx_ini *ptr_struct, FILE* file) {
	connectib_serdes_active_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_force_tx_ini_pack(const struct connectib_serdes_force_tx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 320, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_tx_ini_unpack(struct connectib_serdes_force_tx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 320, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_tx_ini_print(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_force_tx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_force_tx_ini_size(void){
	 return 40;
}

void connectib_serdes_force_tx_ini_dump(const struct connectib_serdes_force_tx_ini *ptr_struct, FILE* file) {
	connectib_serdes_force_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_force_rx_ini_pack(const struct connectib_serdes_force_rx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 640, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_rx_ini_unpack(struct connectib_serdes_force_rx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 640, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_force_rx_ini_print(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_force_rx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_force_rx_ini_size(void){
	 return 80;
}

void connectib_serdes_force_rx_ini_dump(const struct connectib_serdes_force_rx_ini *ptr_struct, FILE* file) {
	connectib_serdes_force_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_aba_tx_ini_pack(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_tx_ini_unpack(struct connectib_serdes_conf_aba_tx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_tx_ini_print(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_aba_tx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_aba_tx_ini_size(void){
	 return 128;
}

void connectib_serdes_conf_aba_tx_ini_dump(const struct connectib_serdes_conf_aba_tx_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_aba_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_aba_rx_ini_pack(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_rx_ini_unpack(struct connectib_serdes_conf_aba_rx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_aba_rx_ini_print(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_aba_rx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_aba_rx_ini_size(void){
	 return 256;
}

void connectib_serdes_conf_aba_rx_ini_dump(const struct connectib_serdes_conf_aba_rx_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_aba_rx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_autoneg_tx_ini_pack(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_tx_ini_unpack(struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 1024, 1);
	connectib_serdes_conf_tx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_tx_ini_print(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_autoneg_tx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_tx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_autoneg_tx_ini_size(void){
	 return 128;
}

void connectib_serdes_conf_autoneg_tx_ini_dump(const struct connectib_serdes_conf_autoneg_tx_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_autoneg_tx_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_conf_autoneg_rx_ini_pack(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_pack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_rx_ini_unpack(struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 32; i++) {
	offset=adb2c_calc_array_field_address(0, 64, i, 2048, 1);
	connectib_serdes_conf_rx_set_ini_unpack(&(ptr_struct->set[i]), ptr_buff + offset/8);
	}

}

void connectib_serdes_conf_autoneg_rx_ini_print(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_conf_autoneg_rx_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 32; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "set_%03d:\n", i);
	connectib_serdes_conf_rx_set_ini_print(&(ptr_struct->set[i]), file, indent_level + 1);
	}

}

int connectib_serdes_conf_autoneg_rx_ini_size(void){
	 return 256;
}

void connectib_serdes_conf_autoneg_rx_ini_dump(const struct connectib_serdes_conf_autoneg_rx_ini *ptr_struct, FILE* file) {
	connectib_serdes_conf_autoneg_rx_ini_print(ptr_struct, file, 0);
}

void connectib_aba_indexes_pack(const struct connectib_aba_indexes *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_aba_index_pack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset=128;
	connectib_aba_index_pack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset=256;
	connectib_aba_index_pack(&(ptr_struct->encode_8_10_legacy), ptr_buff + offset/8);

}

void connectib_aba_indexes_unpack(struct connectib_aba_indexes *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_aba_index_unpack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset=128;
	connectib_aba_index_unpack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset=256;
	connectib_aba_index_unpack(&(ptr_struct->encode_8_10_legacy), ptr_buff + offset/8);

}

void connectib_aba_indexes_print(const struct connectib_aba_indexes *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_aba_indexes ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_64_66:\n");
	connectib_aba_index_print(&(ptr_struct->encode_64_66), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_8_10:\n");
	connectib_aba_index_print(&(ptr_struct->encode_8_10), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_8_10_legacy:\n");
	connectib_aba_index_print(&(ptr_struct->encode_8_10_legacy), file, indent_level + 1);

}

int connectib_aba_indexes_size(void){
	 return 48;
}

void connectib_aba_indexes_dump(const struct connectib_aba_indexes *ptr_struct, FILE* file) {
	connectib_aba_indexes_print(ptr_struct, file, 0);
}

void connectib_serdes_param_mask_per_proto_ini_pack(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx);

}

void connectib_serdes_param_mask_per_proto_ini_unpack(struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->rx = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_serdes_param_mask_per_proto_ini_print(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_param_mask_per_proto_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx                   : "U32H_FMT"\n", ptr_struct->rx);

}

int connectib_serdes_param_mask_per_proto_ini_size(void){
	 return 4;
}

void connectib_serdes_param_mask_per_proto_ini_dump(const struct connectib_serdes_param_mask_per_proto_ini *ptr_struct, FILE* file) {
	connectib_serdes_param_mask_per_proto_ini_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_dmfs_pack(const struct connectib_cmdif_ctx_dmfs *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->gc_hash_meta_ix);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->copied_dest_ctr);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->dealloc_ste_ix);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->ft_hw_ix);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ft_fw_ix);

}

void connectib_cmdif_ctx_dmfs_unpack(struct connectib_cmdif_ctx_dmfs *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->gc_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=48;
	ptr_struct->copied_dest_ctr = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=64;
	ptr_struct->dealloc_ste_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=128;
	ptr_struct->ft_hw_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=192;
	ptr_struct->ft_fw_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_dmfs_print(const struct connectib_cmdif_ctx_dmfs *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_dmfs ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gc_hash_meta_ix      : "U32H_FMT"\n", ptr_struct->gc_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copied_dest_ctr      : "UH_FMT"\n", ptr_struct->copied_dest_ctr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dealloc_ste_ix       : "U64H_FMT"\n", ptr_struct->dealloc_ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_hw_ix             : "U64H_FMT"\n", ptr_struct->ft_hw_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_fw_ix             : "U32H_FMT"\n", ptr_struct->ft_fw_ix);

}

int connectib_cmdif_ctx_dmfs_size(void){
	 return 32;
}

void connectib_cmdif_ctx_dmfs_dump(const struct connectib_cmdif_ctx_dmfs *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_dmfs_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_create_mtt_pack(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mtt_ix);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_mtts);

}

void connectib_cmdif_ctx_create_mtt_unpack(struct connectib_cmdif_ctx_create_mtt *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->mtt_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->num_mtts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_create_mtt_print(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_create_mtt ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_ix               : "U64H_FMT"\n", ptr_struct->mtt_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_mtts             : "U32H_FMT"\n", ptr_struct->num_mtts);

}

int connectib_cmdif_ctx_create_mtt_size(void){
	 return 32;
}

void connectib_cmdif_ctx_create_mtt_dump(const struct connectib_cmdif_ctx_create_mtt *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_create_mtt_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_psv_pack(const struct connectib_cmdif_ctx_psv *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_psv);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_alloced_psv);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->pd);

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(128, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->psv_ix[i]);
	}

}

void connectib_cmdif_ctx_psv_unpack(struct connectib_cmdif_ctx_psv *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->num_psv = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->num_alloced_psv = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->pd = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(128, 32, i, 256, 1);
	ptr_struct->psv_ix[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_cmdif_ctx_psv_print(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_psv ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_psv              : "U32H_FMT"\n", ptr_struct->num_psv);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_alloced_psv      : "U32H_FMT"\n", ptr_struct->num_alloced_psv);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "U32H_FMT"\n", ptr_struct->pd);

	for (i=0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psv_ix_%03d          : "U32H_FMT"\n", i, ptr_struct->psv_ix[i]);
	}

}

int connectib_cmdif_ctx_psv_size(void){
	 return 32;
}

void connectib_cmdif_ctx_psv_dump(const struct connectib_cmdif_ctx_psv *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_psv_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_mcg_pack(const struct connectib_cmdif_ctx_mcg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mcg_index);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->gid_msb);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->gid_lsb);

}

void connectib_cmdif_ctx_mcg_unpack(struct connectib_cmdif_ctx_mcg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->mcg_index = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->gid_msb = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=128;
	ptr_struct->gid_lsb = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_cmdif_ctx_mcg_print(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_mcg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcg_index            : "U64H_FMT"\n", ptr_struct->mcg_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gid_msb              : "U64H_FMT"\n", ptr_struct->gid_msb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gid_lsb              : "U64H_FMT"\n", ptr_struct->gid_lsb);

}

int connectib_cmdif_ctx_mcg_size(void){
	 return 32;
}

void connectib_cmdif_ctx_mcg_dump(const struct connectib_cmdif_ctx_mcg *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_mcg_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_sniffer_pack(const struct connectib_cmdif_ctx_sniffer *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_0_1);

}

void connectib_cmdif_ctx_sniffer_unpack(struct connectib_cmdif_ctx_sniffer *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->port_0_1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmdif_ctx_sniffer_print(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_sniffer ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_0_1             : "UH_FMT"\n", ptr_struct->port_0_1);

}

int connectib_cmdif_ctx_sniffer_size(void){
	 return 32;
}

void connectib_cmdif_ctx_sniffer_dump(const struct connectib_cmdif_ctx_sniffer *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_sniffer_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_rmp_pack(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->bitmask);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->lwm);

}

void connectib_cmdif_ctx_special_modify_rmp_unpack(struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->bitmask = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->lwm = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_modify_rmp_print(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_rmp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bitmask              : "U64H_FMT"\n", ptr_struct->bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lwm                  : "U32H_FMT"\n", ptr_struct->lwm);

}

int connectib_cmdif_ctx_special_modify_rmp_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_modify_rmp_dump(const struct connectib_cmdif_ctx_special_modify_rmp *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_modify_rmp_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_arm_rq_pack(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->lwm);

}

void connectib_cmdif_ctx_special_arm_rq_unpack(struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->lwm = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_arm_rq_print(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_arm_rq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lwm                  : "U32H_FMT"\n", ptr_struct->lwm);

}

int connectib_cmdif_ctx_special_arm_rq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_arm_rq_dump(const struct connectib_cmdif_ctx_special_arm_rq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_arm_rq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_mkey_pack(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->hw_addr);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->octoword_actual_size_mtt);

}

void connectib_cmdif_ctx_special_mkey_unpack(struct connectib_cmdif_ctx_special_mkey *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->hw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=128;
	ptr_struct->octoword_actual_size_mtt = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_mkey_print(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_mkey ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_addr              : "U64H_FMT"\n", ptr_struct->hw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : "U64H_FMT"\n", ptr_struct->fw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "octoword_actual_size_mtt : "U32H_FMT"\n", ptr_struct->octoword_actual_size_mtt);

}

int connectib_cmdif_ctx_special_mkey_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_mkey_dump(const struct connectib_cmdif_ctx_special_mkey *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_mkey_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_cq_pack(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->mtt_ix);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->producer_index);

	offset=127;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cqe_128b_size);

	offset=122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log2_size);

	offset=117;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=111;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->cq_page_offset);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fence_slice);

}

void connectib_cmdif_ctx_special_modify_cq_unpack(struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->mtt_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=72;
	ptr_struct->producer_index = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=127;
	ptr_struct->cqe_128b_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=122;
	ptr_struct->log2_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=117;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=111;
	ptr_struct->cq_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=128;
	ptr_struct->fence_slice = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_modify_cq_print(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_cq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_ix               : "U64H_FMT"\n", ptr_struct->mtt_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "producer_index       : "UH_FMT"\n", ptr_struct->producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cqe_128b_size        : "UH_FMT"\n", ptr_struct->cqe_128b_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_size            : "UH_FMT"\n", ptr_struct->log2_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_page_offset       : "UH_FMT"\n", ptr_struct->cq_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fence_slice          : "U32H_FMT"\n", ptr_struct->fence_slice);

}

int connectib_cmdif_ctx_special_modify_cq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_modify_cq_dump(const struct connectib_cmdif_ctx_special_modify_cq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_modify_cq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_cq_pack(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

}

void connectib_cmdif_ctx_special_create_cq_unpack(struct connectib_cmdif_ctx_special_create_cq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_cmdif_ctx_special_create_cq_print(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_cq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : "U64H_FMT"\n", ptr_struct->fw_addr);

}

int connectib_cmdif_ctx_special_create_cq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_cq_dump(const struct connectib_cmdif_ctx_special_create_cq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_cq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_eq_pack(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_eqc_addr);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->hw_eqc_addr);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->event_bitmask);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hw_eqn);

}

void connectib_cmdif_ctx_special_create_eq_unpack(struct connectib_cmdif_ctx_special_create_eq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->fw_eqc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->hw_eqc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=128;
	ptr_struct->event_bitmask = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=192;
	ptr_struct->hw_eqn = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_eq_print(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_eq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_eqc_addr          : "U64H_FMT"\n", ptr_struct->fw_eqc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_eqc_addr          : "U64H_FMT"\n", ptr_struct->hw_eqc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "event_bitmask        : "U64H_FMT"\n", ptr_struct->event_bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_eqn               : "U32H_FMT"\n", ptr_struct->hw_eqn);

}

int connectib_cmdif_ctx_special_create_eq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_eq_dump(const struct connectib_cmdif_ctx_special_create_eq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_eq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_rqt_pack(const struct connectib_cmdif_ctx_rqt *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rqt_fw_data_ix);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rqt_hw_data_ix);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_rqs_to_dec);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_max_size);

	offset=176;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_actual_size);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rqt_actual_size_old);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rqt_fw_data_ix_old);

}

void connectib_cmdif_ctx_rqt_unpack(struct connectib_cmdif_ctx_rqt *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->rqt_fw_data_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->rqt_hw_data_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->num_rqs_to_dec = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->rqt_max_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=176;
	ptr_struct->rqt_actual_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=160;
	ptr_struct->rqt_actual_size_old = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rqt_fw_data_ix_old = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_rqt_print(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_rqt ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_fw_data_ix       : "U32H_FMT"\n", ptr_struct->rqt_fw_data_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_hw_data_ix       : "U32H_FMT"\n", ptr_struct->rqt_hw_data_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_rqs_to_dec       : "U32H_FMT"\n", ptr_struct->num_rqs_to_dec);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_max_size         : "UH_FMT"\n", ptr_struct->rqt_max_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_actual_size      : "UH_FMT"\n", ptr_struct->rqt_actual_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_actual_size_old  : "UH_FMT"\n", ptr_struct->rqt_actual_size_old);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_fw_data_ix_old   : "U32H_FMT"\n", ptr_struct->rqt_fw_data_ix_old);

}

int connectib_cmdif_ctx_rqt_size(void){
	 return 32;
}

void connectib_cmdif_ctx_rqt_dump(const struct connectib_cmdif_ctx_rqt *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_rqt_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_srq_pack(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_addr);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srqi);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cont_srq);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->pas_offset);

}

void connectib_cmdif_ctx_special_create_srq_unpack(struct connectib_cmdif_ctx_special_create_srq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->fw_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=72;
	ptr_struct->srqi = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->cont_srq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->pas_offset = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_srq_print(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_srq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_addr              : "U64H_FMT"\n", ptr_struct->fw_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srqi                 : "UH_FMT"\n", ptr_struct->srqi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cont_srq             : "UH_FMT"\n", ptr_struct->cont_srq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_offset           : "U32H_FMT"\n", ptr_struct->pas_offset);

}

int connectib_cmdif_ctx_special_create_srq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_srq_dump(const struct connectib_cmdif_ctx_special_create_srq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_srq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_rq_pack(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_qpc_addr);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->no_lro_qpn);

	offset=123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_max_qp);

	offset=116;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->wq_type);

}

void connectib_cmdif_ctx_special_create_rq_unpack(struct connectib_cmdif_ctx_special_create_rq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->fw_qpc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->no_lro_qpn = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=123;
	ptr_struct->log_max_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=116;
	ptr_struct->wq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_rq_print(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_rq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_addr          : "U64H_FMT"\n", ptr_struct->fw_qpc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_lro_qpn           : "U32H_FMT"\n", ptr_struct->no_lro_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_qp           : "UH_FMT"\n", ptr_struct->log_max_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_type              : "UH_FMT"\n", ptr_struct->wq_type);

}

int connectib_cmdif_ctx_special_create_rq_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_rq_dump(const struct connectib_cmdif_ctx_special_create_rq *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_rq_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_qp_pack(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->fw_qpc_addr);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qpi);

	offset=123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_max_qp);

	offset=122;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_dci);

}

void connectib_cmdif_ctx_special_create_qp_unpack(struct connectib_cmdif_ctx_special_create_qp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->fw_qpc_addr = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->qpi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=123;
	ptr_struct->log_max_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=122;
	ptr_struct->is_dci = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmdif_ctx_special_create_qp_print(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create_qp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_addr          : "U64H_FMT"\n", ptr_struct->fw_qpc_addr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpi                  : "U32H_FMT"\n", ptr_struct->qpi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_qp           : "UH_FMT"\n", ptr_struct->log_max_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_dci               : "UH_FMT"\n", ptr_struct->is_dci);

}

int connectib_cmdif_ctx_special_create_qp_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_qp_dump(const struct connectib_cmdif_ctx_special_create_qp *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_qp_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_modify_tir_pack(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->bitmask);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->ste_ix);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rqt_number);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->old_rqt_number);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->inline_rqn);

	offset=196;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disp_type);

}

void connectib_cmdif_ctx_special_modify_tir_unpack(struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->bitmask = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->ste_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=168;
	ptr_struct->old_rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->inline_rqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=196;
	ptr_struct->disp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_modify_tir_print(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_modify_tir ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bitmask              : "U64H_FMT"\n", ptr_struct->bitmask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ste_ix               : "U64H_FMT"\n", ptr_struct->ste_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_number           : "UH_FMT"\n", ptr_struct->rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "old_rqt_number       : "UH_FMT"\n", ptr_struct->old_rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_rqn           : "UH_FMT"\n", ptr_struct->inline_rqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disp_type            : "UH_FMT"\n", ptr_struct->disp_type);

}

int connectib_cmdif_ctx_special_modify_tir_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_modify_tir_dump(const struct connectib_cmdif_ctx_special_modify_tir *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_modify_tir_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_create_pack(const struct connectib_cmdif_ctx_special_create *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_mapped_mtts);

}

void connectib_cmdif_ctx_special_create_unpack(struct connectib_cmdif_ctx_special_create *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->num_mapped_mtts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_cmdif_ctx_special_create_print(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special_create ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_mapped_mtts      : "U32H_FMT"\n", ptr_struct->num_mapped_mtts);

}

int connectib_cmdif_ctx_special_create_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_create_dump(const struct connectib_cmdif_ctx_special_create *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_create_print(ptr_struct, file, 0);
}

void connectib_flush_type_bitmask_pack(const struct connectib_flush_type_bitmask *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dword);

}

void connectib_flush_type_bitmask_unpack(struct connectib_flush_type_bitmask *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dword = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_flush_type_bitmask_print(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flush_type_bitmask ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword                : "U32H_FMT"\n", ptr_struct->dword);

}

int connectib_flush_type_bitmask_size(void){
	 return 4;
}

void connectib_flush_type_bitmask_dump(const struct connectib_flush_type_bitmask *ptr_struct, FILE* file) {
	connectib_flush_type_bitmask_print(ptr_struct, file, 0);
}

void connectib_flush_type_bits_pack(const struct connectib_flush_type_bits *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mkey_flush);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_s_flush);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_r_flush);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_flush);

}

void connectib_flush_type_bits_unpack(struct connectib_flush_type_bits *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->mkey_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->qp_s_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->qp_r_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->rx_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_flush_type_bits_print(const struct connectib_flush_type_bits *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flush_type_bits ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mkey_flush           : "UH_FMT"\n", ptr_struct->mkey_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_s_flush           : "UH_FMT"\n", ptr_struct->qp_s_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_r_flush           : "UH_FMT"\n", ptr_struct->qp_r_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_flush             : "UH_FMT"\n", ptr_struct->rx_flush);

}

int connectib_flush_type_bits_size(void){
	 return 4;
}

void connectib_flush_type_bits_dump(const struct connectib_flush_type_bits *ptr_struct, FILE* file) {
	connectib_flush_type_bits_print(ptr_struct, file, 0);
}

void connectib_project_nvqc_pack(const struct connectib_project_nvqc *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_nv_tlv_type_pack(&(ptr_struct->type), ptr_buff + offset/8);

	offset=63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->support_rd);

	offset=62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->support_wr);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->version);

}

void connectib_project_nvqc_unpack(struct connectib_project_nvqc *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_nv_tlv_type_unpack(&(ptr_struct->type), ptr_buff + offset/8);

	offset=63;
	ptr_struct->support_rd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=62;
	ptr_struct->support_wr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_project_nvqc_print(const struct connectib_project_nvqc *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvqc ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type:\n");
	connectib_nv_tlv_type_print(&(ptr_struct->type), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "support_rd           : "UH_FMT"\n", ptr_struct->support_rd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "support_wr           : "UH_FMT"\n", ptr_struct->support_wr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version              : "UH_FMT"\n", ptr_struct->version);

}

int connectib_project_nvqc_size(void){
	 return 8;
}

void connectib_project_nvqc_dump(const struct connectib_project_nvqc *ptr_struct, FILE* file) {
	connectib_project_nvqc_print(ptr_struct, file, 0);
}

void connectib_project_nvda_pack(const struct connectib_project_nvda *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_nv_tlv_hdr_pack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset=96;
	connectib_register_access_data_pack(&(ptr_struct->nvda_data), ptr_buff + offset/8);

}

void connectib_project_nvda_unpack(struct connectib_project_nvda *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_nv_tlv_hdr_unpack(&(ptr_struct->tlv_header), ptr_buff + offset/8);

	offset=96;
	connectib_register_access_data_unpack(&(ptr_struct->nvda_data), ptr_buff + offset/8);

}

void connectib_project_nvda_print(const struct connectib_project_nvda *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_nvda ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tlv_header:\n");
	connectib_nv_tlv_hdr_print(&(ptr_struct->tlv_header), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "nvda_data:\n");
	connectib_register_access_data_print(&(ptr_struct->nvda_data), file, indent_level + 1);

}

int connectib_project_nvda_size(void){
	 return 44;
}

void connectib_project_nvda_dump(const struct connectib_project_nvda *ptr_struct, FILE* file) {
	connectib_project_nvda_print(ptr_struct, file, 0);
}

void connectib_pmtu_reg_pack(const struct connectib_pmtu_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_mtu);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->admin_mtu);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->oper_mtu);

}

void connectib_pmtu_reg_unpack(struct connectib_pmtu_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=32;
	ptr_struct->max_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=64;
	ptr_struct->admin_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->oper_mtu = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_pmtu_reg_print(const struct connectib_pmtu_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pmtu_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : "UH_FMT"\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_mtu              : "UH_FMT"\n", ptr_struct->max_mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "admin_mtu            : "UH_FMT"\n", ptr_struct->admin_mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oper_mtu             : "UH_FMT"\n", ptr_struct->oper_mtu);

}

int connectib_pmtu_reg_size(void){
	 return 16;
}

void connectib_pmtu_reg_dump(const struct connectib_pmtu_reg *ptr_struct, FILE* file) {
	connectib_pmtu_reg_print(ptr_struct, file, 0);
}

void connectib_pamp_reg_pack(const struct connectib_pamp_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pamp_reg_unpack(struct connectib_pamp_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_pamp_reg_print(const struct connectib_pamp_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pamp_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_pamp_reg_size(void){
	 return 44;
}

void connectib_pamp_reg_dump(const struct connectib_pamp_reg *ptr_struct, FILE* file) {
	connectib_pamp_reg_print(ptr_struct, file, 0);
}

void connectib_slrg_reg_pack(const struct connectib_slrg_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrg_reg_unpack(struct connectib_slrg_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrg_reg_print(const struct connectib_slrg_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_slrg_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_slrg_reg_size(void){
	 return 40;
}

void connectib_slrg_reg_dump(const struct connectib_slrg_reg *ptr_struct, FILE* file) {
	connectib_slrg_reg_print(ptr_struct, file, 0);
}

void connectib_ptas_reg_pack(const struct connectib_ptas_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ptas_reg_unpack(struct connectib_ptas_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_ptas_reg_print(const struct connectib_ptas_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ptas_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_ptas_reg_size(void){
	 return 44;
}

void connectib_ptas_reg_dump(const struct connectib_ptas_reg *ptr_struct, FILE* file) {
	connectib_ptas_reg_print(ptr_struct, file, 0);
}

void connectib_sltp_reg_pack(const struct connectib_sltp_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_sltp_reg_unpack(struct connectib_sltp_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_sltp_reg_print(const struct connectib_sltp_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sltp_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_sltp_reg_size(void){
	 return 20;
}

void connectib_sltp_reg_dump(const struct connectib_sltp_reg *ptr_struct, FILE* file) {
	connectib_sltp_reg_print(ptr_struct, file, 0);
}

void connectib_slrp_reg_pack(const struct connectib_slrp_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrp_reg_unpack(struct connectib_slrp_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_slrp_reg_print(const struct connectib_slrp_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_slrp_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_slrp_reg_size(void){
	 return 40;
}

void connectib_slrp_reg_dump(const struct connectib_slrp_reg *ptr_struct, FILE* file) {
	connectib_slrp_reg_print(ptr_struct, file, 0);
}

void connectib_paos_reg_pack(const struct connectib_paos_reg *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->oper_status);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->admin_status);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->local_port);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->swid);

	offset=62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->e);

	offset=33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ee);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ase);

}

void connectib_paos_reg_unpack(struct connectib_paos_reg *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->oper_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=20;
	ptr_struct->admin_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=8;
	ptr_struct->local_port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->swid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=62;
	ptr_struct->e = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=33;
	ptr_struct->ee = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->ase = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_paos_reg_print(const struct connectib_paos_reg *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_paos_reg ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oper_status          : "UH_FMT"\n", ptr_struct->oper_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "admin_status         : "UH_FMT"\n", ptr_struct->admin_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_port           : "UH_FMT"\n", ptr_struct->local_port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swid                 : "UH_FMT"\n", ptr_struct->swid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e                    : "UH_FMT"\n", ptr_struct->e);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ee                   : "UH_FMT"\n", ptr_struct->ee);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ase                  : "UH_FMT"\n", ptr_struct->ase);

}

int connectib_paos_reg_size(void){
	 return 16;
}

void connectib_paos_reg_dump(const struct connectib_paos_reg *ptr_struct, FILE* file) {
	connectib_paos_reg_print(ptr_struct, file, 0);
}

void connectib_mjtag_pack(const struct connectib_mjtag *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->size);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sequence_number);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->cmd);

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(32, 32, i, 352, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dword[i]);
	}

}

void connectib_mjtag_unpack(struct connectib_mjtag *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=4;
	ptr_struct->sequence_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=0;
	ptr_struct->cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	for (i=0; i < 10; i++) {
	offset=adb2c_calc_array_field_address(32, 32, i, 352, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_mjtag_print(const struct connectib_mjtag *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mjtag ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sequence_number      : "UH_FMT"\n", ptr_struct->sequence_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cmd                  : "UH_FMT"\n", ptr_struct->cmd);

	for (i=0; i < 10; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : "U32H_FMT"\n", i, ptr_struct->dword[i]);
	}

}

int connectib_mjtag_size(void){
	 return 44;
}

void connectib_mjtag_dump(const struct connectib_mjtag *ptr_struct, FILE* file) {
	connectib_mjtag_print(ptr_struct, file, 0);
}

void connectib_mfbe_pack(const struct connectib_mfbe *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

}

void connectib_mfbe_unpack(struct connectib_mfbe *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=72;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_mfbe_print(const struct connectib_mfbe *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfbe ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : "UH_FMT"\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : "UH_FMT"\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : "UH_FMT"\n", ptr_struct->address);

}

int connectib_mfbe_size(void){
	 return 12;
}

void connectib_mfbe_dump(const struct connectib_mfbe *ptr_struct, FILE* file) {
	connectib_mfbe_print(ptr_struct, file, 0);
}

void connectib_project_mfba_pack(const struct connectib_project_mfba *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_mfba_header_pack(&(ptr_struct->mfba_header), ptr_buff + offset/8);

	offset=96;
	connectib_register_access_data_pack(&(ptr_struct->mfba_data), ptr_buff + offset/8);

}

void connectib_project_mfba_unpack(struct connectib_project_mfba *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_mfba_header_unpack(&(ptr_struct->mfba_header), ptr_buff + offset/8);

	offset=96;
	connectib_register_access_data_unpack(&(ptr_struct->mfba_data), ptr_buff + offset/8);

}

void connectib_project_mfba_print(const struct connectib_project_mfba *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_project_mfba ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfba_header:\n");
	connectib_mfba_header_print(&(ptr_struct->mfba_header), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfba_data:\n");
	connectib_register_access_data_print(&(ptr_struct->mfba_data), file, indent_level + 1);

}

int connectib_project_mfba_size(void){
	 return 44;
}

void connectib_project_mfba_dump(const struct connectib_project_mfba *ptr_struct, FILE* file) {
	connectib_project_mfba_print(ptr_struct, file, 0);
}

void connectib_register_misc_counters_pack(const struct connectib_register_misc_counters *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->counter_select);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ecc);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ldb_silent_drop);

}

void connectib_register_misc_counters_unpack(struct connectib_register_misc_counters *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=32;
	ptr_struct->counter_select = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->ecc = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->ldb_silent_drop = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_register_misc_counters_print(const struct connectib_register_misc_counters *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_misc_counters ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_select       : "U32H_FMT"\n", ptr_struct->counter_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecc                  : "U32H_FMT"\n", ptr_struct->ecc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ldb_silent_drop      : "U32H_FMT"\n", ptr_struct->ldb_silent_drop);

}

int connectib_register_misc_counters_size(void){
	 return 32;
}

void connectib_register_misc_counters_dump(const struct connectib_register_misc_counters *ptr_struct, FILE* file) {
	connectib_register_misc_counters_print(ptr_struct, file, 0);
}

void connectib_mtmp_pack(const struct connectib_mtmp *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->sensor_index);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->internal_diodes_query);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_temperture);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mtr);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mte);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature_threshold_hi);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->tee);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->temperature_threshold_lo);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->name_lo);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->name_hi);

}

void connectib_mtmp_unpack(struct connectib_mtmp *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=25;
	ptr_struct->sensor_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=0;
	ptr_struct->internal_diodes_query = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->temperature = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=80;
	ptr_struct->max_temperture = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=65;
	ptr_struct->mtr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->mte = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->temperature_threshold_hi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->tee = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=144;
	ptr_struct->temperature_threshold_lo = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=160;
	ptr_struct->name_lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->name_hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mtmp_print(const struct connectib_mtmp *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mtmp ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sensor_index         : "UH_FMT"\n", ptr_struct->sensor_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "internal_diodes_query : "UH_FMT"\n", ptr_struct->internal_diodes_query);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature          : "UH_FMT"\n", ptr_struct->temperature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_temperture       : "UH_FMT"\n", ptr_struct->max_temperture);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtr                  : "UH_FMT"\n", ptr_struct->mtr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mte                  : "UH_FMT"\n", ptr_struct->mte);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature_threshold_hi : "UH_FMT"\n", ptr_struct->temperature_threshold_hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tee                  : "UH_FMT"\n", ptr_struct->tee);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "temperature_threshold_lo : "UH_FMT"\n", ptr_struct->temperature_threshold_lo);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "name_lo              : "U32H_FMT"\n", ptr_struct->name_lo);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "name_hi              : "U32H_FMT"\n", ptr_struct->name_hi);

}

int connectib_mtmp_size(void){
	 return 28;
}

void connectib_mtmp_dump(const struct connectib_mtmp *ptr_struct, FILE* file) {
	connectib_mtmp_print(ptr_struct, file, 0);
}

void connectib_register_mfrl_pack(const struct connectib_register_mfrl *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->reset_level);

}

void connectib_register_mfrl_unpack(struct connectib_register_mfrl *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=56;
	ptr_struct->reset_level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_mfrl_print(const struct connectib_register_mfrl *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfrl ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reset_level          : "UH_FMT"\n", ptr_struct->reset_level);

}

int connectib_register_mfrl_size(void){
	 return 16;
}

void connectib_register_mfrl_dump(const struct connectib_register_mfrl *ptr_struct, FILE* file) {
	connectib_register_mfrl_print(ptr_struct, file, 0);
}

void connectib_register_mfai_pack(const struct connectib_register_mfai *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->address);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->permanent);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->use_address);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->use_image_id);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->image_id);

}

void connectib_register_mfai_unpack(struct connectib_register_mfai *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=2;
	ptr_struct->permanent = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->use_address = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->use_image_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->image_id = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_register_mfai_print(const struct connectib_register_mfai *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_register_mfai ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "address              : "UH_FMT"\n", ptr_struct->address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "permanent            : "UH_FMT"\n", ptr_struct->permanent);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "use_address          : "UH_FMT"\n", ptr_struct->use_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "use_image_id         : "UH_FMT"\n", ptr_struct->use_image_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "image_id             : "UH_FMT"\n", ptr_struct->image_id);

}

int connectib_register_mfai_size(void){
	 return 16;
}

void connectib_register_mfai_dump(const struct connectib_register_mfai *ptr_struct, FILE* file) {
	connectib_register_mfai_print(ptr_struct, file, 0);
}

void connectib_mfpa_pack(const struct connectib_mfpa *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->fs);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->p);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->boot_address);

	offset=156;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->flash_num);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wip);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->jedec_id);

	offset=214;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->sector_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->block_allignment);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->block_size);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->capability_mask);

}

void connectib_mfpa_unpack(struct connectib_mfpa *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->fs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->p = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=40;
	ptr_struct->boot_address = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=156;
	ptr_struct->flash_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->wip = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->jedec_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=214;
	ptr_struct->sector_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=200;
	ptr_struct->block_allignment = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=192;
	ptr_struct->block_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=224;
	ptr_struct->capability_mask = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_mfpa_print(const struct connectib_mfpa *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mfpa ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fs                   : "UH_FMT"\n", ptr_struct->fs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "p                    : "UH_FMT"\n", ptr_struct->p);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "boot_address         : "UH_FMT"\n", ptr_struct->boot_address);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flash_num            : "UH_FMT"\n", ptr_struct->flash_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wip                  : "UH_FMT"\n", ptr_struct->wip);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "jedec_id             : "UH_FMT"\n", ptr_struct->jedec_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sector_size          : "UH_FMT"\n", ptr_struct->sector_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "block_allignment     : "UH_FMT"\n", ptr_struct->block_allignment);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "block_size           : "UH_FMT"\n", ptr_struct->block_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "capability_mask      : "U32H_FMT"\n", ptr_struct->capability_mask);

}

int connectib_mfpa_size(void){
	 return 32;
}

void connectib_mfpa_dump(const struct connectib_mfpa *ptr_struct, FILE* file) {
	connectib_mfpa_print(ptr_struct, file, 0);
}

void connectib_ib_gid_pack(const struct connectib_ib_gid *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 128, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dword[i]);
	}

}

void connectib_ib_gid_unpack(struct connectib_ib_gid *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 4; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 128, 1);
	ptr_struct->dword[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_ib_gid_print(const struct connectib_ib_gid *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ib_gid ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 4; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dword_%03d           : "U32H_FMT"\n", i, ptr_struct->dword[i]);
	}

}

int connectib_ib_gid_size(void){
	 return 16;
}

void connectib_ib_gid_dump(const struct connectib_ib_gid *ptr_struct, FILE* file) {
	connectib_ib_gid_print(ptr_struct, file, 0);
}

void connectib_dmfs_hash_meta_pack(const struct connectib_dmfs_hash_meta *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log_hash_entries);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->entry_count);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->descendant_count);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->default_ste_ix);

}

void connectib_dmfs_hash_meta_unpack(struct connectib_dmfs_hash_meta *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->log_hash_entries = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=48;
	ptr_struct->entry_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=32;
	ptr_struct->descendant_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=64;
	ptr_struct->default_ste_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_dmfs_hash_meta_print(const struct connectib_dmfs_hash_meta *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_hash_meta ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_hash_entries     : "UH_FMT"\n", ptr_struct->log_hash_entries);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "entry_count          : "UH_FMT"\n", ptr_struct->entry_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "descendant_count     : "UH_FMT"\n", ptr_struct->descendant_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "default_ste_ix       : "U64H_FMT"\n", ptr_struct->default_ste_ix);

}

int connectib_dmfs_hash_meta_size(void){
	 return 16;
}

void connectib_dmfs_hash_meta_dump(const struct connectib_dmfs_hash_meta *ptr_struct, FILE* file) {
	connectib_dmfs_hash_meta_print(ptr_struct, file, 0);
}

void connectib_dmfs_fte_meta_pack(const struct connectib_dmfs_fte_meta *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->dest_iter_ix);

}

void connectib_dmfs_fte_meta_unpack(struct connectib_dmfs_fte_meta *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dest_iter_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_dmfs_fte_meta_print(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_fte_meta ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dest_iter_ix         : "U64H_FMT"\n", ptr_struct->dest_iter_ix);

}

int connectib_dmfs_fte_meta_size(void){
	 return 8;
}

void connectib_dmfs_fte_meta_dump(const struct connectib_dmfs_fte_meta *ptr_struct, FILE* file) {
	connectib_dmfs_fte_meta_print(ptr_struct, file, 0);
}

void connectib_dmfs_ft_meta_pack(const struct connectib_dmfs_ft_meta *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->log2_table_size);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->level);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->other_vport);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_number);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->groups_list_head);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->total_ref_count);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->iter_rule_count);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->groups_member_count);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->ft_head_ix);

}

void connectib_dmfs_ft_meta_unpack(struct connectib_dmfs_ft_meta *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=16;
	ptr_struct->log2_table_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=48;
	ptr_struct->other_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->vport_number = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->groups_list_head = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=144;
	ptr_struct->total_ref_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->iter_rule_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=160;
	ptr_struct->groups_member_count = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->ft_head_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_dmfs_ft_meta_print(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_ft_meta ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : "UH_FMT"\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_table_size      : "UH_FMT"\n", ptr_struct->log2_table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "valid                : "UH_FMT"\n", ptr_struct->valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "level                : "UH_FMT"\n", ptr_struct->level);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "other_vport          : "UH_FMT"\n", ptr_struct->other_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_number         : "UH_FMT"\n", ptr_struct->vport_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "groups_list_head     : "U32H_FMT"\n", ptr_struct->groups_list_head);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_ref_count      : "UH_FMT"\n", ptr_struct->total_ref_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "iter_rule_count      : "UH_FMT"\n", ptr_struct->iter_rule_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "groups_member_count  : "U32H_FMT"\n", ptr_struct->groups_member_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ft_head_ix           : "U64H_FMT"\n", ptr_struct->ft_head_ix);

}

int connectib_dmfs_ft_meta_size(void){
	 return 32;
}

void connectib_dmfs_ft_meta_dump(const struct connectib_dmfs_ft_meta *ptr_struct, FILE* file) {
	connectib_dmfs_ft_meta_print(ptr_struct, file, 0);
}

void connectib_dmfs_group_meta_pack(const struct connectib_dmfs_group_meta *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->table_type);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->table_id);

	offset=88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->match_criteria_enable);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->other_vport);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vport_number);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->start_flow_index);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->end_flow_index);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->prev_group_id);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->next_group_id);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->root_hash_meta_ix);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->end_ste_ix);

}

void connectib_dmfs_group_meta_unpack(struct connectib_dmfs_group_meta *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=56;
	ptr_struct->table_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=32;
	ptr_struct->table_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=88;
	ptr_struct->match_criteria_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=80;
	ptr_struct->other_vport = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->vport_number = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->start_flow_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->end_flow_index = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->prev_group_id = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->next_group_id = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->root_hash_meta_ix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->end_ste_ix = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_dmfs_group_meta_print(const struct connectib_dmfs_group_meta *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dmfs_group_meta ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_type           : "UH_FMT"\n", ptr_struct->table_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_id             : "UH_FMT"\n", ptr_struct->table_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "match_criteria_enable : "UH_FMT"\n", ptr_struct->match_criteria_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "other_vport          : "UH_FMT"\n", ptr_struct->other_vport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_number         : "UH_FMT"\n", ptr_struct->vport_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "start_flow_index     : "U32H_FMT"\n", ptr_struct->start_flow_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "end_flow_index       : "U32H_FMT"\n", ptr_struct->end_flow_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prev_group_id        : "U32H_FMT"\n", ptr_struct->prev_group_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_group_id        : "U32H_FMT"\n", ptr_struct->next_group_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "root_hash_meta_ix    : "U32H_FMT"\n", ptr_struct->root_hash_meta_ix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "end_ste_ix           : "U64H_FMT"\n", ptr_struct->end_ste_ix);

}

int connectib_dmfs_group_meta_size(void){
	 return 64;
}

void connectib_dmfs_group_meta_dump(const struct connectib_dmfs_group_meta *ptr_struct, FILE* file) {
	connectib_dmfs_group_meta_print(ptr_struct, file, 0);
}

void connectib_mkey_dump_pack(const struct connectib_mkey_dump *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ready_4_dump);

}

void connectib_mkey_dump_unpack(struct connectib_mkey_dump *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->ready_4_dump = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_mkey_dump_print(const struct connectib_mkey_dump *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mkey_dump ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ready_4_dump         : "UH_FMT"\n", ptr_struct->ready_4_dump);

}

int connectib_mkey_dump_size(void){
	 return 4;
}

void connectib_mkey_dump_dump(const struct connectib_mkey_dump *ptr_struct, FILE* file) {
	connectib_mkey_dump_print(ptr_struct, file, 0);
}

void connectib_fw_tis_pack(const struct connectib_fw_tis *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->prio);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->sqn_head);

}

void connectib_fw_tis_unpack(struct connectib_fw_tis *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=48;
	ptr_struct->prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->sqn_head = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_fw_tis_print(const struct connectib_fw_tis *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_tis ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prio                 : "UH_FMT"\n", ptr_struct->prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn_head             : "UH_FMT"\n", ptr_struct->sqn_head);

}

int connectib_fw_tis_size(void){
	 return 64;
}

void connectib_fw_tis_dump(const struct connectib_fw_tis *ptr_struct, FILE* file) {
	connectib_fw_tis_print(ptr_struct, file, 0);
}

void connectib_fw_tir_pack(const struct connectib_fw_tir *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->inline_rqn);

	offset=36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disp_type);

	offset=88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->lro_max_ip_payload_size);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->lro_enable_mask);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->lro_timeout_period_usecs);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rqt_number);

	offset=100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rx_hash_fn);

	offset=99;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tunneled_offload_en);

	offset=97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_hash_symmetric);

	offset=128;
	connectib_rx_hash_field_select_pack(&(ptr_struct->rx_hash_field_selector_outer), ptr_buff + offset/8);

	offset=160;
	connectib_rx_hash_field_select_pack(&(ptr_struct->rx_hash_field_selector_inner), ptr_buff + offset/8);

	offset=384;
	connectib_tir_dmfs_pack(&(ptr_struct->dmfs), ptr_buff + offset/8);

}

void connectib_fw_tir_unpack(struct connectib_fw_tir *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=40;
	ptr_struct->inline_rqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=36;
	ptr_struct->disp_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=88;
	ptr_struct->lro_max_ip_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=84;
	ptr_struct->lro_enable_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->lro_timeout_period_usecs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=104;
	ptr_struct->rqt_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=100;
	ptr_struct->rx_hash_fn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=99;
	ptr_struct->tunneled_offload_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=97;
	ptr_struct->rx_hash_symmetric = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=128;
	connectib_rx_hash_field_select_unpack(&(ptr_struct->rx_hash_field_selector_outer), ptr_buff + offset/8);

	offset=160;
	connectib_rx_hash_field_select_unpack(&(ptr_struct->rx_hash_field_selector_inner), ptr_buff + offset/8);

	offset=384;
	connectib_tir_dmfs_unpack(&(ptr_struct->dmfs), ptr_buff + offset/8);

}

void connectib_fw_tir_print(const struct connectib_fw_tir *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_tir ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_rqn           : "UH_FMT"\n", ptr_struct->inline_rqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disp_type            : "UH_FMT"\n", ptr_struct->disp_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_max_ip_payload_size : "UH_FMT"\n", ptr_struct->lro_max_ip_payload_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_enable_mask      : "UH_FMT"\n", ptr_struct->lro_enable_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lro_timeout_period_usecs : "UH_FMT"\n", ptr_struct->lro_timeout_period_usecs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt_number           : "UH_FMT"\n", ptr_struct->rqt_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_fn           : "UH_FMT"\n", ptr_struct->rx_hash_fn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tunneled_offload_en  : "UH_FMT"\n", ptr_struct->tunneled_offload_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_symmetric    : "UH_FMT"\n", ptr_struct->rx_hash_symmetric);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_field_selector_outer:\n");
	connectib_rx_hash_field_select_print(&(ptr_struct->rx_hash_field_selector_outer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_hash_field_selector_inner:\n");
	connectib_rx_hash_field_select_print(&(ptr_struct->rx_hash_field_selector_inner), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dmfs:\n");
	connectib_tir_dmfs_print(&(ptr_struct->dmfs), file, indent_level + 1);

}

int connectib_fw_tir_size(void){
	 return 64;
}

void connectib_fw_tir_dump(const struct connectib_fw_tir *ptr_struct, FILE* file) {
	connectib_fw_tir_print(ptr_struct, file, 0);
}

void connectib_fw_qpc_pack(const struct connectib_fw_qpc *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->sw_st);

	offset=53;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->sw_rwq_type);

	offset=52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_sq);

	offset=50;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->sw_rq_type);

	offset=49;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_dual_write);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ack_fence_req);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->ack_slice_to_fence);

	offset=91;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->sw_timer_granularity);

	offset=86;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->chilling_timer_granularity);

	offset=85;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->one_side_flush);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->apm_path_validation_failed);

	offset=83;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_slave_send);

	offset=82;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_slave_receive);

	offset=81;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cd_master);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sqd_on_sigerr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->tis_num);

	offset=128;
	connectib_fw_qpc_q_pack(&(ptr_struct->responder), ptr_buff + offset/8);

	offset=256;
	connectib_fw_qpc_q_pack(&(ptr_struct->requestor), ptr_buff + offset/8);

	offset=384;
	connectib_fw_qpc_special_pack(&(ptr_struct->fw_qpc_special), ptr_buff + offset/8);

}

void connectib_fw_qpc_unpack(struct connectib_fw_qpc *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=56;
	ptr_struct->sw_st = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=53;
	ptr_struct->sw_rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=52;
	ptr_struct->no_sq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=50;
	ptr_struct->sw_rq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=49;
	ptr_struct->qp_dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->ack_fence_req = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=40;
	ptr_struct->ack_slice_to_fence = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=91;
	ptr_struct->sw_timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=86;
	ptr_struct->chilling_timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=85;
	ptr_struct->one_side_flush = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=84;
	ptr_struct->apm_path_validation_failed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=83;
	ptr_struct->cd_slave_send = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=82;
	ptr_struct->cd_slave_receive = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=81;
	ptr_struct->cd_master = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->sqd_on_sigerr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=104;
	ptr_struct->tis_num = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=128;
	connectib_fw_qpc_q_unpack(&(ptr_struct->responder), ptr_buff + offset/8);

	offset=256;
	connectib_fw_qpc_q_unpack(&(ptr_struct->requestor), ptr_buff + offset/8);

	offset=384;
	connectib_fw_qpc_special_unpack(&(ptr_struct->fw_qpc_special), ptr_buff + offset/8);

}

void connectib_fw_qpc_print(const struct connectib_fw_qpc *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_qpc ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_st                : "UH_FMT"\n", ptr_struct->sw_st);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_rwq_type          : "UH_FMT"\n", ptr_struct->sw_rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_sq                : "UH_FMT"\n", ptr_struct->no_sq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_rq_type           : "UH_FMT"\n", ptr_struct->sw_rq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_dual_write        : "UH_FMT"\n", ptr_struct->qp_dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_fence_req        : "UH_FMT"\n", ptr_struct->ack_fence_req);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_slice_to_fence   : "UH_FMT"\n", ptr_struct->ack_slice_to_fence);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sw_timer_granularity : "UH_FMT"\n", ptr_struct->sw_timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "chilling_timer_granularity : "UH_FMT"\n", ptr_struct->chilling_timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "one_side_flush       : "UH_FMT"\n", ptr_struct->one_side_flush);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "apm_path_validation_failed : "UH_FMT"\n", ptr_struct->apm_path_validation_failed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_slave_send        : "UH_FMT"\n", ptr_struct->cd_slave_send);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_slave_receive     : "UH_FMT"\n", ptr_struct->cd_slave_receive);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cd_master            : "UH_FMT"\n", ptr_struct->cd_master);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqd_on_sigerr        : "UH_FMT"\n", ptr_struct->sqd_on_sigerr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tis_num              : "UH_FMT"\n", ptr_struct->tis_num);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder:\n");
	connectib_fw_qpc_q_print(&(ptr_struct->responder), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "requestor:\n");
	connectib_fw_qpc_q_print(&(ptr_struct->requestor), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_qpc_special:\n");
	connectib_fw_qpc_special_print(&(ptr_struct->fw_qpc_special), file, indent_level + 1);

}

int connectib_fw_qpc_size(void){
	 return 64;
}

void connectib_fw_qpc_dump(const struct connectib_fw_qpc *ptr_struct, FILE* file) {
	connectib_fw_qpc_print(ptr_struct, file, 0);
}

void connectib_fw_srqc_pack(const struct connectib_fw_srqc *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_pack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->catas_event_generated);

	offset=62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->basic_cyclic_rcv_wqe);

	offset=61;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->invalid_user_index);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->trap_reason);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->trap_data);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->no_lro_qpn);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->memory_rq_state);

}

void connectib_fw_srqc_unpack(struct connectib_fw_srqc *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_fw_ref_count_unpack(&(ptr_struct->fw_ref_count), ptr_buff + offset/8);

	offset=63;
	ptr_struct->catas_event_generated = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=62;
	ptr_struct->basic_cyclic_rcv_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=61;
	ptr_struct->invalid_user_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->trap_reason = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->trap_data = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=136;
	ptr_struct->no_lro_qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=128;
	ptr_struct->memory_rq_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_fw_srqc_print(const struct connectib_fw_srqc *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_fw_srqc ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_ref_count:\n");
	connectib_fw_ref_count_print(&(ptr_struct->fw_ref_count), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "catas_event_generated : "UH_FMT"\n", ptr_struct->catas_event_generated);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "basic_cyclic_rcv_wqe : "UH_FMT"\n", ptr_struct->basic_cyclic_rcv_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "invalid_user_index   : "UH_FMT"\n", ptr_struct->invalid_user_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_reason          : %s ("UH_FMT")\n", (ptr_struct->trap_reason == 1 ? ("NOP") : ((ptr_struct->trap_reason == 2 ? ("SET_LIMIT") : ("unknown")))), ptr_struct->trap_reason);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "trap_data            : "UH_FMT"\n", ptr_struct->trap_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_lro_qpn           : "UH_FMT"\n", ptr_struct->no_lro_qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_rq_state      : "UH_FMT"\n", ptr_struct->memory_rq_state);

}

int connectib_fw_srqc_size(void){
	 return 64;
}

void connectib_fw_srqc_dump(const struct connectib_fw_srqc *ptr_struct, FILE* file) {
	connectib_fw_srqc_print(ptr_struct, file, 0);
}

void connectib_sw_ads_pack(const struct connectib_sw_ads *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->pkey_index);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->free_ar);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fl);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rlid);

	offset=41;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->mlid);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh);

	offset=88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->stat_rate);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->src_addr_index);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->ack_timeout);

	offset=108;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=100;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	for (i=0; i < 16; i++) {
	offset=adb2c_calc_array_field_address(152, 8, i, 352, 1);
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rgid_rip[i]);
	}

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->udp_sport);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->dscp);

	offset=264;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->ecn);

	offset=263;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_eth_prio);

	offset=261;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_ecn);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->f_dscp);

	offset=304;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rmac_47_32);

	offset=296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port);

	offset=292;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=289;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->eth_prio);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dei_cfi);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rmac_31_0);

}

void connectib_sw_ads_unpack(struct connectib_sw_ads *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->pkey_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=1;
	ptr_struct->free_ar = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->fl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->rlid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=41;
	ptr_struct->mlid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=40;
	ptr_struct->grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=88;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=84;
	ptr_struct->stat_rate = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->src_addr_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=64;
	ptr_struct->ack_timeout = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=108;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=100;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	for (i=0; i < 16; i++) {
	offset=adb2c_calc_array_field_address(152, 8, i, 352, 1);
	ptr_struct->rgid_rip[i] = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);
	}

	offset=272;
	ptr_struct->udp_sport = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=266;
	ptr_struct->dscp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=264;
	ptr_struct->ecn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=263;
	ptr_struct->f_eth_prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=261;
	ptr_struct->f_ecn = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->f_dscp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=304;
	ptr_struct->rmac_47_32 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=296;
	ptr_struct->port = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=292;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=289;
	ptr_struct->eth_prio = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=288;
	ptr_struct->dei_cfi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=320;
	ptr_struct->rmac_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_sw_ads_print(const struct connectib_sw_ads *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_ads ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_index           : "UH_FMT"\n", ptr_struct->pkey_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "free_ar              : "UH_FMT"\n", ptr_struct->free_ar);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fl                   : "UH_FMT"\n", ptr_struct->fl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rlid                 : "UH_FMT"\n", ptr_struct->rlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlid                 : "UH_FMT"\n", ptr_struct->mlid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh                  : "UH_FMT"\n", ptr_struct->grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "stat_rate            : %s ("UH_FMT")\n", (ptr_struct->stat_rate == 0 ? ("no_limit") : ((ptr_struct->stat_rate == 7 ? ("2_5Gbps") : ((ptr_struct->stat_rate == 8 ? ("10Gbps") : ((ptr_struct->stat_rate == 9 ? ("30Gbps") : ((ptr_struct->stat_rate == 10 ? ("5Gbps") : ((ptr_struct->stat_rate == 11 ? ("20Gbps") : ((ptr_struct->stat_rate == 12 ? ("40Gbps") : ((ptr_struct->stat_rate == 13 ? ("60Gbps") : ((ptr_struct->stat_rate == 14 ? ("80Gbps") : ((ptr_struct->stat_rate == 15 ? ("120Gbps") : ("unknown")))))))))))))))))))), ptr_struct->stat_rate);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "src_addr_index       : "UH_FMT"\n", ptr_struct->src_addr_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_timeout          : "UH_FMT"\n", ptr_struct->ack_timeout);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	for (i=0; i < 16; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rgid_rip_%03d        : "UH_FMT"\n", i, ptr_struct->rgid_rip[i]);
	}

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "udp_sport            : "UH_FMT"\n", ptr_struct->udp_sport);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dscp                 : "UH_FMT"\n", ptr_struct->dscp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecn                  : "UH_FMT"\n", ptr_struct->ecn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_eth_prio           : "UH_FMT"\n", ptr_struct->f_eth_prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_ecn                : "UH_FMT"\n", ptr_struct->f_ecn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "f_dscp               : "UH_FMT"\n", ptr_struct->f_dscp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rmac_47_32           : "UH_FMT"\n", ptr_struct->rmac_47_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port                 : "UH_FMT"\n", ptr_struct->port);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_prio             : "UH_FMT"\n", ptr_struct->eth_prio);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dei_cfi              : "UH_FMT"\n", ptr_struct->dei_cfi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rmac_31_0            : "U32H_FMT"\n", ptr_struct->rmac_31_0);

}

int connectib_sw_ads_size(void){
	 return 44;
}

void connectib_sw_ads_dump(const struct connectib_sw_ads *ptr_struct, FILE* file) {
	connectib_sw_ads_print(ptr_struct, file, 0);
}

void connectib_hw_msix_ext_context_pack(const struct connectib_hw_msix_ext_context *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->mask_3_0);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->disable_3_0);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->need);

	offset=76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->timestamp_51_32);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->min_wait);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->timestamp_31_0);

}

void connectib_hw_msix_ext_context_unpack(struct connectib_hw_msix_ext_context *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->mask_3_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=24;
	ptr_struct->disable_3_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=23;
	ptr_struct->need = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=76;
	ptr_struct->timestamp_51_32 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=64;
	ptr_struct->min_wait = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=96;
	ptr_struct->timestamp_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_msix_ext_context_print(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_ext_context ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mask_3_0             : "UH_FMT"\n", ptr_struct->mask_3_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "disable_3_0          : "UH_FMT"\n", ptr_struct->disable_3_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "need                 : "UH_FMT"\n", ptr_struct->need);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timestamp_51_32      : "UH_FMT"\n", ptr_struct->timestamp_51_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "min_wait             : "UH_FMT"\n", ptr_struct->min_wait);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timestamp_31_0       : "U32H_FMT"\n", ptr_struct->timestamp_31_0);

}

int connectib_hw_msix_ext_context_size(void){
	 return 16;
}

void connectib_hw_msix_ext_context_dump(const struct connectib_hw_msix_ext_context *ptr_struct, FILE* file) {
	connectib_hw_msix_ext_context_print(ptr_struct, file, 0);
}

void connectib_hw_msix_context_pack(const struct connectib_hw_msix_context *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->addr_31_2_);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->addr_63_32_);

	offset=64;
	connectib_hw_msix_context_data_pack(&(ptr_struct->data), ptr_buff + offset/8);

	offset=127;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->spec_mask);

}

void connectib_hw_msix_context_unpack(struct connectib_hw_msix_context *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->addr_31_2_ = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

	offset=32;
	ptr_struct->addr_63_32_ = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	connectib_hw_msix_context_data_unpack(&(ptr_struct->data), ptr_buff + offset/8);

	offset=127;
	ptr_struct->spec_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_msix_context_print(const struct connectib_hw_msix_context *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_msix_context ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_31_2_           : "UH_FMT"\n", ptr_struct->addr_31_2_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_63_32_          : "U32H_FMT"\n", ptr_struct->addr_63_32_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data:\n");
	connectib_hw_msix_context_data_print(&(ptr_struct->data), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "spec_mask            : "UH_FMT"\n", ptr_struct->spec_mask);

}

int connectib_hw_msix_context_size(void){
	 return 16;
}

void connectib_hw_msix_context_dump(const struct connectib_hw_msix_context *ptr_struct, FILE* file) {
	connectib_hw_msix_context_print(ptr_struct, file, 0);
}

void connectib_hw_rdb_atomic_data_pack(const struct connectib_hw_rdb_atomic_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 8; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 256, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->atomic_data[i]);
	}

}

void connectib_hw_rdb_atomic_data_unpack(struct connectib_hw_rdb_atomic_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 8; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 256, 1);
	ptr_struct->atomic_data[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_hw_rdb_atomic_data_print(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_rdb_atomic_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 8; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_data_%03d     : "U32H_FMT"\n", i, ptr_struct->atomic_data[i]);
	}

}

int connectib_hw_rdb_atomic_data_size(void){
	 return 32;
}

void connectib_hw_rdb_atomic_data_dump(const struct connectib_hw_rdb_atomic_data *ptr_struct, FILE* file) {
	connectib_hw_rdb_atomic_data_print(ptr_struct, file, 0);
}

void connectib_hw_mtt2_pack(const struct connectib_hw_mtt2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hi);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->lo);

}

void connectib_hw_mtt2_unpack(struct connectib_hw_mtt2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_mtt2_print(const struct connectib_hw_mtt2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_mtt2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hi                   : "U32H_FMT"\n", ptr_struct->hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lo                   : "U32H_FMT"\n", ptr_struct->lo);

}

int connectib_hw_mtt2_size(void){
	 return 8;
}

void connectib_hw_mtt2_dump(const struct connectib_hw_mtt2 *ptr_struct, FILE* file) {
	connectib_hw_mtt2_print(ptr_struct, file, 0);
}

void connectib_hw_mtt_pack(const struct connectib_hw_mtt *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->pas_63_32);

	offset=63;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rd_en);

	offset=62;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wr_en);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 29, (u_int32_t)ptr_struct->pas_31_3);

}

void connectib_hw_mtt_unpack(struct connectib_hw_mtt *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->pas_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=63;
	ptr_struct->rd_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=62;
	ptr_struct->wr_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->pas_31_3 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 29);

}

void connectib_hw_mtt_print(const struct connectib_hw_mtt *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_mtt ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_63_32            : "U32H_FMT"\n", ptr_struct->pas_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rd_en                : "UH_FMT"\n", ptr_struct->rd_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wr_en                : "UH_FMT"\n", ptr_struct->wr_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pas_31_3             : "UH_FMT"\n", ptr_struct->pas_31_3);

}

int connectib_hw_mtt_size(void){
	 return 8;
}

void connectib_hw_mtt_dump(const struct connectib_hw_mtt *ptr_struct, FILE* file) {
	connectib_hw_mtt_print(ptr_struct, file, 0);
}

void connectib_steering_qp_list_pack(const struct connectib_steering_qp_list *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry0), ptr_buff + offset/8);

	offset=32;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry1), ptr_buff + offset/8);

	offset=64;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry2), ptr_buff + offset/8);

	offset=96;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry3), ptr_buff + offset/8);

	offset=128;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry4), ptr_buff + offset/8);

	offset=160;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry5), ptr_buff + offset/8);

	offset=192;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry6), ptr_buff + offset/8);

	offset=224;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry7), ptr_buff + offset/8);

	offset=256;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry8), ptr_buff + offset/8);

	offset=288;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry9), ptr_buff + offset/8);

	offset=320;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry10), ptr_buff + offset/8);

	offset=352;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry11), ptr_buff + offset/8);

	offset=384;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry12), ptr_buff + offset/8);

	offset=416;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry13), ptr_buff + offset/8);

	offset=448;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry14), ptr_buff + offset/8);

	offset=480;
	connectib_steering_qp_entry_pack(&(ptr_struct->steering_qp_entry15), ptr_buff + offset/8);

}

void connectib_steering_qp_list_unpack(struct connectib_steering_qp_list *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry0), ptr_buff + offset/8);

	offset=32;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry1), ptr_buff + offset/8);

	offset=64;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry2), ptr_buff + offset/8);

	offset=96;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry3), ptr_buff + offset/8);

	offset=128;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry4), ptr_buff + offset/8);

	offset=160;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry5), ptr_buff + offset/8);

	offset=192;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry6), ptr_buff + offset/8);

	offset=224;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry7), ptr_buff + offset/8);

	offset=256;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry8), ptr_buff + offset/8);

	offset=288;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry9), ptr_buff + offset/8);

	offset=320;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry10), ptr_buff + offset/8);

	offset=352;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry11), ptr_buff + offset/8);

	offset=384;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry12), ptr_buff + offset/8);

	offset=416;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry13), ptr_buff + offset/8);

	offset=448;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry14), ptr_buff + offset/8);

	offset=480;
	connectib_steering_qp_entry_unpack(&(ptr_struct->steering_qp_entry15), ptr_buff + offset/8);

}

void connectib_steering_qp_list_print(const struct connectib_steering_qp_list *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_steering_qp_list ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry0:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry0), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry1:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry1), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry2:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry2), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry3:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry3), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry4:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry4), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry5:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry5), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry6:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry6), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry7:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry7), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry8:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry8), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry9:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry9), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry10:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry10), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry11:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry11), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry12:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry12), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry13:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry13), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry14:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry14), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "steering_qp_entry15:\n");
	connectib_steering_qp_entry_print(&(ptr_struct->steering_qp_entry15), file, indent_level + 1);

}

int connectib_steering_qp_list_size(void){
	 return 64;
}

void connectib_steering_qp_list_dump(const struct connectib_steering_qp_list *ptr_struct, FILE* file) {
	connectib_steering_qp_list_print(ptr_struct, file, 0);
}

void connectib_hw_ste_pack(const struct connectib_hw_ste *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->member_count);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_packet_qp);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_fw_int);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rx_cmd);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pport_byte_counters_trigger);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->pport_packet_counters_trigger);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vport_byte_counters_trigger);

	offset=40;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->vport_packet_counters_trigger);

	offset=37;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_sniffer);

	offset=36;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_func_lb);

	offset=35;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_wire);

	offset=34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_fw_int);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->sx_cmd);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_lookup_type);

	offset=120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hit_lookup_type_hash_field_mask);

	offset=114;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log2_hit_entry_size);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->gvmi);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hit_base_address_63_32);

	offset=184;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hit_lookup_type);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->hit_base_address_31_8);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->miss_address_63_32);

	offset=250;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log2_hit_table_size);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 26, (u_int32_t)ptr_struct->miss_address_31_6);

	offset=256;
	connectib_hw_ste_tag_pack(&(ptr_struct->tag_data), ptr_buff + offset/8);

	offset=384;
	connectib_hw_ste_tag_pack(&(ptr_struct->tag_mask), ptr_buff + offset/8);

}

void connectib_hw_ste_unpack(struct connectib_hw_ste *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->member_count = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=3;
	ptr_struct->rx_packet_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->rx_fw_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->rx_cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=56;
	ptr_struct->pport_byte_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=48;
	ptr_struct->pport_packet_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=44;
	ptr_struct->vport_byte_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=40;
	ptr_struct->vport_packet_counters_trigger = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=37;
	ptr_struct->sx_sniffer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=36;
	ptr_struct->sx_func_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=35;
	ptr_struct->sx_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=34;
	ptr_struct->sx_fw_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->sx_cmd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=64;
	ptr_struct->my_lookup_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=120;
	ptr_struct->hit_lookup_type_hash_field_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=114;
	ptr_struct->log2_hit_entry_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=96;
	ptr_struct->gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->hit_base_address_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=184;
	ptr_struct->hit_lookup_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=160;
	ptr_struct->hit_base_address_31_8 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->miss_address_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=250;
	ptr_struct->log2_hit_table_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=224;
	ptr_struct->miss_address_31_6 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 26);

	offset=256;
	connectib_hw_ste_tag_unpack(&(ptr_struct->tag_data), ptr_buff + offset/8);

	offset=384;
	connectib_hw_ste_tag_unpack(&(ptr_struct->tag_mask), ptr_buff + offset/8);

}

void connectib_hw_ste_print(const struct connectib_hw_ste *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_ste ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "member_count         : "UH_FMT"\n", ptr_struct->member_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_packet_qp         : "UH_FMT"\n", ptr_struct->rx_packet_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_fw_int            : "UH_FMT"\n", ptr_struct->rx_fw_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_cmd               : "UH_FMT"\n", ptr_struct->rx_cmd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pport_byte_counters_trigger : "UH_FMT"\n", ptr_struct->pport_byte_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pport_packet_counters_trigger : "UH_FMT"\n", ptr_struct->pport_packet_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_byte_counters_trigger : "UH_FMT"\n", ptr_struct->vport_byte_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vport_packet_counters_trigger : "UH_FMT"\n", ptr_struct->vport_packet_counters_trigger);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_sniffer           : "UH_FMT"\n", ptr_struct->sx_sniffer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_func_lb           : "UH_FMT"\n", ptr_struct->sx_func_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_wire              : "UH_FMT"\n", ptr_struct->sx_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_fw_int            : "UH_FMT"\n", ptr_struct->sx_fw_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_cmd               : "UH_FMT"\n", ptr_struct->sx_cmd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lookup_type       : "UH_FMT"\n", ptr_struct->my_lookup_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_lookup_type_hash_field_mask : "UH_FMT"\n", ptr_struct->hit_lookup_type_hash_field_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_hit_entry_size  : "UH_FMT"\n", ptr_struct->log2_hit_entry_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "gvmi                 : "UH_FMT"\n", ptr_struct->gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_base_address_63_32 : "U32H_FMT"\n", ptr_struct->hit_base_address_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_lookup_type      : "UH_FMT"\n", ptr_struct->hit_lookup_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hit_base_address_31_8 : "UH_FMT"\n", ptr_struct->hit_base_address_31_8);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "miss_address_63_32   : "U32H_FMT"\n", ptr_struct->miss_address_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log2_hit_table_size  : "UH_FMT"\n", ptr_struct->log2_hit_table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "miss_address_31_6    : "UH_FMT"\n", ptr_struct->miss_address_31_6);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_data:\n");
	connectib_hw_ste_tag_print(&(ptr_struct->tag_data), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tag_mask:\n");
	connectib_hw_ste_tag_print(&(ptr_struct->tag_mask), file, indent_level + 1);

}

int connectib_hw_ste_size(void){
	 return 64;
}

void connectib_hw_ste_dump(const struct connectib_hw_ste *ptr_struct, FILE* file) {
	connectib_hw_ste_print(ptr_struct, file, 0);
}

void connectib_hw_timer_pack(const struct connectib_hw_timer *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->timer_granularity);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->timer_state);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->timer_valid);

}

void connectib_hw_timer_unpack(struct connectib_hw_timer *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=3;
	ptr_struct->timer_granularity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=1;
	ptr_struct->timer_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=0;
	ptr_struct->timer_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_timer_print(const struct connectib_hw_timer *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_timer ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_granularity    : "UH_FMT"\n", ptr_struct->timer_granularity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_state          : "UH_FMT"\n", ptr_struct->timer_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_valid          : "UH_FMT"\n", ptr_struct->timer_valid);

}

int connectib_hw_timer_size(void){
	 return 1;
}

void connectib_hw_timer_dump(const struct connectib_hw_timer *ptr_struct, FILE* file) {
	connectib_hw_timer_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_check_gen);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_init);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->w_pad);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->w_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->w_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->w_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_non_repeating_m_non_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : "UH_FMT"\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : "UH_FMT"\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : "UH_FMT"\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_check_gen          : "UH_FMT"\n", ptr_struct->w_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_init               : "UH_FMT"\n", ptr_struct->w_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_pad                : "UH_FMT"\n", ptr_struct->w_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_non_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_w_non_repeating_m_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_check_gen);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_init);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->w_pad);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=23;
	ptr_struct->w_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->w_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->w_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_non_repeating_m_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : "UH_FMT"\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_check_gen          : "UH_FMT"\n", ptr_struct->w_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_init               : "UH_FMT"\n", ptr_struct->w_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_pad                : "UH_FMT"\n", ptr_struct->w_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_non_repeating_m_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_w_non_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_non_repeating_m_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_w_non_repeating_m_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_block_size_selector);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=16;
	ptr_struct->w_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_repeating_m_non_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : "UH_FMT"\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : "UH_FMT"\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : "UH_FMT"\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_block_size_selector : "UH_FMT"\n", ptr_struct->w_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_repeating_m_non_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_w_repeating_m_non_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_non_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_w_repeating_m_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_w_repeating_m_repeating_pack(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_block_size_selector);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_repeating_unpack(struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=16;
	ptr_struct->w_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_w_repeating_m_repeating_print(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_w_repeating_m_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : "UH_FMT"\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_block_size_selector : "UH_FMT"\n", ptr_struct->w_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_w_repeating_m_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_w_repeating_m_repeating_dump(const struct connectib_hw_bsf_entry_w_repeating_m_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_w_repeating_m_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_same_block_non_repeating_pack(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_check_gen);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_init);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->m_pad);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->copy_byte_mask);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_non_repeating_unpack(struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->m_check_gen = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->m_init = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->m_pad = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=16;
	ptr_struct->copy_byte_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_non_repeating_print(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_same_block_non_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_check_gen          : "UH_FMT"\n", ptr_struct->m_check_gen);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_init               : "UH_FMT"\n", ptr_struct->m_init);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_pad                : "UH_FMT"\n", ptr_struct->m_pad);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copy_byte_mask       : "UH_FMT"\n", ptr_struct->copy_byte_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_same_block_non_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_same_block_non_repeating_dump(const struct connectib_hw_bsf_entry_same_block_non_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_same_block_non_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_bsf_entry_same_block_repeating_pack(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_block_size_selector);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->copy_byte_mask);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->byte_check_en);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aligned);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->size);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->raw_size);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_b_psv_pointer);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_b_pdf_ptr);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_b_psv_pointer);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_b_pdf_ptr);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->prologue_size);

	offset=135;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_end);

	offset=134;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_t_start);

	offset=131;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_end);

	offset=130;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_t_start);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->epilogue_size);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->w_t_psv_pointer);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->w_t_pdf_ptr);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->m_t_psv_pointer);

	offset=224;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->m_t_pdf_ptr);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->w_dif_app_tag);

	offset=257;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_refresh_dif_params);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->w_in_line_vld);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->w_dif_ref_tag);

	offset=320;
	connectib_hw_pdf_entry_pack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->m_dif_app_tag);

	offset=385;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_refresh_dif_params);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->m_in_line_vld);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->m_dif_ref_tag);

	offset=448;
	connectib_hw_pdf_entry_pack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_repeating_unpack(struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->m_block_size_selector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=16;
	ptr_struct->copy_byte_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=8;
	ptr_struct->byte_check_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=3;
	ptr_struct->aligned = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->raw_size = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->w_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->w_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->m_b_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=96;
	ptr_struct->m_b_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=136;
	ptr_struct->prologue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=135;
	ptr_struct->m_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=134;
	ptr_struct->m_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=131;
	ptr_struct->w_t_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=130;
	ptr_struct->w_t_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=168;
	ptr_struct->epilogue_size = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=200;
	ptr_struct->w_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=192;
	ptr_struct->w_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=232;
	ptr_struct->m_t_psv_pointer = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=224;
	ptr_struct->m_t_pdf_ptr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=272;
	ptr_struct->w_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=257;
	ptr_struct->w_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=256;
	ptr_struct->w_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=288;
	ptr_struct->w_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->w_in_line_pdf), ptr_buff + offset/8);

	offset=400;
	ptr_struct->m_dif_app_tag = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=385;
	ptr_struct->m_refresh_dif_params = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=384;
	ptr_struct->m_in_line_vld = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=416;
	ptr_struct->m_dif_ref_tag = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	connectib_hw_pdf_entry_unpack(&(ptr_struct->m_in_line_pdf), ptr_buff + offset/8);

}

void connectib_hw_bsf_entry_same_block_repeating_print(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_bsf_entry_same_block_repeating ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_block_size_selector : "UH_FMT"\n", ptr_struct->m_block_size_selector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "copy_byte_mask       : "UH_FMT"\n", ptr_struct->copy_byte_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "byte_check_en        : "UH_FMT"\n", ptr_struct->byte_check_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aligned              : "UH_FMT"\n", ptr_struct->aligned);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "size                 : "UH_FMT"\n", ptr_struct->size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "raw_size             : "U32H_FMT"\n", ptr_struct->raw_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_psv_pointer      : "UH_FMT"\n", ptr_struct->w_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_psv_pointer      : "UH_FMT"\n", ptr_struct->m_b_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_b_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_b_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prologue_size        : "UH_FMT"\n", ptr_struct->prologue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_end              : "UH_FMT"\n", ptr_struct->m_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_start            : "UH_FMT"\n", ptr_struct->m_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_end              : "UH_FMT"\n", ptr_struct->w_t_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_start            : "UH_FMT"\n", ptr_struct->w_t_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "epilogue_size        : "UH_FMT"\n", ptr_struct->epilogue_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_psv_pointer      : "UH_FMT"\n", ptr_struct->w_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->w_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_psv_pointer      : "UH_FMT"\n", ptr_struct->m_t_psv_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_t_pdf_ptr          : "UH_FMT"\n", ptr_struct->m_t_pdf_ptr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_app_tag        : "UH_FMT"\n", ptr_struct->w_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_refresh_dif_params : "UH_FMT"\n", ptr_struct->w_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_vld        : "UH_FMT"\n", ptr_struct->w_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->w_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "w_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->w_in_line_pdf), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_app_tag        : "UH_FMT"\n", ptr_struct->m_dif_app_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_refresh_dif_params : "UH_FMT"\n", ptr_struct->m_refresh_dif_params);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_vld        : "UH_FMT"\n", ptr_struct->m_in_line_vld);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_dif_ref_tag        : "U32H_FMT"\n", ptr_struct->m_dif_ref_tag);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_in_line_pdf:\n");
	connectib_hw_pdf_entry_print(&(ptr_struct->m_in_line_pdf), file, indent_level + 1);

}

int connectib_hw_bsf_entry_same_block_repeating_size(void){
	 return 64;
}

void connectib_hw_bsf_entry_same_block_repeating_dump(const struct connectib_hw_bsf_entry_same_block_repeating *ptr_struct, FILE* file) {
	connectib_hw_bsf_entry_same_block_repeating_print(ptr_struct, file, 0);
}

void connectib_hw_dct_pack(const struct connectib_hw_dct *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->complete_to_64B_eyald);

	offset=283;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=282;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=275;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->max_message_size);

	offset=274;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=273;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=272;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=269;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtu);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->dc_access_key_log_num_byte);

	offset=264;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=263;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=262;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=261;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=300;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=297;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=289;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->my_lid);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=328;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srq_number);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=372;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ipd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=392;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=384;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=424;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=416;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->dc_access_key);

}

void connectib_hw_dct_unpack(struct connectib_hw_dct *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->complete_to_64B_eyald = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=283;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=282;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=280;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=275;
	ptr_struct->max_message_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=274;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=273;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=272;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=269;
	ptr_struct->mtu = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=268;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->dc_access_key_log_num_byte = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=264;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=263;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=262;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=261;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=300;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=297;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=296;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=289;
	ptr_struct->my_lid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=288;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=328;
	ptr_struct->srq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=320;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=372;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=368;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=356;
	ptr_struct->ipd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=392;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=384;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=424;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=416;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=448;
	ptr_struct->dc_access_key = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_dct_print(const struct connectib_hw_dct *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_dct ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "complete_to_64B_eyald : "U32H_FMT"\n", ptr_struct->complete_to_64B_eyald);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size     : "UH_FMT"\n", ptr_struct->max_message_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu                  : "UH_FMT"\n", ptr_struct->mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key_log_num_byte : "UH_FMT"\n", ptr_struct->dc_access_key_log_num_byte);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid               : "UH_FMT"\n", ptr_struct->my_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number           : "UH_FMT"\n", ptr_struct->srq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd                  : "UH_FMT"\n", ptr_struct->ipd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key        : "U64H_FMT"\n", ptr_struct->dc_access_key);

}

int connectib_hw_dct_size(void){
	 return 64;
}

void connectib_hw_dct_dump(const struct connectib_hw_dct *ptr_struct, FILE* file) {
	connectib_hw_dct_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ud_l2_cd_pack(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_wire);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_gvmi);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_lb);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_lb);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drop_my_self_multicast);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_to_cqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->no_wqe_drop_count);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_wire);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->mpi_uar);

}

void connectib_hw_r_qpc_ud_l2_cd_unpack(struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->check_source_uc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->check_source_gvmi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->check_source_mc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->check_source_uc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->drop_my_self_multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->grh_to_cqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=368;
	ptr_struct->no_wqe_drop_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->check_source_mc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=480;
	ptr_struct->mpi_uar = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_ud_l2_cd_print(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ud_l2_cd ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire : "UH_FMT"\n", ptr_struct->check_source_uc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi    : "UH_FMT"\n", ptr_struct->check_source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb   : "UH_FMT"\n", ptr_struct->check_source_mc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb   : "UH_FMT"\n", ptr_struct->check_source_uc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast : "UH_FMT"\n", ptr_struct->drop_my_self_multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe           : "UH_FMT"\n", ptr_struct->grh_to_cqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count    : "UH_FMT"\n", ptr_struct->no_wqe_drop_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire : "UH_FMT"\n", ptr_struct->check_source_mc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mpi_uar              : "UH_FMT"\n", ptr_struct->mpi_uar);

}

int connectib_hw_r_qpc_ud_l2_cd_size(void){
	 return 64;
}

void connectib_hw_r_qpc_ud_l2_cd_dump(const struct connectib_hw_r_qpc_ud_l2_cd *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_ud_l2_cd_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ud_l2_2srq_pack(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_wire);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_gvmi);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_lb);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_lb);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drop_my_self_multicast);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_to_cqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->no_wqe_drop_count);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srq_number);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_wire);

}

void connectib_hw_r_qpc_ud_l2_2srq_unpack(struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->check_source_uc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->check_source_gvmi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->check_source_mc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->check_source_uc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->drop_my_self_multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->grh_to_cqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=368;
	ptr_struct->no_wqe_drop_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=456;
	ptr_struct->srq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=510;
	ptr_struct->check_source_mc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_ud_l2_2srq_print(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ud_l2_2srq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire : "UH_FMT"\n", ptr_struct->check_source_uc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi    : "UH_FMT"\n", ptr_struct->check_source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb   : "UH_FMT"\n", ptr_struct->check_source_mc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb   : "UH_FMT"\n", ptr_struct->check_source_uc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast : "UH_FMT"\n", ptr_struct->drop_my_self_multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe           : "UH_FMT"\n", ptr_struct->grh_to_cqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count    : "UH_FMT"\n", ptr_struct->no_wqe_drop_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number           : "UH_FMT"\n", ptr_struct->srq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire : "UH_FMT"\n", ptr_struct->check_source_mc_wire);

}

int connectib_hw_r_qpc_ud_l2_2srq_size(void){
	 return 64;
}

void connectib_hw_r_qpc_ud_l2_2srq_dump(const struct connectib_hw_r_qpc_ud_l2_2srq *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_ud_l2_2srq_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ud_l2_2cyclicbuff_pack(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_wire);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_gvmi);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_lb);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_lb);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drop_my_self_multicast);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_to_cqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_producer);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->no_wqe_drop_count);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->e2e_pa_63_32);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_wire);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->e2e_pa_31_2);

}

void connectib_hw_r_qpc_ud_l2_2cyclicbuff_unpack(struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->check_source_uc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->check_source_gvmi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->check_source_mc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->check_source_uc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->drop_my_self_multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->grh_to_cqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rcyclic_producer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=368;
	ptr_struct->no_wqe_drop_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->e2e_pa_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->check_source_mc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=480;
	ptr_struct->e2e_pa_31_2 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

}

void connectib_hw_r_qpc_ud_l2_2cyclicbuff_print(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ud_l2_2cyclicbuff ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire : "UH_FMT"\n", ptr_struct->check_source_uc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi    : "UH_FMT"\n", ptr_struct->check_source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb   : "UH_FMT"\n", ptr_struct->check_source_mc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb   : "UH_FMT"\n", ptr_struct->check_source_uc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast : "UH_FMT"\n", ptr_struct->drop_my_self_multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe           : "UH_FMT"\n", ptr_struct->grh_to_cqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_producer     : "U32H_FMT"\n", ptr_struct->rcyclic_producer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count    : "UH_FMT"\n", ptr_struct->no_wqe_drop_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_63_32         : "U32H_FMT"\n", ptr_struct->e2e_pa_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire : "UH_FMT"\n", ptr_struct->check_source_mc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_31_2          : "UH_FMT"\n", ptr_struct->e2e_pa_31_2);

}

int connectib_hw_r_qpc_ud_l2_2cyclicbuff_size(void){
	 return 64;
}

void connectib_hw_r_qpc_ud_l2_2cyclicbuff_dump(const struct connectib_hw_r_qpc_ud_l2_2cyclicbuff *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_ud_l2_2cyclicbuff_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_ud_l2_pack(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_wire);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_gvmi);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_lb);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_lb);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drop_my_self_multicast);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_to_cqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->no_wqe_drop_count);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->e2e_pa_63_32);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_wire);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->e2e_pa_31_2);

}

void connectib_hw_r_qpc_ud_l2_unpack(struct connectib_hw_r_qpc_ud_l2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->check_source_uc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->check_source_gvmi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->check_source_mc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->check_source_uc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->drop_my_self_multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->grh_to_cqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=368;
	ptr_struct->no_wqe_drop_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->e2e_pa_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->check_source_mc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=480;
	ptr_struct->e2e_pa_31_2 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

}

void connectib_hw_r_qpc_ud_l2_print(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_ud_l2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire : "UH_FMT"\n", ptr_struct->check_source_uc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi    : "UH_FMT"\n", ptr_struct->check_source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb   : "UH_FMT"\n", ptr_struct->check_source_mc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb   : "UH_FMT"\n", ptr_struct->check_source_uc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast : "UH_FMT"\n", ptr_struct->drop_my_self_multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe           : "UH_FMT"\n", ptr_struct->grh_to_cqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count    : "UH_FMT"\n", ptr_struct->no_wqe_drop_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_63_32         : "U32H_FMT"\n", ptr_struct->e2e_pa_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire : "UH_FMT"\n", ptr_struct->check_source_mc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_31_2          : "UH_FMT"\n", ptr_struct->e2e_pa_31_2);

}

int connectib_hw_r_qpc_ud_l2_size(void){
	 return 64;
}

void connectib_hw_r_qpc_ud_l2_dump(const struct connectib_hw_r_qpc_ud_l2 *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_ud_l2_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_unconnected_common_pack(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_wire);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_gvmi);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_lb);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_uc_lb);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->drop_my_self_multicast);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_to_cqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->no_wqe_drop_count);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->check_source_mc_wire);

}

void connectib_hw_r_qpc_unconnected_common_unpack(struct connectib_hw_r_qpc_unconnected_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->check_source_uc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=23;
	ptr_struct->check_source_gvmi = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->check_source_mc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->check_source_uc_lb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->drop_my_self_multicast = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->grh_to_cqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=368;
	ptr_struct->no_wqe_drop_count = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->check_source_mc_wire = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_r_qpc_unconnected_common_print(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_unconnected_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_wire : "UH_FMT"\n", ptr_struct->check_source_uc_wire);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_gvmi    : "UH_FMT"\n", ptr_struct->check_source_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_lb   : "UH_FMT"\n", ptr_struct->check_source_mc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_uc_lb   : "UH_FMT"\n", ptr_struct->check_source_uc_lb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "drop_my_self_multicast : "UH_FMT"\n", ptr_struct->drop_my_self_multicast);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_to_cqe           : "UH_FMT"\n", ptr_struct->grh_to_cqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_wqe_drop_count    : "UH_FMT"\n", ptr_struct->no_wqe_drop_count);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "check_source_mc_wire : "UH_FMT"\n", ptr_struct->check_source_mc_wire);

}

int connectib_hw_r_qpc_unconnected_common_size(void){
	 return 64;
}

void connectib_hw_r_qpc_unconnected_common_dump(const struct connectib_hw_r_qpc_unconnected_common *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_unconnected_common_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_xrc_pack(const struct connectib_hw_r_qpc_xrc *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->msn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srq_number);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->xrc_domain);

}

void connectib_hw_r_qpc_xrc_unpack(struct connectib_hw_r_qpc_xrc *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->msn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=456;
	ptr_struct->srq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=480;
	ptr_struct->xrc_domain = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_xrc_print(const struct connectib_hw_r_qpc_xrc *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_xrc ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn                  : "UH_FMT"\n", ptr_struct->msn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number           : "UH_FMT"\n", ptr_struct->srq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "xrc_domain           : "UH_FMT"\n", ptr_struct->xrc_domain);

}

int connectib_hw_r_qpc_xrc_size(void){
	 return 64;
}

void connectib_hw_r_qpc_xrc_dump(const struct connectib_hw_r_qpc_xrc *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_xrc_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_dcr_pack(const struct connectib_hw_r_qpc_dcr *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->msn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->dct_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_dcr);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

	offset=509;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dcr_connected);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->responder_session_id);

}

void connectib_hw_r_qpc_dcr_unpack(struct connectib_hw_r_qpc_dcr *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->msn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->dct_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=456;
	ptr_struct->next_dcr = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=509;
	ptr_struct->dcr_connected = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=480;
	ptr_struct->responder_session_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_dcr_print(const struct connectib_hw_r_qpc_dcr *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_dcr ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn                  : "UH_FMT"\n", ptr_struct->msn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_number           : "UH_FMT"\n", ptr_struct->dct_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_dcr             : "UH_FMT"\n", ptr_struct->next_dcr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dcr_connected        : "UH_FMT"\n", ptr_struct->dcr_connected);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder_session_id : "UH_FMT"\n", ptr_struct->responder_session_id);

}

int connectib_hw_r_qpc_dcr_size(void){
	 return 64;
}

void connectib_hw_r_qpc_dcr_dump(const struct connectib_hw_r_qpc_dcr *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_dcr_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rc_uc_2srq_pack(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->msn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->srq_number);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

}

void connectib_hw_r_qpc_rc_uc_2srq_unpack(struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->msn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=456;
	ptr_struct->srq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_r_qpc_rc_uc_2srq_print(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rc_uc_2srq ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn                  : "UH_FMT"\n", ptr_struct->msn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq_number           : "UH_FMT"\n", ptr_struct->srq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

}

int connectib_hw_r_qpc_rc_uc_2srq_size(void){
	 return 64;
}

void connectib_hw_r_qpc_rc_uc_2srq_dump(const struct connectib_hw_r_qpc_rc_uc_2srq *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_rc_uc_2srq_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rc_uc_2cycbuff_pack(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_producer);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rcyclic_consumer);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->e2e_pa_63_32);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->e2e_pa_31_2);

}

void connectib_hw_r_qpc_rc_uc_2cycbuff_unpack(struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rcyclic_producer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=192;
	ptr_struct->rcyclic_consumer = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=448;
	ptr_struct->e2e_pa_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=480;
	ptr_struct->e2e_pa_31_2 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

}

void connectib_hw_r_qpc_rc_uc_2cycbuff_print(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rc_uc_2cycbuff ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_producer     : "U32H_FMT"\n", ptr_struct->rcyclic_producer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_consumer     : "U32H_FMT"\n", ptr_struct->rcyclic_consumer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_63_32         : "U32H_FMT"\n", ptr_struct->e2e_pa_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_31_2          : "UH_FMT"\n", ptr_struct->e2e_pa_31_2);

}

int connectib_hw_r_qpc_rc_uc_2cycbuff_size(void){
	 return 64;
}

void connectib_hw_r_qpc_rc_uc_2cycbuff_dump(const struct connectib_hw_r_qpc_rc_uc_2cycbuff *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_rc_uc_2cycbuff_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rc_uc_cd_pack(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->msn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->mpi_uar);

}

void connectib_hw_r_qpc_rc_uc_cd_unpack(struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->msn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=480;
	ptr_struct->mpi_uar = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_hw_r_qpc_rc_uc_cd_print(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rc_uc_cd ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn                  : "UH_FMT"\n", ptr_struct->msn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mpi_uar              : "UH_FMT"\n", ptr_struct->mpi_uar);

}

int connectib_hw_r_qpc_rc_uc_cd_size(void){
	 return 64;
}

void connectib_hw_r_qpc_rc_uc_cd_dump(const struct connectib_hw_r_qpc_rc_uc_cd *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_rc_uc_cd_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_rc_uc_dci_pack(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=112;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_producer_index);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_consumer_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->msn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->e2e_pa_63_32);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 30, (u_int32_t)ptr_struct->e2e_pa_31_2);

}

void connectib_hw_r_qpc_rc_uc_dci_unpack(struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=112;
	ptr_struct->rwqe_producer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rwqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->msn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=448;
	ptr_struct->e2e_pa_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=480;
	ptr_struct->e2e_pa_31_2 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 30);

}

void connectib_hw_r_qpc_rc_uc_dci_print(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_rc_uc_dci ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_producer_index  : "UH_FMT"\n", ptr_struct->rwqe_producer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_consumer_index  : "UH_FMT"\n", ptr_struct->rwqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msn                  : "UH_FMT"\n", ptr_struct->msn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_63_32         : "U32H_FMT"\n", ptr_struct->e2e_pa_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_pa_31_2          : "UH_FMT"\n", ptr_struct->e2e_pa_31_2);

}

int connectib_hw_r_qpc_rc_uc_dci_size(void){
	 return 64;
}

void connectib_hw_r_qpc_rc_uc_dci_dump(const struct connectib_hw_r_qpc_rc_uc_dci *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_rc_uc_dci_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_connected_common_pack(const struct connectib_hw_r_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->last_opcode);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->read_enable);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->send_with_invalidate_enable);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->atomic_like_write);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ack_type);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->write_rkey);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=75;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rnr_timer);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_write_pointer);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=312;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->rdb_read_pointer);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=320;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->rx_length_committed);

	offset=368;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->dct_gvmi);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->sqn);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->write_va);

	offset=510;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->connection_state);

}

void connectib_hw_r_qpc_connected_common_unpack(struct connectib_hw_r_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->last_opcode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->read_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->send_with_invalidate_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=8;
	ptr_struct->write_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->atomic_like_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ack_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->write_rkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=75;
	ptr_struct->rnr_timer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->first_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->rdb_write_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=312;
	ptr_struct->rdb_read_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=320;
	ptr_struct->rx_length_committed = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=368;
	ptr_struct->dct_gvmi = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=357;
	ptr_struct->sqn = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->write_va = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=510;
	ptr_struct->connection_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_hw_r_qpc_connected_common_print(const struct connectib_hw_r_qpc_connected_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_connected_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "last_opcode          : "UH_FMT"\n", ptr_struct->last_opcode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "read_enable          : "UH_FMT"\n", ptr_struct->read_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "send_with_invalidate_enable : "UH_FMT"\n", ptr_struct->send_with_invalidate_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_enable         : "UH_FMT"\n", ptr_struct->write_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "atomic_like_write    : "UH_FMT"\n", ptr_struct->atomic_like_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_type             : "UH_FMT"\n", ptr_struct->ack_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_rkey           : "U32H_FMT"\n", ptr_struct->write_rkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_timer            : "UH_FMT"\n", ptr_struct->rnr_timer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_non_acked_psn  : "UH_FMT"\n", ptr_struct->first_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_write_pointer    : "UH_FMT"\n", ptr_struct->rdb_write_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdb_read_pointer     : "UH_FMT"\n", ptr_struct->rdb_read_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_length_committed  : "UH_FMT"\n", ptr_struct->rx_length_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dct_gvmi             : "UH_FMT"\n", ptr_struct->dct_gvmi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sqn                  : "UH_FMT"\n", ptr_struct->sqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_va             : "U64H_FMT"\n", ptr_struct->write_va);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "connection_state     : "UH_FMT"\n", ptr_struct->connection_state);

}

int connectib_hw_r_qpc_connected_common_size(void){
	 return 64;
}

void connectib_hw_r_qpc_connected_common_dump(const struct connectib_hw_r_qpc_connected_common *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_connected_common_print(ptr_struct, file, 0);
}

void connectib_hw_r_qpc_common_pack(const struct connectib_hw_r_qpc_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fw_link_type);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->post_receive_slave_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->rwqe_limit_event);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=68;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_fetch_enable);

	offset=65;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->e2e_credits_prefetch_threshold);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->expected_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

}

void connectib_hw_r_qpc_common_unpack(struct connectib_hw_r_qpc_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->fw_link_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->post_receive_slave_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=80;
	ptr_struct->rwqe_limit_event = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=68;
	ptr_struct->e2e_fetch_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=65;
	ptr_struct->e2e_credits_prefetch_threshold = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->expected_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_r_qpc_common_print(const struct connectib_hw_r_qpc_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_r_qpc_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fw_link_type         : "UH_FMT"\n", ptr_struct->fw_link_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "post_receive_slave_enable : "UH_FMT"\n", ptr_struct->post_receive_slave_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_limit_event     : "UH_FMT"\n", ptr_struct->rwqe_limit_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_fetch_enable     : "UH_FMT"\n", ptr_struct->e2e_fetch_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_prefetch_threshold : "UH_FMT"\n", ptr_struct->e2e_credits_prefetch_threshold);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "expected_psn         : "UH_FMT"\n", ptr_struct->expected_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

}

int connectib_hw_r_qpc_common_size(void){
	 return 64;
}

void connectib_hw_r_qpc_common_dump(const struct connectib_hw_r_qpc_common *ptr_struct, FILE* file) {
	connectib_hw_r_qpc_common_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_ud_l2_pack(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->umr_permission_select);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->packet_allowed);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=67;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->umr_enable);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->frwr_enable);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->swqe_consumer_index);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->deth_sqpn);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_to_send_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh_tclass);

	offset=361;
	adb2c_push_bits_to_buff(ptr_buff, offset, 23, (u_int32_t)ptr_struct->sx_gather_commit);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_my_gid_index);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=449;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vl15);

	offset=448;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh);

}

void connectib_hw_s_qpc_ud_l2_unpack(struct connectib_hw_s_qpc_ud_l2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->umr_permission_select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=2;
	ptr_struct->packet_allowed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=67;
	ptr_struct->umr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=66;
	ptr_struct->frwr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->swqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->deth_sqpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->next_to_send_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=336;
	ptr_struct->force_grh_tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=361;
	ptr_struct->sx_gather_commit = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 23);

	offset=360;
	ptr_struct->force_my_gid_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=449;
	ptr_struct->vl15 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=448;
	ptr_struct->force_grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_ud_l2_print(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_ud_l2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_permission_select : "UH_FMT"\n", ptr_struct->umr_permission_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "packet_allowed       : "UH_FMT"\n", ptr_struct->packet_allowed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_enable           : "UH_FMT"\n", ptr_struct->umr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "frwr_enable          : "UH_FMT"\n", ptr_struct->frwr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_consumer_index  : "UH_FMT"\n", ptr_struct->swqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "deth_sqpn            : "UH_FMT"\n", ptr_struct->deth_sqpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_to_send_psn     : "UH_FMT"\n", ptr_struct->next_to_send_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh_tclass     : "UH_FMT"\n", ptr_struct->force_grh_tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_gather_commit     : "UH_FMT"\n", ptr_struct->sx_gather_commit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_my_gid_index   : "UH_FMT"\n", ptr_struct->force_my_gid_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl15                 : "UH_FMT"\n", ptr_struct->vl15);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh            : "UH_FMT"\n", ptr_struct->force_grh);

}

int connectib_hw_s_qpc_ud_l2_size(void){
	 return 64;
}

void connectib_hw_s_qpc_ud_l2_dump(const struct connectib_hw_s_qpc_ud_l2 *ptr_struct, FILE* file) {
	connectib_hw_s_qpc_ud_l2_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_dci_pack(const struct connectib_hw_s_qpc_dci *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ldb_int);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_limit);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_counter);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->umr_permission_select);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dc_full_handshake);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uncompleted_non_wire_wqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=94;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dc_state);

	offset=76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->limited_qp);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ack_req_frequency);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=67;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->umr_enable);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->frwr_enable);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->currently_completing_wqe_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->swqe_consumer_index);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->oldest_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->psn_since_ackreq);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->responder_session_id);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_to_send_psn);

	offset=296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->ssn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh_tclass);

	offset=332;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->reverse_sl);

	offset=329;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_counter);

	offset=361;
	adb2c_push_bits_to_buff(ptr_buff, offset, 23, (u_int32_t)ptr_struct->sx_gather_commit);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_my_gid_index);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_limit);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->dc_access_key);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_psn_of_message_currently_completing);

	offset=450;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->currently_completing_ds);

	offset=449;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->timer_enable);

	offset=448;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh);

	offset=488;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_unsent_psn);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->number_outstanding_reads);

}

void connectib_hw_s_qpc_dci_unpack(struct connectib_hw_s_qpc_dci *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->ldb_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=21;
	ptr_struct->rnr_nak_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->rnr_nak_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=6;
	ptr_struct->umr_permission_select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->dc_full_handshake = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->uncompleted_non_wire_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=94;
	ptr_struct->dc_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=76;
	ptr_struct->limited_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=72;
	ptr_struct->ack_req_frequency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=67;
	ptr_struct->umr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=66;
	ptr_struct->frwr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->currently_completing_wqe_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->swqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->oldest_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->psn_since_ackreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->responder_session_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->next_to_send_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=296;
	ptr_struct->ssn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=336;
	ptr_struct->force_grh_tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=332;
	ptr_struct->reverse_sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=329;
	ptr_struct->to_sequence_error_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=361;
	ptr_struct->sx_gather_commit = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 23);

	offset=360;
	ptr_struct->force_my_gid_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=357;
	ptr_struct->to_sequence_error_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->dc_access_key = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=456;
	ptr_struct->first_psn_of_message_currently_completing = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=450;
	ptr_struct->currently_completing_ds = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=449;
	ptr_struct->timer_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=448;
	ptr_struct->force_grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=488;
	ptr_struct->first_unsent_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=480;
	ptr_struct->number_outstanding_reads = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_s_qpc_dci_print(const struct connectib_hw_s_qpc_dci *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_dci ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ldb_int              : "UH_FMT"\n", ptr_struct->ldb_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_limit  : "UH_FMT"\n", ptr_struct->rnr_nak_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_counter : "UH_FMT"\n", ptr_struct->rnr_nak_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_permission_select : "UH_FMT"\n", ptr_struct->umr_permission_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_full_handshake    : "UH_FMT"\n", ptr_struct->dc_full_handshake);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uncompleted_non_wire_wqe : "UH_FMT"\n", ptr_struct->uncompleted_non_wire_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_state             : "UH_FMT"\n", ptr_struct->dc_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "limited_qp           : "UH_FMT"\n", ptr_struct->limited_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_req_frequency    : "UH_FMT"\n", ptr_struct->ack_req_frequency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_enable           : "UH_FMT"\n", ptr_struct->umr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "frwr_enable          : "UH_FMT"\n", ptr_struct->frwr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_wqe_index : "UH_FMT"\n", ptr_struct->currently_completing_wqe_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_consumer_index  : "UH_FMT"\n", ptr_struct->swqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oldest_non_acked_psn : "UH_FMT"\n", ptr_struct->oldest_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psn_since_ackreq     : "UH_FMT"\n", ptr_struct->psn_since_ackreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder_session_id : "UH_FMT"\n", ptr_struct->responder_session_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_to_send_psn     : "UH_FMT"\n", ptr_struct->next_to_send_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ssn                  : "UH_FMT"\n", ptr_struct->ssn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh_tclass     : "UH_FMT"\n", ptr_struct->force_grh_tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reverse_sl           : "UH_FMT"\n", ptr_struct->reverse_sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_counter : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_gather_commit     : "UH_FMT"\n", ptr_struct->sx_gather_commit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_my_gid_index   : "UH_FMT"\n", ptr_struct->force_my_gid_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_limit : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_access_key        : "U64H_FMT"\n", ptr_struct->dc_access_key);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_psn_of_message_currently_completing : "UH_FMT"\n", ptr_struct->first_psn_of_message_currently_completing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_ds : "UH_FMT"\n", ptr_struct->currently_completing_ds);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_enable         : "UH_FMT"\n", ptr_struct->timer_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh            : "UH_FMT"\n", ptr_struct->force_grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_unsent_psn     : "UH_FMT"\n", ptr_struct->first_unsent_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "number_outstanding_reads : "UH_FMT"\n", ptr_struct->number_outstanding_reads);

}

int connectib_hw_s_qpc_dci_size(void){
	 return 64;
}

void connectib_hw_s_qpc_dci_dump(const struct connectib_hw_s_qpc_dci *ptr_struct, FILE* file) {
	connectib_hw_s_qpc_dci_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_rc_uc_dcr_pack(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ldb_int);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_limit);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_counter);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->umr_permission_select);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dc_full_handshake);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uncompleted_non_wire_wqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=94;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dc_state);

	offset=76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->limited_qp);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ack_req_frequency);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=67;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->umr_enable);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->frwr_enable);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->currently_completing_wqe_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->swqe_consumer_index);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->oldest_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->psn_since_ackreq);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->responder_session_id);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_to_send_psn);

	offset=296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->ssn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh_tclass);

	offset=332;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->reverse_sl);

	offset=329;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_counter);

	offset=361;
	adb2c_push_bits_to_buff(ptr_buff, offset, 23, (u_int32_t)ptr_struct->sx_gather_commit);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_my_gid_index);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_limit);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=392;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->lsn);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_psn_of_message_currently_completing);

	offset=450;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->currently_completing_ds);

	offset=449;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->timer_enable);

	offset=448;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh);

	offset=488;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_unsent_psn);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->number_outstanding_reads);

}

void connectib_hw_s_qpc_rc_uc_dcr_unpack(struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->ldb_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=21;
	ptr_struct->rnr_nak_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->rnr_nak_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=6;
	ptr_struct->umr_permission_select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->dc_full_handshake = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->uncompleted_non_wire_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=94;
	ptr_struct->dc_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=76;
	ptr_struct->limited_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=72;
	ptr_struct->ack_req_frequency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=67;
	ptr_struct->umr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=66;
	ptr_struct->frwr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->currently_completing_wqe_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->swqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->oldest_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->psn_since_ackreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->responder_session_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->next_to_send_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=296;
	ptr_struct->ssn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=336;
	ptr_struct->force_grh_tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=332;
	ptr_struct->reverse_sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=329;
	ptr_struct->to_sequence_error_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=361;
	ptr_struct->sx_gather_commit = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 23);

	offset=360;
	ptr_struct->force_my_gid_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=357;
	ptr_struct->to_sequence_error_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=392;
	ptr_struct->lsn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=456;
	ptr_struct->first_psn_of_message_currently_completing = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=450;
	ptr_struct->currently_completing_ds = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=449;
	ptr_struct->timer_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=448;
	ptr_struct->force_grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=488;
	ptr_struct->first_unsent_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=480;
	ptr_struct->number_outstanding_reads = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_s_qpc_rc_uc_dcr_print(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_rc_uc_dcr ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ldb_int              : "UH_FMT"\n", ptr_struct->ldb_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_limit  : "UH_FMT"\n", ptr_struct->rnr_nak_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_counter : "UH_FMT"\n", ptr_struct->rnr_nak_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_permission_select : "UH_FMT"\n", ptr_struct->umr_permission_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_full_handshake    : "UH_FMT"\n", ptr_struct->dc_full_handshake);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uncompleted_non_wire_wqe : "UH_FMT"\n", ptr_struct->uncompleted_non_wire_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_state             : "UH_FMT"\n", ptr_struct->dc_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "limited_qp           : "UH_FMT"\n", ptr_struct->limited_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_req_frequency    : "UH_FMT"\n", ptr_struct->ack_req_frequency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_enable           : "UH_FMT"\n", ptr_struct->umr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "frwr_enable          : "UH_FMT"\n", ptr_struct->frwr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_wqe_index : "UH_FMT"\n", ptr_struct->currently_completing_wqe_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_consumer_index  : "UH_FMT"\n", ptr_struct->swqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oldest_non_acked_psn : "UH_FMT"\n", ptr_struct->oldest_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psn_since_ackreq     : "UH_FMT"\n", ptr_struct->psn_since_ackreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder_session_id : "UH_FMT"\n", ptr_struct->responder_session_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_to_send_psn     : "UH_FMT"\n", ptr_struct->next_to_send_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ssn                  : "UH_FMT"\n", ptr_struct->ssn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh_tclass     : "UH_FMT"\n", ptr_struct->force_grh_tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reverse_sl           : "UH_FMT"\n", ptr_struct->reverse_sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_counter : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_gather_commit     : "UH_FMT"\n", ptr_struct->sx_gather_commit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_my_gid_index   : "UH_FMT"\n", ptr_struct->force_my_gid_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_limit : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "lsn                  : "UH_FMT"\n", ptr_struct->lsn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_psn_of_message_currently_completing : "UH_FMT"\n", ptr_struct->first_psn_of_message_currently_completing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_ds : "UH_FMT"\n", ptr_struct->currently_completing_ds);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_enable         : "UH_FMT"\n", ptr_struct->timer_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh            : "UH_FMT"\n", ptr_struct->force_grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_unsent_psn     : "UH_FMT"\n", ptr_struct->first_unsent_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "number_outstanding_reads : "UH_FMT"\n", ptr_struct->number_outstanding_reads);

}

int connectib_hw_s_qpc_rc_uc_dcr_size(void){
	 return 64;
}

void connectib_hw_s_qpc_rc_uc_dcr_dump(const struct connectib_hw_s_qpc_rc_uc_dcr *ptr_struct, FILE* file) {
	connectib_hw_s_qpc_rc_uc_dcr_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_connected_common_pack(const struct connectib_hw_s_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ldb_int);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->inline_scatter);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_limit);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rnr_nak_retry_counter);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ignore_pkey_check);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->extended_atomic);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_atomic);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->umr_permission_select);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_direct_access);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->e2e_credits_enabled);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dc_full_handshake);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->uncompleted_non_wire_wqe);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=94;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->dc_state);

	offset=76;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->limited_qp);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ack_req_frequency);

	offset=71;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_trap);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=69;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->tcu_drop);

	offset=67;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->umr_enable);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->frwr_enable);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->currently_completing_wqe_index);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->swqe_consumer_index);

	offset=168;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->oldest_non_acked_psn);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->psn_since_ackreq);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->responder_session_id);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_to_send_psn);

	offset=296;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->ssn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh_tclass);

	offset=332;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->reverse_sl);

	offset=329;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_counter);

	offset=361;
	adb2c_push_bits_to_buff(ptr_buff, offset, 23, (u_int32_t)ptr_struct->sx_gather_commit);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_my_gid_index);

	offset=357;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->to_sequence_error_retry_limit);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_psn_of_message_currently_completing);

	offset=450;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->currently_completing_ds);

	offset=449;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->timer_enable);

	offset=448;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh);

	offset=488;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->first_unsent_psn);

	offset=480;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->number_outstanding_reads);

}

void connectib_hw_s_qpc_connected_common_unpack(struct connectib_hw_s_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->ldb_int = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->inline_scatter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=21;
	ptr_struct->rnr_nak_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->rnr_nak_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=16;
	ptr_struct->ignore_pkey_check = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->extended_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->max_read_atomic = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=6;
	ptr_struct->umr_permission_select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=5;
	ptr_struct->no_direct_access = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->e2e_credits_enabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->dc_full_handshake = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->uncompleted_non_wire_wqe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=94;
	ptr_struct->dc_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=76;
	ptr_struct->limited_qp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=72;
	ptr_struct->ack_req_frequency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=71;
	ptr_struct->tcu_trap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=69;
	ptr_struct->tcu_drop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=67;
	ptr_struct->umr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=66;
	ptr_struct->frwr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->currently_completing_wqe_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->swqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=168;
	ptr_struct->oldest_non_acked_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=160;
	ptr_struct->psn_since_ackreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=200;
	ptr_struct->responder_session_id = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->next_to_send_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=296;
	ptr_struct->ssn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=336;
	ptr_struct->force_grh_tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=332;
	ptr_struct->reverse_sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=329;
	ptr_struct->to_sequence_error_retry_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=361;
	ptr_struct->sx_gather_commit = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 23);

	offset=360;
	ptr_struct->force_my_gid_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=357;
	ptr_struct->to_sequence_error_retry_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=456;
	ptr_struct->first_psn_of_message_currently_completing = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=450;
	ptr_struct->currently_completing_ds = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=449;
	ptr_struct->timer_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=448;
	ptr_struct->force_grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=488;
	ptr_struct->first_unsent_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=480;
	ptr_struct->number_outstanding_reads = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_s_qpc_connected_common_print(const struct connectib_hw_s_qpc_connected_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_connected_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ldb_int              : "UH_FMT"\n", ptr_struct->ldb_int);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "inline_scatter       : "UH_FMT"\n", ptr_struct->inline_scatter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_limit  : "UH_FMT"\n", ptr_struct->rnr_nak_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rnr_nak_retry_counter : "UH_FMT"\n", ptr_struct->rnr_nak_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ignore_pkey_check    : "UH_FMT"\n", ptr_struct->ignore_pkey_check);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_atomic      : "UH_FMT"\n", ptr_struct->extended_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_atomic      : "UH_FMT"\n", ptr_struct->max_read_atomic);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_permission_select : "UH_FMT"\n", ptr_struct->umr_permission_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_direct_access     : "UH_FMT"\n", ptr_struct->no_direct_access);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "e2e_credits_enabled  : "UH_FMT"\n", ptr_struct->e2e_credits_enabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_full_handshake    : "UH_FMT"\n", ptr_struct->dc_full_handshake);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "uncompleted_non_wire_wqe : "UH_FMT"\n", ptr_struct->uncompleted_non_wire_wqe);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dc_state             : "UH_FMT"\n", ptr_struct->dc_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "limited_qp           : "UH_FMT"\n", ptr_struct->limited_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ack_req_frequency    : "UH_FMT"\n", ptr_struct->ack_req_frequency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_trap             : "UH_FMT"\n", ptr_struct->tcu_trap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tcu_drop             : "UH_FMT"\n", ptr_struct->tcu_drop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_enable           : "UH_FMT"\n", ptr_struct->umr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "frwr_enable          : "UH_FMT"\n", ptr_struct->frwr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_wqe_index : "UH_FMT"\n", ptr_struct->currently_completing_wqe_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_consumer_index  : "UH_FMT"\n", ptr_struct->swqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "oldest_non_acked_psn : "UH_FMT"\n", ptr_struct->oldest_non_acked_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psn_since_ackreq     : "UH_FMT"\n", ptr_struct->psn_since_ackreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "responder_session_id : "UH_FMT"\n", ptr_struct->responder_session_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_to_send_psn     : "UH_FMT"\n", ptr_struct->next_to_send_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ssn                  : "UH_FMT"\n", ptr_struct->ssn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh_tclass     : "UH_FMT"\n", ptr_struct->force_grh_tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reverse_sl           : "UH_FMT"\n", ptr_struct->reverse_sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_counter : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_gather_commit     : "UH_FMT"\n", ptr_struct->sx_gather_commit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_my_gid_index   : "UH_FMT"\n", ptr_struct->force_my_gid_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "to_sequence_error_retry_limit : "UH_FMT"\n", ptr_struct->to_sequence_error_retry_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_psn_of_message_currently_completing : "UH_FMT"\n", ptr_struct->first_psn_of_message_currently_completing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "currently_completing_ds : "UH_FMT"\n", ptr_struct->currently_completing_ds);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "timer_enable         : "UH_FMT"\n", ptr_struct->timer_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh            : "UH_FMT"\n", ptr_struct->force_grh);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_unsent_psn     : "UH_FMT"\n", ptr_struct->first_unsent_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "number_outstanding_reads : "UH_FMT"\n", ptr_struct->number_outstanding_reads);

}

int connectib_hw_s_qpc_connected_common_size(void){
	 return 64;
}

void connectib_hw_s_qpc_connected_common_dump(const struct connectib_hw_s_qpc_connected_common *ptr_struct, FILE* file) {
	connectib_hw_s_qpc_connected_common_print(ptr_struct, file, 0);
}

void connectib_hw_s_qpc_common_pack(const struct connectib_hw_s_qpc_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fast_path);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->umr_permission_select);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qp_valid);

	offset=70;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->can_use_reserved_lkey);

	offset=67;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->umr_enable);

	offset=66;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->frwr_enable);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_heartbeat);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->qp_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->swqe_consumer_index);

	offset=232;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cq_number);

	offset=280;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->flush_syndrom);

	offset=256;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->next_to_send_psn);

	offset=288;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->counter_index);

	offset=336;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh_tclass);

	offset=361;
	adb2c_push_bits_to_buff(ptr_buff, offset, 23, (u_int32_t)ptr_struct->sx_gather_commit);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_my_gid_index);

	offset=356;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_heartbeat);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ts);

	offset=448;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_grh);

}

void connectib_hw_s_qpc_common_unpack(struct connectib_hw_s_qpc_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=20;
	ptr_struct->fast_path = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->umr_permission_select = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=0;
	ptr_struct->qp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=70;
	ptr_struct->can_use_reserved_lkey = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=67;
	ptr_struct->umr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=66;
	ptr_struct->frwr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=64;
	ptr_struct->rx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->qp_state = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=128;
	ptr_struct->swqe_consumer_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=232;
	ptr_struct->cq_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=280;
	ptr_struct->flush_syndrom = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=256;
	ptr_struct->next_to_send_psn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=288;
	ptr_struct->counter_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=336;
	ptr_struct->force_grh_tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=361;
	ptr_struct->sx_gather_commit = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 23);

	offset=360;
	ptr_struct->force_my_gid_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=356;
	ptr_struct->sx_heartbeat = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=352;
	ptr_struct->ts = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->force_grh = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_hw_s_qpc_common_print(const struct connectib_hw_s_qpc_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_s_qpc_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fast_path            : "UH_FMT"\n", ptr_struct->fast_path);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_permission_select : "UH_FMT"\n", ptr_struct->umr_permission_select);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_valid             : "UH_FMT"\n", ptr_struct->qp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "can_use_reserved_lkey : "UH_FMT"\n", ptr_struct->can_use_reserved_lkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "umr_enable           : "UH_FMT"\n", ptr_struct->umr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "frwr_enable          : "UH_FMT"\n", ptr_struct->frwr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_heartbeat         : "UH_FMT"\n", ptr_struct->rx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp_state             : "UH_FMT"\n", ptr_struct->qp_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_consumer_index  : "UH_FMT"\n", ptr_struct->swqe_consumer_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cq_number            : "UH_FMT"\n", ptr_struct->cq_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flush_syndrom        : "UH_FMT"\n", ptr_struct->flush_syndrom);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_to_send_psn     : "UH_FMT"\n", ptr_struct->next_to_send_psn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "counter_index        : "UH_FMT"\n", ptr_struct->counter_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh_tclass     : "UH_FMT"\n", ptr_struct->force_grh_tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_gather_commit     : "UH_FMT"\n", ptr_struct->sx_gather_commit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_my_gid_index   : "UH_FMT"\n", ptr_struct->force_my_gid_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_heartbeat         : "UH_FMT"\n", ptr_struct->sx_heartbeat);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ts                   : "UH_FMT"\n", ptr_struct->ts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_grh            : "UH_FMT"\n", ptr_struct->force_grh);

}

int connectib_hw_s_qpc_common_size(void){
	 return 64;
}

void connectib_hw_s_qpc_common_dump(const struct connectib_hw_s_qpc_common *ptr_struct, FILE* file) {
	connectib_hw_s_qpc_common_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_unconnected_2cycbuff_pack(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=51;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rcyclic_size);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qkey);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

}

void connectib_hw_c_qpc_unconnected_2cycbuff_unpack(struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=51;
	ptr_struct->rcyclic_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=160;
	ptr_struct->qkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_c_qpc_unconnected_2cycbuff_print(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_unconnected_2cycbuff ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_size         : "UH_FMT"\n", ptr_struct->rcyclic_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey                 : "U32H_FMT"\n", ptr_struct->qkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

}

int connectib_hw_c_qpc_unconnected_2cycbuff_size(void){
	 return 64;
}

void connectib_hw_c_qpc_unconnected_2cycbuff_dump(const struct connectib_hw_c_qpc_unconnected_2cycbuff *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_unconnected_2cycbuff_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_unconnected_pack(const struct connectib_hw_c_qpc_unconnected *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rwqe_buffer_size);

	offset=49;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rwqe_stride);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qkey);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

}

void connectib_hw_c_qpc_unconnected_unpack(struct connectib_hw_c_qpc_unconnected *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=52;
	ptr_struct->rwqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=49;
	ptr_struct->rwqe_stride = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=160;
	ptr_struct->qkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_c_qpc_unconnected_print(const struct connectib_hw_c_qpc_unconnected *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_unconnected ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_buffer_size     : "UH_FMT"\n", ptr_struct->rwqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_stride          : "UH_FMT"\n", ptr_struct->rwqe_stride);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey                 : "U32H_FMT"\n", ptr_struct->qkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

}

int connectib_hw_c_qpc_unconnected_size(void){
	 return 64;
}

void connectib_hw_c_qpc_unconnected_dump(const struct connectib_hw_c_qpc_unconnected *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_unconnected_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_unconnected_common_pack(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->qkey);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

}

void connectib_hw_c_qpc_unconnected_common_unpack(struct connectib_hw_c_qpc_unconnected_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=160;
	ptr_struct->qkey = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_c_qpc_unconnected_common_print(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_unconnected_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qkey                 : "U32H_FMT"\n", ptr_struct->qkey);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

}

int connectib_hw_c_qpc_unconnected_common_size(void){
	 return 64;
}

void connectib_hw_c_qpc_unconnected_common_dump(const struct connectib_hw_c_qpc_unconnected_common *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_unconnected_common_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_connected_dual_pack(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_loopback);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dual_write);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rwqe_buffer_size);

	offset=49;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rwqe_stride);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ipd);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->peer_qp);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_migreq);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_migreq);

	offset=140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=195;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->max_message_size);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtu);

	offset=240;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->peer_lid);

	offset=233;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->my_lid);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

	offset=456;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->peer_qp2);

	offset=496;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->peer_lid2);

}

void connectib_hw_c_qpc_connected_dual_unpack(struct connectib_hw_c_qpc_connected_dual *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->force_loopback = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=2;
	ptr_struct->dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=52;
	ptr_struct->rwqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=49;
	ptr_struct->rwqe_stride = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=44;
	ptr_struct->ipd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->peer_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=97;
	ptr_struct->sx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=140;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=195;
	ptr_struct->max_message_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=192;
	ptr_struct->mtu = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=240;
	ptr_struct->peer_lid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=233;
	ptr_struct->my_lid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=456;
	ptr_struct->peer_qp2 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=496;
	ptr_struct->peer_lid2 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

}

void connectib_hw_c_qpc_connected_dual_print(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_connected_dual ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_loopback       : "UH_FMT"\n", ptr_struct->force_loopback);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dual_write           : "UH_FMT"\n", ptr_struct->dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_buffer_size     : "UH_FMT"\n", ptr_struct->rwqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_stride          : "UH_FMT"\n", ptr_struct->rwqe_stride);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd                  : "UH_FMT"\n", ptr_struct->ipd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_qp              : "UH_FMT"\n", ptr_struct->peer_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_migreq            : "UH_FMT"\n", ptr_struct->sx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_migreq            : "UH_FMT"\n", ptr_struct->rx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size     : "UH_FMT"\n", ptr_struct->max_message_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu                  : "UH_FMT"\n", ptr_struct->mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_lid             : "UH_FMT"\n", ptr_struct->peer_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid               : "UH_FMT"\n", ptr_struct->my_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_qp2             : "UH_FMT"\n", ptr_struct->peer_qp2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_lid2            : "UH_FMT"\n", ptr_struct->peer_lid2);

}

int connectib_hw_c_qpc_connected_dual_size(void){
	 return 64;
}

void connectib_hw_c_qpc_connected_dual_dump(const struct connectib_hw_c_qpc_connected_dual *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_connected_dual_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_connected_2cycbuff_pack(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_loopback);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dual_write);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=51;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->rcyclic_size);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ipd);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->peer_qp);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_migreq);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_migreq);

	offset=140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=195;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->max_message_size);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtu);

	offset=240;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->peer_lid);

	offset=233;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->my_lid);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->peer_gid_127_64);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 8, ptr_struct->peer_gid_63_0);

}

void connectib_hw_c_qpc_connected_2cycbuff_unpack(struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->force_loopback = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=2;
	ptr_struct->dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=51;
	ptr_struct->rcyclic_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=44;
	ptr_struct->ipd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->peer_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=97;
	ptr_struct->sx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=140;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=195;
	ptr_struct->max_message_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=192;
	ptr_struct->mtu = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=240;
	ptr_struct->peer_lid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=233;
	ptr_struct->my_lid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=384;
	ptr_struct->peer_gid_127_64 = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

	offset=448;
	ptr_struct->peer_gid_63_0 = adb2c_pop_integer_from_buff(ptr_buff, offset, 8);

}

void connectib_hw_c_qpc_connected_2cycbuff_print(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_connected_2cycbuff ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_loopback       : "UH_FMT"\n", ptr_struct->force_loopback);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dual_write           : "UH_FMT"\n", ptr_struct->dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcyclic_size         : "UH_FMT"\n", ptr_struct->rcyclic_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd                  : "UH_FMT"\n", ptr_struct->ipd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_qp              : "UH_FMT"\n", ptr_struct->peer_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_migreq            : "UH_FMT"\n", ptr_struct->sx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_migreq            : "UH_FMT"\n", ptr_struct->rx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size     : "UH_FMT"\n", ptr_struct->max_message_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu                  : "UH_FMT"\n", ptr_struct->mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_lid             : "UH_FMT"\n", ptr_struct->peer_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid               : "UH_FMT"\n", ptr_struct->my_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_127_64      : "U64H_FMT"\n", ptr_struct->peer_gid_127_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_63_0        : "U64H_FMT"\n", ptr_struct->peer_gid_63_0);

}

int connectib_hw_c_qpc_connected_2cycbuff_size(void){
	 return 64;
}

void connectib_hw_c_qpc_connected_2cycbuff_dump(const struct connectib_hw_c_qpc_connected_2cycbuff *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_connected_2cycbuff_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_connected_pack(const struct connectib_hw_c_qpc_connected *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_loopback);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dual_write);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=52;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->rwqe_buffer_size);

	offset=49;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->rwqe_stride);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ipd);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->peer_qp);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_migreq);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_migreq);

	offset=140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=195;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->max_message_size);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtu);

	offset=240;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->peer_lid);

	offset=233;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->my_lid);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->peer_gid_127_96);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->peer_gid_95_64);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->peer_gid_63_32);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->peer_gid_31_0);

}

void connectib_hw_c_qpc_connected_unpack(struct connectib_hw_c_qpc_connected *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->force_loopback = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=2;
	ptr_struct->dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=52;
	ptr_struct->rwqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=49;
	ptr_struct->rwqe_stride = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=44;
	ptr_struct->ipd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->peer_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=97;
	ptr_struct->sx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=140;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=195;
	ptr_struct->max_message_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=192;
	ptr_struct->mtu = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=240;
	ptr_struct->peer_lid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=233;
	ptr_struct->my_lid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=384;
	ptr_struct->peer_gid_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->peer_gid_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->peer_gid_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->peer_gid_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_c_qpc_connected_print(const struct connectib_hw_c_qpc_connected *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_connected ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_loopback       : "UH_FMT"\n", ptr_struct->force_loopback);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dual_write           : "UH_FMT"\n", ptr_struct->dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_buffer_size     : "UH_FMT"\n", ptr_struct->rwqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwqe_stride          : "UH_FMT"\n", ptr_struct->rwqe_stride);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd                  : "UH_FMT"\n", ptr_struct->ipd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_qp              : "UH_FMT"\n", ptr_struct->peer_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_migreq            : "UH_FMT"\n", ptr_struct->sx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_migreq            : "UH_FMT"\n", ptr_struct->rx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size     : "UH_FMT"\n", ptr_struct->max_message_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu                  : "UH_FMT"\n", ptr_struct->mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_lid             : "UH_FMT"\n", ptr_struct->peer_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid               : "UH_FMT"\n", ptr_struct->my_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_127_96      : "U32H_FMT"\n", ptr_struct->peer_gid_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_95_64       : "U32H_FMT"\n", ptr_struct->peer_gid_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_63_32       : "U32H_FMT"\n", ptr_struct->peer_gid_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_gid_31_0        : "U32H_FMT"\n", ptr_struct->peer_gid_31_0);

}

int connectib_hw_c_qpc_connected_size(void){
	 return 64;
}

void connectib_hw_c_qpc_connected_dump(const struct connectib_hw_c_qpc_connected *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_connected_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_connected_common_pack(const struct connectib_hw_c_qpc_connected_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_loopback);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->dual_write);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->ipd);

	offset=72;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->peer_qp);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->hop_limit);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=97;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sx_migreq);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rx_migreq);

	offset=140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 20, (u_int32_t)ptr_struct->flow_label);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=195;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->max_message_size);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtu);

	offset=240;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->peer_lid);

	offset=233;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->my_lid);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

}

void connectib_hw_c_qpc_connected_common_unpack(struct connectib_hw_c_qpc_connected_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->force_loopback = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=2;
	ptr_struct->dual_write = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=44;
	ptr_struct->ipd = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=72;
	ptr_struct->peer_qp = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=64;
	ptr_struct->hop_limit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=97;
	ptr_struct->sx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=96;
	ptr_struct->rx_migreq = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=140;
	ptr_struct->flow_label = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 20);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=195;
	ptr_struct->max_message_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=192;
	ptr_struct->mtu = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=240;
	ptr_struct->peer_lid = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=233;
	ptr_struct->my_lid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_c_qpc_connected_common_print(const struct connectib_hw_c_qpc_connected_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_connected_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_loopback       : "UH_FMT"\n", ptr_struct->force_loopback);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dual_write           : "UH_FMT"\n", ptr_struct->dual_write);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ipd                  : "UH_FMT"\n", ptr_struct->ipd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_qp              : "UH_FMT"\n", ptr_struct->peer_qp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hop_limit            : "UH_FMT"\n", ptr_struct->hop_limit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sx_migreq            : "UH_FMT"\n", ptr_struct->sx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_migreq            : "UH_FMT"\n", ptr_struct->rx_migreq);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_label           : "UH_FMT"\n", ptr_struct->flow_label);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_message_size     : "UH_FMT"\n", ptr_struct->max_message_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtu                  : "UH_FMT"\n", ptr_struct->mtu);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "peer_lid             : "UH_FMT"\n", ptr_struct->peer_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_lid               : "UH_FMT"\n", ptr_struct->my_lid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

}

int connectib_hw_c_qpc_connected_common_size(void){
	 return 64;
}

void connectib_hw_c_qpc_connected_common_dump(const struct connectib_hw_c_qpc_connected_common *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_connected_common_print(ptr_struct, file, 0);
}

void connectib_hw_c_qpc_common_pack(const struct connectib_hw_c_qpc_common *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->rwq_type);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->log_page_size);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->wq_signature);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_valid);

	offset=56;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->tclass);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->context_number);

	offset=98;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->wqe_page_offset);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 12, (u_int32_t)ptr_struct->pkey_table_index);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->my_gid_mac_index);

	offset=268;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->sl);

	offset=267;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->grh_bit);

	offset=266;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->port_number);

	offset=265;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->adaptive_routing);

	offset=260;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->swqe_buffer_size);

	offset=317;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->mtt_pointer_39_37);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->mtt_pointer_36_5);

	offset=360;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->pd);

	offset=352;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->mtt_pointer_4_0);

}

void connectib_hw_c_qpc_common_unpack(struct connectib_hw_c_qpc_common *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=26;
	ptr_struct->rwq_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->log_page_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=1;
	ptr_struct->wq_signature = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->common_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=56;
	ptr_struct->tclass = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=104;
	ptr_struct->context_number = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=98;
	ptr_struct->wqe_page_offset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=128;
	ptr_struct->pkey_table_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 12);

	offset=200;
	ptr_struct->my_gid_mac_index = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=268;
	ptr_struct->sl = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=267;
	ptr_struct->grh_bit = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=266;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=265;
	ptr_struct->adaptive_routing = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=260;
	ptr_struct->swqe_buffer_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=317;
	ptr_struct->mtt_pointer_39_37 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=320;
	ptr_struct->mtt_pointer_36_5 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=360;
	ptr_struct->pd = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=352;
	ptr_struct->mtt_pointer_4_0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_hw_c_qpc_common_print(const struct connectib_hw_c_qpc_common *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_c_qpc_common ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rwq_type             : "UH_FMT"\n", ptr_struct->rwq_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_page_size        : "UH_FMT"\n", ptr_struct->log_page_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wq_signature         : "UH_FMT"\n", ptr_struct->wq_signature);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_valid         : "UH_FMT"\n", ptr_struct->common_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tclass               : "UH_FMT"\n", ptr_struct->tclass);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "context_number       : "UH_FMT"\n", ptr_struct->context_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_page_offset      : "UH_FMT"\n", ptr_struct->wqe_page_offset);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pkey_table_index     : "UH_FMT"\n", ptr_struct->pkey_table_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "my_gid_mac_index     : "UH_FMT"\n", ptr_struct->my_gid_mac_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sl                   : "UH_FMT"\n", ptr_struct->sl);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "grh_bit              : "UH_FMT"\n", ptr_struct->grh_bit);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "adaptive_routing     : "UH_FMT"\n", ptr_struct->adaptive_routing);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "swqe_buffer_size     : "UH_FMT"\n", ptr_struct->swqe_buffer_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_39_37    : "UH_FMT"\n", ptr_struct->mtt_pointer_39_37);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_36_5     : "U32H_FMT"\n", ptr_struct->mtt_pointer_36_5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pd                   : "UH_FMT"\n", ptr_struct->pd);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt_pointer_4_0      : "UH_FMT"\n", ptr_struct->mtt_pointer_4_0);

}

int connectib_hw_c_qpc_common_size(void){
	 return 64;
}

void connectib_hw_c_qpc_common_dump(const struct connectib_hw_c_qpc_common *ptr_struct, FILE* file) {
	connectib_hw_c_qpc_common_print(ptr_struct, file, 0);
}

void connectib_pf_vf_cfg_space_pack(const struct connectib_pf_vf_cfg_space *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_pf_vf_sriov_pack(&(ptr_struct->sriov), ptr_buff + offset/8);

	offset=64;
	connectib_pf_vf_vpd_pack(&(ptr_struct->vpd), ptr_buff + offset/8);

	offset=150;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->hw_msix_vec0);

	offset=149;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->msix_func_mask);

	offset=148;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->msix_enable);

	offset=147;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bus_master_en);

	offset=146;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->memory_space);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->serr_status);

	offset=143;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->serr_enable);

	offset=142;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->perr_enable);

	offset=141;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->int_disable);

	offset=140;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->need_to_fire_flr_event);

	offset=139;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->in_middle_of_flr);

	offset=138;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->hide);

	offset=136;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->power_state);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->cache_line);

	offset=184;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->interrupt_line);

	offset=181;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->exp_rom_en);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 21, (u_int32_t)ptr_struct->exp_rom_addr_31_11);

	offset=223;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_correctable_error_report_en);

	offset=222;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_nonfatal_error_report_en);

	offset=221;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_fatal_error_report_en);

	offset=220;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_ur_error_report_en);

	offset=219;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_enable_relaxed_ordering);

	offset=216;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->device_control_max_payload_size);

	offset=215;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_extended_tag_en);

	offset=214;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_control_enable_no_snoop);

	offset=211;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->device_control_max_read_request_size);

	offset=210;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_status_correctable_error_detected);

	offset=209;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_status_nonfatal_error_detected);

	offset=208;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_status_fatal_error_detected);

	offset=207;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->device_status_ur_error_detected);

	offset=206;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->command_register_memory_space);

	offset=205;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->command_register_bus_master_en);

	offset=204;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->command_register_perr_report_en);

	offset=203;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->command_register_serr_report_en);

	offset=202;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->command_register_interrupt_disable);

	offset=201;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_interrupt_status);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_perr);

	offset=199;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_serr);

	offset=198;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_received_master_abort);

	offset=197;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_received_target_abort);

	offset=196;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->status_register_detected_parity_error);

}

void connectib_pf_vf_cfg_space_unpack(struct connectib_pf_vf_cfg_space *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_pf_vf_sriov_unpack(&(ptr_struct->sriov), ptr_buff + offset/8);

	offset=64;
	connectib_pf_vf_vpd_unpack(&(ptr_struct->vpd), ptr_buff + offset/8);

	offset=150;
	ptr_struct->hw_msix_vec0 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=149;
	ptr_struct->msix_func_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=148;
	ptr_struct->msix_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=147;
	ptr_struct->bus_master_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=146;
	ptr_struct->memory_space = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=144;
	ptr_struct->serr_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=143;
	ptr_struct->serr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=142;
	ptr_struct->perr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=141;
	ptr_struct->int_disable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=140;
	ptr_struct->need_to_fire_flr_event = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=139;
	ptr_struct->in_middle_of_flr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=138;
	ptr_struct->hide = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=136;
	ptr_struct->power_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=128;
	ptr_struct->cache_line = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=184;
	ptr_struct->interrupt_line = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=181;
	ptr_struct->exp_rom_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=160;
	ptr_struct->exp_rom_addr_31_11 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 21);

	offset=223;
	ptr_struct->device_control_correctable_error_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=222;
	ptr_struct->device_control_nonfatal_error_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=221;
	ptr_struct->device_control_fatal_error_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=220;
	ptr_struct->device_control_ur_error_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=219;
	ptr_struct->device_control_enable_relaxed_ordering = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=216;
	ptr_struct->device_control_max_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=215;
	ptr_struct->device_control_extended_tag_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=214;
	ptr_struct->device_control_enable_no_snoop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=211;
	ptr_struct->device_control_max_read_request_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=210;
	ptr_struct->device_status_correctable_error_detected = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=209;
	ptr_struct->device_status_nonfatal_error_detected = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=208;
	ptr_struct->device_status_fatal_error_detected = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=207;
	ptr_struct->device_status_ur_error_detected = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=206;
	ptr_struct->command_register_memory_space = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=205;
	ptr_struct->command_register_bus_master_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=204;
	ptr_struct->command_register_perr_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=203;
	ptr_struct->command_register_serr_report_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=202;
	ptr_struct->command_register_interrupt_disable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=201;
	ptr_struct->status_register_interrupt_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=200;
	ptr_struct->status_register_perr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=199;
	ptr_struct->status_register_serr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=198;
	ptr_struct->status_register_received_master_abort = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=197;
	ptr_struct->status_register_received_target_abort = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=196;
	ptr_struct->status_register_detected_parity_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_pf_vf_cfg_space_print(const struct connectib_pf_vf_cfg_space *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pf_vf_cfg_space ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sriov:\n");
	connectib_pf_vf_sriov_print(&(ptr_struct->sriov), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vpd:\n");
	connectib_pf_vf_vpd_print(&(ptr_struct->vpd), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hw_msix_vec0         : "UH_FMT"\n", ptr_struct->hw_msix_vec0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msix_func_mask       : "UH_FMT"\n", ptr_struct->msix_func_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msix_enable          : "UH_FMT"\n", ptr_struct->msix_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bus_master_en        : "UH_FMT"\n", ptr_struct->bus_master_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_space         : "UH_FMT"\n", ptr_struct->memory_space);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "serr_status          : "UH_FMT"\n", ptr_struct->serr_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "serr_enable          : "UH_FMT"\n", ptr_struct->serr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "perr_enable          : "UH_FMT"\n", ptr_struct->perr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "int_disable          : "UH_FMT"\n", ptr_struct->int_disable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "need_to_fire_flr_event : "UH_FMT"\n", ptr_struct->need_to_fire_flr_event);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "in_middle_of_flr     : "UH_FMT"\n", ptr_struct->in_middle_of_flr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hide                 : "UH_FMT"\n", ptr_struct->hide);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "power_state          : "UH_FMT"\n", ptr_struct->power_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cache_line           : "UH_FMT"\n", ptr_struct->cache_line);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "interrupt_line       : "UH_FMT"\n", ptr_struct->interrupt_line);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "exp_rom_en           : "UH_FMT"\n", ptr_struct->exp_rom_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "exp_rom_addr_31_11   : "UH_FMT"\n", ptr_struct->exp_rom_addr_31_11);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_correctable_error_report_en : "UH_FMT"\n", ptr_struct->device_control_correctable_error_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_nonfatal_error_report_en : "UH_FMT"\n", ptr_struct->device_control_nonfatal_error_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_fatal_error_report_en : "UH_FMT"\n", ptr_struct->device_control_fatal_error_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_ur_error_report_en : "UH_FMT"\n", ptr_struct->device_control_ur_error_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_enable_relaxed_ordering : "UH_FMT"\n", ptr_struct->device_control_enable_relaxed_ordering);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_max_payload_size : "UH_FMT"\n", ptr_struct->device_control_max_payload_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_extended_tag_en : "UH_FMT"\n", ptr_struct->device_control_extended_tag_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_enable_no_snoop : "UH_FMT"\n", ptr_struct->device_control_enable_no_snoop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_control_max_read_request_size : "UH_FMT"\n", ptr_struct->device_control_max_read_request_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_status_correctable_error_detected : "UH_FMT"\n", ptr_struct->device_status_correctable_error_detected);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_status_nonfatal_error_detected : "UH_FMT"\n", ptr_struct->device_status_nonfatal_error_detected);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_status_fatal_error_detected : "UH_FMT"\n", ptr_struct->device_status_fatal_error_detected);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_status_ur_error_detected : "UH_FMT"\n", ptr_struct->device_status_ur_error_detected);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "command_register_memory_space : "UH_FMT"\n", ptr_struct->command_register_memory_space);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "command_register_bus_master_en : "UH_FMT"\n", ptr_struct->command_register_bus_master_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "command_register_perr_report_en : "UH_FMT"\n", ptr_struct->command_register_perr_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "command_register_serr_report_en : "UH_FMT"\n", ptr_struct->command_register_serr_report_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "command_register_interrupt_disable : "UH_FMT"\n", ptr_struct->command_register_interrupt_disable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_interrupt_status : "UH_FMT"\n", ptr_struct->status_register_interrupt_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_perr : "UH_FMT"\n", ptr_struct->status_register_perr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_serr : "UH_FMT"\n", ptr_struct->status_register_serr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_received_master_abort : "UH_FMT"\n", ptr_struct->status_register_received_master_abort);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_received_target_abort : "UH_FMT"\n", ptr_struct->status_register_received_target_abort);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "status_register_detected_parity_error : "UH_FMT"\n", ptr_struct->status_register_detected_parity_error);

}

int connectib_pf_vf_cfg_space_size(void){
	 return 28;
}

void connectib_pf_vf_cfg_space_dump(const struct connectib_pf_vf_cfg_space *ptr_struct, FILE* file) {
	connectib_pf_vf_cfg_space_print(ptr_struct, file, 0);
}

void connectib_hw_init_info_pack(const struct connectib_hw_init_info *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->init_state);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->init_lock);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->owner_pf);

}

void connectib_hw_init_info_unpack(struct connectib_hw_init_info *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->init_state = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=29;
	ptr_struct->init_lock = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->owner_pf = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_hw_init_info_print(const struct connectib_hw_init_info *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_hw_init_info ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "init_state           : "UH_FMT"\n", ptr_struct->init_state);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "init_lock            : "UH_FMT"\n", ptr_struct->init_lock);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "owner_pf             : "UH_FMT"\n", ptr_struct->owner_pf);

}

int connectib_hw_init_info_size(void){
	 return 4;
}

void connectib_hw_init_info_dump(const struct connectib_hw_init_info *ptr_struct, FILE* file) {
	connectib_hw_init_info_print(ptr_struct, file, 0);
}

void connectib_mlnx_enhanced_equal_info_ini_pack(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_100kr4_extended_time_sup);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_100cr4_extended_time_sup);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_40cr4_extended_time_sup);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_40kr4_extended_time_sup);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_kr_extended_time_sup);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->edr_rx_atten_sup);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->edr_rx_atten);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fdr_rx_atten_sup);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->fdr_rx_atten);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->qdr_ddr_ts3_rev);

}

void connectib_mlnx_enhanced_equal_info_ini_unpack(struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->mlpn_100kr4_extended_time_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->mlpn_100cr4_extended_time_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->mlpn_40cr4_extended_time_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->mlpn_40kr4_extended_time_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->mlpn_kr_extended_time_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->edr_rx_atten_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->edr_rx_atten = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=20;
	ptr_struct->fdr_rx_atten_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->fdr_rx_atten = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=14;
	ptr_struct->qdr_ddr_ts3_rev = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_mlnx_enhanced_equal_info_ini_print(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mlnx_enhanced_equal_info_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_100kr4_extended_time_sup : "UH_FMT"\n", ptr_struct->mlpn_100kr4_extended_time_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_100cr4_extended_time_sup : "UH_FMT"\n", ptr_struct->mlpn_100cr4_extended_time_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_40cr4_extended_time_sup : "UH_FMT"\n", ptr_struct->mlpn_40cr4_extended_time_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_40kr4_extended_time_sup : "UH_FMT"\n", ptr_struct->mlpn_40kr4_extended_time_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_kr_extended_time_sup : "UH_FMT"\n", ptr_struct->mlpn_kr_extended_time_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edr_rx_atten_sup     : "UH_FMT"\n", ptr_struct->edr_rx_atten_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edr_rx_atten         : "UH_FMT"\n", ptr_struct->edr_rx_atten);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fdr_rx_atten_sup     : "UH_FMT"\n", ptr_struct->fdr_rx_atten_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fdr_rx_atten         : "UH_FMT"\n", ptr_struct->fdr_rx_atten);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qdr_ddr_ts3_rev      : "UH_FMT"\n", ptr_struct->qdr_ddr_ts3_rev);

}

int connectib_mlnx_enhanced_equal_info_ini_size(void){
	 return 4;
}

void connectib_mlnx_enhanced_equal_info_ini_dump(const struct connectib_mlnx_enhanced_equal_info_ini *ptr_struct, FILE* file) {
	connectib_mlnx_enhanced_equal_info_ini_print(ptr_struct, file, 0);
}

void connectib_mlpn_database_all_protocol_bits_ini_pack(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fdr_8_10);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlx_kr2);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->eth_56gb);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fdr10);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->speed_reduction);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->width_reduction);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->eth_cbf);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ib_64b_credits);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_edr);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_fdr);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_fdr10);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_qdr);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_ddr);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_ib_sdr);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_56_kr4);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_56_kx4);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_kr4);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_cr4);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_slr4);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_kr);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_cr);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_slr);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_xaui);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_sgmii);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fc_protocol);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->eth_protocol);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ib_protocol);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ib_64_66_spec_recovery);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ib_128b_llr);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ll_llr);

}

void connectib_mlpn_database_all_protocol_bits_ini_unpack(struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->fdr_8_10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->mlx_kr2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->eth_56gb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->fdr10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->speed_reduction = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->width_reduction = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->eth_cbf = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->ib_64b_credits = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->llr_ib_edr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->llr_ib_fdr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->llr_ib_fdr10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->llr_ib_qdr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->llr_ib_ddr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->llr_ib_sdr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->llr_56_kr4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->llr_56_kx4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->llr_kr4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->llr_cr4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->llr_slr4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->llr_kr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->llr_cr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->llr_slr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->llr_xaui = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->llr_sgmii = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->fc_protocol = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->eth_protocol = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->ib_protocol = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->ib_64_66_spec_recovery = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->ib_128b_llr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->ll_llr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_mlpn_database_all_protocol_bits_ini_print(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_mlpn_database_all_protocol_bits_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fdr_8_10             : "UH_FMT"\n", ptr_struct->fdr_8_10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlx_kr2              : "UH_FMT"\n", ptr_struct->mlx_kr2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_56gb             : "UH_FMT"\n", ptr_struct->eth_56gb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fdr10                : "UH_FMT"\n", ptr_struct->fdr10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "speed_reduction      : "UH_FMT"\n", ptr_struct->speed_reduction);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "width_reduction      : "UH_FMT"\n", ptr_struct->width_reduction);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_cbf              : "UH_FMT"\n", ptr_struct->eth_cbf);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_64b_credits       : "UH_FMT"\n", ptr_struct->ib_64b_credits);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_edr           : "UH_FMT"\n", ptr_struct->llr_ib_edr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_fdr           : "UH_FMT"\n", ptr_struct->llr_ib_fdr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_fdr10         : "UH_FMT"\n", ptr_struct->llr_ib_fdr10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_qdr           : "UH_FMT"\n", ptr_struct->llr_ib_qdr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_ddr           : "UH_FMT"\n", ptr_struct->llr_ib_ddr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_ib_sdr           : "UH_FMT"\n", ptr_struct->llr_ib_sdr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_56_kr4           : "UH_FMT"\n", ptr_struct->llr_56_kr4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_56_kx4           : "UH_FMT"\n", ptr_struct->llr_56_kx4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_kr4              : "UH_FMT"\n", ptr_struct->llr_kr4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_cr4              : "UH_FMT"\n", ptr_struct->llr_cr4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_slr4             : "UH_FMT"\n", ptr_struct->llr_slr4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_kr               : "UH_FMT"\n", ptr_struct->llr_kr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_cr               : "UH_FMT"\n", ptr_struct->llr_cr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_slr              : "UH_FMT"\n", ptr_struct->llr_slr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_xaui             : "UH_FMT"\n", ptr_struct->llr_xaui);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_sgmii            : "UH_FMT"\n", ptr_struct->llr_sgmii);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_protocol          : "UH_FMT"\n", ptr_struct->fc_protocol);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eth_protocol         : "UH_FMT"\n", ptr_struct->eth_protocol);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_protocol          : "UH_FMT"\n", ptr_struct->ib_protocol);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_64_66_spec_recovery : "UH_FMT"\n", ptr_struct->ib_64_66_spec_recovery);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ib_128b_llr          : "UH_FMT"\n", ptr_struct->ib_128b_llr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ll_llr               : "UH_FMT"\n", ptr_struct->ll_llr);

}

int connectib_mlpn_database_all_protocol_bits_ini_size(void){
	 return 4;
}

void connectib_mlpn_database_all_protocol_bits_ini_dump(const struct connectib_mlpn_database_all_protocol_bits_ini *ptr_struct, FILE* file) {
	connectib_mlpn_database_all_protocol_bits_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_preset_sets_ini_pack(const struct connectib_serdes_preset_sets_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_preset_tx_ini_pack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_preset_sets_ini_unpack(struct connectib_serdes_preset_sets_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_preset_tx_ini_unpack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_preset_sets_ini_print(const struct connectib_serdes_preset_sets_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_preset_sets_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx:\n");
	connectib_serdes_conf_preset_tx_ini_print(&(ptr_struct->tx), file, indent_level + 1);

}

int connectib_serdes_preset_sets_ini_size(void){
	 return 64;
}

void connectib_serdes_preset_sets_ini_dump(const struct connectib_serdes_preset_sets_ini *ptr_struct, FILE* file) {
	connectib_serdes_preset_sets_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_active_sets_ini_pack(const struct connectib_serdes_active_sets_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_active_rx_ini_pack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=256;
	connectib_serdes_active_tx_ini_pack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_active_sets_ini_unpack(struct connectib_serdes_active_sets_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_active_rx_ini_unpack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=256;
	connectib_serdes_active_tx_ini_unpack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_active_sets_ini_print(const struct connectib_serdes_active_sets_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_active_sets_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx:\n");
	connectib_serdes_active_rx_ini_print(&(ptr_struct->rx), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx:\n");
	connectib_serdes_active_tx_ini_print(&(ptr_struct->tx), file, indent_level + 1);

}

int connectib_serdes_active_sets_ini_size(void){
	 return 48;
}

void connectib_serdes_active_sets_ini_dump(const struct connectib_serdes_active_sets_ini *ptr_struct, FILE* file) {
	connectib_serdes_active_sets_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_force_sets_ini_pack(const struct connectib_serdes_force_sets_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_force_rx_ini_pack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=640;
	connectib_serdes_force_tx_ini_pack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_force_sets_ini_unpack(struct connectib_serdes_force_sets_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_force_rx_ini_unpack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=640;
	connectib_serdes_force_tx_ini_unpack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_force_sets_ini_print(const struct connectib_serdes_force_sets_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_force_sets_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx:\n");
	connectib_serdes_force_rx_ini_print(&(ptr_struct->rx), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx:\n");
	connectib_serdes_force_tx_ini_print(&(ptr_struct->tx), file, indent_level + 1);

}

int connectib_serdes_force_sets_ini_size(void){
	 return 120;
}

void connectib_serdes_force_sets_ini_dump(const struct connectib_serdes_force_sets_ini *ptr_struct, FILE* file) {
	connectib_serdes_force_sets_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_aba_sets_ini_pack(const struct connectib_serdes_aba_sets_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_aba_rx_ini_pack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=2048;
	connectib_serdes_conf_aba_tx_ini_pack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_aba_sets_ini_unpack(struct connectib_serdes_aba_sets_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_aba_rx_ini_unpack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=2048;
	connectib_serdes_conf_aba_tx_ini_unpack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_aba_sets_ini_print(const struct connectib_serdes_aba_sets_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_aba_sets_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx:\n");
	connectib_serdes_conf_aba_rx_ini_print(&(ptr_struct->rx), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx:\n");
	connectib_serdes_conf_aba_tx_ini_print(&(ptr_struct->tx), file, indent_level + 1);

}

int connectib_serdes_aba_sets_ini_size(void){
	 return 384;
}

void connectib_serdes_aba_sets_ini_dump(const struct connectib_serdes_aba_sets_ini *ptr_struct, FILE* file) {
	connectib_serdes_aba_sets_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_autoneg_sets_ini_pack(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_autoneg_rx_ini_pack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=2048;
	connectib_serdes_conf_autoneg_tx_ini_pack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_autoneg_sets_ini_unpack(struct connectib_serdes_autoneg_sets_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_conf_autoneg_rx_ini_unpack(&(ptr_struct->rx), ptr_buff + offset/8);

	offset=2048;
	connectib_serdes_conf_autoneg_tx_ini_unpack(&(ptr_struct->tx), ptr_buff + offset/8);

}

void connectib_serdes_autoneg_sets_ini_print(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_autoneg_sets_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx:\n");
	connectib_serdes_conf_autoneg_rx_ini_print(&(ptr_struct->rx), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx:\n");
	connectib_serdes_conf_autoneg_tx_ini_print(&(ptr_struct->tx), file, indent_level + 1);

}

int connectib_serdes_autoneg_sets_ini_size(void){
	 return 384;
}

void connectib_serdes_autoneg_sets_ini_dump(const struct connectib_serdes_autoneg_sets_ini *ptr_struct, FILE* file) {
	connectib_serdes_autoneg_sets_ini_print(ptr_struct, file, 0);
}

void connectib_spec1_3_preset_ini_pack(const struct connectib_spec1_3_preset_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->preset_tx_mask_internal);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->preset_tx_mask);

	offset=59;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask0_start);

	offset=51;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask0_end);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->tx_ABA_en_mask);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask0);

	offset=91;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask1_start);

	offset=83;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask1_end);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->tx_ABA_mode_mask);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask1);

	offset=123;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask2_start);

	offset=115;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask2_end);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask2);

	offset=155;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask3_start);

	offset=147;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask3_end);

	offset=128;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask3);

	offset=187;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask4_start);

	offset=179;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask4_end);

	offset=160;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask4);

	offset=219;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask5_start);

	offset=211;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->aba_mask5_end);

	offset=192;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->aba_mask5);

	offset=224;
	connectib_aba_indexes_pack(&(ptr_struct->aba_indexes), ptr_buff + offset/8);

}

void connectib_spec1_3_preset_ini_unpack(struct connectib_spec1_3_preset_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->preset_tx_mask_internal = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=0;
	ptr_struct->preset_tx_mask = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=59;
	ptr_struct->aba_mask0_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=51;
	ptr_struct->aba_mask0_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=48;
	ptr_struct->tx_ABA_en_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=32;
	ptr_struct->aba_mask0 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=91;
	ptr_struct->aba_mask1_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=83;
	ptr_struct->aba_mask1_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=80;
	ptr_struct->tx_ABA_mode_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=64;
	ptr_struct->aba_mask1 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=123;
	ptr_struct->aba_mask2_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=115;
	ptr_struct->aba_mask2_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=96;
	ptr_struct->aba_mask2 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=155;
	ptr_struct->aba_mask3_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=147;
	ptr_struct->aba_mask3_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=128;
	ptr_struct->aba_mask3 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=187;
	ptr_struct->aba_mask4_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=179;
	ptr_struct->aba_mask4_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=160;
	ptr_struct->aba_mask4 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=219;
	ptr_struct->aba_mask5_start = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=211;
	ptr_struct->aba_mask5_end = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=192;
	ptr_struct->aba_mask5 = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=224;
	connectib_aba_indexes_unpack(&(ptr_struct->aba_indexes), ptr_buff + offset/8);

}

void connectib_spec1_3_preset_ini_print(const struct connectib_spec1_3_preset_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_spec1_3_preset_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "preset_tx_mask_internal : "UH_FMT"\n", ptr_struct->preset_tx_mask_internal);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "preset_tx_mask       : "UH_FMT"\n", ptr_struct->preset_tx_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask0_start      : "UH_FMT"\n", ptr_struct->aba_mask0_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask0_end        : "UH_FMT"\n", ptr_struct->aba_mask0_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_ABA_en_mask       : "UH_FMT"\n", ptr_struct->tx_ABA_en_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask0            : "UH_FMT"\n", ptr_struct->aba_mask0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask1_start      : "UH_FMT"\n", ptr_struct->aba_mask1_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask1_end        : "UH_FMT"\n", ptr_struct->aba_mask1_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_ABA_mode_mask     : "UH_FMT"\n", ptr_struct->tx_ABA_mode_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask1            : "UH_FMT"\n", ptr_struct->aba_mask1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask2_start      : "UH_FMT"\n", ptr_struct->aba_mask2_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask2_end        : "UH_FMT"\n", ptr_struct->aba_mask2_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask2            : "UH_FMT"\n", ptr_struct->aba_mask2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask3_start      : "UH_FMT"\n", ptr_struct->aba_mask3_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask3_end        : "UH_FMT"\n", ptr_struct->aba_mask3_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask3            : "UH_FMT"\n", ptr_struct->aba_mask3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask4_start      : "UH_FMT"\n", ptr_struct->aba_mask4_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask4_end        : "UH_FMT"\n", ptr_struct->aba_mask4_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask4            : "UH_FMT"\n", ptr_struct->aba_mask4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask5_start      : "UH_FMT"\n", ptr_struct->aba_mask5_start);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask5_end        : "UH_FMT"\n", ptr_struct->aba_mask5_end);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_mask5            : "UH_FMT"\n", ptr_struct->aba_mask5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aba_indexes:\n");
	connectib_aba_indexes_print(&(ptr_struct->aba_indexes), file, indent_level + 1);

}

int connectib_spec1_3_preset_ini_size(void){
	 return 76;
}

void connectib_spec1_3_preset_ini_dump(const struct connectib_spec1_3_preset_ini *ptr_struct, FILE* file) {
	connectib_spec1_3_preset_ini_print(ptr_struct, file, 0);
}

void connectib_ib_ini_per_lcl_ini_pack(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->spec1_2_ib_support);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->spec1_3_ib_support);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fec_request_fdr);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fec_request_fdr10);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->heartbeat_enable);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->force_speed_val);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_speed_en);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->force_width_val);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_width_en);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_qdr_is_fdr10_val);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_qdr_is_fdr10_en);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_llr_fdr_en);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_llr_fdr_val);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_llr_fdr10_en);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->force_llr_fdr10_val);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mlpn_en);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_cell_size);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->speed_reduction_force);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->width_reduction_force);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_fdr10_force);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_fdr_force);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->spec1_2_legacy_mode);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->llr_disable_failsafe);

}

void connectib_ib_ini_per_lcl_ini_unpack(struct connectib_ib_ini_per_lcl_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->spec1_2_ib_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->spec1_3_ib_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->fec_request_fdr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->fec_request_fdr10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->heartbeat_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->force_speed_val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=22;
	ptr_struct->force_speed_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->force_width_val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=17;
	ptr_struct->force_width_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->force_qdr_is_fdr10_val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->force_qdr_is_fdr10_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->force_llr_fdr_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->force_llr_fdr_val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->force_llr_fdr10_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->force_llr_fdr10_val = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->mlpn_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->llr_cell_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->speed_reduction_force = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->width_reduction_force = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->llr_fdr10_force = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->llr_fdr_force = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->spec1_2_legacy_mode = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->llr_disable_failsafe = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_ib_ini_per_lcl_ini_print(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ib_ini_per_lcl_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "spec1_2_ib_support   : "UH_FMT"\n", ptr_struct->spec1_2_ib_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "spec1_3_ib_support   : "UH_FMT"\n", ptr_struct->spec1_3_ib_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_request_fdr      : "UH_FMT"\n", ptr_struct->fec_request_fdr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fec_request_fdr10    : "UH_FMT"\n", ptr_struct->fec_request_fdr10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "heartbeat_enable     : "UH_FMT"\n", ptr_struct->heartbeat_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_speed_val      : "UH_FMT"\n", ptr_struct->force_speed_val);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_speed_en       : "UH_FMT"\n", ptr_struct->force_speed_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_width_val      : "UH_FMT"\n", ptr_struct->force_width_val);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_width_en       : "UH_FMT"\n", ptr_struct->force_width_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_qdr_is_fdr10_val : "UH_FMT"\n", ptr_struct->force_qdr_is_fdr10_val);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_qdr_is_fdr10_en : "UH_FMT"\n", ptr_struct->force_qdr_is_fdr10_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_llr_fdr_en     : "UH_FMT"\n", ptr_struct->force_llr_fdr_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_llr_fdr_val    : "UH_FMT"\n", ptr_struct->force_llr_fdr_val);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_llr_fdr10_en   : "UH_FMT"\n", ptr_struct->force_llr_fdr10_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "force_llr_fdr10_val  : "UH_FMT"\n", ptr_struct->force_llr_fdr10_val);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mlpn_en              : "UH_FMT"\n", ptr_struct->mlpn_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_cell_size        : "UH_FMT"\n", ptr_struct->llr_cell_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "speed_reduction_force : "UH_FMT"\n", ptr_struct->speed_reduction_force);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "width_reduction_force : "UH_FMT"\n", ptr_struct->width_reduction_force);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_fdr10_force      : "UH_FMT"\n", ptr_struct->llr_fdr10_force);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_fdr_force        : "UH_FMT"\n", ptr_struct->llr_fdr_force);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "spec1_2_legacy_mode  : "UH_FMT"\n", ptr_struct->spec1_2_legacy_mode);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_disable_failsafe : "UH_FMT"\n", ptr_struct->llr_disable_failsafe);

}

int connectib_ib_ini_per_lcl_ini_size(void){
	 return 4;
}

void connectib_ib_ini_per_lcl_ini_dump(const struct connectib_ib_ini_per_lcl_ini *ptr_struct, FILE* file) {
	connectib_ib_ini_per_lcl_ini_print(ptr_struct, file, 0);
}

void connectib_serdes_param_mask_ini_pack(const struct connectib_serdes_param_mask_ini *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_param_mask_per_proto_ini_pack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset=32;
	connectib_serdes_param_mask_per_proto_ini_pack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset=64;
	connectib_serdes_param_mask_per_proto_ini_pack(&(ptr_struct->encode_kr), ptr_buff + offset/8);

	offset=96;
	connectib_serdes_param_mask_per_proto_ini_pack(&(ptr_struct->fdr), ptr_buff + offset/8);

}

void connectib_serdes_param_mask_ini_unpack(struct connectib_serdes_param_mask_ini *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	connectib_serdes_param_mask_per_proto_ini_unpack(&(ptr_struct->encode_8_10), ptr_buff + offset/8);

	offset=32;
	connectib_serdes_param_mask_per_proto_ini_unpack(&(ptr_struct->encode_64_66), ptr_buff + offset/8);

	offset=64;
	connectib_serdes_param_mask_per_proto_ini_unpack(&(ptr_struct->encode_kr), ptr_buff + offset/8);

	offset=96;
	connectib_serdes_param_mask_per_proto_ini_unpack(&(ptr_struct->fdr), ptr_buff + offset/8);

}

void connectib_serdes_param_mask_ini_print(const struct connectib_serdes_param_mask_ini *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_serdes_param_mask_ini ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_8_10:\n");
	connectib_serdes_param_mask_per_proto_ini_print(&(ptr_struct->encode_8_10), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_64_66:\n");
	connectib_serdes_param_mask_per_proto_ini_print(&(ptr_struct->encode_64_66), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "encode_kr:\n");
	connectib_serdes_param_mask_per_proto_ini_print(&(ptr_struct->encode_kr), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fdr:\n");
	connectib_serdes_param_mask_per_proto_ini_print(&(ptr_struct->fdr), file, indent_level + 1);

}

int connectib_serdes_param_mask_ini_size(void){
	 return 16;
}

void connectib_serdes_param_mask_ini_dump(const struct connectib_serdes_param_mask_ini *ptr_struct, FILE* file) {
	connectib_serdes_param_mask_ini_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_data_tpt_capabilities_pack(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->log_max_payload_size_supported);

}

void connectib_nv_tlv_data_tpt_capabilities_unpack(struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->log_max_payload_size_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_nv_tlv_data_tpt_capabilities_print(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_data_tpt_capabilities ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_payload_size_supported : "UH_FMT"\n", ptr_struct->log_max_payload_size_supported);

}

int connectib_nv_tlv_data_tpt_capabilities_size(void){
	 return 4;
}

void connectib_nv_tlv_data_tpt_capabilities_dump(const struct connectib_nv_tlv_data_tpt_capabilities *ptr_struct, FILE* file) {
	connectib_nv_tlv_data_tpt_capabilities_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_data_tpt_settings_pack(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->log_max_payload_size);

}

void connectib_nv_tlv_data_tpt_settings_unpack(struct connectib_nv_tlv_data_tpt_settings *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->log_max_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_nv_tlv_data_tpt_settings_print(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_data_tpt_settings ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_max_payload_size : "UH_FMT"\n", ptr_struct->log_max_payload_size);

}

int connectib_nv_tlv_data_tpt_settings_size(void){
	 return 4;
}

void connectib_nv_tlv_data_tpt_settings_dump(const struct connectib_nv_tlv_data_tpt_settings *ptr_struct, FILE* file) {
	connectib_nv_tlv_data_tpt_settings_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_data_pci_capabilities_pack(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pf_bar_size_supported);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_bar_size_supported);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_pf_msix_supported);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_vf_msix_supported);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_pfs_supported);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->max_log_total_bar_valid);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->max_total_msix_valid);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->max_vfs_per_pf_valid);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->max_vfs_per_pf);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_num_pfs);

	offset=34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fpp_support);

	offset=33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_qos_control_support);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sriov_support);

	offset=90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->max_log_pf_uar_bar_size);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->max_log_vf_uar_bar_size);

	offset=74;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->max_num_pf_msix);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->max_num_vf_msix);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->max_total_msix);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->max_total_bar_MB);

}

void connectib_nv_tlv_data_pci_capabilities_unpack(struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	ptr_struct->pf_bar_size_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->vf_bar_size_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->num_pf_msix_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->num_vf_msix_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->num_pfs_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->max_log_total_bar_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->max_total_msix_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->max_vfs_per_pf_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->max_vfs_per_pf = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=44;
	ptr_struct->max_num_pfs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=34;
	ptr_struct->fpp_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=33;
	ptr_struct->vf_qos_control_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->sriov_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=90;
	ptr_struct->max_log_pf_uar_bar_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=84;
	ptr_struct->max_log_vf_uar_bar_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=74;
	ptr_struct->max_num_pf_msix = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=64;
	ptr_struct->max_num_vf_msix = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=96;
	ptr_struct->max_total_msix = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->max_total_bar_MB = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_nv_tlv_data_pci_capabilities_print(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_data_pci_capabilities ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pf_bar_size_supported : "UH_FMT"\n", ptr_struct->pf_bar_size_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_bar_size_supported : "UH_FMT"\n", ptr_struct->vf_bar_size_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pf_msix_supported : "UH_FMT"\n", ptr_struct->num_pf_msix_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_vf_msix_supported : "UH_FMT"\n", ptr_struct->num_vf_msix_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pfs_supported    : "UH_FMT"\n", ptr_struct->num_pfs_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_log_total_bar_valid : "UH_FMT"\n", ptr_struct->max_log_total_bar_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_total_msix_valid : "UH_FMT"\n", ptr_struct->max_total_msix_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_vfs_per_pf_valid : "UH_FMT"\n", ptr_struct->max_vfs_per_pf_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_vfs_per_pf       : "UH_FMT"\n", ptr_struct->max_vfs_per_pf);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_num_pfs          : "UH_FMT"\n", ptr_struct->max_num_pfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpp_support          : "UH_FMT"\n", ptr_struct->fpp_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_qos_control_support : "UH_FMT"\n", ptr_struct->vf_qos_control_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sriov_support        : "UH_FMT"\n", ptr_struct->sriov_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_log_pf_uar_bar_size : "UH_FMT"\n", ptr_struct->max_log_pf_uar_bar_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_log_vf_uar_bar_size : "UH_FMT"\n", ptr_struct->max_log_vf_uar_bar_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_num_pf_msix      : "UH_FMT"\n", ptr_struct->max_num_pf_msix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_num_vf_msix      : "UH_FMT"\n", ptr_struct->max_num_vf_msix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_total_msix       : "U32H_FMT"\n", ptr_struct->max_total_msix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_total_bar_MB     : "U32H_FMT"\n", ptr_struct->max_total_bar_MB);

}

int connectib_nv_tlv_data_pci_capabilities_size(void){
	 return 20;
}

void connectib_nv_tlv_data_pci_capabilities_dump(const struct connectib_nv_tlv_data_pci_capabilities *ptr_struct, FILE* file) {
	connectib_nv_tlv_data_pci_capabilities_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_data_pci_settings_pack(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->pf_bar_size_valid);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_bar_size_valid);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_pf_msix_valid);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_vf_msix_valid);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->num_pfs_valid);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fpp_valid);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->full_vf_qos_valid);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sriov_valid);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->total_vfs);

	offset=44;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->num_pfs);

	offset=34;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fpp_en);

	offset=33;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->full_vf_qos);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->sriov_en);

	offset=90;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log_pf_uar_bar_size);

	offset=84;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->log_vf_uar_bar_size);

	offset=74;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->num_pf_msix);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 10, (u_int32_t)ptr_struct->num_vf_msix);

}

void connectib_nv_tlv_data_pci_settings_unpack(struct connectib_nv_tlv_data_pci_settings *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=7;
	ptr_struct->pf_bar_size_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->vf_bar_size_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->num_pf_msix_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->num_vf_msix_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->num_pfs_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->fpp_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->full_vf_qos_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->sriov_valid = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=48;
	ptr_struct->total_vfs = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=44;
	ptr_struct->num_pfs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=34;
	ptr_struct->fpp_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=33;
	ptr_struct->full_vf_qos = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=32;
	ptr_struct->sriov_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=90;
	ptr_struct->log_pf_uar_bar_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=84;
	ptr_struct->log_vf_uar_bar_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=74;
	ptr_struct->num_pf_msix = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

	offset=64;
	ptr_struct->num_vf_msix = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 10);

}

void connectib_nv_tlv_data_pci_settings_print(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_data_pci_settings ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "pf_bar_size_valid    : "UH_FMT"\n", ptr_struct->pf_bar_size_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_bar_size_valid    : "UH_FMT"\n", ptr_struct->vf_bar_size_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pf_msix_valid    : "UH_FMT"\n", ptr_struct->num_pf_msix_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_vf_msix_valid    : "UH_FMT"\n", ptr_struct->num_vf_msix_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pfs_valid        : "UH_FMT"\n", ptr_struct->num_pfs_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpp_valid            : "UH_FMT"\n", ptr_struct->fpp_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "full_vf_qos_valid    : "UH_FMT"\n", ptr_struct->full_vf_qos_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sriov_valid          : "UH_FMT"\n", ptr_struct->sriov_valid);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "total_vfs            : "UH_FMT"\n", ptr_struct->total_vfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pfs              : "UH_FMT"\n", ptr_struct->num_pfs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fpp_en               : "UH_FMT"\n", ptr_struct->fpp_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "full_vf_qos          : "UH_FMT"\n", ptr_struct->full_vf_qos);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sriov_en             : "UH_FMT"\n", ptr_struct->sriov_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_pf_uar_bar_size  : "UH_FMT"\n", ptr_struct->log_pf_uar_bar_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "log_vf_uar_bar_size  : "UH_FMT"\n", ptr_struct->log_vf_uar_bar_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pf_msix          : "UH_FMT"\n", ptr_struct->num_pf_msix);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_vf_msix          : "UH_FMT"\n", ptr_struct->num_vf_msix);

}

int connectib_nv_tlv_data_pci_settings_size(void){
	 return 12;
}

void connectib_nv_tlv_data_pci_settings_dump(const struct connectib_nv_tlv_data_pci_settings *ptr_struct, FILE* file) {
	connectib_nv_tlv_data_pci_settings_print(ptr_struct, file, 0);
}

void connectib_header_log_pack(const struct connectib_header_log *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hdr_127_96);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hdr_95_64);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hdr_63_32);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->hdr_31_0);

}

void connectib_header_log_unpack(struct connectib_header_log *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->hdr_127_96 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->hdr_95_64 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->hdr_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->hdr_31_0 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_header_log_print(const struct connectib_header_log *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_header_log ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hdr_127_96           : "U32H_FMT"\n", ptr_struct->hdr_127_96);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hdr_95_64            : "U32H_FMT"\n", ptr_struct->hdr_95_64);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hdr_63_32            : "U32H_FMT"\n", ptr_struct->hdr_63_32);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hdr_31_0             : "U32H_FMT"\n", ptr_struct->hdr_31_0);

}

int connectib_header_log_size(void){
	 return 16;
}

void connectib_header_log_dump(const struct connectib_header_log *ptr_struct, FILE* file) {
	connectib_header_log_print(ptr_struct, file, 0);
}

void connectib_advanced_error_cap_ctl_pack(const struct connectib_advanced_error_cap_ctl *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->first_error_pointer);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_generation_cap);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_generation_enable);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_check_cap);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_check_enable);

}

void connectib_advanced_error_cap_ctl_unpack(struct connectib_advanced_error_cap_ctl *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=27;
	ptr_struct->first_error_pointer = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

	offset=26;
	ptr_struct->ecrc_generation_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->ecrc_generation_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->ecrc_check_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->ecrc_check_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_advanced_error_cap_ctl_print(const struct connectib_advanced_error_cap_ctl *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_advanced_error_cap_ctl ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "first_error_pointer  : "UH_FMT"\n", ptr_struct->first_error_pointer);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_generation_cap  : "UH_FMT"\n", ptr_struct->ecrc_generation_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_generation_enable : "UH_FMT"\n", ptr_struct->ecrc_generation_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_check_cap       : "UH_FMT"\n", ptr_struct->ecrc_check_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_check_enable    : "UH_FMT"\n", ptr_struct->ecrc_check_enable);

}

int connectib_advanced_error_cap_ctl_size(void){
	 return 4;
}

void connectib_advanced_error_cap_ctl_dump(const struct connectib_advanced_error_cap_ctl *ptr_struct, FILE* file) {
	connectib_advanced_error_cap_ctl_print(ptr_struct, file, 0);
}

void connectib_correctable_error_mask_pack(const struct connectib_correctable_error_mask *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->receiver_error_mask);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved1);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved2);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved3);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved4);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved5);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bad_tlp_mask);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bad_dllp_mask);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->replay_num_rollover_mask);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved9);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved10);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved11);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->replay_timer_timeout_mask);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->advisory_non_fatal_err_mask);

}

void connectib_correctable_error_mask_unpack(struct connectib_correctable_error_mask *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->receiver_error_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->reserved1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->reserved2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->reserved3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->reserved4 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->reserved5 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->bad_tlp_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->bad_dllp_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->replay_num_rollover_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->reserved9 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->reserved10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->reserved11 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->replay_timer_timeout_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->advisory_non_fatal_err_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_correctable_error_mask_print(const struct connectib_correctable_error_mask *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_correctable_error_mask ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_error_mask  : "UH_FMT"\n", ptr_struct->receiver_error_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved1            : "UH_FMT"\n", ptr_struct->reserved1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved2            : "UH_FMT"\n", ptr_struct->reserved2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved3            : "UH_FMT"\n", ptr_struct->reserved3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved4            : "UH_FMT"\n", ptr_struct->reserved4);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved5            : "UH_FMT"\n", ptr_struct->reserved5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bad_tlp_mask         : "UH_FMT"\n", ptr_struct->bad_tlp_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bad_dllp_mask        : "UH_FMT"\n", ptr_struct->bad_dllp_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "replay_num_rollover_mask : "UH_FMT"\n", ptr_struct->replay_num_rollover_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved9            : "UH_FMT"\n", ptr_struct->reserved9);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved10           : "UH_FMT"\n", ptr_struct->reserved10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved11           : "UH_FMT"\n", ptr_struct->reserved11);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "replay_timer_timeout_mask : "UH_FMT"\n", ptr_struct->replay_timer_timeout_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "advisory_non_fatal_err_mask : "UH_FMT"\n", ptr_struct->advisory_non_fatal_err_mask);

}

int connectib_correctable_error_mask_size(void){
	 return 4;
}

void connectib_correctable_error_mask_dump(const struct connectib_correctable_error_mask *ptr_struct, FILE* file) {
	connectib_correctable_error_mask_print(ptr_struct, file, 0);
}

void connectib_correctable_error_status_pack(const struct connectib_correctable_error_status *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->receiver_error_status);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bad_tlp_status);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bad_dllp_status);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->replay_num_rollover_status);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->replay_timer_timeout_status);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->advisory_nonftl_err_status);

}

void connectib_correctable_error_status_unpack(struct connectib_correctable_error_status *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->receiver_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->bad_tlp_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->bad_dllp_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->replay_num_rollover_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->replay_timer_timeout_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->advisory_nonftl_err_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_correctable_error_status_print(const struct connectib_correctable_error_status *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_correctable_error_status ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_error_status : "UH_FMT"\n", ptr_struct->receiver_error_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bad_tlp_status       : "UH_FMT"\n", ptr_struct->bad_tlp_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bad_dllp_status      : "UH_FMT"\n", ptr_struct->bad_dllp_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "replay_num_rollover_status : "UH_FMT"\n", ptr_struct->replay_num_rollover_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "replay_timer_timeout_status : "UH_FMT"\n", ptr_struct->replay_timer_timeout_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "advisory_nonftl_err_status : "UH_FMT"\n", ptr_struct->advisory_nonftl_err_status);

}

int connectib_correctable_error_status_size(void){
	 return 4;
}

void connectib_correctable_error_status_dump(const struct connectib_correctable_error_status *ptr_struct, FILE* file) {
	connectib_correctable_error_status_print(ptr_struct, file, 0);
}

void connectib_uncorrectable_error_severity_pack(const struct connectib_uncorrectable_error_severity *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->training_error_severity);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved1);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved2);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved3);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->data_link_protocol_error);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved5);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved6);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved7);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved8);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved9);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved10);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved11);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->poisoned_tlp);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->flow_control_protocol_error);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completion_timeout);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completer_abort);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unexpected_completion);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->receiver_overflow);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->malformed_tlp);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_error);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unsupported_request_error);

}

void connectib_uncorrectable_error_severity_unpack(struct connectib_uncorrectable_error_severity *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->training_error_severity = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->reserved1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->reserved2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->reserved3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->data_link_protocol_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->reserved5 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->reserved6 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->reserved7 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->reserved8 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->reserved9 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->reserved10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->reserved11 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->poisoned_tlp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->flow_control_protocol_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->completion_timeout = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->completer_abort = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->unexpected_completion = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->receiver_overflow = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->malformed_tlp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->ecrc_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->unsupported_request_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_uncorrectable_error_severity_print(const struct connectib_uncorrectable_error_severity *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_uncorrectable_error_severity ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "training_error_severity : "UH_FMT"\n", ptr_struct->training_error_severity);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved1            : "UH_FMT"\n", ptr_struct->reserved1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved2            : "UH_FMT"\n", ptr_struct->reserved2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved3            : "UH_FMT"\n", ptr_struct->reserved3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_link_protocol_error : "UH_FMT"\n", ptr_struct->data_link_protocol_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved5            : "UH_FMT"\n", ptr_struct->reserved5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved6            : "UH_FMT"\n", ptr_struct->reserved6);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved7            : "UH_FMT"\n", ptr_struct->reserved7);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved8            : "UH_FMT"\n", ptr_struct->reserved8);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved9            : "UH_FMT"\n", ptr_struct->reserved9);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved10           : "UH_FMT"\n", ptr_struct->reserved10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved11           : "UH_FMT"\n", ptr_struct->reserved11);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "poisoned_tlp         : "UH_FMT"\n", ptr_struct->poisoned_tlp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_control_protocol_error : "UH_FMT"\n", ptr_struct->flow_control_protocol_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout   : "UH_FMT"\n", ptr_struct->completion_timeout);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completer_abort      : "UH_FMT"\n", ptr_struct->completer_abort);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unexpected_completion : "UH_FMT"\n", ptr_struct->unexpected_completion);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_overflow    : "UH_FMT"\n", ptr_struct->receiver_overflow);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "malformed_tlp        : "UH_FMT"\n", ptr_struct->malformed_tlp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_error           : "UH_FMT"\n", ptr_struct->ecrc_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unsupported_request_error : "UH_FMT"\n", ptr_struct->unsupported_request_error);

}

int connectib_uncorrectable_error_severity_size(void){
	 return 4;
}

void connectib_uncorrectable_error_severity_dump(const struct connectib_uncorrectable_error_severity *ptr_struct, FILE* file) {
	connectib_uncorrectable_error_severity_print(ptr_struct, file, 0);
}

void connectib_uncorrectable_error_mask_pack(const struct connectib_uncorrectable_error_mask *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->training_error_mask);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved1);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved2);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved3);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->data_link_protocol_error);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved5);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved6);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved7);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved8);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved9);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved10);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->reserved11);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->poisoned_tlp);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->flow_control_protocol_error);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completion_timeout);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completer_abort);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unexpected_completion);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->receiver_overflow);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->malformed_tlp);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_error);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unsupported_request_error);

}

void connectib_uncorrectable_error_mask_unpack(struct connectib_uncorrectable_error_mask *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->training_error_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->reserved1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->reserved2 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->reserved3 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->data_link_protocol_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->reserved5 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->reserved6 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->reserved7 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->reserved8 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->reserved9 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->reserved10 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->reserved11 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->poisoned_tlp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->flow_control_protocol_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->completion_timeout = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->completer_abort = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->unexpected_completion = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->receiver_overflow = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->malformed_tlp = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->ecrc_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->unsupported_request_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_uncorrectable_error_mask_print(const struct connectib_uncorrectable_error_mask *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_uncorrectable_error_mask ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "training_error_mask  : "UH_FMT"\n", ptr_struct->training_error_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved1            : "UH_FMT"\n", ptr_struct->reserved1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved2            : "UH_FMT"\n", ptr_struct->reserved2);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved3            : "UH_FMT"\n", ptr_struct->reserved3);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_link_protocol_error : "UH_FMT"\n", ptr_struct->data_link_protocol_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved5            : "UH_FMT"\n", ptr_struct->reserved5);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved6            : "UH_FMT"\n", ptr_struct->reserved6);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved7            : "UH_FMT"\n", ptr_struct->reserved7);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved8            : "UH_FMT"\n", ptr_struct->reserved8);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved9            : "UH_FMT"\n", ptr_struct->reserved9);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved10           : "UH_FMT"\n", ptr_struct->reserved10);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "reserved11           : "UH_FMT"\n", ptr_struct->reserved11);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "poisoned_tlp         : "UH_FMT"\n", ptr_struct->poisoned_tlp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_control_protocol_error : "UH_FMT"\n", ptr_struct->flow_control_protocol_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout   : "UH_FMT"\n", ptr_struct->completion_timeout);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completer_abort      : "UH_FMT"\n", ptr_struct->completer_abort);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unexpected_completion : "UH_FMT"\n", ptr_struct->unexpected_completion);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_overflow    : "UH_FMT"\n", ptr_struct->receiver_overflow);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "malformed_tlp        : "UH_FMT"\n", ptr_struct->malformed_tlp);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_error           : "UH_FMT"\n", ptr_struct->ecrc_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unsupported_request_error : "UH_FMT"\n", ptr_struct->unsupported_request_error);

}

int connectib_uncorrectable_error_mask_size(void){
	 return 4;
}

void connectib_uncorrectable_error_mask_dump(const struct connectib_uncorrectable_error_mask *ptr_struct, FILE* file) {
	connectib_uncorrectable_error_mask_print(ptr_struct, file, 0);
}

void connectib_uncorrectable_error_status_pack(const struct connectib_uncorrectable_error_status *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->training_error_status);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->data_link_protocol_error_status);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->poisoned_tlp_status);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->flow_control_protocol_error_status);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completion_timeout_status);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completer_abort_status);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unexpected_completion_status);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->receiver_overflow_status);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->malformed_tlp_status);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ecrc_error_status);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unsupported_request_error_status);

}

void connectib_uncorrectable_error_status_unpack(struct connectib_uncorrectable_error_status *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->training_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->data_link_protocol_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->poisoned_tlp_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->flow_control_protocol_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->completion_timeout_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->completer_abort_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->unexpected_completion_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->receiver_overflow_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->malformed_tlp_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->ecrc_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->unsupported_request_error_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_uncorrectable_error_status_print(const struct connectib_uncorrectable_error_status *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_uncorrectable_error_status ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "training_error_status : "UH_FMT"\n", ptr_struct->training_error_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_link_protocol_error_status : "UH_FMT"\n", ptr_struct->data_link_protocol_error_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "poisoned_tlp_status  : "UH_FMT"\n", ptr_struct->poisoned_tlp_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "flow_control_protocol_error_status : "UH_FMT"\n", ptr_struct->flow_control_protocol_error_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout_status : "UH_FMT"\n", ptr_struct->completion_timeout_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completer_abort_status : "UH_FMT"\n", ptr_struct->completer_abort_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unexpected_completion_status : "UH_FMT"\n", ptr_struct->unexpected_completion_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "receiver_overflow_status : "UH_FMT"\n", ptr_struct->receiver_overflow_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "malformed_tlp_status : "UH_FMT"\n", ptr_struct->malformed_tlp_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ecrc_error_status    : "UH_FMT"\n", ptr_struct->ecrc_error_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unsupported_request_error_status : "UH_FMT"\n", ptr_struct->unsupported_request_error_status);

}

int connectib_uncorrectable_error_status_size(void){
	 return 4;
}

void connectib_uncorrectable_error_status_dump(const struct connectib_uncorrectable_error_status *ptr_struct, FILE* file) {
	connectib_uncorrectable_error_status_print(ptr_struct, file, 0);
}

void connectib_bar_high_pack(const struct connectib_bar_high *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->addr_63_32);

}

void connectib_bar_high_unpack(struct connectib_bar_high *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->addr_63_32 = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_bar_high_print(const struct connectib_bar_high *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_bar_high ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_63_32           : "U32H_FMT"\n", ptr_struct->addr_63_32);

}

int connectib_bar_high_size(void){
	 return 4;
}

void connectib_bar_high_dump(const struct connectib_bar_high *ptr_struct, FILE* file) {
	connectib_bar_high_print(ptr_struct, file, 0);
}

void connectib_bar_low_pack(const struct connectib_bar_low *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->memory_or_io);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->type);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->prefetchable);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 28, (u_int32_t)ptr_struct->addr_31_4);

}

void connectib_bar_low_unpack(struct connectib_bar_low *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->memory_or_io = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=28;
	ptr_struct->prefetchable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->addr_31_4 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 28);

}

void connectib_bar_low_print(const struct connectib_bar_low *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_bar_low ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_or_io         : "UH_FMT"\n", ptr_struct->memory_or_io);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "type                 : "UH_FMT"\n", ptr_struct->type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "prefetchable         : "UH_FMT"\n", ptr_struct->prefetchable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_31_4            : "UH_FMT"\n", ptr_struct->addr_31_4);

}

int connectib_bar_low_size(void){
	 return 4;
}

void connectib_bar_low_dump(const struct connectib_bar_low *ptr_struct, FILE* file) {
	connectib_bar_low_print(ptr_struct, file, 0);
}

void connectib_sriov_status_pack(const struct connectib_sriov_status *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_mig_status);

}

void connectib_sriov_status_unpack(struct connectib_sriov_status *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->vf_mig_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sriov_status_print(const struct connectib_sriov_status *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sriov_status ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mig_status        : "UH_FMT"\n", ptr_struct->vf_mig_status);

}

int connectib_sriov_status_size(void){
	 return 2;
}

void connectib_sriov_status_dump(const struct connectib_sriov_status *ptr_struct, FILE* file) {
	connectib_sriov_status_print(ptr_struct, file, 0);
}

void connectib_sriov_control_pack(const struct connectib_sriov_control *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_enable);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_en);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_migration_int_en);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_mse);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ari_capable_hierarchy);

}

void connectib_sriov_control_unpack(struct connectib_sriov_control *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->vf_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->vf_migration_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->vf_migration_int_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->vf_mse = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->ari_capable_hierarchy = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_sriov_control_print(const struct connectib_sriov_control *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sriov_control ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_enable            : "UH_FMT"\n", ptr_struct->vf_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_en      : "UH_FMT"\n", ptr_struct->vf_migration_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_migration_int_en  : "UH_FMT"\n", ptr_struct->vf_migration_int_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mse               : "UH_FMT"\n", ptr_struct->vf_mse);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_capable_hierarchy : "UH_FMT"\n", ptr_struct->ari_capable_hierarchy);

}

int connectib_sriov_control_size(void){
	 return 2;
}

void connectib_sriov_control_dump(const struct connectib_sriov_control *ptr_struct, FILE* file) {
	connectib_sriov_control_print(ptr_struct, file, 0);
}

void connectib_sriov_capabilities_pack(const struct connectib_sriov_capabilities *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->vf_mig_capable);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ari_cap_hier_preserved);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->vf_mig_int_msg_num);

}

void connectib_sriov_capabilities_unpack(struct connectib_sriov_capabilities *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->vf_mig_capable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->ari_cap_hier_preserved = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->vf_mig_int_msg_num = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

}

void connectib_sriov_capabilities_print(const struct connectib_sriov_capabilities *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sriov_capabilities ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mig_capable       : "UH_FMT"\n", ptr_struct->vf_mig_capable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_cap_hier_preserved : "UH_FMT"\n", ptr_struct->ari_cap_hier_preserved);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vf_mig_int_msg_num   : "UH_FMT"\n", ptr_struct->vf_mig_int_msg_num);

}

int connectib_sriov_capabilities_size(void){
	 return 4;
}

void connectib_sriov_capabilities_dump(const struct connectib_sriov_capabilities *ptr_struct, FILE* file) {
	connectib_sriov_capabilities_print(ptr_struct, file, 0);
}

void connectib_ari_control_pack(const struct connectib_ari_control *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mfvc_en);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->acs_en);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->func_group);

}

void connectib_ari_control_unpack(struct connectib_ari_control *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->mfvc_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->acs_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->func_group = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_ari_control_print(const struct connectib_ari_control *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ari_control ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfvc_en              : "UH_FMT"\n", ptr_struct->mfvc_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "acs_en               : "UH_FMT"\n", ptr_struct->acs_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "func_group           : "UH_FMT"\n", ptr_struct->func_group);

}

int connectib_ari_control_size(void){
	 return 2;
}

void connectib_ari_control_dump(const struct connectib_ari_control *ptr_struct, FILE* file) {
	connectib_ari_control_print(ptr_struct, file, 0);
}

void connectib_ari_capabilities_pack(const struct connectib_ari_capabilities *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->mfvc);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->acs);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->next_func_num);

}

void connectib_ari_capabilities_unpack(struct connectib_ari_capabilities *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->mfvc = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->acs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->next_func_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_ari_capabilities_print(const struct connectib_ari_capabilities *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ari_capabilities ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mfvc                 : "UH_FMT"\n", ptr_struct->mfvc);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "acs                  : "UH_FMT"\n", ptr_struct->acs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "next_func_num        : "UH_FMT"\n", ptr_struct->next_func_num);

}

int connectib_ari_capabilities_size(void){
	 return 2;
}

void connectib_ari_capabilities_dump(const struct connectib_ari_capabilities *ptr_struct, FILE* file) {
	connectib_ari_capabilities_print(ptr_struct, file, 0);
}

void connectib_lane_eql_ctl_pack(const struct connectib_lane_eql_ctl *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->downstream_port_transmitter_preset0);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->downstream_port_receiver_preset_hint0);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->upstream_port_transmitter_preset0);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->upstream_port_receiver_preset_hint0);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->downstream_port_transmitter_preset1);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->downstream_port_receiver_preset_hint1);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->upstream_port_transmitter_preset1);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->upstream_port_receiver_preset_hint1);

}

void connectib_lane_eql_ctl_unpack(struct connectib_lane_eql_ctl *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->downstream_port_transmitter_preset0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=25;
	ptr_struct->downstream_port_receiver_preset_hint0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=20;
	ptr_struct->upstream_port_transmitter_preset0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=17;
	ptr_struct->upstream_port_receiver_preset_hint0 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=12;
	ptr_struct->downstream_port_transmitter_preset1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=9;
	ptr_struct->downstream_port_receiver_preset_hint1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=4;
	ptr_struct->upstream_port_transmitter_preset1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=1;
	ptr_struct->upstream_port_receiver_preset_hint1 = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

}

void connectib_lane_eql_ctl_print(const struct connectib_lane_eql_ctl *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_lane_eql_ctl ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "downstream_port_transmitter_preset0 : "UH_FMT"\n", ptr_struct->downstream_port_transmitter_preset0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "downstream_port_receiver_preset_hint0 : "UH_FMT"\n", ptr_struct->downstream_port_receiver_preset_hint0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "upstream_port_transmitter_preset0 : "UH_FMT"\n", ptr_struct->upstream_port_transmitter_preset0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "upstream_port_receiver_preset_hint0 : "UH_FMT"\n", ptr_struct->upstream_port_receiver_preset_hint0);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "downstream_port_transmitter_preset1 : "UH_FMT"\n", ptr_struct->downstream_port_transmitter_preset1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "downstream_port_receiver_preset_hint1 : "UH_FMT"\n", ptr_struct->downstream_port_receiver_preset_hint1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "upstream_port_transmitter_preset1 : "UH_FMT"\n", ptr_struct->upstream_port_transmitter_preset1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "upstream_port_receiver_preset_hint1 : "UH_FMT"\n", ptr_struct->upstream_port_receiver_preset_hint1);

}

int connectib_lane_eql_ctl_size(void){
	 return 4;
}

void connectib_lane_eql_ctl_dump(const struct connectib_lane_eql_ctl *ptr_struct, FILE* file) {
	connectib_lane_eql_ctl_print(ptr_struct, file, 0);
}

void connectib_pciex_link_ctl3_pack(const struct connectib_pciex_link_ctl3 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->perform_equalization);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->link_equalization_req_int_en);

}

void connectib_pciex_link_ctl3_unpack(struct connectib_pciex_link_ctl3 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->perform_equalization = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->link_equalization_req_int_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_pciex_link_ctl3_print(const struct connectib_pciex_link_ctl3 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pciex_link_ctl3 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "perform_equalization : "UH_FMT"\n", ptr_struct->perform_equalization);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_equalization_req_int_en : "UH_FMT"\n", ptr_struct->link_equalization_req_int_en);

}

int connectib_pciex_link_ctl3_size(void){
	 return 4;
}

void connectib_pciex_link_ctl3_dump(const struct connectib_pciex_link_ctl3 *ptr_struct, FILE* file) {
	connectib_pciex_link_ctl3_print(ptr_struct, file, 0);
}

void connectib_message_control_pack(const struct connectib_message_control *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 11, (u_int32_t)ptr_struct->table_size);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->function_mask);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->msix_en);

}

void connectib_message_control_unpack(struct connectib_message_control *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=5;
	ptr_struct->table_size = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 11);

	offset=1;
	ptr_struct->function_mask = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->msix_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_message_control_print(const struct connectib_message_control *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_message_control ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "table_size           : "UH_FMT"\n", ptr_struct->table_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "function_mask        : "UH_FMT"\n", ptr_struct->function_mask);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "msix_en              : "UH_FMT"\n", ptr_struct->msix_en);

}

int connectib_message_control_size(void){
	 return 2;
}

void connectib_message_control_dump(const struct connectib_message_control *ptr_struct, FILE* file) {
	connectib_message_control_print(ptr_struct, file, 0);
}

void connectib_link_stat2_pack(const struct connectib_link_stat2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->current_de_emphasis_level);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->equalization_complete);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->equalization_phase1_successful);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->equalization_phase2_successful);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->equalization_phase3_successful);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->link_equalization_request);

}

void connectib_link_stat2_unpack(struct connectib_link_stat2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->current_de_emphasis_level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->equalization_complete = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->equalization_phase1_successful = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->equalization_phase2_successful = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->equalization_phase3_successful = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->link_equalization_request = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_link_stat2_print(const struct connectib_link_stat2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_stat2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "current_de_emphasis_level : "UH_FMT"\n", ptr_struct->current_de_emphasis_level);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "equalization_complete : "UH_FMT"\n", ptr_struct->equalization_complete);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "equalization_phase1_successful : "UH_FMT"\n", ptr_struct->equalization_phase1_successful);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "equalization_phase2_successful : "UH_FMT"\n", ptr_struct->equalization_phase2_successful);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "equalization_phase3_successful : "UH_FMT"\n", ptr_struct->equalization_phase3_successful);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_equalization_request : "UH_FMT"\n", ptr_struct->link_equalization_request);

}

int connectib_link_stat2_size(void){
	 return 2;
}

void connectib_link_stat2_dump(const struct connectib_link_stat2 *ptr_struct, FILE* file) {
	connectib_link_stat2_print(ptr_struct, file, 0);
}

void connectib_link_ctl2_pack(const struct connectib_link_ctl2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->target_link_speed);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->enter_compliance);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->hardware_autonomus_speed_disable);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->selectable_de_emphasis);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->transmit_margin);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->modified_compliance);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->compliance_sos);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->compliance_preset_de_emphasis);

}

void connectib_link_ctl2_unpack(struct connectib_link_ctl2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->target_link_speed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=11;
	ptr_struct->enter_compliance = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->hardware_autonomus_speed_disable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->selectable_de_emphasis = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->transmit_margin = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=5;
	ptr_struct->modified_compliance = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->compliance_sos = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->compliance_preset_de_emphasis = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_link_ctl2_print(const struct connectib_link_ctl2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_ctl2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "target_link_speed    : "UH_FMT"\n", ptr_struct->target_link_speed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "enter_compliance     : "UH_FMT"\n", ptr_struct->enter_compliance);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "hardware_autonomus_speed_disable : "UH_FMT"\n", ptr_struct->hardware_autonomus_speed_disable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "selectable_de_emphasis : "UH_FMT"\n", ptr_struct->selectable_de_emphasis);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transmit_margin      : "UH_FMT"\n", ptr_struct->transmit_margin);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "modified_compliance  : "UH_FMT"\n", ptr_struct->modified_compliance);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "compliance_sos       : "UH_FMT"\n", ptr_struct->compliance_sos);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "compliance_preset_de_emphasis : "UH_FMT"\n", ptr_struct->compliance_preset_de_emphasis);

}

int connectib_link_ctl2_size(void){
	 return 2;
}

void connectib_link_ctl2_dump(const struct connectib_link_ctl2 *ptr_struct, FILE* file) {
	connectib_link_ctl2_print(ptr_struct, file, 0);
}

void connectib_link_caps2_pack(const struct connectib_link_caps2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 7, (u_int32_t)ptr_struct->supported_link_speed_vector);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->cross_link_supported);

}

void connectib_link_caps2_unpack(struct connectib_link_caps2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->supported_link_speed_vector = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 7);

	offset=23;
	ptr_struct->cross_link_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_link_caps2_print(const struct connectib_link_caps2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_caps2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "supported_link_speed_vector : "UH_FMT"\n", ptr_struct->supported_link_speed_vector);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cross_link_supported : "UH_FMT"\n", ptr_struct->cross_link_supported);

}

int connectib_link_caps2_size(void){
	 return 4;
}

void connectib_link_caps2_dump(const struct connectib_link_caps2 *ptr_struct, FILE* file) {
	connectib_link_caps2_print(ptr_struct, file, 0);
}

void connectib_device_stat2_pack(const struct connectib_device_stat2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_device_stat2_unpack(struct connectib_device_stat2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

}

void connectib_device_stat2_print(const struct connectib_device_stat2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_stat2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

}

int connectib_device_stat2_size(void){
	 return 2;
}

void connectib_device_stat2_dump(const struct connectib_device_stat2 *ptr_struct, FILE* file) {
	connectib_device_stat2_print(ptr_struct, file, 0);
}

void connectib_device_ctl2_pack(const struct connectib_device_ctl2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->completion_timeout_value);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completion_timeout_disable);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->ari_forwarding_enable);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->obff_enable);

}

void connectib_device_ctl2_unpack(struct connectib_device_ctl2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->completion_timeout_value = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=11;
	ptr_struct->completion_timeout_disable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->ari_forwarding_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->obff_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

}

void connectib_device_ctl2_print(const struct connectib_device_ctl2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_ctl2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout_value : "UH_FMT"\n", ptr_struct->completion_timeout_value);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout_disable : "UH_FMT"\n", ptr_struct->completion_timeout_disable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_forwarding_enable : "UH_FMT"\n", ptr_struct->ari_forwarding_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "obff_enable          : "UH_FMT"\n", ptr_struct->obff_enable);

}

int connectib_device_ctl2_size(void){
	 return 2;
}

void connectib_device_ctl2_dump(const struct connectib_device_ctl2 *ptr_struct, FILE* file) {
	connectib_device_ctl2_print(ptr_struct, file, 0);
}

void connectib_device_caps2_pack(const struct connectib_device_caps2 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->completion_timeout_ranges_supported);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->completion_timeout_disable_supported);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->ari_forwarding_supported);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->obff_supported);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->extended_fmt_field_supported);

}

void connectib_device_caps2_unpack(struct connectib_device_caps2 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->completion_timeout_ranges_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=27;
	ptr_struct->completion_timeout_disable_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->ari_forwarding_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=12;
	ptr_struct->obff_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=11;
	ptr_struct->extended_fmt_field_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_device_caps2_print(const struct connectib_device_caps2 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_caps2 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout_ranges_supported : "UH_FMT"\n", ptr_struct->completion_timeout_ranges_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "completion_timeout_disable_supported : "UH_FMT"\n", ptr_struct->completion_timeout_disable_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ari_forwarding_supported : "UH_FMT"\n", ptr_struct->ari_forwarding_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "obff_supported       : "UH_FMT"\n", ptr_struct->obff_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_fmt_field_supported : "UH_FMT"\n", ptr_struct->extended_fmt_field_supported);

}

int connectib_device_caps2_size(void){
	 return 4;
}

void connectib_device_caps2_dump(const struct connectib_device_caps2 *ptr_struct, FILE* file) {
	connectib_device_caps2_print(ptr_struct, file, 0);
}

void connectib_link_stat_pack(const struct connectib_link_stat *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->link_speed);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->negotiated_link_width);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->training_error);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->link_training);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->slot_clock_cfg);

}

void connectib_link_stat_unpack(struct connectib_link_stat *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->link_speed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=6;
	ptr_struct->negotiated_link_width = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=5;
	ptr_struct->training_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->link_training = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->slot_clock_cfg = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_link_stat_print(const struct connectib_link_stat *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_stat ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_speed           : "UH_FMT"\n", ptr_struct->link_speed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "negotiated_link_width : "UH_FMT"\n", ptr_struct->negotiated_link_width);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "training_error       : "UH_FMT"\n", ptr_struct->training_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_training        : "UH_FMT"\n", ptr_struct->link_training);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slot_clock_cfg       : "UH_FMT"\n", ptr_struct->slot_clock_cfg);

}

int connectib_link_stat_size(void){
	 return 2;
}

void connectib_link_stat_dump(const struct connectib_link_stat *ptr_struct, FILE* file) {
	connectib_link_stat_print(ptr_struct, file, 0);
}

void connectib_link_ctl_pack(const struct connectib_link_ctl *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->aspm_control);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rcb);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->common_clock_configuration);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->extended_synch);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->enable_clock_power_management);

}

void connectib_link_ctl_unpack(struct connectib_link_ctl *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=14;
	ptr_struct->aspm_control = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=12;
	ptr_struct->rcb = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->common_clock_configuration = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->extended_synch = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->enable_clock_power_management = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_link_ctl_print(const struct connectib_link_ctl *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_ctl ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aspm_control         : "UH_FMT"\n", ptr_struct->aspm_control);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rcb                  : "UH_FMT"\n", ptr_struct->rcb);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "common_clock_configuration : "UH_FMT"\n", ptr_struct->common_clock_configuration);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_synch       : "UH_FMT"\n", ptr_struct->extended_synch);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "enable_clock_power_management : "UH_FMT"\n", ptr_struct->enable_clock_power_management);

}

int connectib_link_ctl_size(void){
	 return 2;
}

void connectib_link_ctl_dump(const struct connectib_link_ctl *ptr_struct, FILE* file) {
	connectib_link_ctl_print(ptr_struct, file, 0);
}

void connectib_link_caps_pack(const struct connectib_link_caps *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->max_link_speed);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 6, (u_int32_t)ptr_struct->max_link_width);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->aspm_support);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->l0s_exit_latency);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->l1_exit_latency);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->clock_power_management);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->surprise_down_error_reporting_cap);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->link_active_reporting_cap);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->link_bw_notification_cap);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aspm_optionality_compliance);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_number);

}

void connectib_link_caps_unpack(struct connectib_link_caps *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=28;
	ptr_struct->max_link_speed = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=22;
	ptr_struct->max_link_width = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 6);

	offset=20;
	ptr_struct->aspm_support = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=17;
	ptr_struct->l0s_exit_latency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=14;
	ptr_struct->l1_exit_latency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=13;
	ptr_struct->clock_power_management = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->surprise_down_error_reporting_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->link_active_reporting_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->link_bw_notification_cap = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->aspm_optionality_compliance = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->port_number = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_link_caps_print(const struct connectib_link_caps *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_link_caps ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_link_speed       : "UH_FMT"\n", ptr_struct->max_link_speed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_link_width       : "UH_FMT"\n", ptr_struct->max_link_width);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aspm_support         : "UH_FMT"\n", ptr_struct->aspm_support);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0s_exit_latency     : "UH_FMT"\n", ptr_struct->l0s_exit_latency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l1_exit_latency      : "UH_FMT"\n", ptr_struct->l1_exit_latency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "clock_power_management : "UH_FMT"\n", ptr_struct->clock_power_management);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "surprise_down_error_reporting_cap : "UH_FMT"\n", ptr_struct->surprise_down_error_reporting_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_active_reporting_cap : "UH_FMT"\n", ptr_struct->link_active_reporting_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_bw_notification_cap : "UH_FMT"\n", ptr_struct->link_bw_notification_cap);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aspm_optionality_compliance : "UH_FMT"\n", ptr_struct->aspm_optionality_compliance);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_number          : "UH_FMT"\n", ptr_struct->port_number);

}

int connectib_link_caps_size(void){
	 return 4;
}

void connectib_link_caps_dump(const struct connectib_link_caps *ptr_struct, FILE* file) {
	connectib_link_caps_print(ptr_struct, file, 0);
}

void connectib_device_stat_pack(const struct connectib_device_stat *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->correctable_error);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->non_fatal_error);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fatal_error);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unsupported_request);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aux_power);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->transactions_pending);

}

void connectib_device_stat_unpack(struct connectib_device_stat *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->correctable_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->non_fatal_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->fatal_error = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->unsupported_request = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->aux_power = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->transactions_pending = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_device_stat_print(const struct connectib_device_stat *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_stat ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "correctable_error    : "UH_FMT"\n", ptr_struct->correctable_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "non_fatal_error      : "UH_FMT"\n", ptr_struct->non_fatal_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fatal_error          : "UH_FMT"\n", ptr_struct->fatal_error);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unsupported_request  : "UH_FMT"\n", ptr_struct->unsupported_request);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aux_power            : "UH_FMT"\n", ptr_struct->aux_power);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transactions_pending : "UH_FMT"\n", ptr_struct->transactions_pending);

}

int connectib_device_stat_size(void){
	 return 2;
}

void connectib_device_stat_dump(const struct connectib_device_stat *ptr_struct, FILE* file) {
	connectib_device_stat_print(ptr_struct, file, 0);
}

void connectib_device_ctl_pack(const struct connectib_device_ctl *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->correctable_error_report);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->non_fatal_error_report);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->fatal_error_report);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->unsupported_request_report);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->relaxed_ordering);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_payload_size);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->extended_tag_field_en);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->phantom_funcs);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->aux_power);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->no_snoop);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_read_request_size);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->initiate_function_level_reset);

}

void connectib_device_ctl_unpack(struct connectib_device_ctl *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->correctable_error_report = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->non_fatal_error_report = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->fatal_error_report = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->unsupported_request_report = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->relaxed_ordering = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->max_payload_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=7;
	ptr_struct->extended_tag_field_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->phantom_funcs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->aux_power = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->no_snoop = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->max_read_request_size = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=0;
	ptr_struct->initiate_function_level_reset = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_device_ctl_print(const struct connectib_device_ctl *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_ctl ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "correctable_error_report : "UH_FMT"\n", ptr_struct->correctable_error_report);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "non_fatal_error_report : "UH_FMT"\n", ptr_struct->non_fatal_error_report);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fatal_error_report   : "UH_FMT"\n", ptr_struct->fatal_error_report);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "unsupported_request_report : "UH_FMT"\n", ptr_struct->unsupported_request_report);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "relaxed_ordering     : "UH_FMT"\n", ptr_struct->relaxed_ordering);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_payload_size     : "UH_FMT"\n", ptr_struct->max_payload_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_tag_field_en : "UH_FMT"\n", ptr_struct->extended_tag_field_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phantom_funcs        : "UH_FMT"\n", ptr_struct->phantom_funcs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "aux_power            : "UH_FMT"\n", ptr_struct->aux_power);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "no_snoop             : "UH_FMT"\n", ptr_struct->no_snoop);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_read_request_size : "UH_FMT"\n", ptr_struct->max_read_request_size);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "initiate_function_level_reset : "UH_FMT"\n", ptr_struct->initiate_function_level_reset);

}

int connectib_device_ctl_size(void){
	 return 2;
}

void connectib_device_ctl_dump(const struct connectib_device_ctl *ptr_struct, FILE* file) {
	connectib_device_ctl_print(ptr_struct, file, 0);
}

void connectib_device_caps_pack(const struct connectib_device_caps *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->max_payload_size_supported);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->phantom_funcs);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->extended_tag_field_sup);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->l0s_acceptable_latency);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 3, (u_int32_t)ptr_struct->l1_acceptable_latency);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->role_based_error_reporting);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->captured_slot_power_limit_value);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 2, (u_int32_t)ptr_struct->captured_slot_power_limit_scale);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->function_level_reset_capability);

}

void connectib_device_caps_unpack(struct connectib_device_caps *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=29;
	ptr_struct->max_payload_size_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=27;
	ptr_struct->phantom_funcs = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=26;
	ptr_struct->extended_tag_field_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->l0s_acceptable_latency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=20;
	ptr_struct->l1_acceptable_latency = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 3);

	offset=16;
	ptr_struct->role_based_error_reporting = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->captured_slot_power_limit_value = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=4;
	ptr_struct->captured_slot_power_limit_scale = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 2);

	offset=3;
	ptr_struct->function_level_reset_capability = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_device_caps_print(const struct connectib_device_caps *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_device_caps ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "max_payload_size_supported : "UH_FMT"\n", ptr_struct->max_payload_size_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "phantom_funcs        : "UH_FMT"\n", ptr_struct->phantom_funcs);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "extended_tag_field_sup : "UH_FMT"\n", ptr_struct->extended_tag_field_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l0s_acceptable_latency : "UH_FMT"\n", ptr_struct->l0s_acceptable_latency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "l1_acceptable_latency : "UH_FMT"\n", ptr_struct->l1_acceptable_latency);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "role_based_error_reporting : "UH_FMT"\n", ptr_struct->role_based_error_reporting);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "captured_slot_power_limit_value : "UH_FMT"\n", ptr_struct->captured_slot_power_limit_value);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "captured_slot_power_limit_scale : "UH_FMT"\n", ptr_struct->captured_slot_power_limit_scale);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "function_level_reset_capability : "UH_FMT"\n", ptr_struct->function_level_reset_capability);

}

int connectib_device_caps_size(void){
	 return 4;
}

void connectib_device_caps_dump(const struct connectib_device_caps *ptr_struct, FILE* file) {
	connectib_device_caps_print(ptr_struct, file, 0);
}

void connectib_pciex_cap_pack(const struct connectib_pciex_cap *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->version);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->device_port_type);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->slot);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 5, (u_int32_t)ptr_struct->int_message_num);

}

void connectib_pciex_cap_unpack(struct connectib_pciex_cap *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->version = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=8;
	ptr_struct->device_port_type = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=6;
	ptr_struct->slot = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->int_message_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 5);

}

void connectib_pciex_cap_print(const struct connectib_pciex_cap *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_pciex_cap ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "version              : "UH_FMT"\n", ptr_struct->version);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "device_port_type     : "UH_FMT"\n", ptr_struct->device_port_type);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "slot                 : "UH_FMT"\n", ptr_struct->slot);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "int_message_num      : "UH_FMT"\n", ptr_struct->int_message_num);

}

int connectib_pciex_cap_size(void){
	 return 2;
}

void connectib_pciex_cap_dump(const struct connectib_pciex_cap *ptr_struct, FILE* file) {
	connectib_pciex_cap_print(ptr_struct, file, 0);
}

void connectib_exp_rom_pack(const struct connectib_exp_rom *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->exp_rom_en);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 21, (u_int32_t)ptr_struct->addr_31_11);

}

void connectib_exp_rom_unpack(struct connectib_exp_rom *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->exp_rom_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->addr_31_11 = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 21);

}

void connectib_exp_rom_print(const struct connectib_exp_rom *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_exp_rom ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "exp_rom_en           : "UH_FMT"\n", ptr_struct->exp_rom_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "addr_31_11           : "UH_FMT"\n", ptr_struct->addr_31_11);

}

int connectib_exp_rom_size(void){
	 return 4;
}

void connectib_exp_rom_dump(const struct connectib_exp_rom *ptr_struct, FILE* file) {
	connectib_exp_rom_print(ptr_struct, file, 0);
}

void connectib_stat_reg1_pack(const struct connectib_stat_reg1 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->int_status);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->capabilities_list);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->master_data_perr);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->signaled_ta);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->received_ta);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->received_ma);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->signaled_serr);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->detected_perr);

}

void connectib_stat_reg1_unpack(struct connectib_stat_reg1 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=12;
	ptr_struct->int_status = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->capabilities_list = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->master_data_perr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->signaled_ta = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->received_ta = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->received_ma = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->signaled_serr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->detected_perr = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_stat_reg1_print(const struct connectib_stat_reg1 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_stat_reg1 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "int_status           : "UH_FMT"\n", ptr_struct->int_status);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "capabilities_list    : "UH_FMT"\n", ptr_struct->capabilities_list);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "master_data_perr     : "UH_FMT"\n", ptr_struct->master_data_perr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "signaled_ta          : "UH_FMT"\n", ptr_struct->signaled_ta);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "received_ta          : "UH_FMT"\n", ptr_struct->received_ta);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "received_ma          : "UH_FMT"\n", ptr_struct->received_ma);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "signaled_serr        : "UH_FMT"\n", ptr_struct->signaled_serr);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "detected_perr        : "UH_FMT"\n", ptr_struct->detected_perr);

}

int connectib_stat_reg1_size(void){
	 return 2;
}

void connectib_stat_reg1_dump(const struct connectib_stat_reg1 *ptr_struct, FILE* file) {
	connectib_stat_reg1_print(ptr_struct, file, 0);
}

void connectib_cmd_reg1_pack(const struct connectib_cmd_reg1 *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->io_space);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->memory_space);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->bus_master_en);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->perr_enable);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->serr_enable);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->int_disable);

}

void connectib_cmd_reg1_unpack(struct connectib_cmd_reg1 *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=15;
	ptr_struct->io_space = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->memory_space = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->bus_master_en = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->perr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->serr_enable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->int_disable = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_cmd_reg1_print(const struct connectib_cmd_reg1 *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmd_reg1 ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "io_space             : "UH_FMT"\n", ptr_struct->io_space);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "memory_space         : "UH_FMT"\n", ptr_struct->memory_space);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bus_master_en        : "UH_FMT"\n", ptr_struct->bus_master_en);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "perr_enable          : "UH_FMT"\n", ptr_struct->perr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "serr_enable          : "UH_FMT"\n", ptr_struct->serr_enable);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "int_disable          : "UH_FMT"\n", ptr_struct->int_disable);

}

int connectib_cmd_reg1_size(void){
	 return 2;
}

void connectib_cmd_reg1_dump(const struct connectib_cmd_reg1 *ptr_struct, FILE* file) {
	connectib_cmd_reg1_print(ptr_struct, file, 0);
}

void connectib_nv_tlv_data_vpi_settings_pack(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->network_link_type_ib);

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->network_link_type_eth);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->default_link_type_ib);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->default_link_type_eth);

}

void connectib_nv_tlv_data_vpi_settings_unpack(struct connectib_nv_tlv_data_vpi_settings *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=31;
	ptr_struct->network_link_type_ib = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=30;
	ptr_struct->network_link_type_eth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->default_link_type_ib = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->default_link_type_eth = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_nv_tlv_data_vpi_settings_print(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_nv_tlv_data_vpi_settings ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "network_link_type_ib : "UH_FMT"\n", ptr_struct->network_link_type_ib);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "network_link_type_eth : "UH_FMT"\n", ptr_struct->network_link_type_eth);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "default_link_type_ib : "UH_FMT"\n", ptr_struct->default_link_type_ib);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "default_link_type_eth : "UH_FMT"\n", ptr_struct->default_link_type_eth);

}

int connectib_nv_tlv_data_vpi_settings_size(void){
	 return 4;
}

void connectib_nv_tlv_data_vpi_settings_dump(const struct connectib_nv_tlv_data_vpi_settings *ptr_struct, FILE* file) {
	connectib_nv_tlv_data_vpi_settings_print(ptr_struct, file, 0);
}

void connectib_dword_val_pack(const struct connectib_dword_val *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->val);

}

void connectib_dword_val_unpack(struct connectib_dword_val *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->val = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_dword_val_print(const struct connectib_dword_val *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_dword_val ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "val                  : "U32H_FMT"\n", ptr_struct->val);

}

int connectib_dword_val_size(void){
	 return 4;
}

void connectib_dword_val_dump(const struct connectib_dword_val *ptr_struct, FILE* file) {
	connectib_dword_val_print(ptr_struct, file, 0);
}

void connectib_port_cap_mask1_fields_pack(const struct connectib_port_cap_mask1_fields *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_sm);

	offset=29;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_notice_sup);

	offset=28;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_trap_sup);

	offset=27;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_optional_ipd_sup);

	offset=26;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_automatic_migration_sup);

	offset=25;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_sl_mapping_sup);

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_mkey_nvram);

	offset=23;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_pkey_nvram);

	offset=22;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_led_info_sup);

	offset=21;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_sm_disabled);

	offset=20;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_system_image_guid_sup);

	offset=19;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_pkey_switch_external_port_trap_sup);

	offset=18;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_cable_info_supported);

	offset=17;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_extended_speed_sup);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_capability_mask2_supported);

	offset=15;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_communication_management_sup);

	offset=14;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_snmp_tunneling_sup);

	offset=13;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_reinit_sup);

	offset=12;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_device_management_sup);

	offset=11;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_vendor_class_sup);

	offset=10;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_dr_notice_sup);

	offset=9;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_capability_mask_notice_sup);

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_boot_management_sup);

	offset=7;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_link_round_trip_latency_sup);

	offset=6;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_client_reregistration_sup);

	offset=5;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_other_local_changes_notice_supported);

	offset=4;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_link_speed_width_pairs_table_supported);

	offset=3;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_vendor_specific_mads_table_supported);

	offset=2;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_multicast_pkey_trap_suppression_supported);

	offset=1;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_multicast_fdb_top_supported);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->is_hierarchy_info_supported);

}

void connectib_port_cap_mask1_fields_unpack(struct connectib_port_cap_mask1_fields *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=30;
	ptr_struct->is_sm = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=29;
	ptr_struct->is_notice_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=28;
	ptr_struct->is_trap_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=27;
	ptr_struct->is_optional_ipd_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=26;
	ptr_struct->is_automatic_migration_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=25;
	ptr_struct->is_sl_mapping_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=24;
	ptr_struct->is_mkey_nvram = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=23;
	ptr_struct->is_pkey_nvram = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=22;
	ptr_struct->is_led_info_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=21;
	ptr_struct->is_sm_disabled = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=20;
	ptr_struct->is_system_image_guid_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=19;
	ptr_struct->is_pkey_switch_external_port_trap_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=18;
	ptr_struct->is_cable_info_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=17;
	ptr_struct->is_extended_speed_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=16;
	ptr_struct->is_capability_mask2_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=15;
	ptr_struct->is_communication_management_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=14;
	ptr_struct->is_snmp_tunneling_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=13;
	ptr_struct->is_reinit_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=12;
	ptr_struct->is_device_management_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=11;
	ptr_struct->is_vendor_class_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=10;
	ptr_struct->is_dr_notice_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=9;
	ptr_struct->is_capability_mask_notice_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=8;
	ptr_struct->is_boot_management_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=7;
	ptr_struct->is_link_round_trip_latency_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=6;
	ptr_struct->is_client_reregistration_sup = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=5;
	ptr_struct->is_other_local_changes_notice_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=4;
	ptr_struct->is_link_speed_width_pairs_table_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=3;
	ptr_struct->is_vendor_specific_mads_table_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=2;
	ptr_struct->is_multicast_pkey_trap_suppression_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=1;
	ptr_struct->is_multicast_fdb_top_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=0;
	ptr_struct->is_hierarchy_info_supported = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_port_cap_mask1_fields_print(const struct connectib_port_cap_mask1_fields *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_port_cap_mask1_fields ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_sm                : "UH_FMT"\n", ptr_struct->is_sm);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_notice_sup        : "UH_FMT"\n", ptr_struct->is_notice_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_trap_sup          : "UH_FMT"\n", ptr_struct->is_trap_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_optional_ipd_sup  : "UH_FMT"\n", ptr_struct->is_optional_ipd_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_automatic_migration_sup : "UH_FMT"\n", ptr_struct->is_automatic_migration_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_sl_mapping_sup    : "UH_FMT"\n", ptr_struct->is_sl_mapping_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_mkey_nvram        : "UH_FMT"\n", ptr_struct->is_mkey_nvram);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_pkey_nvram        : "UH_FMT"\n", ptr_struct->is_pkey_nvram);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_led_info_sup      : "UH_FMT"\n", ptr_struct->is_led_info_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_sm_disabled       : "UH_FMT"\n", ptr_struct->is_sm_disabled);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_system_image_guid_sup : "UH_FMT"\n", ptr_struct->is_system_image_guid_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_pkey_switch_external_port_trap_sup : "UH_FMT"\n", ptr_struct->is_pkey_switch_external_port_trap_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_cable_info_supported : "UH_FMT"\n", ptr_struct->is_cable_info_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_extended_speed_sup : "UH_FMT"\n", ptr_struct->is_extended_speed_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_capability_mask2_supported : "UH_FMT"\n", ptr_struct->is_capability_mask2_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_communication_management_sup : "UH_FMT"\n", ptr_struct->is_communication_management_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_snmp_tunneling_sup : "UH_FMT"\n", ptr_struct->is_snmp_tunneling_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_reinit_sup        : "UH_FMT"\n", ptr_struct->is_reinit_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_device_management_sup : "UH_FMT"\n", ptr_struct->is_device_management_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_vendor_class_sup  : "UH_FMT"\n", ptr_struct->is_vendor_class_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_dr_notice_sup     : "UH_FMT"\n", ptr_struct->is_dr_notice_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_capability_mask_notice_sup : "UH_FMT"\n", ptr_struct->is_capability_mask_notice_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_boot_management_sup : "UH_FMT"\n", ptr_struct->is_boot_management_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_link_round_trip_latency_sup : "UH_FMT"\n", ptr_struct->is_link_round_trip_latency_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_client_reregistration_sup : "UH_FMT"\n", ptr_struct->is_client_reregistration_sup);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_other_local_changes_notice_supported : "UH_FMT"\n", ptr_struct->is_other_local_changes_notice_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_link_speed_width_pairs_table_supported : "UH_FMT"\n", ptr_struct->is_link_speed_width_pairs_table_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_vendor_specific_mads_table_supported : "UH_FMT"\n", ptr_struct->is_vendor_specific_mads_table_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_multicast_pkey_trap_suppression_supported : "UH_FMT"\n", ptr_struct->is_multicast_pkey_trap_suppression_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_multicast_fdb_top_supported : "UH_FMT"\n", ptr_struct->is_multicast_fdb_top_supported);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "is_hierarchy_info_supported : "UH_FMT"\n", ptr_struct->is_hierarchy_info_supported);

}

int connectib_port_cap_mask1_fields_size(void){
	 return 4;
}

void connectib_port_cap_mask1_fields_dump(const struct connectib_port_cap_mask1_fields *ptr_struct, FILE* file) {
	connectib_port_cap_mask1_fields_print(ptr_struct, file, 0);
}

void connectib_ib_port_counters_pack(const struct connectib_ib_port_counters *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_downed_counter);

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->link_error_recovery_counter);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->symbol_error_counter);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_remote_physical_errors);

	offset=32;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_errors);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_xmit_discards);

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->port_rcv_switch_relay_errors);

	offset=124;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->excessive_buffer_overrun_errors);

	offset=120;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->local_link_integrity_errors);

	offset=104;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_rcv_constraint_errors);

	offset=96;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->port_xmit_constraint_errors);

	offset=144;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->vl15_dropped);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_xmit_data);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_rcv_data);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_xmit_pkts);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_rcv_pkts);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_xmit_wait);

}

void connectib_ib_port_counters_unpack(struct connectib_ib_port_counters *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=24;
	ptr_struct->link_downed_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=16;
	ptr_struct->link_error_recovery_counter = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->symbol_error_counter = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=48;
	ptr_struct->port_rcv_remote_physical_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=32;
	ptr_struct->port_rcv_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=80;
	ptr_struct->port_xmit_discards = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=64;
	ptr_struct->port_rcv_switch_relay_errors = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=124;
	ptr_struct->excessive_buffer_overrun_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=120;
	ptr_struct->local_link_integrity_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

	offset=104;
	ptr_struct->port_rcv_constraint_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=96;
	ptr_struct->port_xmit_constraint_errors = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=144;
	ptr_struct->vl15_dropped = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=160;
	ptr_struct->port_xmit_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->port_rcv_data = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->port_xmit_pkts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->port_rcv_pkts = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->port_xmit_wait = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_ib_port_counters_print(const struct connectib_ib_port_counters *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_ib_port_counters ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_downed_counter  : "UH_FMT"\n", ptr_struct->link_downed_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_error_recovery_counter : "UH_FMT"\n", ptr_struct->link_error_recovery_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_error_counter : "UH_FMT"\n", ptr_struct->symbol_error_counter);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_remote_physical_errors : "UH_FMT"\n", ptr_struct->port_rcv_remote_physical_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_errors      : "UH_FMT"\n", ptr_struct->port_rcv_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_discards   : "UH_FMT"\n", ptr_struct->port_xmit_discards);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_switch_relay_errors : "UH_FMT"\n", ptr_struct->port_rcv_switch_relay_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "excessive_buffer_overrun_errors : "UH_FMT"\n", ptr_struct->excessive_buffer_overrun_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "local_link_integrity_errors : "UH_FMT"\n", ptr_struct->local_link_integrity_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_constraint_errors : "UH_FMT"\n", ptr_struct->port_rcv_constraint_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_constraint_errors : "UH_FMT"\n", ptr_struct->port_xmit_constraint_errors);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "vl15_dropped         : "UH_FMT"\n", ptr_struct->vl15_dropped);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_data       : "U32H_FMT"\n", ptr_struct->port_xmit_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_data        : "U32H_FMT"\n", ptr_struct->port_rcv_data);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_pkts       : "U32H_FMT"\n", ptr_struct->port_xmit_pkts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_rcv_pkts        : "U32H_FMT"\n", ptr_struct->port_rcv_pkts);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_xmit_wait       : "U32H_FMT"\n", ptr_struct->port_xmit_wait);

}

int connectib_ib_port_counters_size(void){
	 return 248;
}

void connectib_ib_port_counters_dump(const struct connectib_ib_port_counters *ptr_struct, FILE* file) {
	connectib_ib_port_counters_print(ptr_struct, file, 0);
}

void connectib_llr_counters_pack(const struct connectib_llr_counters *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_cells_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_cells_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_error_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_error_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_crc_error_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_rx_crc_error_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_cells_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_cells_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_ret_cells_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_ret_cells_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_ret_events_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->llr_tx_ret_events_low);

}

void connectib_llr_counters_unpack(struct connectib_llr_counters *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->llr_rx_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->llr_rx_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->llr_rx_error_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->llr_rx_error_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->llr_rx_crc_error_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->llr_rx_crc_error_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->llr_tx_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->llr_tx_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->llr_tx_ret_cells_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->llr_tx_ret_cells_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->llr_tx_ret_events_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->llr_tx_ret_events_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_llr_counters_print(const struct connectib_llr_counters *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_llr_counters ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_cells_high    : "U32H_FMT"\n", ptr_struct->llr_rx_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_cells_low     : "U32H_FMT"\n", ptr_struct->llr_rx_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_error_high    : "U32H_FMT"\n", ptr_struct->llr_rx_error_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_error_low     : "U32H_FMT"\n", ptr_struct->llr_rx_error_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_crc_error_high : "U32H_FMT"\n", ptr_struct->llr_rx_crc_error_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_rx_crc_error_low : "U32H_FMT"\n", ptr_struct->llr_rx_crc_error_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_cells_high    : "U32H_FMT"\n", ptr_struct->llr_tx_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_cells_low     : "U32H_FMT"\n", ptr_struct->llr_tx_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_cells_high : "U32H_FMT"\n", ptr_struct->llr_tx_ret_cells_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_cells_low : "U32H_FMT"\n", ptr_struct->llr_tx_ret_cells_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_events_high : "U32H_FMT"\n", ptr_struct->llr_tx_ret_events_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "llr_tx_ret_events_low : "U32H_FMT"\n", ptr_struct->llr_tx_ret_events_low);

}

int connectib_llr_counters_size(void){
	 return 248;
}

void connectib_llr_counters_dump(const struct connectib_llr_counters *ptr_struct, FILE* file) {
	connectib_llr_counters_print(ptr_struct, file, 0);
}

void connectib_discard_cntrs_grp_data_pack(const struct connectib_discard_cntrs_grp_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_general_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_general_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_policy_engine_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_policy_engine_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_vlan_membership_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_vlan_membership_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_tag_frame_type_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ingress_tag_frame_type_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_vlan_membership_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_vlan_membership_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->loopback_filter_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->loopback_filter_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_general_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_general_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_link_down_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_link_down_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_hoq_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_hoq_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_isolation_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_isolation_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_policy_engine_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->egress_policy_engine_low);

}

void connectib_discard_cntrs_grp_data_unpack(struct connectib_discard_cntrs_grp_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->ingress_general_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->ingress_general_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->ingress_policy_engine_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->ingress_policy_engine_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->ingress_vlan_membership_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->ingress_vlan_membership_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->ingress_tag_frame_type_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->ingress_tag_frame_type_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->egress_vlan_membership_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->egress_vlan_membership_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->loopback_filter_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->loopback_filter_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->egress_general_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->egress_general_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->egress_link_down_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->egress_link_down_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->egress_hoq_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->egress_hoq_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->port_isolation_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->port_isolation_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->egress_policy_engine_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->egress_policy_engine_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_discard_cntrs_grp_data_print(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_discard_cntrs_grp_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_general_high : "U32H_FMT"\n", ptr_struct->ingress_general_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_general_low  : "U32H_FMT"\n", ptr_struct->ingress_general_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_policy_engine_high : "U32H_FMT"\n", ptr_struct->ingress_policy_engine_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_policy_engine_low : "U32H_FMT"\n", ptr_struct->ingress_policy_engine_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_vlan_membership_high : "U32H_FMT"\n", ptr_struct->ingress_vlan_membership_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_vlan_membership_low : "U32H_FMT"\n", ptr_struct->ingress_vlan_membership_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tag_frame_type_high : "U32H_FMT"\n", ptr_struct->ingress_tag_frame_type_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ingress_tag_frame_type_low : "U32H_FMT"\n", ptr_struct->ingress_tag_frame_type_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_vlan_membership_high : "U32H_FMT"\n", ptr_struct->egress_vlan_membership_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_vlan_membership_low : "U32H_FMT"\n", ptr_struct->egress_vlan_membership_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "loopback_filter_high : "U32H_FMT"\n", ptr_struct->loopback_filter_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "loopback_filter_low  : "U32H_FMT"\n", ptr_struct->loopback_filter_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_general_high  : "U32H_FMT"\n", ptr_struct->egress_general_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_general_low   : "U32H_FMT"\n", ptr_struct->egress_general_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_link_down_high : "U32H_FMT"\n", ptr_struct->egress_link_down_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_link_down_low : "U32H_FMT"\n", ptr_struct->egress_link_down_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_high      : "U32H_FMT"\n", ptr_struct->egress_hoq_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_hoq_low       : "U32H_FMT"\n", ptr_struct->egress_hoq_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_isolation_high  : "U32H_FMT"\n", ptr_struct->port_isolation_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_isolation_low   : "U32H_FMT"\n", ptr_struct->port_isolation_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_policy_engine_high : "U32H_FMT"\n", ptr_struct->egress_policy_engine_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "egress_policy_engine_low : "U32H_FMT"\n", ptr_struct->egress_policy_engine_low);

}

int connectib_discard_cntrs_grp_data_size(void){
	 return 248;
}

void connectib_discard_cntrs_grp_data_dump(const struct connectib_discard_cntrs_grp_data *ptr_struct, FILE* file) {
	connectib_discard_cntrs_grp_data_print(ptr_struct, file, 0);
}

void connectib_phys_layer_cntrs_pack(const struct connectib_phys_layer_cntrs *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->time_since_last_clear_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->time_since_last_clear_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->symbol_errors_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->symbol_errors_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->sync_headers_errors_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->sync_headers_errors_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane0_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane0_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane1_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane1_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane2_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane2_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane3_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->edpl_bip_errors_lane3_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane0_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane0_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane1_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane1_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane2_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane2_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane3_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_corrected_blocks_lane3_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane0_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane0_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane1_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane1_low);

	offset=832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane2_high);

	offset=864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane2_low);

	offset=896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane3_high);

	offset=928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->fc_fec_uncorrectable_blocks_lane3_low);

	offset=960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_blocks_high);

	offset=992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_blocks_low);

	offset=1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_uncorrectable_blocks_high);

	offset=1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_uncorrectable_blocks_low);

	offset=1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_no_errors_blocks_high);

	offset=1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_no_errors_blocks_low);

	offset=1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_single_error_blocks_high);

	offset=1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_single_error_blocks_low);

	offset=1216;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_total_high);

	offset=1248;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_total_low);

	offset=1280;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane0_high);

	offset=1312;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane0_low);

	offset=1344;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane1_high);

	offset=1376;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane1_low);

	offset=1408;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane2_high);

	offset=1440;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane2_low);

	offset=1472;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane3_high);

	offset=1504;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rs_fec_corrected_symbols_lane3_low);

	offset=1536;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->link_down_events);

	offset=1568;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->successful_recovery_events);

}

void connectib_phys_layer_cntrs_unpack(struct connectib_phys_layer_cntrs *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->time_since_last_clear_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->time_since_last_clear_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->symbol_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->symbol_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->sync_headers_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->sync_headers_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->edpl_bip_errors_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->edpl_bip_errors_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->edpl_bip_errors_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->edpl_bip_errors_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->edpl_bip_errors_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->edpl_bip_errors_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->edpl_bip_errors_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->edpl_bip_errors_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->fc_fec_corrected_blocks_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->fc_fec_corrected_blocks_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->fc_fec_corrected_blocks_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->fc_fec_corrected_blocks_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->fc_fec_corrected_blocks_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->fc_fec_corrected_blocks_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->fc_fec_corrected_blocks_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->fc_fec_corrected_blocks_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->fc_fec_uncorrectable_blocks_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->fc_fec_uncorrectable_blocks_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->fc_fec_uncorrectable_blocks_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->fc_fec_uncorrectable_blocks_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=832;
	ptr_struct->fc_fec_uncorrectable_blocks_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=864;
	ptr_struct->fc_fec_uncorrectable_blocks_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=896;
	ptr_struct->fc_fec_uncorrectable_blocks_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=928;
	ptr_struct->fc_fec_uncorrectable_blocks_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=960;
	ptr_struct->rs_fec_corrected_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=992;
	ptr_struct->rs_fec_corrected_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1024;
	ptr_struct->rs_fec_uncorrectable_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1056;
	ptr_struct->rs_fec_uncorrectable_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1088;
	ptr_struct->rs_fec_no_errors_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1120;
	ptr_struct->rs_fec_no_errors_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1152;
	ptr_struct->rs_fec_single_error_blocks_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1184;
	ptr_struct->rs_fec_single_error_blocks_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1216;
	ptr_struct->rs_fec_corrected_symbols_total_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1248;
	ptr_struct->rs_fec_corrected_symbols_total_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1280;
	ptr_struct->rs_fec_corrected_symbols_lane0_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1312;
	ptr_struct->rs_fec_corrected_symbols_lane0_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1344;
	ptr_struct->rs_fec_corrected_symbols_lane1_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1376;
	ptr_struct->rs_fec_corrected_symbols_lane1_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1408;
	ptr_struct->rs_fec_corrected_symbols_lane2_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1440;
	ptr_struct->rs_fec_corrected_symbols_lane2_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1472;
	ptr_struct->rs_fec_corrected_symbols_lane3_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1504;
	ptr_struct->rs_fec_corrected_symbols_lane3_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1536;
	ptr_struct->link_down_events = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1568;
	ptr_struct->successful_recovery_events = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_phys_layer_cntrs_print(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_phys_layer_cntrs ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_high : "U32H_FMT"\n", ptr_struct->time_since_last_clear_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "time_since_last_clear_low : "U32H_FMT"\n", ptr_struct->time_since_last_clear_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_errors_high   : "U32H_FMT"\n", ptr_struct->symbol_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "symbol_errors_low    : "U32H_FMT"\n", ptr_struct->symbol_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sync_headers_errors_high : "U32H_FMT"\n", ptr_struct->sync_headers_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sync_headers_errors_low : "U32H_FMT"\n", ptr_struct->sync_headers_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane0_high : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane0_low : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane1_high : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane1_low : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane2_high : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane2_low : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane3_high : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "edpl_bip_errors_lane3_low : "U32H_FMT"\n", ptr_struct->edpl_bip_errors_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane0_high : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane0_low : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane1_high : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane1_low : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane2_high : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane2_low : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane3_high : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_corrected_blocks_lane3_low : "U32H_FMT"\n", ptr_struct->fc_fec_corrected_blocks_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane0_high : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane0_low : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane1_high : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane1_low : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane2_high : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane2_low : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane3_high : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "fc_fec_uncorrectable_blocks_lane3_low : "U32H_FMT"\n", ptr_struct->fc_fec_uncorrectable_blocks_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_blocks_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_blocks_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_uncorrectable_blocks_high : "U32H_FMT"\n", ptr_struct->rs_fec_uncorrectable_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_uncorrectable_blocks_low : "U32H_FMT"\n", ptr_struct->rs_fec_uncorrectable_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_no_errors_blocks_high : "U32H_FMT"\n", ptr_struct->rs_fec_no_errors_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_no_errors_blocks_low : "U32H_FMT"\n", ptr_struct->rs_fec_no_errors_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_single_error_blocks_high : "U32H_FMT"\n", ptr_struct->rs_fec_single_error_blocks_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_single_error_blocks_low : "U32H_FMT"\n", ptr_struct->rs_fec_single_error_blocks_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_total_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_total_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_total_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_total_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane0_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane0_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane0_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane0_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane1_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane1_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane1_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane1_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane2_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane2_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane2_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane2_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane3_high : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane3_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rs_fec_corrected_symbols_lane3_low : "U32H_FMT"\n", ptr_struct->rs_fec_corrected_symbols_lane3_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "link_down_events     : "U32H_FMT"\n", ptr_struct->link_down_events);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "successful_recovery_events : "U32H_FMT"\n", ptr_struct->successful_recovery_events);

}

int connectib_phys_layer_cntrs_size(void){
	 return 200;
}

void connectib_phys_layer_cntrs_dump(const struct connectib_phys_layer_cntrs *ptr_struct, FILE* file) {
	connectib_phys_layer_cntrs_print(ptr_struct, file, 0);
}

void connectib_eth_per_traffic_grp_data_layout_pack(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->transmit_queue_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->transmit_queue_low);

}

void connectib_eth_per_traffic_grp_data_layout_unpack(struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->transmit_queue_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->transmit_queue_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_per_traffic_grp_data_layout_print(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_per_traffic_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transmit_queue_high  : "U32H_FMT"\n", ptr_struct->transmit_queue_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "transmit_queue_low   : "U32H_FMT"\n", ptr_struct->transmit_queue_low);

}

int connectib_eth_per_traffic_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_per_traffic_grp_data_layout_dump(const struct connectib_eth_per_traffic_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_per_traffic_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_per_prio_grp_data_layout_pack(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_octets_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_octets_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_frames_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_frames_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_octets_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_octets_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_frames_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_frames_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_duration_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_duration_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_pause_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_pause_low);

	offset=832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_pause_duration_high);

	offset=864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->tx_pause_duration_low);

	offset=896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_transition_high);

	offset=928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rx_pause_transition_low);

}

void connectib_eth_per_prio_grp_data_layout_unpack(struct connectib_eth_per_prio_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->rx_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->rx_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->rx_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->rx_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->tx_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->tx_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->tx_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->tx_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->rx_pause_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->rx_pause_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->rx_pause_duration_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->rx_pause_duration_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->tx_pause_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->tx_pause_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=832;
	ptr_struct->tx_pause_duration_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=864;
	ptr_struct->tx_pause_duration_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=896;
	ptr_struct->rx_pause_transition_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=928;
	ptr_struct->rx_pause_transition_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_per_prio_grp_data_layout_print(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_per_prio_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_octets_high       : "U32H_FMT"\n", ptr_struct->rx_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_octets_low        : "U32H_FMT"\n", ptr_struct->rx_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_frames_high       : "U32H_FMT"\n", ptr_struct->rx_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_frames_low        : "U32H_FMT"\n", ptr_struct->rx_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_octets_high       : "U32H_FMT"\n", ptr_struct->tx_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_octets_low        : "U32H_FMT"\n", ptr_struct->tx_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_frames_high       : "U32H_FMT"\n", ptr_struct->tx_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_frames_low        : "U32H_FMT"\n", ptr_struct->tx_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_high        : "U32H_FMT"\n", ptr_struct->rx_pause_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_low         : "U32H_FMT"\n", ptr_struct->rx_pause_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_duration_high : "U32H_FMT"\n", ptr_struct->rx_pause_duration_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_duration_low : "U32H_FMT"\n", ptr_struct->rx_pause_duration_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_high        : "U32H_FMT"\n", ptr_struct->tx_pause_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_low         : "U32H_FMT"\n", ptr_struct->tx_pause_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_duration_high : "U32H_FMT"\n", ptr_struct->tx_pause_duration_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tx_pause_duration_low : "U32H_FMT"\n", ptr_struct->tx_pause_duration_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_transition_high : "U32H_FMT"\n", ptr_struct->rx_pause_transition_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rx_pause_transition_low : "U32H_FMT"\n", ptr_struct->rx_pause_transition_low);

}

int connectib_eth_per_prio_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_per_prio_grp_data_layout_dump(const struct connectib_eth_per_prio_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_per_prio_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_extended_cntrs_grp_data_layout_pack(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_transmit_wait_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->port_transmit_wait_low);

}

void connectib_eth_extended_cntrs_grp_data_layout_unpack(struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->port_transmit_wait_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->port_transmit_wait_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_extended_cntrs_grp_data_layout_print(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_extended_cntrs_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_transmit_wait_high : "U32H_FMT"\n", ptr_struct->port_transmit_wait_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_transmit_wait_low : "U32H_FMT"\n", ptr_struct->port_transmit_wait_low);

}

int connectib_eth_extended_cntrs_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_extended_cntrs_grp_data_layout_dump(const struct connectib_eth_extended_cntrs_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_extended_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_3635_cntrs_grp_data_layout_pack(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_alignment_errors_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_alignment_errors_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_fcs_errors_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_fcs_errors_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_single_collision_frames_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_single_collision_frames_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_multiple_collision_frames_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_multiple_collision_frames_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_sqe_test_errors_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_sqe_test_errors_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_deferred_transmissions_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_deferred_transmissions_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_late_collisions_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_late_collisions_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_excessive_collisions_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_excessive_collisions_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_internal_mac_transmit_errors_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_internal_mac_transmit_errors_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_carrier_sense_errors_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_carrier_sense_errors_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_frame_too_longs_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_frame_too_longs_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_internal_mac_receive_errors_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_internal_mac_receive_errors_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_symbol_errors_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3stats_symbol_errors_low);

	offset=832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3control_in_unknown_opcodes_high);

	offset=864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3control_in_unknown_opcodes_low);

	offset=896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3in_pause_frames_high);

	offset=928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3in_pause_frames_low);

	offset=960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3out_pause_frames_high);

	offset=992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->dot3out_pause_frames_low);

}

void connectib_eth_3635_cntrs_grp_data_layout_unpack(struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->dot3stats_alignment_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->dot3stats_alignment_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->dot3stats_fcs_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->dot3stats_fcs_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->dot3stats_single_collision_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->dot3stats_single_collision_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->dot3stats_multiple_collision_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->dot3stats_multiple_collision_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->dot3stats_sqe_test_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->dot3stats_sqe_test_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->dot3stats_deferred_transmissions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->dot3stats_deferred_transmissions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->dot3stats_late_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->dot3stats_late_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->dot3stats_excessive_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->dot3stats_excessive_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->dot3stats_internal_mac_transmit_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->dot3stats_internal_mac_transmit_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->dot3stats_carrier_sense_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->dot3stats_carrier_sense_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->dot3stats_frame_too_longs_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->dot3stats_frame_too_longs_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->dot3stats_internal_mac_receive_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->dot3stats_internal_mac_receive_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->dot3stats_symbol_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->dot3stats_symbol_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=832;
	ptr_struct->dot3control_in_unknown_opcodes_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=864;
	ptr_struct->dot3control_in_unknown_opcodes_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=896;
	ptr_struct->dot3in_pause_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=928;
	ptr_struct->dot3in_pause_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=960;
	ptr_struct->dot3out_pause_frames_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=992;
	ptr_struct->dot3out_pause_frames_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_3635_cntrs_grp_data_layout_print(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_3635_cntrs_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_alignment_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_alignment_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_alignment_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_alignment_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_fcs_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_fcs_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_fcs_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_fcs_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_single_collision_frames_high : "U32H_FMT"\n", ptr_struct->dot3stats_single_collision_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_single_collision_frames_low : "U32H_FMT"\n", ptr_struct->dot3stats_single_collision_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_multiple_collision_frames_high : "U32H_FMT"\n", ptr_struct->dot3stats_multiple_collision_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_multiple_collision_frames_low : "U32H_FMT"\n", ptr_struct->dot3stats_multiple_collision_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_sqe_test_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_sqe_test_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_sqe_test_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_sqe_test_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_deferred_transmissions_high : "U32H_FMT"\n", ptr_struct->dot3stats_deferred_transmissions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_deferred_transmissions_low : "U32H_FMT"\n", ptr_struct->dot3stats_deferred_transmissions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_late_collisions_high : "U32H_FMT"\n", ptr_struct->dot3stats_late_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_late_collisions_low : "U32H_FMT"\n", ptr_struct->dot3stats_late_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_excessive_collisions_high : "U32H_FMT"\n", ptr_struct->dot3stats_excessive_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_excessive_collisions_low : "U32H_FMT"\n", ptr_struct->dot3stats_excessive_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_transmit_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_internal_mac_transmit_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_transmit_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_internal_mac_transmit_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_carrier_sense_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_carrier_sense_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_carrier_sense_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_carrier_sense_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_frame_too_longs_high : "U32H_FMT"\n", ptr_struct->dot3stats_frame_too_longs_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_frame_too_longs_low : "U32H_FMT"\n", ptr_struct->dot3stats_frame_too_longs_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_receive_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_internal_mac_receive_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_internal_mac_receive_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_internal_mac_receive_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_symbol_errors_high : "U32H_FMT"\n", ptr_struct->dot3stats_symbol_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3stats_symbol_errors_low : "U32H_FMT"\n", ptr_struct->dot3stats_symbol_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3control_in_unknown_opcodes_high : "U32H_FMT"\n", ptr_struct->dot3control_in_unknown_opcodes_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3control_in_unknown_opcodes_low : "U32H_FMT"\n", ptr_struct->dot3control_in_unknown_opcodes_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3in_pause_frames_high : "U32H_FMT"\n", ptr_struct->dot3in_pause_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3in_pause_frames_low : "U32H_FMT"\n", ptr_struct->dot3in_pause_frames_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3out_pause_frames_high : "U32H_FMT"\n", ptr_struct->dot3out_pause_frames_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dot3out_pause_frames_low : "U32H_FMT"\n", ptr_struct->dot3out_pause_frames_low);

}

int connectib_eth_3635_cntrs_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_3635_cntrs_grp_data_layout_dump(const struct connectib_eth_3635_cntrs_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_3635_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_2819_cntrs_grp_data_layout_pack(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_drop_events_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_drop_events_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_octets_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_octets_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_broadcast_pkts_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_broadcast_pkts_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_multicast_pkts_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_multicast_pkts_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_crc_align_errors_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_crc_align_errors_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_undersize_pkts_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_undersize_pkts_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_oversize_pkts_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_oversize_pkts_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_fragments_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_fragments_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_jabbers_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_jabbers_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_collisions_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_collisions_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts64octets_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts64octets_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts65to127octets_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts65to127octets_low);

	offset=832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts128to255octets_high);

	offset=864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts128to255octets_low);

	offset=896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts256to511octets_high);

	offset=928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts256to511octets_low);

	offset=960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts512to1023octets_high);

	offset=992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts512to1023octets_low);

	offset=1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts1024to1518octets_high);

	offset=1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts1024to1518octets_low);

	offset=1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts1519to2047octets_high);

	offset=1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts1519to2047octets_low);

	offset=1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts2048to4095octets_high);

	offset=1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts2048to4095octets_low);

	offset=1216;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts4096to8191octets_high);

	offset=1248;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts4096to8191octets_low);

	offset=1280;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts8192to10239octets_high);

	offset=1312;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->ether_stats_pkts8192to10239octets_low);

}

void connectib_eth_2819_cntrs_grp_data_layout_unpack(struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->ether_stats_drop_events_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->ether_stats_drop_events_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->ether_stats_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->ether_stats_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->ether_stats_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->ether_stats_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->ether_stats_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->ether_stats_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->ether_stats_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->ether_stats_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->ether_stats_crc_align_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->ether_stats_crc_align_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->ether_stats_undersize_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->ether_stats_undersize_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->ether_stats_oversize_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->ether_stats_oversize_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->ether_stats_fragments_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->ether_stats_fragments_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->ether_stats_jabbers_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->ether_stats_jabbers_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->ether_stats_collisions_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->ether_stats_collisions_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->ether_stats_pkts64octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->ether_stats_pkts64octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->ether_stats_pkts65to127octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->ether_stats_pkts65to127octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=832;
	ptr_struct->ether_stats_pkts128to255octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=864;
	ptr_struct->ether_stats_pkts128to255octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=896;
	ptr_struct->ether_stats_pkts256to511octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=928;
	ptr_struct->ether_stats_pkts256to511octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=960;
	ptr_struct->ether_stats_pkts512to1023octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=992;
	ptr_struct->ether_stats_pkts512to1023octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1024;
	ptr_struct->ether_stats_pkts1024to1518octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1056;
	ptr_struct->ether_stats_pkts1024to1518octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1088;
	ptr_struct->ether_stats_pkts1519to2047octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1120;
	ptr_struct->ether_stats_pkts1519to2047octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1152;
	ptr_struct->ether_stats_pkts2048to4095octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1184;
	ptr_struct->ether_stats_pkts2048to4095octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1216;
	ptr_struct->ether_stats_pkts4096to8191octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1248;
	ptr_struct->ether_stats_pkts4096to8191octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1280;
	ptr_struct->ether_stats_pkts8192to10239octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1312;
	ptr_struct->ether_stats_pkts8192to10239octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_2819_cntrs_grp_data_layout_print(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_2819_cntrs_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_drop_events_high : "U32H_FMT"\n", ptr_struct->ether_stats_drop_events_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_drop_events_low : "U32H_FMT"\n", ptr_struct->ether_stats_drop_events_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_broadcast_pkts_high : "U32H_FMT"\n", ptr_struct->ether_stats_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_broadcast_pkts_low : "U32H_FMT"\n", ptr_struct->ether_stats_broadcast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_multicast_pkts_high : "U32H_FMT"\n", ptr_struct->ether_stats_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_multicast_pkts_low : "U32H_FMT"\n", ptr_struct->ether_stats_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_crc_align_errors_high : "U32H_FMT"\n", ptr_struct->ether_stats_crc_align_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_crc_align_errors_low : "U32H_FMT"\n", ptr_struct->ether_stats_crc_align_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_undersize_pkts_high : "U32H_FMT"\n", ptr_struct->ether_stats_undersize_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_undersize_pkts_low : "U32H_FMT"\n", ptr_struct->ether_stats_undersize_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_oversize_pkts_high : "U32H_FMT"\n", ptr_struct->ether_stats_oversize_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_oversize_pkts_low : "U32H_FMT"\n", ptr_struct->ether_stats_oversize_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_fragments_high : "U32H_FMT"\n", ptr_struct->ether_stats_fragments_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_fragments_low : "U32H_FMT"\n", ptr_struct->ether_stats_fragments_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_jabbers_high : "U32H_FMT"\n", ptr_struct->ether_stats_jabbers_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_jabbers_low : "U32H_FMT"\n", ptr_struct->ether_stats_jabbers_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_collisions_high : "U32H_FMT"\n", ptr_struct->ether_stats_collisions_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_collisions_low : "U32H_FMT"\n", ptr_struct->ether_stats_collisions_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts64octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts64octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts64octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts64octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts65to127octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts65to127octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts65to127octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts65to127octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts128to255octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts128to255octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts128to255octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts128to255octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts256to511octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts256to511octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts256to511octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts256to511octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts512to1023octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts512to1023octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts512to1023octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts512to1023octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1024to1518octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts1024to1518octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1024to1518octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts1024to1518octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1519to2047octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts1519to2047octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts1519to2047octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts1519to2047octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts2048to4095octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts2048to4095octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts2048to4095octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts2048to4095octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts4096to8191octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts4096to8191octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts4096to8191octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts4096to8191octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts8192to10239octets_high : "U32H_FMT"\n", ptr_struct->ether_stats_pkts8192to10239octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "ether_stats_pkts8192to10239octets_low : "U32H_FMT"\n", ptr_struct->ether_stats_pkts8192to10239octets_low);

}

int connectib_eth_2819_cntrs_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_2819_cntrs_grp_data_layout_dump(const struct connectib_eth_2819_cntrs_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_2819_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_2863_cntrs_grp_data_layout_pack(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_octets_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_octets_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_ucast_pkts_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_ucast_pkts_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_discards_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_discards_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_errors_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_errors_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_unknown_protos_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_unknown_protos_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_octets_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_octets_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_ucast_pkts_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_ucast_pkts_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_discards_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_discards_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_errors_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_errors_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_multicast_pkts_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_multicast_pkts_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_broadcast_pkts_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_in_broadcast_pkts_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_multicast_pkts_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_multicast_pkts_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_broadcast_pkts_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->if_out_broadcast_pkts_low);

}

void connectib_eth_2863_cntrs_grp_data_layout_unpack(struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->if_in_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->if_in_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->if_in_ucast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->if_in_ucast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->if_in_discards_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->if_in_discards_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->if_in_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->if_in_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->if_in_unknown_protos_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->if_in_unknown_protos_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->if_out_octets_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->if_out_octets_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->if_out_ucast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->if_out_ucast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->if_out_discards_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->if_out_discards_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->if_out_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->if_out_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->if_in_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->if_in_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->if_in_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->if_in_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->if_out_multicast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->if_out_multicast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->if_out_broadcast_pkts_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->if_out_broadcast_pkts_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_2863_cntrs_grp_data_layout_print(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_2863_cntrs_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_octets_high    : "U32H_FMT"\n", ptr_struct->if_in_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_octets_low     : "U32H_FMT"\n", ptr_struct->if_in_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_ucast_pkts_high : "U32H_FMT"\n", ptr_struct->if_in_ucast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_ucast_pkts_low : "U32H_FMT"\n", ptr_struct->if_in_ucast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_discards_high  : "U32H_FMT"\n", ptr_struct->if_in_discards_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_discards_low   : "U32H_FMT"\n", ptr_struct->if_in_discards_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_errors_high    : "U32H_FMT"\n", ptr_struct->if_in_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_errors_low     : "U32H_FMT"\n", ptr_struct->if_in_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_unknown_protos_high : "U32H_FMT"\n", ptr_struct->if_in_unknown_protos_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_unknown_protos_low : "U32H_FMT"\n", ptr_struct->if_in_unknown_protos_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_octets_high   : "U32H_FMT"\n", ptr_struct->if_out_octets_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_octets_low    : "U32H_FMT"\n", ptr_struct->if_out_octets_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_ucast_pkts_high : "U32H_FMT"\n", ptr_struct->if_out_ucast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_ucast_pkts_low : "U32H_FMT"\n", ptr_struct->if_out_ucast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_discards_high : "U32H_FMT"\n", ptr_struct->if_out_discards_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_discards_low  : "U32H_FMT"\n", ptr_struct->if_out_discards_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_errors_high   : "U32H_FMT"\n", ptr_struct->if_out_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_errors_low    : "U32H_FMT"\n", ptr_struct->if_out_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_multicast_pkts_high : "U32H_FMT"\n", ptr_struct->if_in_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_multicast_pkts_low : "U32H_FMT"\n", ptr_struct->if_in_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_broadcast_pkts_high : "U32H_FMT"\n", ptr_struct->if_in_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_in_broadcast_pkts_low : "U32H_FMT"\n", ptr_struct->if_in_broadcast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_multicast_pkts_high : "U32H_FMT"\n", ptr_struct->if_out_multicast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_multicast_pkts_low : "U32H_FMT"\n", ptr_struct->if_out_multicast_pkts_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_broadcast_pkts_high : "U32H_FMT"\n", ptr_struct->if_out_broadcast_pkts_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "if_out_broadcast_pkts_low : "U32H_FMT"\n", ptr_struct->if_out_broadcast_pkts_low);

}

int connectib_eth_2863_cntrs_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_2863_cntrs_grp_data_layout_dump(const struct connectib_eth_2863_cntrs_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_2863_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_eth_802_3_cntrs_grp_data_layout_pack(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frames_transmitted_ok_high);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frames_transmitted_ok_low);

	offset=64;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frames_received_ok_high);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frames_received_ok_low);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frame_check_sequence_errors_high);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frame_check_sequence_errors_low);

	offset=192;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_alignment_errors_high);

	offset=224;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_alignment_errors_low);

	offset=256;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_octets_transmitted_ok_high);

	offset=288;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_octets_transmitted_ok_low);

	offset=320;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_octets_received_ok_high);

	offset=352;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_octets_received_ok_low);

	offset=384;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_multicast_frames_xmitted_ok_high);

	offset=416;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_multicast_frames_xmitted_ok_low);

	offset=448;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_broadcast_frames_xmitted_ok_high);

	offset=480;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_broadcast_frames_xmitted_ok_low);

	offset=512;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_multicast_frames_received_ok_high);

	offset=544;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_multicast_frames_received_ok_low);

	offset=576;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_broadcast_frames_recieved_ok_high);

	offset=608;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_broadcast_frames_recieved_ok_low);

	offset=640;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_in_range_length_errors_high);

	offset=672;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_in_range_length_errors_low);

	offset=704;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_out_of_range_length_field_high);

	offset=736;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_out_of_range_length_field_low);

	offset=768;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frame_too_long_errors_high);

	offset=800;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_frame_too_long_errors_low);

	offset=832;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_symbol_error_during_carrier_high);

	offset=864;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_symbol_error_during_carrier_low);

	offset=896;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_mac_control_frames_transmitted_high);

	offset=928;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_mac_control_frames_transmitted_low);

	offset=960;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_mac_control_frames_received_high);

	offset=992;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_mac_control_frames_received_low);

	offset=1024;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_unsupported_opcodes_received_high);

	offset=1056;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_unsupported_opcodes_received_low);

	offset=1088;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_pause_mac_ctrl_frames_received_high);

	offset=1120;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_pause_mac_ctrl_frames_received_low);

	offset=1152;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_pause_mac_ctrl_frames_transmitted_high);

	offset=1184;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->a_pause_mac_ctrl_frames_transmitted_low);

}

void connectib_eth_802_3_cntrs_grp_data_layout_unpack(struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->a_frames_transmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->a_frames_transmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=64;
	ptr_struct->a_frames_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=96;
	ptr_struct->a_frames_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->a_frame_check_sequence_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->a_frame_check_sequence_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=192;
	ptr_struct->a_alignment_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=224;
	ptr_struct->a_alignment_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=256;
	ptr_struct->a_octets_transmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=288;
	ptr_struct->a_octets_transmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=320;
	ptr_struct->a_octets_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=352;
	ptr_struct->a_octets_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=384;
	ptr_struct->a_multicast_frames_xmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=416;
	ptr_struct->a_multicast_frames_xmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=448;
	ptr_struct->a_broadcast_frames_xmitted_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=480;
	ptr_struct->a_broadcast_frames_xmitted_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=512;
	ptr_struct->a_multicast_frames_received_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=544;
	ptr_struct->a_multicast_frames_received_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=576;
	ptr_struct->a_broadcast_frames_recieved_ok_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=608;
	ptr_struct->a_broadcast_frames_recieved_ok_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=640;
	ptr_struct->a_in_range_length_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=672;
	ptr_struct->a_in_range_length_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=704;
	ptr_struct->a_out_of_range_length_field_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=736;
	ptr_struct->a_out_of_range_length_field_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=768;
	ptr_struct->a_frame_too_long_errors_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=800;
	ptr_struct->a_frame_too_long_errors_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=832;
	ptr_struct->a_symbol_error_during_carrier_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=864;
	ptr_struct->a_symbol_error_during_carrier_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=896;
	ptr_struct->a_mac_control_frames_transmitted_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=928;
	ptr_struct->a_mac_control_frames_transmitted_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=960;
	ptr_struct->a_mac_control_frames_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=992;
	ptr_struct->a_mac_control_frames_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1024;
	ptr_struct->a_unsupported_opcodes_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1056;
	ptr_struct->a_unsupported_opcodes_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1088;
	ptr_struct->a_pause_mac_ctrl_frames_received_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1120;
	ptr_struct->a_pause_mac_ctrl_frames_received_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1152;
	ptr_struct->a_pause_mac_ctrl_frames_transmitted_high = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=1184;
	ptr_struct->a_pause_mac_ctrl_frames_transmitted_low = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_eth_802_3_cntrs_grp_data_layout_print(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_eth_802_3_cntrs_grp_data_layout ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_transmitted_ok_high : "U32H_FMT"\n", ptr_struct->a_frames_transmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_transmitted_ok_low : "U32H_FMT"\n", ptr_struct->a_frames_transmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_received_ok_high : "U32H_FMT"\n", ptr_struct->a_frames_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frames_received_ok_low : "U32H_FMT"\n", ptr_struct->a_frames_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_check_sequence_errors_high : "U32H_FMT"\n", ptr_struct->a_frame_check_sequence_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_check_sequence_errors_low : "U32H_FMT"\n", ptr_struct->a_frame_check_sequence_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_alignment_errors_high : "U32H_FMT"\n", ptr_struct->a_alignment_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_alignment_errors_low : "U32H_FMT"\n", ptr_struct->a_alignment_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_transmitted_ok_high : "U32H_FMT"\n", ptr_struct->a_octets_transmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_transmitted_ok_low : "U32H_FMT"\n", ptr_struct->a_octets_transmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_received_ok_high : "U32H_FMT"\n", ptr_struct->a_octets_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_octets_received_ok_low : "U32H_FMT"\n", ptr_struct->a_octets_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_xmitted_ok_high : "U32H_FMT"\n", ptr_struct->a_multicast_frames_xmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_xmitted_ok_low : "U32H_FMT"\n", ptr_struct->a_multicast_frames_xmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_xmitted_ok_high : "U32H_FMT"\n", ptr_struct->a_broadcast_frames_xmitted_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_xmitted_ok_low : "U32H_FMT"\n", ptr_struct->a_broadcast_frames_xmitted_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_received_ok_high : "U32H_FMT"\n", ptr_struct->a_multicast_frames_received_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_multicast_frames_received_ok_low : "U32H_FMT"\n", ptr_struct->a_multicast_frames_received_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_recieved_ok_high : "U32H_FMT"\n", ptr_struct->a_broadcast_frames_recieved_ok_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_broadcast_frames_recieved_ok_low : "U32H_FMT"\n", ptr_struct->a_broadcast_frames_recieved_ok_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_in_range_length_errors_high : "U32H_FMT"\n", ptr_struct->a_in_range_length_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_in_range_length_errors_low : "U32H_FMT"\n", ptr_struct->a_in_range_length_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_out_of_range_length_field_high : "U32H_FMT"\n", ptr_struct->a_out_of_range_length_field_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_out_of_range_length_field_low : "U32H_FMT"\n", ptr_struct->a_out_of_range_length_field_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_too_long_errors_high : "U32H_FMT"\n", ptr_struct->a_frame_too_long_errors_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_frame_too_long_errors_low : "U32H_FMT"\n", ptr_struct->a_frame_too_long_errors_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_symbol_error_during_carrier_high : "U32H_FMT"\n", ptr_struct->a_symbol_error_during_carrier_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_symbol_error_during_carrier_low : "U32H_FMT"\n", ptr_struct->a_symbol_error_during_carrier_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_transmitted_high : "U32H_FMT"\n", ptr_struct->a_mac_control_frames_transmitted_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_transmitted_low : "U32H_FMT"\n", ptr_struct->a_mac_control_frames_transmitted_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_received_high : "U32H_FMT"\n", ptr_struct->a_mac_control_frames_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_mac_control_frames_received_low : "U32H_FMT"\n", ptr_struct->a_mac_control_frames_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_unsupported_opcodes_received_high : "U32H_FMT"\n", ptr_struct->a_unsupported_opcodes_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_unsupported_opcodes_received_low : "U32H_FMT"\n", ptr_struct->a_unsupported_opcodes_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_received_high : "U32H_FMT"\n", ptr_struct->a_pause_mac_ctrl_frames_received_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_received_low : "U32H_FMT"\n", ptr_struct->a_pause_mac_ctrl_frames_received_low);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_transmitted_high : "U32H_FMT"\n", ptr_struct->a_pause_mac_ctrl_frames_transmitted_high);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "a_pause_mac_ctrl_frames_transmitted_low : "U32H_FMT"\n", ptr_struct->a_pause_mac_ctrl_frames_transmitted_low);

}

int connectib_eth_802_3_cntrs_grp_data_layout_size(void){
	 return 248;
}

void connectib_eth_802_3_cntrs_grp_data_layout_dump(const struct connectib_eth_802_3_cntrs_grp_data_layout *ptr_struct, FILE* file) {
	connectib_eth_802_3_cntrs_grp_data_layout_print(ptr_struct, file, 0);
}

void connectib_cmdif_ctx_special_pack(const union connectib_cmdif_ctx_special *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_dmfs_pack(&(ptr_struct->dmfs), ptr_buff);
}

void connectib_cmdif_ctx_special_unpack(union connectib_cmdif_ctx_special *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_cmdif_ctx_dmfs_unpack(&(ptr_struct->dmfs), ptr_buff);
}

void connectib_cmdif_ctx_special_print(const union connectib_cmdif_ctx_special *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_cmdif_ctx_special ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "c:\n");
	connectib_cmdif_ctx_special_create_print(&(ptr_struct->c), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "tir:\n");
	connectib_cmdif_ctx_special_modify_tir_print(&(ptr_struct->tir), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qp:\n");
	connectib_cmdif_ctx_special_create_qp_print(&(ptr_struct->qp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rq:\n");
	connectib_cmdif_ctx_special_create_rq_print(&(ptr_struct->rq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "srq:\n");
	connectib_cmdif_ctx_special_create_srq_print(&(ptr_struct->srq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rqt:\n");
	connectib_cmdif_ctx_rqt_print(&(ptr_struct->rqt), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "eq:\n");
	connectib_cmdif_ctx_special_create_eq_print(&(ptr_struct->eq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "c_cq:\n");
	connectib_cmdif_ctx_special_create_cq_print(&(ptr_struct->c_cq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "m_cq:\n");
	connectib_cmdif_ctx_special_modify_cq_print(&(ptr_struct->m_cq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mkey:\n");
	connectib_cmdif_ctx_special_mkey_print(&(ptr_struct->mkey), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "arm_rq:\n");
	connectib_cmdif_ctx_special_arm_rq_print(&(ptr_struct->arm_rq), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "modify_rmp:\n");
	connectib_cmdif_ctx_special_modify_rmp_print(&(ptr_struct->modify_rmp), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "sniffer:\n");
	connectib_cmdif_ctx_sniffer_print(&(ptr_struct->sniffer), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mcg:\n");
	connectib_cmdif_ctx_mcg_print(&(ptr_struct->mcg), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "psv:\n");
	connectib_cmdif_ctx_psv_print(&(ptr_struct->psv), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "mtt:\n");
	connectib_cmdif_ctx_create_mtt_print(&(ptr_struct->mtt), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "dmfs:\n");
	connectib_cmdif_ctx_dmfs_print(&(ptr_struct->dmfs), file, indent_level + 1);

}

int connectib_cmdif_ctx_special_size(void){
	 return 32;
}

void connectib_cmdif_ctx_special_dump(const union connectib_cmdif_ctx_special *ptr_struct, FILE* file) {
	connectib_cmdif_ctx_special_print(ptr_struct, file, 0);
}

void connectib_flush_type_pack(const union connectib_flush_type *ptr_struct, u_int8_t* ptr_buff)
{
	connectib_flush_type_bitmask_pack(&(ptr_struct->bitmask), ptr_buff);
}

void connectib_flush_type_unpack(union connectib_flush_type *ptr_struct, const u_int8_t* ptr_buff)
{
	connectib_flush_type_bitmask_unpack(&(ptr_struct->bitmask), ptr_buff);
}

void connectib_flush_type_print(const union connectib_flush_type *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_flush_type ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bits:\n");
	connectib_flush_type_bits_print(&(ptr_struct->bits), file, indent_level + 1);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bitmask:\n");
	connectib_flush_type_bitmask_print(&(ptr_struct->bitmask), file, indent_level + 1);

}

int connectib_flush_type_size(void){
	 return 4;
}

void connectib_flush_type_dump(const union connectib_flush_type *ptr_struct, FILE* file) {
	connectib_flush_type_print(ptr_struct, file, 0);
}

void connectib_sw_eqe_flat_data_pack(const struct connectib_sw_eqe_flat_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 7; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 224, 1);
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->data[i]);
	}

}

void connectib_sw_eqe_flat_data_unpack(struct connectib_sw_eqe_flat_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	for (i=0; i < 7; i++) {
	offset=adb2c_calc_array_field_address(0, 32, i, 224, 1);
	ptr_struct->data[i] = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);
	}

}

void connectib_sw_eqe_flat_data_print(const struct connectib_sw_eqe_flat_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_eqe_flat_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	for (i=0; i < 7; i++) {
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "data_%03d            : "U32H_FMT"\n", i, ptr_struct->data[i]);
	}

}

int connectib_sw_eqe_flat_data_size(void){
	 return 28;
}

void connectib_sw_eqe_flat_data_dump(const struct connectib_sw_eqe_flat_data *ptr_struct, FILE* file) {
	connectib_sw_eqe_flat_data_print(ptr_struct, file, 0);
}

void connectib_db_bf_congestion_event_pack(const struct connectib_db_bf_congestion_event *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->congestion_level);

	offset=0;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->event_subtype);

}

void connectib_db_bf_congestion_event_unpack(struct connectib_db_bf_congestion_event *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->congestion_level = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

	offset=0;
	ptr_struct->event_subtype = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_db_bf_congestion_event_print(const struct connectib_db_bf_congestion_event *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_db_bf_congestion_event ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "congestion_level     : "UH_FMT"\n", ptr_struct->congestion_level);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "event_subtype        : "UH_FMT"\n", ptr_struct->event_subtype);

}

int connectib_db_bf_congestion_event_size(void){
	 return 24;
}

void connectib_db_bf_congestion_event_dump(const struct connectib_db_bf_congestion_event *ptr_struct, FILE* file) {
	connectib_db_bf_congestion_event_print(ptr_struct, file, 0);
}

void connectib_rdma_page_fault_event_pack(const struct connectib_rdma_page_fault_event *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->bytes_committed);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->r_key);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->packet_len);

	offset=96;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rdma_op_len);

	offset=128;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rdma_va_hi);

	offset=160;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->rdma_va_lo);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->qpn);

	offset=199;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->requestor);

	offset=198;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_read_);

	offset=197;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rdma);

}

void connectib_rdma_page_fault_event_unpack(struct connectib_rdma_page_fault_event *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->bytes_committed = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=32;
	ptr_struct->r_key = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=80;
	ptr_struct->packet_len = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=96;
	ptr_struct->rdma_op_len = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=128;
	ptr_struct->rdma_va_hi = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=160;
	ptr_struct->rdma_va_lo = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=200;
	ptr_struct->qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=199;
	ptr_struct->requestor = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=198;
	ptr_struct->write_read_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=197;
	ptr_struct->rdma = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_rdma_page_fault_event_print(const struct connectib_rdma_page_fault_event *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_rdma_page_fault_event ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bytes_committed      : "U32H_FMT"\n", ptr_struct->bytes_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "r_key                : "U32H_FMT"\n", ptr_struct->r_key);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "packet_len           : "UH_FMT"\n", ptr_struct->packet_len);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdma_op_len          : "U32H_FMT"\n", ptr_struct->rdma_op_len);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdma_va_hi           : "U32H_FMT"\n", ptr_struct->rdma_va_hi);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdma_va_lo           : "U32H_FMT"\n", ptr_struct->rdma_va_lo);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpn                  : "UH_FMT"\n", ptr_struct->qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "requestor            : "UH_FMT"\n", ptr_struct->requestor);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_read_          : "UH_FMT"\n", ptr_struct->write_read_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdma                 : "UH_FMT"\n", ptr_struct->rdma);

}

int connectib_rdma_page_fault_event_size(void){
	 return 28;
}

void connectib_rdma_page_fault_event_dump(const struct connectib_rdma_page_fault_event *ptr_struct, FILE* file) {
	connectib_rdma_page_fault_event_print(ptr_struct, file, 0);
}

void connectib_wqe_page_fault_event_pack(const struct connectib_wqe_page_fault_event *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->bytes_committed);

	offset=48;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->wqe_index);

	offset=80;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->packet_len);

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->qpn);

	offset=199;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->req_res_);

	offset=198;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->write_read_);

	offset=197;
	adb2c_push_bits_to_buff(ptr_buff, offset, 1, (u_int32_t)ptr_struct->rdma);

}

void connectib_wqe_page_fault_event_unpack(struct connectib_wqe_page_fault_event *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=0;
	ptr_struct->bytes_committed = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

	offset=48;
	ptr_struct->wqe_index = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=80;
	ptr_struct->packet_len = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=200;
	ptr_struct->qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=199;
	ptr_struct->req_res_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=198;
	ptr_struct->write_read_ = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

	offset=197;
	ptr_struct->rdma = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 1);

}

void connectib_wqe_page_fault_event_print(const struct connectib_wqe_page_fault_event *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_wqe_page_fault_event ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "bytes_committed      : "U32H_FMT"\n", ptr_struct->bytes_committed);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "wqe_index            : "UH_FMT"\n", ptr_struct->wqe_index);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "packet_len           : "UH_FMT"\n", ptr_struct->packet_len);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpn                  : "UH_FMT"\n", ptr_struct->qpn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "req_res_             : "UH_FMT"\n", ptr_struct->req_res_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "write_read_          : "UH_FMT"\n", ptr_struct->write_read_);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "rdma                 : "UH_FMT"\n", ptr_struct->rdma);

}

int connectib_wqe_page_fault_event_size(void){
	 return 28;
}

void connectib_wqe_page_fault_event_dump(const struct connectib_wqe_page_fault_event *ptr_struct, FILE* file) {
	connectib_wqe_page_fault_event_print(ptr_struct, file, 0);
}

void connectib_page_request_event_pack(const struct connectib_page_request_event *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	adb2c_push_bits_to_buff(ptr_buff, offset, 16, (u_int32_t)ptr_struct->function_id);

	offset=32;
	adb2c_push_integer_to_buff(ptr_buff, offset, 4, (u_int64_t)ptr_struct->num_pages);

}

void connectib_page_request_event_unpack(struct connectib_page_request_event *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=16;
	ptr_struct->function_id = (u_int16_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 16);

	offset=32;
	ptr_struct->num_pages = (u_int32_t)adb2c_pop_integer_from_buff(ptr_buff, offset, 4);

}

void connectib_page_request_event_print(const struct connectib_page_request_event *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_page_request_event ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "function_id          : "UH_FMT"\n", ptr_struct->function_id);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "num_pages            : "U32H_FMT"\n", ptr_struct->num_pages);

}

int connectib_page_request_event_size(void){
	 return 28;
}

void connectib_page_request_event_dump(const struct connectib_page_request_event *ptr_struct, FILE* file) {
	connectib_page_request_event_print(ptr_struct, file, 0);
}

void connectib_port_state_change_event_pack(const struct connectib_port_state_change_event *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=64;
	adb2c_push_bits_to_buff(ptr_buff, offset, 4, (u_int32_t)ptr_struct->port_num);

}

void connectib_port_state_change_event_unpack(struct connectib_port_state_change_event *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=64;
	ptr_struct->port_num = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 4);

}

void connectib_port_state_change_event_print(const struct connectib_port_state_change_event *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_port_state_change_event ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "port_num             : "UH_FMT"\n", ptr_struct->port_num);

}

int connectib_port_state_change_event_size(void){
	 return 28;
}

void connectib_port_state_change_event_dump(const struct connectib_port_state_change_event *ptr_struct, FILE* file) {
	connectib_port_state_change_event_print(ptr_struct, file, 0);
}

void connectib_sw_eqe_qp_data_pack(const struct connectib_sw_eqe_qp_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->qpn);

}

void connectib_sw_eqe_qp_data_unpack(struct connectib_sw_eqe_qp_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=200;
	ptr_struct->qpn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_sw_eqe_qp_data_print(const struct connectib_sw_eqe_qp_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_eqe_qp_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "qpn                  : "UH_FMT"\n", ptr_struct->qpn);

}

int connectib_sw_eqe_qp_data_size(void){
	 return 28;
}

void connectib_sw_eqe_qp_data_dump(const struct connectib_sw_eqe_qp_data *ptr_struct, FILE* file) {
	connectib_sw_eqe_qp_data_print(ptr_struct, file, 0);
}

void connectib_sw_eqe_error_data_pack(const struct connectib_sw_eqe_error_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cqn);

	offset=88;
	adb2c_push_bits_to_buff(ptr_buff, offset, 8, (u_int32_t)ptr_struct->syndrome);

}

void connectib_sw_eqe_error_data_unpack(struct connectib_sw_eqe_error_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=8;
	ptr_struct->cqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

	offset=88;
	ptr_struct->syndrome = (u_int8_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 8);

}

void connectib_sw_eqe_error_data_print(const struct connectib_sw_eqe_error_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_eqe_error_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "cqn                  : "UH_FMT"\n", ptr_struct->cqn);

	adb2c_add_indentation(file, indent_level);
	fprintf(file, "syndrome             : "UH_FMT"\n", ptr_struct->syndrome);

}

int connectib_sw_eqe_error_data_size(void){
	 return 28;
}

void connectib_sw_eqe_error_data_dump(const struct connectib_sw_eqe_error_data *ptr_struct, FILE* file) {
	connectib_sw_eqe_error_data_print(ptr_struct, file, 0);
}

void connectib_sw_eqe_cq_data_pack(const struct connectib_sw_eqe_cq_data *ptr_struct, u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=200;
	adb2c_push_bits_to_buff(ptr_buff, offset, 24, (u_int32_t)ptr_struct->cqn);

}

void connectib_sw_eqe_cq_data_unpack(struct connectib_sw_eqe_cq_data *ptr_struct, const u_int8_t* ptr_buff){
	u_int32_t offset;
	int i=0;
	u_int8_t val=0;
	(void)val;
	(void)offset;
	(void)i;
	(void)ptr_struct;
	(void)ptr_buff;

	offset=200;
	ptr_struct->cqn = (u_int32_t)adb2c_pop_bits_from_buff(ptr_buff, offset, 24);

}

void connectib_sw_eqe_cq_data_print(const struct connectib_sw_eqe_cq_data *ptr_struct, FILE* file, int indent_level){
	adb2c_add_indentation(file, indent_level);
	fprintf(file, "======== connectib_sw_eqe_cq_data ========\n");
	int i=0;
	(void)i;(void)ptr_struct;
	(void)file;
	(void)indent_level;

	adb2c_add_indentation(file, inde