.TH mspdebug 1 "9 Nov 2010" "Version 0.13"
.SH NAME
MSPDebug - debugging tool for MSP430 MCUs
.SH SYNOPSIS
\fBmspdebug\fR [options] \fIdriver\fR [\fIcommand\fR ...]
.SH DESCRIPTION
MSPDebug is a command-line tool designed for debugging and programming
the MSP430 family of MCUs. It supports the eZ430-F2013, eZ430-RF2500,
FET430UIF and Olimex MSP-JTAG-TINY programming tools, as well as a
simulation mode.

When started with appropriate options, MSPDebug will attempt to
connect to the debugging tool specified and identify the device under
test. Once connected, the user is presented with a command prompt
which can be used to reflash the device memory, inspect memory and
registers, set registers, and control the CPU (single step, run and
run to breakpoint).

It supports ELF32, Intel HEX and BSD-style symbol tables (such as the
output produced by \fBnm\fR(1)). It can also be used as a remote stub
for \fBgdb\fR(1).

On startup, MSPDebug will look for a file called .mspdebug in the user's
home directory. If it exists, commands will be read and executed from this
file before executing any other commands or starting the interactive
reader.
.SH COMMAND-LINE OPTIONS
Command-line options accepted by MSPDebug are described below. If
commands are specified on the end of the command-line, then they are
executed after connecting to the device, and the interactive prompt is
not started. See the section labelled \fBCOMMANDS\fR for more
information.
.IP "\-q"
Start in quiet mode. See the "quiet" option described below.
.IP "\-v \fIvoltage\fR"
Set the programming voltage. The voltage should be specified as an integer
in millivolts. It defaults to 3000 (3.0 V).
.IP "\-j"
Use JTAG instead of Spy-Bi-Wire to communicate with the MSP430. This
option only works on FET430UIF devices.
.IP "\-d \fIdevice\fR"
Specify that the driver should connect via a tty device rather than USB.
The supported connection methods vary depending on the driver. See the
section \fBDRIVERS\fR below for details.
.IP "\-U \fIbus\fR:\fIdevice\fR"
Specify a particular USB device to connect to. Without this option,
the first device of the appropriate type is opened.
.IP "\-n"
Do not process the startup file (~/.mspdebug).
.IP "\--long-password"
When using the flash-bsl driver, send a 32-byte BSL password instead
of the standard 16-byte password.
.IP "\-\-help"
Display a brief help message and exit.
.IP "\-\-fet\-list"
Display a list of devices supported by the FET driver (the driver used
for \fB\-R\fR and \fB\-u\fR operating modes).
.IP "\-\-fet\-force\-id \fIstring\fR"
When using a FET device, force the connected chip to be recognised by
MSPDebug as one of the given type during initialization. This overrides
the device ID returned by the FET.
.IP "\-\-usb\-list"
List available USB devices and exit.
.IP "\-\-version"
Show program version and copyright information.
.SH DRIVERS
A driver name must be specified on the command line for MSPDebug to
connect to. Valid driver names are listed here.
.IP "\fBrf2500\fR"
Connect to an eZ430-RF2500 device. Only USB connection is supported.
.IP "\fBolimex\fR"
Connect to an Olimex MSP-JTAG-TINY device. Both USB and tty access are
supported.
.IP "\fBolimex-iso\fR"
Connect to an Olimex MSP-JTAG-ISO device. Only tty access is supported.
.IP "\fBsim\fR"
Do not connect to any hardware device, but instead start in simulation
mode. A 64k buffer is allocated to simulate the device memory. The CPU
core alone is emulated (no peripheral emulation).

During simulation, addresses below 0x0200 are assumed to be IO memory.
When data is written to an IO memory address, a message is displayed
on the console showing the program counter location, address written
to, and data. The data value is also written to simulated RAM at the
relevant address.

When data is read from IO memory, the user is notified similarly and
prompted to supply the data. At this prompt, address expressions can
be entered. If no value is entered, the value is read from simulated
RAM. The user can press Ctrl+C to abort an IO request and stop
execution.

This mode is intended for testing of changes to MSPDebug, and for
aiding the disassembly of MSP430 binaries (as all binary and symbol
table formats are still usable in this mode).
.IP "\fBuif\fR"
Connect to an eZ430-F2013 or a FET430UIF device. The device argument
should be the filename of the appropriate tty device. The TI serial
converter chips on these devices are supported by newer versions of the
Linux kernel, and should appear as /dev/tty\fIXX\fR when attached.

USB connection is not supported for this driver.
.IP "\fBuif-bsl\fR"
Connect to the bootloader on a FET430UIF device. These devices contain
MSP430F419 chips. By sending a special command sequence, you can obtain
access to the bootloader and inspect memory on the MSP430F419 in the
programming device itself.

Currently, only memory inspection is supported. CPU control via the
bootloader is not possible. Memory erase and write is possible, but is
currently not implemented, for lack of ability to test it. If implemented,
this would allow firmware updates to FET430UIF devices.

USB connection is not supported for this driver.
.IP "\fBflash-bsl\fR"
Connect to the built-in bootloader in MSP430 devices with flash bootloader
memory. Devices with ROM bootloaders require another driver. Currently,
this driver must mass-erase the device in order to gain access. Read,
write, and erase operations are supported.

USB connection is not supported for this driver. Connection is via serial
port, and bootloader entry is accomplished via the RTS and DTR lines.
Connect RTS to the device's TEST pin and DTR to the device's RST pin.
Use an appropriate serial level-shifter to make the connection, if necessary.
If connecting to a device with non-multiplexed JTAG pins, connect RTS to
the device's TCK pin via an inverter.
.SH COMMANDS
MSPDebug can accept commands either through an interactive prompt, or
non-interactively when specified on the command line. The supported
commands are listed below.

Commands take arguments separated by spaces. Any text string enclosed
in double-quotation marks is considered to be a single argument, even
if it contains space characters. Within a quoted string, the usual
C-style backslash substitutions can be used.

Commands can be specified by giving the first few characters of the
command name, provided that the prefix is unambiguous. Some commands
support automatic repeat. For these commands, pressing enter at the
reader prompt without typing anything will cause repeat execution.
.IP "\fB=\fR \fIexpression\fR"
Evaluate an address expression and show both its value, and the result
when the value is looked up in reverse in the current symbol
table. This result is of the form \fIsymbol\fR+\fIoffset\fR, where
\fIsymbol\fR is the name of the nearest symbol not past the address in
question.

See the section marked \fBADDRESS EXPRESSIONS\fR for more information on
the syntax of expressions.
.IP "\fBbreak\fR"
Show a list of active breakpoints. Breakpoints can be added and removed
with the \fBsetbreak\fR and \fBdelbreak\fR commands. Each breakpoint is
numbered with an integer index starting at 0.
.IP "\fBcgraph\fR \fIaddress\fR \fIlength\fR [\fIaddress\fR]"
Construct the call graph of all functions contained or referenced in
the given range of memory. If a particular function is specified, then
details for that node of the graph are displayed. Otherwise, a summary
of all nodes is displayed.

Information from the symbol table is used for hinting at the possible
locations of function starts. Any symbol which does not contain a "."
is considered a possible function start.

Callers and callee names are shown prefixed by a "*" where the
transition is a tail-call type transition.
.IP "\fBdelbreak\fR [\fIindex\fR]"
Delete one or all breakpoints. If an index is given, the selected breakpoint
is deleted. Otherwise, all breakpoints are cleared.
.IP "\fBdis\fR \fIaddress\fR [\fIlength\fR]"
Dissassemble a section of memory. Both arguments may be address
expressions. If no length is specified, a section of the default
length (64 bytes) is disassembled and shown.

If symbols are available, then all addresses used as operands are
translated into \fIsymbol\fR+\fIoffset\fR form.

This command supports repeat execution. If repeated, it continues to
disassemble another block of memory following that last printed.
.IP "\fBerase\fR [\fBall\fR|\fBsegment\fR] [\fIaddress\fR]"
Erase the device under test. With no arguments, all code memory is erased
(but not information or boot memory). With the argument "all", a mass
erase is performed (the results may depend on the state of the LOCKA
bit in the flash memory controller).

Specify "segment" and a memory address to erase an individual flash
segment.
.IP "\fBexit\fR"
Exit from MSPDebug.
.IP "\fBgdb\fR [\fIport\fR]"
Start a GDB remote stub, optionally specifying a TCP port to listen on.
If no port is given, the default port is 2000.

MSPDebug will wait for a connection on this port, and then act as a
GDB remote stub until GDB disconnects.

GDB's "monitor" command can be used to issue MSPDebug commands via the
GDB interface. Supplied commands are executed non-interactively, and
the output is sent back to be displayed in GDB.
.IP "\fBhelp\fR [\fIcommand\fR]"
Show a brief listing of available commands. If an argument is
specified, show the syntax for the given command. The help text shown
when no argument is given is also shown when MSPDebug starts up.
.IP "\fBhexout\fR \fIaddress\fR \fIlength\fR \fIfilename\fR"
Read the specified section of the device memory and save it to an
Intel HEX file. The address and length arguments may both be address
expressions.

If the specified file already exists, then it will be overwritten. If
you need to dump memory from several disjoint memory regions, you can
do this by saving each section to a separate file. The resulting files
can then be concatenated together to form a single valid HEX file.
.IP "\fBisearch\fR \fIaddress\fR \fIlength\fR [\fIoptions\fR ...]"
Search over the given range for an instruction which matches the specified
search criteria. The search may be narrowed by specifying one or more of
the following terms:
.RS
.IP "\fBopcode\fR \fIopcode\fR"
Match the specified opcode. Byte/word specifiers are not recognised, as
they are specified with other options.
.IP "\fBbyte\fR"
Match only byte operations.
.IP "\fBword\fR"
Match only word operations.
.IP "\fBaword\fR"
Match only address-word (20-bit) operations.
.IP "\fBjump\fR"
Match only jump instructions (conditional and unconditional jumps, but
not instructions such as BR which load the program counter explicitly).
.IP "\fBsingle\fR"
Match only single-operand instructions.
.IP "\fBdouble\fR"
Match only double-operand instructions.
.IP "\fBnoarg\fR"
Match only instructions with no arguments.
.IP "\fBsrc\fR \fIaddress\fR"
Match instructions with the specified value in the source operand. The value
may be given as an address expression. Specifying this option implies matching
of only double-operand instructions.
.IP "\fBdst\fR \fIaddress\fR"
Match instructions with the specified value in the destination
operand. This option implies that no-argument instructions are not
matched.
.IP "\fBsrcreg\fR \fIregister\fR"
Match instructions using the specified register in the source operand. This
option implies matching of only double-operand instructions.
.IP "\fBdstreg\fR \fIregister\fR"
Match instructions using the specified register in the destination operand.
This option implies that no-argument instructions are not matched.
.IP "\fBsrcmode\fR \fImode\fR"
Match instructions using the specified mode in the source operand. See
below for a list of modes recognised. This option implies matching of
only double-operand instructions.
.IP "\fBdstmode\fR \fImode\fR"
Match instructions using the specified mode in the destination operand. See
below for a list of modes. This option implies that no-argument instructions
are not matched.
.RE
For single-operand instructions, the operand is considered to be the
destination operand.

The seven addressing modes used by the MSP430 are represented by single
characters, and are listed here:
.RS
.IP "\fBR\fR"
Register mode.
.IP "\fBI\fR"
Indexed mode.
.IP "\fBS\fR"
Symbolic mode.
.IP "\fB&\fR"
Absolute mode.
.IP "\fB@\fR"
Register-indirect mode.
.IP "\fB+\fR"
Register-indirect mode with auto-increment.
.IP "\fB#\fR"
Immediate mode.
.RE
.IP "\fBload\fR \fIfilename\fR"
Program the device under test using the binary file supplied. This
command is like \fBprog\fR, but it does not load symbols or erase
the device before programming.

The CPU is reset and halted before and after programming.
.IP "\fBlocka\fR [\fBset\fR|\fBclear\fR]"
Show or change the status of the LOCKA bit in the chip's memory
controller. The LOCKA bit is set on POR and acts as a write-protect bit
for info segment A. This segment contains factory-configured calibration
data, and under normal circumstances, should not be changed.

If the LOCKA bit is cleared, erasing the info A segment is possible.

The LOCKA bit also affects the behaviour of the "erase all" command. If
LOCKA is set (the default), only main memory is erased. If LOCKA is
cleared, main and information memory are both erased.
.IP "\fBmd\fR \fIaddress\fR [\fIlength\fR]"
Read the specified section of device memory and display it as a
canonical\-style hexdump. Both arguments may be address expressions. If
no length is specified, a section of the default length (64 bytes) is
shown.

The output is split into three columns. The first column shows the
starting address for the line. The second column lists the hexadecimal
values of the bytes. The final column shows the ASCII characters
corresponding to printable bytes, and . for non-printing characters.

This command supports repeat execution. If repeated, it continues to
print another block of memory following that last printed.
.IP "\fBmw\fR \fIaddress\fR \fIbytes\fR ..."
Write a sequence of bytes at the given memory address. The address given
may be an address expression. Bytes values are two-digit hexadecimal
numbers separated by spaces.

Unless used in the simulation mode, this command can only be used for
programming flash memory.
.IP "\fBopt\fR [\fIname\fR] [\fIvalue\fR]"
Query, set or list option variables. MSPDebug's behaviour can be configured
using option variables, described below in the section \fBOPTIONS\fR.

Option variables may be of three types: boolean, numeric or text. Numeric
values may be specified as address expressions.

With no arguments, this command displays all available option variables.
With just an option name as its argument, it displays the current value
of that option.
.IP "\fBprog\fR \fIfilename\fR"
Erase and reprogram the device under test using the binary file
supplied. The file format will be auto-detected and may be any of
the supported file formats.

In the case of a file containing symbols, symbols will be automatically
loaded from the file into the symbol table (discarding any existing
symbols), if they are present.

The CPU is reset and halted before and after programming.
.IP "\fBread\fR \fIfilename\fR"
Read commands from the given file, line by line and process each one.
Any lines whose first non-space character is \fB#\fR are ignored. If
an error occurs while processing a command, the rest of the file is not
processed.
.IP "\fBregs\fR"
Show the current value of all CPU registers in the device under test.
.IP "\fBreset\fR"
Reset (and halt) the CPU of the device under test.
.IP "\fBrun\fR"
Start running the CPU. The interactive command prompt is blocked when
the CPU is started and the prompt will not appear again until the CPU
halts. The CPU will halt if it encounters a breakpoint, or if Ctrl\-C
is pressed by the user.

After the CPU halts, the current register values are shown as well as
a disassembly of the first few instructions at the address selected
by the program counter.
.IP "\fBset\fR \fIregister\fR \fIvalue\fR"
Alter the value of a register. Registers are specified as numbers from
0 through 15. Any leading non-numeric characters are ignored (so a
register may be specified as, for example, "R12"). The value argument
is an address expression.
.IP "\fBsetbreak\fR \fIaddress\fR [\fIindex\fR]"
Add a new breakpoint. The breakpoint location is an address expression. An
optional index may be specified, indicating that this new breakpoint should
overwrite an existing slot. If no index is specified, then the breakpoint
will be stored in the next unused slot.
.IP "\fBstep\fR [\fIcount\fR]"
Step the CPU through one or more instructions. After stepping, the new
register values are displayed, as well as a disassembly of the
instructions at the address selected by the program counter.

An optional count can be specified to step multiple times. If no
argument is given, the CPU steps once. This command supports repeat
execution.
.IP "\fBsym clear\fR"
Clear the symbol table, deleting all symbols.
.IP "\fBsym set\fR \fIname\fR \fIvalue\fR"
Set or alter the value of a symbol. The value given may be an address
expression.
.IP "\fBsym del\fR \fIname\fR"
Delete the given symbol from the symbol table.
.IP "\fBsym import\fR \fIfilename\fR"
Load symbols from the specified file and add them to the symbol table.
The file format will be auto-detected and may be either ELF32 or a
BSD-style symbol listing (like the output from \fBnm\fR(1)).

Symbols can be combined from many sources, as the syms command adds
to the existing symbol table without discarding existing symbols.
.IP "\fBsym import+\fR \fIfilename\fR"
This command is similar to \fBsym import\fR, except that the symbol table
is not cleared first. By using this command, symbols from multiple
sources can be combined.
.IP "\fBsym export\fR \fIfilename\fR"
Save all symbols currently defined to the given file. The symbols are
saved as a BSD-style symbol table. Note that symbol types are not stored
by MSPDebug, and all symbols are saved as type \fBt\fR.
.IP "\fBsym find\fR [\fIregex\fR]"
Search for symbols. If a regular expression is given, then all symbols
matching the expression are printed. If no expression is specified, then
the entire symbol table is listed.
.IP "\fBsym rename\fR \fIregex\fR \fIstring\fR"
Rename symbols by searching for those matching the given regular
expression and substituting the given string for the matched portion. The
symbols renamed are displayed, as well as a total count of all symbols
renamed.
.SH ADDRESS EXPRESSIONS
Any command which accepts a memory address, length or register value
as an argument may be given an address expression. An address
expression consists of an algebraic combination of values.

An address value may be either a symbol name, a hex value preceeded
with the specifier "0x", a decimal value preceeded with the specifier
"0d", or a number in the default input radix (without a specifier). See
the option \fBiradix\fR for more information.

The operators recognised are the usual algebraic operators: \fB+\fR, \fB-\fR,
\fB*\fR, \fB/\fR, \fB%\fR, \fB(\fR and \fB)\fR. Operator precedence is the
same as in C-like languages, and the \fB-\fR operator may be used as a
unary negation operator.

The following are all valid examples of address expressions:

.B 2+2
.br
.B table_start + (elem_size + elem_pad)*4
.br
.B main+0x3f
.br
.B __bss_end-__bss_start
.SH SEE ALSO
\fBnm\fR(1), \fBgdb\fR(1), \fBobjcopy\fR(1)
.SH OPTIONS
MSPDebug's behaviour can be configured via the following variables:
.IP "\fBcolor\fR (boolean)"
If true, MSPDebug will colorize debugging output.
.IP "\fBgdb_loop\fR (boolean)"
Automatically restart the GDB server after disconnection. If this
option is set, then the GDB server keeps running until an error occurs,
or the user interrupts with Ctrl+C.
.IP "\fBiradix\fR (numeric)"
Default input radix for address expressions. For address values with
no radix specifier, this value gives the input radix, which is
10 (decimal) by default.
.IP "\fBquiet\fR (boolean)"
If set, MSPDebug will supress most of its debug-related output. This option
defaults to false, but can be set true on start-up using the \fB-q\fR
command-line option.
.SH BUGS
If you find any bugs, you should report them to the author at
daniel@tortek.co.nz. It would help if you could include a transcript
of an MSPDebug session illustrating the program, as well as any
relevant binaries or other files. Below, known bugs in the current
version of MSPDebug are described.

When using the GDB remote stub in simulation and an IO read request
occurs, any request to interrupt from GDB will not be acknowledged
until the IO request is either completed or aborted.
.SH COPYRIGHT
Copyright (C) 2009, 2010 Daniel Beer <daniel@tortek.co.nz>

MSPDebug is free software, distributed under the terms of the GNU
General Public license (version 2 or later). See the file COPYING
included with the source code for more details.
