#!/usr/bin/env python3
# Print a _diff bitmap to screen, highlighting red pixels
from PIL import Image
from sys import argv
img = Image.open(argv[1])
gr = img.convert('L')
assert img.size == gr.size
assert 3 <= len(img.getpixel((0, 0))) <= 4
red = (255, 0, 0) if len(img.getpixel((0, 0))) == 3 else (255, 255, 0, 0)
w, h = img.size
# Palette; revert for mostly white images (smaller utf-8 output)
CHR = [' ', '░', '▒', '▓', '█'][::-1] # https://en.wikipedia.org/wiki/Block_Elements
print(f'block palette: {"".join(CHR)}')
CHR = [' ', '.', ':', '-', '=', '+', '*', '#', '%', '8', '@'][::-1]
print(f'ascii palette: {"".join(CHR)}')
r = (len(CHR) - 1) / 255. # map 0..255 to indices in CHR
RED = 'X' # or ® or ⭕ https://www.compart.com/en/unicode/U+2B55
m = [[CHR[0] for _ in range(w)] for _ in range(h)]
for y in range(h):
    for x in range(w):
        px = gr.getpixel((x, y))
        m[y][x] = RED if img.getpixel((x, y)) == red else CHR[int(px * r)]
for i in m:
    print(''.join(i))
