from typing import Any, ClassVar, Dict, List, Tuple

from typing import overload
import mrpt.pymrpt.mrpt.containers
import mrpt.pymrpt.mrpt.poses
import mrpt.pymrpt.mrpt.rtti
import mrpt.pymrpt.mrpt.serialization
MATRIX_FORMAT_ENG: TMatrixTextFileFormat
MATRIX_FORMAT_FIXED: TMatrixTextFileFormat
MATRIX_FORMAT_INT: TMatrixTextFileFormat
UNINITIALIZED_MATRIX: TConstructorFlags_Matrices
UNINITIALIZED_QUATERNION: TConstructorFlags_Quaternions
rkLeastSquares: TRobustKernelType
rkPseudoHuber: TRobustKernelType

class CAtan2LookUpTable:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xmin: float, xmax: float, ymin: float, ymax: float, resolution: float) -> None: ...
    @overload
    def __init__(self, arg0: CAtan2LookUpTable) -> None: ...
    @overload
    def atan2(self, y: float, x: float, out_atan2: float) -> bool: ...
    @overload
    def atan2(y, x) -> Any: ...
    def atan2ByIndex(self, iy: int, ix: int, out_atan2: float) -> bool: ...
    @overload
    def getResolution(self) -> float: ...
    @overload
    def getResolution() -> double: ...
    @overload
    def getSizeX(self) -> int: ...
    @overload
    def getSizeX() -> size_t: ...
    @overload
    def getSizeY(self) -> int: ...
    @overload
    def getSizeY() -> size_t: ...
    @overload
    def getXMax(self) -> float: ...
    @overload
    def getXMax() -> double: ...
    @overload
    def getXMin(self) -> float: ...
    @overload
    def getXMin() -> double: ...
    @overload
    def getYMax(self) -> float: ...
    @overload
    def getYMax() -> double: ...
    @overload
    def getYMin(self) -> float: ...
    @overload
    def getYMin() -> double: ...
    def resize(self, xmin: float, xmax: float, ymin: float, ymax: float, resolution: float) -> None: ...

class CAtan2LookUpTableMultiRes:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, lst_resolutions2extensions: Dict[float,float]) -> None: ...
    @overload
    def __init__(self, arg0: CAtan2LookUpTableMultiRes) -> None: ...
    def assign(self) -> CAtan2LookUpTableMultiRes: ...
    @overload
    def atan2(self, y: float, x: float, out_atan2: float) -> bool: ...
    @overload
    def atan2(y, x) -> Any: ...
    def resize(self, lst_resolutions2extensions: Dict[float,float]) -> None: ...

class CHistogram:
    @overload
    def __init__(self, min: float, max: float, nBins: int) -> None: ...
    @overload
    def __init__(self, arg0: CHistogram) -> None: ...
    def add(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CHistogram: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def createWithFixedWidth(self, min: float, max: float, binWidth: float) -> CHistogram: ...
    @overload
    def getBinCount(self, index: int) -> int: ...
    @overload
    def getBinCount(size_t) -> size_t: ...
    @overload
    def getBinRatio(self, index: int) -> float: ...
    @overload
    def getBinRatio(size_t) -> double: ...

class CMatrixB(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixB) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixB) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixB: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CMatrixD(mrpt.pymrpt.mrpt.serialization.CSerializable, CMatrixDynamic_double_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_double_t) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_float_t) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixD) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixD) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, other: CMatrixDynamic_float_t) -> CMatrixD: ...
    @overload
    def assign(self, other: CMatrixD) -> CMatrixD: ...
    @overload
    def assign(self) -> CMatrixD: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CMatrixDynamic_double_t:
    @overload
    def __init__(self, arg0: CMatrixDynamic_double_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_double_t, cropRowCount: int, cropColCount: int) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, m: CMatrixDynamic_double_t) -> CMatrixDynamic_double_t: ...
    @overload
    def assign(self, m: CMatrixDynamic_float_t) -> CMatrixDynamic_double_t: ...
    @overload
    def assign(self, m: CMatrixFixed_double_3UL_3UL_t) -> CMatrixDynamic_double_t: ...
    @overload
    def assign(self, m: CMatrixDynamic_double_t) -> CMatrixDynamic_double_t: ...
    def cast_double(self) -> CMatrixDynamic_double_t: ...
    def cast_float(self) -> CMatrixDynamic_float_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def derived(self) -> CMatrixDynamic_double_t: ...
    def inMatlabFormat(self) -> str: ...
    def llt_solve(self, *args, **kwargs) -> Any: ...
    def lu_solve(self, *args, **kwargs) -> Any: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def resize(self, vectorLen: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setFromMatrixLike(self, m: CMatrixDynamic_float_t) -> None: ...
    @overload
    def setFromMatrixLike(constclassmrpt) -> void: ...
    @overload
    def setFromMatrixLike(self, m: CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    @overload
    def swap(self, o: CMatrixDynamic_double_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def to_list(self) -> list: ...
    def __call__(self, row: int, col: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixDynamic_float_t:
    @overload
    def __init__(self, arg0: CMatrixDynamic_float_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_float_t, cropRowCount: int, cropColCount: int) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, m: CMatrixDynamic_float_t) -> CMatrixDynamic_float_t: ...
    @overload
    def assign(self, m) -> CMatrixDynamic_float_t: ...
    @overload
    def assign(self, m: CMatrixDynamic_float_t) -> CMatrixDynamic_float_t: ...
    def cast_double(self, *args, **kwargs) -> Any: ...
    def cast_float(self) -> CMatrixDynamic_float_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def derived(self) -> CMatrixDynamic_float_t: ...
    def inMatlabFormat(self) -> str: ...
    def llt_solve(self, *args, **kwargs) -> Any: ...
    def lu_solve(self, *args, **kwargs) -> Any: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def resize(self, vectorLen: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setFromMatrixLike(self, m) -> None: ...
    @overload
    def setFromMatrixLike(constclassmrpt) -> void: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    @overload
    def swap(self, o: CMatrixDynamic_float_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def to_list(self) -> list: ...
    def __call__(self, row: int, col: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixDynamic_unsigned_char_t:
    @overload
    def __init__(self, arg0: CMatrixDynamic_unsigned_char_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_unsigned_char_t, cropRowCount: int, cropColCount: int) -> None: ...
    @overload
    def assign(self, m: CMatrixDynamic_unsigned_char_t) -> CMatrixDynamic_unsigned_char_t: ...
    @overload
    def assign(self, m: CMatrixDynamic_unsigned_char_t) -> CMatrixDynamic_unsigned_char_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> int: ...
    def derived(self) -> CMatrixDynamic_unsigned_char_t: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def resize(self, vectorLen: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    @overload
    def swap(self, o: CMatrixDynamic_unsigned_char_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def __call__(self, row: int, col: int) -> int: ...
    def __getitem__(self, ith: int) -> int: ...

class CMatrixDynamic_unsigned_short_t:
    @overload
    def __init__(self, arg0: CMatrixDynamic_unsigned_short_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_unsigned_short_t, cropRowCount: int, cropColCount: int) -> None: ...
    @overload
    def assign(self, m: CMatrixDynamic_unsigned_short_t) -> CMatrixDynamic_unsigned_short_t: ...
    @overload
    def assign(self, m: CMatrixDynamic_unsigned_short_t) -> CMatrixDynamic_unsigned_short_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> int: ...
    def derived(self) -> CMatrixDynamic_unsigned_short_t: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def resize(self, vectorLen: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    @overload
    def swap(self, o: CMatrixDynamic_unsigned_short_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def __call__(self, row: int, col: int) -> int: ...
    def __getitem__(self, ith: int) -> int: ...

class CMatrixF(mrpt.pymrpt.mrpt.serialization.CSerializable, CMatrixDynamic_float_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, row: int, col: int) -> None: ...
    @overload
    def __init__(self, m: CMatrixDynamic_float_t) -> None: ...
    @overload
    def __init__(self, m) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixF) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixF) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def assign(self, m: CMatrixF) -> CMatrixF: ...
    @overload
    def assign(self, m: CMatrixDynamic_float_t) -> CMatrixF: ...
    @overload
    def assign(self) -> CMatrixF: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...

class CMatrixFixed_double_12UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_12UL_1UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_12UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_12UL_1UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_2UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_2UL_1UL_t) -> None: ...
    def assign(self) -> CMatrixFixed_double_2UL_1UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_2UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_2UL_1UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_2UL_2UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_2UL_2UL_t) -> None: ...
    def assign(self) -> CMatrixFixed_double_2UL_2UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_2UL_2UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_2UL_2UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_3UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_3UL_1UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_double_3UL_1UL_t: ...
    def cast_float(self, *args, **kwargs) -> Any: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_double_3UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_3UL_1UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_double_3UL_3UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_3UL_3UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_double_3UL_3UL_t: ...
    def cast_float(self, *args, **kwargs) -> Any: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_double_3UL_3UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_3UL_3UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_double_3UL_4UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_3UL_4UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_3UL_4UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_3UL_4UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_3UL_6UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_3UL_6UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_3UL_6UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_3UL_6UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_4UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_4UL_1UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_double_4UL_1UL_t: ...
    def cast_float(self, *args, **kwargs) -> Any: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_double_4UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_4UL_1UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_double_4UL_3UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_4UL_3UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_4UL_3UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_4UL_3UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_4UL_4UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_4UL_4UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_double_4UL_4UL_t: ...
    def cast_float(self, *args, **kwargs) -> Any: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_double_4UL_4UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_4UL_4UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_double_6UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_6UL_1UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_6UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_6UL_1UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_6UL_6UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_6UL_6UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_double_6UL_6UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_double_6UL_6UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_6UL_6UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_double_7UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_7UL_1UL_t) -> None: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_7UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_7UL_1UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_double_7UL_7UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_double_7UL_7UL_t) -> None: ...
    def assign(self) -> CMatrixFixed_double_7UL_7UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_7UL_7UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_7UL_7UL_t) -> None: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...

class CMatrixFixed_float_3UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_float_3UL_1UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_float_3UL_1UL_t: ...
    def cast_float(self) -> CMatrixFixed_float_3UL_1UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_float_3UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_float_3UL_1UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    @overload
    def __getitem__(self, i: int) -> float: ...
    @overload
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_float_3UL_3UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def cast_float(self) -> CMatrixFixed_float_3UL_3UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_float_3UL_3UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_float_3UL_3UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_float_4UL_1UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_float_4UL_1UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_float_4UL_1UL_t: ...
    def cast_float(self) -> CMatrixFixed_float_4UL_1UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_float_4UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_float_4UL_1UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CMatrixFixed_float_4UL_4UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: float) -> None: ...
    @overload
    def __init__(self, rows: int, cols: int) -> None: ...
    @overload
    def __init__(self, arg0: CMatrixFixed_float_4UL_4UL_t) -> None: ...
    @overload
    def __init__(self, arg0: list) -> None: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def Zero(self, *args, **kwargs) -> Any: ...
    def assign(self) -> CMatrixFixed_float_4UL_4UL_t: ...
    def cast_float(self) -> CMatrixFixed_float_4UL_4UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def data(self) -> float: ...
    def inMatlabFormat(self) -> str: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def size(self) -> tuple: ...
    def sum_At(self, A: CMatrixFixed_float_4UL_4UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_float_4UL_4UL_t) -> None: ...
    def to_list(self) -> list: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __setitem__(self, arg0: tuple, arg1: float) -> None: ...

class CPolygon(mrpt.pymrpt.mrpt.serialization.CSerializable, TPolygon2D):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CPolygon) -> None: ...
    @overload
    def __init__(self, arg0: CPolygon) -> None: ...
    def AddVertex(self, x: float, y: float) -> None: ...
    @overload
    def Clear(self) -> None: ...
    @overload
    def Clear() -> void: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    @overload
    def GetVertex_x(self, i: int) -> float: ...
    @overload
    def GetVertex_x(size_t) -> double: ...
    @overload
    def GetVertex_y(self, i: int) -> float: ...
    @overload
    def GetVertex_y(size_t) -> double: ...
    def PointIntoPolygon(self, x: float, y: float) -> bool: ...
    def assign(self) -> CPolygon: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def setAllVertices(self, nVertices: int, xs: float, ys: float) -> None: ...
    @overload
    def setAllVertices(self, nVertices: int, xs: float, ys: float) -> None: ...
    @overload
    def verticesCount(self) -> int: ...
    @overload
    def verticesCount() -> size_t: ...

class CProbabilityDensityFunction_mrpt_poses_CPoint2D_2UL_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: CProbabilityDensityFunction_mrpt_poses_CPoint2D_2UL_t) -> None: ...
    def assign(self) -> CProbabilityDensityFunction_mrpt_poses_CPoint2D_2UL_t: ...
    @overload
    def drawSingleSample(self, outPart) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def getCovariance(self, cov) -> None: ...
    @overload
    def getCovariance(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    def getCovarianceDynAndMean(self, cov, mean_point) -> None: ...
    @overload
    def getCovarianceEntropy(self) -> float: ...
    @overload
    def getCovarianceEntropy() -> double: ...
    def getInformationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_point) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMeanVal(self, *args, **kwargs) -> Any: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CProbabilityDensityFunction_mrpt_poses_CPoint3D_3UL_t:
    @overload
    def __init__(self, arg0: CProbabilityDensityFunction_mrpt_poses_CPoint3D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CProbabilityDensityFunction_mrpt_poses_CPoint3D_3UL_t: ...
    @overload
    def drawSingleSample(self, outPart) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def getCovariance(self, cov) -> None: ...
    @overload
    def getCovariance(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    def getCovarianceDynAndMean(self, cov, mean_point) -> None: ...
    @overload
    def getCovarianceEntropy(self) -> float: ...
    @overload
    def getCovarianceEntropy() -> double: ...
    def getInformationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_point) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMeanVal(self, *args, **kwargs) -> Any: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CProbabilityDensityFunction_mrpt_poses_CPose2D_3UL_t:
    @overload
    def __init__(self, arg0: CProbabilityDensityFunction_mrpt_poses_CPose2D_3UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CProbabilityDensityFunction_mrpt_poses_CPose2D_3UL_t: ...
    @overload
    def drawSingleSample(self, outPart: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def getCovariance(self, cov) -> None: ...
    @overload
    def getCovariance(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    def getCovarianceDynAndMean(self, cov, mean_point: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def getCovarianceEntropy(self) -> float: ...
    @overload
    def getCovarianceEntropy() -> double: ...
    def getInformationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_point: mrpt.pymrpt.mrpt.poses.CPose2D) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMeanVal(self) -> mrpt.pymrpt.mrpt.poses.CPose2D: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CProbabilityDensityFunction_mrpt_poses_CPose3DQuat_7UL_t:
    @overload
    def __init__(self, arg0: CProbabilityDensityFunction_mrpt_poses_CPose3DQuat_7UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CProbabilityDensityFunction_mrpt_poses_CPose3DQuat_7UL_t: ...
    @overload
    def drawSingleSample(self, outPart) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def getCovariance(self, cov) -> None: ...
    @overload
    def getCovariance(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    def getCovarianceDynAndMean(self, cov, mean_point) -> None: ...
    @overload
    def getCovarianceEntropy(self) -> float: ...
    @overload
    def getCovarianceEntropy() -> double: ...
    def getInformationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_point) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMeanVal(self, *args, **kwargs) -> Any: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CProbabilityDensityFunction_mrpt_poses_CPose3D_6UL_t:
    @overload
    def __init__(self, arg0: CProbabilityDensityFunction_mrpt_poses_CPose3D_6UL_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> CProbabilityDensityFunction_mrpt_poses_CPose3D_6UL_t: ...
    @overload
    def drawSingleSample(self, outPart) -> None: ...
    @overload
    def drawSingleSample(classmrpt) -> void: ...
    @overload
    def getCovariance(self, cov) -> None: ...
    @overload
    def getCovariance(classmrpt) -> void: ...
    def getCovarianceAndMean(self, *args, **kwargs) -> Any: ...
    def getCovarianceDynAndMean(self, cov, mean_point) -> None: ...
    @overload
    def getCovarianceEntropy(self) -> float: ...
    @overload
    def getCovarianceEntropy() -> double: ...
    def getInformationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def getMean(self, mean_point) -> None: ...
    @overload
    def getMean(classmrpt) -> void: ...
    def getMeanVal(self, *args, **kwargs) -> Any: ...
    @overload
    def isInfType(self) -> bool: ...
    @overload
    def isInfType() -> bool: ...
    @overload
    def saveToTextFile(self, file: str) -> bool: ...
    @overload
    def saveToTextFile(conststd) -> bool: ...

class CQuaternion_double_t(CMatrixFixed_double_4UL_1UL_t):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, R: float, X: float, Y: float, Z: float) -> None: ...
    @overload
    def __init__(self, arg0: CQuaternion_double_t) -> None: ...
    @overload
    def assign(self) -> CQuaternion_double_t: ...
    @overload
    def assign(self) -> CMatrixFixed_double_4UL_1UL_t: ...
    def cast_float(self) -> CMatrixFixed_float_4UL_1UL_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    @overload
    def conj(self, q_out: CQuaternion_double_t) -> None: ...
    @overload
    def conj(classmrpt) -> void: ...
    @overload
    def conj(self) -> CQuaternion_double_t: ...
    def conservativeResize(self, row: int, col: int) -> None: ...
    def crossProduct(self, q1: CQuaternion_double_t, q2: CQuaternion_double_t) -> None: ...
    def data(self) -> float: ...
    @overload
    def ensurePositiveRealPart(self) -> None: ...
    @overload
    def ensurePositiveRealPart() -> void: ...
    def inverseRotatePoint(self, lx: float, ly: float, lz: float, gx: float, gy: float, gz: float) -> None: ...
    def jacobian_rodrigues_from_quat(self) -> CMatrixFixed_double_3UL_4UL_t: ...
    def loadFromRawPointer(self, data: float) -> None: ...
    @overload
    def normSqr(self) -> float: ...
    @overload
    def normSqr() -> double: ...
    @overload
    def normalize(self) -> None: ...
    @overload
    def normalize() -> void: ...
    @overload
    def r(self, r: float) -> None: ...
    @overload
    def r(constdouble) -> void: ...
    @overload
    def r(self) -> float: ...
    @overload
    def resize(self, n: int) -> None: ...
    @overload
    def resize(size_t) -> void: ...
    @overload
    def resize(self, row: int, col: int) -> None: ...
    def rotatePoint(self, lx: float, ly: float, lz: float, gx: float, gy: float, gz: float) -> None: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    def rpy(self, roll: float, pitch: float, yaw: float) -> None: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    def sum_At(self, A: CMatrixFixed_double_4UL_1UL_t) -> None: ...
    def swap(self, o: CMatrixFixed_double_4UL_1UL_t) -> None: ...
    @overload
    def w(self) -> float: ...
    @overload
    def w() -> double: ...
    @overload
    def w(self, w: float) -> None: ...
    @overload
    def w(constdouble) -> void: ...
    @overload
    def x(self, x: float) -> None: ...
    @overload
    def x(constdouble) -> void: ...
    @overload
    def x(self) -> float: ...
    @overload
    def y(self, y: float) -> None: ...
    @overload
    def y(constdouble) -> void: ...
    @overload
    def y(self) -> float: ...
    @overload
    def z(self, z: float) -> None: ...
    @overload
    def z(constdouble) -> void: ...
    @overload
    def z(self) -> float: ...
    @overload
    def __call__(self, row: int, col: int) -> float: ...
    @overload
    def __call__(self, i: int) -> float: ...
    def __getitem__(self, i: int) -> float: ...
    def __mul__(self, factor: float) -> CQuaternion_double_t: ...

class CSplineInterpolator1D(mrpt.pymrpt.mrpt.serialization.CSerializable):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wrap2pi: bool) -> None: ...
    @overload
    def __init__(self, arg0: CSplineInterpolator1D) -> None: ...
    @overload
    def __init__(self, arg0: CSplineInterpolator1D) -> None: ...
    def CreateObject(self, *args, **kwargs) -> Any: ...
    def GetRuntimeClass(self) -> mrpt.pymrpt.mrpt.rtti.TRuntimeClassId: ...
    def GetRuntimeClassIdStatic(self, *args, **kwargs) -> Any: ...
    def appendXY(self, x: float, y: float) -> None: ...
    def assign(self) -> CSplineInterpolator1D: ...
    @overload
    def clear(self) -> None: ...
    @overload
    def clear() -> void: ...
    def clone(self) -> mrpt.pymrpt.mrpt.rtti.CObject: ...
    @overload
    def getWrap2pi(self) -> bool: ...
    @overload
    def getWrap2pi() -> bool: ...
    def query(self, *args, **kwargs) -> Any: ...
    @overload
    def setWrap2pi(self, wrap: bool) -> None: ...
    @overload
    def setWrap2pi(bool) -> void: ...

class CVectorDynamic_double_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, N: int) -> None: ...
    @overload
    def __init__(self, N: int, initZero: bool) -> None: ...
    @overload
    def __init__(self, arg0: CVectorDynamic_double_t) -> None: ...
    @overload
    def assign(self, v: CMatrixFixed_double_3UL_1UL_t) -> CVectorDynamic_double_t: ...
    @overload
    def assign(self, v: CMatrixFixed_double_6UL_1UL_t) -> CVectorDynamic_double_t: ...
    @overload
    def assign(self, v: CMatrixFixed_double_7UL_1UL_t) -> CVectorDynamic_double_t: ...
    @overload
    def assign(self) -> CVectorDynamic_double_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    @overload
    def fromVectorLike(self, m: CMatrixFixed_double_3UL_1UL_t) -> None: ...
    @overload
    def fromVectorLike(self, m: CMatrixFixed_double_6UL_1UL_t) -> None: ...
    @overload
    def fromVectorLike(self, m: CMatrixFixed_double_7UL_1UL_t) -> None: ...
    def push_back(self, val: float) -> None: ...
    @overload
    def realloc(self, new_len: int) -> None: ...
    @overload
    def realloc(self, new_len: int, newElementsToZero: bool) -> None: ...
    @overload
    def realloc(size_t, bool) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(self, N: int, zeroNewElements: bool) -> None: ...
    @overload
    def resize(std, bool) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    def segmentCopy(self, start: int, LEN: int) -> CVectorDynamic_double_t: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> int: ...
    @overload
    def swap(self, o: CVectorDynamic_double_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def __call__(self, row: int, col: int) -> float: ...
    def __getitem__(self, ith: int) -> float: ...

class CVectorDynamic_float_t:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, N: int) -> None: ...
    @overload
    def __init__(self, N: int, initZero: bool) -> None: ...
    @overload
    def __init__(self, arg0: CVectorDynamic_float_t) -> None: ...
    def assign(self) -> CVectorDynamic_float_t: ...
    @overload
    def cols(self) -> int: ...
    @overload
    def cols() -> int: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def push_back(self, val: float) -> None: ...
    @overload
    def realloc(self, new_len: int) -> None: ...
    @overload
    def realloc(self, new_len: int, newElementsToZero: bool) -> None: ...
    @overload
    def realloc(size_t, bool) -> void: ...
    @overload
    def resize(self, N: int) -> None: ...
    @overload
    def resize(self, N: int, zeroNewElements: bool) -> None: ...
    @overload
    def resize(std, bool) -> void: ...
    @overload
    def rows(self) -> int: ...
    @overload
    def rows() -> int: ...
    def segmentCopy(self, start: int, LEN: int) -> CVectorDynamic_float_t: ...
    @overload
    def setSize(self, row: int, col: int) -> None: ...
    @overload
    def setSize(self, row: int, col: int, zeroNewElements: bool) -> None: ...
    @overload
    def size(self) -> int: ...
    @overload
    def size() -> int: ...
    @overload
    def swap(self, o: CVectorDynamic_float_t) -> None: ...
    @overload
    def swap(classmrpt) -> void: ...
    def __call__(self, row: int, col: int) -> float: ...
    def __getitem__(self, ith: int) -> float: ...

class LowPassFilter_IIR1:
    alpha: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: float) -> None: ...
    @overload
    def __init__(self, alpha: float, y_k_minus_1: float) -> None: ...
    @overload
    def __init__(self, arg0: LowPassFilter_IIR1) -> None: ...
    @overload
    def filter(self, x: float) -> float: ...
    @overload
    def filter(double) -> double: ...
    @overload
    def getLastOutput(self) -> float: ...
    @overload
    def getLastOutput() -> double: ...

class ModelSearch:
    def __init__(self) -> None: ...

class TBoundingBox_double_t:
    class CTOR_FLAGS:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        AllowUnordered: ClassVar[TBoundingBox_double_t.CTOR_FLAGS] = ...
        None: ClassVar[TBoundingBox_double_t.CTOR_FLAGS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    max: Any
    min: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Min, Max) -> None: ...
    @overload
    def __init__(self, Min, Max, f) -> None: ...
    @overload
    def __init__(self, arg0: TBoundingBox_double_t) -> None: ...
    def FromUnsortedPoints(self, *args, **kwargs) -> Any: ...
    def PlusMinusInfinity(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> TBoundingBox_double_t: ...
    def compose(self, pose: mrpt.pymrpt.mrpt.poses.CPose3D) -> TBoundingBox_double_t: ...
    @overload
    def containsPoint(self, p) -> bool: ...
    @overload
    def containsPoint(conststructmrpt) -> bool: ...
    def unionWith(self, b: TBoundingBox_double_t) -> TBoundingBox_double_t: ...
    @overload
    def updateWithPoint(self, p) -> None: ...
    @overload
    def updateWithPoint(conststructmrpt) -> void: ...
    @overload
    def volume(self) -> float: ...
    @overload
    def volume() -> double: ...

class TBoundingBox_float_t:
    class CTOR_FLAGS:
        __doc__: ClassVar[str] = ...  # read-only
        __members__: ClassVar[dict] = ...  # read-only
        AllowUnordered: ClassVar[TBoundingBox_float_t.CTOR_FLAGS] = ...
        None: ClassVar[TBoundingBox_float_t.CTOR_FLAGS] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __getstate__(self) -> int: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        def __setstate__(self, state: int) -> None: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    max: Any
    min: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Min, Max) -> None: ...
    @overload
    def __init__(self, Min, Max, f) -> None: ...
    @overload
    def __init__(self, arg0: TBoundingBox_float_t) -> None: ...
    def FromUnsortedPoints(self, *args, **kwargs) -> Any: ...
    def PlusMinusInfinity(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> TBoundingBox_float_t: ...
    @overload
    def containsPoint(self, p) -> bool: ...
    @overload
    def containsPoint(conststructmrpt) -> bool: ...
    def unionWith(self, b: TBoundingBox_float_t) -> TBoundingBox_float_t: ...
    @overload
    def updateWithPoint(self, p) -> None: ...
    @overload
    def updateWithPoint(conststructmrpt) -> void: ...
    @overload
    def volume(self) -> float: ...
    @overload
    def volume() -> float: ...

class TConstructorFlags_Matrices:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    UNINITIALIZED_MATRIX: ClassVar[TConstructorFlags_Matrices] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TConstructorFlags_Quaternions:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    UNINITIALIZED_QUATERNION: ClassVar[TConstructorFlags_Quaternions] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TLine2D:
    coefs: List[float[3]]
    @overload
    def __init__(self, p1, p2) -> None: ...
    @overload
    def __init__(self, s: TSegment2D) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, A: float, B: float, C: float) -> None: ...
    @overload
    def __init__(self, l: TLine3D) -> None: ...
    @overload
    def __init__(self, arg0: TLine2D) -> None: ...
    def FromCoefficientsABC(self, *args, **kwargs) -> Any: ...
    def FromTwoPoints(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> TLine2D: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def evaluatePoint(self, point) -> float: ...
    @overload
    def evaluatePoint(conststructmrpt) -> double: ...
    @overload
    def generate3DObject(self, l: TLine3D) -> None: ...
    @overload
    def generate3DObject(structmrpt) -> void: ...
    @overload
    def getAsPose2D(self, outPose: TPose2D) -> None: ...
    @overload
    def getAsPose2D(structmrpt) -> void: ...
    @overload
    def getAsPose2DForcingOrigin(self, origin, outPose: TPose2D) -> None: ...
    @overload
    def getAsPose2DForcingOrigin(conststructmrpt, structmrpt) -> void: ...
    @overload
    def signedDistance(self, point) -> float: ...
    @overload
    def signedDistance(conststructmrpt) -> double: ...
    @overload
    def unitarize(self) -> None: ...
    @overload
    def unitarize() -> void: ...

class TLine3D:
    director: Any
    pBase: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p1, p2) -> None: ...
    @overload
    def __init__(self, s: TSegment3D) -> None: ...
    @overload
    def __init__(self, l) -> None: ...
    @overload
    def __init__(self, arg0: TLine3D) -> None: ...
    def FromPointAndDirector(self, *args, **kwargs) -> Any: ...
    def FromTwoPoints(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> TLine3D: ...
    def closestPointTo(self, *args, **kwargs) -> Any: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def generate2DObject(self, l) -> None: ...
    @overload
    def generate2DObject(structmrpt) -> void: ...
    def getDirectorVector(self, *args, **kwargs) -> Any: ...
    @overload
    def unitarize(self) -> None: ...
    @overload
    def unitarize() -> void: ...

class TMatrixTextFileFormat:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    MATRIX_FORMAT_ENG: ClassVar[TMatrixTextFileFormat] = ...
    MATRIX_FORMAT_FIXED: ClassVar[TMatrixTextFileFormat] = ...
    MATRIX_FORMAT_INT: ClassVar[TMatrixTextFileFormat] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TObject2D:
    data: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TObject2D) -> None: ...
    def asString(self) -> str: ...
    def assign(self) -> TObject2D: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def generate3DObject(self) -> TObject3D: ...
    @overload
    def getAs(self) -> TSegment2D: ...
    @overload
    def getAs(self) -> TLine2D: ...
    @overload
    def getAs(self) -> TPolygon2D: ...
    @overload
    def getLine(self, out: TLine2D) -> bool: ...
    @overload
    def getLine(structmrpt) -> bool: ...
    @overload
    def getPoint(self, out) -> bool: ...
    @overload
    def getPoint(structmrpt) -> bool: ...
    @overload
    def getPolygon(self, out: TPolygon2D) -> bool: ...
    @overload
    def getPolygon(classmrpt) -> bool: ...
    @overload
    def getSegment(self, out: TSegment2D) -> bool: ...
    @overload
    def getSegment(structmrpt) -> bool: ...
    @overload
    def isLine(self) -> bool: ...
    @overload
    def isLine() -> bool: ...
    @overload
    def isPoint(self) -> bool: ...
    @overload
    def isPoint() -> bool: ...
    @overload
    def isPolygon(self) -> bool: ...
    @overload
    def isPolygon() -> bool: ...
    @overload
    def isSegment(self) -> bool: ...
    @overload
    def isSegment() -> bool: ...

class TObject3D:
    data: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TObject3D) -> None: ...
    def asString(self) -> str: ...
    def assign(self) -> TObject3D: ...
    @overload
    def empty(self) -> bool: ...
    @overload
    def empty() -> bool: ...
    def generate2DObject(self, *args, **kwargs) -> Any: ...
    @overload
    def getAs(self) -> TSegment3D: ...
    @overload
    def getAs(self) -> TLine3D: ...
    @overload
    def getAs(self) -> TPolygon3D: ...
    @overload
    def getAs(self) -> TPlane: ...
    @overload
    def getLine(self, out: TLine3D) -> bool: ...
    @overload
    def getLine(structmrpt) -> bool: ...
    @overload
    def getPlane(self, out: TPlane) -> bool: ...
    @overload
    def getPlane(structmrpt) -> bool: ...
    @overload
    def getPoint(self, out) -> bool: ...
    @overload
    def getPoint(structmrpt) -> bool: ...
    @overload
    def getPolygon(self, out: TPolygon3D) -> bool: ...
    @overload
    def getPolygon(classmrpt) -> bool: ...
    @overload
    def getSegment(self, out: TSegment3D) -> bool: ...
    @overload
    def getSegment(structmrpt) -> bool: ...
    @overload
    def isLine(self) -> bool: ...
    @overload
    def isLine() -> bool: ...
    @overload
    def isPlane(self) -> bool: ...
    @overload
    def isPlane() -> bool: ...
    @overload
    def isPoint(self) -> bool: ...
    @overload
    def isPoint() -> bool: ...
    @overload
    def isPolygon(self) -> bool: ...
    @overload
    def isPolygon() -> bool: ...
    @overload
    def isSegment(self) -> bool: ...
    @overload
    def isSegment() -> bool: ...

class TPlane:
    coefs: List[float[4]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, A: float, B: float, C: float, D: float) -> None: ...
    @overload
    def __init__(self, p1, p2, p3) -> None: ...
    @overload
    def __init__(self, p1, normal) -> None: ...
    @overload
    def __init__(self, p1, r2) -> None: ...
    @overload
    def __init__(self, r1, r2) -> None: ...
    @overload
    def __init__(self, arg0: TPlane) -> None: ...
    def From3Points(self, *args, **kwargs) -> Any: ...
    def FromPointAndLine(self, *args, **kwargs) -> Any: ...
    def FromPointAndNormal(self, *args, **kwargs) -> Any: ...
    def FromTwoLines(self, *args, **kwargs) -> Any: ...
    def asString(self) -> str: ...
    def assign(self) -> TPlane: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def contains(self, segment: TSegment3D) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def contains(self, line) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def distance(self, line) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def evaluatePoint(self, point) -> float: ...
    @overload
    def evaluatePoint(conststructmrpt) -> double: ...
    @overload
    def getAsPose3D(self, outPose: TPose3D) -> None: ...
    @overload
    def getAsPose3D(structmrpt) -> void: ...
    @overload
    def getAsPose3DForcingOrigin(self, center, pose: TPose3D) -> None: ...
    @overload
    def getAsPose3DForcingOrigin(conststructmrpt, structmrpt) -> void: ...
    @overload
    def getAsPose3DForcingOrigin(self, center) -> TPose3D: ...
    def getNormalVector(self, *args, **kwargs) -> Any: ...
    def getUnitaryNormalVector(self, *args, **kwargs) -> Any: ...
    @overload
    def signedDistance(self, point) -> float: ...
    @overload
    def signedDistance(conststructmrpt) -> double: ...
    @overload
    def unitarize(self) -> None: ...
    @overload
    def unitarize() -> void: ...

class TPoint2D_data_double_t:
    x: float
    y: float
    @overload
    def __init__(self, arg0: TPoint2D_data_double_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPoint2D_data_double_t: ...

class TPoint2D_data_float_t:
    x: float
    y: float
    @overload
    def __init__(self, arg0: TPoint2D_data_float_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPoint2D_data_float_t: ...

class TPoint2D_double_t(TPoseOrPoint, TPoint2D_data_double_t):
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xx: float, yy: float) -> None: ...
    @overload
    def __init__(self, p: TPose2D) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p: TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: TPoint2D_double_t) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def assign(self) -> TPoint2D_double_t: ...
    @overload
    def assign(self) -> TPoseOrPoint: ...
    @overload
    def assign(self) -> TPoint2D_data_double_t: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def sqrNorm(self) -> float: ...
    @overload
    def sqrNorm() -> double: ...
    def unitarize(self) -> TPoint2D_double_t: ...
    def __add__(self, p: TPoint2D_double_t) -> TPoint2D_double_t: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, p: TPoint2D_double_t) -> TPoint2D_double_t: ...
    def __imul__(self, d: float) -> TPoint2D_double_t: ...
    def __isub__(self, p: TPoint2D_double_t) -> TPoint2D_double_t: ...
    def __itruediv__(self, d: float) -> TPoint2D_double_t: ...
    def __mul__(self, d: float) -> TPoint2D_double_t: ...
    def __sub__(self, p: TPoint2D_double_t) -> TPoint2D_double_t: ...
    def __truediv__(self, d: float) -> TPoint2D_double_t: ...

class TPoint2D_float_t(TPoseOrPoint, TPoint2D_data_float_t):
    x: float
    y: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xx: float, yy: float) -> None: ...
    @overload
    def __init__(self, p: TPose2D) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p: TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: TPoint2D_float_t) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def assign(self) -> TPoint2D_float_t: ...
    @overload
    def assign(self) -> TPoseOrPoint: ...
    @overload
    def assign(self) -> TPoint2D_data_float_t: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> float: ...
    @overload
    def sqrNorm(self) -> float: ...
    @overload
    def sqrNorm() -> float: ...
    def unitarize(self) -> TPoint2D_float_t: ...
    def __add__(self, p: TPoint2D_float_t) -> TPoint2D_float_t: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, p: TPoint2D_float_t) -> TPoint2D_float_t: ...
    def __imul__(self, d: float) -> TPoint2D_float_t: ...
    def __isub__(self, p: TPoint2D_float_t) -> TPoint2D_float_t: ...
    def __itruediv__(self, d: float) -> TPoint2D_float_t: ...
    def __mul__(self, d: float) -> TPoint2D_float_t: ...
    def __sub__(self, p: TPoint2D_float_t) -> TPoint2D_float_t: ...
    def __truediv__(self, d: float) -> TPoint2D_float_t: ...

class TPoint3D_data_double_t:
    x: float
    y: float
    z: float
    @overload
    def __init__(self, arg0: TPoint3D_data_double_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPoint3D_data_double_t: ...

class TPoint3D_data_float_t:
    x: float
    y: float
    z: float
    @overload
    def __init__(self, arg0: TPoint3D_data_float_t) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPoint3D_data_float_t: ...

class TPoint3D_double_t(TPoseOrPoint, TPoint3D_data_double_t):
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xx: float, yy: float, zz: float) -> None: ...
    @overload
    def __init__(self, p: TPoint2D_double_t) -> None: ...
    @overload
    def __init__(self, p: TPose2D) -> None: ...
    @overload
    def __init__(self, p: TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: TPoint3D_double_t) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def assign(self) -> TPoint3D_double_t: ...
    @overload
    def assign(self) -> TPoseOrPoint: ...
    @overload
    def assign(self) -> TPoint3D_data_double_t: ...
    def cast(self, *args, **kwargs) -> Any: ...
    @overload
    def distanceTo(self, p: TPoint3D_double_t) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> double: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def sqrDistanceTo(self, p: TPoint3D_double_t) -> float: ...
    @overload
    def sqrDistanceTo(conststructmrpt) -> double: ...
    @overload
    def sqrNorm(self) -> float: ...
    @overload
    def sqrNorm() -> double: ...
    def unitarize(self) -> TPoint3D_double_t: ...
    def __add__(self, p: TPoint3D_double_t) -> TPoint3D_double_t: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, p: TPoint3D_double_t) -> TPoint3D_double_t: ...
    def __imul__(self, f: float) -> TPoint3D_double_t: ...
    def __isub__(self, p: TPoint3D_double_t) -> TPoint3D_double_t: ...
    def __mul__(self, d: float) -> TPoint3D_double_t: ...
    def __sub__(self, p: TPoint3D_double_t) -> TPoint3D_double_t: ...
    def __truediv__(self, d: float) -> TPoint3D_double_t: ...

class TPoint3D_float_t(TPoseOrPoint, TPoint3D_data_float_t):
    x: float
    y: float
    z: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xx: float, yy: float, zz: float) -> None: ...
    @overload
    def __init__(self, p: TPoint2D_float_t) -> None: ...
    @overload
    def __init__(self, p: TPose2D) -> None: ...
    @overload
    def __init__(self, p: TPose3D) -> None: ...
    @overload
    def __init__(self, arg0: TPoint3D_float_t) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def assign(self) -> TPoint3D_float_t: ...
    @overload
    def assign(self) -> TPoseOrPoint: ...
    @overload
    def assign(self) -> TPoint3D_data_float_t: ...
    @overload
    def distanceTo(self, p: TPoint3D_float_t) -> float: ...
    @overload
    def distanceTo(conststructmrpt) -> float: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> float: ...
    @overload
    def sqrDistanceTo(self, p: TPoint3D_float_t) -> float: ...
    @overload
    def sqrDistanceTo(conststructmrpt) -> float: ...
    @overload
    def sqrNorm(self) -> float: ...
    @overload
    def sqrNorm() -> float: ...
    def unitarize(self) -> TPoint3D_float_t: ...
    def __add__(self, p: TPoint3D_float_t) -> TPoint3D_float_t: ...
    def __getitem__(self, i: int) -> float: ...
    def __iadd__(self, p: TPoint3D_float_t) -> TPoint3D_float_t: ...
    def __imul__(self, f: float) -> TPoint3D_float_t: ...
    def __isub__(self, p: TPoint3D_float_t) -> TPoint3D_float_t: ...
    def __mul__(self, d: float) -> TPoint3D_float_t: ...
    def __sub__(self, p: TPoint3D_float_t) -> TPoint3D_float_t: ...
    def __truediv__(self, d: float) -> TPoint3D_float_t: ...

class TPointXYZIu8:
    intensity: int
    pt: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, intensity_val: int) -> None: ...

class TPointXYZRGBAf:
    A: float
    B: float
    G: float
    R: float
    pt: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, R_val: float, G_val: float, B_val: float, A_val: float) -> None: ...

class TPointXYZRGBu8:
    b: int
    g: int
    pt: Any
    r: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, R_val: int, G_val: int, B_val: int) -> None: ...

class TPointXYZfIu8:
    intensity: int
    pt: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, intensity_val: int) -> None: ...

class TPointXYZfRGBAu8:
    a: int
    b: int
    g: int
    pt: Any
    r: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, R_val: int, G_val: int, B_val: int) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, R_val: int, G_val: int, B_val: int, A_val: int) -> None: ...
    @overload
    def __init__(self, arg0: TPointXYZfRGBAu8) -> None: ...
    def assign(self) -> TPointXYZfRGBAu8: ...

class TPointXYZfRGBu8:
    b: int
    g: int
    pt: Any
    r: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float, R_val: int, G_val: int, B_val: int) -> None: ...

class TPolygon2D:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, N: int) -> None: ...
    @overload
    def __init__(self, p: TPolygon3D) -> None: ...
    @overload
    def __init__(self, arg0: TPolygon2D) -> None: ...
    def FromYAML(self, *args, **kwargs) -> Any: ...
    def asYAML(self) -> mrpt.pymrpt.mrpt.containers.yaml: ...
    def assign(self) -> TPolygon2D: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    def createRegularPolygon(self, *args, **kwargs) -> Any: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def generate3DObject(self, p: TPolygon3D) -> None: ...
    @overload
    def generate3DObject(classmrpt) -> void: ...
    def getBoundingBox(self, min_coords, max_coords) -> None: ...
    @overload
    def getCenter(self, p) -> None: ...
    @overload
    def getCenter(structmrpt) -> void: ...
    def getPlotData(self) -> Tuple[List[float],List[float]]: ...
    @overload
    def isConvex(self) -> bool: ...
    @overload
    def isConvex() -> bool: ...
    @overload
    def removeRedundantVertices(self) -> None: ...
    @overload
    def removeRedundantVertices() -> void: ...
    @overload
    def removeRepeatedVertices(self) -> None: ...
    @overload
    def removeRepeatedVertices() -> void: ...

class TPolygon3D:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, N: int) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, arg0: TPolygon3D) -> None: ...
    def FromYAML(self, *args, **kwargs) -> Any: ...
    def asYAML(self) -> mrpt.pymrpt.mrpt.containers.yaml: ...
    def assign(self) -> TPolygon3D: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    def createRegularPolygon(self, *args, **kwargs) -> Any: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def generate2DObject(self, p) -> None: ...
    @overload
    def generate2DObject(classmrpt) -> void: ...
    @overload
    def getBestFittingPlane(self, p) -> None: ...
    @overload
    def getBestFittingPlane(structmrpt) -> void: ...
    @overload
    def getCenter(self, p) -> None: ...
    @overload
    def getCenter(structmrpt) -> void: ...
    @overload
    def getPlane(self, p) -> bool: ...
    @overload
    def getPlane(structmrpt) -> bool: ...
    @overload
    def isSkew(self) -> bool: ...
    @overload
    def isSkew() -> bool: ...
    @overload
    def removeRedundantVertices(self) -> None: ...
    @overload
    def removeRedundantVertices() -> void: ...
    @overload
    def removeRepeatedVertices(self) -> None: ...
    @overload
    def removeRepeatedVertices() -> void: ...

class TPolygonWithPlane:
    inversePose: TPose3D
    plane: TPlane
    poly: TPolygon3D
    poly2D: TPolygon2D
    pose: TPose3D
    @overload
    def __init__(self, p: TPolygon3D) -> None: ...
    @overload
    def __init__(self) -> None: ...

class TPose2D(TPoseOrPoint):
    phi: float
    x: float
    y: float
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p: TPose3D) -> None: ...
    @overload
    def __init__(self, xx: float, yy: float, Phi: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TPose2D) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    def assign(self) -> TPose2D: ...
    def composePoint(self, *args, **kwargs) -> Any: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    def inverseComposePoint(self, *args, **kwargs) -> Any: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    @overload
    def normalizePhi(self) -> None: ...
    @overload
    def normalizePhi() -> void: ...
    def translation(self, *args, **kwargs) -> Any: ...
    def __add__(self, b: TPose2D) -> TPose2D: ...
    def __getitem__(self, i: int) -> float: ...
    def __sub__(self, b: TPose2D) -> TPose2D: ...

class TPose3D(TPoseOrPoint):
    pitch: float
    roll: float
    x: float
    y: float
    yaw: float
    z: float
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, p) -> None: ...
    @overload
    def __init__(self, _x: float, _y: float, _z: float, _yaw: float, _pitch: float, _roll: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TPose3D) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    def Identity(self, *args, **kwargs) -> Any: ...
    def SO3_to_yaw_pitch_roll(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    def assign(self) -> TPose3D: ...
    @overload
    def composePoint(self, l, g) -> None: ...
    @overload
    def composePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def composePose(self, other: TPose3D, result: TPose3D) -> None: ...
    @overload
    def composePose(conststructmrpt, structmrpt) -> void: ...
    def fromHomogeneousMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    def getHomogeneousMatrix(self, *args, **kwargs) -> Any: ...
    def getInverseHomogeneousMatrix(self, *args, **kwargs) -> Any: ...
    def getRotationMatrix(self, *args, **kwargs) -> Any: ...
    @overload
    def inverseComposePoint(self, g, l) -> None: ...
    @overload
    def inverseComposePoint(conststructmrpt, structmrpt) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    def translation(self, *args, **kwargs) -> Any: ...
    def __add__(self, b: TPose3D) -> TPose3D: ...
    def __getitem__(self, i: int) -> float: ...

class TPose3DQuat(TPoseOrPoint):
    qr: float
    qx: float
    qy: float
    qz: float
    x: float
    y: float
    z: float
    @overload
    def __init__(self, _x: float, _y: float, _z: float, _qr: float, _qx: float, _qy: float, _qz: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TPose3DQuat) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    def assign(self) -> TPose3DQuat: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def norm(self) -> float: ...
    @overload
    def norm() -> double: ...
    def __getitem__(self, i: int) -> float: ...

class TPoseOrPoint:
    @overload
    def __init__(self, arg0: TPoseOrPoint) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def assign(self) -> TPoseOrPoint: ...

class TRobustKernelType:
    __doc__: ClassVar[str] = ...  # read-only
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    rkLeastSquares: ClassVar[TRobustKernelType] = ...
    rkPseudoHuber: ClassVar[TRobustKernelType] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __getstate__(self) -> int: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __setstate__(self, state: int) -> None: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class TSegment2D:
    point1: Any
    point2: Any
    @overload
    def __init__(self, p1, p2) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, s) -> None: ...
    @overload
    def __init__(self, arg0: TSegment2D) -> None: ...
    def FromPoints(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TSegment2D: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def generate3DObject(self, s) -> None: ...
    @overload
    def generate3DObject(structmrpt) -> void: ...
    @overload
    def getCenter(self, p) -> None: ...
    @overload
    def getCenter(structmrpt) -> void: ...
    @overload
    def length(self) -> float: ...
    @overload
    def length() -> double: ...
    @overload
    def signedDistance(self, point) -> float: ...
    @overload
    def signedDistance(conststructmrpt) -> double: ...
    def __getitem__(self, index) -> Any: ...

class TSegment3D:
    point1: Any
    point2: Any
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p1, p2) -> None: ...
    @overload
    def __init__(self, s: TSegment2D) -> None: ...
    @overload
    def __init__(self, arg0: TSegment3D) -> None: ...
    def FromPoints(self, *args, **kwargs) -> Any: ...
    def assign(self) -> TSegment3D: ...
    @overload
    def contains(self, point) -> bool: ...
    @overload
    def contains(conststructmrpt) -> bool: ...
    @overload
    def distance(self, point) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def distance(self, segment: TSegment3D) -> float: ...
    @overload
    def distance(conststructmrpt) -> double: ...
    @overload
    def generate2DObject(self, s: TSegment2D) -> None: ...
    @overload
    def generate2DObject(structmrpt) -> void: ...
    @overload
    def getCenter(self, p) -> None: ...
    @overload
    def getCenter(structmrpt) -> void: ...
    @overload
    def length(self) -> float: ...
    @overload
    def length() -> double: ...
    def __getitem__(self, index) -> Any: ...

class TTwist2D:
    __hash__: ClassVar[None] = ...
    omega: float
    vx: float
    vy: float
    @overload
    def __init__(self, vx_: float, vy_: float, omega_: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TTwist2D) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    def assign(self) -> TTwist2D: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def rotate(self, ang: float) -> None: ...
    @overload
    def rotate(constdouble) -> void: ...
    def rotated(self, ang: float) -> TTwist2D: ...
    def __eq__(self, o: TTwist2D) -> bool: ...
    def __getitem__(self, i: int) -> float: ...
    def __imul__(self, k: float) -> None: ...
    def __mul__(self, dt: float) -> TPose2D: ...
    def __ne__(self, o: TTwist2D) -> bool: ...

class TTwist3D:
    __hash__: ClassVar[None] = ...
    vx: float
    vy: float
    vz: float
    wx: float
    wy: float
    wz: float
    @overload
    def __init__(self, vx_: float, vy_: float, vz_: float, wx_: float, wy_: float, wz_: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: TTwist3D) -> None: ...
    def FromString(self, *args, **kwargs) -> Any: ...
    @overload
    def asString(self, s: str) -> None: ...
    @overload
    def asString(std) -> void: ...
    @overload
    def asString(self) -> str: ...
    @overload
    def fromString(self, s: str) -> None: ...
    @overload
    def fromString(conststd) -> void: ...
    @overload
    def rotate(self, rot: TPose3D) -> None: ...
    @overload
    def rotate(conststructmrpt) -> void: ...
    def rotated(self, rot: TPose3D) -> TTwist3D: ...
    def __call__(self, row: int, col: int) -> float: ...
    def __eq__(self, o: TTwist3D) -> bool: ...
    def __getitem__(self, i: int) -> float: ...
    def __imul__(self, k: float) -> None: ...
    def __ne__(self, o: TTwist3D) -> bool: ...

@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_float_t, mean, stdCount: float) -> str: ...
@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_float_t, mean, stdCount: float, style: str) -> str: ...
@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_float_t, mean, stdCount: float, style: str, nEllipsePoints: int) -> str: ...
@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_double_t, mean, stdCount: float) -> str: ...
@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_double_t, mean, stdCount: float, style: str) -> str: ...
@overload
def MATLAB_plotCovariance2D(cov22: CMatrixDynamic_double_t, mean, stdCount: float, style: str, nEllipsePoints: int) -> str: ...
def RectanglesIntersection(*args, **kwargs) -> Any: ...
def angDistance(from: float, to: float) -> float: ...
@overload
def averageLogLikelihood(logLikelihoods) -> float: ...
@overload
def averageLogLikelihood(constclassmrpt) -> double: ...
@overload
def averageLogLikelihood(logWeights, logLikelihoods) -> float: ...
@overload
def averageWrap2Pi(angles) -> float: ...
@overload
def averageWrap2Pi(constclassmrpt) -> double: ...
def chi2CDF(*args, **kwargs) -> Any: ...
def chi2PDF(*args, **kwargs) -> Any: ...
@overload
def chi2inv(P: float) -> float: ...
@overload
def chi2inv(P: float, dim: int) -> float: ...
@overload
def chi2inv() -> Any: ...
@overload
def chi2inv(double, unsignedint) -> double: ...
def closestFromPointToLine(Px: float, Py: float, x1: float, y1: float, x2: float, y2: float, out_x: float, out_y: float) -> None: ...
def closestFromPointToSegment(Px: float, Py: float, x1: float, y1: float, x2: float, y2: float, out_x: float, out_y: float) -> None: ...
def createFromPoseX(p: TPose3D, r: TLine3D) -> None: ...
@overload
def createFromPoseY(p: TPose3D, r: TLine3D) -> None: ...
@overload
def createFromPoseY(conststructmrpt, structmrpt) -> void: ...
@overload
def createFromPoseY(p: TPose2D, r: TLine2D) -> None: ...
@overload
def createFromPoseY(conststructmrpt, structmrpt) -> void: ...
@overload
def createFromPoseZ(p: TPose3D, r: TLine3D) -> None: ...
@overload
def createFromPoseZ(conststructmrpt, structmrpt) -> void: ...
def createPlaneFromPoseXY(pose: TPose3D, plane: TPlane) -> None: ...
@overload
def createPlaneFromPoseXZ(pose: TPose3D, plane: TPlane) -> None: ...
@overload
def createPlaneFromPoseXZ(conststructmrpt, structmrpt) -> void: ...
@overload
def createPlaneFromPoseYZ(pose: TPose3D, plane: TPlane) -> None: ...
@overload
def createPlaneFromPoseYZ(conststructmrpt, structmrpt) -> void: ...
def cross_correlation_FFT(A: CMatrixDynamic_float_t, B: CMatrixDynamic_float_t, out_corr: CMatrixDynamic_float_t) -> None: ...
def dft2_complex(in_real: CMatrixDynamic_float_t, in_imag: CMatrixDynamic_float_t, out_real: CMatrixDynamic_float_t, out_imag: CMatrixDynamic_float_t) -> None: ...
def dft2_real(in_data: CMatrixDynamic_float_t, out_real: CMatrixDynamic_float_t, out_imag: CMatrixDynamic_float_t) -> None: ...
def distance(p1, p2) -> float: ...
def distanceBetweenPoints(x1: float, y1: float, x2: float, y2: float) -> float: ...
@overload
def factorial(n: int) -> float: ...
@overload
def factorial(unsignedint) -> double: ...
@overload
def factorial64(n: int) -> int: ...
@overload
def factorial64(unsignedint) -> uint64_t: ...
def fft_real(in_realData, out_FFT_Re, out_FFT_Im, out_FFT_Mag) -> None: ...
@overload
def fresnel_cos_integral(x: float) -> float: ...
@overload
def fresnel_cos_integral(double) -> double: ...
@overload
def fresnel_sin_integral(x: float) -> float: ...
@overload
def fresnel_sin_integral(double) -> double: ...
def generateAxisBaseFromDirection(*args, **kwargs) -> Any: ...
@overload
def generateAxisBaseFromDirectionAndAxis(vec, coord: int) -> CMatrixFixed_double_4UL_4UL_t: ...
@overload
def generateAxisBaseFromDirectionAndAxis() -> Any: ...
def getAngle(p1: TPlane, p2: TPlane) -> float: ...
@overload
def getAngleBisector(l1: TLine2D, l2: TLine2D, bis: TLine2D) -> None: ...
@overload
def getAngleBisector(l1: TLine3D, l2: TLine3D, bis: TLine3D) -> None: ...
@overload
def getEpsilon() -> float: ...
@overload
def getEpsilon() -> double: ...
@overload
def getSegmentBisector(sgm: TSegment2D, bis: TLine2D) -> None: ...
@overload
def getSegmentBisector(conststructmrpt, structmrpt) -> void: ...
@overload
def getSegmentBisector(sgm: TSegment3D, bis: TPlane) -> None: ...
@overload
def getSegmentBisector(conststructmrpt, structmrpt) -> void: ...
def homogeneousMatrixInverse(*args, **kwargs) -> Any: ...
def idft2_complex(in_real: CMatrixDynamic_float_t, in_imag: CMatrixDynamic_float_t, out_real: CMatrixDynamic_float_t, out_imag: CMatrixDynamic_float_t) -> None: ...
def idft2_real(*args, **kwargs) -> Any: ...
@overload
def interpolate2points(x: float, x0: float, y0: float, x1: float, y1: float) -> float: ...
@overload
def interpolate2points(x: float, x0: float, y0: float, x1: float, y1: float, wrap2pi: bool) -> float: ...
def intersect(s1: TSegment3D, s2: TSegment3D, obj: TObject3D) -> bool: ...
@overload
def lfresnel_cos_integral(x: float) -> float: ...
@overload
def lfresnel_cos_integral(longdouble) -> longdouble: ...
@overload
def lfresnel_sin_integral(x: float) -> float: ...
@overload
def lfresnel_sin_integral(longdouble) -> longdouble: ...
@overload
def maximum(v) -> float: ...
@overload
def maximum(constclassmrpt) -> double: ...
@overload
def mean(v) -> float: ...
@overload
def mean(constclassmrpt) -> double: ...
@overload
def minimum(v) -> float: ...
@overload
def minimum(constclassmrpt) -> double: ...
def noncentralChi2CDF(*args, **kwargs) -> Any: ...
@overload
def noncentralChi2PDF_CDF(degreesOfFreedom: int, noncentrality: float, arg: float) -> Tuple[float,float]: ...
@overload
def noncentralChi2PDF_CDF(degreesOfFreedom: int, noncentrality: float, arg: float, eps: float) -> Tuple[float,float]: ...
def normalCDF(*args, **kwargs) -> Any: ...
def normalPDF(x: float, mu: float, std: float) -> float: ...
@overload
def normalQuantile(p: float) -> float: ...
@overload
def normalQuantile(double) -> double: ...
@overload
def project2D(point, newXpose: TPose2D, newPoint) -> None: ...
@overload
def project2D(segment: TSegment2D, newXpose: TPose2D, newSegment: TSegment2D) -> None: ...
@overload
def project2D(line: TLine2D, newXpose: TPose2D, newLine: TLine2D) -> None: ...
@overload
def project2D(polygon: TPolygon2D, newXpose: TPose2D, newPolygon: TPolygon2D) -> None: ...
@overload
def project2D(constclassmrpt, conststructmrpt, classmrpt) -> void: ...
@overload
def project2D(object, newXpose: TPose2D, newObject) -> None: ...
def project3D(point, newXYpose: TPose3D, newPoint) -> None: ...
@overload
def setEpsilon(nE: float) -> None: ...
@overload
def setEpsilon(double) -> void: ...
@overload
def signedArea(p: TPolygon2D) -> float: ...
@overload
def signedArea(constclassmrpt) -> double: ...
def slerp(q0: TPose3D, q1: TPose3D, t: float, p: TPose3D) -> None: ...
def slerp_ypr(q0: TPose3D, q1: TPose3D, t: float, p: TPose3D) -> None: ...
def solve_poly2(a: float, b: float, c: float, r1: float, r2: float) -> int: ...
def solve_poly3(x: float, a: float, b: float, c: float) -> int: ...
def solve_poly4(x: float, a: float, b: float, c: float, d: float) -> int: ...
def solve_poly5(x: float, a: float, b: float, c: float, d: float, e: float) -> int: ...
@overload
def squaredDistancePointToLine(Px: float, Py: float, x1: float, y1: float, x2: float, y2: float) -> float: ...
@overload
def squaredDistancePointToLine(query, linePt1, linePt2) -> float: ...
@overload
def wrapTo2Pi(a: float) -> float: ...
@overload
def wrapTo2Pi(double) -> double: ...
def wrapTo2PiInPlace(a: float) -> None: ...
@overload
def wrapToPi(a: float) -> float: ...
@overload
def wrapToPi(double) -> double: ...
def wrapToPiInPlace(a: float) -> None: ...
