
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace std;

// return 0 if OK.
int test_matrix_parse_main(int argc,char* argv[])
{
	const char* mat1 = "[1 2 3;-3 -6 -5]";
	const char* mat2 = " [ 	  -8.2	 9.232 ; -2e+2		+6 ; 1.000  7 ] ";    // With tabs and spaces...
	const char* mat3 = "[9]";
	const char* mat4 = "[1 2 3 4 5 6 7 9 10  ; 1 2 3 4 5 6 7 8 9 10 11]";   // An invalid matrix
	const char* mat5 = "[  ]";  // Empty
	const char* mat6 = "[ -405.200 42.232 ; 1219.600    -98.696 ]";  // M1 * M2



	CMatrixDouble	M1,M2,M3, M4, M5, M6;

	cout << endl << "To load: " << mat1 << endl;
	if (! M1.fromMatlabStringFormat(mat1) ) return 1;
	cout << "Loaded: " << endl << M1 << endl;

	cout << endl << "To load: " << mat2 << endl;
	if (! M2.fromMatlabStringFormat(mat2) ) return 1;
	cout << "Loaded: " << endl << M2 << endl;

	cout << endl << "To load: " << mat3 << endl;
	if (! M3.fromMatlabStringFormat(mat3) ) return 1;
	cout << "Loaded: " << endl << M3 << endl;

	cout << endl << "To load (should be detected as wrong): " << mat4 << endl;
	if ( M4.fromMatlabStringFormat(mat4) ) return 1;
	cout << "Detected as wrong, OK" << endl;

	cout << endl << "To load: " << mat5 << endl;
	if (! M5.fromMatlabStringFormat(mat5) || size(M5,1)!=0 || size(M5,2)!=0 ) return 1;
	cout << "Loaded empty matrix, OK" << endl;

	cout << endl << "To load: " << mat6 << endl;
	if (! M6.fromMatlabStringFormat(mat6) ) return 1;
	cout << "Loaded: " << endl << M6 << endl;

	// Check correct values loaded:
	CMatrixDouble RES = M1*M2;

	double err = (M6 - M1*M2).Square().sumAll();

	if (err>1e-3) return 1;

	// Okay
	return 0;
}

