
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace std;


// return 0 if OK.
int test_matrix_ops_main(int /*argc*/,char* /*argv*/[])
{
	// Dyn. size, double.
	const double   dat_A[] = { 4, 5, 8, -2, 1, 3 };
	CMatrixDouble	A(3,2, dat_A);

	const double   dat_B[] = { 2, 6, 9, 8 };
	CMatrixDouble	B(2,2, dat_B);

	CMatrixDouble C = A*B;

	const double   dat_Cok[] = {53,64, -2,32, 29,30  };
	CMatrixDouble	C_ok(3,2, dat_Cok);

	CMatrixDouble	err = C - C_ok;
	
	if (fabs(err.sumAll())>1e-5) return 1; // Error

	// Fix. size, double.
	CMatrixFixedNumeric<double,3,2>	fA(dat_A);
	CMatrixFixedNumeric<double,2,2>	fB(dat_B);
	CMatrixFixedNumeric<double,3,2> fC, fC_ok, fErr;

	fC = fA * fB;

	fC_ok = C_ok;

	fErr = fC - CMatrixFixedNumeric<double,3,2>(C_ok);
	
	if (fabs(fErr.sumAll())>1e-5) return 1; // Error

	// serialization tests:
	{
		CMatrixD	As = A;

		CMemoryStream	membuf;
		membuf << As;
		membuf.Seek(0);
		membuf >> fA;	
		if ( fabs((CMatrixDouble(fA) - A).sumAll()) > 1e-9 ) 
			return 1; // error

		try 
		{
			// Now, if we try to de-serialize into the wrong type, we should get an exception:
			membuf.Seek(0);
			membuf >> fB;  // Wrong size!	
			return 1; // We shouldn't be here!
		}
		catch(...)
		{
			// OK
			cout << "exception occurred, as expected" << endl;
		}
	}


	// Eigenvalue decomposition test: 2x2 dynamic
	{
		const double   dat_C1[] = {  14.6271,  5.8133, 5.8133, 16.8805 };
		CMatrixDouble  C1(2,2, dat_C1);

		CMatrixDouble  C1_V(2,2), C1_D(2,2);
		C1.eigenVectors(C1_V,C1_D);

		CMatrixDouble  C1_RR = C1_V*C1_D*(~C1_V);
		C1_RR-=C1;
		if (fabs(C1_RR.sumAll())>1e-4) return 1; // Error
	}
	// Eigenvalue decomposition test: 3x3 dynamic
	{
		const double   dat_C1[] = {  8,6,1, 6,9,4, 1,4,10 };
		CMatrixDouble  C1(3,3, dat_C1);

		CMatrixDouble  C1_V(3,3), C1_D(3,3);
		C1.eigenVectors(C1_V,C1_D);

		CMatrixDouble  C1_RR = C1_V*C1_D*(~C1_V);
		C1_RR-=C1;
		if (fabs(C1_RR.sumAll())>1e-4) return 1; // Error
	}
	// Eigenvalue decomposition test: 2x2 fixed
	{
		const double   dat_C1[] = {  14.6271,  5.8133, 5.8133, 16.8805 };
		CMatrixDouble22  C1(dat_C1);

		CMatrixDouble22  C1_V, C1_D;
		C1.eigenVectors(C1_V,C1_D);

		CMatrixDouble22  C1_RR = C1_V*C1_D*(~C1_V);
		C1_RR-=C1;
		if (fabs(C1_RR.sumAll())>1e-4) return 1; // Error
	}
	// Eigenvalue decomposition test: 3x3 fixed
	{
		const double   dat_C1[] = {  8,6,1, 6,9,4, 1,4,10 };
		CMatrixDouble33  C1(dat_C1);

		CMatrixDouble33  C1_V, C1_D;
		C1.eigenVectors(C1_V,C1_D);

		CMatrixDouble33  C1_RR = C1_V*C1_D*(~C1_V);
		C1_RR-=C1;
		if (fabs(C1_RR.sumAll())>1e-4) return 1; // Error
	}

	return 0; // Ok
}

