
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace mrpt::system;
using namespace mrpt::random;
using namespace std;

// return 0 if OK.
int test_base64_main(int argc,char* argv[])
{
	for (size_t i=0;i<6;i++)
	{
		const size_t block_len = randomGenerator.drawUniform32bit() % 567;
		
		vector_byte  myData(block_len);
		for (size_t n=0;n<block_len;n++)
			myData[n] = static_cast<uint8_t>(randomGenerator.drawUniform32bit());

		std::string myStr;
		mrpt::system::encodeBase64(myData,myStr);

		vector_byte outData;
		if (!mrpt::system::decodeBase64(myStr,outData))
		{
			cerr << "Error decoding the just encoded data!!" << endl;
			return 1;
		}

		// Compare data:
		if (outData.size()!=myData.size())
		{
			cerr << "64-decoded data is not of the right length!!" << endl;
			return 1;
		}

		if (0!=mrpt::math::maximum( outData - myData ))
		{
			cerr << "64-decoded data does not match original data!!" << endl;
			return 1;
		}

	}

	return 0;
}

