
#include <mrpt/core.h>

using namespace mrpt;
using namespace mrpt::slam;
using namespace mrpt::utils;
using namespace mrpt::math;
using namespace std;

struct TRegs
{
	uint8_t		v1;
	int8_t		v2;
	uint16_t	v3;
	int16_t		v4;
	uint32_t	v5;
	int32_t		v6;
	uint64_t	v7;
	int64_t		v8;
	std::string 	v9;
};

// return 0 if OK.
int test_serialize1(int argc,char* argv[])
{
	// Reference data:
	TRegs	R;
	R.v1 = 8;
	R.v2 = -3;
	R.v3 = 781;
	R.v4 = -888;
	R.v5 =  100000;
	R.v6 = -100000;
	R.v7 =  555666777;
	R.v8 = -555666777;
	R.v9 = "an example test";

#if 0
	// Save test binary file:
	{
		CFileOutputStream	gg(argv[1]);
		gg << R.v1 << R.v2 << R.v3 << R.v4 << R.v5 << R.v6 << R.v7 << R.v8 << R.v9;
	}
#endif

	// Loaded data to compare with reference:
	TRegs	L;
	CFileInputStream	gg(argv[1]);
	gg >> L.v1 >> L.v2 >> L.v3 >> L.v4 >> L.v5 >> L.v6 >> L.v7 >> L.v8 >> L.v9;

	return  (
		R.v1==L.v1 &&
		R.v2==L.v2 &&  
		R.v3==L.v3 &&  
		R.v4==L.v4 &&  
		R.v5==L.v5 &&  
		R.v6==L.v6 &&  
		R.v7==L.v7 &&  
		R.v8==L.v8 &&  
		R.v9==L.v9 )  ? 0 : 1;
}

// return 0 if OK.
int test_serialize2()
{
	// Create a set of classes, then serialize and deserialize to test possible bugs:
	const mrpt::utils::TRuntimeClassId* lstClasses[] = {
		// Misc:
		CLASS_ID(CPose2D),
		CLASS_ID(CPose3D),
		CLASS_ID(CPoint2D),
		CLASS_ID(CPoint3D),
		// Observations:
		CLASS_ID(CObservation2DRangeScan),
		CLASS_ID(CObservation3DRangeScan),
		CLASS_ID(CObservationBearingRange),
		CLASS_ID(CObservationBatteryState),
		CLASS_ID(CObservationBeaconRanges),
		CLASS_ID(CObservationComment),
		CLASS_ID(CObservationGasSensors),
		CLASS_ID(CObservationGPS),
		CLASS_ID(CObservationImage),
		CLASS_ID(CObservationIMU),
		CLASS_ID(CObservationOdometry),
		CLASS_ID(CObservationRange),
		CLASS_ID(CObservationStereoImages)
		};

	for (size_t i=0;i<sizeof(lstClasses)/sizeof(lstClasses[0]);i++)
	{
		try
		{
			CMemoryStream  buf;
			{
				CSerializable* o = lstClasses[i]->createObject();
				buf << *o;
				delete o;
			}

			CSerializablePtr recons;
			buf.Seek(0);
			buf >> recons;
		}
		catch(std::exception &e)
		{
			cerr << "Exception during serialization test for class '"<< lstClasses[i]->className <<"':\n" << e.what() << endl;
			return 1;
		}
	}

	return 0;
}

// return 0 if OK.
int test_serialize_main(int argc,char* argv[])
{
	if (test_serialize2()) return 1;
	if (test_serialize1(argc,argv)) return 1;

	return 0;
}

