/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2010  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef reactivenav_link_pragmas_H
#define reactivenav_link_pragmas_H

#include <mrpt/utils/utils_defs.h>

// If we are building a DLL, do not link against the .lib files:
#if defined(MRPT_BUILT_AS_DLL) && defined(mrpt_reactivenav_EXPORTS) && !defined(MRPT_SKIP_AUTOINCLUDE_LIBS)
#	define MRPT_SKIP_AUTOINCLUDE_LIBS
#endif

#if (defined(_MSC_VER) || defined(__BORLANDC__))  && !defined(MRPT_SKIP_AUTOINCLUDE_LIBS)
	#if defined(_DEBUG)
		#pragma comment (lib, BOOST_JOIN( BOOST_JOIN("libmrpt-reactivenav",MRPT_VERSION_POSTFIX),"-dbg.lib"))
	#else
		#pragma comment (lib, BOOST_JOIN( BOOST_JOIN("libmrpt-reactivenav",MRPT_VERSION_POSTFIX),".lib"))
	#endif
#endif

#define _IAMINUTILSDEFS_H
#include <mrpt/reactivenav/reactivenav_impexp.h>  // DLL import/export definitions
#undef _IAMINUTILSDEFS_H


#endif
