/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/precomp_core.h>  // Only for precomp. headers, include all libmrpt-core headers. 


#include <mrpt/math/CHistogram.h>
#include <mrpt/system/os.h>

using namespace mrpt;
using namespace mrpt::math;

/*---------------------------------------------------------------
					Constructor
 ---------------------------------------------------------------*/
CHistogram::CHistogram(double min, double max, int nBins)
{
	ASSERT_(nBins>0)
	ASSERT_(max>min)

	this->min	= min;
	this->max	= max;
	bins.resize(nBins);

	clear();
}

/*---------------------------------------------------------------
						clear
 ---------------------------------------------------------------*/
void CHistogram::clear()
{
	for (unsigned int i=0;i<bins.size();i++) bins[i]=0;
	count = 0;
}

/*---------------------------------------------------------------
							add
 ---------------------------------------------------------------*/
void CHistogram::add(double x)
{
	unsigned int ind = (unsigned int )(bins.size()*((x - min) / (max - min)));

	if (ind>=0 && ((unsigned int)ind)<bins.size())
	{
		bins[ind]++;
		count++;
	}
}

/*---------------------------------------------------------------
					getBinCount
 ---------------------------------------------------------------*/
int CHistogram::getBinCount(int index)
{
	if (index<0 || ((unsigned int)index)>=bins.size())
		THROW_EXCEPTION("Index out of bounds")

	return bins[index];
}

/*---------------------------------------------------------------
					getBinRatio
 ---------------------------------------------------------------*/
double CHistogram::getBinRatio(int index)
{
	if (index<0 || ((unsigned int)index)>=bins.size())
		THROW_EXCEPTION("Index out of bounds")

	if (count)	return bins[index] / (double)count;
	else		return 0;
}
