/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2009  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef _mrpt_opengl_H
#define _mrpt_opengl_H

#include "opengl/CRenderizable.h"
#include "opengl/COpenGLScene.h"
#include "opengl/COpenGLViewport.h"

#include "opengl/CArrow.h"
#include "opengl/CAxis.h"
#include "opengl/CCamera.h"
#include "opengl/CDisk.h"
#include "opengl/CEllipsoid.h"
#include "opengl/CGridPlaneXY.h"
#include "opengl/CGridPlaneXZ.h"
#include "opengl/CMesh.h"
#include "opengl/CPointCloud.h"
#include "opengl/CPointCloudColoured.h"
#include "opengl/CSetOfLines.h"
#include "opengl/CSetOfObjects.h"
#include "opengl/CSetOfTriangles.h"
#include "opengl/CSetOfTexturedTriangles.h"
#include "opengl/CSimpleLine.h"
#include "opengl/CSphere.h"
#include "opengl/CText.h"
#include "opengl/CTexturedPlane.h"
#include "opengl/C3DSScene.h"
#include "opengl/CPlanarLaserScan.h"
#include "opengl/CAngularObservationMesh.h"
#include "opengl/CCylinder.h"
#include "opengl/CPolyhedron.h"
#include "opengl/CGeneralizedCylinder.h"
#include "opengl/COpenGLStandardObject.h"

#include "opengl/stock_objects.h"


#endif
