/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#include <mrpt/core.h>

using namespace mrpt::utils;
using namespace mrpt::vision;


// ------------------------------------------------------
//					Test
// ------------------------------------------------------
void Test_GaussWindows()
{
	//CGaussianConvolutionKernel		gaussKernel( 1.0f, true );

	CTicTac							tictac;
	CMRPTImage						img;
	CMRPTImageFloat					inImg, outImg, outImg2;

	img.loadFromFile("test_in.jpg");
	inImg = img;

	// Smoothed image:
	// ---------------------------
	tictac.Tic();

//	CImageConvolution::convolutionHorizontal( inImg, outImg, gaussKernel );
//	CImageConvolution::convolutionVertical( inImg, outImg, gaussKernel );
//	CImageConvolution::convolutionHorzVert( inImg, outImg, gaussKernel );

	CImageConvolution::computeSmoothedImage(inImg,1.0f, outImg);

	printf("Smoothed image in %.03fms\n",1000 * tictac.Tac());
	outImg.adjustImageRange(0,1);
	//outImg.saveToTextFile("test_out_smooth.txt");
	img = outImg; img.saveToFile("test_out_smoothed.bmp");

	// Gradient images:
	// ---------------------------
	tictac.Tic();

	CImageConvolution::computeGradients(inImg,1.0f,outImg,outImg2);

	printf("Gradients in %.03fms\n",1000 * tictac.Tac());
	
	outImg.adjustImageRange(0,1); img = outImg; img.saveToFile("test_out_gradients_X.bmp");
	outImg2.adjustImageRange(0,1); img = outImg2; img.saveToFile("test_out_gradients_Y.bmp");

}


int main()
{
	try
	{
		Test_GaussWindows();

		return 0;
	} catch (std::exception &e)
	{
		std::cout << "MRPT exception caught: " << e.what() << std::endl;
		return -1;
	}
	catch (...)
	{
		printf("Another exception!!");
		return -1;
	}

}

