/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef CStereoImagesTo3D_H
#define CStereoImagesTo3D_H

#include <mrpt/slam/CObservationVisualLandmarks.h>
#include <mrpt/slam/CObservationStereoImages.h>

namespace mrpt
{
	namespace vision
	{
		/** A class for processing a pair of stereo images and generateing a disparity image and/or a 3D landmarks map.
		  */
		class MRPTDLLIMPEXP CStereoImagesTo3D
		{
		protected:

		public:
			/** Constructor:
			*/
			CStereoImagesTo3D( );

			/** Destructor
			*/
			virtual ~CStereoImagesTo3D( );

			/** Process a pair of stereo images and generates a disparity image and/or a 3D landmarks map.
			 * \param in_stereoImages	The pair of images. REMEMBER that images have to be undistorted previously to this call!
			*/
			void  stereo( mrpt::slam::CObservationStereoImages		&in_stereoImages,
									mrpt::slam::CObservationVisualLandmarks	&out_landmarks );


		};	// End of class

	} // End of NS
} // End of NS

#endif
