/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */

#ifndef opengl_CCamera_H
#define opengl_CCamera_H

#include <mrpt/opengl/CRenderizable.h>

namespace mrpt
{
	namespace opengl
	{
		class COpenGLViewport;
		class CCamera;

		// This must be added to any CSerializable derived class:
		DEFINE_SERIALIZABLE_PRE_CUSTOM_BASE( CCamera, CRenderizable )

		/** A smart pointer (see opengl::CRenderizablePtr) */
		/*struct CCameraPtr : public CRenderizablePtr
		{
			template <class R> CCameraPtr(R *p) : CRenderizablePtr(p) {  }
			CCamera* operator ->(void) { return reinterpret_cast<CCamera*>( CRenderizablePtr::operator ->() ); }	// reinterpret_cast is because class forward declaration only
		};		*/

		/** A camera: if added to a scene, the viewpoint defined by this camera will be used instead of the camera parameters set in COpenGLViewport::m_camera.
		  *  A camera can be defined to provide a projective or orthogonal view of the world by setting the member CCamera::m_projectiveModel.
		  *  \sa opengl::COpenGLScene
		  */
		class MRPTDLLIMPEXP CCamera : public CRenderizable
		{
			friend class COpenGLViewport;

			DEFINE_SERIALIZABLE( CCamera )
		public:
			float	m_pointingX,m_pointingY,m_pointingZ,
					m_distanceZoom,
					m_azimuthDeg,m_elevationDeg;

			/** If set to true (default), camera model is projective, otherwise, it's orthogonal.
			  */
			bool	m_projectiveModel;

			/** Field-of-View in degs, only when projectiveModel=true (default=30 deg).
			  */
			float	m_projectiveFOVdeg;

			/** Class factory  */
			static CCameraPtr Create()
			{
				return CCameraPtr( new CCamera );
			}

			/** Render does nothing here.
			  */
			void  render() {  }

		private:
			/** Constructor
			  */
			CCamera();

			/** Private, virtual destructor: only can be deleted from smart pointers */
			virtual ~CCamera() { }

		};

	} // end namespace opengl

} // End of namespace


#endif
