/* +---------------------------------------------------------------------------+
   |          The Mobile Robot Programming Toolkit (MRPT) C++ library          |
   |                                                                           |
   |                   http://mrpt.sourceforge.net/                            |
   |                                                                           |
   |   Copyright (C) 2005-2008  University of Malaga                           |
   |                                                                           |
   |    This software was written by the Machine Perception and Intelligent    |
   |      Robotics Lab, University of Malaga (Spain).                          |
   |    Contact: Jose-Luis Blanco  <jlblanco@ctima.uma.es>                     |
   |                                                                           |
   |  This file is part of the MRPT project.                                   |
   |                                                                           |
   |     MRPT is free software: you can redistribute it and/or modify          |
   |     it under the terms of the GNU General Public License as published by  |
   |     the Free Software Foundation, either version 3 of the License, or     |
   |     (at your option) any later version.                                   |
   |                                                                           |
   |   MRPT is distributed in the hope that it will be useful,                 |
   |     but WITHOUT ANY WARRANTY; without even the implied warranty of        |
   |     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         |
   |     GNU General Public License for more details.                          |
   |                                                                           |
   |     You should have received a copy of the GNU General Public License     |
   |     along with MRPT.  If not, see <http://www.gnu.org/licenses/>.         |
   |                                                                           |
   +---------------------------------------------------------------------------+ */
#ifndef  MRPT_WX_UTILS_H
#define  MRPT_WX_UTILS_H

#include <mrpt/utils/utils_defs.h>
#include <mrpt/config.h>
#include <mrpt/synch.h>

#include <map>
#include <queue>

#if MRPT_HAS_WXWIDGETS

#include <wx/sizer.h>
#include <wx/statbmp.h>
#include <wx/menu.h>
#include <wx/toolbar.h>
#include <wx/frame.h>
#include <wx/timer.h>
#include <wx/statusbr.h>
#include <wx/msgdlg.h>
#include <wx/artprov.h>
#include <wx/bitmap.h>
#include <wx/intl.h>
#include <wx/image.h>
#include <wx/string.h>
#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/progdlg.h>
#include <wx/imaglist.h>
#include <wx/busyinfo.h>
#include <wx/log.h>
#include <wx/textdlg.h>
#include <wx/dirdlg.h>
#include <wx/colordlg.h>
#include <wx/dcmemory.h>
#include <wx/app.h>
#include <wx/pen.h>

#endif

namespace mrpt
{
	namespace utils { class CMRPTImage; }

	namespace gui
	{
#if MRPT_HAS_WXWIDGETS

		/** Create a wxImage from a MRPT image. The new object must be freed by the user when not required anymore.
		  * \sa MRPTImage2wxImage
		  */
		wxImage MRPTDLLIMPEXP * MRPTImage2wxImage( const mrpt::utils::CMRPTImage &img );

#if MRPT_HAS_OPENCV
		/** Create a wxImage from a IPL image. The new object must be freed by the user when not required anymore.
		  * \sa IplImage2wxImage
		  */
		wxImage MRPTDLLIMPEXP * IplImage2wxImage( void* img );
#endif

		/** Create a MRPT image from a wxImage. The new object must be freed by the user when not required anymore.
		  * \sa wxImage2MRPTImage
		  */
		mrpt::utils::CMRPTImage MRPTDLLIMPEXP * wxImage2MRPTImage( const wxImage &img );
#endif

    } // End of namespace
} // End of namespace

#endif
